package com.example.calcutator.Calculator1;

import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;

import com.example.calcutator.R;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.snackbar.Snackbar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.os.Environment;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Random;

public class Calculator_1_2 extends AppCompatActivity {
    Button button;
    LinearLayout container;
    private EditText earnings;
    private EditText rpm;
    private EditText destiny;
    private EditText runtime;
    private EditText efficiency;
    private EditText width_count;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_calculator_1_2);
        earnings = findViewById(R.id.day_earnings);
        rpm = findViewById(R.id.day_rpm);
        destiny = findViewById(R.id.day_destiny);
        runtime = findViewById(R.id.day_runtime);
        efficiency = findViewById(R.id.day_efficiency);
        width_count = findViewById(R.id.day_width_count);

        earnings.requestFocus();

        button = (Button) findViewById(R.id.capturesone);

        container = (LinearLayout) findViewById(R.id.captures2);



        button.setOnClickListener(new View.OnClickListener() {



            @Override

            public void onClick(View v) {

                // TODO Auto-generated method stub



                String folder = "TexCalculator"; // 폴더 이름



                try {

                    File sdCardPath = Environment.getExternalStorageDirectory();

                    File dirs = new File(Environment.getExternalStorageDirectory(), folder);



                    if (!dirs.exists()) { // 원하는 경로에 폴더가 있는지 확인

                        dirs.mkdirs(); // Test 폴더 생성

                        Log.d("CAMERA_TEST", "Directory Created");

                    }

                    container.buildDrawingCache();

                    Bitmap captureView = container.getDrawingCache();

                    FileOutputStream fos;

                    String save;



                    try {
                        Random random = new Random();
                        String s = "TexCalculator_" + String.valueOf( random.nextInt(99999)) + ".png";
                        save = sdCardPath.getPath() + "/" + folder + "/" + s;

                        // 저장 경로

                        fos = new FileOutputStream(save);

                        captureView.compress(Bitmap.CompressFormat.PNG, 100, fos); // 캡쳐



                        // 미디어 스캐너를 통해 모든 미디어 리스트를 갱신시킨다.

                        sendBroadcast(new Intent(Intent.ACTION_MEDIA_MOUNTED,

                                Uri.parse("file://" + Environment.getExternalStorageDirectory())));

                    } catch (FileNotFoundException e) {

                        e.printStackTrace();

                    }


                } catch (Exception e) {

                    // TODO: handle exception

                    Log.e("Screen", "" + e.toString());

                }

            }

        });

    }

    public void day_calculation(View v){

        TextView beamweight = findViewById(R.id.day_output);
        TextView totalweight = findViewById(R.id.day_pay);

        try {
            double day_earnings = Float.parseFloat(earnings.getText().toString());
            double day_rpm = Float.parseFloat(rpm.getText().toString());
            double day_destiny = Float.parseFloat(destiny.getText().toString());
            double day_runtime = Float.parseFloat(runtime.getText().toString());
            double day_efficiency = Float.parseFloat(efficiency.getText().toString());
            double day_width_count = Float.parseFloat(width_count.getText().toString());


            double calcul1 = day_rpm * 60 / day_destiny / 91.44 * day_runtime * (day_efficiency / 100) * day_width_count;
            double calcul2 = day_earnings / calcul1;
            double calculround1 = Math.round(calcul1);
            double calculround2 = Math.round(calcul2);

        beamweight.setText(calculround1+"yds");
        totalweight.setText(calculround2+"원");
        }catch (NumberFormatException e){
            Toast.makeText(this.getApplicationContext(),"값을 제대로 입력해 주세요", Toast.LENGTH_LONG).show();
        }catch (NullPointerException e){

        }
    }

}
