package com.example.calcutator.CalculatorMenu;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Intent;
import android.os.Bundle;

import android.util.Log;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ProgressBar;

import com.example.calcutator.MyAPI;
import com.example.calcutator.PostItem;
import com.example.calcutator.R;

import java.util.List;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;


public class Calculator_Login extends AppCompatActivity {
    private final  String TAG = getClass().getSimpleName();
    private final String BASE_URL = "http://211.238.177.146:9999";
    private MyAPI mMyAPI;
    private EditText usernameEditText;
    private EditText passwordEditText;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_calculator__login);
        usernameEditText = findViewById(R.id.username);
        passwordEditText = findViewById(R.id.password);
        final Button loginButton = findViewById(R.id.loginBtn);
        loginButton.setImeOptions(EditorInfo.IME_ACTION_DONE);
        final ProgressBar loadingProgressBar = findViewById(R.id.loading);
        initMyAPI(BASE_URL);
        loginButton.setImeOptions(EditorInfo.IME_ACTION_DONE);

    }
    private void initMyAPI(String baseUrl){

        Log.d(TAG,"initMyAPI : " + baseUrl);
        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(baseUrl)
                .addConverterFactory(GsonConverterFactory.create())
                .build();

        mMyAPI = retrofit.create(MyAPI.class);
    }

    public void Login_Click(View v) {
        System.out.println("-----------------------------------------------------------");
        Log.d(TAG,"GET");
        final String name = usernameEditText.getText().toString();
        final String password = passwordEditText.getText().toString();
        Call<List<PostItem>> getCall = mMyAPI.get_posts();
        

        getCall.enqueue(new Callback<List<PostItem>>() {
            @Override
            public void onResponse(Call<List<PostItem>> call, Response<List<PostItem>> response) {
                if( response.isSuccessful()){
                    List<PostItem> mList = response.body();
                    String result ="";
                    for( PostItem item : mList){
                        if(item.getName().equals(name)){
                            if (item.getPassword().equals(password)){
                                System.out.println("접속되었습니다");
                                Intent intent = new Intent(Calculator_Login.this, MainMenu.class);
                                startActivity(intent);
                            }
                        }else{

                        }
                    }
                    PostItem item = new PostItem();
                }else {
                    Log.d(TAG,"Status Code : " + response.code());
                }
            }

            @Override
            public void onFailure(Call<List<PostItem>> call, Throwable t) {
                Log.d(TAG,"Fail msg : " + t.getMessage());
            }
        });
    }
}
