package com.example.calcutator.CalculatorMenu;

import android.content.Intent;
import android.os.Bundle;

import com.example.calcutator.R;

import androidx.appcompat.app.AppCompatActivity;

import android.util.Log;
import android.view.View;

public class MainMenu extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main_menu);

        int uiOptions = getWindow().getDecorView().getSystemUiVisibility();
        int newUiOptions = uiOptions;
        boolean isImmersiveModeEnabled = ((uiOptions | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY) == uiOptions);
        if (isImmersiveModeEnabled) {
            Log.i("Is on?", "Turning immersive mode mode off. ");
        } else {
            Log.i("Is on?", "Turning immersive mode mode on.");
        }
        // 몰입 모드를 꼭 적용해야 한다면 아래의 3가지 속성을 모두 적용시켜야 합니다
        newUiOptions ^= View.SYSTEM_UI_FLAG_HIDE_NAVIGATION;
        newUiOptions ^= View.SYSTEM_UI_FLAG_FULLSCREEN;
        newUiOptions ^= View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY;
        getWindow().getDecorView().setSystemUiVisibility(newUiOptions);


    }
    public void nextClick1(View v){
        Intent intent = new Intent(MainMenu.this, CalculationMenu.class);
        startActivity(intent);
    }
    public void nextClick2(View v){
        Intent intent = new Intent(MainMenu.this, CalculationMenuTwo.class);
        startActivity(intent);
    }
    public void nextClick3(View v){
        Intent intent = new Intent(MainMenu.this, CalculationMenuThree.class);
        startActivity(intent);
    }


}
