//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "OldProductData.h"
#include "MainImage.h"
//---------------------------------------------------------------------------
#define IDS_CODE      StringTable[0]
#define IDS_YARN      StringTable[1]
#define IDS_TOTAL     StringTable[2]
#define IDS_DENSITY   StringTable[3]
#define IDS_WARP      StringTable[4]
#define IDS_WEFT      StringTable[5]
#define IDS_SOURCE    StringTable[6]
#define IDS_DEN       StringTable[7]
#define IDS_WID       StringTable[8]
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TProductDataForm *ProductDataForm;
//---------------------------------------------------------------------------
__fastcall TProductDataForm::TProductDataForm(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TProductDataForm::FormCreate(TObject *Sender)
{
//======================================================================
  StringTable.Create(DirectoryItem, Language, "ProductData");
  SetSmallFont(Font);
  btSource->Caption                  = IDS_SOURCE;
  btOK->Caption                      = IDS_COMMON_BUTTONOK;
  btCancel->Caption                  = IDS_COMMON_BUTTONCANCEL;
//======================================================================
  WriteText();
  ProductData[0] = new TList;
  ProductData[1] = new TList;
  if (MainImageForm->Plan->Finish) {
     MainImageForm->Plan->GetProductDataA(0, TotalCnt[0], TotalLength[0]);
     MainImageForm->Plan->GetProductDataA(1, TotalCnt[1], TotalLength[1]);
     WarpDensity = TotalCnt[0]/TotalLength[0];
     WeftDensity = TotalCnt[1]/TotalLength[1];
     edWeft->Text = IntToStr(int(WeftDensity+0.5));
     ReadProductData();
     InitStringGrid();
  }
}
//---------------------------------------------------------------------------
void __fastcall TProductDataForm::WriteText()
{
  TStringGrid *grid;
  int k, cnt;
  int Row, Col, i, x;
  TYarnArray *pd;
  AnsiString str;
  for (k = 0; k < 2; k++) {
     if (k == 0) grid = sgWarp;
     else grid = sgWeft;
     for (Row = 0; Row < grid->RowCount; Row++) {
        if (Row == 0) {
           for (Col = 0; Col < grid->ColCount; Col++) {
              switch (Col) {
                 case 0: str = "";              break;
                 case 1: str = "Code";          break;
                 case 2: str = "Length";        break;
                 case 3: str = "Yarns";         break;
                 case 4: str = "Weight";        break;
              }
              grid->Cells[Col][Row] = str;
           }
        } else {
           grid->Cells[0][Row] = AnsiString(char(64+Row));   //65--->A, 66---->B,...
        }
     }
  }

  for (k = 0; k < 2; k++){
     if (k == 0) grid = sgWarpArray;
     else grid = sgWeftArray;
     for (Row=0; Row<grid->RowCount; Row++) {
       for (Col=0; Col<grid->ColCount; Col++) {
         if (Row == 0) {
     	    switch (Col)  {
            	case 0: str = "No";                   break;
           	case 1: str = IDS_CODE;               break;
            	case 2: str = IDS_COMMON_METHOD;      break;
             case 3: str = IDS_COMMON_LENGTH;      break;
             case 4: str = IDS_YARN;               break;
             case 5: str = IDS_DENSITY;            break;
             case 6: str = IDS_COMMON_REPEAT;      break;
           }
           grid->Cells[Col][Row] = str;
         } else {
           if (Col == 0) {
            	str = Row;
             grid->Cells[Col][Row] = str;
           }
         }
       }
     }
  }

}
//---------------------------------------------------------------------------
void __fastcall TProductDataForm::ReadProductData()
{
  int cnt, i, j;
	TYarnArray *pd, *ya;

  if (MainImageForm->Plan->Yarn->PData[0]->Count
       && MainImageForm->Plan->Yarn->PData[1]->Count) {
    for (i=0; i<2; i++) {
      for (j=0; j<MainImageForm->Plan->Yarn->PData[i]->Count; j++) {
        ya = (TYarnArray *)MainImageForm->Plan->Yarn->PData[i]->Items[j];
        pd = new TYarnArray;
        pd->code    = ya->code;
        pd->method  = ya->method;
        pd->length  = ya->length;
        pd->yarns   = ya->yarns;
        pd->density = ya->density;
        pd->repeat  = ya->repeat;
        ProductData[i]->Add(pd);
      }
    }
  } else {
    for (i=0; i<2; i++) {
      for (j=0; j<MainImageForm->Plan->Yarn->Array[i]->Count; j++) {
        ya = (TYarnArray *)MainImageForm->Plan->Yarn->Array[i]->Items[j];
        pd = new TYarnArray;
        pd->code    = ya->code;
        pd->method  = ya->method;
        pd->length  = ya->length;
        pd->yarns   = ya->yarns;
        pd->density = ya->density;
        pd->repeat  = ya->repeat;
        ProductData[i]->Add(pd);
      }
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TProductDataForm::InitStringGrid()
{
  TStringGrid *grid;
  int k, cnt;
  int Row, Col, i, x;
  TYarnArray *pd;
  AnsiString str;
  for (k = 0; k < 2; k++) {
     if (k == 0) grid = sgWarp;
     else grid = sgWeft;
     for (Row = 0; Row < MainImageForm->Plan->SimpleProductArray[k]->Count; Row++) {
        grid->Cells[1][Row+1] = IntToStr(((SimpleProductInfo *)MainImageForm->Plan->SimpleProductArray[k]->Items[Row])->Code);
        grid->Cells[2][Row+1] = Format("%.2f", OPENARRAY(TVarRec,
                                (((SimpleProductInfo *)MainImageForm->Plan->SimpleProductArray[k]->Items[Row])->Length)));
        grid->Cells[3][Row+1] = IntToStr(((SimpleProductInfo *)MainImageForm->Plan->SimpleProductArray[k]->Items[Row])->Yarns);
        grid->Cells[4][Row+1] = "0.0000";        
     }
  }

  for (k = 0; k < 2; k++){
     if (k == 0) grid = sgWarpArray;
     else grid = sgWeftArray;
     for (Row=0; Row<grid->RowCount; Row++) {
       for (Col=0; Col<grid->ColCount; Col++) {
         if (Row == 0) {
     	    switch (Col)  {
            	case 0: str = "No";                   break;
           	case 1: str = IDS_CODE;               break;
            	case 2: str = IDS_COMMON_METHOD;      break;
             case 3: str = IDS_COMMON_LENGTH;      break;
             case 4: str = IDS_YARN;               break;
             case 5: str = IDS_DENSITY;            break;
             case 6: str = IDS_COMMON_REPEAT;      break;
           }
           grid->Cells[Col][Row] = str;
         } else {
           if (Col == 0) {
            	str = Row;
             grid->Cells[Col][Row] = str;
           }
         }
       }
     }
     cnt = ProductData[k]->Count;
     for (i=0; i<cnt; i++) {
       pd = (TYarnArray *)ProductData[k]->Items[i];
       if (pd->code == 0) return;
       grid->Cells[1][i+1] = (int)pd->code;
       if (pd->method      == 0) str = "Normal";
       else if (pd->method == 1) str = "Reverse";
       else                      str = "Center";
       grid->Cells[2][i+1] = str;
       grid->Cells[3][i+1] = Format("%.2f", OPENARRAY(TVarRec,(pd->length)));
       grid->Cells[4][i+1] = pd->yarns;
       grid->Cells[5][i+1] = Format("%.2f", OPENARRAY(TVarRec,(pd->density)));
       grid->Cells[6][i+1] = pd->repeat;
     }
  }
}
//----------------------------------------------------------------------------

void __fastcall TProductDataForm::FormDestroy(TObject *Sender)
{
  TYarnArray *ya;
  for (int i = 0; i < 2; i++){
     while (ProductData[i]->Count) {
        ya = (TYarnArray *)ProductData[i]->Last();
        ProductData[i]->Remove(ya);
        delete ya;
     }
     delete ProductData[i];
  }
}
//---------------------------------------------------------------------------

void __fastcall TProductDataForm::sgWarpDrawCell(TObject *Sender, int ACol,
      int ARow, TRect &Rect, TGridDrawState State)
{
  SetTextAlign(sgWarp->Canvas->Handle, TA_CENTER);
  if (ARow == 0 || ACol == 0) sgWarp->Canvas->Font->Color = clBlue;
  sgWarp->Canvas->TextRect(Rect, Rect.Left+(Rect.Right-Rect.Left)/2,
           Rect.Top+3, sgWarp->Cells[ACol][ARow]);

}
//---------------------------------------------------------------------------

void __fastcall TProductDataForm::sgWeftDrawCell(TObject *Sender, int ACol,
      int ARow, TRect &Rect, TGridDrawState State)
{
  SetTextAlign(sgWeft->Canvas->Handle, TA_CENTER);
  if (ARow == 0 || ACol == 0) sgWeft->Canvas->Font->Color = clBlue;
  sgWeft->Canvas->TextRect(Rect, Rect.Left+(Rect.Right-Rect.Left)/2,
           Rect.Top+3, sgWeft->Cells[ACol][ARow]);

}
//---------------------------------------------------------------------------

void __fastcall TProductDataForm::sgWarpArrayDrawCell(TObject *Sender,
      int ACol, int ARow, TRect &Rect, TGridDrawState State)
{
  SetTextAlign(sgWarpArray->Canvas->Handle, TA_CENTER);
  if (ARow == 0 || ACol == 0) sgWarpArray->Canvas->Font->Color = clBlue;
  sgWarpArray->Canvas->TextRect(Rect, Rect.Left+(Rect.Right-Rect.Left)/2,
           Rect.Top+3, sgWarpArray->Cells[ACol][ARow]);

}
//---------------------------------------------------------------------------

void __fastcall TProductDataForm::sgWeftArrayDrawCell(TObject *Sender,
      int ACol, int ARow, TRect &Rect, TGridDrawState State)
{
  SetTextAlign(sgWeftArray->Canvas->Handle, TA_CENTER);
  if (ARow == 0 || ACol == 0) sgWeftArray->Canvas->Font->Color = clBlue;
  sgWeftArray->Canvas->TextRect(Rect, Rect.Left+(Rect.Right-Rect.Left)/2,
           Rect.Top+3, sgWeftArray->Cells[ACol][ARow]);
}
//---------------------------------------------------------------------------

void __fastcall TProductDataForm::edWidthKeyDown(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
  if (Key == VK_RETURN) Calculate();
}
//---------------------------------------------------------------------------
void __fastcall TProductDataForm::Calculate()
{
  int i;
  double Weight, TotalWeight;
  short Count;
  SimpleProductInfo *pi;
  TYarnUnit *yu;
  int ActingReedWidth = StrToInt(edWidth->Text);
  for (i = 0; i < MainImageForm->Plan->SimpleProductArray[0]->Count; i++){
     pi = (SimpleProductInfo *)MainImageForm->Plan->SimpleProductArray[0]->Items[i];
     Count = MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Infor.Detail.Count;
     if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.Method == YU_DIRECT){
       if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 0)
          Weight = ActingReedWidth*(pi->Yarns/pi->Length)*pi->Yarns/TotalCnt[0]*Count/(1093.6*1000);
       else if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 1)
          Weight = ActingReedWidth*(pi->Yarns/pi->Length)*pi->Yarns/TotalCnt[0]*Count/(9842.4*1000);
     } else {
       if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 0)
          Weight = ActingReedWidth*(pi->Yarns/pi->Length)*pi->Yarns/(TotalCnt[0]*Count)*(0.5399/1000);
       else if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 1)
          Weight = ActingReedWidth*(pi->Yarns/pi->Length)*pi->Yarns/(TotalCnt[0]*Count)*(0.8100/1000);
       else if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 2)
          Weight = ActingReedWidth*(pi->Yarns/pi->Length)*pi->Yarns/(TotalCnt[0]*Count)*(1.7718/1000);
       else if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 3)
          Weight = ActingReedWidth*(pi->Yarns/pi->Length)*pi->Yarns/(TotalCnt[0]*Count)*(1.5120/1000);
     }
     TotalWeight += Weight;
     sgWarp->Cells[4][i+1] = Format("%.4f", OPENARRAY (TVarRec,(Weight)));
  }
  for (i = 0; i < MainImageForm->Plan->SimpleProductArray[1]->Count; i++){
     pi = (SimpleProductInfo *)MainImageForm->Plan->SimpleProductArray[1]->Items[i];
     Count = MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Infor.Detail.Count;
     if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.Method == YU_DIRECT){
       if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 0)
          Weight = ActingReedWidth*WeftDensity*pi->Yarns*0.9144/TotalCnt[1]*Count/(1093.6*1000);
       else if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 1)
          Weight = ActingReedWidth*WeftDensity*pi->Yarns*0.9144/TotalCnt[1]*Count/(9842.4*1000);
     } else {
       if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 0)
          Weight = ActingReedWidth*WeftDensity*pi->Yarns*0.9144/(TotalCnt[1]*Count)*(0.5399/1000);
       else if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 1)
          Weight = ActingReedWidth*WeftDensity*pi->Yarns*0.9144/(TotalCnt[1]*Count)*(0.8100/1000);
       else if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 2)
          Weight = ActingReedWidth*WeftDensity*pi->Yarns*0.9144/(TotalCnt[1]*Count)*(1.7718/1000);
       else if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 3)
          Weight = ActingReedWidth*WeftDensity*pi->Yarns*0.9144/(TotalCnt[1]*Count)*(1.5120/1000);
     }
     TotalWeight += Weight;
     sgWeft->Cells[4][i+1] = Format("%.4f", OPENARRAY (TVarRec,(Weight)));
  }
  sgWarp->Repaint();
  sgWeft->Repaint();
}
//----------------------------------------------------------------------------

void __fastcall TProductDataForm::btOKClick(TObject *Sender)
{
  int i, j, total;
  TYarnArray *pd, *td;
  SimpleProductInfo *pi;
  TStringGrid *grid;
  double width, density;

  for (i=1; i>=0; i--) {
    while(MainImageForm->Plan->Yarn->PData[i]->Count) {
      td = (TYarnArray *)MainImageForm->Plan->Yarn->PData[i]->Last();
      MainImageForm->Plan->Yarn->PData[i]->Remove(td);
      delete td;
    }
  }

  for (i=0; i<2; i++) {
    for (j=0; j<ProductData[i]->Count; j++) {
      td = (TYarnArray *)ProductData[i]->Items[j];
      pd = new TYarnArray ;
      pd->code    = td->code;
      pd->method  = td->method;
      pd->length  = td->length;
      pd->yarns   = td->yarns;
      pd->density = td->density;
      pd->repeat  = td->repeat;
      MainImageForm->Plan->Yarn->PData[i]->Add(pd);
    }
    if (i == 0) grid = sgWarp; else grid = sgWeft;
    for (j = 0; j < MainImageForm->Plan->SimpleProductArray[i]->Count; j++){
       pi = (SimpleProductInfo *)MainImageForm->Plan->SimpleProductArray[i]->Items[j];
       pi->Weight = StrToFloat(grid->Cells[4][j+1]);
    }
  }
  width = StrToFloat(edWidth->Text);
  arWidth = Format("%.2f", OPENARRAY(TVarRec, (width)));
  density = StrToFloat(edWeft->Text);
  weDensity = Format("%.2f", OPENARRAY(TVarRec, (density)));
  if (TotalLength[0] != 0) total = width*TotalCnt[0]/TotalLength[0]+0.5;
  else total = 0;
  TotalWarpCnt = IntToStr(total);
}
//---------------------------------------------------------------------------

