#include <vcl.h>
#include <math.h>
#pragma hdrstop

#include "Plan.h"
#include "Exception.h"
#include "StatusProgress.h"
#include "MainImage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
#define PATTERN 8
//----------------------------------------------------------------------------
static struct {
  char sht[5][3][3];
  char nml[5][5][5];
  char lng[5][7][7];
} Hair[3] = {
  {
    {
      { { 1, 0, 0 }, { 0, 1, 0 }, { 0, 0, 1 } },
      { { 1, 1, 0 }, { 0, 0, 1 }, { 0, 1, 0 } },
      { { 0, 0, 1 }, { 0, 0, 1 }, { 1, 1, 0 } },
      { { 0, 0, 1 }, { 0, 1, 0 }, { 1, 0, 0 } },
      { { 1, 0, 0 }, { 1, 0, 1 }, { 0, 1, 0 } }
    }, {
      {
        { 1, 0, 0, 0, 0 }, { 0, 1, 0, 0, 0 }, { 0, 1, 0, 0, 0 },
        { 0, 0, 1, 1, 0 }, { 0, 0, 0, 0, 1 }
      }, {
        { 1, 1, 1, 0, 0 }, { 0, 0, 0, 1, 0 }, { 0, 0, 1, 0, 0 },
        { 0, 0, 1, 0, 0 }, { 0, 1, 0, 0, 0 }
      }, {
        { 0, 0, 0, 0, 1 }, { 0, 0, 0, 0, 1 }, { 0, 1, 1, 1, 0 },
        { 0, 1, 0, 0, 0 }, { 1, 1, 0, 0, 0 }

      }, {
        { 0, 0, 1, 1, 0 }, { 1, 1, 0, 0, 1 }, { 0, 0, 0, 0, 1 },
        { 0, 0, 0, 1, 0 }, { 0, 0, 0, 1, 0 }
      }, {
        { 1, 1, 1, 0, 0 }, { 0, 0, 0, 1, 0 }, { 0, 0, 0, 0, 1 },
        { 0, 0, 0, 0, 1 }, { 0, 0, 0, 1, 0 }
      }
    }, {
      {
        { 1, 0, 0, 0, 0, 0, 0 }, { 0, 1, 0, 0, 0, 0, 0 },
        { 0, 1, 0, 0, 0, 0, 0 }, { 0, 1, 0, 0, 0, 0, 0 },
        { 0, 0, 1, 1, 0, 0, 0 }, { 0, 0, 0, 1, 0, 0, 1 },
        { 0, 0, 0, 0, 1, 1, 0 }
      }, {
        { 1, 1, 1, 0, 0, 0, 0 }, { 0, 0, 0, 1, 0, 0, 0 },
        { 0, 0, 1, 0, 0, 0, 0 }, { 0, 1, 0, 0, 0, 0, 0 },
        { 0, 0, 1, 0, 0, 0, 1 }, { 0, 0, 1, 0, 0, 1, 0 },
        { 0, 0, 0, 1, 1, 0, 0 }
      }, {
        { 0, 0, 0, 0, 1, 1, 0 }, { 0, 0, 0, 0, 1, 0, 1 },
        { 0, 1, 1, 1, 0, 0, 0 }, { 0, 1, 0, 0, 0, 0, 0 },
        { 0, 1, 0, 0, 0, 0, 0 }, { 0, 0, 1, 0, 0, 0, 0 },
        { 1, 1, 0, 0, 0, 0, 0 }
      }, {
        { 0, 0, 1, 1, 0, 0, 0 }, { 1, 1, 0, 0, 1, 0, 0 },
        { 0, 0, 0, 0, 1, 0, 0 }, { 0, 0, 1, 1, 0, 0, 0 },
        { 0, 1, 0, 0, 0, 0, 0 }, { 0, 0, 1, 0, 0, 0, 0 },
        { 0, 0, 1, 1, 1, 0, 0 }
      }, {
        { 1, 0, 0, 0, 0, 0, 0 }, { 1, 0, 0, 0, 0, 0, 0 },
        { 0, 1, 1, 0, 0, 0, 0 }, { 0, 0, 1, 0, 0, 0, 0 },
        { 0, 0, 0, 1, 1, 1, 0 }, { 0, 0, 0, 0, 0, 1, 0 },
        { 0, 0, 0, 0, 0, 0, 1 }
      }
    }
  },
//------------------------  data
  {
    {
      { { 1, 0, 0 }, { 1, 1, 0 }, { 0, 0, 1 } },
      { { 1, 0, 0 }, { 0, 1, 1 }, { 0, 0, 1 } },
      { { 0, 0, 1 }, { 0, 1, 0 }, { 1, 1, 1 } },
      { { 0, 0, 1 }, { 1, 1, 1 }, { 1, 0, 0 } },
      { { 1, 1, 1 }, { 0, 1, 0 }, { 0, 0, 1 } }
    }, {
      {
        { 1, 0, 0, 0, 0 }, { 0, 1, 0, 0, 0 }, { 0, 0, 1, 1, 0 },
        { 0, 0, 0, 1, 0 }, { 0, 0, 0, 1, 1 }
      }, {
        { 1, 1, 1, 0, 0 }, { 0, 0, 1, 1, 0 }, { 0, 0, 1, 0, 0 },
        { 0, 0, 0, 0, 1 }, { 0, 0, 0, 1, 1 }
      }, {
        { 1, 1, 1, 0, 0 }, { 0, 0, 1, 1, 1 }, { 0, 0, 0, 1, 1 },
        { 0, 0, 0, 1, 1 }, { 0, 0, 0, 0, 1 }
      }, {
        { 1, 0, 0, 0, 0 }, { 1, 1, 1, 0, 0 }, { 0, 0, 1, 1, 1 },
        { 0, 0, 0, 0, 0 }, { 0, 0, 0, 0, 0 }
      }, {
        { 1, 1, 1, 0, 0 }, { 0, 0, 0, 1, 1 }, { 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0 }, { 0, 0, 0, 0, 0 }
      }
    }, {
      {
        { 1, 0, 0, 0, 0, 0, 0 }, { 0, 1, 1, 1, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0 }, { 0, 0, 0, 0, 1, 1, 1 },
        { 0, 0, 0, 0, 0, 0, 0 }, { 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0 }
      }, {
        { 1, 1, 1, 0, 0, 0, 0 }, { 0, 0, 0, 1, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 1, 0 }, { 0, 0, 0, 0, 0, 0, 1 },
        { 0, 0, 1, 0, 0, 0, 0 }, { 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0 }
      }, {
        { 1, 0, 0, 0, 0, 0, 0 }, { 0, 1, 1, 1, 1, 0, 0 },
        { 0, 0, 0, 0, 0, 1, 0 }, { 0, 1, 0, 0, 0, 1, 1 },
        { 0, 0, 0, 0, 0, 0, 0 }, { 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0 }
      }, {
        { 1, 1, 1, 1, 0, 0, 0 }, { 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 1, 0 }, { 0, 0, 0, 0, 0, 0, 0 },
        { 0, 1, 0, 0, 0, 0, 1 }, { 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0 }
      }, {
        { 1, 0, 0, 0, 0, 0, 0 }, { 0, 1, 1, 0, 0, 0, 0 },
        { 0, 0, 1, 1, 1, 1, 0 }, { 0, 0, 0, 0, 0, 1, 1 },
        { 0, 0, 0, 0, 0, 0, 1 }, { 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0 }
      }
    }
  },
//-------------------------  data
  {
    {
      { { 1, 0, 0 }, { 0, 1, 0 }, { 1, 0, 0 } },
      { { 0, 1, 0 }, { 0, 0, 1 }, { 0, 0, 1 } },
      { { 0, 0, 1 }, { 0, 0, 1 }, { 1, 1, 0 } },
      { { 0, 0, 1 }, { 0, 1, 0 }, { 0, 1, 0 } },
      { { 1, 0, 0 }, { 1, 0, 0 }, { 0, 1, 0 } }
    }, {
      {
        { 1, 0, 0, 0, 0 }, { 0, 1, 0, 0, 0 }, { 0, 1, 0, 0, 0 },
        { 0, 1, 0, 0, 0 }, { 1, 0, 0, 0, 0 }
      }, {
        { 0, 1, 0, 0, 0 }, { 0, 0, 1, 0, 0 }, { 0, 1, 0, 0, 0 },
        { 0, 0, 1, 0, 0 }, { 0, 0, 1, 0, 0 }
      }, {
        { 0, 0, 0, 0, 1 }, { 0, 0, 0, 0, 1 }, { 0, 1, 1, 1, 0 },
        { 0, 1, 0, 0, 0 }, { 1, 1, 0, 0, 0 }
      }, {
        { 0, 0, 0, 1, 0 }, { 0, 1, 0, 0, 0 }, { 0, 1, 1, 0, 0 },
        { 0, 0, 1, 0, 0 }, { 0, 1, 0, 0, 0 }
      }, {
        { 1, 0, 0, 0, 0 }, { 0, 1, 0, 1, 0 }, { 0, 1, 0, 0, 0 },
        { 1, 0, 0, 0, 0 }, { 1, 1, 0, 0, 0 }
      }
    }, {
      {
        { 0, 0, 0, 0, 1, 0, 0 }, { 0, 0, 0, 1, 1, 0, 0 },
        { 0, 0, 0, 0, 0, 1, 0 }, { 0, 0, 0, 0, 1, 0, 0 },
        { 0, 0, 0, 1, 1, 0, 0 }, { 0, 0, 0, 0, 1, 0, 0 },
        { 0, 0, 0, 0, 1, 1, 0 }
      }, {
        { 0, 1, 1, 0, 0, 0, 0 }, { 0, 1, 0, 0, 0, 0, 0 },
        { 0, 0, 1, 0, 0, 0, 0 }, { 0, 1, 0, 0, 0, 0, 0 },
        { 0, 1, 0, 0, 0, 0, 0 }, { 0, 1, 1, 0, 0, 0, 0 },
        { 0, 0, 1, 0, 0, 0, 0 }
      }, {
        { 0, 0, 0, 0, 1, 1, 0 }, { 0, 0, 0, 0, 0, 0, 1 },
        { 0, 0, 0, 0, 0, 0, 1 }, { 0, 0, 0, 0, 0, 1, 0 },
        { 0, 0, 0, 0, 0, 1, 0 }, { 0, 0, 0, 0, 0, 1, 1 },
        { 0, 0, 0, 0, 1, 1, 0 }
      }, {
        { 0, 0, 1, 1, 0, 0, 0 }, { 0, 0, 0, 1, 0, 0, 0 },
        { 0, 0, 1, 1, 0, 0, 0 }, { 0, 0, 1, 0, 0, 0, 0 },
        { 0, 0, 1, 0, 0, 0, 0 }, { 0, 0, 1, 0, 0, 0, 0 },
        { 0, 0, 0, 1, 1, 0, 0 }
      }, {
        { 1, 0, 0, 0, 0, 0, 0 }, { 1, 0, 0, 0, 0, 0, 0 },
        { 0, 1, 1, 0, 0, 0, 0 }, { 0, 0, 1, 0, 0, 0, 0 },
        { 0, 1, 0, 0, 0, 0, 0 }, { 0, 1, 0, 0, 0, 0, 0 },
        { 0, 0, 1, 0, 0, 0, 0 }
      }
    }
  }
};
//---------------------------------------------------------------------------
// TKnapsack
//---------------------------------------------------------------------------
int __fastcall TKnapsack::Recursion(int t, int i)
{
  if (t==min) return 1;
  else if (t<min || i==dn) return 0;
  else if (Recursion(t-data[i], i+1)) {
    result[rn++] = i; return 1;
  } else return Recursion(t, i+1);
}
//---------------------------------------------------------------------------
void __fastcall TKnapsack::Process(int t)
{
  min = 0;
  while (abs(min)<t) {
    Recursion(t, 0);
    if (rn) break;
    min = -min;
    if (min<=0) min--;
  }
}
//---------------------------------------------------------------------------
__fastcall TPlan::TPlan()
{
  Yarn = new TYarnArrange;
  Texture = new TTextureArrange;

	WeaveCondition.HairEffect = HENone;
  WeaveCondition.HairRatio = 0;
  WeaveCondition.WovenEffect = WESolid;
  WeaveCondition.BackSide = 0;
  WeaveCondition.HairType = 0;
  WeaveCondition.ColorCorrection = false;
//  WeaveCondition.TextureCorrection = false;
  WeaveCondition.Tension = 20;
  PatternDPI = 160;
  bOld = false;                  // 7.3   ȣȯ 
  bTextureCorrection = false;    //

  xwp = ywt = NULL;
  bmFront = bmBack = NULL;
  bmHighFront = bmHighBack = NULL;
  PatternBitmap = HighPatternBitmap = NULL;
  BackPatternBitmap = HighBackPatternBitmap = NULL;
  WarpBitmap = WeftBitmap = NULL;
  Length[WARP] = Length[WEFT] = NULL;
  ExactLength[WARP] = ExactLength[WEFT] = NULL;
  ptLength[WARP] = ptLength[WEFT] = NULL;
  bmLength[WARP] = bmLength[WEFT] = NULL;
  sLength[WARP] = sLength[WEFT] = NULL;
  bSucker = NULL;
  SuckerData.SuckerBitmap = NULL;
  SuckerData.tagBitmap = NULL;
  CopyBitmap = NULL;
  dummyCnt = 0;
  for (int i=0; i<5; i++){
     PatternDummy[i] = BackPatternDummy[i] = NULL;
     bmDummy[i] = bmDummyBack[i] = NULL;
  }
  for (int j=0; j<8; j++){
     HighYarnMap[j] = NULL;
  }
  for (int i = 0; i < 2; i++) {
     ProductArray[i] = new TList;
     SimpleProductArray[i] = new TList;
     OrderArray[i] = new TList;
  }
  ProductStringData.WarpingFront = NULL;
  ProductStringData.WarpingBack = NULL;
  ProductStringData.Warping = NULL;
  ProductStringData.TotalWarpCount = NULL;
  ProductStringData.Reed = NULL;
  ProductStringData.InsertingNo = NULL;
  ProductStringData.ActingReedWidth = NULL;
  ProductStringData.WeftDensity = NULL;
  ProductStringData.Weight = NULL;
  ProductStringData.Ji = new TStringList;
  ProductStringData.Attention = new TStringList;
}
//---------------------------------------------------------------------------
__fastcall TPlan::~TPlan()
{
  if (Yarn) delete Yarn;
  if (Texture) delete Texture;
	if (xwp) delete[] xwp;
	if (ywt) delete[] ywt;
  if (bmFront) delete bmFront;
  if (bmBack) delete bmBack;
  if (bmHighFront) delete bmHighFront;
  if (bmHighBack) delete bmHighBack;
  if (PatternBitmap) delete PatternBitmap;
  if (HighPatternBitmap) delete HighPatternBitmap;
  if (BackPatternBitmap) delete BackPatternBitmap;
  if (HighBackPatternBitmap) delete HighBackPatternBitmap;
  for (int i=0; i<5; i++) {
     if (PatternDummy[i]) {delete PatternDummy[i];}
     if (BackPatternDummy[i]) {delete BackPatternDummy[i];}
     if (bmDummy[i]) {delete bmDummy[i];}
     if (bmDummyBack[i]) {delete bmDummyBack[i];}
  }
  if (SuckerData.SuckerBitmap) delete SuckerData.SuckerBitmap;
  if (SuckerData.tagBitmap) delete SuckerData.tagBitmap;
  if (CopyBitmap) delete CopyBitmap;
  ProductInfo *pi;
  SimpleProductInfo *spi;
  ArrayInfo *ai;
  for (int i=1; i>=0; i--) {
    while (ProductArray[i]->Count) {
    	pi = (ProductInfo *) ProductArray[i]->Last();
      ProductArray[i]->Remove(pi);
     delete pi;
    }
    delete ProductArray[i]; ProductArray[i] = NULL;
    while (SimpleProductArray[i]->Count) {
      spi = (SimpleProductInfo *) SimpleProductArray[i]->Last();
      SimpleProductArray[i]->Remove(spi);
      delete spi;
    }
    delete SimpleProductArray[i];  SimpleProductArray[i] = NULL;
    while (OrderArray[i]->Count) {
    	ai = (ArrayInfo *) OrderArray[i]->Last();
      OrderArray[i]->Remove(ai);
     delete ai;
    }
    delete OrderArray[i]; OrderArray[i] = NULL;
  }
  delete ProductStringData.Ji;
  delete ProductStringData.Attention;
}
//---------------------------------------------------------------------------
// Private Methods
//---------------------------------------------------------------------------
bool __fastcall TPlan::GetFinish()
{
	if (Yarn && Texture) {
		return Yarn->bFinish[WARP] && Yarn->bFinish[WEFT] && Texture->bFinish;
  }
  return false;
}
//---------------------------------------------------------------------------
bool __fastcall TPlan::GetWeaving()
{
 	return GetFinish() && bmFront && bmBack;
}
//---------------------------------------------------------------------------
void __fastcall TPlan::InitYarnDot(int i)
{
  int j, k;
  double l1, l2, gap;
  TYarnArray *yad;

  if (Yarn->Array[i]->Count) {
    data[i] = new Data[Yarn->Array[i]->Count];
    memset(data[i], 0, sizeof(Data));
    if (bOld) {
      if (bTextureCorrection) {
        cnt[i] = 0;
        for (j=0; j<Yarn->Array[i]->Count; j++) {
	        yad = (TYarnArray *)Yarn->Array[i]->Items[j];
          if (yad->code>0) {
	          for (k=0; k<cnt[i]; k++) {
  	          if (yad->code==data[i][k].code) {
        	      if (yad->method==W_REVERSE) {
          	      data[i][k].max += 2 * yad->repeat * yad->yarns;
            	  } else {
              	  data[i][k].max += yad->repeat * yad->yarns;
  	            }
      	        data[i][j].num = k;
      	        break;
        	    }
          	}
	          if (k>=cnt[i]) {
		  	      data[i][k].code = yad->code;
          	  data[i][k].dpy = 160 / yad->density;
            	if (yad->method==W_REVERSE) {
	              data[i][k].max = 2 * yad->repeat * yad->yarns;
  	          } else {
      	        data[i][k].max = yad->repeat * yad->yarns;
          	  }
            	data[i][j].num = cnt[i]++;
	          }
          }
        }
      } else {
        cnt[i] = 0;
        l1 = l2 = 0.0;
        for (j=0; j<Yarn->Array[i]->Count; j++) {
	        yad = (TYarnArray *)Yarn->Array[i]->Items[j];
          if (yad->code>0) {
	          for (k=0; k<cnt[i]; k++) {
  	          if (yad->code==data[i][k].code && yad->yarns==data[i][k].yarns) {
        	      if (yad->method==W_REVERSE) {
          	      data[i][k].max += 2*yad->repeat;
            	  } else {
              	  data[i][k].max += yad->repeat;
  	            }
      	        data[i][j].num = k;
      	        break;
        	    }
          	}
	          if (k>=cnt[i]) {
		  	      data[i][k].code = yad->code;
        	    data[i][k].yarns = yad->yarns;
          	  data[i][k].dot = yad->yarns*160/yad->density;
            	if (yad->method==W_REVERSE) {
	              data[i][k].max = 2*yad->repeat;
  	          } else {
      	        data[i][k].max = yad->repeat;
          	  }
            	data[i][j].num = cnt[i]++;
	          }
  	        if (yad->method==W_REVERSE) {
      	      l1 += 2*yad->yarns*yad->repeat/yad->density;
        	    l2 += 2*yad->repeat*data[i][k].dot/160.0;
  	        } else {
      	      l1 += yad->yarns*yad->repeat/yad->density;
        	    l2 += yad->repeat*data[i][k].dot/160.0;
          	}
          }
        }
        gap = (l1-l2)*160.0+0.5;
        TKnapsack *ks = new TKnapsack(cnt[i]);
        for (j=0; j<cnt[i]; j++) ks->Input(j, data[i][j].max);
        ks->Process(gap);
        for (j=0; j<ks->rn; j++) data[i][ks->result[j]].dot++;
        delete ks;
      }
    } else {
      cnt[i] = 0;
      for (j=0; j<Yarn->Array[i]->Count; j++) {
	      yad = (TYarnArray *)Yarn->Array[i]->Items[j];
        if (yad->code>0) {
	        for (k=0; k<cnt[i]; k++) {
  	        if (yad->code==data[i][k].code && yad->yarns==data[i][k].yarns) {
      	      if (yad->method==W_REVERSE) {
        	      data[i][k].max += 2*yad->repeat;
          	  } else {
            	  data[i][k].max += yad->repeat;
  	          }
    	        data[i][j].num = k;
    	        break;
      	    }
        	}
	        if (k>=cnt[i]) {
			      data[i][k].code = yad->code;
      	    data[i][k].yarns = yad->yarns;
            if( ceil(PatternDPI/160.0 * Yarn->Choice[(yad->code-1)>>3].Data->ExactThick) < ceil(PatternDPI/yad->density)){
               data[i][k].dot = yad->yarns * ceil(PatternDPI/yad->density);
            } else {
               data[i][k].dot = yad->yarns * ceil(PatternDPI/160.0 * Yarn->Choice[(yad->code-1)>>3].Data->ExactThick);
            }
          	if (yad->method==W_REVERSE) {
	            data[i][k].max = 2*yad->repeat;
  	        } else {
    	        data[i][k].max = yad->repeat;
        	  }
          	data[i][j].num = cnt[i]++;
	        }
        }
      }
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TPlan::ExitYarnDot(int i)
{
  if (data[i]) { delete data[i]; data[i] = NULL; }
}
//---------------------------------------------------------------------------
int __fastcall TPlan::Change(int i, int &n, int &o, int &r, int &repeat, int &Crepeat, int &rs, int &rn)
{
	TList *Array = Yarn->Array[i];
  if (((TYarnArray *)Array->Items[n])->method==W_REVERSE) {
    if (!zero){
      if (rs == NULL)
        rs = n;
        rn = NULL;         //  n =  ȣ, o = ׷  ȣ, r = ݺ ۵Ǵ  ȣ
        zero2 = false;     //  repeat =  ݺ, Crepeat =  ݺ Ƚ, rs = reverse   , rn  = normal  .
        if(n == 0)         //  zero = ù°  츦 üũϱ .
          zero = true;
    }
  }
  if (n>0)
    if (((TYarnArray *)Array->Items[n-1])->method==W_CENTER)
      rn = NULL;
  if (((TYarnArray *)Array->Items[n])->method==W_NORMAL) {
    if (!zero2){
      if (!rn)
        rn = n;
        if(n==0)
          zero2 = true;
    }
  }
  if (((TYarnArray *)Array->Items[n])->method==W_CENTER) {
    if (!Crepeat)
      Crepeat = ((TYarnArray *)Array->Items[n])->repeat;
    if (o>0) {
      o--;
      while (o>0 && ((TYarnArray *)Array->Items[o])->code==0) o--;    // replace o>=0
      if (((TYarnArray *)Array->Items[o])->method!=W_REVERSE) {
        if(((TYarnArray *)Array->Items[r])->method==W_CENTER)
          repeat = 1;
        if (repeat>1) {
          repeat--;
          o = r;
        } else {
          if (Crepeat>1) {
            n = rs;
            if (rn)
              n = rn;
            repeat = ((TYarnArray *)Array->Items[n])->repeat;
            r = o = n;
            Crepeat--;
          } else {
            n++;
            Crepeat = NULL;
            rs = NULL;
            zero = false;
            zero2 = false;
            while (n<Array->Count && ((TYarnArray *)Array->Items[n])->code==0) n++;
            if (n>=Array->Count) {
              if (bOld) {
                 if (Yarn->bFinish[i]) {
                   n = 0;
                   repeat = ((TYarnArray *)Array->Items[n])->repeat;
                   r = n;
                 } else return 1;
              } else {
                 if (Yarn->bFinish[i]) {
                    n = 0;
                    repeat = ((TYarnArray *)Array->Items[n])->repeat;
                    o = r = n;
                    return 2;
                 } else return 1;
              }
            }
            o = r = n;
            repeat = ((TYarnArray *)Array->Items[n])->repeat;
          }
        }
      } else {
        if (((TYarnArray *)Array->Items[o])->method!=((TYarnArray *)Array->Items[r])->method ||
	        	((TYarnArray *)Array->Items[o])->repeat!=((TYarnArray *)Array->Items[r])->repeat) {
          if(((TYarnArray *)Array->Items[r])->method==W_CENTER)
            repeat = 1;
          if (repeat>1) {
            repeat--;
            o = r;
          } else {
            repeat = ((TYarnArray *)Array->Items[o])->repeat;
            r = o;
          }
        }
      }
    } else {
      if (repeat>1) {
        repeat--;
        o = r;
      } else {
        if (Crepeat>1) {
          n = rs;
          repeat = ((TYarnArray *)Array->Items[n])->repeat;
          r = o = n;
          Crepeat--;
        } else {
          n++;
          Crepeat = NULL;
          rs = NULL;
          zero = false;
          zero = false;
          while (n<Array->Count && ((TYarnArray *)Array->Items[n])->code==0) n++;
          if (n>=Array->Count) {
            if (bOld){
               if (Yarn->bFinish[i]) {
                 n = 0;
                 repeat = ((TYarnArray *)Array->Items[n])->repeat;
                 r = n;
               } else return 1;
            } else {
               if (Yarn->bFinish[i]) {
                 n = 0;
                 repeat = ((TYarnArray *)Array->Items[n])->repeat;
                 o = r = n;
                 return 2;      //7.3ʹ ͸  ȴ. 2 ȯ.
               } else return 1;
            }
          }
          r = o = n;
          repeat = ((TYarnArray *)Array->Items[n])->repeat;
        }
      }
    }
  } else {
    n++;
    while (n<Array->Count && ((TYarnArray *)Array->Items[n])->code==0) n++;
    if (n<Array->Count) {
      if (((TYarnArray *)Array->Items[n])->method!=((TYarnArray *)Array->Items[r])->method ||
			    ((TYarnArray *)Array->Items[n])->repeat!=((TYarnArray *)Array->Items[r])->repeat) {
	    	if (repeat>1) {
 			    repeat--;
 	  	 	  n = r;
      	} else {
    	  	repeat = ((TYarnArray *)Array->Items[n])->repeat;
	 		    r = n;
 		   	}
      }
    } else {
    	if (repeat>1) {
 		    repeat--;
 	   	  n = r;
      } else {
    	  repeat = 1;
 		    r = n;
	   	  if (bOld) {
           if (Yarn->bFinish[i]) {
  	   	     n = 0;
    	   	   repeat = ((TYarnArray *)Array->Items[n])->repeat;
      	     r = n;
	 	       } else return 1;
        } else {
           if (Yarn->bFinish[i]) {
              n = 0;
              repeat = ((TYarnArray *)Array->Items[n])->repeat;
              o = r = n;
              return 2;
           } else return 1;
        }
 	   	}
    }
    o = n;
  }
  return 0;
}
//---------------------------------------------------------------------------
bool __fastcall TPlan::InitWeaveData(TWeaveData &wd, int i, int o)
{
  int x, y;
  int l, s, w, hl;
  TYarnArray *ya = (TYarnArray *)Yarn->Array[i]->Items[o];
  wd.dpy = 0;
  if (ya->yarns>0) {
	  wd.cv = (ya->code-1)>>3;
  	wd.cr = (ya->code-1)&0x07;
    if (Yarn->Choice[wd.cv].Data && (Yarn->Choice[wd.cv].Color[wd.cr] || Yarn->Choice[wd.cv].Data->Dyed)) {
      if(bOld) {
        wd.l = Yarn->Choice[wd.cv].Data->Length;
        wd.s = Yarn->Choice[wd.cv].Data->Width;
        wd.w = Yarn->Choice[wd.cv].Data->Thick;
        wd.hl = (wd.s-wd.w)>>1;
        wd.ydye = Yarn->Choice[wd.cv].Data->Dyed;
        if (bTextureCorrection) {
          wd.dpy = data[i][data[i][o].num].dpy;
          if (wd.dpy <= 0) return false;
          wd.yarns = 160.0 * ya->length / wd.dpy + 0.5;     //sometimes wd.dpy==0 --->happen error by kjs
        } else {
          wd.dpy = (double)data[i][data[i][o].num].dot/ya->yarns;
          if (wd.dpy <= 0) return false;
          wd.yarns = ya->yarns;
        }
        wd.gap = wd.dpy-wd.w;
        if (wd.gap>0) {
          wd.gap *= wd.w/wd.gap;
        	if (wd.gap>wd.w) wd.gap = wd.w;
        } else wd.w = ceil(wd.dpy);
        wd.t = (wd.s-wd.w)>>1;
        if (!wd.ydye) wd.ydc = Yarn->Choice[wd.cv].Color[wd.cr]; else wd.ydc = NULL;
        wd.ydm = Yarn->Choice[wd.cv].Data->Map;
        wd.ycn = (wd.cv<<11)+(wd.cr<<8);
        wd.space = 0;
      } else {
        l = Yarn->Choice[wd.cv].Data->Length;
        wd.l = l*PatternDPI/160.0;
        w = Yarn->Choice[wd.cv].Data->Thick;
        if (PatternDPI == 160) wd.w = w;
        else wd.w = ceil(Yarn->Choice[wd.cv].Data->ExactThick * PatternDPI / 160.0);
        s = Yarn->Choice[wd.cv].Data->Width;
        wd.s = s*wd.w/w;
        hl = (s-w)>>1;
        wd.hl = (wd.s-wd.w)>>1;
        wd.ydye = Yarn->Choice[wd.cv].Data->Dyed;
        wd.dpy = (double)data[i][data[i][o].num].dot/ya->yarns;

        if (wd.dpy <= 0) return false;
        wd.yarns = ya->yarns;

        wd.space = ceil(PatternDPI/ya->density)>wd.w ? ceil(PatternDPI/ya->density) - wd.w : 0;
        wd.gap = 0;
        wd.t = (wd.s-wd.w)>>1;
        if (!wd.ydye) wd.ydc = Yarn->Choice[wd.cv].Color[wd.cr]; else wd.ydc = NULL;
        if (PatternDPI < 320) {
           wd.ydm = Yarn->Choice[wd.cv].Data->Map;
        } else {
           wd.ydm = HighYarnMap[wd.cv];
        }
        wd.ycn = (wd.cv<<11)+(wd.cr<<8);
      }
    }
  }
  return true;
}
//---------------------------------------------------------------------------
void __fastcall TPlan::WarpBar8(TPMemoryArea<WORD> *Warp, TWeaveData &wd, int y)
{
	BYTE *yp, c;
  WORD *pp;
  int x, vx;

  yp = (BYTE *)wd.ydm+(*(xwp+wd.tc)+y)%wd.l;
  pp = Warp->pointer(wd.v, y);
  for (x=0; x<wd.w; x++, pp++) {
    vx = wd.v+x;
    if (vx<Warp->size.x) {
      c = *(yp+(x+wd.t)*wd.l);
      if(c) *pp = wd.ycn + c;
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TPlan::WarpBar15(TPMemoryArea<WORD> *Warp, TWeaveData &wd, int y)
{
	WORD *yp, *pp, c;
  int x, vx;

  yp = (WORD *)wd.ydm+(*(xwp+wd.tc)+y)%wd.l;
  pp = Warp->pointer(wd.v, y);
  for (x=0; x<wd.w; x++, pp++) {
    vx = wd.v+x;
    if (vx<Warp->size.x) {
      c = *(yp+(x+wd.t)*wd.l);
      if (~c & 0x8000) *pp = c | 0x8000;
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TPlan::WeftBar8(TPMemoryArea<WORD> *Weft, TWeaveData &wd, int x)
{
	BYTE *yp, c;
  WORD *pp;
  int y, vy;

  yp = (BYTE *)wd.ydm+(*(ywt+wd.tc)+x)%wd.l;
  for (y=0; y<wd.w; y++) {
    vy = wd.v+y;
    if (vy<Weft->size.y) {
		  pp = Weft->pointer(x, vy);
      c = *(yp+(y+wd.t)*wd.l);
      if(c) *pp = wd.ycn + c;
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TPlan::WeftBar15(TPMemoryArea<WORD> *Weft, TWeaveData &wd, int x)
{
	WORD *yp, *pp;
  int y, vy;

  yp = (WORD *)wd.ydm+(*(ywt+wd.tc)+x)%wd.l;
  for (y=0; y<wd.w; y++) {
    vy = wd.v+y;
    if (vy<Weft->size.y) {
		  pp = Weft->pointer(x, vy);
      *pp = *(yp+(y+wd.t)*wd.l) | 0x8000;
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TPlan::WarpBarFront8(TTexpiaBitmap *Bitmap, TWeaveData &wd, int y)
{
	BYTE *yp, c;
  WORD *pp;
  int x, vx;

  yp = (BYTE *)wd.ydm+(*(xwp+wd.tc)+y)%wd.l;
  pp = (WORD *)Bitmap->GetScanLine(y)+wd.v;
  for (x=0; x<wd.w; x++, pp++) {
    vx = wd.v+x;
    if (vx<Bitmap->Width) {
      c = *(yp+(x+wd.t)*wd.l);
      if (c) {
      	if (WeaveCondition.WovenEffect==WESolid) {
	      	*pp = RGBToColor15(wd.ydc[c>>3]->GetColor(0)->RGB);
        } else {
	      	*pp = RGBToColor15(wd.ydc[c>>3]->GetColor((c&7)-4)->RGB);
        }
      }
    }
  }
  Bitmap->PutScanLine(y);
}
//---------------------------------------------------------------------------
void __fastcall TPlan::WarpBarBack8(TTexpiaBitmap *Bitmap, TWeaveData &wd, int y)
{
	BYTE *yp, c;
  WORD *pp;
  int x, vx;

  yp = (BYTE *)wd.ydm+(*(xwp+wd.tc)+y)%wd.l;
  pp = (WORD *)Bitmap->GetScanLine(y)+Bitmap->Width-1-wd.v;
  for (x=0; x<wd.w; x++, pp--) {
    vx = wd.v+x;
    if (vx<Bitmap->Width) {
      c = *(yp+(x+wd.t)*wd.l);
      if (c) {
      	if (WeaveCondition.WovenEffect==WESolid) {
	      	*pp = RGBToColor15(wd.ydc[c>>3]->GetColor(0)->RGB);
        } else {
	      	*pp = RGBToColor15(wd.ydc[c>>3]->GetColor((c&7)-4)->RGB);
        }
      }
    }
  }
  Bitmap->PutScanLine(y);
}
//---------------------------------------------------------------------------
void __fastcall TPlan::WarpBarFront15(TTexpiaBitmap *Bitmap, TWeaveData &wd, int y)
{
  WORD *pp, *yp, c;
  int x, vx;

  yp = (WORD *)wd.ydm+(*(xwp+wd.tc)+y)%wd.l;
  pp = (WORD *)Bitmap->GetScanLine(y)+wd.v;
  for (x=0; x<wd.w; x++, pp++) {
    vx = wd.v+x;
    if (vx<Bitmap->Width) {
      c = *(yp+(x+wd.t)*wd.l);
      if (~c & 0x8000) *pp = c & 0x7FFF;
    }
  }
  Bitmap->PutScanLine(y);
}
//---------------------------------------------------------------------------
void __fastcall TPlan::WarpBarBack15(TTexpiaBitmap *Bitmap, TWeaveData &wd, int y)
{
  WORD *pp, *yp, c;
  int x, vx;

  yp = (WORD *)wd.ydm+(*(xwp+wd.tc)+y)%wd.l;
  pp = (WORD *)Bitmap->GetScanLine(y)+Bitmap->Width-1-wd.v;
  for (x=0; x<wd.w; x++, pp--) {
    vx = wd.v+x;
    if (vx<Bitmap->Width) {
      c = *(yp+(x+wd.t)*wd.l);
      if (~c & 0x8000) *pp = c & 0x7FFF;
    }
  }
  Bitmap->PutScanLine(y);
}
//---------------------------------------------------------------------------

void __fastcall TPlan::WeftBar8(TTexpiaBitmap *Bitmap, TWeaveData &wd, int x)
{
	BYTE *yp, c;
  WORD *pp;
  int y, vy;

  yp = (BYTE *)wd.ydm+(*(ywt+wd.tc)+x)%wd.l;
  for (y=0; y<wd.w; y++) {
    vy = Bitmap->Height-1-(wd.v+y);
    if (vy<Bitmap->Height) {
		  pp = (WORD *)Bitmap->GetScanLine(vy)+x;
      c = *(yp+(y+wd.t)*wd.l);
      if (c) {
      	if (WeaveCondition.WovenEffect==WESolid) {
	      	*pp = RGBToColor15(wd.ydc[c>>3]->GetColor(0)->RGB);
        } else {
	      	*pp = RGBToColor15(wd.ydc[c>>3]->GetColor((c&7)-4)->RGB);
        }
      }
		  Bitmap->PutScanLine(vy);
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TPlan::WeftBar15(TTexpiaBitmap *Bitmap, TWeaveData &wd, int x)
{
  WORD *pp, *yp, c;
  int y, vy;

  yp = (WORD *)wd.ydm+(*(ywt+wd.tc)+x)%wd.l;
  for (y=0; y<wd.w; y++) {
    vy = Bitmap->Height-1-(wd.v+y);
    if (vy<Bitmap->Height) {
		  pp = (WORD *)Bitmap->GetScanLine(vy)+x;
      c = *(yp+(y+wd.t)*wd.l);
      if (~c & 0x8000) *pp = c & 0x7FFF;
		  Bitmap->PutScanLine(vy);
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TPlan::Warp8(TWeaveData &wd, WORD *pp)
{
  BYTE *yp1;
  WORD *pp1;
  int x;

  yp1 = (BYTE *)wd.ydm+*(xwp+wd.tc)+wd.t*wd.l;
  pp1 = pp+wd.v;
  if (wd.v+wd.w<bmWarp->size.x) {
    for (x=0; x<wd.w; x++, yp1+=wd.l, pp1++) {
      if (*yp1) *pp1 = wd.ycn+*yp1;
    }
  } else {
    for (x=0; x<wd.w; x++, yp1+=wd.l, pp1++) {
      if (wd.v+x<bmWarp->size.x && *yp1) *pp1 = wd.ycn+*yp1;
    }
  }
  if (++*(xwp+wd.tc)>=wd.l) *(xwp+wd.tc) = 0;
}
//---------------------------------------------------------------------------

void __fastcall TPlan::Warp15(TWeaveData &wd, WORD *pp)
{
  WORD *pp1, *yp1;
  int x;

  yp1 = (WORD *)wd.ydm+*(xwp+wd.tc)+wd.t*wd.l;
  pp1 = pp+wd.v;
  if (wd.v+wd.w<bmWarp->size.x) {
    for (x=0; x<wd.w; x++, yp1+=wd.l, pp1++) {
      if (!(*yp1 & 0x8000)) *pp1 = *yp1 | 0x8000;
    }
  } else {
    for (x=0; x<wd.w; x++, yp1+=wd.l, pp1++) {
      if (wd.v+x<bmWarp->size.x && (!(*yp1 & 0x8000)))
        *pp1 = *yp1 | 0x8000;
    }
  }
  if (++*(xwp+wd.tc)>=wd.l) *(xwp+wd.tc) = 0;
}
//---------------------------------------------------------------------------

void __fastcall TPlan::WarpHair8(TWeaveData &wd, WORD *pp, WORD *hp)
{
  BYTE *yp1;
  WORD *pp1, *hp1;
  int x;

  yp1 = (BYTE *)wd.ydm+*(xwp+wd.tc);                          //κ
  for (x=-wd.hl; x<0; x++,yp1+=wd.l) {
    if (*yp1) *(hp+(bmHair->size.x +(wd.v+x)%bmHair->size.x)%bmHair->size.x) = wd.ycn+*yp1;
  }

  yp1 = (BYTE *)wd.ydm+*(xwp+wd.tc)+wd.t*wd.l;                //߽ɺκ
  pp1 = pp+wd.v;
  if (wd.v+wd.w<bmWarp->size.x) {
    for (x=0; x<wd.w; x++, yp1+=wd.l, pp1++) {
      if (*yp1) *pp1 = wd.ycn+*yp1;
    }
  } else {
    for (x=0; x<wd.w; x++, yp1+=wd.l, pp1++) {
      if (wd.v+x<bmWarp->size.x && *yp1) *pp1 = wd.ycn+*yp1;
    }
  }

  yp1 = (BYTE *)wd.ydm+*(xwp+wd.tc)+(wd.s-wd.hl)*wd.l;        //κ
  for (x=wd.w; x<wd.w+wd.hl; x++, yp1+=wd.l) {
    if (*yp1) *(hp+(wd.v+x)%bmHair->size.x) = wd.ycn+*yp1;
  }
  if (++*(xwp+wd.tc)>=wd.l) *(xwp+wd.tc) = 0;
}
//---------------------------------------------------------------------------

void __fastcall TPlan::WarpHair15(TWeaveData &wd, WORD *pp, WORD *hp)
{
  WORD *pp1, *hp1, *yp1;
  int x;

  yp1 = (WORD *)wd.ydm+*(xwp+wd.tc)+wd.t*wd.l;
  pp1 = pp+wd.v;
  if (wd.v+wd.w<bmWarp->size.x) {
    for (x=0; x<wd.w; x++, yp1+=wd.l, pp1++) {
      if (!(*yp1 & 0x8000)) *pp1 = *yp1 | 0x8000;
    }
  } else {
    for (x=0; x<wd.w; x++, yp1+=wd.l, pp1++) {
      if (wd.v+x<bmWarp->size.x && (!(*yp1 & 0x8000)))
        *pp1 = *yp1 | 0x8000;
    }
  }
  yp1 = (WORD *)wd.ydm+*(xwp+wd.tc);
  hp1 = hp+wd.v-wd.hl;
  if (wd.v-wd.hl>=0 && wd.v<bmHair->size.x) {
    for (x=-wd.hl; x<0; x++, yp1+=wd.l, hp1++) {
      if (!(*yp1 & 0x8000)) *hp1 = *yp1 | 0x8000;
    }
  } else {
    for (x=-wd.hl; x<0; x++, yp1+=wd.l, hp1++) {
      if (wd.v+x>=0 && wd.v+x<bmHair->size.x && (!(*yp1 & 0x8000)))
        *hp1 = *yp1 | 0x8000;
    }
  }
  yp1 = (WORD *)wd.ydm+*(xwp+wd.tc)+(wd.s-wd.hl)*wd.l;
  hp1 = hp+wd.v+wd.w;
  if (wd.v+wd.w+wd.hl<bmHair->size.x) {
    for (x=wd.w; x<wd.w+wd.hl; x++, yp1+=wd.l, hp1++) {
      if (!(*yp1 & 0x8000)) *hp1 = *yp1 | 0x8000;
    }
  } else {
    for (x=wd.w; x<wd.w+wd.hl; x++, yp1+=wd.l, hp1++) {
      if (wd.v+x<bmHair->size.x && (!(*yp1 & 0x8000)))
        *hp1 = *yp1 | 0x8000;
    }
  }
  if (++*(xwp+wd.tc)>=wd.l) *(xwp+wd.tc) = 0;
}
//---------------------------------------------------------------------------

int __fastcall TPlan::getsize(int warporweft, int size)
{
	TList *Array = Yarn->Array[warporweft];
  TWeaveData wd;
  WORD *pp, *hp;
  int x, y, n, o, ic, r, repeat, tl, Crepeat, rs, rn;
  double al, gs, gt;

  tl = 0; al = tl;
  wd.tc = ic = 0;
  n = o = Crepeat = 0;
  rs = rn = NULL;
  r = n;
  repeat = ((TYarnArray *)Array->Items[n])->repeat;
  if (!InitWeaveData(wd, warporweft, o)) return 0;
  while (al+wd.dpy < size) {
    wd.tc++; ic++;
    al += wd.dpy;
    if (ic >= wd.yarns) {
      ic = 0;
      if (bOld) {
         if (!bTextureCorrection) {
           tl += data[warporweft][data[warporweft][o].num].dot; al = tl;
         }
      } else {
         tl += data[warporweft][data[warporweft][o].num].dot; al = tl;
      }
      if (Change(warporweft, n, o, r, repeat, Crepeat, rs, rn) == 1) break;   // qe test
      else if (!InitWeaveData(wd, warporweft, o)) return 0;
    }
  }
  return wd.tc;
}
//-----------------------------------------------------------------------------

void __fastcall TPlan::calc_warp()
{
	TList *Array = Yarn->Array[WARP];
  TWeaveData wd;
  WORD *pp, *hp;
  int x, y, n, o, ic, r, repeat, tl, tension, s, Crepeat, rs, rn;
  double al, gs, gt;

  //  bitmap ʱȭѴ.
	memset(bmWarp->pointer(), 0, 2*bmWarp->size.x*bmWarp->size.y);

  tl = 0; al = tl;
  wd.tc = ic = 0;
  n = o = Crepeat = 0;
  rs = rn = NULL;
  repeat = ((TYarnArray *)Array->Items[n])->repeat;
  r = n;
  tension = WeaveCondition.Tension;

  // bmWarp->size.x 쿡    ȯѴ.
  if ((s = getsize(WARP, bmWarp->size.x)) == 0) goto fail;

  // ǵ  ġ  ֽ.
  if (xwp) delete[] xwp;
  xwp = new int[s];

  if (!InitWeaveData(wd, WARP, o)) goto fail;
  if (WeaveCondition.HairEffect==HEActual) {
    // Hair effect bitmap ʱȭѴ.
		memset(bmHair->pointer(), 0, 2*bmHair->size.x*bmHair->size.y);

    while (al+wd.dpy<bmWarp->size.x) {
      if (*(xwp+wd.tc)<=0 || *(xwp+wd.tc)>=wd.l) {
        *(xwp+wd.tc) = rand()%wd.l;
      }

      if (wd.gap>0.0) {
        gs = (rand()%int(wd.gap*100))/100.0;
        gt = wd.gap/(wd.gap*tension + rand()%10);
//        gt = wd.gap/(16+rand()%10);
        pp = bmWarp->pointer();
        hp = bmHair->pointer();
        if (wd.ydye) {
          for (y=0; y<bmWarp->size.y; y++) {
            wd.v = al+gs;
            if (gt>=0) {
              if (gs+gt>=wd.gap) gt = -gt;
            } else {
              if (gs+gt<0) gt = -gt;
            }
            gs += gt;
            WarpHair15(wd, pp, hp);
            pp += bmWarp->size.x;
            hp += bmHair->size.x;
          }
        } else {
          for (y=0; y<bmWarp->size.y; y++) {
            wd.v = al+gs;
            if (gt>=0) {
              if (gs+gt>=wd.gap) gt = -gt;
            } else {
              if (gs+gt<0) gt = -gt;
            }
            gs += gt;
            WarpHair8(wd, pp, hp);
            pp += bmWarp->size.x;
            hp += bmHair->size.x;
          }
        }
      } else {
        wd.v = al + wd.space;
        pp = bmWarp->pointer();
        hp = bmHair->pointer();
        if (wd.ydye) {
          for (y=0; y<bmWarp->size.y; y++) {
            WarpHair15(wd, pp, hp);
            pp += bmWarp->size.x;
            hp += bmHair->size.x;
          }
        } else {
          for (y=0; y<bmWarp->size.y; y++) {
            WarpHair8(wd, pp, hp);
            pp += bmWarp->size.x;
            hp += bmHair->size.x;
          }
        }
      }
      wd.tc++; ic++;
      al += wd.dpy;
      if (ic>=wd.yarns) {
        ic = 0;
        if (!bTextureCorrection) {
           tl += data[WARP][data[WARP][o].num].dot; al = tl;
        }
        Change(WARP, n, o, r, repeat, Crepeat, rs, rn);
        if (!InitWeaveData(wd, WARP, o)) goto fail;
      }
    }
  } else {
    while (al+wd.dpy<bmWarp->size.x) {
      if (*(xwp+wd.tc)<=0 || *(xwp+wd.tc)>=wd.l) {
        *(xwp+wd.tc) = rand()%wd.l;
      }
      if (wd.gap>0.0) {
        gs = (rand()%int(wd.gap*100))/100.0;
        gt = wd.gap/(wd.gap*tension + rand()%10);
//        gt = wd.gap/(16+rand()%10);
        pp = bmWarp->pointer();
        if (wd.ydye) {
          for (y=0; y<bmWarp->size.y; y++) {
            wd.v = al+gs;
            if (gt>=0) {
              if (gs+gt>=wd.gap) gt = -gt;
            } else {
              if (gs+gt<0) gt = -gt;
            }
            gs += gt;
            Warp15(wd, pp);
            pp += bmWarp->size.x;
          }
        } else {
          for (y=0; y<bmWarp->size.y; y++) {
            wd.v = al+gs;
            if (gt>=0) {
              if (gs+gt>=wd.gap) gt = -gt;
            } else {
              if (gs+gt<0) gt = -gt;
            }
            gs += gt;
            Warp8(wd, pp);
            pp += bmWarp->size.x;
          }
        }
      } else {
        wd.v = al + wd.space;
        pp = bmWarp->pointer();
        if (wd.ydye) {
          for (y=0; y<bmWarp->size.y; y++) {
            Warp15(wd, pp);
            pp += bmWarp->size.x;
          }
        } else {
          for (y=0; y<bmWarp->size.y; y++) {
            Warp8(wd, pp);
            pp += bmWarp->size.x;
          }
        }
      }
      wd.tc++; ic++;
      al += wd.dpy;
      if (ic>=wd.yarns) {
        ic = 0;
        if (!bTextureCorrection) {
          tl += data[WARP][data[WARP][o].num].dot; al = tl;
        }
        Change(WARP, n, o, r, repeat, Crepeat, rs, rn);
        if (!InitWeaveData(wd, WARP, o)) goto fail;
      }
    }
  }
  delete[] xwp; xwp = NULL;
  return;
fail:
  EXCEPTION_MESSAGE_OK(EC_HIGH_DENSITY);
}
//---------------------------------------------------------------------------
void __fastcall TPlan::Weft8(TWeaveData &wd, WORD *pp)
{
  BYTE *yp1;
  WORD *pp1;
  int y;

  yp1 = (BYTE *)wd.ydm+*(ywt+wd.tc)+wd.t*wd.l;
  pp1 = pp+wd.v*bmWeft->size.x;
  if (wd.v+wd.w<bmWeft->size.y) {
    for (y=0; y<wd.w; y++, yp1+=wd.l, pp1+=bmWeft->size.x) {
      if (*yp1) *pp1 = 0x4000|(wd.ycn+*yp1);
    }
  } else {
    for (y=0; y<wd.w; y++, yp1+=wd.l, pp1+=bmWeft->size.x) {
      if (wd.v+y<bmWeft->size.y && *yp1) *pp1 = 0x4000|(wd.ycn+*yp1);
    }
  }
  if (++*(ywt+wd.tc)>=wd.l) *(ywt+wd.tc) = 0;
}
//---------------------------------------------------------------------------

void __fastcall TPlan::Weft15(TWeaveData &wd, WORD *pp)
{
  WORD *pp1, *yp1;
  int y;

  yp1 = (WORD *)wd.ydm+*(ywt+wd.tc)+wd.t*wd.l;
  pp1 = pp+wd.v*bmWeft->size.x;
  if (wd.v+wd.w<bmWeft->size.y) {
    for (y=0; y<wd.w; y++, yp1+=wd.l, pp1+=bmWeft->size.x) {
      if (!(*yp1 & 0x8000)) *pp1 = *yp1 | 0x8000;
    }
  } else {
    for (y=0; y<wd.w; y++, yp1+=wd.l, pp1+=bmWeft->size.x) {
      if (wd.v+y<bmWeft->size.y && (!(*yp1 & 0x8000)))
        *pp1 = *yp1 | 0x8000;
    }
  }
  if (++*(ywt+wd.tc)>=wd.l) *(ywt+wd.tc) = 0;
}
//---------------------------------------------------------------------------

void __fastcall TPlan::WeftHair8(TWeaveData &wd, WORD *pp, WORD *hp)
{
  BYTE *yp1;
  WORD *pp1, *hp1;
  int y;

  yp1 = (BYTE *)wd.ydm+*(ywt+wd.tc);
  for (y=-wd.hl; y<0; y++, yp1+=wd.l) {
    if(*yp1) {
      if(*(hp+((bmHair->size.y+(wd.v+y)%bmHair->size.y)%bmHair->size.y)*bmHair->size.x)) {
         *(hp+((bmHair->size.y+(wd.v+y)%bmHair->size.y)%bmHair->size.y)*bmHair->size.x) = 0x4000|(wd.ycn+*yp1);
         wd.h ^= 0xFF;
      }
    }
  }
  /*hp1 = hp+(wd.v-wd.hl)*bmHair->size.x;
  if (wd.v-wd.hl>=0 && wd.v<bmHair->size.y) {
    for (y=-wd.hl; y<0; y++, yp1+=wd.l, hp1+=bmHair->size.x) {
      if (*yp1) {
        if (*hp1==0 || wd.h==0) {
          *hp1 = 0x4000|(wd.ycn+*yp1);
          wd.h ^= 0xFF;
        }
      }
    }
  } else {
    for (y=-wd.hl; y<0; y++, yp1+=wd.l, hp1+=bmHair->size.x) {
      if (wd.v+y>=0 && wd.v+y<bmHair->size.y && *yp1) {
        if (*hp1==0 || wd.h==0) {
          *hp1 = 0x4000|(wd.ycn+*yp1);
          wd.h ^= 0xFF;
        }
      }
    }
  } */
  yp1 = (BYTE *)wd.ydm+*(ywt+wd.tc)+wd.t*wd.l;
  pp1 = pp+wd.v*bmWeft->size.x;
  if (wd.v+wd.w<bmWeft->size.y) {
    for (y=0; y<wd.w; y++, yp1+=wd.l, pp1+=bmWeft->size.x) {
      if (*yp1) *pp1 = 0x4000|(wd.ycn+*yp1);
    }
  } else {
    for (y=0; y<wd.w; y++, yp1+=wd.l, pp1+=bmWeft->size.x) {
      if (wd.v+y<bmWeft->size.y && *yp1) *pp1 = 0x4000|(wd.ycn+*yp1);
    }
  }
  yp1 = (BYTE *)wd.ydm+*(ywt+wd.tc)+(wd.s-wd.hl)*wd.l;
  for (y=wd.w; y<wd.w+wd.hl; y++, yp1+=wd.l) {
    if(*yp1) {
      if (*(hp+((wd.v+y)%bmHair->size.y)*bmHair->size.x)) {
        *(hp+((wd.v+y)%bmHair->size.y)*bmHair->size.x) = 0x4000|(wd.ycn+*yp1);
        wd.h ^= 0xFF;
      }
    }
  }
  /*hp1 = hp+(wd.v+wd.w)*bmHair->size.x;
  if (wd.v+wd.w+wd.hl<bmHair->size.y) {
    for (y=wd.w; y<wd.w+wd.hl; y++, yp1+=wd.l, hp1+=bmHair->size.x) {
      if (*yp1) {
        if (*hp1==0 || wd.h==0) {
          *hp1 = 0x4000|(wd.ycn+*yp1);
          wd.h ^= 0xFF;
        }
      }
    }
  } else {
    for (y=wd.w; y<wd.w+wd.hl; y++, yp1+=wd.l, hp1+=bmHair->size.x) {
      if (wd.v+y<bmHair->size.y && *yp1) {
        if (*hp1==0 || wd.h==0) {
          *hp1 = 0x4000|(wd.ycn+*yp1);
          wd.h ^= 0xFF;
        }
      }
    }
  }*/
  if (++*(ywt+wd.tc)>=wd.l) *(ywt+wd.tc) = 0;
}
//---------------------------------------------------------------------------

void __fastcall TPlan::WeftHair15(TWeaveData &wd, WORD *pp, WORD *hp)
{
  WORD *pp1, *hp1, *yp1;
  int y;

  yp1 = (WORD *)wd.ydm+*(ywt+wd.tc)+wd.t*wd.l;
  pp1 = pp+wd.v*bmWeft->size.x;
  if (wd.v+wd.w<bmWeft->size.y) {
    for (y=0; y<wd.w; y++, yp1+=wd.l, pp1+=bmWeft->size.x) {
      if (!(*yp1 & 0x8000)) *pp1 = *yp1 | 0x8000;
    }
  } else {
    for (y=0; y<wd.w; y++, yp1+=wd.l, pp1+=bmWeft->size.x) {
      if (wd.v+y<bmWeft->size.y && (!(*yp1 & 0x8000)))
        *pp1 = *yp1 | 0x8000;
    }
  }
  yp1 = (WORD *)wd.ydm+*(ywt+wd.tc);
  hp1 = hp+(wd.v-wd.hl)*bmHair->size.x;
  if (wd.v-wd.hl>=0 && wd.v<bmHair->size.y) {
    for (y=-wd.hl; y<0; y++, yp1+=wd.l, hp1+=bmHair->size.x) {
      if (!(*yp1 & 0x8000)) {
        if (*hp1==0 || wd.h==0) {
          *hp1 = *yp1 | 0x8000;
          wd.h ^= 0xFF;
        }
      }
    }
  } else {
    for (y=-wd.hl; y<0; y++, yp1+=wd.l, hp1+=bmHair->size.x) {
      if (wd.v+y>=0 && wd.v+y<bmHair->size.y && *yp1) {
        if (*hp1==0 || wd.h==0) {
          *hp1 = *yp1 | 0x8000;
          wd.h ^= 0xFF;
        }
      }
    }
  }
  yp1 = (WORD *)wd.ydm+*(ywt+wd.tc)+(wd.s-wd.hl)*wd.l;
  hp1 = hp+(wd.v+wd.w)*bmHair->size.x;
  if (wd.v+wd.w+wd.hl<bmHair->size.y) {
    for (y=wd.w; y<wd.w+wd.hl; y++, yp1+=wd.l, hp1+=bmHair->size.x) {
      if (!(*yp1 & 0x8000)) {
        if (*hp1==0 || wd.h==0) {
          *hp1 = *yp1 | 0x8000;
          wd.h ^= 0xFF;
        }
      }
    }
  } else {
    for (y=wd.w; y<wd.w+wd.hl; y++, yp1+=wd.l, hp1+=bmHair->size.x) {
      if (wd.v+y<bmHair->size.y && *yp1) {
        if (*hp1==0 || wd.h==0) {
          *hp1 = *yp1 | 0x8000;
          wd.h ^= 0xFF;
        }
      }
    }
  }
  if (++*(ywt+wd.tc)>=wd.l) *(ywt+wd.tc) = 0;
}
//---------------------------------------------------------------------------

void __fastcall TPlan::calc_weft()
{
	TList *Array = Yarn->Array[WEFT];
  TWeaveData wd;
  WORD *pp, *hp;
  int x, y, n, o, ic, r, repeat, tl, tension, s, Crepeat, rs, rn;
  double al, gs, gt;

	memset(bmWeft->pointer(), 0, 2*bmWeft->size.x*bmWeft->size.y);
  tl = 0; al = tl;
  wd.tc = ic = 0;
  n = o = Crepeat = 0;
  rs = rn = NULL;
  repeat = ((TYarnArray *)Array->Items[n])->repeat;
  r = n;
  wd.h = 0;

  tension = WeaveCondition.Tension;

  if ((s = getsize(WEFT, bmWeft->size.y)) == 0) goto fail;
  if (ywt) delete[] ywt;
  ywt = new int[s];

  if (!InitWeaveData(wd, WEFT, o)) goto fail;
  if (WeaveCondition.HairEffect==HEActual) {
    while (al+wd.dpy<bmWeft->size.y) {
	    if (*(ywt+wd.tc)<=0 || *(ywt+wd.tc)>=wd.l) {
  	    *(ywt+wd.tc) = rand()%wd.l;
    	}
      if (wd.gap>0.0) {
        gs = (rand()%int(wd.gap*100))/100.0;
        gt = wd.gap/(wd.gap*tension + rand()%10);
//        gt = wd.gap/(16+rand()%10);
        pp = bmWeft->pointer();
        hp = bmHair->pointer();
        if (wd.ydye) {
          for (x=0; x<bmWeft->size.x; x++, pp++, hp++) {
            wd.v = al+gs;
            if (gt>=0) {
              if (gs+gt>=wd.gap) gt = -gt;
            } else {
              if (gs+gt<0) gt = -gt;
            }
            gs += gt;
            WeftHair15(wd, pp, hp);
          }
        } else {
          for (x=0; x<bmWeft->size.x; x++, pp++, hp++) {
            wd.v = al+gs;
            if (gt>=0) {
              if (gs+gt>=wd.gap) gt = -gt;
            } else {
              if (gs+gt<0) gt = -gt;
            }
            gs += gt;
            WeftHair8(wd, pp, hp);
          }
        }
      } else {
        wd.v = al + wd.space;
        pp = bmWeft->pointer();
        hp = bmHair->pointer();
        if (wd.ydye) {
          for (x=0; x<bmWeft->size.x; x++, pp++, hp++)
            WeftHair15(wd, pp, hp);
        } else {
          for (x=0; x<bmWeft->size.x; x++, pp++, hp++)
            WeftHair8(wd, pp, hp);
        }
      }
      wd.tc++; ic++;
      al += wd.dpy;
      if (ic>=wd.yarns) {
        ic = 0;
        if (!bTextureCorrection) {
          tl += data[WEFT][data[WEFT][o].num].dot; al = tl;
        }
        Change(WEFT, n, o, r, repeat, Crepeat, rs, rn);
        if (!InitWeaveData(wd, WEFT, o)) goto fail;
      }
    }
  } else {
    while (al+wd.dpy<bmWeft->size.y) {
	    if (*(ywt+wd.tc)<=0 || *(ywt+wd.tc)>=wd.l) {
  	    *(ywt+wd.tc) = rand()%wd.l;
    	}
      if (wd.gap>0.0) {
        gs = (rand()%int(wd.gap*100))/100.0;
        gt = wd.gap/(wd.gap*tension + rand()%10);
//        gt = wd.gap/(16+rand()%10);
        pp = bmWeft->pointer();
        if (wd.ydye) {
          for (x=0; x<bmWeft->size.x; x++, pp++) {
            wd.v = al+gs;
            if (gt>=0) {
              if (gs+gt>=wd.gap) gt = -gt;
            } else {
              if (gs+gt<0) gt = -gt;
            }
            gs += gt;
            Weft15(wd, pp);
          }
        } else {
          for (x=0; x<bmWeft->size.x; x++, pp++) {
            wd.v = al+gs;
            if (gt>=0) {
              if (gs+gt>=wd.gap) gt = -gt;
            } else {
              if (gs+gt<0) gt = -gt;
            }
            gs += gt;
            Weft8(wd, pp);
          }
        }
      } else {
        wd.v = al + wd.space;
        pp = bmWeft->pointer();
        if (wd.ydye) {
          for (x=0; x<bmWeft->size.x; x++, pp++) Weft15(wd, pp);
        } else {
          for (x=0; x<bmWeft->size.x; x++, pp++) Weft8(wd, pp);
        }
      }
      wd.tc++; ic++;
      al += wd.dpy;
      if (ic>=wd.yarns) {
        ic = 0;
        if (!bTextureCorrection) {
          tl += data[WEFT][data[WEFT][o].num].dot; al = tl;
        }
        Change(WEFT, n, o, r, repeat, Crepeat, rs, rn);
        if (!InitWeaveData(wd, WEFT, o)) goto fail;
      }
    }
  }
  delete[] ywt; ywt = NULL;
  return;
fail:
  EXCEPTION_MESSAGE_OK(EC_HIGH_DENSITY);
}
//---------------------------------------------------------------------------
void __fastcall TPlan::texture_warp(TPMemoryArea<WORD> *bm)
{
  WORD *bp, *wp, *wpp;
  int p, x, y;
  
  wp = bmWarp->pointer(v[WARP], v[WEFT]);
  if (v[WEFT]+dpy[WEFT]<bm->size.y) {
    for (y=0; y<dpy[WEFT]; y++) {
      bp = bm->pointer(v[WARP], v[WEFT]+y); wpp = wp;
      if (v[WARP]+dpy[WARP]<bm->size.x) {
        for (x=0; x<dpy[WARP]; x++, bp++, wpp++) {
          if (*wpp) *bp = *wpp;
        }
      } else {
        for (x=0; x<dpy[WARP]; x++, bp++, wpp++) {
          if (v[WARP]+x<bm->size.x) {
            if (*wpp) *bp = *wpp;
          }
        }
      }
      wp += bmWarp->size.x;
    }
  } else {
    for (y=0; y<dpy[WEFT]; y++) {
      if (v[WEFT]+y<bm->size.y) {
        bp = bm->pointer(v[WARP], v[WEFT]+y); wpp = wp;
        if (v[WARP]+dpy[WARP]<bm->size.x) {
          for (x=0; x<dpy[WARP]; x++, bp++, wpp++) {
            if (*wpp) *bp = *wpp;
          }
        } else {
          for (x=0; x<dpy[WARP]; x++, bp++, wpp++) {
            if (v[WARP]+x<bm->size.x) {
              if (*wpp) *bp = *wpp;
            }
          }
        }
      }
      wp += bmWarp->size.x;
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TPlan::texture_weft(TPMemoryArea<WORD> *bm)
{
  WORD *bp, *wp, *wpp;
  int p, x, y;

  wp = bmWeft->pointer(v[WARP], v[WEFT]);
  if (v[WARP]+dpy[WARP]<bm->size.x) {
    for (x=0; x<dpy[WARP]; x++, wp++) {
      bp = bm->pointer(v[WARP]+x, v[WEFT]); wpp = wp;
      if (v[WEFT]+dpy[WEFT]<bm->size.y) {
        for (y=0; y<dpy[WEFT]; y++) {
          if (*wpp) *bp = *wpp;
          bp += bm->size.x;
          wpp += bmWeft->size.x;
        }
      } else {
        for (y=0; y<dpy[WEFT]; y++) {
          if (v[WEFT]+y<bm->size.y && *wpp) *bp = *wpp;
          bp += bm->size.x;
          wpp += bmWeft->size.x;
        }
      }
    }
  } else {
    for (x=0; x<dpy[WARP]; x++, wp++) {
      if (v[WARP]+x<bm->size.x) {
        bp = bm->pointer(v[WARP]+x, v[WEFT]); wpp = wp;
        if (v[WEFT]+dpy[WEFT]<bm->size.y) {
          for (y=0; y<dpy[WEFT]; y++) {
            if (*wpp) *bp = *wpp;
	          bp += bm->size.x;
            wpp += bmWeft->size.x;
          }
        } else {
          for (y=0; y<dpy[WEFT]; y++) {
            if (v[WEFT]+y<bm->size.y && *wpp) *bp = *wpp;
	          bp += bm->size.x;
            wpp += bmWeft->size.x;
          }
        }
      }
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TPlan::calc_hair(TPMemoryArea<WORD> *bmf, TPMemoryArea<WORD> *bmb)
{
	WORD *fp, *bp, *hp, fc, bc;
  int x, y, ix, iy, px, py, hmp;
  int w = bmFront->size.x;
  int h = bmFront->size.y;

  if (WeaveCondition.HairEffect==HEActual) {
      for (y=0; y<bmf->size.y; y++) {
        fp = (WORD *)bmf->pointer(0, y);
        hp = (WORD *)bmHair->pointer(0, y);
        for (x=0; x<bmf->size.x; x++) {
          switch (WeaveCondition.HairRatio) {
            case 0: if (*hp && rand()%5==0) *fp = *hp; break;
            case 1: if (*hp && rand()%4==0) *fp = *hp; break;
            case 2: if (*hp && rand()%3==0) *fp = *hp; break;
            case 3: if (*hp && rand()%2) *fp = *hp; break;
            case 4: if (*hp && rand()%3) *fp = *hp; break;
            case 5: if (*hp && rand()%4) *fp = *hp; break;
            case 6: if (*hp && rand()%5) *fp = *hp; break;
            default: if (*hp) *fp = *hp;
          }
          fp++; hp++;
        }
      }
      if(WeaveCondition.BackSide){
        for (y=0; y<bmb->size.y; y++) {
          bp = (WORD *)bmb->pointer(0, y);
          hp = (WORD *)bmHair->pointer(0, y);
          for (x=0; x<bmb->size.x; x++) {
            switch (WeaveCondition.HairRatio) {
              case 0: if (*hp && rand()%5==0) *bp = *hp; break;
              case 1: if (*hp && rand()%4==0) *bp = *hp; break;
              case 2: if (*hp && rand()%3==0) *bp = *hp; break;
              case 3: if (*hp && rand()%2) *bp = *hp; break;
              case 4: if (*hp && rand()%3) *bp = *hp; break;
              case 5: if (*hp && rand()%4) *bp = *hp; break;
              case 6: if (*hp && rand()%5) *bp = *hp; break;
              default: if (*hp) *bp = *hp;
            }
            bp++; hp++;
          }
        }
      }
  } else if (WeaveCondition.HairEffect==HEShort) {
    fp = (WORD *)bmf->pointer();
    for (iy=0; iy<h; iy+=3) {
      for (ix=0; ix<w; ix+=3) {
        px = (ix+rand()%2)%w;  py = (iy+rand()%2)%h;
        fc = *(WORD *)bmf->pointer((px+rand()%3)%w, (py+rand()%3)%h);
        if (fc) {
          hmp = rand()%5;
          for (y=0; y<3; y++) {
            for (x=0; x<3; x++) {
              if (Hair[WeaveCondition.HairType].sht[hmp][y][x])
                 *(fp+py*w+(px+x)%w) = fc;
            }
            py = (py+1)%h;
          }
        }
      }
    }
    if(WeaveCondition.BackSide){
      bp = (WORD *)bmb->pointer();
      for (iy=0; iy<h; iy+=3) {
        for (ix=0; ix<w; ix+=3) {
          px = (ix+rand()%2)%w;  py = (iy+rand()%2)%h;
          bc = *(WORD *)bmb->pointer((px+rand()%3)%w, (py+rand()%3)%h);
          if (bc) {
            hmp = rand()%5;
            for (y=0; y<3; y++) {
              for (x=0; x<3; x++) {
                if (Hair[WeaveCondition.HairType].sht[hmp][y][x])
                   *(bp+py*w+(px+x)%w) = bc;
              }
              py = (py+1)%h;
            }
          }
        }
      }
    }
  } else if (WeaveCondition.HairEffect==HELong) {
    fp = (WORD *)bmf->pointer();
    for (iy=0; iy<h; iy+=3) {
      for (ix=0; ix<w; ix+=3) {
        px = (ix+rand()%2)%w;  py = (iy+rand()%2)%h;
        fc = *(WORD *)bmf->pointer((px+rand()%7)%w, (py+rand()%7)%h);
        if (fc) {
          hmp = rand()%5;
          for (y=0; y<7; y++) {
            for (x=0; x<7; x++) {
              if (Hair[WeaveCondition.HairType].lng[hmp][y][x])
                 *(fp+py*w+(px+x)%w) = fc;
            }
            py = (py+1)%h;
          }
        }
      }
    }
    if(WeaveCondition.BackSide){
      bp = (WORD *)bmb->pointer();
      for (iy=0; iy<h; iy+=3) {
        for (ix=0; ix<w; ix+=3) {
          px = (ix+rand()%2)%w;  py = (iy+rand()%2)%h;
          bc = *(WORD *)bmb->pointer((px+rand()%7)%w, (py+rand()%7)%h);
          if (bc) {
            hmp = rand()%5;
            for (y=0; y<7; y++) {
              for (x=0; x<7; x++) {
                if (Hair[WeaveCondition.HairType].lng[hmp][y][x])
                   *(bp+py*w+(px+x)%w) = bc;
              }
              py = (py+1)%h;
            }
          }
        }
      }
    }
  } else if (WeaveCondition.HairEffect==HENormal) {
    fp = (WORD *)bmf->pointer();
    for (iy=0; iy<h; iy+=3) {
      for (ix=0; ix<w; ix+=3) {
        px = (ix+rand()%2)%w;   py = (iy+rand()%2)%h;
        fc = *(WORD *)bmf->pointer((px+rand()%5)%w, (py+rand()%5)%h);
        if (fc) {
          hmp = rand()%5;
          for (y=0; y<5; y++) {
            for (x=0; x<5; x++) {
              if (Hair[WeaveCondition.HairType].nml[hmp][y][x])
                 *(fp+py*w+(px+x)%w) = fc;
            }
            py = (py+1)%h;
          }
        }
      }
    }
    if(WeaveCondition.BackSide){
      bp = (WORD *)bmb->pointer();
      for (iy=0; iy<h; iy+=3) {
        for (ix=0; ix<w; ix+=3) {
          px = (ix+rand()%2)%w;   py = (iy+rand()%2)%h;
          bc = *(WORD *)bmb->pointer((px+rand()%5)%w, (py+rand()%5)%h);
          if (bc) {
            hmp = rand()%5;
            for (y=0; y<5; y++) {
              for (x=0; x<5; x++) {
                if (Hair[WeaveCondition.HairType].nml[hmp][y][x])
                   *(bp+py*w+(px+x)%w) = bc;
              }
              py = (py+1)%h;
            }
          }
        }
      }
    }
  }
}
//---------------------------------------------------------------------------
// Public Methods
//---------------------------------------------------------------------------
bool __fastcall TPlan::Init(int x, int y)
{

	if (xwp) delete[] xwp;
  if ((xwp = new int[x])==NULL) goto fail;
	if (ywt) delete[] ywt;
  if ((ywt = new int[y])==NULL) goto fail;
  return true;
fail:
	if (xwp) { delete[] xwp; xwp = NULL; }
	if (ywt) { delete[] ywt; ywt = NULL; }
	return false;

}
//---------------------------------------------------------------------------
TPException __fastcall TPlan::DrawWarpBar(TTexpiaBitmap *Bitmap, RGBQUAD bgColor, bool bBack, int DPI)
{
	TList *Array = Yarn->Array[WARP];
  char c;
  int i, x, y, vx, vy, n, o, r, ic, repeat, tl, tension, s, Crepeat, rs, dd, rn, WarpH;
  int sk, k, sum, scnt, cnt;  
  double al, gs, gt;
  int YarnCnt, YarnLength =0;
  TWeaveData wd;
  TPException ec = EC_NONE;
  TPMemoryArea<WORD> *bmWarpBar;

  PatternDPI = DPI;
  if (Array->Count==0) return ec;
  if(Bitmap){
      Bitmap->FillRect(Rect(0, 0, Bitmap->Width, Bitmap->Height), clBlack);
      WarpH = Bitmap->Height;
  } else {
      WarpH = MainImageForm->ImageWarp->Bitmap->Height*PatternDPI/160;
  }
  InitYarnDot(WARP);
  tension = WeaveCondition.Tension;

  tl = 0; al = tl;
  wd.tc = ic = 0;
  n = 0;
  sk = 0;
  k = 0;
  Crepeat = 0;
  sum = 0;
  cnt = GetCount(WARP);
  scnt = GetSCount(WARP);
  rs = rn = NULL;
  while (((TYarnArray *)Array->Items[n])->code==0) n++;
  o = n;
  repeat = ((TYarnArray *)Array->Items[n])->repeat;
  r = n;
  if (!InitWeaveData(wd, WARP, o)) { ec = EC_HIGH_DENSITY; goto fail; }

  ExitLengthInfo(WARP);
  InitLengthInfo(WARP);
  YarnCnt = GetPatternInfo(WARP, YarnLength);
  ConsiderTextureYarn(WARP, YarnCnt, YarnLength, MainImageForm->ImageWarp->Bitmap->Width*PatternDPI/160);
  if(TotalLength[WARP] == 0) return ec;
  if(WarpBitmap) {delete WarpBitmap;   WarpBitmap = NULL;}
  WarpBitmap = new TTexpiaBitmap;
  if (!WeaveCondition.ColorCorrection) WarpBitmap->Create(TotalExactLength[WARP], WarpH, 16);
  else WarpBitmap->Create(TotalLength[WARP], WarpH, 16);
  bmWarpBar = new TPMemoryArea<WORD>(TotalLength[WARP] + 1, WarpH);    //qe test
  if ((s = getsize(WARP, bmWarpBar->size.x)) == 0) { ec = EC_HIGH_DENSITY; goto fail; }
  if (xwp) {delete[] xwp;  xwp = NULL;}
  xwp = new int[s];
  if(bmWarpBar == NULL) goto fail;
  if(bmWarpBar->lock() == NULL) goto fail;
  while (al+wd.dpy < bmWarpBar->size.x) {
  	 if (wd.dpy>0) {
        if (*(xwp+wd.tc)<=0 || *(xwp+wd.tc)>=wd.l) {
           *(xwp+wd.tc) = rand()%wd.l;
        }
        if (wd.gap>0.0) {
    	     gs = (rand()%int(wd.gap*100))/100.0;
      	   gt = wd.gap/(wd.gap*tension + rand()%10);
        	 for (y=0; y<bmWarpBar->size.y; y++) {
          	  wd.v = al+gs;
  	          if (gt>=0) {
    	           if (gs+gt>=wd.gap) gt = -gt;
      	      } else {
        	       if (gs+gt<0) gt = -gt;
          	  }
  	          gs += gt;
              if (wd.ydye) WarpBar15(bmWarpBar, wd, y);
              else WarpBar8(bmWarpBar, wd, y);
      	   }
  	    } else {
    	      wd.v = al + wd.space;
      	    for (y=0; y<bmWarpBar->size.y; y++) {
        	     if (wd.ydye) WarpBar15(bmWarpBar, wd, y);
               else WarpBar8(bmWarpBar, wd, y);
  	        }
    	  }
      	wd.tc++; ic++;
  	    al += wd.dpy;
    	  if (ic>=wd.yarns) {
           sum += sLength[WARP][sk%scnt];
           if (sum >= Length[WARP][k%cnt]){
              MakeYarnBar(WARP, k, wd, WarpBitmap, bmWarpBar, bgColor, bBack);
              sum = 0;
              k++;
           }
           sk++;
      	   ic = 0;
           tl += data[WARP][data[WARP][o].num].dot; al = tl;
           if (Change(WARP, n, o, r, repeat, Crepeat, rs, rn) == 1) break;
           else if (!InitWeaveData(wd, WARP, o)) { ec = EC_HIGH_DENSITY; goto fail; }
    	  }
     } else {
     	  ic = 0;
        tl += data[WARP][data[WARP][o].num].dot; al = tl;
        if (Change(WARP, n, o, r, repeat, Crepeat, rs, rn) == 1) break;
        else if (!InitWeaveData(wd, WARP, o)) { ec = EC_HIGH_DENSITY; goto fail; }
     }
  }
  if(Bitmap) RepeatBitmap(WARP, Bitmap, WarpBitmap, bBack);
  bmWarpBar->unlock();
  delete bmWarpBar;
  bmWarpBar = NULL;
  ExitYarnDot(WARP);
  delete[] xwp;  xwp = NULL;
  PatternDPI = 160;
  return ec;
fail:
  Bitmap->StopScanLine();
  ExitYarnDot(WARP);
  if(bmWarpBar) {delete bmWarpBar;  bmWarpBar = NULL;}
  delete[] xwp;  xwp = NULL;
  return ec;
}
//---------------------------------------------------------------------------
TPException __fastcall TPlan::DrawWeftBar(TTexpiaBitmap *Bitmap, RGBQUAD bgColor, int DPI)
{
	TList *Array = Yarn->Array[WEFT];
  char c;
  int i, x, y, vx, vy, n, o, r, ic, repeat, tl, tension, s, Crepeat, rs, rn, WeftW;
  int sk, k, sum, scnt, cnt;
  double al, gs, gt;
  int YarnCnt, YarnLength =0;
  TWeaveData wd;
  TPMemoryArea<WORD> *bmWeftBar;
  TPException ec = EC_NONE;

  PatternDPI = DPI;
  if (Array->Count==0) return ec;
  if(Bitmap){
      Bitmap->FillRect(Rect(0, 0, Bitmap->Width, Bitmap->Height), clBlack);
      WeftW = Bitmap->Width;
  } else{
      WeftW = MainImageForm->ImageWeft->Bitmap->Width*PatternDPI/160;
  }
  InitYarnDot(WEFT);
  tension = WeaveCondition.Tension;

  tl = 0; al = tl;
  wd.tc = ic = 0;
  n = 0;
  sk = 0;
  k = 0;
  Crepeat = 0;
  sum = 0;
  cnt = GetCount(WEFT);
  scnt = GetSCount(WEFT);
  rs = rn = NULL;
  while (((TYarnArray *)Array->Items[n])->code==0) n++;
  o = n;
  repeat = ((TYarnArray *)Array->Items[n])->repeat;
  r = n;
  if (!InitWeaveData(wd, WEFT, o)) { ec = EC_HIGH_DENSITY; goto fail; }


    ExitLengthInfo(WEFT);
    InitLengthInfo(WEFT);
    YarnCnt = GetPatternInfo(WEFT, YarnLength);
    ConsiderTextureYarn(WEFT, YarnCnt, YarnLength, MainImageForm->ImageWeft->Bitmap->Height*PatternDPI/160);
    if(TotalLength[WEFT] == 0) return ec;
    if(WeftBitmap) {delete WeftBitmap;    WeftBitmap = NULL;}
    WeftBitmap = new TTexpiaBitmap;
    if (!WeaveCondition.ColorCorrection) WeftBitmap->Create(WeftW, TotalExactLength[WEFT], 16);
    else WeftBitmap->Create(WeftW, TotalLength[WEFT], 16);
    bmWeftBar = new TPMemoryArea<WORD>(WeftW, TotalLength[WEFT]+1);
    if ((s = getsize(WEFT, bmWeftBar->size.y)) == 0) { ec = EC_HIGH_DENSITY; goto fail; }
    if (ywt) {delete[] ywt;   ywt = NULL;}
    ywt = new int[s];
    if(bmWeftBar == NULL) goto fail;
    if(bmWeftBar->lock() == NULL) goto fail;
    if (WeftBitmap->StartScanLine() == false) { ec = EC_MEMORY_LACK; goto fail; }
    while (al+wd.dpy < bmWeftBar->size.y) {
    	if (wd.dpy>0) {
	      if (*(ywt+wd.tc)<=0 || *(ywt+wd.tc)>=wd.l) {
    	    *(ywt+wd.tc) = rand()%wd.l;
      	}
        if (wd.gap>0.0) {
    	    gs = (rand()%int(wd.gap*100))/100.0;
      	  gt = wd.gap/(wd.gap*tension + rand()%10);
//          gt = wd.gap/(16+rand()%10);
          for (x=0; x<bmWeftBar->size.x; x++) {
        	  wd.v = al+gs;
	          if (gt>=0) {
    	        if (gs+gt>=wd.gap) gt = -gt;
      	    } else {
              if (gs+gt<0) gt = -gt;
        	  }
	          gs += gt;
    	      if (wd.ydye) WeftBar15(bmWeftBar, wd, x);
            else WeftBar8(bmWeftBar, wd, x);
      	  }
	      } else {
    	    wd.v = al + wd.space;
      	  for (x=0; x<bmWeftBar->size.x; x++) {
            if (wd.ydye) WeftBar15(bmWeftBar, wd, x);
            else WeftBar8(bmWeftBar, wd, x);
	        }
    	  }
      	wd.tc++; ic++;
	      al += wd.dpy;
    	  if (ic>=wd.yarns) {
      	  ic = 0;
          sum += sLength[WEFT][sk%scnt];
          if (sum >= Length[WEFT][k%cnt]) {
             MakeYarnBar(WEFT, k, wd, WeftBitmap, bmWeftBar, bgColor);
             sum = 0;
             k++;
          }
          sk++;
          tl += data[WEFT][data[WEFT][o].num].dot; al = tl;
          if (Change(WEFT, n, o, r, repeat, Crepeat, rs, rn) == 1) break;
          else if (!InitWeaveData(wd, WEFT, o)) { ec = EC_HIGH_DENSITY; goto fail; }
        }
      } else {
     	  ic = 0;
        tl += data[WEFT][data[WEFT][o].num].dot; al = tl;
        if (Change(WEFT, n, o, r, repeat, Crepeat, rs, rn) == 1) break;
        else if (!InitWeaveData(wd, WEFT, o)) { ec = EC_HIGH_DENSITY; goto fail; }
      }
    }
    WeftBitmap->StopScanLine();
    if(Bitmap) RepeatBitmap(WEFT, Bitmap, WeftBitmap);
    bmWeftBar->unlock();
    delete bmWeftBar; bmWeftBar = NULL;

  ExitYarnDot(WEFT);
  delete[] ywt; ywt = NULL;
  PatternDPI = 160;
  return ec;
fail:
  Bitmap->StopScanLine();
  ExitYarnDot(WEFT);
  if(bmWeftBar) {delete bmWeftBar;  bmWeftBar = NULL;}
  delete[] ywt;   ywt = NULL;
  return ec;
}
//---------------------------------------------------------------------------

void __fastcall TPlan::calc_weave(TTexpiaBitmap *Bitmap, RGBQUAD bgColor, int DPI)
{
  char *tp;
  WORD *bf = NULL, *bb = NULL, *bhf = NULL, *bhb = NULL;
  int x, y, lx, ly, code, ti, i, j, s, canvas, StartPos, EndPos, pcnt;
  int n[2], o[2], r[2], ic[2], tc[2], repeat[2], tl[2], yarns[2], Crepeat[2], rs[2], rn[2];
  double al[2];
  int YarnCnt[2], YarnLength = 0;
  WORD *pFront = NULL, *pWeft = NULL, *pHighFront;
	TList *ArrayWarp = Yarn->Array[WARP];
	TList *ArrayWeft = Yarn->Array[WEFT];

  if (WeaveCondition.HairEffect == HENone) PatternDPI = DPI;
  else {PatternDPI = 160;   DPI = 160;}

  StatusProgress->Maximum = 100;

  TCursor OldCursor = Screen->Cursor;
  Screen->Cursor = crHourGlass;

  StatusProgress->Position = 5;
  // 縦 ġϱ   .
  InitYarnDot(WARP);

  StatusProgress->Position = 10;
  // 縦 ġϱ   .
  InitYarnDot(WEFT);

  StatusProgress->Position = 15;

  ExitLengthInfo(WARP);
  ExitLengthInfo(WEFT);
  InitLengthInfo(WARP);
  InitLengthInfo(WEFT);

  YarnCnt[WARP] = GetPatternInfo(WARP, YarnLength);
  YarnCnt[WEFT] = GetPatternInfo(WEFT, YarnLength);
  if(Bitmap){
     ConsiderTextureYarn(WARP, YarnCnt[WARP], YarnLength, Bitmap->Width);
     ConsiderTextureYarn(WEFT, YarnCnt[WEFT], YarnLength, Bitmap->Height);
  }else {
     ConsiderTextureYarn(WARP, YarnCnt[WARP], YarnLength, MainImageForm->iMainImage->Bitmap->Width*PatternDPI/160);
     ConsiderTextureYarn(WEFT, YarnCnt[WEFT], YarnLength, MainImageForm->iMainImage->Bitmap->Height*PatternDPI/160);
  }
  WeaveCondition.bmWidth = TotalLength[WARP]+1;
  WeaveCondition.bmHeight = TotalLength[WEFT]+1;

  //  bitmap  - 縦 ġ bitmap
  bmWarp = new TPMemoryArea<WORD>(TotalLength[WARP]+1, TotalLength[WEFT]+1);
  if (bmWarp == NULL) goto fail;
  if (bmWarp->lock() == NULL) goto fail;
  //  bitmap  - 縦 ġ bitmap
  bmWeft = new TPMemoryArea<WORD>(TotalLength[WARP]+1, TotalLength[WEFT]+1);
  if (bmWeft == NULL) goto fail;
  if (bmWeft->lock() == NULL) goto fail;
  // Hair effect bitmap 
  bmHair = new TPMemoryArea<WORD>(TotalLength[WARP]+1, TotalLength[WEFT]+1);
  if (bmHair == NULL) goto fail;
  if (bmHair->lock() == NULL) goto fail;

  // 縦 ġѴ.
  calc_warp();
  StatusProgress->Position = 22;
  // 縦 ġѴ.
  calc_weft();
  StatusProgress->Position = 30;

  if(PatternDPI < 320) {
    // (ո) bitmap 
    if(bmFront) {delete bmFront; bmFront = NULL;}
    if (bmFront==NULL) {
	    bmFront = new TPMemoryArea<WORD>(TotalLength[WARP]+1, TotalLength[WEFT]+1);
      if (bmFront == NULL) goto fail;
    }
    bf = bmFront->lock();
    if (bf == NULL) goto fail;
    // (ո) bitmap  bitmap 
    *bmFront = *bmWarp;
    // (ո) bitmap   ʴ   bitmap о 
    pFront = bmFront->pointer();
    pWeft = bmWeft->pointer();
    for (i=0; i<bmFront->size.y; i++) {
      for (j=0; j<bmFront->size.x; j++, pFront++, pWeft++) {
        if (*pWeft!=0 && *pFront==0) *pFront = *pWeft;
      }
    }
    if(bmBack) {delete bmBack; bmBack = NULL;}
    if (bmBack==NULL) {
      bmBack = new TPMemoryArea<WORD>(TotalLength[WARP]+1, TotalLength[WEFT]+1);
      if (bmBack == NULL) goto fail;
    }
    bb = bmBack->lock();
    if (bb == NULL) goto fail;
    *bmBack = *bmFront;
  } else { // ػ󵵸  bitmap.. ϸ öü Ű⶧
    if(bmHighFront) {delete bmHighFront; bmHighFront = NULL;}
    if (bmHighFront==NULL) {
	    bmHighFront = new TPMemoryArea<WORD>(TotalLength[WARP]+1, TotalLength[WEFT]+1);
      if (bmHighFront == NULL) goto fail;
    }
    bhf = bmHighFront->lock();
    if (bhf == NULL) goto fail;
    // (ո) bitmap  bitmap 
    *bmHighFront = *bmWarp;
    // (ո) bitmap   ʴ   bitmap о 
    pHighFront = bmHighFront->pointer();
    pWeft = bmWeft->pointer();
    for (i=0; i<bmHighFront->size.y; i++) {
      for (j=0; j<bmHighFront->size.x; j++, pHighFront++, pWeft++) {
        if (*pWeft!=0 && *pHighFront==0) *pHighFront = *pWeft;
      }
    }
    if(bmHighBack) {delete bmHighBack; bmHighBack = NULL;}
    if (bmHighBack==NULL) {
      bmHighBack = new TPMemoryArea<WORD>(TotalLength[WARP]+1, TotalLength[WEFT]+1);
      if (bmHighBack == NULL) goto fail;
    }
    bhb = bmHighBack->lock();
    if (bhb == NULL) goto fail;
    *bmHighBack = *bmHighFront;
  }

  tl[WEFT] = tl[WARP] = 0;
  al[WEFT] = al[WARP] = 0.0;
  ic[WEFT] = ic[WARP] = 0;
  n[WEFT] = n[WARP] = 0;
  o[WEFT] = o[WARP] = 0;
  r[WEFT] = r[WARP] = 0;
  Crepeat[WEFT] = Crepeat[WARP] = 0;
  rs[WEFT] = rs[WARP] = NULL;
  rn[WEFT] = rn[WARP] = NULL;
  repeat[WARP] = ((TYarnArray *)ArrayWarp->Items[n[WARP]])->repeat;
  repeat[WEFT] = ((TYarnArray *)ArrayWeft->Items[n[WEFT]])->repeat;

  dpy[WARP] = (double)data[WARP][data[WARP][o[WARP]].num].dot/
      ((TYarnArray *)ArrayWarp->Items[o[WARP]])->yarns;
  dpy[WEFT] = (double)data[WEFT][data[WEFT][o[WEFT]].num].dot/
      ((TYarnArray *)ArrayWeft->Items[o[WEFT]])->yarns;
  yarns[WARP] = ((TYarnArray *)ArrayWarp->Items[o[WARP]])->yarns;
  yarns[WEFT] = ((TYarnArray *)ArrayWeft->Items[o[WEFT]])->yarns;

  tc[WEFT] = tc[WARP] = 0;
  ti = 0;
  lx = Texture->Choice[PATTERN].width;
  ly = Texture->Choice[PATTERN].height;
  tp = Texture->Choice[PATTERN].data;
  while (1) {
    v[WARP] = al[WARP]; v[WEFT] = al[WEFT];
    if (*(tp+tc[WARP]%lx)) {
        if(PatternDPI < 320) {
          texture_warp(bmFront);
          texture_weft(bmBack);
        } else {
          texture_warp(bmHighFront);
          texture_weft(bmHighBack);
        }
    } else {
        if(PatternDPI < 320) {
          texture_weft(bmFront);
          texture_warp(bmBack);
        } else {
          texture_weft(bmHighFront);
          texture_warp(bmHighBack);
        }
    }

    tc[WARP]++;
    ic[WARP]++;
    al[WARP] += dpy[WARP];
    if (al[WARP]<TotalLength[WARP]) {
      if (ic[WARP]>=yarns[WARP]) {
        ic[WARP] = 0;
        Change(WARP, n[WARP], o[WARP], r[WARP], repeat[WARP], Crepeat[WARP], rs[WARP], rn[WARP]);
        dpy[WARP] = (double)data[WARP][data[WARP][o[WARP]].num].dot/
            ((TYarnArray *)ArrayWarp->Items[o[WARP]])->yarns;
        yarns[WARP] = ((TYarnArray *)ArrayWarp->Items[o[WARP]])->yarns;
      }
    } else {
      tl[WARP] = 0; al[WARP] = 0.0;
      n[WARP] = o[WARP] = r[WARP] = 0;
      repeat[WARP] = ((TYarnArray *)ArrayWarp->Items[n[WARP]])->repeat;
      dpy[WARP] = (double)data[WARP][data[WARP][o[WARP]].num].dot/
          ((TYarnArray *)ArrayWarp->Items[o[WARP]])->yarns;
      yarns[WARP] = ((TYarnArray *)ArrayWarp->Items[o[WARP]])->yarns;
      ic[WARP] = 0;
      tc[WARP] = 0; tc[WEFT]++;
      tp = Texture->Choice[PATTERN].data+(tc[WEFT]%ly)*lx;
      ic[WEFT]++;
      al[WEFT] += dpy[WEFT];
      if (al[WEFT]<TotalLength[WEFT]) {
        if (ic[WEFT]>=yarns[WEFT]) {
          ic[WEFT] = 0;
          tl[WEFT] += data[WEFT][data[WEFT][o[WEFT]].num].dot;
          al[WEFT] = tl[WEFT];
          Change(WEFT, n[WEFT], o[WEFT], r[WEFT], repeat[WEFT], Crepeat[WEFT], rs[WEFT], rn[WEFT]);
          dpy[WEFT] = (double)data[WEFT][data[WEFT][o[WEFT]].num].dot/
              ((TYarnArray *)ArrayWeft->Items[o[WEFT]])->yarns;
           yarns[WEFT] = ((TYarnArray *)ArrayWeft->Items[o[WEFT]])->yarns;
        }
      } else break;
    }
  }
  StatusProgress->Position = 40;
  StartPos = 40;
  pcnt = 30;
  dummyCnt = 0;
  if (WeaveCondition.HairEffect == HEShort || WeaveCondition.HairEffect == HENormal
     || WeaveCondition.HairEffect == HELong ) {// ȿ ϰ ̰ ϱ     
    s = bmFront->size.x*bmFront->size.y;
    canvas = MainImageForm->iMainImage->Bitmap->Width*MainImageForm->iMainImage->Bitmap->Height;
    if (s >= canvas/2) dummyCnt = 0;
    else if (s >= canvas/4) dummyCnt = 1;
    else if (s >= canvas/8) dummyCnt = 2;
    else if (s >= canvas/16) dummyCnt = 3;
    else if (s >= canvas/32) dummyCnt = 4;
    else dummyCnt = 5;
    if (WeaveCondition.BackSide) pcnt = 60/(dummyCnt*2+2);
    else pcnt = 60/(dummyCnt+2);
    for (i=0; i<dummyCnt; i++) {
      if (WeaveCondition.BackSide) {
        if (bmDummy[i]) {delete bmDummy[i];   bmDummy[i] = NULL;}
        bmDummy[i] = new TPMemoryArea<WORD>(TotalLength[WARP]+1, TotalLength[WEFT]+1);
        if (bmDummy[i] == NULL) goto fail;
        if (bmDummy[i]->lock() == NULL) goto fail;
        *bmDummy[i] = *bmFront;
        if (bmDummyBack[i]) {delete bmDummyBack[i];  bmDummyBack[i] = NULL;}
        bmDummyBack[i] = new TPMemoryArea<WORD>(TotalLength[WARP]+1, TotalLength[WEFT]+1);
        if (bmDummyBack[i] == NULL) goto fail;
        if (bmDummyBack[i]->lock() == NULL) goto fail;
        *bmDummyBack[i] = *bmBack;
        calc_hair(bmDummy[i], bmDummyBack[i]);

        if(PatternDummy[i]) {delete PatternDummy[i];  PatternDummy[i] = NULL;}
        PatternDummy[i] = new TTexpiaBitmap;
        if (!WeaveCondition.ColorCorrection) PatternDummy[i]->Create(TotalExactLength[WARP],TotalExactLength[WEFT], 16);
        else PatternDummy[i]->Create(TotalLength[WARP], TotalLength[WEFT], 16);
        MakePatternBitmap(PatternDummy[i], bmDummy[i], bgColor, StartPos, pcnt );
        StartPos += pcnt;
        if(BackPatternDummy[i]) {delete BackPatternDummy[i];  BackPatternDummy[i] = NULL;}
        BackPatternDummy[i] = new TTexpiaBitmap;
        if (!WeaveCondition.ColorCorrection) BackPatternDummy[i]->Create(TotalExactLength[WARP],TotalExactLength[WEFT], 16);
        else BackPatternDummy[i]->Create(TotalLength[WARP], TotalLength[WEFT], 16);
        MakePatternBitmap(BackPatternDummy[i], bmDummyBack[i], bgColor, StartPos, pcnt);
        StartPos += pcnt;
        bmDummy[i]->unlock();
        bmDummyBack[i]->unlock();
      } else {
        if (bmDummy[i]) delete bmDummy[i];
        bmDummy[i] = new TPMemoryArea<WORD>(TotalLength[WARP]+1, TotalLength[WEFT]+1);
        if (bmDummy[i] == NULL) goto fail;
        if (bmDummy[i]->lock() == NULL) goto fail;
        *bmDummy[i] = *bmFront;
        calc_hair(bmDummy[i], NULL);
        if(PatternDummy[i]) {delete PatternDummy[i];  PatternDummy[i] = NULL;}
        PatternDummy[i] = new TTexpiaBitmap;
        if (!WeaveCondition.ColorCorrection) PatternDummy[i]->Create(TotalExactLength[WARP],TotalExactLength[WEFT], 16);
        else PatternDummy[i]->Create(TotalLength[WARP], TotalLength[WEFT], 16);
        pcnt = 60/(dummyCnt+2);
        MakePatternBitmap(PatternDummy[i], bmDummy[i], bgColor, StartPos, pcnt);
        StartPos += pcnt;
        bmDummy[i]->unlock();
      }
    }
  }
  calc_hair(bmFront, bmBack);

  if(PatternDPI < 320) {
    if(PatternBitmap) {delete PatternBitmap;  PatternBitmap = NULL;}
    PatternBitmap = new TTexpiaBitmap;
    if (!WeaveCondition.ColorCorrection) PatternBitmap->Create(TotalExactLength[WARP],TotalExactLength[WEFT], 16);
    else PatternBitmap->Create(TotalLength[WARP], TotalLength[WEFT], 16);
    MakePatternBitmap(PatternBitmap, bmFront, bgColor, StartPos, pcnt);
    StartPos += pcnt;
    if(BackPatternBitmap) {delete BackPatternBitmap;  BackPatternBitmap = NULL;}
    BackPatternBitmap = new TTexpiaBitmap;
    if (!WeaveCondition.ColorCorrection) BackPatternBitmap->Create(TotalExactLength[WARP],TotalExactLength[WEFT], 16);
    else BackPatternBitmap->Create(TotalLength[WARP], TotalLength[WEFT], 16);
    MakePatternBitmap(BackPatternBitmap, bmBack, bgColor, StartPos, pcnt);
    StartPos += pcnt;
  } else {
    if(HighPatternBitmap) {delete HighPatternBitmap;  HighPatternBitmap = NULL;}
    HighPatternBitmap = new TTexpiaBitmap;
    if (!WeaveCondition.ColorCorrection) HighPatternBitmap->Create(TotalExactLength[WARP],TotalExactLength[WEFT], 16);
    else HighPatternBitmap->Create(TotalLength[WARP], TotalLength[WEFT], 16);
    MakePatternBitmap(HighPatternBitmap, bmHighFront, bgColor, StartPos, pcnt);
    StartPos += pcnt;
    if(HighBackPatternBitmap) {delete HighBackPatternBitmap;  HighBackPatternBitmap = NULL;}
    HighBackPatternBitmap = new TTexpiaBitmap;
    if (!WeaveCondition.ColorCorrection) HighBackPatternBitmap->Create(TotalExactLength[WARP],TotalExactLength[WEFT], 16);
    else HighBackPatternBitmap->Create(TotalLength[WARP], TotalExactLength[WEFT], 16);
    MakePatternBitmap(HighBackPatternBitmap, bmHighBack, bgColor, StartPos, pcnt);
    StartPos += pcnt;
  }
  ExitYarnDot(WARP);
  ExitYarnDot(WEFT);
  bmWarp->unlock();  delete bmWarp;  bmWarp = NULL;
  bmWeft->unlock();  delete bmWeft;  bmWeft = NULL;
  bmHair->unlock();  delete bmHair;  bmHair = NULL;
  if(PatternDPI < 320) {
     bmFront->unlock();
     bmBack->unlock();
  } else {
     bmHighFront->unlock();
     bmHighBack->unlock();
  }
  PatternDPI = 160;
  Screen->Cursor = OldCursor;
  StatusProgress->Position = 100;
  StatusProgress->End();
  return;
fail:
  ExitYarnDot(WARP);
  ExitYarnDot(WEFT);
  if (bmWarp) {delete bmWarp;   bmWarp = NULL;}
  if (bmWeft) {delete bmWeft;   bmWeft = NULL;}
  if (bmHair) {delete bmHair;   bmHair = NULL;}
  if (bf) bmFront->unlock();
  if (bb) bmBack->unlock();
  if (bhf) bmHighFront->unlock();
  if (bhb) bmHighBack->unlock();
  Screen->Cursor = OldCursor;
  StatusProgress->End();
  EXCEPTION_MESSAGE_OK(EC_MEMORY_LACK);
}
//---------------------------------------------------------------------------

void __fastcall TPlan::DrawFront(TTexpiaBitmap *Bitmap, int DPI)
{
  WORD *sp, *dp;
  TTexpiaBitmap *TempBitmap;
  int u, v, x, y, index;
  PatternDPI = DPI;
  if(PatternDPI < 320){
    if (PatternBitmap == NULL) return;
    TempBitmap = PatternBitmap;
  }else {
    if (HighPatternBitmap == NULL) return;
    TempBitmap = HighPatternBitmap;
  }

  u = v = 0;
  if(Bitmap->StartScanLine() == false) goto fail;
  while (1) {
    if (dummyCnt) {
       index = rand()%dummyCnt;
       if(index)  TempBitmap = PatternDummy[index-1];
       else TempBitmap = PatternBitmap;
    }
    if(TempBitmap->StartScanLine() == false) goto fail;
    for (y = 0; y < TempBitmap->Height; y++) {
      if (v+y < Bitmap->Height) {
        dp = (WORD *)Bitmap->GetScanLine(Bitmap->Height-1-(v+y));
        sp = (WORD *)TempBitmap->GetScanLine(TempBitmap->Height -1- y);
        for (x = 0; x < TempBitmap->Width; x++,sp++) {
          if (u+x < Bitmap->Width) *(dp+u+x) = *sp;
        }
        Bitmap->PutScanLine(Bitmap->Height-1-(v+y));
      }
    }
    u += TempBitmap->Width;
    TempBitmap->StopScanLine();
    if (u >= Bitmap->Width) {
      u = 0;
      v += TempBitmap->Height;
      if ( v >= Bitmap->Height) break;
    }
  }
  Bitmap->StopScanLine();

  /*if(Bitmap->StartScanLine() == false) goto fail;
  if(TempBitmap->StartScanLine() == false) goto fail;
  for(int y = 0, IndexY = 0; y < Bitmap->Height; y++, IndexY++) {
     dp = (WORD *)Bitmap->GetScanLine(Bitmap->Height-1-y);
     sp = (WORD *)TempBitmap->GetScanLine(TempBitmap->Height -1- IndexY);
     for(int x = 0, IndexX = 0; x < Bitmap->Width; x++, dp++, IndexX++ ) {
        *dp = *(sp + IndexX);
        if(IndexX == TempBitmap->Width -1) IndexX = -1;
     }
     Bitmap->PutScanLine(Bitmap->Height-1-y);
     if(IndexY == TempBitmap->Height -1) IndexY = -1;
  }

  TempBitmap = NULL;*/
  PatternDPI = 160;
  return;
fail:
  Bitmap->StopScanLine();
  TempBitmap->StopScanLine();
  EXCEPTION_MESSAGE_OK(EC_MEMORY_LACK);
}
//---------------------------------------------------------------------------

void __fastcall TPlan::DrawBack(TTexpiaBitmap *Bitmap, int DPI)
{
  WORD *sp, *dp;
  TTexpiaBitmap *TempBitmap;
  PatternDPI = DPI;
  if(PatternDPI < 320){
    if (BackPatternBitmap == NULL) return;
    TempBitmap = BackPatternBitmap;
  }else {
    if (HighBackPatternBitmap == NULL) return;
    TempBitmap = HighBackPatternBitmap;
  }
  if(Bitmap->StartScanLine() == false) goto fail;
  if(TempBitmap->StartScanLine() == false) goto fail;
  for(int y = 0, IndexY = 0; y < Bitmap->Height; y++, IndexY++) {
     dp = (WORD *)Bitmap->GetScanLine(Bitmap->Height - y -1) + Bitmap->Width-1;;
     sp = (WORD *)TempBitmap->GetScanLine(TempBitmap->Height - IndexY -1);
     for(int x = 0, IndexX = 0; x < Bitmap->Width; x++, dp--, IndexX++ ) {
        *dp = *(sp + IndexX);
        if(IndexX == TempBitmap->Width -1) IndexX = -1;
     }
     Bitmap->PutScanLine(Bitmap->Height-1-y);
     if(IndexY == TempBitmap->Height -1) IndexY = -1;
  }
  Bitmap->StopScanLine();
  TempBitmap->StopScanLine();
  PatternDPI = 160;
  return;
fail:
  Bitmap->StopScanLine();
  TempBitmap->StopScanLine();
  EXCEPTION_MESSAGE_OK(EC_MEMORY_LACK);
}
//---------------------------------------------------------------------------

bool __fastcall TPlan::CheckFrontBackPrint()
{
  bool CheckbmBack;
  if(bmBack) {
    CheckbmBack = true;
  } else {
    CheckbmBack = false;
  }
  return(CheckbmBack);
}
//---------------------------------------------------------------------------
void __fastcall TPlan::ChangeColorFront(TTexpiaBitmap *Bitmap, RGBQUAD bgColor, bool IsBackGround)
{
  WORD *sp, *dp, yc;
  int x, y;
  WORD *bf = NULL;
  if(bmFront) {
    if(PatternBitmap) {delete PatternBitmap;  PatternBitmap = NULL;}
    PatternBitmap = new TTexpiaBitmap;
    if (!WeaveCondition.ColorCorrection) PatternBitmap->Create(TotalExactLength[WARP],TotalExactLength[WEFT], 16);
    else PatternBitmap->Create(TotalLength[WARP], TotalLength[WEFT], 16);
    bf = bmFront->lock();
    if(bf == NULL) goto fail;
    MakePatternBitmap(PatternBitmap, bmFront, bgColor, 0, 100);
    bmFront->unlock();
    for (int i = 0; i < dummyCnt; i++){
       if (PatternDummy[i]) delete PatternDummy[i];
       PatternDummy[i] = new TTexpiaBitmap;
       if (!WeaveCondition.ColorCorrection) PatternDummy[i]->Create(TotalExactLength[WARP],TotalExactLength[WEFT], 16);
       else PatternDummy[i]->Create(TotalLength[WARP], TotalLength[WEFT], 16);
       if (bmDummy[i]->lock() == NULL) goto fail;
       MakePatternBitmap(PatternDummy[i], bmDummy[i], bgColor, 0, 100);
       bmDummy[i]->unlock();
    }
    DrawFront(Bitmap);
  } else {
    if(IsBackGround){
      yc = RGBToColor15(bgColor);
      if (Bitmap->StartScanLine() == false) goto fail;
      for (y = 0; y < Bitmap->Height; y++) {
		 	  dp = (WORD *) Bitmap->GetScanLine(y);
        for (x = 0; x < Bitmap->Width; x++, dp++) {
          *dp = yc;
        }
  		  Bitmap->PutScanLine(y);
		  }
  	  Bitmap->StopScanLine();
    }
  }
  return;
fail:
	Bitmap->StopScanLine();
  if (bf) bmFront->unlock();
  EXCEPTION_MESSAGE_OK(EC_MEMORY_LACK);

}
//---------------------------------------------------------------------------
void __fastcall TPlan::ChangeColorBack(TTexpiaBitmap *Bitmap, RGBQUAD bgColor, bool IsBackGround)
{
  WORD *sp, *dp, yc;
  int x, y;
  WORD *bb = NULL;
  if(bmBack) {
     if(BackPatternBitmap) {delete BackPatternBitmap;  BackPatternBitmap = NULL;}
     BackPatternBitmap = new TTexpiaBitmap;
     if (!WeaveCondition.ColorCorrection) BackPatternBitmap->Create(TotalExactLength[WARP],TotalExactLength[WEFT], 16);
     else BackPatternBitmap->Create(TotalLength[WARP], TotalLength[WEFT], 16);
     bb = bmBack->lock();
     if(bb == NULL) goto fail;
     MakePatternBitmap(BackPatternBitmap, bmBack, bgColor, 0, 100);
     bmBack->unlock();
     for (int i = 0; i < dummyCnt; i++){
        if(BackPatternDummy[i]) delete BackPatternDummy[i];
        if (!WeaveCondition.ColorCorrection) BackPatternDummy[i]->Create(TotalExactLength[WARP],TotalExactLength[WEFT], 16);
        else BackPatternDummy[i]->Create(TotalLength[WARP], TotalLength[WEFT], 16);
        if (bmDummyBack[i]->lock() == NULL) goto fail;
        MakePatternBitmap(BackPatternDummy[i], bmDummyBack[i], bgColor, 0, 100);
        bmDummyBack[i]->unlock();
     }
     DrawBack(Bitmap);
  } else {
    if(IsBackGround){
      yc = RGBToColor15(bgColor);
      if (Bitmap->StartScanLine() == false) goto fail;
      for (y = 0; y < Bitmap->Height; y++) {
		   	dp = (WORD *) Bitmap->GetScanLine(y);
        for (x = 0; x < Bitmap->Width; x++, dp++) {
          *dp = yc;
        }
  		  Bitmap->PutScanLine(y);
		  }
     	Bitmap->StopScanLine();
    }
  }
  return;
fail:
	Bitmap->StopScanLine();
  if (bb) bmBack->unlock();
  EXCEPTION_MESSAGE_OK(EC_MEMORY_LACK);
}
//---------------------------------------------------------------------------
void __fastcall TPlan::ChangeColorFront(TTexpiaBitmap *Bitmap, WORD *yc, int cnt)
{
	WORD *sp, *dp, c;
  COLORREF rgb;
  TGradeColor **ydc;
  WORD *bf = NULL;

	if (bmFront) {
    bf = bmFront->lock();
    if (bf == NULL) goto fail;
 	  if (Bitmap->StartScanLine() == false) goto fail;
		if (WeaveCondition.WovenEffect==WESolid) {
	  	for (int y=0; y<bmFront->size.y; y++) {
		  	sp = bmFront->pointer(0, bmFront->size.y-1-y);
			 	dp = (WORD *)Bitmap->GetScanLine(y);
		  	for (int x=0; x<bmFront->size.x; x++, sp++, dp++) {
          for (int i=0; i<cnt; i++) {
      			if (*sp && (*sp&0x1FF8)==yc[i] && ~(*sp & 0x8000)) {
             	c = *sp & 0x1FFF;
		  		  	ydc = Yarn->Choice[c>>11].Color[(c>>8)&7];
 	      			*dp = RGBToColor15(ydc[(c>>3)&0x1F]->GetColor(0)->RGB);
              break;
            }
		      }
  		  }
  			Bitmap->PutScanLine(y);
		  }
    } else if (WeaveCondition.WovenEffect==WETypeA) {
	  	for (int y=0; y<bmFront->size.y; y++) {
		  	sp = bmFront->pointer(0, bmFront->size.y-1-y);
			 	dp = (WORD *)Bitmap->GetScanLine(y);
		  	for (int x=0; x<bmFront->size.x; x++, sp++, dp++) {
          for (int i=0; i<cnt; i++) {
      			if (*sp && (*sp&0x1FF8)==yc[i] && ~(*sp & 0x8000)) {
             	c = *sp & 0x1FFF;
		  		  	ydc = Yarn->Choice[c>>11].Color[(c>>8)&7];
 			      	*dp = RGBToColor15(ydc[(c>>3)&0x1F]->GetColor((c&7)-4)->RGB);
              break;
            }
		      }
  		  }
  			Bitmap->PutScanLine(y);
		  }
	  } else {
	  	for (int y=0; y<bmFront->size.y; y++) {
		  	sp = bmFront->pointer(0, bmFront->size.y-1-y);
			 	dp = (WORD *)Bitmap->GetScanLine(y);
		  	for (int x=0; x<bmFront->size.x; x++, sp++, dp++) {
          for (int i=0; i < cnt; i++) {
      			if (*sp && (*sp&0x1FF8)==yc[i] && ~(*sp & 0x8000)) {
             	c = *sp & 0x1FFF;
		  		  	ydc = Yarn->Choice[c>>11].Color[(c>>8)&7];
              if (*sp&0x4000) {
	     	  			*dp = RGBToColor15(ydc[(c>>3)&0x1F]->GetColor((c&7)>>1)->RGB);
              } else {
	     			  	*dp = RGBToColor15(ydc[(c>>3)&0x1F]->GetColor(-((c&7)>>1))->RGB);
              }
              break;
            }
		      }
  		  }
  			Bitmap->PutScanLine(y);
		  }
    }
  	Bitmap->StopScanLine();
    bmFront->unlock();
  }
  return;
fail:
	Bitmap->StopScanLine();
  if (bf) bmFront->unlock();
  EXCEPTION_MESSAGE_OK(EC_MEMORY_LACK);
}
//---------------------------------------------------------------------------
void __fastcall TPlan::ChangeColorBack(TTexpiaBitmap *Bitmap, WORD *yc, int cnt)
{
	WORD *sp, *dp, c;
  COLORREF rgb;
  TGradeColor **ydc;
  WORD *bb = NULL;

	if (bmBack) {
    bb = bmBack->lock();
    if (bb == NULL) goto fail;
	  if (Bitmap->StartScanLine() == false) goto fail;
		if (WeaveCondition.WovenEffect==WESolid) {
	  	for (int y=0; y<bmBack->size.y; y++) {
		  	sp = bmBack->pointer(0, bmBack->size.y-1-y);
			 	dp = (WORD *)Bitmap->GetScanLine(y)+Bitmap->Width-1;
		  	for (int x=0; x<bmBack->size.x; x++, sp++, dp--) {
          for (int i=0; i<cnt; i++) {
      			if (*sp && (*sp&0x1FF8)==yc[i] && ~(*sp & 0x8000)) {
             	c = *sp & 0x1FFF;
			  	  	ydc = Yarn->Choice[c>>11].Color[(c>>8)&7];
 	    	  		*dp = RGBToColor15(ydc[(c>>3)&0x1F]->GetColor(0)->RGB);
              break;
  		      }
          }
  		  }
	  		Bitmap->PutScanLine(y);
		  }
    } else if (WeaveCondition.WovenEffect==WETypeA) {
	  	for (int y=0; y<bmBack->size.y; y++) {
		  	sp = bmBack->pointer(0, bmBack->size.y-1-y);
			 	dp = (WORD *)Bitmap->GetScanLine(y)+Bitmap->Width-1;
		  	for (int x=0; x<bmBack->size.x; x++, sp++, dp--) {
          for (int i=0; i<cnt; i++) {
      			if (*sp && (*sp&0x1FF8)==yc[i] && ~(*sp & 0x8000)) {
             	c = *sp & 0x1FFF;
		  		  	ydc = Yarn->Choice[c>>11].Color[(c>>8)&7];
 			      	*dp = RGBToColor15(ydc[(c>>3)&0x1F]->GetColor((c&7)-4)->RGB);
              break;
            }
		      }
  		  }
	  		Bitmap->PutScanLine(y);
		  }
	  } else {
	  	for (int y=0; y<bmBack->size.y; y++) {
		  	sp = bmBack->pointer(0, bmBack->size.y-1-y);
			 	dp = (WORD *)Bitmap->GetScanLine(y)+Bitmap->Width-1;
		  	for (int x=0; x<bmBack->size.x; x++, sp++, dp--) {
          for (int i=0; i<cnt; i++) {
      			if (*sp && (*sp&0x1FF8)==yc[i] && ~(*sp & 0x8000)) {
             	c = *sp & 0x1FFF;
		  		  	ydc = Yarn->Choice[c>>11].Color[(c>>8)&7];
              if (*sp&0x4000) {
	     	  			*dp = RGBToColor15(ydc[(c>>3)&0x1F]->GetColor((c&7)>>1)->RGB);
              } else {
	     			  	*dp = RGBToColor15(ydc[(c>>3)&0x1F]->GetColor(-((c&7)>>1))->RGB);
              }
              break;
            }
		      }
  		  }
	  		Bitmap->PutScanLine(y);
		  }
    }
  	Bitmap->StopScanLine();
    bmBack->unlock();
  }
  return;
fail:
	Bitmap->StopScanLine();
  if (bb) bmBack->unlock();
  EXCEPTION_MESSAGE_OK(EC_MEMORY_LACK);
}
//---------------------------------------------------------------------------

void __fastcall TPlan::ChangeBackGroundColorFront(TTexpiaBitmap *Bitmap, WORD yc)
{
	WORD *sp, *dp;
  int x, y;
  WORD *bf = NULL;

	if (bmFront) {
    bf = bmFront->lock();
    if (bf == NULL) goto fail;
    if (Bitmap->StartScanLine() == false) goto fail;
	  for (y = 0; y < bmFront->size.y; y++) {
		 	sp = bmFront->pointer(0, bmFront->size.y-1-y);
		 	dp = (WORD *) Bitmap->GetScanLine(y);
		 	for (x = 0; x < bmFront->size.x; x++, sp++, dp++) {
    		if (*sp == 0) *dp = yc;
  	  }
  		Bitmap->PutScanLine(y);
		}
  	Bitmap->StopScanLine();
    bmFront->unlock();
  } else {
    if (Bitmap->StartScanLine() == false) goto fail;
    for (y = 0; y < Bitmap->Height; y++) {
		 	dp = (WORD *) Bitmap->GetScanLine(y);
      for (x = 0; x < Bitmap->Width; x++, dp++) {
        *dp = yc;
      }
  		Bitmap->PutScanLine(y);
		}
  	Bitmap->StopScanLine();
  }
  return;
fail:
	Bitmap->StopScanLine();
  if (bf) bmFront->unlock();
  EXCEPTION_MESSAGE_OK(EC_MEMORY_LACK);
}
//---------------------------------------------------------------------------
void __fastcall TPlan::ChangeBackGroundColorBack(TTexpiaBitmap *Bitmap, WORD yc)
{
	WORD *sp, *dp;
  int x, y;
  WORD *bb = NULL;

	if (bmBack) {
    bb = bmBack->lock();
    if (bb == NULL) goto fail;
	  if (Bitmap->StartScanLine() == false) goto fail;
	  for (y = 0; y < bmBack->size.y; y++) {
		 	sp = bmBack->pointer(0, bmBack->size.y-1-y);
		 	dp = (WORD *) Bitmap->GetScanLine(y);
		 	for (x = 0; x < bmBack->size.x; x++, sp++, dp++) {
    		if (*sp == 0) *dp = yc;
  	  }
  		Bitmap->PutScanLine(y);
		}
  	Bitmap->StopScanLine();
    bmBack->unlock();
  } else {
    if (Bitmap->StartScanLine() == false) goto fail;
    for (y = 0; y < Bitmap->Height; y++) {
		 	dp = (WORD *) Bitmap->GetScanLine(y);
      for (x = 0; x < Bitmap->Width; x++, dp++) {
        *dp = yc;
      }
  		Bitmap->PutScanLine(y);
		}
  	Bitmap->StopScanLine();
  }
  return;
fail:
	Bitmap->StopScanLine();
  if (bb) bmBack->unlock();
  EXCEPTION_MESSAGE_OK(EC_MEMORY_LACK);
}
//---------------------------------------------------------------------------
TPException __fastcall TPlan::LoadFromFile(HANDLE fh, TEXPIAFILEHEADER &tpfh)
{
  DWORD dwRead;
	WORD opt;
  WORD *bf = NULL, *bb = NULL;
  BYTE *buf;
  RGBQUAD rgb[256];
  int w, h, cntWarp, cntWeft;
  int cnt, s;
  int ec = EC_NONE;
  char str[128];   //ϸ maximum length 128
  bOld = true;

  if (tpfh.Version.Texpia=='P') {
	  if (tpfh.Version.Method=='T' && tpfh.Version.Number>=200) {		// Windows Version
		  if (tpfh.Version.Number < 223) {		// Before Windows Version 7.0
				if (!ReadFile(fh, &WeaveCondition, sizeof(TWeaveCondition) - 24, &dwRead, NULL)) goto fail;
        WeaveCondition.HairType = 0;
        //WeaveCondition.TextureCorrection = false;
        WeaveCondition.ColorCorrection = false;
        WeaveCondition.Tension  = 20;
        WeaveCondition.bmWidth = tpfh.CanvasInfor.Width;
        WeaveCondition.bmHeight = tpfh.CanvasInfor.Height;
		  } else if (tpfh.Version.Number < 225) {		// Before Windows Version 7.0
				if (!ReadFile(fh, &WeaveCondition, sizeof(TWeaveCondition) - 20, &dwRead, NULL)) goto fail;
        //WeaveCondition.TextureCorrection = false;
        WeaveCondition.ColorCorrection = false;
        WeaveCondition.Tension  = 20;
        WeaveCondition.bmWidth = tpfh.CanvasInfor.Width;
        WeaveCondition.bmHeight = tpfh.CanvasInfor.Height;
      } else if (tpfh.Version.Number<230) {   // Before adding Tension property in the 99/07/21.
			  if (!ReadFile(fh, &WeaveCondition, sizeof(TWeaveCondition) - 16, &dwRead, NULL)) goto fail;
        //WeaveCondition.TextureCorrection = false;
        WeaveCondition.ColorCorrection = false;
        WeaveCondition.Tension  = 20;
        WeaveCondition.bmWidth = tpfh.CanvasInfor.Width;
        WeaveCondition.bmHeight = tpfh.CanvasInfor.Height;
      } else if (tpfh.Version.Number<240) {                         //version number 230
			  if (!ReadFile(fh, &WeaveCondition, sizeof(TWeaveCondition) -12, &dwRead, NULL)) goto fail;
        bTextureCorrection = WeaveCondition.ColorCorrection;  // TextureCorrection..
        WeaveCondition.ColorCorrection = false;
        WeaveCondition.bmWidth = tpfh.CanvasInfor.Width;
        WeaveCondition.bmHeight = tpfh.CanvasInfor.Height;          //version number 240
      } else {
        if (!ReadFile(fh, &WeaveCondition, sizeof(TWeaveCondition), &dwRead, NULL)) goto fail;
      }
			if ((ec = Yarn->LoadFromFile(fh, tpfh)) != EC_NONE) goto fail;
			if ((ec = Texture->LoadFromFile(fh, tpfh.Version)) != EC_NONE) goto fail;
		  if ((bmFront = new TPMemoryArea<WORD>(WeaveCondition.bmWidth, WeaveCondition.bmHeight)) == NULL) {
        ec = EC_MEMORY_LACK; goto fail;
      }
      if ((bf = bmFront->lock()) == NULL) { ec = EC_MEMORY_LACK; goto fail; }
			if (!bmFront->LoadFromFile(fh, tpfh.Compress)) goto fail;
      bmFront->unlock();
      if ((bmBack = new TPMemoryArea<WORD>(WeaveCondition.bmWidth, WeaveCondition.bmHeight)) == NULL) {
          ec = EC_MEMORY_LACK; goto fail;
      }
      if ((bb = bmBack->lock()) == NULL) { ec = EC_MEMORY_LACK; goto fail; }
      if (!bmBack->LoadFromFile(fh, tpfh.Compress)) goto fail;
       bmBack->unlock();
      if (tpfh.Version.Number >= 240) {
         if (!ReadFile(fh, &w, sizeof(int), &dwRead, NULL)) goto fail;
     	   if (!ReadFile(fh, &h, sizeof(int), &dwRead, NULL)) goto fail;
         PatternBitmap = new TTexpiaBitmap;
         BackPatternBitmap = new TTexpiaBitmap;
         PatternBitmap->Create(w, h, 16);
         PatternBitmap->LoadFromTexpiaFile(fh, tpfh.Compress);
         BackPatternBitmap->Create(w, h, 16);
         BackPatternBitmap->LoadFromTexpiaFile(fh, tpfh.Compress);
         if (!ReadFile(fh, &cntWarp, sizeof(int), &dwRead, NULL)) goto fail;
         if (!ReadFile(fh, &cntWeft, sizeof(int), &dwRead, NULL)) goto fail;
         ptLength[WARP] = new int[cntWarp];
         ptLength[WEFT] = new int[cntWeft];
         bmLength[WARP] = new int[cntWarp];
         bmLength[WEFT] = new int[cntWeft];
         if (!ReadFile(fh, ptLength[WARP], sizeof(int)*cntWarp, &dwRead, NULL)) goto fail;
         if (!ReadFile(fh, ptLength[WEFT], sizeof(int)*cntWeft, &dwRead, NULL)) goto fail;
         if (!ReadFile(fh, bmLength[WARP], sizeof(int)*cntWarp, &dwRead, NULL)) goto fail;
         if (!ReadFile(fh, bmLength[WEFT], sizeof(int)*cntWeft, &dwRead, NULL)) goto fail;
         bOld = false;
         if (WeaveCondition.SuckerEffect) {
            if (!ReadFile(fh, str, 128, &dwRead, NULL)) goto fail;
            if (!ReadFile(fh, &(SuckerData.Repro), sizeof(double),  &dwRead, NULL)) goto fail;
            if (!ReadFile(fh, &(SuckerData.Density), sizeof(double), &dwRead, NULL)) goto fail;
            if (!ReadFile(fh, rgb, sizeof(RGBQUAD)*256, &dwRead, NULL)) goto fail;
            if (!ReadFile(fh, &w, sizeof(int), &dwRead, NULL)) goto fail;
            if (!ReadFile(fh, &h, sizeof(int), &dwRead, NULL)) goto fail;
            SuckerData.FileName = (AnsiString)str;
            SuckerData.SuckerBitmap = new TTexpiaBitmap;
            SuckerData.SuckerBitmap->Create(w, h, 8, rgb);
            SuckerData.SuckerBitmap->LoadFromTexpiaFile(fh, tpfh.Compress);
            if (SuckerData.tagBitmap) delete SuckerData.tagBitmap;
            SuckerData.tagBitmap = new TPMemoryArea<BYTE> (80, 100);
            SuckerData.tagBitmap->lock();
            for (int y = 0; y < 100; y++){
               buf = SuckerData.tagBitmap->pointer(0, y);
               if (!ReadFile(fh, buf, sizeof(BYTE)*80, &dwRead, NULL)) goto fail;
            }
            SuckerData.tagBitmap->unlock();
         }
         if (!ReadFile(fh, &s, sizeof(short), &dwRead, NULL)) goto fail;
         if (!ReadFile(fh, &ProductStringData.WarpingFront, s, &dwRead, NULL)) goto fail;
/*         if (!ReadFile(fh, &s, sizeof(short), &dwRead, NULL)) goto fail;
         if (!ReadFile(fh, &ProductStringData.WarpingBack, s, &dwRead, NULL)) goto fail;
         if (!ReadFile(fh, &s, sizeof(short), &dwRead, NULL)) goto fail;
         if (!ReadFile(fh, &ProductStringData.Warping, s, &dwRead, NULL)) goto fail;
         if (!ReadFile(fh, &s, sizeof(short), &dwRead, NULL)) goto fail;
         if (!ReadFile(fh, &ProductStringData.TotalWarpCount, s, &dwRead, NULL)) goto fail;
         if (!ReadFile(fh, &s, sizeof(short), &dwRead, NULL)) goto fail;
         if (!ReadFile(fh, &ProductStringData.Reed, s, &dwRead, NULL)) goto fail;
         if (!ReadFile(fh, &s, sizeof(short), &dwRead, NULL)) goto fail;
         if (!ReadFile(fh, &ProductStringData.InsertingNo, s, &dwRead, NULL)) goto fail;
         if (!ReadFile(fh, &s, sizeof(short), &dwRead, NULL)) goto fail;
         if (!ReadFile(fh, &ProductStringData.ActingReedWidth, s, &dwRead, NULL)) goto fail;
         if (!ReadFile(fh, &s, sizeof(short), &dwRead, NULL)) goto fail;
         if (!ReadFile(fh, &ProductStringData.WeftDensity, s, &dwRead, NULL)) goto fail;
         if (!ReadFile(fh, &s, sizeof(short), &dwRead, NULL)) goto fail;
         if (!ReadFile(fh, &ProductStringData.Weight, s, &dwRead, NULL)) goto fail;
         if (!ReadFile(fh, &cnt, sizeof(short), &dwRead, NULL)) goto fail;
         for (int i = 0; i < cnt; i++){
            if (!ReadFile(fh, &s, sizeof(short), &dwRead, NULL)) goto fail;
            if (!ReadFile(fh, &(ProductStringData.Ji->Strings[i]), s, &dwRead, NULL)) goto fail;
         }
         if (!ReadFile(fh, &cnt, sizeof(short), &dwRead, NULL)) goto fail;
         for (int i = 0; i < cnt; i++){
            if (!ReadFile(fh, &s, sizeof(short), &dwRead, NULL)) goto fail;
            if (!ReadFile(fh, &ProductStringData.Attention->Strings[i], s, &dwRead, NULL)) goto fail;
         }*/
      }
    } else {																											// DOS Version
    	if ((ec = Yarn->LoadFromFile(fh, tpfh)) != EC_NONE) goto fail;
			if ((ec = Texture->LoadFromFile(fh, tpfh.Version)) != EC_NONE) goto fail;
		  if (tpfh.Version.Method=='T' || tpfh.Version.Number>332) {
				if (!ReadFile(fh, &opt, 2, &dwRead, NULL)) goto fail;
				WeaveCondition.HairEffect = opt&0xF;
			  WeaveCondition.HairRatio = (opt>>10)&7;
			  WeaveCondition.WovenEffect = (opt>>8)&3;
      } else {
				if (!ReadFile(fh, &opt, 1, &dwRead, NULL)) goto fail;
				WeaveCondition.HairEffect = opt&0xF;
			  WeaveCondition.HairRatio = 0;
			  WeaveCondition.WovenEffect = WETypeA;
      }
		  WeaveCondition.BackSide = false;
      WeaveCondition.HairType = 0;
      WeaveCondition.Tension  = 20;
    }
  }
  return EC_NONE;
fail:
  if (bf) bmFront->unlock();
  if (bb) bmBack->unlock();
  if (ec == EC_NONE) ec = EC_FILE_NOT_READ;
  return ec;
}
//---------------------------------------------------------------------------
TPException __fastcall TPlan::SaveToFile(HANDLE fh, TCompressMethod cm)
{
  DWORD dwWrite;
  int ec = EC_NONE;
  WORD *bf = NULL, *bb = NULL;
  BYTE *buf;
  int w, h, cntWarp, cntWeft, Length;
  RGBQUAD rgb[256];

	if (!WriteFile(fh, &WeaveCondition, sizeof(TWeaveCondition), &dwWrite, NULL)) goto fail;
  if ((ec = Yarn->SaveToFile(fh)) != EC_NONE) goto fail;
	if ((ec = Texture->SaveToFile(fh)) != EC_NONE) goto fail;
  if ((bf = bmFront->lock()) == NULL)  { ec = EC_MEMORY_LACK; goto fail; }
	if (!bmFront->SaveToFile(fh, cm)) goto fail;
  bmFront->unlock();
  if ((bb = bmBack->lock()) == NULL)   { ec = EC_MEMORY_LACK; goto fail; }
  if (!bmBack->SaveToFile(fh, cm)) goto fail;
  bmBack->unlock();
  if(PatternBitmap){
    w = PatternBitmap->Width;
    h = PatternBitmap->Height;
    if (!WriteFile(fh, &w, sizeof(int), &dwWrite, NULL)) goto fail;
    if (!WriteFile(fh, &h, sizeof(int), &dwWrite, NULL)) goto fail;
    if(!PatternBitmap->SaveToTexpiaFile(fh, cm)) goto fail;
    if(!BackPatternBitmap->SaveToTexpiaFile(fh, cm)) goto fail;
    cntWarp = GetCount(WARP);
    cntWeft = GetCount(WEFT);
    if (!WriteFile(fh, &cntWarp, sizeof(int), &dwWrite, NULL)) goto fail;
    if (!WriteFile(fh, &cntWeft, sizeof(int), &dwWrite, NULL)) goto fail;
    if (!WriteFile(fh, ptLength[WARP], sizeof(int)*cntWarp, &dwWrite, NULL)) goto fail;
    if (!WriteFile(fh, ptLength[WEFT], sizeof(int)*cntWeft, &dwWrite, NULL)) goto fail;
    if (!WriteFile(fh, bmLength[WARP], sizeof(int)*cntWarp, &dwWrite, NULL)) goto fail;
    if (!WriteFile(fh, bmLength[WEFT], sizeof(int)*cntWeft, &dwWrite, NULL)) goto fail;
  }
  if (WeaveCondition.SuckerEffect) {
     if (!WriteFile(fh, SuckerData.FileName.c_str(), 128, &dwWrite, NULL)) goto fail;
     if (!WriteFile(fh, &(SuckerData.Repro), sizeof(double), &dwWrite, NULL)) goto fail;
     if (!WriteFile(fh, &(SuckerData.Density), sizeof(double), &dwWrite, NULL)) goto fail;
     SuckerData.SuckerBitmap->GetColors(0, 256, rgb);
     w = SuckerData.SuckerBitmap->Width;
     h = SuckerData.SuckerBitmap->Height;
     if (!WriteFile(fh, rgb, sizeof(RGBQUAD)*256, &dwWrite, NULL)) goto fail;
     if (!WriteFile(fh, &w, sizeof(int), &dwWrite, NULL)) goto fail;
     if (!WriteFile(fh, &h, sizeof(int), &dwWrite, NULL)) goto fail;
     SuckerData.SuckerBitmap->SaveToTexpiaFile(fh, cm);
     SuckerData.tagBitmap->lock();
     for (int y = 0; y < 100; y++){
        buf = SuckerData.tagBitmap->pointer(0, y);
        if (!WriteFile(fh, buf, sizeof(BYTE)*80, &dwWrite, NULL)) goto fail;
     }
     SuckerData.tagBitmap->unlock();
  }
  if (!WriteFile(fh, &(ProductStringData.WarpingFront.Length()), sizeof(short), &dwWrite, NULL)) goto fail;
  if (!WriteFile(fh, &(ProductStringData.WarpingFront.c_str()), ProductStringData.WarpingFront.Length(), &dwWrite, NULL)) goto fail;
/*  if (!WriteFile(fh, &ProductStringData.WarpingBack.Length(), sizeof(short), &dwWrite, NULL)) goto fail;
  if (!WriteFile(fh, &ProductStringData.WarpingBack.c_str(), ProductStringData.WarpingBack.Length(), &dwWrite, NULL)) goto fail;
  if (!WriteFile(fh, &ProductStringData.Warping.Length(), sizeof(short), &dwWrite, NULL)) goto fail;
  if (!WriteFile(fh, &ProductStringData.Warping.c_str(), ProductStringData.Warping.Length(), &dwWrite, NULL)) goto fail;
  if (!WriteFile(fh, &ProductStringData.TotalWarpCount.Length(), sizeof(short), &dwWrite, NULL)) goto fail;
  if (!WriteFile(fh, &ProductStringData.TotalWarpCount.c_str(), ProductStringData.TotalWarpCount.Length(), &dwWrite, NULL)) goto fail;
  if (!WriteFile(fh, &ProductStringData.Reed.Length(), sizeof(short), &dwWrite, NULL)) goto fail;
  if (!WriteFile(fh, &ProductStringData.Reed.c_str(), ProductStringData.Reed.Length(), &dwWrite, NULL)) goto fail;
  if (!WriteFile(fh, &ProductStringData.InsertingNo.Length(), sizeof(short), &dwWrite, NULL)) goto fail;
  if (!WriteFile(fh, &ProductStringData.InsertingNo.c_str(), InsertingNo.Warping.Length(), &dwWrite, NULL)) goto fail;
  if (!WriteFile(fh, &ProductStringData.ActingReedWidth.Length(), sizeof(short), &dwWrite, NULL)) goto fail;
  if (!WriteFile(fh, &ProductStringData.ActingReedWidth.c_str(), ProductStringData.ActingReedWidth.Length(), &dwWrite, NULL)) goto fail;
  if (!WriteFile(fh, &ProductStringData.WeftDensity.Length(), sizeof(short), &dwWrite, NULL)) goto fail;
  if (!WriteFile(fh, &ProductStringData.WeftDensity.c_str(), ProductStringData.WeftDensity.Length(), &dwWrite, NULL)) goto fail;
  if (!WriteFile(fh, &ProductStringData.Weight.Length(), sizeof(short), &dwWrite, NULL)) goto fail;
  if (!WriteFile(fh, &ProductStringData.Weight.c_str(), ProductStringData.Weight.Length(), &dwWrite, NULL)) goto fail;
  if (!WriteFile(fh, &ProductStringData.Ji->Count, sizeof(short), &dwWrite, NULL)) goto fail;
  for (int i = 0; i < ProductStringData.Ji->Count; i++){
     if (!WriteFile(fh, ProductStringData.Ji->Strings[i].Length(), sizeof(short), &dwWrite, NULL)) goto fail;
     if (!WriteFile(fh, ProductStringData.Ji->Strings[i].c_str(), ProductStringData.Ji->Strings[i].Length(), &dwWrite, NULL)) goto fail;
  }
  if (!WriteFile(fh, ProductStringData.Attention->Count, sizeof(short), &dwWrite, NULL)) goto fail;
  for (int i = 0; i < ProductStringData.Attention->Count; i++){
     if (!WriteFile(fh, &ProductStringData.Attention->Strings[i].Length(), sizeof(short), &dwWrite, NULL)) goto fail;
     if (!WriteFile(fh, &ProductStringData.Attention->Strings[i].c_str(), ProductStringData.Attention->Strings[i].Length(), &dwWrite, NULL)) goto fail;
  }*/
  return EC_NONE;
fail:
  if (bf) bmFront->unlock();
  if (bb) bmBack->unlock();
  if (ec == EC_NONE) ec = EC_FILE_NOT_WRITE;
  return ec;
}
//---------------------------------------------------------------------------
WORD __fastcall TPlan::GetYarn(int X, int Y, bool bBackSide)
{
  WORD value;
  WORD *bf = NULL, *bb = NULL;
  int cnt, i;
  int sumx = 0, sumy = 0, sumbmx = 0, sumbmy = 0;
	if (bBackSide) {
    if (bmBack) {
      bb = bmBack->lock();
      if (bb == NULL) goto fail;
      if (bOld == false) {
        X = (MainImageForm->iMainImage->Bitmap->Width -1 -X)%PatternBitmap->Width;
        Y %= PatternBitmap->Height;
        if (!WeaveCondition.ColorCorrection){
           cnt = GetCount(WARP);
           for(i = 0; ;i++){            //qe iMainImage ° bmWarp Ѱ̱ 
              sumx += ptLength[WARP][i%cnt];            //ùٸ ǥ  ȯϴ 
              if(X < sumx){
                sumx -= ptLength[WARP][i%cnt];
                X = sumbmx + (double)bmLength[WARP][i%cnt]/ptLength[WARP][i%cnt]*(X - sumx) + 0.5;
                break;
              }
              sumbmx += bmLength[WARP][i%cnt];
           }
           cnt = GetCount(WEFT);
           for(i = 0; ; i++){
              sumy += ptLength[WEFT][i%cnt];
              if(Y < sumy){
                sumy -= ptLength[WEFT][i%cnt];
                Y = sumbmy + (double)bmLength[WEFT][i%cnt]/ptLength[WEFT][i%cnt]*(Y - sumy) + 0.5;
                break;
              }
              sumbmy += bmLength[WEFT][i%cnt];
           }
        }
      }
      value = *bmBack->pointer(X, Y);
      bmBack->unlock();
      if (value & 0x8000) return 0;
    } else return 0;
  } else {
    if (bmFront) {
      bf = bmFront->lock();
      if (bf == NULL) goto fail;
      if (bOld == false){
        X %= PatternBitmap->Width;
        Y %= PatternBitmap->Height;
        if (!WeaveCondition.ColorCorrection) {
           cnt = GetCount(WARP);
           for(i = 0; ; i++){            //qe iMainImage ° bmWarp Ѱ̱ 
              sumx += ptLength[WARP][i%cnt];            //ùٸ ǥ  ȯϴ 
              if(X < sumx){
                sumx -= ptLength[WARP][i%cnt];
                X = sumbmx + (double)bmLength[WARP][i%cnt]/ptLength[WARP][i%cnt]*(X - sumx) + 0.5;
                break;
              }
              sumbmx += bmLength[WARP][i%cnt];
           }
           cnt = GetCount(WEFT);
           for(i = 0; ; i++){
              sumy += ptLength[WEFT][i%cnt];
              if(Y < sumy){
                sumy -= ptLength[WEFT][i%cnt];
                Y = sumbmy + (double)bmLength[WEFT][i%cnt]/ptLength[WEFT][i%cnt]*(Y - sumy) + 0.5;
                break;
              }
              sumbmy += bmLength[WEFT][i%cnt];
           }
        }
      }
      value = *bmFront->pointer(X, Y);
      bmFront->unlock();
      if (value & 0x8000) return 0;
    } else return 0;
  }
  return value;
fail:
  if (bf) bmFront->unlock();
  EXCEPTION_MESSAGE_OK(EC_MEMORY_LACK);
  return 0;
}
//---------------------------------------------------------------------------
int __fastcall TPlan::GetCount(int i)        // 迭   Ǿֳ ˾Ƴ.
{                                            //⼭  ̶  е  Ѵ.
  int n, o, r, ic, tc, Repeat, CRepeat, rs, rn, cnt;
  double pdensity;
  TYarnArray *ya;
  n = 0; o = 0; r = 0;
  CRepeat = 0;
  rs = NULL; rn = NULL;
  cnt = 0;
  pdensity = -1;
  Repeat = ((TYarnArray *)Yarn->Array[i]->Items[n])->repeat;
  while(1){
     ya = (TYarnArray *)Yarn->Array[i]->Items[o];
     if (pdensity > 0 && ya->density != pdensity) cnt++;
     pdensity = ya->density;
     if(Change(i, n, o, r, Repeat, CRepeat, rs, rn)) return ++cnt;
  }
}
//---------------------------------------------------------------------------
int __fastcall TPlan::GetSCount(int i)        // 迭   Ǿֳ ˾Ƴ.
{                                            //⼭  ̶  迭 ϳ ϳ Ѵ
  int n, o, r, ic, tc, Repeat, CRepeat, rs, rn, Yarns, cnt;
  n = 0; o = 0; r = 0;
  CRepeat = 0;
  rs = NULL; rn = NULL;
  cnt = 0;
  Repeat = ((TYarnArray *)Yarn->Array[i]->Items[n])->repeat;
  while(1){
     if(Change(i, n, o, r, Repeat, CRepeat, rs, rn)) return ++cnt;
     cnt++;
  }
}
//---------------------------------------------------------------------------
int __fastcall TPlan::GetPatternInfo(int i, int &YarnLength)
{
  int n, o, r, ic, tc, Repeat, CRepeat, rs, rn, Yarns, cnt, TotalYarnCount;
  int TempLength, TempYarns, s;
  double DPY, pdensity;
  TYarnArray *ya;
  n = 0; o = 0; r = 0;
  CRepeat = 0;
  rs = NULL; rn = NULL;
  cnt = 0;  s = 0;
  TotalLength[i] =0;
  TotalExactLength[i] =0;
  TotalYarnCount = 0;
  TempLength = 0;
  TempYarns = 0;
  pdensity = -1;
  Repeat = ((TYarnArray *)Yarn->Array[i]->Items[n])->repeat;
  while(1){
     ya = (TYarnArray *)Yarn->Array[i]->Items[o];
     if (pdensity > 0 && ya->density != pdensity){
        Length[i][cnt] = TempLength;
        ExactLength[i][cnt] = PatternDPI * TempYarns/pdensity + 0.5;
        if (ExactLength[i][cnt] < 1) ExactLength[i][cnt] = 1;
        TempLength = 0;
        TempYarns = 0;
        TotalLength[i] += Length[i][cnt];
        TotalExactLength[i] += ExactLength[i][cnt];
        cnt++;
     }
     if(ya->yarns == 0) DPY = 0;
     else DPY = (double)data[i][data[i][o].num].dot/ya->yarns;
     Yarns = ya->yarns;
     TempLength += DPY*Yarns;
     TempYarns += Yarns;
     pdensity = ya->density;
     TotalYarnCount += Yarns;                                            //ܻ簡 ƴ 쳪 ĵ,ȿ ִ½
     if (Yarn->Choice[(ya->code-1)>>3].Data->Infor.Detail.Type != 0 ||   //  ũ .
         Yarn->Choice[(ya->code-1)>>3].Data->Dyed || WeaveCondition.HairEffect == HEActual) {
         YarnLength = max((int)Yarn->Choice[(ya->code-1)>>3].Data->Length, YarnLength);
     }
     sLength[i][s] = DPY*Yarns;
     if (i == WARP)  bSucker[s] = ya->sucker;
     if(Change(i, n, o, r, Repeat, CRepeat, rs, rn)) {
        Length[i][cnt] = TempLength;
        ExactLength[i][cnt] = PatternDPI * TempYarns/pdensity + 0.5;
        if (ExactLength[i][cnt] < 1) ExactLength[i][cnt] = 1;
        TempLength = 0;
        TempYarns = 0;
        TotalLength[i] += Length[i][cnt];
        TotalExactLength[i] += ExactLength[i][cnt];
        return TotalYarnCount;
     }
     s++;
  }
}
//----------------------------------------------------------------------------
void __fastcall TPlan::ConsiderTextureYarn(int i, int YarnCnt, int YarnLength, int maximum)
{
  int ratio, temp;
  if (YarnCnt == 0) return;
  if (i == WARP)ratio = Texture->GetLCM(YarnCnt, Texture->Choice[PATTERN].width)/YarnCnt;
  else  ratio = Texture->GetLCM(YarnCnt, Texture->Choice[PATTERN].height)/YarnCnt;
  temp = ratio;
  while(TotalLength[i]*ratio < YarnLength*2/3) ratio += temp;
  while(TotalLength[i]*ratio > maximum) ratio -= temp;
  if(ratio < 1) ratio = 1;
  TotalLength[i] = TotalLength[i]*ratio;
  TotalExactLength[i] = TotalExactLength[i]*ratio;
  if (!WeaveCondition.ColorCorrection) while(TotalExactLength[i] > maximum) TotalExactLength[i]--;
  else while(TotalLength[i] > maximum) TotalLength[i]--;
}
//----------------------------------------------------------------------------
void __fastcall TPlan::MakePatternBitmap(TTexpiaBitmap *TempBitmap, TPMemoryArea<WORD> *bmTemp, RGBQUAD bgColor, int StartPos, int pcnt)
{
  WORD sp1, sp2, sp3, sp4, sp5, sp6, sp7, sp8, sp9, *sp, *dp, *dp1, *dp2, c, c1, c2, c3, c4, c5, c6, c7, c8, c9;
  TGradeColor **ydc;
  WORD *bf = NULL;
  RGBQUAD TempRGB, rgb1, rgb2, rgb3, rgb4, rgb5, rgb6, rgb7, rgb8, rgb9;
  int x, y, i = 0, j = 0, lx = 0, ly =0, sumx = 0, sumy = 0, total, s;
  int dy1, dy2, dy3;
  double dd1, dd2, dd3;
  double ratiox, ratioy;
  int SeriesWarp, SeriesWeft;
  int a, b, temp, xgap, ygap;
  SeriesWarp = GetCount(WARP);
  SeriesWeft = GetCount(WEFT);

  if(PatternDPI < 320) {
     if(bmLength[WARP]) {delete[] bmLength[WARP]; bmLength[WARP] = NULL;}
     if(ptLength[WARP]) {delete[] ptLength[WARP]; ptLength[WARP] = NULL;}
     bmLength[WARP] = new int[SeriesWarp];
     ptLength[WARP] = new int[SeriesWarp];
     for(s = 0; s < SeriesWarp; s++){
       bmLength[WARP][s] = Length[WARP][s];
       ptLength[WARP][s] = ExactLength[WARP][s];
     }
     if(bmLength[WEFT]) {delete[] bmLength[WEFT];  bmLength[WEFT] = NULL;}
     if(ptLength[WEFT]) {delete[] ptLength[WEFT];  ptLength[WEFT] = NULL;}
     bmLength[WEFT] = new int[SeriesWeft];
     ptLength[WEFT] = new int[SeriesWeft];
     for(s = 0; s < SeriesWeft; s++){
       bmLength[WEFT][s] = Length[WEFT][s];
       ptLength[WEFT][s] = ExactLength[WEFT][s];
     }
  }

  if (!WeaveCondition.ColorCorrection){
    TTexpiaBitmap *Bitmap = new TTexpiaBitmap;
    Bitmap->Create(TotalLength[WARP], TotalExactLength[WEFT], 16);
    if (Bitmap->StartScanLine() == false) goto fail;
    if(WeaveCondition.WovenEffect==WESolid) {
       for (y = 0; y < Bitmap->Height; y++, ly++) {
         StatusProgress->Position = StartPos + (10*y/Bitmap->Height)*pcnt/20;
         if(i == 0){                                                //ó ..
            ly = 0;
            ratioy  = (double)Length[WEFT][0]/ExactLength[WEFT][0];
            a = Length[WEFT][0];
            b = ExactLength[WEFT][0];
            while(a != b){
                temp = min(a,b);
                a = max(a, b) - min(a, b);
                b = temp;
            }
            if((Length[WEFT][0]/a - ExactLength[WEFT][0]/a) > 1) ygap = 1;
            else ygap = 0;
            i++;
         } else {
            if(ly >= ExactLength[WEFT][(i-1)%SeriesWeft]) {
              ly = 0;
              ratioy = (double)Length[WEFT][i%SeriesWeft]/ExactLength[WEFT][i%SeriesWeft];
              sumy += Length[WEFT][(i-1)%SeriesWeft];
              a = Length[WEFT][i%SeriesWeft];
              b = ExactLength[WEFT][i%SeriesWeft];
              while(a != b){
                temp = min(a,b);
                a = max(a, b) - min(a, b);
                b = temp;
              }
              if((Length[WEFT][i%SeriesWeft]/a - ExactLength[WEFT][i%SeriesWeft]/a) > 1) ygap = 1;
              else ygap = 0;
              i++;
            }
         }
         dp = (WORD *)Bitmap->GetScanLine(Bitmap->Height -1 -y);
         if (ygap == 0) {
            dy1 = sumy+int(ratioy*ly);
            dy2 = sumy+int(ratioy*ly)+1;
            dd1 = int(ratioy*ly)+1 - ratioy*ly;
            dd2 = ratioy*(ly+1) - int(ratioy*ly) -1;
         } else {
            dy1 = sumy + int(ratioy*ly);
            dy2 = sumy + int(ratioy*ly)+1;
            dy3 = sumy + int(ratioy*(ly+1));
            dd1 = int(ratioy*ly)+1 - ratioy*ly;
            dd2 = int(ratioy*(ly+1)) - (int(ratioy*ly)+1);
            dd3 = ratioy*(ly+1) - int(ratioy*(ly+1));
         }
         for (x = 0; x < Bitmap->Width; x++, dp++) {
           if (ygap == 0){
              sp1 = *bmTemp->pointer(x, dy1);
              sp2 = *bmTemp->pointer(x, dy2);
              c1 = sp1 & 0x3FFF; c2 = sp2 & 0x3FFF;
              if (sp1) {
                 if (sp1 & 0x8000) {    //ĵ 
                    rgb1.rgbBlue = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                    rgb1.rgbGreen = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                    rgb1.rgbRed = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);
                 } else {
                    rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor(0)->RGB;
                    if(c1>>3 == c2>>3) {TempRGB = rgb2 = rgb1;  goto next1;}
                 }
              } else { rgb1 = bgColor;}
              if (sp2) {
                 if (sp2 & 0x8000) {
                    rgb2.rgbBlue = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                    rgb2.rgbGreen = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                    rgb2.rgbRed = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);
                 } else {
                    rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor(0)->RGB;
                 }
              } else { rgb2 = bgColor;}

              TempRGB.rgbRed = (dd1*rgb1.rgbRed + dd2*rgb2.rgbRed)/ratioy;
              TempRGB.rgbGreen = (dd1*rgb1.rgbGreen + dd2* rgb2.rgbGreen)/ratioy;
              TempRGB.rgbBlue = (dd1*rgb1.rgbBlue + dd2*rgb2.rgbBlue)/ratioy;
           } else {
              sp1 = *bmTemp->pointer(x, dy1);
              sp2 = *bmTemp->pointer(x, dy2);
              if((ratioy*(ly+1) - int(ratioy*(ly+1))) < 0.0001) sp3 = sp2;
              else sp3 = *bmTemp->pointer(x, dy3);
              c1 = sp1 & 0x3FFF; c2 = sp2 & 0x3FFF; c3 = sp3 & 0x3FFF;
              if (sp1) {
                 if (sp1 & 0x8000) {    //ĵ 
                    rgb1.rgbBlue = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                    rgb1.rgbGreen = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                    rgb1.rgbRed = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);
                 } else {
                    rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor(0)->RGB;
                    if((c1>>3 == c2>>3) && (c2>>3 == c3>>3)) {TempRGB = rgb3 = rgb1;  goto next1;}
                 }
              } else { rgb1 = bgColor;}
              if (sp2) {
                 if (sp2 & 0x8000) {
                    rgb2.rgbBlue = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                    rgb2.rgbGreen = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                    rgb2.rgbRed = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);
                 } else {
                    rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor(0)->RGB;
                 }
              } else { rgb2 = bgColor;}
              if (sp3 == sp2) {
                 rgb3 = rgb2;
              } else {
                 if (sp3) {
                    if (sp3 & 0x8000) {
                       rgb3.rgbBlue = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                       rgb3.rgbGreen = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                       rgb3.rgbRed = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);
                    } else {
                       rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor(0)->RGB;
                    }
                 } else { rgb3 = bgColor;}
              }
              TempRGB.rgbRed = (dd1*rgb1.rgbRed + dd2*rgb2.rgbRed + dd3* rgb3.rgbRed)/ratioy;
              TempRGB.rgbGreen = (dd1*rgb1.rgbGreen + dd2* rgb2.rgbGreen + dd3* rgb3.rgbGreen)/ratioy;
              TempRGB.rgbBlue = (dd1*rgb1.rgbBlue + dd2*rgb2.rgbBlue + dd3*rgb3.rgbBlue)/ratioy;
           }
  next1:
           *dp = RGBToColor15(TempRGB);
         }
         Bitmap->PutScanLine(Bitmap->Height -1 - y);
       }
    } else if (WeaveCondition.WovenEffect==WETypeA) {
       for (y = 0; y < Bitmap->Height; y++, ly++) {
         StatusProgress->Position = StartPos + (10*y/Bitmap->Height)*pcnt/20;
         if(i == 0){                                                //ó ..
            ly = 0;
            ratioy  = (double)Length[WEFT][0]/ExactLength[WEFT][0];
            a = Length[WEFT][0];
            b = ExactLength[WEFT][0];
            while(a != b){
                temp = min(a,b);
                a = max(a, b) - min(a, b);
                b = temp;
            }
            if((Length[WEFT][0]/a - ExactLength[WEFT][0]/a) > 1) ygap = 1;
            else ygap = 0;
            i++;
         } else {
            if(ly >= ExactLength[WEFT][(i-1)%SeriesWeft]) {
              ly = 0;
              ratioy = (double)Length[WEFT][i%SeriesWeft]/ExactLength[WEFT][i%SeriesWeft];
              sumy += Length[WEFT][(i-1)%SeriesWeft];
              a = Length[WEFT][i%SeriesWeft];
              b = ExactLength[WEFT][i%SeriesWeft];
              while(a != b){
                temp = min(a,b);
                a = max(a, b) - min(a, b);
                b = temp;
              }
              if((Length[WEFT][i%SeriesWeft]/a - ExactLength[WEFT][i%SeriesWeft]/a) > 1) ygap = 1;
              else ygap = 0;
              i++;
            }
         }
         dp = (WORD *)Bitmap->GetScanLine(Bitmap->Height -1 -y);
         if (ygap == 0) {
            dy1 = sumy+int(ratioy*ly);
            dy2 = sumy+int(ratioy*ly)+1;
            dd1 = int(ratioy*ly)+1 - ratioy*ly;
            dd2 = ratioy*(ly+1) - int(ratioy*ly) -1;
         } else {
            dy1 = sumy + int(ratioy*ly);
            dy2 = sumy + int(ratioy*ly)+1;
            dy3 = sumy + int(ratioy*(ly+1));
            dd1 = int(ratioy*ly)+1 - ratioy*ly;
            dd2 = int(ratioy*(ly+1)) - (int(ratioy*ly)+1);
            dd3 = ratioy*(ly+1) - int(ratioy*(ly+1));
         }
         for (x = 0; x < Bitmap->Width; x++, dp++) {
           if (ygap == 0){
              sp1 = *bmTemp->pointer(x, dy1);
              sp2 = *bmTemp->pointer(x, dy2);
              c1 = sp1 & 0x3FFF; c2 = sp2 & 0x3FFF;
              if ((ratioy*ly - int(ratioy*ly)) > 0.001) {
                 rgb1 = rgb2;
              } else {
                 if (sp1) {
                    if (sp1 & 0x8000) {    //ĵ 
                       rgb1.rgbBlue = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                       rgb1.rgbGreen = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                       rgb1.rgbRed = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);
                    } else {
                       rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor((c1&7)-4)->RGB;
                    }
                 } else { rgb1 = bgColor;}
              }
              if (sp2) {
                 if (sp2 & 0x8000) {
                    rgb2.rgbBlue = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                    rgb2.rgbGreen = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                    rgb2.rgbRed = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);
                 } else {
                    rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor((c2&7)-4)->RGB;
                 }
              } else { rgb2 = bgColor;}

              TempRGB.rgbRed = (dd1*rgb1.rgbRed + dd2*rgb2.rgbRed)/ratioy;
              TempRGB.rgbGreen = (dd1*rgb1.rgbGreen + dd2* rgb2.rgbGreen)/ratioy;
              TempRGB.rgbBlue = (dd1*rgb1.rgbBlue + dd2*rgb2.rgbBlue)/ratioy;

           } else {
              sp1 = *bmTemp->pointer(x, dy1);
              sp2 = *bmTemp->pointer(x, dy2);
              if((ratioy*(ly+1) - int(ratioy*(ly+1))) < 0.0001) sp3 = sp2;
              else sp3 = *bmTemp->pointer(x, dy3);
              c1 = sp1 & 0x3FFF; c2 = sp2 & 0x3FFF; c3 = sp3 & 0x3FFF;
              if (sp1) {
                 if (sp1 & 0x8000) {    //ĵ 
                    rgb1.rgbBlue = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                    rgb1.rgbGreen = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                    rgb1.rgbRed = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);
                 } else {
                    rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor((c1&7)-4)->RGB;
                 }
              } else { rgb1 = bgColor;}
              if (sp2) {
                 if (sp2 & 0x8000) {
                    rgb2.rgbBlue = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                    rgb2.rgbGreen = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                    rgb2.rgbRed = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);
                 } else {
                    rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor((c2&7)-4)->RGB;
                 }
              } else { rgb2 = bgColor;}
              if (sp3 == sp2) {
                 rgb3 = rgb2;
              } else {
                 if (sp3) {
                    if (sp3 & 0x8000) {
                       rgb3.rgbBlue = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                       rgb3.rgbGreen = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                       rgb3.rgbRed = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);
                    } else {
                       rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor((c3&7)-4)->RGB;
                    }
                 } else { rgb3 = bgColor;}
              }
              TempRGB.rgbRed = (dd1*rgb1.rgbRed + dd2*rgb2.rgbRed + dd3* rgb3.rgbRed)/ratioy;
              TempRGB.rgbGreen = (dd1*rgb1.rgbGreen + dd2* rgb2.rgbGreen + dd3* rgb3.rgbGreen)/ratioy;
              TempRGB.rgbBlue = (dd1*rgb1.rgbBlue + dd2*rgb2.rgbBlue + dd3*rgb3.rgbBlue)/ratioy;
           }
           *dp = RGBToColor15(TempRGB);
         }
         Bitmap->PutScanLine(Bitmap->Height -1 - y);
       }
    } else {
       for (y = 0; y < Bitmap->Height; y++, ly++) {
         StatusProgress->Position = StartPos + (10*y/Bitmap->Height)*pcnt/20;
         if(i == 0){                                                //ó ..
            ly = 0;
            ratioy  = (double)Length[WEFT][0]/ExactLength[WEFT][0];
            a = Length[WEFT][0];
            b = ExactLength[WEFT][0];
            while(a != b){
                temp = min(a,b);
                a = max(a, b) - min(a, b);
                b = temp;
            }
            if((Length[WEFT][0]/a - ExactLength[WEFT][0]/a) > 1) ygap = 1;
            else ygap = 0;
            i++;
         } else {
            if(ly >= ExactLength[WEFT][(i-1)%SeriesWeft]) {
              ly = 0;
              ratioy = (double)Length[WEFT][i%SeriesWeft]/ExactLength[WEFT][i%SeriesWeft];
              sumy += Length[WEFT][(i-1)%SeriesWeft];
              a = Length[WEFT][i%SeriesWeft];
              b = ExactLength[WEFT][i%SeriesWeft];
              while(a != b){
                temp = min(a,b);
                a = max(a, b) - min(a, b);
                b = temp;
              }
              if((Length[WEFT][i%SeriesWeft]/a - ExactLength[WEFT][i%SeriesWeft]/a) > 1) ygap = 1;
              else ygap = 0;
              i++;
            }
         }
         dp = (WORD *)Bitmap->GetScanLine(Bitmap->Height -1 -y);
         if (ygap == 0) {
            dy1 = sumy+int(ratioy*ly);
            dy2 = sumy+int(ratioy*ly)+1;
            dd1 = int(ratioy*ly)+1 - ratioy*ly;
            dd2 = ratioy*(ly+1) - int(ratioy*ly) -1;
         } else {
            dy1 = sumy + int(ratioy*ly);
            dy2 = sumy + int(ratioy*ly)+1;
            dy3 = sumy + int(ratioy*(ly+1));
            dd1 = int(ratioy*ly)+1 - ratioy*ly;
            dd2 = int(ratioy*(ly+1)) - (int(ratioy*ly)+1);
            dd3 = ratioy*(ly+1) - int(ratioy*(ly+1));
         }
         for (x = 0; x < Bitmap->Width; x++, dp++) {
           if (ygap == 0){
              sp1 = *bmTemp->pointer(x, dy1);
              sp2 = *bmTemp->pointer(x, dy2);
              c1 = sp1 & 0x3FFF; c2 = sp2 & 0x3FFF;
              if (sp1) {
                 if (sp1 & 0x8000) {    //ĵ 
                    rgb1.rgbBlue = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                    rgb1.rgbGreen = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                    rgb1.rgbRed = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);
                 } else {
                    if(sp1 & 0x4000) rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor((c1&7)>>1)->RGB;
                    else rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor(-((c1&7)>>1))->RGB;
                 }
              } else { rgb1 = bgColor;}
              if (sp2) {
                 if (sp2 & 0x8000) {
                    rgb2.rgbBlue = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                    rgb2.rgbGreen = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                    rgb2.rgbRed = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);
                 } else {
                    if(sp2 & 0x4000) rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor((c2&7)>>1)->RGB;
                    else rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor(-((c2&7)>>1))->RGB;
                 }
              } else { rgb2 = bgColor;}

              TempRGB.rgbRed = (dd1*rgb1.rgbRed + dd2*rgb2.rgbRed)/ratioy;
              TempRGB.rgbGreen = (dd1*rgb1.rgbGreen + dd2* rgb2.rgbGreen)/ratioy;
              TempRGB.rgbBlue = (dd1*rgb1.rgbBlue + dd2*rgb2.rgbBlue)/ratioy;

           } else {
              sp1 = *bmTemp->pointer(x, dy1);
              sp2 = *bmTemp->pointer(x, dy2);
              if((ratioy*(ly+1) - int(ratioy*(ly+1))) < 0.0001) sp3 = sp2;
              else sp3 = *bmTemp->pointer(x, dy3);
              c1 = sp1 & 0x3FFF; c2 = sp2 & 0x3FFF; c3 = sp3 & 0x3FFF;
              if (sp1) {
                 if (sp1 & 0x8000) {    //ĵ 
                    rgb1.rgbBlue = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                    rgb1.rgbGreen = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                    rgb1.rgbRed = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);
                 } else {
                    if(sp1 & 0x4000) rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor((c1&7)>>1)->RGB;
                    else rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor(-((c1&7)>>1))->RGB;
                 }
              } else { rgb1 = bgColor;}
              if (sp2) {
                 if (sp2 & 0x8000) {
                    rgb2.rgbBlue = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                    rgb2.rgbGreen = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                    rgb2.rgbRed = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);
                 } else {
                    if(sp2 & 0x4000) rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor((c2&7)>>1)->RGB;
                    else rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor(-((c2&7)>>1))->RGB;
                 }
              } else { rgb2 = bgColor;}
              if (sp3 == sp2) {
                 rgb3 = rgb2;
              } else {
                 if (sp3) {
                    if (sp3 & 0x8000) {
                       rgb3.rgbBlue = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                       rgb3.rgbGreen = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                       rgb3.rgbRed = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);
                    } else {
                       if(sp3 & 0x4000) rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor((c3&7)>>1)->RGB;
                       else rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor(-((c3&7)>>1))->RGB;
                    }
                 } else { rgb3 = bgColor;}
              }
              TempRGB.rgbRed = (dd1*rgb1.rgbRed + dd2*rgb2.rgbRed + dd3* rgb3.rgbRed)/ratioy;
              TempRGB.rgbGreen = (dd1*rgb1.rgbGreen + dd2* rgb2.rgbGreen + dd3* rgb3.rgbGreen)/ratioy;
              TempRGB.rgbBlue = (dd1*rgb1.rgbBlue + dd2*rgb2.rgbBlue + dd3*rgb3.rgbBlue)/ratioy;
           }
           *dp = RGBToColor15(TempRGB);
         }
         Bitmap->PutScanLine(Bitmap->Height -1 - y);
       }
    }

    TempBitmap->FillRect(Rect(0, 0, TempBitmap->Width, TempBitmap->Height), clBlack);
    if (TempBitmap->StartScanLine() == false) goto fail;
    for (y = 0; y < Bitmap->Height; y++) {
       StatusProgress->Position = StartPos + pcnt/2 + (10*y/TempBitmap->Height)*pcnt/20;
       sp = (WORD *)Bitmap->GetScanLine(Bitmap->Height -1 -y);
       dp = (WORD *)TempBitmap->GetScanLine(TempBitmap->Height - 1 -y);
       i = 0; sumx = 0;
       for(x = 0; x < Bitmap->Width; x++, lx++, sp++){
          if (lx >= sumx){
             lx = 0;
             ratiox = (double)ExactLength[WARP][i%SeriesWarp]/Length[WARP][i%SeriesWarp];
             sumx = Length[WARP][i%SeriesWarp];
             total = ExactLength[WARP][i%SeriesWarp];
             i++;
          }
          if (int(ratiox*(lx+1)+0.0001) == int(ratiox*lx+0.0001) || ceil(ratiox*lx) == ceil(ratiox*(lx+1)) || ratiox == 1) {
             TempRGB = Color15ToRGB(*sp);
             if (ratiox*lx - int(ratiox*lx+0.0001) > 0.0001) rgb3 = rgb2;
             else rgb3 = Color15ToRGB(*dp);
             dd1 = ratiox*(lx+1) - ratiox*lx;
             rgb1.rgbRed = rgb3.rgbRed + dd1*TempRGB.rgbRed;
             rgb1.rgbGreen = rgb3.rgbGreen + dd1*TempRGB.rgbGreen;
             rgb1.rgbBlue = rgb3.rgbBlue + dd1*TempRGB.rgbBlue;
             *(dp) = RGBToColor15(rgb1);
             rgb2 = rgb1;
             dp += int(ratiox*(lx+1)+0.0001) - int(ratiox*lx+0.0001);
          } else {
             TempRGB = Color15ToRGB(*sp);
             if (ratiox*lx - int(ratiox*lx+0.0001) > 0.0001) rgb3 = rgb2;
             else rgb3 = Color15ToRGB(*dp);
             dd1 = int(ratiox*(lx+1)+0.0001) - ratiox*lx;
             rgb1.rgbRed = rgb3.rgbRed + dd1*TempRGB.rgbRed;
             rgb1.rgbGreen = rgb3.rgbGreen + dd1*TempRGB.rgbGreen;
             rgb1.rgbBlue = rgb3.rgbBlue + dd1*TempRGB.rgbBlue;
             *(dp) = RGBToColor15(rgb1);
             dp++;
             //if (int(ratiox*(lx+1)) >= total) continue;
             dd2 = ratiox*(lx+1) - int(ratiox*(lx+1)+0.0001);
             rgb1.rgbRed = dd2*TempRGB.rgbRed;
             rgb1.rgbGreen = dd2*TempRGB.rgbGreen;
             rgb1.rgbBlue = dd2*TempRGB.rgbBlue;
             *(dp) = RGBToColor15(rgb1);
             rgb2 = rgb1;
          }
       }
       TempBitmap->PutScanLine(TempBitmap->Height - 1 - y);
    }
    TempBitmap->StopScanLine();
    Bitmap->StopScanLine();
    delete Bitmap;
  } else {                  // 
    if (TempBitmap->StartScanLine() == false) goto fail;
    if(WeaveCondition.WovenEffect==WESolid) {
       for(y = 0; y < TempBitmap->Height; y++){
          StatusProgress->Position = StartPos + (10*y/TempBitmap->Height)*pcnt/10;
          dp = (WORD *)TempBitmap->GetScanLine(TempBitmap->Height - y -1);
          sp = bmTemp->pointer(0, y);
          for(x = 0; x < TempBitmap->Width; x++, sp++, dp++){
             if (*sp) {
                if (*sp & 0x8000) {
   	  			       *dp = *sp & 0x7FFF;
                } else {
            	     c = *sp & 0x3FFF;
					         ydc = Yarn->Choice[c>>11].Color[(c>>8)&7];
   	  			       *dp = RGBToColor15(ydc[(c>>3)&0x1F]->GetColor(0)->RGB);
                }
		  		   } else {
			 	  	    *dp = RGBToColor15(bgColor);
             }
          }
          TempBitmap->PutScanLine(TempBitmap->Height - y -1);
       }
    } else if (WeaveCondition.WovenEffect==WETypeA) {
       for (int y=0; y<TempBitmap->Height; y++) {
          StatusProgress->Position = StartPos + (10*y/TempBitmap->Height)*pcnt/10;
		  	  sp = bmTemp->pointer(0, y);
			 	  dp = (WORD *)TempBitmap->GetScanLine(TempBitmap->Height-1-y);
		  	  for (int x=0; x<TempBitmap->Width; x++, sp++, dp++) {
    			   if (*sp) {
                if (*sp & 0x8000) {
   	  			       *dp = *sp & 0x7FFF;
                } else {
            	     c = *sp & 0x3FFF;
  					       ydc = Yarn->Choice[c>>11].Color[(c>>8)&7];
 	  	  	  	     *dp = RGBToColor15(ydc[(c>>3)&0x1F]->GetColor((c&7)-4)->RGB);
                }
             } else {
			 	  	    *dp = RGBToColor15(bgColor);
             }
          }
  			  TempBitmap->PutScanLine(TempBitmap->Height-1-y);
	  	 }
	  } else {
	  	 for (int y=0; y<TempBitmap->Height; y++) {
          StatusProgress->Position = StartPos + (10*y/TempBitmap->Height)*pcnt/10;
		  	  sp = bmTemp->pointer(0, y);
			 	  dp = (WORD *)TempBitmap->GetScanLine(TempBitmap->Height-1-y);
		  	  for (int x=0; x<TempBitmap->Width; x++, sp++, dp++) {
    			   if (*sp) {
                if (*sp & 0x8000) {
   	  			    *dp = *sp & 0x7FFF;
                } else {
            	     c = *sp & 0x3FFF;
					         ydc = Yarn->Choice[c>>11].Color[(c>>8)&7];
                   if (*sp&0x4000) {
	     				        *dp = RGBToColor15(ydc[(c>>3)&0x1F]->GetColor((c&7)>>1)->RGB);
                   } else {
	     				        *dp = RGBToColor15(ydc[(c>>3)&0x1F]->GetColor(-((c&7)>>1))->RGB);
                   }
                }
		  		   } else {
			 	  	    *dp = RGBToColor15(bgColor);
    		     }
		      }
          TempBitmap->PutScanLine(TempBitmap->Height-1-y);
    	 }
    }
    TempBitmap->StopScanLine();
  }



/*  if (TempBitmap->StartScanLine() == false) goto fail;
  if(WeaveCondition.WovenEffect==WESolid) {
     for (int y=0; y<TempBitmap->Height; y++, ly++) {
       StatusProgress->Position = 50 + 5*(10*y/TempBitmap->Height);
       if(i == 0){                                                //ó ..
          ly = 0;
          ratioy  = (double)Length[WEFT][0]/ExactLength[WEFT][0];
          a = Length[WEFT][0];
          b = ExactLength[WEFT][0];
          while(a != b){
              temp = min(a,b);
              a = max(a, b) - min(a, b);
              b = temp;
          }
          if((Length[WEFT][0]/a - ExactLength[WEFT][0]/a) > 1) ygap = 1;
          else ygap = 0;
          i++;
       } else {
          if(ly >= ExactLength[WEFT][(i-1)%SeriesWeft]) {
            ly = 0;
            ratioy = (double)Length[WEFT][i%SeriesWeft]/ExactLength[WEFT][i%SeriesWeft];
            sumy += Length[WEFT][(i-1)%SeriesWeft];
            a = Length[WEFT][i%SeriesWeft];
            b = ExactLength[WEFT][i%SeriesWeft];
            while(a != b){
              temp = min(a,b);
              a = max(a, b) - min(a, b);
              b = temp;
            }
            if((Length[WEFT][i%SeriesWeft]/a - ExactLength[WEFT][i%SeriesWeft]/a) > 1) ygap = 1;
            else ygap = 0;
            i++;
          }
       }
       dp = (WORD *)TempBitmap->GetScanLine(TempBitmap->Height-1-y);
	   	 j =0, sumx = 0;
       for (int x=0; x<TempBitmap->Width; x++, dp++, lx++) {
         if(j == 0){
            lx = 0;
            ratiox = (double)Length[WARP][0]/ExactLength[WARP][0];
            a = Length[WARP][0], b = ExactLength[WARP][0];
            while(a != b){
              temp = min(a,b);
              a = max(a, b) - min(a, b);
              b = temp;
            }
            if((Length[WARP][0]/a - ExactLength[WARP][0]/a) > 1) xgap = 1;
            else xgap = 0;
            j++;
         } else {
            if(lx >= ExactLength[WARP][(j-1)%SeriesWarp]) {
               lx = 0;
               ratiox = (double)Length[WARP][j%SeriesWarp]/ExactLength[WARP][j%SeriesWarp];
               sumx += Length[WARP][(j-1)%SeriesWarp];
               a = Length[WARP][j%SeriesWarp], b = ExactLength[WARP][j%SeriesWarp];
               while(a != b){
                 temp = min(a,b);
                 a = max(a, b) - min(a, b);
                 b = temp;
               }
               if((Length[WARP][j%SeriesWarp]/a - ExactLength[WARP][j%SeriesWarp]/a) > 1) xgap = 1;
               else xgap = 0;
               j++;
            }
         }

         //bmWarp   ϴ ..rgb  ϴ  
         if(xgap == 0 && ygap == 0){
            sp1 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+sumy));
            sp2 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+sumy));
            sp3 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+1+sumy));
            sp4 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+1+sumy));
            c1 = sp1 & 0x3FFF; c2 = sp2 & 0x3FFF; c3 = sp3 & 0x3FFF; c4 = sp4 & 0x3FFF;
            if ((ratiox*lx - int(ratiox*lx)) > 0.001) {
               rgb1 = rgb2;
               rgb3 = rgb4;
            } else {
               if (sp1) {
                 if (sp1 & 0x8000) {    //ĵ 
                   rgb1.rgbBlue = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbGreen = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbRed = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);
                 } else {
                   rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor(0)->RGB;
                   if((c1>>3 == c2>>3) && (c1>>3 == c3>>3) && (c1>>3 == c4>>3)) {TempRGB = rgb2 = rgb4 = rgb1;  goto next;}
                 }
               } else { rgb1 = bgColor;}
               if (sp3) {
                 if (sp3 & 0x8000) {
                   rgb3.rgbBlue = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbGreen = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbRed = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);
                 } else {
                   rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor(0)->RGB;
                 }
               } else { rgb3 = bgColor;}
            }
            if (sp2) {
              if (sp2 & 0x8000) {
                rgb2.rgbBlue = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbGreen = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbRed = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);
              } else {
                rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor(0)->RGB;
              }
            } else { rgb2 = bgColor;}
            if (sp4) {
              if (sp4 & 0x8000) {
                rgb4.rgbBlue = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                rgb4.rgbGreen = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                rgb4.rgbRed = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);
              } else {
                rgb4 = Yarn->Choice[c4>>11].Color[(c4>>8)&7][(c4>>3)&0x1F]->GetColor(0)->RGB;
              }
            } else { rgb4 = bgColor;}

              TempRGB.rgbRed = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbRed
                              + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbRed
                              +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb3.rgbRed
                              + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb4.rgbRed
                              )/(ratiox*ratioy);
              TempRGB.rgbGreen = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbGreen
                              + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbGreen
                              +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb3.rgbGreen
                              + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb4.rgbGreen
                               )/(ratiox*ratioy);
              TempRGB.rgbBlue = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbBlue
                              + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbBlue
                              +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb3.rgbBlue
                              + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb4.rgbBlue
                               )/(ratiox*ratioy);

         } else if(xgap == 1 && ygap == 0) {
            sp1 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+sumy));
            sp2 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+sumy));
            sp4 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+1+sumy));
            sp5 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+1+sumy));
            if((ratiox*(lx+1) - int(ratiox*(lx+1))) < 0.0001 || int(ratiox*lx)+1 == int(ratiox*(lx+1))) {
               sp3 = sp2; sp6 = sp5;
            }else {
               sp3 = *(bmTemp->pointer(int(ratiox*(lx+1))+sumx, int(ratioy*ly)+sumy));
               sp6 = *(bmTemp->pointer(int(ratiox*(lx+1))+sumx, int(ratioy*ly)+1+sumy));
            }
            c1 = sp1 & 0x3FFF; c2 = sp2 & 0x3FFF; c3 = sp3 & 0x3FFF; c4 = sp4 & 0x3FFF;
            c5 = sp5 & 0x3FFF; c6 = sp6 & 0x3FFF;
            if ((ratiox*lx - int(ratiox*lx)) > 0.001) {
               rgb1 = rgb3;
               rgb4 = rgb6;
            } else {
               if (sp1) {
                 if (sp1 & 0x8000) {    //ĵ 
                   rgb1.rgbBlue = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbGreen = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbRed = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);
                 } else {
                   rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor(0)->RGB;
                   if((c1>>3 == c2>>3) && (c1>>3 == c3>>3) && (c1>>3 == c4>>3) && (c1>>3 == c5>>3) && (c1>>3 == c6>>3))
                         {TempRGB = rgb3 = rgb6 = rgb1;  goto next;}
                 }
               } else { rgb1 = bgColor;}
               if (sp4) {
                 if (sp4 & 0x8000) {
                   rgb4.rgbBlue = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                   rgb4.rgbGreen = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                   rgb4.rgbRed = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);
                 } else {
                   rgb4 = Yarn->Choice[c4>>11].Color[(c4>>8)&7][(c4>>3)&0x1F]->GetColor(0)->RGB;
                   }
               } else { rgb4 = bgColor;}
            }
            if (sp2) {
              if (sp2 & 0x8000) {
                rgb2.rgbBlue = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbGreen = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbRed = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);
              } else {
                rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor(0)->RGB;
              }
            } else { rgb2 = bgColor;}
            if (sp5) {
              if (sp5 & 0x8000) {
                rgb5.rgbBlue = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);  sp5 >>= 5;
                rgb5.rgbGreen = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);  sp5 >>= 5;
                rgb5.rgbRed = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);
              } else {
                rgb5 = Yarn->Choice[c5>>11].Color[(c5>>8)&7][(c5>>3)&0x1F]->GetColor(0)->RGB;
              }
            } else { rgb5 = bgColor;}

            if (sp3 == sp2 && sp6 == sp5){
               rgb3 = rgb2;
               rgb6 = rgb5;
            } else {
               if (sp3) {
                 if (sp3 & 0x8000) {
                   rgb3.rgbBlue = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbGreen = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbRed = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);
                 } else {
                   rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor(0)->RGB;
                 }
               } else { rgb3 = bgColor;}
               if (sp6) {
                 if (sp6 & 0x8000) {
                   rgb6.rgbBlue = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);  sp6 >>= 5;
                   rgb6.rgbGreen = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);  sp6 >>= 5;
                   rgb6.rgbRed = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);
                 } else {
                   rgb6 = Yarn->Choice[c6>>11].Color[(c6>>8)&7][(c6>>3)&0x1F]->GetColor(0)->RGB;
                 }
               } else { rgb6 = bgColor;}
            }
              TempRGB.rgbRed = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbRed
                            + (int(ratiox*(lx+1)) - (int(ratiox*lx)+1))* (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbRed
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*ly)+1 - ratioy*ly) * rgb3.rgbRed
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb4.rgbRed
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb5.rgbRed
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb6.rgbRed
                            )/(ratiox*ratioy);
              TempRGB.rgbGreen = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbGreen
                            + (int(ratiox*(lx+1)) - (int(ratiox*lx)+1))* (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbGreen
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*ly)+1 - ratioy*ly) * rgb3.rgbGreen
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb4.rgbGreen
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb5.rgbGreen
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb6.rgbGreen
                            )/(ratiox*ratioy);
              TempRGB.rgbBlue = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbBlue
                            + (int(ratiox*(lx+1)) - (int(ratiox*lx)+1))* (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbBlue
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*ly)+1 - ratioy*ly) * rgb3.rgbBlue
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb4.rgbBlue
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb5.rgbBlue
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb6.rgbBlue
                            )/(ratiox*ratioy);

         } else if(xgap == 0 && ygap == 1) {
            sp1 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+sumy));
            sp2 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+sumy));
            sp3 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+1+sumy));
            sp4 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+1+sumy));
            if( (ratioy*(ly+1) - int(ratioy*(ly+1))) < 0.0001 ){
               sp5 = sp3; sp6 = sp4;
            } else {
               sp5 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*(ly+1))+sumy)) & 0x3FFF;
               sp6 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*(ly+1))+sumy)) & 0x3FFF;
            }
            c1 = sp1 & 0x3FFF; c2 = sp2 & 0x3FFF; c3 = sp3 & 0x3FFF; c4 = sp4 & 0x3FFF;
            c5 = sp5 & 0x3FFF; c6 = sp6 & 0x3FFF;
           ////////////////////////////////////////////////////////////////////////////////////////////////////  qe test
            if(int(ratiox*(lx+1))+sumx >= bmTemp->size.x || int(ratioy*(ly+1))+sumy >= bmTemp->size.y) {ShowMessage("Oops!"); goto fail;}
            if ((ratiox*lx - int(ratiox*lx)) > 0.001) {
               rgb1 = rgb2;
               rgb3 = rgb4;
               rgb5 = rgb6;
            } else {
               if (sp1) {
                 if (sp1 & 0x8000) {    //ĵ 
                   rgb1.rgbBlue = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbGreen = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbRed = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);
                 } else {
                   rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor(0)->RGB;
                   if((c1>>3 == c2>>3) && (c1>>3 == c3>>3) && (c1>>3 == c4>>3) && (c1>>3 == c5>>3) && (c1>>3 == c6>>3))
                        {TempRGB = rgb2 =rgb4 =rgb6 = rgb1 ;  goto next;}
                 }
               } else { rgb1 = bgColor;}
               if (sp3) {
                 if (sp3 & 0x8000) {
                   rgb3.rgbBlue = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbGreen = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbRed = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);
                 } else {
                   rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor(0)->RGB;
                 }
               } else { rgb3 = bgColor;}
               if (sp5 == sp3) rgb5 = rgb3;
               else {
                  if (sp5) {
                    if (sp5 & 0x8000) {
                      rgb5.rgbBlue = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);  sp5 >>= 5;
                      rgb5.rgbGreen = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);  sp5 >>= 5;
                      rgb5.rgbRed = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);
                    } else {
                      rgb5 = Yarn->Choice[c5>>11].Color[(c5>>8)&7][(c5>>3)&0x1F]->GetColor(0)->RGB;
                    }
                  } else { rgb5 = bgColor;}
               }
            }
            if (sp2) {
              if (sp2 & 0x8000) {
                rgb2.rgbBlue = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbGreen = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbRed = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);
              } else {
                rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor(0)->RGB;
              }
            } else { rgb2 = bgColor;}
            if (sp4) {
              if (sp4 & 0x8000) {
                rgb4.rgbBlue = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                rgb4.rgbGreen = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                rgb4.rgbRed = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);
              } else {
                rgb4 = Yarn->Choice[c4>>11].Color[(c4>>8)&7][(c4>>3)&0x1F]->GetColor(0)->RGB;
              }
            } else { rgb4 = bgColor;}
            if (sp6 == sp4) rgb6 = rgb4;
            else {
               if (sp6) {
                 if (sp6 & 0x8000) {
                   rgb6.rgbBlue = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);  sp6 >>= 5;
                   rgb6.rgbGreen = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);  sp6 >>= 5;
                   rgb6.rgbRed = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);
                 } else {
                   rgb6 = Yarn->Choice[c6>>11].Color[(c6>>8)&7][(c6>>3)&0x1F]->GetColor(0)->RGB;
                 }
               } else { rgb6 = bgColor;}
            }
              TempRGB.rgbRed = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbRed
                            + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbRed
                            +(int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb3.rgbRed
                            +(ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb4.rgbRed
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb5.rgbRed
                            +(ratiox*(lx+1) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb6.rgbRed
                            )/(ratiox*ratioy);

              TempRGB.rgbGreen = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbGreen
                            + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbGreen
                            +(int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb3.rgbGreen
                            +(ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb4.rgbGreen
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb5.rgbGreen
                            +(ratiox*(lx+1) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb6.rgbGreen
                            )/(ratiox*ratioy);

              TempRGB.rgbBlue = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbBlue
                            + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbBlue
                            +(int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb3.rgbBlue
                            +(ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb4.rgbBlue
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb5.rgbBlue
                            +(ratiox*(lx+1) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb6.rgbBlue
                            )/(ratiox*ratioy);

         } else {
            sp1 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+sumy));
            sp2 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+sumy));
            if((ratiox*(lx+1) - int(ratiox*(lx+1))) < 0.0001) sp3 = sp2;
            else sp3 = *(bmTemp->pointer(int(ratiox*(lx+1))+sumx, int(ratioy*ly)+sumy));

            sp4 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+1+sumy));
            sp5 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+1+sumy));
            if((ratiox*(lx+1) - int(ratiox*(lx+1))) < 0.0001 || int(ratiox*(lx+1)) == int(ratiox*lx+1)) sp6 = sp5;
            else sp6 = *(bmTemp->pointer(int(ratiox*(lx+1))+sumx, int(ratioy*ly)+1+sumy));

            if( (ratioy*(ly+1) - int(ratioy*(ly+1))) < 0.0001 || int(ratioy*(ly+1)) == int(ratioy*ly+1)){
               sp7 = sp4;
               sp8 = sp5;
               sp9 = sp6;
            } else {
               sp7 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*(ly+1))+sumy));
               sp8 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*(ly+1))+sumy));
               if ((ratiox*(lx+1) - int(ratiox*(lx+1))) < 0.0001 || int(ratiox*(lx+1)) == int(ratiox*lx+1)) sp9 = sp8;
               else sp9 = *(bmTemp->pointer(int(ratiox*(lx+1))+sumx, int(ratioy*(ly+1))+sumy));
            }
            c1 = sp1 & 0x3FFF; c2 = sp2 & 0x3FFF; c3 = sp3 & 0x3FFF; c4 = sp4 & 0x3FFF; c5 = sp5 & 0x3FFF;
            c6 = sp6 & 0x3FFF; c7 = sp7 & 0x3FFF; c8 = sp8 & 0x3FFF; c9 = sp9 & 0x3FFF;

            if ((ratiox*lx - int(ratiox*lx)) > 0.001) {
               rgb1 = rgb3;
               rgb4 = rgb6;
               rgb7 = rgb9;
            } else {
               if (sp1) {
                 if (sp1 & 0x8000) {    //ĵ 
                   rgb1.rgbBlue = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbGreen = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbRed = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);
                 } else {
                   rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor(0)->RGB;
                    if((c1>>3 == c2>>3) && (c1>>3 == c3>>3) && (c1>>3 == c4>>3) && (c1>>3 == c5>>3) && (c1>>3 == c6>>3)
                       && (c1>>3 == c7>>3) && (c1>>3 && c8>>3) && (c1>>3 && c9>>3)) {TempRGB = rgb3 = rgb6 = rgb9 = rgb1;  goto next;}
                 }
               } else { rgb1 = bgColor;}
               if (sp4) {
                 if (sp4 & 0x8000) {
                   rgb4.rgbBlue = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                   rgb4.rgbGreen = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                   rgb4.rgbRed = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);
                 } else {
                   rgb4 = Yarn->Choice[c4>>11].Color[(c4>>8)&7][(c4>>3)&0x1F]->GetColor(0)->RGB;
                 }
               } else { rgb4 = bgColor;}
               if (sp7 == sp4) rgb7 = rgb4;
               else {
                  if (sp7) {
                    if (sp7 & 0x8000) {
                      rgb7.rgbBlue = ((sp7 & 0x1F) << 3) | ((sp7 & 0x1F) >> 2);  sp7 >>= 5;
                      rgb7.rgbGreen = ((sp7 & 0x1F) << 3) | ((sp7 & 0x1F) >> 2);  sp7 >>= 5;
                      rgb7.rgbRed = ((sp7 & 0x1F) << 3) | ((sp7 & 0x1F) >> 2);
                    } else {
                      rgb7 = Yarn->Choice[c7>>11].Color[(c7>>8)&7][(c7>>3)&0x1F]->GetColor(0)->RGB;
                    }
                  } else { rgb7 = bgColor;}
               }
            }

            if (sp2) {
              if (sp2 & 0x8000) {
                rgb2.rgbBlue = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbGreen = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbRed = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);
              } else {
                rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor(0)->RGB;
              }
            } else { rgb2 = bgColor;}
            if (sp5) {
              if (sp5 & 0x8000) {
                rgb5.rgbBlue = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);  sp5 >>= 5;
                rgb5.rgbGreen = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);  sp5 >>= 5;
                rgb5.rgbRed = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);
              } else {
                rgb5 = Yarn->Choice[c5>>11].Color[(c5>>8)&7][(c5>>3)&0x1F]->GetColor(0)->RGB;
              }
            } else { rgb5 = bgColor;}
            if (sp8 == sp5) rgb8 = rgb5;
            else {
               if(sp8){
                 if (sp8 & 0x8000) {
                   rgb8.rgbBlue = ((sp8 & 0x1F) << 3) | ((sp8 & 0x1F) >> 2);  sp8 >>= 5;
                   rgb8.rgbGreen = ((sp8 & 0x1F) << 3) | ((sp8 & 0x1F) >> 2);  sp8 >>= 5;
                   rgb8.rgbRed = ((sp8 & 0x1F) << 3) | ((sp8 & 0x1F) >> 2);
                 } else {
                   rgb8 = Yarn->Choice[c8>>11].Color[(c8>>8)&7][(c8>>3)&0x1F]->GetColor(0)->RGB;
                 }
               } else { rgb8 = bgColor;}
            }
            if (sp3 == sp2 && sp6 == sp5 && sp9 == sp8){
               rgb3 = rgb2;
               rgb6 = rgb5;
               rgb9 = rgb8;
            } else {
               if (sp3) {
                 if (sp3 & 0x8000) {
                   rgb3.rgbBlue = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbGreen = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbRed = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);
                 } else {
                   rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor(0)->RGB;
                 }
               } else { rgb3 = bgColor;}
               if (sp6) {
                 if (sp6 & 0x8000) {
                   rgb6.rgbBlue = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);  sp6 >>= 5;
                   rgb6.rgbGreen = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);  sp6 >>= 5;
                   rgb6.rgbRed = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);
                 } else {
                   rgb6 = Yarn->Choice[c6>>11].Color[(c6>>8)&7][(c6>>3)&0x1F]->GetColor(0)->RGB;
                 }
               } else { rgb6 = bgColor;}
               if (sp9 == sp6) rgb9 = rgb6;
               else {
                  if (sp9) {
                    if (sp9 & 0x8000) {
                      rgb9.rgbBlue = ((sp9 & 0x1F) << 3) | ((sp9 & 0x1F) >> 2);  sp9 >>= 5;
                      rgb9.rgbGreen = ((sp9 & 0x1F) << 3) | ((sp9 & 0x1F) >> 2);  sp9 >>= 5;
                      rgb9.rgbRed = ((sp9 & 0x1F) << 3) | ((sp9 & 0x1F) >> 2);
                    } else {
                      rgb9 = Yarn->Choice[c9>>11].Color[(c9>>8)&7][(c9>>3)&0x1F]->GetColor(0)->RGB;
                    }
                  } else { rgb9 = bgColor;}
               }
            }

              TempRGB.rgbRed = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbRed
                            + (int(ratiox*(lx+1)) - (int(ratiox*lx)+1))* (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbRed
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*ly)+1 - ratioy*ly) * rgb3.rgbRed
                            +(int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb4.rgbRed
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb5.rgbRed
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb6.rgbRed
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb7.rgbRed
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb8.rgbRed
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb9.rgbRed
                            )/(ratiox*ratioy);

              TempRGB.rgbGreen = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbGreen
                            + (int(ratiox*(lx+1)) - (int(ratiox*lx)+1))* (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbGreen
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*ly)+1 - ratioy*ly) * rgb3.rgbGreen
                            +(int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb4.rgbGreen
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb5.rgbGreen
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb6.rgbGreen
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb7.rgbGreen
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb8.rgbGreen
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb9.rgbGreen
                            )/(ratiox*ratioy);

              TempRGB.rgbBlue = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbBlue
                            + (int(ratiox*(lx+1)) - (int(ratiox*lx)+1))* (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbBlue
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*ly)+1 - ratioy*ly) * rgb3.rgbBlue
                            +(int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb4.rgbBlue
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb5.rgbBlue
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb6.rgbBlue
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb7.rgbBlue
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb8.rgbBlue
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb9.rgbBlue
                            )/(ratiox*ratioy);
         }
next:
         *dp = RGBToColor15(TempRGB);
       }
     	TempBitmap->PutScanLine(TempBitmap->Height-1-y);
	   }
  } else if (WeaveCondition.WovenEffect==WETypeA) {
      for (int y=0; y<TempBitmap->Height; y++, ly++) {
       StatusProgress->Position = 50 + 5*(10*y/TempBitmap->Height);
       if(i == 0){                                                //ó ..
          ly = 0;
          ratioy  = (double)Length[WEFT][0]/ExactLength[WEFT][0];
          a = Length[WEFT][0];
          b = ExactLength[WEFT][0];
          while(a != b){
              temp = min(a,b);
              a = max(a, b) - min(a, b);
              b = temp;
          }
          if((Length[WEFT][0]/a - ExactLength[WEFT][0]/a) > 1) ygap = 1;
          else ygap = 0;
          i++;
       } else {
          if(ly >= ExactLength[WEFT][(i-1)%SeriesWeft]) {
            ly = 0;
            ratioy = (double)Length[WEFT][i%SeriesWeft]/ExactLength[WEFT][i%SeriesWeft];
            sumy += Length[WEFT][(i-1)%SeriesWeft];
            a = Length[WEFT][i%SeriesWeft];
            b = ExactLength[WEFT][i%SeriesWeft];
            while(a != b){
              temp = min(a,b);
              a = max(a, b) - min(a, b);
              b = temp;
            }
            if((Length[WEFT][i%SeriesWeft]/a - ExactLength[WEFT][i%SeriesWeft]/a) > 1) ygap = 1;
            else ygap = 0;
            i++;
          }
       }
       dp = (WORD *)TempBitmap->GetScanLine(TempBitmap->Height-1-y);
	   	 j =0, sumx = 0;
       for (int x=0; x<TempBitmap->Width; x++, dp++, lx++) {
         if(j == 0){
            lx = 0;
            ratiox = (double)Length[WARP][0]/ExactLength[WARP][0];
            a = Length[WARP][0], b = ExactLength[WARP][0];
            while(a != b){
              temp = min(a,b);
              a = max(a, b) - min(a, b);
              b = temp;
            }
            if((Length[WARP][0]/a - ExactLength[WARP][0]/a) > 1) xgap = 1;
            else xgap = 0;
            j++;
         } else {
            if(lx >= ExactLength[WARP][(j-1)%SeriesWarp]) {
               lx = 0;
               ratiox = (double)Length[WARP][j%SeriesWarp]/ExactLength[WARP][j%SeriesWarp];
               sumx += Length[WARP][(j-1)%SeriesWarp];
               a = Length[WARP][j%SeriesWarp], b = ExactLength[WARP][j%SeriesWarp];
               while(a != b){
                 temp = min(a,b);
                 a = max(a, b) - min(a, b);
                 b = temp;
               }
               if((Length[WARP][j%SeriesWarp]/a - ExactLength[WARP][j%SeriesWarp]/a) > 1) xgap = 1;
               else xgap = 0;
               j++;
            }
         }

         //bmWarp   ϴ ..rgb  ϴ  
         if(xgap == 0 && ygap == 0){
            sp1 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+sumy));
            sp2 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+sumy));
            sp3 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+1+sumy));
            sp4 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+1+sumy));
            c1 = sp1 & 0x3FFF; c2 = sp2 & 0x3FFF; c3 = sp3 & 0x3FFF; c4 = sp4 & 0x3FFF;
            if ((ratiox*lx - int(ratiox*lx)) > 0.001) {
               rgb1 = rgb2;
               rgb3 = rgb4;
            } else {
               if (sp1) {
                 if (sp1 & 0x8000) {    //ĵ 
                   rgb1.rgbBlue = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbGreen = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbRed = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);
                 } else {
                   rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor((c1&7)-4)->RGB;
                 }
               } else { rgb1 = bgColor;}
               if (sp3) {
                 if (sp3 & 0x8000) {
                   rgb3.rgbBlue = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbGreen = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbRed = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);
                 } else {
                   rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor((c3&7)-4)->RGB;
                 }
               } else { rgb3 = bgColor;}
            }
            if (sp2) {
              if (sp2 & 0x8000) {
                rgb2.rgbBlue = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbGreen = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbRed = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);
              } else {
                rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor((c2&7)-4)->RGB;
              }
            } else { rgb2 = bgColor;}
            if (sp4) {
              if (sp4 & 0x8000) {
                rgb4.rgbBlue = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                rgb4.rgbGreen = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                rgb4.rgbRed = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);
              } else {
                rgb4 = Yarn->Choice[c4>>11].Color[(c4>>8)&7][(c4>>3)&0x1F]->GetColor((c4&7)-4)->RGB;
              }
            } else { rgb4 = bgColor;}

              TempRGB.rgbRed = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbRed
                              + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbRed
                              +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb3.rgbRed
                              + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb4.rgbRed
                              )/(ratiox*ratioy);
              TempRGB.rgbGreen = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbGreen
                              + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbGreen
                              +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb3.rgbGreen
                              + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb4.rgbGreen
                               )/(ratiox*ratioy);
              TempRGB.rgbBlue = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbBlue
                              + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbBlue
                              +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb3.rgbBlue
                              + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb4.rgbBlue
                               )/(ratiox*ratioy);

         } else if(xgap == 1 && ygap == 0) {
            sp1 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+sumy));
            sp2 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+sumy));
            sp4 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+1+sumy));
            sp5 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+1+sumy));
            if((ratiox*(lx+1) - int(ratiox*(lx+1))) < 0.0001 || int(ratiox*lx)+1 == int(ratiox*(lx+1))) {
               sp3 = sp2; sp6 = sp5;
            }else {
               sp3 = *(bmTemp->pointer(int(ratiox*(lx+1))+sumx, int(ratioy*ly)+sumy));
               sp6 = *(bmTemp->pointer(int(ratiox*(lx+1))+sumx, int(ratioy*ly)+1+sumy));
            }
            c1 = sp1 & 0x3FFF; c2 = sp2 & 0x3FFF; c3 = sp3 & 0x3FFF; c4 = sp4 & 0x3FFF;
            c5 = sp5 & 0x3FFF; c6 = sp6 & 0x3FFF;
            if ((ratiox*lx - int(ratiox*lx)) > 0.001) {
               rgb1 = rgb3;
               rgb4 = rgb6;
            } else {
               if (sp1) {
                 if (sp1 & 0x8000) {    //ĵ 
                   rgb1.rgbBlue = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbGreen = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbRed = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);
                 } else {
                   rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor((c1&7)-4)->RGB;
                 }
               } else { rgb1 = bgColor;}
               if (sp4) {
                 if (sp4 & 0x8000) {
                   rgb4.rgbBlue = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                   rgb4.rgbGreen = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                   rgb4.rgbRed = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);
                 } else {
                   rgb4 = Yarn->Choice[c4>>11].Color[(c4>>8)&7][(c4>>3)&0x1F]->GetColor((c4&7)-4)->RGB;
                 }
               } else { rgb4 = bgColor;}
            }
            if (sp2) {
              if (sp2 & 0x8000) {
                rgb2.rgbBlue = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbGreen = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbRed = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);
              } else {
                rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor((c2&7)-4)->RGB;
              }
            } else { rgb2 = bgColor;}
            if (sp5) {
              if (sp5 & 0x8000) {
                rgb5.rgbBlue = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);  sp5 >>= 5;
                rgb5.rgbGreen = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);  sp5 >>= 5;
                rgb5.rgbRed = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);
              } else {
                rgb5 = Yarn->Choice[c5>>11].Color[(c5>>8)&7][(c5>>3)&0x1F]->GetColor((c5&7)-4)->RGB;
              }
            } else { rgb5 = bgColor;}

            if (sp3 == sp2 && sp6 == sp5){
               rgb3 = rgb2;
               rgb6 = rgb5;
            } else {
               if (sp3) {
                 if (sp3 & 0x8000) {
                   rgb3.rgbBlue = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbGreen = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbRed = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);
                 } else {
                   rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor((c3&7)-4)->RGB;
                 }
               } else { rgb3 = bgColor;}
               if (sp6) {
                 if (sp6 & 0x8000) {
                   rgb6.rgbBlue = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);  sp6 >>= 5;
                   rgb6.rgbGreen = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);  sp6 >>= 5;
                   rgb6.rgbRed = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);
                 } else {
                   rgb6 = Yarn->Choice[c6>>11].Color[(c6>>8)&7][(c6>>3)&0x1F]->GetColor((c6&7)-4)->RGB;
                 }
               } else { rgb6 = bgColor;}
            }
              TempRGB.rgbRed = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbRed
                            + (int(ratiox*(lx+1)) - (int(ratiox*lx)+1))* (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbRed
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*ly)+1 - ratioy*ly) * rgb3.rgbRed
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb4.rgbRed
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb5.rgbRed
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb6.rgbRed
                            )/(ratiox*ratioy);
              TempRGB.rgbGreen = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbGreen
                            + (int(ratiox*(lx+1)) - (int(ratiox*lx)+1))* (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbGreen
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*ly)+1 - ratioy*ly) * rgb3.rgbGreen
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb4.rgbGreen
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb5.rgbGreen
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb6.rgbGreen
                            )/(ratiox*ratioy);
              TempRGB.rgbBlue = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbBlue
                            + (int(ratiox*(lx+1)) - (int(ratiox*lx)+1))* (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbBlue
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*ly)+1 - ratioy*ly) * rgb3.rgbBlue
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb4.rgbBlue
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb5.rgbBlue
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb6.rgbBlue
                            )/(ratiox*ratioy);

         } else if(xgap == 0 && ygap == 1) {
            sp1 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+sumy));
            sp2 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+sumy));
            sp3 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+1+sumy));
            sp4 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+1+sumy));
            if( (ratioy*(ly+1) - int(ratioy*(ly+1))) < 0.0001 ){
               sp5 = sp3; sp6 = sp4;
            } else {
               sp5 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*(ly+1))+sumy)) & 0x3FFF;
               sp6 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*(ly+1))+sumy)) & 0x3FFF;
            }
            c1 = sp1 & 0x3FFF; c2 = sp2 & 0x3FFF; c3 = sp3 & 0x3FFF; c4 = sp4 & 0x3FFF;
            c5 = sp5 & 0x3FFF; c6 = sp6 & 0x3FFF;
           ////////////////////////////////////////////////////////////////////////////////////////////////////  qe test
            if(int(ratiox*(lx+1))+sumx >= bmTemp->size.x || int(ratioy*(ly+1))+sumy >= bmTemp->size.y) {ShowMessage("Oops!"); goto fail;}
            if ((ratiox*lx - int(ratiox*lx)) > 0.001) {
               rgb1 = rgb2;
               rgb3 = rgb4;
               rgb5 = rgb6;
            } else {
               if (sp1) {
                 if (sp1 & 0x8000) {    //ĵ 
                   rgb1.rgbBlue = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbGreen = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbRed = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);
                 } else {
                   rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor((c1&7)-4)->RGB;
                 }
               } else { rgb1 = bgColor;}
               if (sp3) {
                 if (sp3 & 0x8000) {
                   rgb3.rgbBlue = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbGreen = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbRed = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);
                 } else {
                   rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor((c3&7)-4)->RGB;
                 }
               } else { rgb3 = bgColor;}
               if (sp5 == sp3) rgb5 = rgb3;
               else {
                  if (sp5) {
                    if (sp5 & 0x8000) {
                      rgb5.rgbBlue = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);  sp5 >>= 5;
                      rgb5.rgbGreen = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);  sp5 >>= 5;
                      rgb5.rgbRed = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);
                    } else {
                      rgb5 = Yarn->Choice[c5>>11].Color[(c5>>8)&7][(c5>>3)&0x1F]->GetColor((c5&7)-4)->RGB;
                    }
                  } else { rgb5 = bgColor;}
               }
            }
            if (sp2) {
              if (sp2 & 0x8000) {
                rgb2.rgbBlue = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbGreen = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbRed = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);
              } else {
                rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor((c2&7)-4)->RGB;
              }
            } else { rgb2 = bgColor;}
            if (sp4) {
              if (sp4 & 0x8000) {
                rgb4.rgbBlue = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                rgb4.rgbGreen = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                rgb4.rgbRed = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);
              } else {
                rgb4 = Yarn->Choice[c4>>11].Color[(c4>>8)&7][(c4>>3)&0x1F]->GetColor((c4&7)-4)->RGB;
              }
            } else { rgb4 = bgColor;}
            if (sp6 == sp4) rgb6 = rgb4;
            else {
               if (sp6) {
                 if (sp6 & 0x8000) {
                   rgb6.rgbBlue = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);  sp6 >>= 5;
                   rgb6.rgbGreen = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);  sp6 >>= 5;
                   rgb6.rgbRed = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);
                 } else {
                   rgb6 = Yarn->Choice[c6>>11].Color[(c6>>8)&7][(c6>>3)&0x1F]->GetColor((c6&7)-4)->RGB;
                 }
               } else { rgb6 = bgColor;}
            }
              TempRGB.rgbRed = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbRed
                            + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbRed
                            +(int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb3.rgbRed
                            +(ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb4.rgbRed
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb5.rgbRed
                            +(ratiox*(lx+1) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb6.rgbRed
                            )/(ratiox*ratioy);

              TempRGB.rgbGreen = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbGreen
                            + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbGreen
                            +(int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb3.rgbGreen
                            +(ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb4.rgbGreen
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb5.rgbGreen
                            +(ratiox*(lx+1) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb6.rgbGreen
                            )/(ratiox*ratioy);

              TempRGB.rgbBlue = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbBlue
                            + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbBlue
                            +(int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb3.rgbBlue
                            +(ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb4.rgbBlue
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb5.rgbBlue
                            +(ratiox*(lx+1) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb6.rgbBlue
                            )/(ratiox*ratioy);

         } else {
            sp1 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+sumy));
            sp2 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+sumy));
            if((ratiox*(lx+1) - int(ratiox*(lx+1))) < 0.0001) sp3 = sp2;
            else sp3 = *(bmTemp->pointer(int(ratiox*(lx+1))+sumx, int(ratioy*ly)+sumy));

            sp4 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+1+sumy));
            sp5 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+1+sumy));
            if((ratiox*(lx+1) - int(ratiox*(lx+1))) < 0.0001 || int(ratiox*(lx+1)) == int(ratiox*lx+1)) sp6 = sp5;
            else sp6 = *(bmTemp->pointer(int(ratiox*(lx+1))+sumx, int(ratioy*ly)+1+sumy));

            if( (ratioy*(ly+1) - int(ratioy*(ly+1))) < 0.0001 || int(ratioy*(ly+1)) == int(ratioy*ly+1)){
               sp7 = sp4;
               sp8 = sp5;
               sp9 = sp6;
            } else {
               sp7 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*(ly+1))+sumy));
               sp8 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*(ly+1))+sumy));
               if ((ratiox*(lx+1) - int(ratiox*(lx+1))) < 0.0001 || int(ratiox*(lx+1)) == int(ratiox*lx+1)) sp9 = sp8;
               else sp9 = *(bmTemp->pointer(int(ratiox*(lx+1))+sumx, int(ratioy*(ly+1))+sumy));
            }
            c1 = sp1 & 0x3FFF; c2 = sp2 & 0x3FFF; c3 = sp3 & 0x3FFF; c4 = sp4 & 0x3FFF; c5 = sp5 & 0x3FFF;
            c6 = sp6 & 0x3FFF; c7 = sp7 & 0x3FFF; c8 = sp8 & 0x3FFF; c9 = sp9 & 0x3FFF;

            if ((ratiox*lx - int(ratiox*lx)) > 0.001) {
               rgb1 = rgb3;
               rgb4 = rgb6;
               rgb7 = rgb9;
            } else {
               if (sp1) {
                 if (sp1 & 0x8000) {    //ĵ 
                   rgb1.rgbBlue = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbGreen = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbRed = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);
                 } else {
                   rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor((c1&7)-4)->RGB;
                 }
               } else { rgb1 = bgColor;}
               if (sp4) {
                 if (sp4 & 0x8000) {
                   rgb4.rgbBlue = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                   rgb4.rgbGreen = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                   rgb4.rgbRed = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);
                 } else {
                   rgb4 = Yarn->Choice[c4>>11].Color[(c4>>8)&7][(c4>>3)&0x1F]->GetColor((c4&7)-4)->RGB;
                 }
               } else { rgb4 = bgColor;}
               if (sp7 == sp4) rgb7 = rgb4;
               else {
                  if (sp7) {
                    if (sp7 & 0x8000) {
                      rgb7.rgbBlue = ((sp7 & 0x1F) << 3) | ((sp7 & 0x1F) >> 2);  sp7 >>= 5;
                      rgb7.rgbGreen = ((sp7 & 0x1F) << 3) | ((sp7 & 0x1F) >> 2);  sp7 >>= 5;
                      rgb7.rgbRed = ((sp7 & 0x1F) << 3) | ((sp7 & 0x1F) >> 2);
                    } else {
                      rgb7 = Yarn->Choice[c7>>11].Color[(c7>>8)&7][(c7>>3)&0x1F]->GetColor((c7&7)-4)->RGB;
                    }
                  } else { rgb7 = bgColor;}
               }
            }

            if (sp2) {
              if (sp2 & 0x8000) {
                rgb2.rgbBlue = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbGreen = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbRed = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);
              } else {
                rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor((c2&7)-4)->RGB;
              }
            } else { rgb2 = bgColor;}
            if (sp5) {
              if (sp5 & 0x8000) {
                rgb5.rgbBlue = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);  sp5 >>= 5;
                rgb5.rgbGreen = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);  sp5 >>= 5;
                rgb5.rgbRed = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);
              } else {
                rgb5 = Yarn->Choice[c5>>11].Color[(c5>>8)&7][(c5>>3)&0x1F]->GetColor((c5&7)-4)->RGB;
              }
            } else { rgb5 = bgColor;}
            if (sp8 == sp5) rgb8 = rgb5;
            else {
               if(sp8){
                 if (sp8 & 0x8000) {
                   rgb8.rgbBlue = ((sp8 & 0x1F) << 3) | ((sp8 & 0x1F) >> 2);  sp8 >>= 5;
                   rgb8.rgbGreen = ((sp8 & 0x1F) << 3) | ((sp8 & 0x1F) >> 2);  sp8 >>= 5;
                   rgb8.rgbRed = ((sp8 & 0x1F) << 3) | ((sp8 & 0x1F) >> 2);
                 } else {
                   rgb8 = Yarn->Choice[c8>>11].Color[(c8>>8)&7][(c8>>3)&0x1F]->GetColor((c8&7)-4)->RGB;
                 }
               } else { rgb8 = bgColor;}
            }
            if (sp3 == sp2 && sp6 == sp5 && sp9 == sp8){
               rgb3 = rgb2;
               rgb6 = rgb5;
               rgb9 = rgb8;
            } else {
               if (sp3) {
                 if (sp3 & 0x8000) {
                   rgb3.rgbBlue = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbGreen = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbRed = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);
                 } else {
                   rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor((c3&7)-4)->RGB;
                 }
               } else { rgb3 = bgColor;}
               if (sp6) {
                 if (sp6 & 0x8000) {
                   rgb6.rgbBlue = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);  sp6 >>= 5;
                   rgb6.rgbGreen = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);  sp6 >>= 5;
                   rgb6.rgbRed = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);
                 } else {
                   rgb6 = Yarn->Choice[c6>>11].Color[(c6>>8)&7][(c6>>3)&0x1F]->GetColor((c6&7)-4)->RGB;
                 }
               } else { rgb6 = bgColor;}
               if (sp9 == sp6) rgb9 = rgb6;
               else {
                  if (sp9) {
                    if (sp9 & 0x8000) {
                      rgb9.rgbBlue = ((sp9 & 0x1F) << 3) | ((sp9 & 0x1F) >> 2);  sp9 >>= 5;
                      rgb9.rgbGreen = ((sp9 & 0x1F) << 3) | ((sp9 & 0x1F) >> 2);  sp9 >>= 5;
                      rgb9.rgbRed = ((sp9 & 0x1F) << 3) | ((sp9 & 0x1F) >> 2);
                    } else {
                      rgb9 = Yarn->Choice[c9>>11].Color[(c9>>8)&7][(c9>>3)&0x1F]->GetColor((c9&7)-4)->RGB;
                    }
                  } else { rgb9 = bgColor;}
               }
            }

              TempRGB.rgbRed = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbRed
                            + (int(ratiox*(lx+1)) - (int(ratiox*lx)+1))* (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbRed
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*ly)+1 - ratioy*ly) * rgb3.rgbRed
                            +(int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb4.rgbRed
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb5.rgbRed
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb6.rgbRed
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb7.rgbRed
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb8.rgbRed
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb9.rgbRed
                            )/(ratiox*ratioy);

              TempRGB.rgbGreen = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbGreen
                            + (int(ratiox*(lx+1)) - (int(ratiox*lx)+1))* (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbGreen
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*ly)+1 - ratioy*ly) * rgb3.rgbGreen
                            +(int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb4.rgbGreen
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb5.rgbGreen
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb6.rgbGreen
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb7.rgbGreen
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb8.rgbGreen
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb9.rgbGreen
                            )/(ratiox*ratioy);

              TempRGB.rgbBlue = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbBlue
                            + (int(ratiox*(lx+1)) - (int(ratiox*lx)+1))* (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbBlue
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*ly)+1 - ratioy*ly) * rgb3.rgbBlue
                            +(int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb4.rgbBlue
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb5.rgbBlue
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb6.rgbBlue
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb7.rgbBlue
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb8.rgbBlue
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb9.rgbBlue
                            )/(ratiox*ratioy);
         }
         *dp = RGBToColor15(TempRGB);
       }
     	TempBitmap->PutScanLine(TempBitmap->Height-1-y);
	   }
  } else {
      for (int y=0; y<TempBitmap->Height; y++, ly++) {
       StatusProgress->Position = 50 + 5*(10*y/TempBitmap->Height);
       if(i == 0){                                                //ó ..
          ly = 0;
          ratioy  = (double)Length[WEFT][0]/ExactLength[WEFT][0];
          a = Length[WEFT][0];
          b = ExactLength[WEFT][0];
          while(a != b){
              temp = min(a,b);
              a = max(a, b) - min(a, b);
              b = temp;
          }
          if((Length[WEFT][0]/a - ExactLength[WEFT][0]/a) > 1) ygap = 1;
          else ygap = 0;
          i++;
       } else {
          if(ly >= ExactLength[WEFT][(i-1)%SeriesWeft]) {
            ly = 0;
            ratioy = (double)Length[WEFT][i%SeriesWeft]/ExactLength[WEFT][i%SeriesWeft];
            sumy += Length[WEFT][(i-1)%SeriesWeft];
            a = Length[WEFT][i%SeriesWeft];
            b = ExactLength[WEFT][i%SeriesWeft];
            while(a != b){
              temp = min(a,b);
              a = max(a, b) - min(a, b);
              b = temp;
            }
            if((Length[WEFT][i%SeriesWeft]/a - ExactLength[WEFT][i%SeriesWeft]/a) > 1) ygap = 1;
            else ygap = 0;
            i++;
          }
       }
       dp = (WORD *)TempBitmap->GetScanLine(TempBitmap->Height-1-y);
	   	 j =0, sumx = 0;
       for (int x=0; x<TempBitmap->Width; x++, dp++, lx++) {
         if(j == 0){
            lx = 0;
            ratiox = (double)Length[WARP][0]/ExactLength[WARP][0];
            a = Length[WARP][0], b = ExactLength[WARP][0];
            while(a != b){
              temp = min(a,b);
              a = max(a, b) - min(a, b);
              b = temp;
            }
            if((Length[WARP][0]/a - ExactLength[WARP][0]/a) > 1) xgap = 1;
            else xgap = 0;
            j++;
         } else {
            if(lx >= ExactLength[WARP][(j-1)%SeriesWarp]) {
               lx = 0;
               ratiox = (double)Length[WARP][j%SeriesWarp]/ExactLength[WARP][j%SeriesWarp];
               sumx += Length[WARP][(j-1)%SeriesWarp];
               a = Length[WARP][j%SeriesWarp], b = ExactLength[WARP][j%SeriesWarp];
               while(a != b){
                 temp = min(a,b);
                 a = max(a, b) - min(a, b);
                 b = temp;
               }
               if((Length[WARP][j%SeriesWarp]/a - ExactLength[WARP][j%SeriesWarp]/a) > 1) xgap = 1;
               else xgap = 0;
               j++;
            }
         }

         //bmWarp   ϴ ..rgb  ϴ  
         if(xgap == 0 && ygap == 0){
            sp1 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+sumy));
            sp2 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+sumy));
            sp3 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+1+sumy));
            sp4 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+1+sumy));
            c1 = sp1 & 0x3FFF; c2 = sp2 & 0x3FFF; c3 = sp3 & 0x3FFF; c4 = sp4 & 0x3FFF;
            if ((ratiox*lx - int(ratiox*lx)) > 0.001) {
               rgb1 = rgb2;
               rgb3 = rgb4;
            } else {
               if (sp1) {
                 if (sp1 & 0x8000) {    //ĵ 
                   rgb1.rgbBlue = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbGreen = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbRed = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);
                 } else {
                   if(sp1 & 0x4000) rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor((c1&7)>>1)->RGB;
                   else rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor(-((c1&7)>>1))->RGB;
                 }
               } else { rgb1 = bgColor;}
               if (sp3) {
                 if (sp3 & 0x8000) {
                   rgb3.rgbBlue = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbGreen = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbRed = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);
                 } else {
                   if(sp3 & 0x4000) rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor((c3&7)>>1)->RGB;
                   else rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor(-((c3&7)>>1))->RGB;
                 }
               } else { rgb3 = bgColor;}
            }
            if (sp2) {
              if (sp2 & 0x8000) {
                rgb2.rgbBlue = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbGreen = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbRed = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);
              } else {
                if(sp2 & 0x4000) rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor((c2&7)>>1)->RGB;
                else rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor(-((c2&7)>>1))->RGB;
              }
            } else { rgb2 = bgColor;}
            if (sp4) {
              if (sp4 & 0x8000) {
                rgb4.rgbBlue = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                rgb4.rgbGreen = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                rgb4.rgbRed = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);
              } else {
                if(sp4 & 0x4000) rgb4 = Yarn->Choice[c4>>11].Color[(c4>>8)&7][(c4>>3)&0x1F]->GetColor((c4&7)>>1)->RGB;
                else rgb4 = Yarn->Choice[c4>>11].Color[(c4>>8)&7][(c4>>3)&0x1F]->GetColor(-((c4&7)>>1))->RGB;
              }
            } else { rgb4 = bgColor;}

              TempRGB.rgbRed = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbRed
                              + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbRed
                              +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb3.rgbRed
                              + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb4.rgbRed
                              )/(ratiox*ratioy);
              TempRGB.rgbGreen = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbGreen
                              + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbGreen
                              +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb3.rgbGreen
                              + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb4.rgbGreen
                               )/(ratiox*ratioy);
              TempRGB.rgbBlue = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbBlue
                              + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbBlue
                              +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb3.rgbBlue
                              + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb4.rgbBlue
                               )/(ratiox*ratioy);

         } else if(xgap == 1 && ygap == 0) {
            sp1 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+sumy));
            sp2 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+sumy));
            sp4 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+1+sumy));
            sp5 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+1+sumy));
            if((ratiox*(lx+1) - int(ratiox*(lx+1))) < 0.0001 || int(ratiox*lx)+1 == int(ratiox*(lx+1))) {
               sp3 = sp2; sp6 = sp5;
            }else {
               sp3 = *(bmTemp->pointer(int(ratiox*(lx+1))+sumx, int(ratioy*ly)+sumy));
               sp6 = *(bmTemp->pointer(int(ratiox*(lx+1))+sumx, int(ratioy*ly)+1+sumy));
            }
            c1 = sp1 & 0x3FFF; c2 = sp2 & 0x3FFF; c3 = sp3 & 0x3FFF; c4 = sp4 & 0x3FFF;
            c5 = sp5 & 0x3FFF; c6 = sp6 & 0x3FFF;
            if ((ratiox*lx - int(ratiox*lx)) > 0.001) {
               rgb1 = rgb3;
               rgb4 = rgb6;
            } else {
               if (sp1) {
                 if (sp1 & 0x8000) {    //ĵ 
                   rgb1.rgbBlue = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbGreen = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbRed = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);
                 } else {
                   if(sp1 & 0x4000) rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor((c1&7)>>1)->RGB;
                   else rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor(-((c1&7)>>1))->RGB;
                 }
               } else { rgb1 = bgColor;}
               if (sp4) {
                 if (sp4 & 0x8000) {
                   rgb4.rgbBlue = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                   rgb4.rgbGreen = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                   rgb4.rgbRed = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);
                 } else {
                   if(sp4 & 0x4000) rgb4 = Yarn->Choice[c4>>11].Color[(c4>>8)&7][(c4>>3)&0x1F]->GetColor((c4&7)>>1)->RGB;
                   else rgb4 = Yarn->Choice[c4>>11].Color[(c4>>8)&7][(c4>>3)&0x1F]->GetColor(-((c4&7)>>1))->RGB;
                 }
               } else { rgb4 = bgColor;}
            }
            if (sp2) {
              if (sp2 & 0x8000) {
                rgb2.rgbBlue = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbGreen = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbRed = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);
              } else {
                if(sp2 & 0x4000) rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor((c2&7)>>1)->RGB;
                else rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor(-((c2&7)>>1))->RGB;
              }
            } else { rgb2 = bgColor;}
            if (sp5) {
              if (sp5 & 0x8000) {
                rgb5.rgbBlue = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);  sp5 >>= 5;
                rgb5.rgbGreen = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);  sp5 >>= 5;
                rgb5.rgbRed = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);
              } else {
                if(sp5 & 0x4000) rgb5 = Yarn->Choice[c5>>11].Color[(c5>>8)&7][(c5>>3)&0x1F]->GetColor((c5&7)>>1)->RGB;
                else rgb5 = Yarn->Choice[c5>>11].Color[(c5>>8)&7][(c5>>3)&0x1F]->GetColor(-((c5&7)>>1))->RGB;
              }
            } else { rgb5 = bgColor;}

            if (sp3 == sp2 && sp6 == sp5){
               rgb3 = rgb2;
               rgb6 = rgb5;
            } else {
               if (sp3) {
                 if (sp3 & 0x8000) {
                   rgb3.rgbBlue = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbGreen = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbRed = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);
                 } else {
                   if(sp3 & 0x4000) rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor((c3&7)>>1)->RGB;
                   else rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor(-((c3&7)>>1))->RGB;
                 }
               } else { rgb3 = bgColor;}
               if (sp6) {
                 if (sp6 & 0x8000) {
                   rgb6.rgbBlue = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);  sp6 >>= 5;
                   rgb6.rgbGreen = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);  sp6 >>= 5;
                   rgb6.rgbRed = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);
                 } else {
                   if(sp4 & 0x4000) rgb6 = Yarn->Choice[c6>>11].Color[(c6>>8)&7][(c6>>3)&0x1F]->GetColor((c6&7)>>1)->RGB;
                   else rgb6 = Yarn->Choice[c6>>11].Color[(c6>>8)&7][(c6>>3)&0x1F]->GetColor(-((c6&7)>>1))->RGB;
                 }
               } else { rgb6 = bgColor;}
            }
              TempRGB.rgbRed = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbRed
                            + (int(ratiox*(lx+1)) - (int(ratiox*lx)+1))* (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbRed
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*ly)+1 - ratioy*ly) * rgb3.rgbRed
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb4.rgbRed
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb5.rgbRed
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb6.rgbRed
                            )/(ratiox*ratioy);
              TempRGB.rgbGreen = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbGreen
                            + (int(ratiox*(lx+1)) - (int(ratiox*lx)+1))* (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbGreen
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*ly)+1 - ratioy*ly) * rgb3.rgbGreen
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb4.rgbGreen
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb5.rgbGreen
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb6.rgbGreen
                            )/(ratiox*ratioy);
              TempRGB.rgbBlue = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbBlue
                            + (int(ratiox*(lx+1)) - (int(ratiox*lx)+1))* (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbBlue
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*ly)+1 - ratioy*ly) * rgb3.rgbBlue
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb4.rgbBlue
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb5.rgbBlue
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (ratioy*(ly+1) - (int(ratioy*ly)+1)) * rgb6.rgbBlue
                            )/(ratiox*ratioy);

         } else if(xgap == 0 && ygap == 1) {
            sp1 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+sumy));
            sp2 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+sumy));
            sp3 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+1+sumy));
            sp4 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+1+sumy));
            if( (ratioy*(ly+1) - int(ratioy*(ly+1))) < 0.0001 ){
               sp5 = sp3; sp6 = sp4;
            } else {
               sp5 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*(ly+1))+sumy)) & 0x3FFF;
               sp6 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*(ly+1))+sumy)) & 0x3FFF;
            }
            c1 = sp1 & 0x3FFF; c2 = sp2 & 0x3FFF; c3 = sp3 & 0x3FFF; c4 = sp4 & 0x3FFF;
            c5 = sp5 & 0x3FFF; c6 = sp6 & 0x3FFF;
           ////////////////////////////////////////////////////////////////////////////////////////////////////  qe test
            if(int(ratiox*(lx+1))+sumx >= bmTemp->size.x || int(ratioy*(ly+1))+sumy >= bmTemp->size.y) {ShowMessage("Oops!"); goto fail;}
            if ((ratiox*lx - int(ratiox*lx)) > 0.001) {
               rgb1 = rgb2;
               rgb3 = rgb4;
               rgb5 = rgb6;
            } else {
               if (sp1) {
                 if (sp1 & 0x8000) {    //ĵ 
                   rgb1.rgbBlue = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbGreen = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbRed = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);
                 } else {
                   if(sp1 & 0x4000) rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor((c1&7)>>1)->RGB;
                   else rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor(-((c1&7)>>1))->RGB;
                 }
               } else { rgb1 = bgColor;}
               if (sp3) {
                 if (sp3 & 0x8000) {
                   rgb3.rgbBlue = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbGreen = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbRed = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);
                 } else {
                   if(sp3 & 0x4000) rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor((c3&7)>>1)->RGB;
                   else rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor(-((c3&7)>>1))->RGB;
                 }
               } else { rgb3 = bgColor;}
               if (sp5 == sp3) rgb5 = rgb3;
               else {
                  if (sp5) {
                    if (sp5 & 0x8000) {
                      rgb5.rgbBlue = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);  sp5 >>= 5;
                      rgb5.rgbGreen = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);  sp5 >>= 5;
                      rgb5.rgbRed = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);
                    } else {
                      if(sp5 & 0x4000) rgb5 = Yarn->Choice[c5>>11].Color[(c5>>8)&7][(c5>>3)&0x1F]->GetColor((c5&7)>>1)->RGB;
                      else rgb5 = Yarn->Choice[c5>>11].Color[(c5>>8)&7][(c5>>3)&0x1F]->GetColor(-((c5&7)>>1))->RGB;
                    }
                  } else { rgb5 = bgColor;}
               }
            }
            if (sp2) {
              if (sp2 & 0x8000) {
                rgb2.rgbBlue = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbGreen = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbRed = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);
              } else {
                if(sp2 & 0x4000) rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor((c2&7)>>1)->RGB;
                else rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor(-((c2&7)>>1))->RGB;
              }
            } else { rgb2 = bgColor;}
            if (sp4) {
              if (sp4 & 0x8000) {
                rgb4.rgbBlue = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                rgb4.rgbGreen = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                rgb4.rgbRed = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);
              } else {
                if(sp4 & 0x4000) rgb4 = Yarn->Choice[c4>>11].Color[(c4>>8)&7][(c4>>3)&0x1F]->GetColor((c4&7)>>1)->RGB;
                else rgb4 = Yarn->Choice[c4>>11].Color[(c4>>8)&7][(c4>>3)&0x1F]->GetColor(-((c4&7)>>1))->RGB;
              }
            } else { rgb4 = bgColor;}
            if (sp6 == sp4) rgb6 = rgb4;
            else {
               if (sp6) {
                 if (sp6 & 0x8000) {
                   rgb6.rgbBlue = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);  sp6 >>= 5;
                   rgb6.rgbGreen = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);  sp6 >>= 5;
                   rgb6.rgbRed = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);
                 } else {
                   if(sp4 & 0x4000) rgb6 = Yarn->Choice[c6>>11].Color[(c6>>8)&7][(c6>>3)&0x1F]->GetColor((c6&7)>>1)->RGB;
                   else rgb6 = Yarn->Choice[c6>>11].Color[(c6>>8)&7][(c6>>3)&0x1F]->GetColor(-((c6&7)>>1))->RGB;
                 }
               } else { rgb6 = bgColor;}
            }
              TempRGB.rgbRed = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbRed
                            + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbRed
                            +(int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb3.rgbRed
                            +(ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb4.rgbRed
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb5.rgbRed
                            +(ratiox*(lx+1) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb6.rgbRed
                            )/(ratiox*ratioy);

              TempRGB.rgbGreen = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbGreen
                            + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbGreen
                            +(int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb3.rgbGreen
                            +(ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb4.rgbGreen
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb5.rgbGreen
                            +(ratiox*(lx+1) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb6.rgbGreen
                            )/(ratiox*ratioy);

              TempRGB.rgbBlue = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbBlue
                            + (ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbBlue
                            +(int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb3.rgbBlue
                            +(ratiox*(lx+1) - (int(ratiox*lx)+1)) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb4.rgbBlue
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb5.rgbBlue
                            +(ratiox*(lx+1) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb6.rgbBlue
                            )/(ratiox*ratioy);

         } else {
            sp1 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+sumy));
            sp2 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+sumy));
            if((ratiox*(lx+1) - int(ratiox*(lx+1))) < 0.0001) sp3 = sp2;
            else sp3 = *(bmTemp->pointer(int(ratiox*(lx+1))+sumx, int(ratioy*ly)+sumy));

            sp4 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*ly)+1+sumy));
            sp5 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*ly)+1+sumy));
            if((ratiox*(lx+1) - int(ratiox*(lx+1))) < 0.0001 || int(ratiox*(lx+1)) == int(ratiox*lx+1)) sp6 = sp5;
            else sp6 = *(bmTemp->pointer(int(ratiox*(lx+1))+sumx, int(ratioy*ly)+1+sumy));

            if( (ratioy*(ly+1) - int(ratioy*(ly+1))) < 0.0001 || int(ratioy*(ly+1)) == int(ratioy*ly+1)){
               sp7 = sp4;
               sp8 = sp5;
               sp9 = sp6;
            } else {
               sp7 = *(bmTemp->pointer(int(ratiox*lx)+sumx, int(ratioy*(ly+1))+sumy));
               sp8 = *(bmTemp->pointer(int(ratiox*lx)+1+sumx, int(ratioy*(ly+1))+sumy));
               if ((ratiox*(lx+1) - int(ratiox*(lx+1))) < 0.0001 || int(ratiox*(lx+1)) == int(ratiox*lx+1)) sp9 = sp8;
               else sp9 = *(bmTemp->pointer(int(ratiox*(lx+1))+sumx, int(ratioy*(ly+1))+sumy));
            }
            c1 = sp1 & 0x3FFF; c2 = sp2 & 0x3FFF; c3 = sp3 & 0x3FFF; c4 = sp4 & 0x3FFF; c5 = sp5 & 0x3FFF;
            c6 = sp6 & 0x3FFF; c7 = sp7 & 0x3FFF; c8 = sp8 & 0x3FFF; c9 = sp9 & 0x3FFF;
           ////////////////////////////////////////////////////////////////////////////////////////////////////  qe test
           if(int(ratiox*(lx+1))+sumx >= bmTemp->size.x || int(ratioy*(ly+1))+sumy >= bmTemp->size.y) {ShowMessage("Oops!"); goto fail;}
          //    if((c1&7)<1 || (c1&7)>7) ShowMessage("1");
          //    if((c2&7)<1 || (c2&7)>7) ShowMessage("2");
          //    if((c3&7)<1 || (c3&7)>7) ShowMessage("3");
          //    if((c4&7)<1 || (c4&7)>7) ShowMessage("4");
          //    if((c5&7)<1 || (c5&7)>7) ShowMessage("5");
          //    if((c6&7)<1 || (c6&7)>7) ShowMessage("6");
          //    if((c7&7)<1 || (c7&7)>7) ShowMessage("7");
          //    if((c8&7)<1 || (c8&7)>7) ShowMessage("8");
          //   if((c9&7)<1 || (c9&7)>7) ShowMessage("9");
//   ////  ///////////////////////////////////////////////////////////////////////////////////////////////
            if ((ratiox*lx - int(ratiox*lx)) > 0.001) {
               rgb1 = rgb3;
               rgb4 = rgb6;
               rgb7 = rgb9;
            } else {
               if (sp1) {
                 if (sp1 & 0x8000) {    //ĵ 
                   rgb1.rgbBlue = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbGreen = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                   rgb1.rgbRed = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);
                 } else {
                   if(sp1 & 0x4000) rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor((c1&7)>>1)->RGB;
                   else rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor(-((c1&7)>>1))->RGB;
                 }
               } else { rgb1 = bgColor;}
               if (sp4) {
                 if (sp4 & 0x8000) {
                   rgb4.rgbBlue = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                   rgb4.rgbGreen = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);  sp4 >>= 5;
                   rgb4.rgbRed = ((sp4 & 0x1F) << 3) | ((sp4 & 0x1F) >> 2);
                 } else {
                   if(sp4 & 0x4000) rgb4 = Yarn->Choice[c4>>11].Color[(c4>>8)&7][(c4>>3)&0x1F]->GetColor((c4&7)>>1)->RGB;
                   else rgb4 = Yarn->Choice[c4>>11].Color[(c4>>8)&7][(c4>>3)&0x1F]->GetColor(-((c4&7)>>1))->RGB;
                 }
               } else { rgb4 = bgColor;}
               if (sp7 == sp4) rgb7 = rgb4;
               else {
                  if (sp7) {
                    if (sp7 & 0x8000) {
                      rgb7.rgbBlue = ((sp7 & 0x1F) << 3) | ((sp7 & 0x1F) >> 2);  sp7 >>= 5;
                      rgb7.rgbGreen = ((sp7 & 0x1F) << 3) | ((sp7 & 0x1F) >> 2);  sp7 >>= 5;
                      rgb7.rgbRed = ((sp7 & 0x1F) << 3) | ((sp7 & 0x1F) >> 2);
                    } else {
                      if(sp7 & 0x4000) rgb7 = Yarn->Choice[c6>>11].Color[(c7>>8)&7][(c7>>3)&0x1F]->GetColor((c7&7)>>1)->RGB;
                      else rgb7 = Yarn->Choice[c7>>11].Color[(c7>>8)&7][(c7>>3)&0x1F]->GetColor(-((c7&7)>>1))->RGB;
                    }
                  } else { rgb7 = bgColor;}
               }
            }

            if (sp2) {
              if (sp2 & 0x8000) {
                rgb2.rgbBlue = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbGreen = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                rgb2.rgbRed = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);
              } else {
                if(sp2 & 0x4000) rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor((c2&7)>>1)->RGB;
                else rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor(-((c2&7)>>1))->RGB;
              }
            } else { rgb2 = bgColor;}
            if (sp5) {
              if (sp5 & 0x8000) {
                rgb5.rgbBlue = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);  sp5 >>= 5;
                rgb5.rgbGreen = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);  sp5 >>= 5;
                rgb5.rgbRed = ((sp5 & 0x1F) << 3) | ((sp5 & 0x1F) >> 2);
              } else {
                if(sp5 & 0x4000) rgb5 = Yarn->Choice[c5>>11].Color[(c5>>8)&7][(c5>>3)&0x1F]->GetColor((c5&7)>>1)->RGB;
                else rgb5 = Yarn->Choice[c5>>11].Color[(c5>>8)&7][(c5>>3)&0x1F]->GetColor(-((c5&7)>>1))->RGB;
              }
            } else { rgb5 = bgColor;}
            if (sp8 == sp5) rgb8 = rgb5;
            else {
               if(sp8){
                 if (sp8 & 0x8000) {
                   rgb8.rgbBlue = ((sp8 & 0x1F) << 3) | ((sp8 & 0x1F) >> 2);  sp8 >>= 5;
                   rgb8.rgbGreen = ((sp8 & 0x1F) << 3) | ((sp8 & 0x1F) >> 2);  sp8 >>= 5;
                   rgb8.rgbRed = ((sp8 & 0x1F) << 3) | ((sp8 & 0x1F) >> 2);
                 } else {
                   if(sp8 & 0x4000) rgb8 = Yarn->Choice[c8>>11].Color[(c8>>8)&7][(c8>>3)&0x1F]->GetColor((c8&7)>>1)->RGB;
                   else rgb8 = Yarn->Choice[c8>>11].Color[(c8>>8)&7][(c8>>3)&0x1F]->GetColor(-((c8&7)>>1))->RGB;
                 }
               } else { rgb8 = bgColor;}
            }
            if (sp3 == sp2 && sp6 == sp5 && sp9 == sp8){
               rgb3 = rgb2;
               rgb6 = rgb5;
               rgb9 = rgb8;
            } else {
               if (sp3) {
                 if (sp3 & 0x8000) {
                   rgb3.rgbBlue = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbGreen = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                   rgb3.rgbRed = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);
                 } else {
                   if(sp3 & 0x4000) rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor((c3&7)>>1)->RGB;
                   else rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor(-((c3&7)>>1))->RGB;
                 }
               } else { rgb3 = bgColor;}
               if (sp6) {
                 if (sp6 & 0x8000) {
                   rgb6.rgbBlue = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);  sp6 >>= 5;
                   rgb6.rgbGreen = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);  sp6 >>= 5;
                   rgb6.rgbRed = ((sp6 & 0x1F) << 3) | ((sp6 & 0x1F) >> 2);
                 } else {
                   if(sp6 & 0x4000) rgb6 = Yarn->Choice[c6>>11].Color[(c6>>8)&7][(c6>>3)&0x1F]->GetColor((c6&7)>>1)->RGB;
                   else rgb6 = Yarn->Choice[c6>>11].Color[(c6>>8)&7][(c6>>3)&0x1F]->GetColor(-((c6&7)>>1))->RGB;
                 }
               } else { rgb6 = bgColor;}
               if (sp9 == sp6) rgb9 = rgb6;
               else {
                  if (sp9) {
                    if (sp9 & 0x8000) {
                      rgb9.rgbBlue = ((sp9 & 0x1F) << 3) | ((sp9 & 0x1F) >> 2);  sp9 >>= 5;
                      rgb9.rgbGreen = ((sp9 & 0x1F) << 3) | ((sp9 & 0x1F) >> 2);  sp9 >>= 5;
                      rgb9.rgbRed = ((sp9 & 0x1F) << 3) | ((sp9 & 0x1F) >> 2);
                    } else {
                      if(sp9 & 0x4000) rgb9 = Yarn->Choice[c9>>11].Color[(c9>>8)&7][(c9>>3)&0x1F]->GetColor((c9&7)>>1)->RGB;
                      else rgb9 = Yarn->Choice[c9>>11].Color[(c9>>8)&7][(c9>>3)&0x1F]->GetColor(-((c9&7)>>1))->RGB;
                    }
                  } else { rgb9 = bgColor;}
               }
            }

              TempRGB.rgbRed = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbRed
                            + (int(ratiox*(lx+1)) - (int(ratiox*lx)+1))* (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbRed
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*ly)+1 - ratioy*ly) * rgb3.rgbRed
                            +(int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb4.rgbRed
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb5.rgbRed
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb6.rgbRed
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb7.rgbRed
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb8.rgbRed
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb9.rgbRed
                            )/(ratiox*ratioy);

              TempRGB.rgbGreen = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbGreen
                            + (int(ratiox*(lx+1)) - (int(ratiox*lx)+1))* (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbGreen
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*ly)+1 - ratioy*ly) * rgb3.rgbGreen
                            +(int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb4.rgbGreen
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb5.rgbGreen
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb6.rgbGreen
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb7.rgbGreen
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb8.rgbGreen
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb9.rgbGreen
                            )/(ratiox*ratioy);

              TempRGB.rgbBlue = ((int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*ly)+1 - ratioy*ly) * rgb1.rgbBlue
                            + (int(ratiox*(lx+1)) - (int(ratiox*lx)+1))* (int(ratioy*ly)+1 - ratioy*ly) * rgb2.rgbBlue
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*ly)+1 - ratioy*ly) * rgb3.rgbBlue
                            +(int(ratiox*lx)+1 - ratiox*lx) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb4.rgbBlue
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb5.rgbBlue
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (int(ratioy*(ly+1)) - (int(ratioy*ly)+1)) * rgb6.rgbBlue
                            +(int(ratiox*lx)+1 - ratiox*lx) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb7.rgbBlue
                            +(int(ratiox*(lx+1)) - (int(ratiox*lx)+1)) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb8.rgbBlue
                            + (ratiox*(lx+1) - int(ratiox*(lx+1))) * (ratioy*(ly+1) - int(ratioy*(ly+1))) *rgb9.rgbBlue
                            )/(ratiox*ratioy);
         }
         *dp = RGBToColor15(TempRGB);
       }
     	TempBitmap->PutScanLine(TempBitmap->Height-1-y);
	   }
  }
  TempBitmap->StopScanLine();    */


  return;
fail:
 	TempBitmap->StopScanLine();
  EXCEPTION_MESSAGE_OK(EC_MEMORY_LACK);
}
//----------------------------------------------------------------------------
void __fastcall TPlan::MakeYarnBar(int i, int n, TWeaveData &wd, TTexpiaBitmap *DstBitmap,
                               TPMemoryArea<WORD> *bmSrc, RGBQUAD bgColor, bool bWarpBack)
{
   int x, y, index, k;
   WORD *dp, sp1, sp2, sp3, c1, c2, c3, *tp, *sp, c;
   RGBQUAD rgb1, rgb2, rgb3, TempRGB;
   int cnt = GetCount(i);
   double dd1, dd2, dd3, ratio;
   int sumSrc = 0, sumDst = 0;
   for(k=0; k<n; k++){
     sumSrc += Length[i][k%cnt];
     sumDst += ExactLength[i][k%cnt];
   }
   if(DstBitmap->StartScanLine() == false) goto fail;
   if (!WeaveCondition.ColorCorrection) {
      ratio = (double)Length[i][n%cnt]/ExactLength[i][n%cnt];
      if(i == WARP) {
         if (WeaveCondition.WovenEffect==WESolid) {
            for(y = 0; y < DstBitmap->Height; y++){
               dp = (WORD *)DstBitmap->GetScanLine(y) + sumDst;
               for(x = 0; x < ExactLength[WARP][n%cnt]; x++, dp++){
                  sp1 = *bmSrc->pointer(sumSrc + int(ratio*x+0.0001), y);
                  sp2 = *bmSrc->pointer(sumSrc + int(ratio*x+0.0001)+1, y);
                  if((ratio*(x+1) - int(ratio*(x+1)+0.0001)) < 0.0001) sp3 = sp2;
                  else sp3 = *bmSrc->pointer(sumSrc + int(ratio*(x+1)+0.0001), y);
                  c1 = sp1 & 0x3FFF; c2 = sp2 & 0x3FFF; c3 = sp3 & 0x3FFF;
                  if ((ratio*x - int(ratio*x+0.0001)) > 0.001) {
                     rgb1 = rgb3;
                  } else {
                     if (sp1) {
                        if (sp1 & 0x8000) {    //ĵ 
                           rgb1.rgbBlue = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                           rgb1.rgbGreen = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                           rgb1.rgbRed = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);
                        } else {
                              rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor(0)->RGB;
                        }
                     } else { rgb1 = bgColor;}
                  }
                  if (sp2) {
                     if (sp2 & 0x8000) {
                        rgb2.rgbBlue = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                        rgb2.rgbGreen = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                        rgb2.rgbRed = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);
                     } else {
                        rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor(0)->RGB;
                     }
                  } else { rgb2 = bgColor;}
                  if (sp3 == sp2) {
                     rgb3 = rgb2;
                  } else {
                     if (sp3) {
                        if (sp3 & 0x8000) {
                           rgb3.rgbBlue = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                           rgb3.rgbGreen = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                           rgb3.rgbRed = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);
                        } else {
                           rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor(0)->RGB;
                        }
                     } else { rgb3 = bgColor;}
                  }
                  dd1 = int(ratio*x+0.0001)+1 - ratio*x;
                  dd2 = int(ratio*(x+1)+0.0001) - int(ratio*x+0.0001) -1;
                  dd3 = ratio*(x+1) - int(ratio*(x+1)+0.0001);
                  TempRGB.rgbRed = (dd1*rgb1.rgbRed + dd2*rgb2.rgbRed + dd3*rgb3.rgbRed)/ratio;
                  TempRGB.rgbGreen = (dd1*rgb1.rgbGreen + dd2*rgb2.rgbGreen +dd3*rgb3.rgbGreen)/ratio;
                  TempRGB.rgbBlue = (dd1*rgb1.rgbBlue + dd2*rgb2.rgbBlue + dd3*rgb3.rgbBlue)/ratio;
next1:
                  *dp = RGBToColor15(TempRGB);
               }
               DstBitmap->PutScanLine(y);
            }
         } else {
            for(y = 0; y < DstBitmap->Height; y++){
               dp = (WORD *)DstBitmap->GetScanLine(y) + sumDst;
               for(x = 0; x < ExactLength[WARP][n%cnt]; x++, dp++){
                  sp1 = *bmSrc->pointer(sumSrc + int(ratio*x+0.0001), y);
                  sp2 = *bmSrc->pointer(sumSrc + int(ratio*x+0.0001)+1, y);
                  if((ratio*(x+1) - int(ratio*(x+1)+0.0001)) < 0.0001) sp3 = sp2;
                  else sp3 = *bmSrc->pointer(sumSrc + int(ratio*(x+1)+0.0001), y);
                  c1 = sp1 & 0x3FFF; c2 = sp2 & 0x3FFF; c3 = sp3 & 0x3FFF;
                  if ((ratio*x - int(ratio*x+0.0001)) > 0.001) {
                     rgb1 = rgb3;
                  } else {
                     if (sp1) {
                        if (sp1 & 0x8000) {    //ĵ 
                           rgb1.rgbBlue = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                           rgb1.rgbGreen = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                           rgb1.rgbRed = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);
                        } else {
                           if((c1&7)<1 || (c1&7)>7) ShowMessage("1");  //qe test
                           rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor((c1&7)-4)->RGB;
                        }
                     } else { rgb1 = bgColor;}
                  }
                  if (sp2) {
                     if (sp2 & 0x8000) {
                        rgb2.rgbBlue = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                        rgb2.rgbGreen = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                        rgb2.rgbRed = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);
                     } else {
                        if((c2&7)<1 || (c2&7)>7) ShowMessage("2");
                        rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor((c2&7)-4)->RGB;
                     }
                  } else { rgb2 = bgColor;}
                  if (sp3 == sp2) {
                     rgb3 = rgb2;
                  } else {
                     if (sp3) {
                        if (sp3 & 0x8000) {
                           rgb3.rgbBlue = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                           rgb3.rgbGreen = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                           rgb3.rgbRed = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);
                        } else {
                           if((c3&7)<1 || (c3&7)>7) ShowMessage("3");
                           rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor((c3&7)-4)->RGB;
                        }
                     } else { rgb3 = bgColor;}
                  }
                  dd1 = int(ratio*x+0.0001)+1 - ratio*x;
                  dd2 = int(ratio*(x+1)+0.0001) - int(ratio*x+0.0001) -1;
                  dd3 = ratio*(x+1) - int(ratio*(x+1)+0.0001);
                  TempRGB.rgbRed = (dd1*rgb1.rgbRed + dd2*rgb2.rgbRed + dd3*rgb3.rgbRed)/ratio;
                  TempRGB.rgbGreen = (dd1*rgb1.rgbGreen + dd2*rgb2.rgbGreen +dd3*rgb3.rgbGreen)/ratio;
                  TempRGB.rgbBlue = (dd1*rgb1.rgbBlue + dd2*rgb2.rgbBlue + dd3*rgb3.rgbBlue)/ratio;
                  *dp = RGBToColor15(TempRGB);
               }
               DstBitmap->PutScanLine(y);
            }
         }
      } else {
         if (WeaveCondition.WovenEffect==WESolid) {
            for(y = 0; y < ExactLength[WEFT][n%cnt]; y++){
               dp = (WORD *)DstBitmap->GetScanLine(DstBitmap->Height - sumDst - y -1);
               for(x = 0; x < DstBitmap->Width; x++, dp++){
                  sp1 = *bmSrc->pointer(x, sumSrc + int(ratio*y));
                  sp2 = *bmSrc->pointer(x, sumSrc + int(ratio*y)+1);
                  if((ratio*(y+1) - int(ratio*(y+1))) < 0.001) sp3 = sp2;
                  else sp3 = *bmSrc->pointer(x, sumSrc + int(ratio*(y+1)));
                  c1 = sp1 & 0x3FFF; c2 = sp2 & 0x3FFF; c3 = sp3 & 0x3FFF;
                  if (sp1) {
                     if (sp1 & 0x8000) {    //ĵ 
                        rgb1.rgbBlue = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                        rgb1.rgbGreen = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                        rgb1.rgbRed = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);
                     } else {
                        rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor(0)->RGB;
                     }
                  } else { rgb1 = bgColor;}
                  if (sp2) {
                     if (sp2 & 0x8000) {
                        rgb2.rgbBlue = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                        rgb2.rgbGreen = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                        rgb2.rgbRed = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);
                     } else {
                        rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor(0)->RGB;
                     }
                  } else { rgb2 = bgColor;}
                  if (sp3 == sp2) {
                     rgb3 = rgb2;
                  } else {
                     if (sp3) {
                        if (sp3 & 0x8000) {
                           rgb3.rgbBlue = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                           rgb3.rgbGreen = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                           rgb3.rgbRed = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);
                        } else {
                           rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor(0)->RGB;
                        }
                     } else { rgb3 = bgColor;}
                  }
                  dd1 = int(ratio*y+0.0001)+1 - ratio*y;
                  dd2 = int(ratio*(y+1)+0.0001) - int(ratio*y+0.0001)-1;
                  dd3 = ratio*(y+1) - int(ratio*(y+1)+0.0001);
                  TempRGB.rgbRed = (dd1*rgb1.rgbRed + dd2*rgb2.rgbRed + dd3*rgb3.rgbRed)/ratio;
                  TempRGB.rgbGreen = (dd1*rgb1.rgbGreen + dd2*rgb2.rgbGreen + dd3*rgb3.rgbGreen)/ratio;
                  TempRGB.rgbBlue = (dd1*rgb1.rgbBlue + dd2*rgb2.rgbBlue + dd3*rgb3.rgbBlue)/ratio;
                  *dp = RGBToColor15(TempRGB);
               }
               DstBitmap->PutScanLine(DstBitmap->Height - y - sumDst -1);
            }
         } else {
             for(y = 0; y < ExactLength[WEFT][n%cnt]; y++){
               dp = (WORD *)DstBitmap->GetScanLine(DstBitmap->Height - sumDst - y -1);
               for(x = 0; x < DstBitmap->Width; x++, dp++){
                  sp1 = *bmSrc->pointer(x, sumSrc + int(ratio*y));
                  sp2 = *bmSrc->pointer(x, sumSrc + int(ratio*y)+1);
                  if((ratio*(y+1) - int(ratio*(y+1))) < 0.001) sp3 = sp2;
                  else sp3 = *bmSrc->pointer(x, sumSrc + int(ratio*(y+1)));
                  c1 = sp1 & 0x3FFF; c2 = sp2 & 0x3FFF; c3 = sp3 & 0x3FFF;
                  if (sp1) {
                     if (sp1 & 0x8000) {    //ĵ 
                        rgb1.rgbBlue = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                        rgb1.rgbGreen = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);  sp1 >>= 5;
                        rgb1.rgbRed = ((sp1 & 0x1F) << 3) | ((sp1 & 0x1F) >> 2);
                     } else {
                        rgb1 = Yarn->Choice[c1>>11].Color[(c1>>8)&7][(c1>>3)&0x1F]->GetColor((c1&7)-4)->RGB;
                     }
                  } else { rgb1 = bgColor;}
                  if (sp2) {
                     if (sp2 & 0x8000) {
                        rgb2.rgbBlue = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                        rgb2.rgbGreen = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);  sp2 >>= 5;
                        rgb2.rgbRed = ((sp2 & 0x1F) << 3) | ((sp2 & 0x1F) >> 2);
                     } else {
                        rgb2 = Yarn->Choice[c2>>11].Color[(c2>>8)&7][(c2>>3)&0x1F]->GetColor((c2&7)-4)->RGB;
                     }
                  } else { rgb2 = bgColor;}
                  if (sp3 == sp2) {
                     rgb3 = rgb2;
                  } else {
                     if (sp3) {
                        if (sp3 & 0x8000) {
                           rgb3.rgbBlue = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                           rgb3.rgbGreen = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);  sp3 >>= 5;
                           rgb3.rgbRed = ((sp3 & 0x1F) << 3) | ((sp3 & 0x1F) >> 2);
                        } else {
                           rgb3 = Yarn->Choice[c3>>11].Color[(c3>>8)&7][(c3>>3)&0x1F]->GetColor((c3&7)-4)->RGB;
                        }
                     } else { rgb3 = bgColor;}
                  }
                  dd1 = int(ratio*y+0.0001)+1 - ratio*y;
                  dd2 = int(ratio*(y+1)+0.0001) - int(ratio*y+0.0001)-1;
                  dd3 = ratio*(y+1) - int(ratio*(y+1)+0.0001);
                  TempRGB.rgbRed = (dd1*rgb1.rgbRed + dd2*rgb2.rgbRed + dd3*rgb3.rgbRed)/ratio;
                  TempRGB.rgbGreen = (dd1*rgb1.rgbGreen + dd2*rgb2.rgbGreen + dd3*rgb3.rgbGreen)/ratio;
                  TempRGB.rgbBlue = (dd1*rgb1.rgbBlue + dd2*rgb2.rgbBlue + dd3*rgb3.rgbBlue)/ratio;
                  *dp = RGBToColor15(TempRGB);
               }
               DstBitmap->PutScanLine(DstBitmap->Height - y - sumDst -1);
            }
         }
      }
   } else {
      if(i == WARP) {
         if (WeaveCondition.WovenEffect==WESolid) {
            for (y = 0; y < DstBitmap->Height; y++){
               dp = (WORD *)DstBitmap->GetScanLine(y) + sumSrc;
               sp = bmSrc->pointer(sumSrc, y);
               for(x = 0; x < Length[WARP][n%cnt]; x++, dp++, sp++){
                  if (*sp) {
                     if (*sp & 0x8000) {
   	  			            *dp = *sp & 0x7FFF;
                     } else {
            	          c = *sp & 0x3FFF;
                        *dp = RGBToColor15(Yarn->Choice[c>>11].Color[(c>>8)&7][(c>>3)&0x1F]->GetColor(0)->RGB);
                     }
                  } else {
			 	  	         *dp = RGBToColor15(bgColor);
                  }
               }
               DstBitmap->PutScanLine(y);
            }
         } else {
            for (y = 0; y < DstBitmap->Height; y++) {
               dp = (WORD *)DstBitmap->GetScanLine(y) + sumSrc;
               sp = bmSrc->pointer(sumSrc, y);
               for (int x=0; x < Length[WARP][n%cnt]; x++, sp++, dp++) {
    			        if (*sp) {
                     if (*sp & 0x8000) {
   	  			            *dp = *sp & 0x7FFF;
                     } else {
            	          c = *sp & 0x3FFF;
                        *dp = RGBToColor15(Yarn->Choice[c>>11].Color[(c>>8)&7][(c>>3)&0x1F]->GetColor((c&7)-4)->RGB);
                     }
		  		        } else {
			 	  	         *dp = RGBToColor15(bgColor);
                  }
               }
               DstBitmap->PutScanLine(y);
            }
         }
      } else {
         if (WeaveCondition.WovenEffect==WESolid) {
            for (y = 0; y < Length[WEFT][n%cnt]; y++){
               dp = (WORD *)DstBitmap->GetScanLine(DstBitmap->Height - sumSrc - y -1);
               sp = bmSrc->pointer(0, sumSrc+y);
               for(x = 0; x < DstBitmap->Width; x++, dp++, sp++){
                  if (*sp) {
                     if (*sp & 0x8000) {
   	  			            *dp = *sp & 0x7FFF;
                     } else {
            	          c = *sp & 0x3FFF;
   	  			            *dp = RGBToColor15(Yarn->Choice[c>>11].Color[(c>>8)&7][(c>>3)&0x1F]->GetColor(0)->RGB);
                     }
                  } else {
			 	  	         *dp = RGBToColor15(bgColor);
                  }
               }
               DstBitmap->PutScanLine(DstBitmap->Height - sumSrc - y -1);
            }
         } else {
            for (y = 0; y < Length[WEFT][n%cnt]; y++) {
               dp = (WORD *)DstBitmap->GetScanLine(DstBitmap->Height - sumSrc - y -1);
               sp = bmSrc->pointer(0, sumSrc+y);
               for (int x=0; x<DstBitmap->Width; x++, sp++, dp++) {
    			        if (*sp) {
                     if (*sp & 0x8000) {
   	  			            *dp = *sp & 0x7FFF;
                     } else {
            	          c = *sp & 0x3FFF;
                        *dp = RGBToColor15(Yarn->Choice[c>>11].Color[(c>>8)&7][(c>>3)&0x1F]->GetColor((c&7)-4)->RGB);
                     }
		  		        } else {
			 	  	         *dp = RGBToColor15(bgColor);
                  }
               }
               DstBitmap->PutScanLine(DstBitmap->Height - sumSrc - y -1);
            }
         }
      }
   }
   DstBitmap->StopScanLine();
   return;
fail:
  DstBitmap->StopScanLine();
}
//----------------------------------------------------------------------------
void __fastcall TPlan::RepeatBitmap(int i, TTexpiaBitmap *Bitmap, TTexpiaBitmap *TempBitmap, bool bWarpBack)
{
   int x, y, index;
   WORD *dp, *tp;
   if(Bitmap->StartScanLine() == false) goto fail;
   if(TempBitmap->StartScanLine() == false) goto fail;
   if(i == WARP){
      if(Yarn->bFinish[i]){
         for(y = 0; y < Bitmap->Height; y++){
            dp = (WORD *)Bitmap->GetScanLine(y);
            tp = (WORD *)TempBitmap->GetScanLine(y);
            for(x = 0, index = 0; x < Bitmap->Width; x++, index++){
               if(index == TempBitmap->Width) index = 0;
               if(bWarpBack) *(dp + Bitmap->Width - x -1) = *(tp + index);
               else *(dp+x) = *(tp + index);
            }
            Bitmap->PutScanLine(y);
         }

      } else {
         for(y = 0; y < TempBitmap->Height; y++){
            dp = (WORD *)Bitmap->GetScanLine(y);
            tp = (WORD *)TempBitmap->GetScanLine(y);
            for(x = 0; x < TempBitmap->Width; x++){
               if(bWarpBack) *(dp + Bitmap->Width - x -1) = *(tp+x);
               else *(dp+x) = *(tp+x);
            }
            Bitmap->PutScanLine(y);
         }
      }
   }else {
      if(Yarn->bFinish[i]){
         for(y = 0, index = 0; y < Bitmap->Height; y++, index++){
           if(index == TempBitmap->Height) index = 0;
           dp = (WORD *)Bitmap->GetScanLine(Bitmap->Height - y -1);
           tp = (WORD *)TempBitmap->GetScanLine(TempBitmap->Height - index -1);
           memcpy(dp, tp, sizeof(WORD) * Bitmap->Width);
           Bitmap->PutScanLine(Bitmap->Height - y -1);
         }
      }else {
         for(y = 0; y < TempBitmap->Height; y++){
           dp = (WORD *)Bitmap->GetScanLine(Bitmap->Height - y -1);
           tp = (WORD *)TempBitmap->GetScanLine(TempBitmap->Height - y -1);
           memcpy(dp, tp, sizeof(WORD) * TempBitmap->Width);
           Bitmap->PutScanLine(Bitmap->Height - y -1);
         }
      }
   }
   Bitmap->StopScanLine();
   TempBitmap->StopScanLine();
   return;
fail:
}
//---------------------------------------------------------------------------
void __fastcall TPlan::InitLengthInfo(int i)
{
  int Count, sCount, k;
  Count = GetCount(i);
  Length[i] = new int[Count];
  ExactLength[i] = new int[Count];
  sCount = GetSCount(i);
  sLength[i] = new int[sCount];
  if (i == WARP) bSucker = new bool[sCount];
}
//-----------------------------------------------------------------------------
void __fastcall TPlan::ExitLengthInfo(int i)
{
  if (Length[i])      {delete[] Length[i];   Length[i] = NULL;}
  if (ExactLength[i]) {delete[] ExactLength[i]; ExactLength[i] = NULL;}
  if (sLength[i])     {delete[] sLength[i];   sLength[i] = NULL;}
  if(i == WARP && bSucker) {delete[] bSucker;   bSucker = NULL;}
}
//---------------------------------------------------------------------------
//7.3   ε ʿ ڵ...
void __fastcall TPlan::calc_weave(TTexpiaBitmap *Bitmap)
{
  char *tp;
  WORD *bf = NULL, *bb = NULL;
  int x, y, lx, ly, code, ti, i, j;
  int n[2], o[2], r[2], ic[2], tc[2], repeat[2], tl[2], yarns[2], Crepeat[2], rs[2], rn[2];
  double al[2];
  WORD *pFront = NULL, *pWeft = NULL;
	TList *ArrayWarp = Yarn->Array[WARP];
	TList *ArrayWeft = Yarn->Array[WEFT];

  StatusProgress->Maximum = 100;

  TCursor OldCursor = Screen->Cursor;
  Screen->Cursor = crHourGlass;

  //  bitmap  - 縦 ġ bitmap
  bmWarp = new TPMemoryArea<WORD>(Bitmap->Width, Bitmap->Height);
  if (bmWarp == NULL) goto fail;
  if (bmWarp->lock() == NULL) goto fail;

  //  bitmap  - 縦 ġ bitmap
  bmWeft = new TPMemoryArea<WORD>(Bitmap->Width, Bitmap->Height);
  if (bmWeft == NULL) goto fail;
  if (bmWeft->lock() == NULL) goto fail;

  // Hair effect bitmap 
  bmHair = new TPMemoryArea<WORD>(Bitmap->Width, Bitmap->Height);
  if (bmHair == NULL) goto fail;
  if (bmHair->lock() == NULL) goto fail;

  StatusProgress->Position = 5;

  // 縦 ġϱ   .
  InitYarnDot(WARP);

  StatusProgress->Position = 15;

  // 縦 ġϱ   .
  InitYarnDot(WEFT);

  StatusProgress->Position = 25;

  // 縦 ġѴ.
  calc_warp();

  StatusProgress->Position = 45;

  // 縦 ġѴ.
  calc_weft();

  StatusProgress->Position = 65;

  // (ո) bitmap 
  if (bmFront==NULL) {
	  bmFront = new TPMemoryArea<WORD>(Bitmap->Width, Bitmap->Height);
    if (bmFront == NULL) goto fail;
  }
  bf = bmFront->lock();
  if (bf == NULL) goto fail;

  // (ո) bitmap  bitmap 
  *bmFront = *bmWarp;

  // (ո) bitmap   ʴ   bitmap о 
  pFront = bmFront->pointer();
  pWeft = bmWeft->pointer();
  for (i=0; i<bmFront->size.y; i++) {
    for (j=0; j<bmFront->size.x; j++, pFront++, pWeft++) {
      if (*pWeft!=0 && *pFront==0) *pFront = *pWeft;
    }
  }
  if (bmBack==NULL) {
	  bmBack = new TPMemoryArea<WORD>(Bitmap->Width, Bitmap->Height);
    if (bmBack == NULL) goto fail;
	}
  bb = bmBack->lock();
  if (bb == NULL) goto fail;
  *bmBack = *bmFront;


  tl[WEFT] = tl[WARP] = 0;
  al[WEFT] = al[WARP] = 0.0;
  ic[WEFT] = ic[WARP] = 0;
  n[WEFT] = n[WARP] = 0;
  o[WEFT] = o[WARP] = 0;
  r[WEFT] = r[WARP] = 0;
  Crepeat[WEFT] = Crepeat[WARP] = 0;
  rs[WEFT] = rs[WARP] = NULL;
  rn[WEFT] = rn[WARP] = NULL;
  repeat[WARP] = ((TYarnArray *)ArrayWarp->Items[n[WARP]])->repeat;
  repeat[WEFT] = ((TYarnArray *)ArrayWeft->Items[n[WEFT]])->repeat;
  if (bTextureCorrection) {
    dpy[WARP] = data[WARP][data[WARP][o[WARP]].num].dpy;
    dpy[WEFT] = data[WEFT][data[WEFT][o[WEFT]].num].dpy;
    yarns[WARP] = 160.0 * ((TYarnArray *)ArrayWarp->Items[o[WARP]])->length / dpy[WARP] + 0.5;
    yarns[WEFT] = 160.0 * ((TYarnArray *)ArrayWeft->Items[o[WEFT]])->length / dpy[WEFT] + 0.5;
  } else {
    dpy[WARP] = (double)data[WARP][data[WARP][o[WARP]].num].dot/
      ((TYarnArray *)ArrayWarp->Items[o[WARP]])->yarns;
    dpy[WEFT] = (double)data[WEFT][data[WEFT][o[WEFT]].num].dot/
      ((TYarnArray *)ArrayWeft->Items[o[WEFT]])->yarns;
    yarns[WARP] = ((TYarnArray *)ArrayWarp->Items[o[WARP]])->yarns;
    yarns[WEFT] = ((TYarnArray *)ArrayWeft->Items[o[WEFT]])->yarns;
  }
  tc[WEFT] = tc[WARP] = 0;
  ti = 0;
  code = ((TTextureArray *)Texture->Array->Items[ti])->code-1;
  lx = Texture->Choice[code].width;
  ly = Texture->Choice[code].height;
  tp = Texture->Choice[code].data;
  while (1) {
    v[WARP] = al[WARP]; v[WEFT] = al[WEFT];
    if (*(tp+tc[WARP]%lx)) {
        texture_warp(bmFront);
        texture_weft(bmBack);
    } else {
        texture_weft(bmFront);
        texture_warp(bmBack);
    }

    tc[WARP]++;
    if (Texture->Array->Count>1) {
      if (tc[WARP]>=((TTextureArray *)Texture->Array->Items[ti])->size) {
        ti++; if (ti>=Texture->Array->Count) ti = 0;
        code = ((TTextureArray *)Texture->Array->Items[ti])->code-1;
        lx = Texture->Choice[code].width;
        ly = Texture->Choice[code].height;
        tp = Texture->Choice[code].data+(tc[WEFT]%ly)*lx;
        tc[WARP] = 0;
      }
    }
    ic[WARP]++;
    al[WARP] += dpy[WARP];
    if (al[WARP]<bmFront->size.x) {
      if (ic[WARP]>=yarns[WARP]) {
        ic[WARP] = 0;
        if (!bTextureCorrection) {
          tl[WARP] += data[WARP][data[WARP][o[WARP]].num].dot;
          al[WARP] = tl[WARP];
        }
        Change(WARP, n[WARP], o[WARP], r[WARP], repeat[WARP], Crepeat[WARP], rs[WARP], rn[WARP]);
        if (bTextureCorrection) {
          dpy[WARP] = data[WARP][data[WARP][o[WARP]].num].dpy;
          yarns[WARP] = 160.0 * ((TYarnArray *)ArrayWarp->Items[o[WARP]])->length / dpy[WARP] + 0.5;
        } else {
          dpy[WARP] = (double)data[WARP][data[WARP][o[WARP]].num].dot/
            ((TYarnArray *)ArrayWarp->Items[o[WARP]])->yarns;
          yarns[WARP] = ((TYarnArray *)ArrayWarp->Items[o[WARP]])->yarns;
        }
      }
    } else {
      tl[WARP] = 0; al[WARP] = 0.0;
      n[WARP] = o[WARP] = r[WARP] = 0;
      repeat[WARP] = ((TYarnArray *)ArrayWarp->Items[n[WARP]])->repeat;
      if (bTextureCorrection) {
        dpy[WARP] = data[WARP][data[WARP][o[WARP]].num].dpy;
        yarns[WARP] = 160.0 * ((TYarnArray *)ArrayWarp->Items[o[WARP]])->length / dpy[WARP] + 0.5;
      } else {
        dpy[WARP] = (double)data[WARP][data[WARP][o[WARP]].num].dot/
          ((TYarnArray *)ArrayWarp->Items[o[WARP]])->yarns;
        yarns[WARP] = ((TYarnArray *)ArrayWarp->Items[o[WARP]])->yarns;
      }
      ic[WARP] = 0;
      tc[WARP] = 0; tc[WEFT]++;
      if (Texture->Array->Count>1) {
        ti = 0;
        code = ((TTextureArray *)Texture->Array->Items[ti])->code-1;
        lx = Texture->Choice[code].width;
        ly = Texture->Choice[code].height;
      }
      tp = Texture->Choice[code].data+(tc[WEFT]%ly)*lx;
      ic[WEFT]++;
      al[WEFT] += dpy[WEFT];
      if (al[WEFT]<bmFront->size.y) {
        if (ic[WEFT]>=yarns[WEFT]) {
          ic[WEFT] = 0;
          if (!bTextureCorrection) {
            tl[WEFT] += data[WEFT][data[WEFT][o[WEFT]].num].dot;
            al[WEFT] = tl[WEFT];
          }
          Change(WEFT, n[WEFT], o[WEFT], r[WEFT], repeat[WEFT], Crepeat[WEFT], rs[WEFT], rn[WEFT]);
          if (bTextureCorrection) {
            dpy[WEFT] = data[WEFT][data[WEFT][o[WEFT]].num].dpy;
            yarns[WEFT] = 160.0 * ((TYarnArray *)ArrayWeft->Items[o[WEFT]])->length / dpy[WEFT] + 0.5;
          } else {
            dpy[WEFT] = (double)data[WEFT][data[WEFT][o[WEFT]].num].dot/
              ((TYarnArray *)ArrayWeft->Items[o[WEFT]])->yarns;
            yarns[WEFT] = ((TYarnArray *)ArrayWeft->Items[o[WEFT]])->yarns;
          }
        }
      } else break;
    }
  }
  ExitYarnDot(WARP);
  ExitYarnDot(WEFT);
  bmWarp->unlock();  delete bmWarp;  bmWarp = NULL;
  bmWeft->unlock();  delete bmWeft;  bmWeft = NULL;

  StatusProgress->Position = 85;

  // hair effect ش.
  calc_hair(bmFront, bmBack);

  bmHair->unlock();  delete bmHair;
  bmFront->unlock();
  bmBack->unlock();
  Screen->Cursor = OldCursor;
  StatusProgress->Position = 100;
  StatusProgress->End();
  return;
fail:
  ExitYarnDot(WARP);
  ExitYarnDot(WEFT);
  if (bmWarp) delete bmWarp;  bmWarp = NULL;
  if (bmWeft) delete bmWeft;  bmWeft = NULL;
  if (bmHair) delete bmHair;  bmHair = NULL;
  if (bf) bmFront->unlock();
  if (bb) bmBack->unlock();
  Screen->Cursor = OldCursor;
  StatusProgress->End();
  EXCEPTION_MESSAGE_OK(EC_MEMORY_LACK);
}
//---------------------------------------------------------------------------
void __fastcall TPlan::DrawFront(TTexpiaBitmap *Bitmap, RGBQUAD bgColor)
{
	WORD *sp, *dp, c;
  TGradeColor **ydc;
  WORD *bf = NULL;
	if (bmFront) {
    bf = bmFront->lock();
    if (bf == NULL) goto fail;
	  if (Bitmap->StartScanLine() == false) goto fail;
		if (WeaveCondition.WovenEffect==WESolid) {
	  	for (int y=0; y<Bitmap->Height; y++) {
		  	sp = bmFront->pointer(0, y);
			 	dp = (WORD *)Bitmap->GetScanLine(Bitmap->Height-1-y);
		  	for (int x=0; x<Bitmap->Width; x++, sp++, dp++) {
    			if (*sp) {
            if (*sp & 0x8000) {
   	  			  *dp = *sp & 0x7FFF;
            } else {
            	c = *sp & 0x1FFF;
					    ydc = Yarn->Choice[c>>11].Color[(c>>8)&7];
   	  			  *dp = RGBToColor15(ydc[(c>>3)&0x1F]->GetColor(0)->RGB);
            }
		  		} else {
			 	  	*dp = RGBToColor15(bgColor);
    		  }
		    }
  			Bitmap->PutScanLine(Bitmap->Height-1-y);
	  	}
    } else if (WeaveCondition.WovenEffect==WETypeA) {
	  	for (int y=0; y<Bitmap->Height; y++) {
		  	sp = bmFront->pointer(0, y);
			 	dp = (WORD *)Bitmap->GetScanLine(Bitmap->Height-1-y);
		  	for (int x=0; x<Bitmap->Width; x++, sp++, dp++) {
    			if (*sp) {
            if (*sp & 0x8000) {
   	  			  *dp = *sp & 0x7FFF;
            } else {
            	c = *sp & 0x1FFF;
  					  ydc = Yarn->Choice[c>>11].Color[(c>>8)&7];
 	  	  	  	*dp = RGBToColor15(ydc[(c>>3)&0x1F]->GetColor((c&7)-4)->RGB);
            }
		  		} else {
			 	  	*dp = RGBToColor15(bgColor);
    		  }
		    }
  			Bitmap->PutScanLine(Bitmap->Height-1-y);
	  	}
	  } else {
	  	for (int y=0; y<Bitmap->Height; y++) {
		  	sp = bmFront->pointer(0, y);
			 	dp = (WORD *)Bitmap->GetScanLine(Bitmap->Height-1-y);
		  	for (int x=0; x<Bitmap->Width; x++, sp++, dp++) {
    			if (*sp) {
            if (*sp & 0x8000) {
   	  			  *dp = *sp & 0x7FFF;
            } else {
            	c = *sp & 0x1FFF;
					    ydc = Yarn->Choice[c>>11].Color[(c>>8)&7];
              if (*sp&0x4000) {
	     				  *dp = RGBToColor15(ydc[(c>>3)&0x1F]->GetColor((c&7)>>1)->RGB);
              } else {
	     				  *dp = RGBToColor15(ydc[(c>>3)&0x1F]->GetColor(-((c&7)>>1))->RGB);
              }
            }
		  		} else {
			 	  	*dp = RGBToColor15(bgColor);
    		  }
		    }
  			Bitmap->PutScanLine(Bitmap->Height-1-y);
	  	}
    }
  	Bitmap->StopScanLine();
    bmFront->unlock();
  } else Bitmap->FillRect(Rect(0, 0, Bitmap->Width, Bitmap->Height), RGBToTColor(bgColor));
  return;
fail:
 	Bitmap->StopScanLine();
  if (bf) bmFront->unlock();
  EXCEPTION_MESSAGE_OK(EC_MEMORY_LACK);
}
//---------------------------------------------------------------------------

void __fastcall TPlan::DrawBack(TTexpiaBitmap *Bitmap, RGBQUAD bgColor)
{
	WORD *sp, *dp, c;
  TGradeColor **ydc;
  WORD *bb = NULL;

	if (bmBack) {
    bb = bmBack->lock();
	  if (bb == NULL) goto fail;
    if (Bitmap->StartScanLine() == false) goto fail;
		if (WeaveCondition.WovenEffect==WESolid) {
	  	for (int y=0; y<Bitmap->Height; y++) {
		  	sp = bmBack->pointer(0, y);
			 	dp = (WORD *)Bitmap->GetScanLine(Bitmap->Height-1-y)+Bitmap->Width-1;
		  	for (int x=0; x<Bitmap->Width; x++, sp++, dp--) {
    			if (*sp) {
            if (*sp & 0x8000) {
   	  			  *dp = *sp & 0x7FFF;
            } else {
            	c = *sp & 0x1FFF;
				  	  ydc = Yarn->Choice[c>>11].Color[(c>>8)&7];
 	    			  *dp = RGBToColor15(ydc[(c>>3)&0x1F]->GetColor(0)->RGB);
            }
		  		} else {
			 	  	*dp = RGBToColor15(bgColor);
    		  }
		    }
  			Bitmap->PutScanLine(Bitmap->Height-1-y);
	  	}
    } else if (WeaveCondition.WovenEffect==WETypeA) {
	  	for (int y=0; y<Bitmap->Height; y++) {
		  	sp = bmBack->pointer(0, y);
			 	dp = (WORD *)Bitmap->GetScanLine(Bitmap->Height-1-y)+Bitmap->Width-1;
		  	for (int x=0; x<Bitmap->Width; x++, sp++, dp--) {
    			if (*sp) {
            if (*sp & 0x8000) {
   	  			  *dp = *sp & 0x7FFF;
            } else {
            	c = *sp & 0x1FFF;
				  	  ydc = Yarn->Choice[c>>11].Color[(c>>8)&7];
 			    	  *dp = RGBToColor15(ydc[(c>>3)&0x1F]->GetColor((c&7)-4)->RGB);
            }
		  		} else {
			 	  	*dp = RGBToColor15(bgColor);
    		  }
		    }
  			Bitmap->PutScanLine(Bitmap->Height-1-y);
	  	}
	  } else {
	  	for (int y=0; y<Bitmap->Height; y++) {
		  	sp = bmBack->pointer(0, y);
			 	dp = (WORD *)Bitmap->GetScanLine(Bitmap->Height-1-y)+Bitmap->Width-1;
		  	for (int x=0; x<Bitmap->Width; x++, sp++, dp--) {
    			if (*sp) {
            if (*sp & 0x8000) {
   	  			  *dp = *sp & 0x7FFF;
            } else {
            	c = *sp & 0x1FFF;
				  	  ydc = Yarn->Choice[c>>11].Color[(c>>8)&7];
              if (*sp&0x4000) {
	     				  *dp = RGBToColor15(ydc[(c>>3)&0x1F]->GetColor((c&7)>>1)->RGB);
              } else {
	     				  *dp = RGBToColor15(ydc[(c>>3)&0x1F]->GetColor(-((c&7)>>1))->RGB);
              }
            }
		  		} else {
			 	  	*dp = RGBToColor15(bgColor);
    		  }
		    }
  			Bitmap->PutScanLine(Bitmap->Height-1-y);
	  	}
    }
  	Bitmap->StopScanLine();
    bmBack->unlock();
  } else Bitmap->FillRect(Rect(0, 0, Bitmap->Width, Bitmap->Height), RGBToTColor(bgColor));
  return;
fail:
	Bitmap->StopScanLine();
  if (bb) bmBack->unlock();
  EXCEPTION_MESSAGE_OK(EC_MEMORY_LACK);
}
//---------------------------------------------------------------------------
TPException __fastcall TPlan::DrawWarpBarFront(TTexpiaBitmap *Bitmap)
{
	TList *Array = Yarn->Array[WARP];
  char c;
  int i, x, y, vx, vy, n, o, r, ic, repeat, tl, tension, s, Crepeat, rs, dd, rn;
  double al, gs, gt;
  TWeaveData wd;
  TPException ec = EC_NONE;

  if (Array->Count==0) return ec;
  Bitmap->FillRect(Rect(0, 0, Bitmap->Width, Bitmap->Height), clBlack);
  InitYarnDot(WARP);
  tension = WeaveCondition.Tension;

  if ((s = getsize(WARP, Bitmap->Width)) == 0) { ec = EC_HIGH_DENSITY; goto fail; }
  if (xwp) delete[] xwp;
  xwp = new int[s];

  tl = 0; al = tl;
  wd.tc = ic = 0;
  n = 0;
  Crepeat = 0;
  rs = rn = NULL;
  while (((TYarnArray *)Array->Items[n])->code==0) n++;
  o = n;
  repeat = ((TYarnArray *)Array->Items[n])->repeat;
  r = n;
  if (!InitWeaveData(wd, WARP, o)) { ec = EC_HIGH_DENSITY; goto fail; }

  if (Bitmap->StartScanLine() == false) { ec = EC_MEMORY_LACK; goto fail; }
  while (al+wd.dpy<Bitmap->Width) {
  	if (wd.dpy>0) {
	    if (*(xwp+wd.tc)<=0 || *(xwp+wd.tc)>=wd.l) {
  	    *(xwp+wd.tc) = rand()%wd.l;
    	}
      if (wd.ydye) {
	      if (wd.gap>0.0) {
  	      gs = (rand()%int(wd.gap*100))/100.0;
    	    gt = wd.gap/(wd.gap*tension + rand()%10);
//    	    gt = wd.gap/(16+rand()%10);
      	  for (y=0; y<Bitmap->Height; y++) {
        	  wd.v = al+gs;
	          if (gt>=0) {
  	          if (gs+gt>=wd.gap) gt = -gt;
    	      } else {
      	      if (gs+gt<0) gt = -gt;
        	  }
	          gs += gt;
  	        WarpBarFront15(Bitmap, wd, y);
    	    }
	      } else {
  	      wd.v = al;
    	    for (y=0; y<Bitmap->Height; y++) {
      	    WarpBarFront15(Bitmap, wd, y);
	        }
  	    }
      } else {
	      if (wd.gap>0.0) {
  	      gs = (rand()%int(wd.gap*100))/100.0;
    	    gt = wd.gap/(wd.gap*tension + rand()%10);
//    	    gt = wd.gap/(16+rand()%10);
      	  for (y=0; y<Bitmap->Height; y++) {
        	  wd.v = al+gs;
	          if (gt>=0) {
  	          if (gs+gt>=wd.gap) gt = -gt;
    	      } else {
      	      if (gs+gt<0) gt = -gt;
        	  }
	          gs += gt;
  	        WarpBarFront8(Bitmap, wd, y);
    	    }
	      } else {
  	      wd.v = al;
    	    for (y=0; y<Bitmap->Height; y++) {
      	    WarpBarFront8(Bitmap, wd, y);
	        }
  	    }
      }
    	wd.tc++; ic++;
	    al += wd.dpy;
  	  if (ic>=wd.yarns) {
    	  ic = 0;
        if (!bTextureCorrection) {
        	tl += data[WARP][data[WARP][o].num].dot; al = tl;
        }
	      if (Change(WARP, n, o, r, repeat, Crepeat, rs, rn)) break;
        else if (!InitWeaveData(wd, WARP, o)) { ec = EC_HIGH_DENSITY; goto fail; }
  	  }
    } else {
   	  ic = 0;
      if (!bTextureCorrection) {
       	tl += data[WARP][data[WARP][o].num].dot; al = tl;
      }
      if (Change(WARP, n, o, r, repeat, Crepeat, rs, rn)) break;
      else if (!InitWeaveData(wd, WARP, o)) { ec = EC_HIGH_DENSITY; goto fail; }
    }
  }
  Bitmap->StopScanLine();
  ExitYarnDot(WARP);
  delete[] xwp;  xwp = NULL;
  return ec;
fail:
  Bitmap->StopScanLine();
  ExitYarnDot(WARP);
  delete[] xwp;
  return ec;
}
//---------------------------------------------------------------------------
TPException __fastcall TPlan::DrawWarpBarBack(TTexpiaBitmap *Bitmap)
{
	TList *Array = Yarn->Array[WARP];
  char c;
  int i, x, y, vx, vy, n, o, r, ic, repeat, tl, tension, s, Crepeat, rs, rn;
  double al, gs, gt;
  TWeaveData wd;
  TPException ec = EC_NONE;

  if (Array->Count==0) return ec;
  Bitmap->FillRect(Rect(0, 0, Bitmap->Width, Bitmap->Height), clBlack);
  InitYarnDot(WARP);
  tension = WeaveCondition.Tension;

  if ((s = getsize(WARP, Bitmap->Width)) == 0) { ec = EC_HIGH_DENSITY; goto fail; }
  if (xwp) delete[] xwp;
  xwp = new int[s];

  tl = 0; al = tl;
  wd.tc = ic = 0;
  n = 0;
  Crepeat = 0;
  rs = rn = NULL;
  while (((TYarnArray *)Array->Items[n])->code==0) n++;
  o = n;
  repeat = ((TYarnArray *)Array->Items[n])->repeat;
  r = n;
  if (!InitWeaveData(wd, WARP, o)) { ec = EC_HIGH_DENSITY; goto fail; }
  if (Bitmap->StartScanLine() == false) { ec = EC_MEMORY_LACK; goto fail; }
  while (al+wd.dpy<Bitmap->Width) {
  	if (wd.dpy>0) {
	    if (*(xwp+wd.tc)<=0 || *(xwp+wd.tc)>=wd.l) {
  	    *(xwp+wd.tc) = rand()%wd.l;
    	}
      if (wd.ydye) {
	      if (wd.gap>0.0) {
  	      gs = (rand()%int(wd.gap*100))/100.0;
    	    gt = wd.gap/(wd.gap*tension + rand()%10);
//    	    gt = wd.gap/(16+rand()%10);
      	  for (y=0; y<Bitmap->Height; y++) {
        	  wd.v = al+gs;
	          if (gt>=0) {
  	          if (gs+gt>=wd.gap) gt = -gt;
    	      } else {
      	      if (gs+gt<0) gt = -gt;
        	  }
	          gs += gt;
  	        WarpBarBack15(Bitmap, wd, y);
    	    }
	      } else {
  	      wd.v = al;
    	    for (y=0; y<Bitmap->Height; y++) {
      	    WarpBarBack15(Bitmap, wd, y);
	        }
  	    }
      } else {
	      if (wd.gap>0.0) {
  	      gs = (rand()%int(wd.gap*100))/100.0;
    	    gt = wd.gap/(wd.gap*tension + rand()%10);
//    	    gt = wd.gap/(16+rand()%10);
      	  for (y=0; y<Bitmap->Height; y++) {
        	  wd.v = al+gs;
	          if (gt>=0) {
  	          if (gs+gt>=wd.gap) gt = -gt;
    	      } else {
      	      if (gs+gt<0) gt = -gt;
        	  }
	          gs += gt;
  	        WarpBarBack8(Bitmap, wd, y);
    	    }
	      } else {
  	      wd.v = al;
    	    for (y=0; y<Bitmap->Height; y++) {
      	    WarpBarBack8(Bitmap, wd, y);
	        }
  	    }
      }
    	wd.tc++; ic++;
	    al += wd.dpy;
  	  if (ic>=wd.yarns) {
    	  ic = 0;
        if (!bTextureCorrection) {
        	tl += data[WARP][data[WARP][o].num].dot; al = tl;
        }
	      if (Change(WARP, n, o, r, repeat, Crepeat, rs, rn)) break;
        else if (!InitWeaveData(wd, WARP, o)) { ec = EC_HIGH_DENSITY; goto fail; }
  	  }
    } else {
   	  ic = 0;
      if (!bTextureCorrection) {
       	tl += data[WARP][data[WARP][o].num].dot; al = tl;
      }
      if (Change(WARP, n, o, r, repeat, Crepeat, rs, rn)) break;
      else if (!InitWeaveData(wd, WARP, o)) { ec = EC_HIGH_DENSITY; goto fail; }
    }
  }
  Bitmap->StopScanLine();
  ExitYarnDot(WARP);
  delete[] xwp; xwp = NULL;
  return ec;
fail:
  Bitmap->StopScanLine();
  ExitYarnDot(WARP);
  return ec;
}
//---------------------------------------------------------------------------
TPException __fastcall TPlan::DrawWeftBar(TTexpiaBitmap *Bitmap)
{
	TList *Array = Yarn->Array[WEFT];
  char c;
  int i, x, y, vx, vy, n, o, r, ic, repeat, tl, tension, s, Crepeat, rs, rn;
  double al, gs, gt;
  TWeaveData wd;
  TPException ec = EC_NONE;

  if (Array->Count==0) return ec;
  Bitmap->FillRect(Rect(0, 0, Bitmap->Width, Bitmap->Height), clBlack);
  InitYarnDot(WEFT);
  tension = WeaveCondition.Tension;

  if ((s = getsize(WEFT, Bitmap->Height)) == 0) { ec = EC_HIGH_DENSITY; goto fail; }
  if (ywt) delete[] ywt;
  ywt = new int[s];

  tl = 0; al = tl;
  wd.tc = ic = 0;
  n = 0;
  Crepeat = 0;
  rs = rn = NULL;
  while (((TYarnArray *)Array->Items[n])->code==0) n++;
  o = n;
  repeat = ((TYarnArray *)Array->Items[n])->repeat;
  r = n;
  if (!InitWeaveData(wd, WEFT, o)) { ec = EC_HIGH_DENSITY; goto fail; }
  if (Bitmap->StartScanLine() == false) { ec = EC_MEMORY_LACK; goto fail; }
  while (al+wd.dpy<Bitmap->Height) {
  	if (wd.dpy>0) {
	    if (*(ywt+wd.tc)<=0 || *(ywt+wd.tc)>=wd.l) {
  	    *(ywt+wd.tc) = rand()%wd.l;
    	}
      if (wd.ydye) {
	      if (wd.gap>0.0) {
  	      gs = (rand()%int(wd.gap*100))/100.0;
    	    gt = wd.gap/(wd.gap*tension + rand()%10);
//    	    gt = wd.gap/(16+rand()%10);
      	  for (x=0; x<Bitmap->Width; x++) {
        	  wd.v = al+gs;
	          if (gt>=0) {
  	          if (gs+gt>=wd.gap) gt = -gt;
    	      } else {
      	      if (gs+gt<0) gt = -gt;
        	  }
	          gs += gt;
  	        WeftBar15(Bitmap, wd, x);
    	    }
	      } else {
  	      wd.v = al;
    	    for (x=0; x<Bitmap->Width; x++) {
      	    WeftBar15(Bitmap, wd, x);
	        }
  	    }
      } else {
	      if (wd.gap>0.0) {
  	      gs = (rand()%int(wd.gap*100))/100.0;
    	    gt = wd.gap/(wd.gap*tension + rand()%10);
//    	    gt = wd.gap/(16+rand()%10);
      	  for (x=0; x<Bitmap->Width; x++) {
        	  wd.v = al+gs;
	          if (gt>=0) {
  	          if (gs+gt>=wd.gap) gt = -gt;
    	      } else {
      	      if (gs+gt<0) gt = -gt;
        	  }
	          gs += gt;
  	        WeftBar8(Bitmap, wd, x);
    	    }
	      } else {
  	      wd.v = al;
    	    for (x=0; x<Bitmap->Width; x++) {
      	    WeftBar8(Bitmap, wd, x);
	        }
  	    }
      }
    	wd.tc++; ic++;
	    al += wd.dpy;
  	  if (ic>=wd.yarns) {
    	  ic = 0;
        if (!bTextureCorrection) {
        	tl += data[WEFT][data[WEFT][o].num].dot; al = tl;
        }
	      if (Change(WEFT, n, o, r, repeat, Crepeat, rs, rn)) break;
        else if (!InitWeaveData(wd, WEFT, o)) { ec = EC_HIGH_DENSITY; goto fail; }
      }
    } else {
   	  ic = 0;
      if (!bTextureCorrection) {
       	tl += data[WEFT][data[WEFT][o].num].dot; al = tl;
      }
      if (Change(WEFT, n, o, r, repeat, Crepeat, rs, rn)) break;
      else if (!InitWeaveData(wd, WEFT, o)) { ec = EC_HIGH_DENSITY; goto fail; }
    }
  }
  Bitmap->StopScanLine();
  ExitYarnDot(WEFT);
  delete[] ywt; ywt = NULL;
  return ec;
fail:
  Bitmap->StopScanLine();
  ExitYarnDot(WARP);
  delete[] ywt;
  return ec;
}
//---------------------------------------------------------------------------
void __fastcall TPlan::MakeYarnMap4HighDPI(int DPI)
{
  int x, y, l, t, Thick, Length, Width, Size;
  for(int i = 0; i< 8; i++){
     if (Yarn->Choice[i].Data == NULL) continue;
     t =  Yarn->Choice[i].Data->Thick;
     Thick = ceil(Yarn->Choice[i].Data->ExactThick * DPI / 160.0);
     l =  Yarn->Choice[i].Data->Length;
     Length =  l* DPI/160.0;
     Width =  Yarn->Choice[i].Data->Width * Thick/t;
     Size = Length*Width;
     if(Yarn->Choice[i].Data->Dyed){
        if (HighYarnMap[i]) delete HighYarnMap[i];
        (WORD *)HighYarnMap[i] = new WORD[Size];
        for(y = 0; y < Width; y++){         //Data Map PatternDPI  β δ Ratioŭ
           for(x = 0; x < Length; x++){     // δ DPI/160 ŭ Ȯϴ 
              *((WORD *)HighYarnMap[i] +y*Length +x) = *((WORD *)Yarn->Choice[i].Data->Map
                       + l*int(y*t/Thick+0.5) + int(x*160.0/DPI));
           }
        }
     } else {
        if (HighYarnMap[i]) delete HighYarnMap[i];
        (BYTE *)HighYarnMap[i] = new BYTE[Size];
        for(y = 0; y < Width; y++){
           for(x = 0; x < Length; x++){
              *((BYTE *)HighYarnMap[i] +y*Length +x) = *((BYTE *)Yarn->Choice[i].Data->Map
                                           + l*int(y*t/Thick+0.5) + int(x*160.0/DPI));
           }
        }
     }
  }
}
//----------------------------------------------------------------------------
void __fastcall TPlan::Sucking(bool FrontBack)
{
	int ec;
  THLS APMask;
  RGBQUAD tempRGB;
  TTexpiaBitmap *TempBitmap;
  WORD *bpMainImage, *bpCopy;
  Byte *bpMaskImage, *bpMp, mm;
  int x, y, xx, yy, k, i, sum, ssum, cnt, scnt, posy;
  int j, suckercnt, status;     //for StatusPregress
  int xPos, Sign;               //for Front or Back
  double ratio;
  TCursor OldCursor;

  TPItemImage *Image = MainImageForm->iMainImage;
  TempBitmap = new TTexpiaBitmap;
  TempBitmap->Copy(SuckerData.SuckerBitmap, SRCCOPY);
  TempBitmap->ResizeStretch(int(SuckerData.Repro * TempBitmap->Width), int(SuckerData.Repro * TempBitmap->Height));
  Image->Bitmap->StartScanLine();
  TempBitmap->StartScanLine();
  CopyBitmap->StartScanLine();
  OldCursor = Screen->Cursor;
 	Screen->Cursor = crHourGlass;
  cnt = GetCount(WARP);
  scnt = GetSCount(WARP);
  sum = 0; ssum = 0; i = 0; k = 0;
  posy = rand();
  if (!WeaveCondition.ColorCorrection) ratio = (double)ExactLength[WARP][0]/Length[WARP][0];
  else ratio = 1;
  suckercnt = status = 0;
  while(sum+ratio*ssum < Image->Bitmap->Width) {
     if (bSucker[i%scnt]) suckercnt++;
     ssum += sLength[WARP][i%scnt];
     if (ssum >= Length[WARP][k%cnt]){
        if (!WeaveCondition.ColorCorrection) sum += ExactLength[WARP][k%cnt];
        else sum += Length[WARP][k%cnt];
        ssum = 0;
        k++;
        if (!WeaveCondition.ColorCorrection) ratio = (double)ExactLength[WARP][k%cnt]/Length[WARP][k%cnt];
        else ratio = 1;
     }
     i++;
  }
  StatusProgress->Maximum = suckercnt*Image->Bitmap->Height;
  sum = 0; ssum = 0; i = 0; k = 0;
  if (!WeaveCondition.ColorCorrection) ratio = (double)ExactLength[WARP][0]/Length[WARP][0];
  else ratio = 1;
  if (FrontBack == false) {xPos = 0;   Sign = 1;}
  else {xPos = Image->Bitmap->Width -1;   Sign = -1;}
  while(1){
     if(sum+ratio*(ssum+sLength[WARP][i%scnt]) < Image->Bitmap->Width) {
        if (bSucker[i%scnt]){
           for(y=0,yy=posy%TempBitmap->Height; y<Image->Bitmap->Height; y++,yy++){
              StatusProgress->Position = status++;
              bpMainImage = (WORD *)Image->Bitmap->GetScanLine(y) + xPos + Sign*(sum+(int)(ratio*ssum));
              bpMaskImage = (BYTE *)TempBitmap->GetScanLine(yy%TempBitmap->Height);
              bpCopy = (WORD *)CopyBitmap->GetScanLine(y) + xPos + Sign*(sum+(int)(ratio*ssum));
              for(x = sum+ratio*ssum; x < sum+ratio*(ssum+sLength[WARP][i%scnt]); x++){
                 tempRGB = Color15ToRGB(*bpCopy);
                 RGB2HLS(tempRGB.rgbRed, tempRGB.rgbGreen, tempRGB.rgbBlue, APMask.Hue, APMask.Lig, APMask.Sat);
                 APMask.Lig += (*(bpMaskImage+(x%TempBitmap->Width)) - 26) * SuckerData.Density;
                 if(APMask.Lig < 0) APMask.Lig = 0;
                 if(APMask.Lig > 1) APMask.Lig = 1.0;
                 HLS2RGB(APMask.Hue, APMask.Lig, APMask.Sat, tempRGB.rgbRed, tempRGB.rgbGreen, tempRGB.rgbBlue);
                 *bpMainImage = RGBToColor15(tempRGB);
                 bpMainImage += Sign;
                 bpCopy += Sign;
              }
              Image->Bitmap->PutScanLine(y);
           }
        }
     } else {
        if (bSucker[i%scnt]){
           for(y=0,yy=posy%TempBitmap->Height; y<Image->Bitmap->Height; y++,yy++){
              StatusProgress->Position = status + y;
              bpMainImage = (WORD *)Image->Bitmap->GetScanLine(y) + xPos + Sign*(sum+(int)(ratio*ssum));
              bpMaskImage = (BYTE *)TempBitmap->GetScanLine(yy%TempBitmap->Height);
              bpCopy = (WORD *)CopyBitmap->GetScanLine(y) + xPos + Sign*(sum+(int)(ratio*ssum));
              for(x = sum+ratio*ssum, xx = 0; x < sum+ratio*(ssum+sLength[WARP][i%scnt]); x++, xx++){
                 if (sum+ratio*ssum+xx < Image->Bitmap->Width){
                    tempRGB = Color15ToRGB(*bpCopy);
                    RGB2HLS(tempRGB.rgbRed, tempRGB.rgbGreen, tempRGB.rgbBlue, APMask.Hue, APMask.Lig, APMask.Sat);
                    APMask.Lig += (*(bpMaskImage+(x%TempBitmap->Width)) - 26) * SuckerData.Density;
                    if(APMask.Lig < 0) APMask.Lig = 0;
                    if(APMask.Lig > 1) APMask.Lig = 1.0;
                    HLS2RGB(APMask.Hue, APMask.Lig, APMask.Sat, tempRGB.rgbRed, tempRGB.rgbGreen, tempRGB.rgbBlue);
                    *bpMainImage = RGBToColor15(tempRGB);
                    bpMainImage += Sign;
                    bpCopy += Sign;
                 }
              }
              Image->Bitmap->PutScanLine(y);
           }
        }
        break;
     }
     ssum += sLength[WARP][i%scnt];
     if (ssum >= Length[WARP][k%cnt]){
        if (!WeaveCondition.ColorCorrection) sum += ExactLength[WARP][k%cnt];
        else sum += Length[WARP][k%cnt];
        ssum = 0;
        k++;
        if (!WeaveCondition.ColorCorrection) ratio = (double)ExactLength[WARP][k%cnt]/Length[WARP][k%cnt];
        else ratio = 1;
     }
     i++;
  }

  TempBitmap->StopScanLine();
  Image->Bitmap->StopScanLine();
  CopyBitmap->StopScanLine() ;
  StatusProgress->End();
  ::RepaintColor();
  Screen->Cursor = OldCursor;
  return;
}
//----------------------------------------------------------------------------
void __fastcall TPlan::SaveSuckerData(double Range, double Ratio, AnsiString fn, TTexpiaBitmap *sBitmap, Graphics::TBitmap *tBitmap)
{
  BYTE *fp;
  SuckerData.Repro = Ratio;
  SuckerData.Density = Range;
  SuckerData.FileName = fn;
  if (SuckerData.SuckerBitmap) delete SuckerData.SuckerBitmap;
  SuckerData.SuckerBitmap = new TTexpiaBitmap;
  SuckerData.SuckerBitmap->Copy(sBitmap, SRCCOPY);
  if (SuckerData.tagBitmap) delete SuckerData.tagBitmap;
  SuckerData.tagBitmap = new TPMemoryArea<BYTE>(80, 100);
  SuckerData.tagBitmap->lock();
  for (int y=0; y <100; y++){
     fp = SuckerData.tagBitmap->pointer(0, y);
     memcpy(fp, tBitmap->ScanLine[y], 80);
  }
  SuckerData.tagBitmap->unlock();
}
//----------------------------------------------------------------------------
void __fastcall TPlan::GetProductDataA(int i, int &TotalCnt, double &TotalLen)
{
  int n, o, r, ic, tc, Repeat, CRepeat, rs, rn;
  int a, cnt;
  bool IsNew;
  TYarnArray *ya;
  SimpleProductInfo *spi;
  n = 0; o = 0; r = 0;
  cnt = 0;
  CRepeat = 0;
  rs = NULL; rn = NULL;
  Repeat = ((TYarnArray *)Yarn->Array[i]->Items[n])->repeat;
  while (SimpleProductArray[i]->Count){
     spi = (SimpleProductInfo *)SimpleProductArray[i]->Last();
     SimpleProductArray[i]->Remove(spi);
     delete spi;
  }
  while(1){
     ya = (TYarnArray *)Yarn->Array[i]->Items[o];
     IsNew = true;
     for (a = 0; a < SimpleProductArray[i]->Count; a++){
        if (((SimpleProductInfo *)SimpleProductArray[i]->Items[a])->Code == ya->code) {IsNew = false;  break;}
     }
     if (IsNew) {
        spi = new SimpleProductInfo;
        spi->Code = ya->code;
        spi->Length = ya->length;
        spi->Yarns = ya->yarns;

        SimpleProductArray[i]->Add(spi);
        TotalCnt += ya->yarns;
        TotalLen += ya->length;
        cnt++;
     } else {
        spi = ((SimpleProductInfo *)SimpleProductArray[i]->Items[a]);
        spi->Yarns += ya->yarns;
        spi->Length += ya->length;
        TotalCnt += ya->yarns;
        TotalLen += ya->length;
     }
     if(Change(i, n, o, r, Repeat, CRepeat, rs, rn)) return;
  }
}
//----------------------------------------------------------------------------
void __fastcall TPlan::GetProductDataB(int i, int &TotalCnt, double &TotalLen)
{
  int n, o, r, ic, tc, Repeat, CRepeat, rs, rn;
  int a, cnt;
  bool IsNew;
  ProductInfo *pi;
  ArrayInfo *ai;
  TYarnArray *ya;
  n = 0; o = 0; r = 0;
  cnt = 0;
  CRepeat = 0;
  rs = NULL; rn = NULL;
  Repeat = ((TYarnArray *)Yarn->Array[i]->Items[n])->repeat;
  while (ProductArray[i]->Count){
     pi = (ProductInfo *)ProductArray[i]->Last();
     ProductArray[i]->Remove(pi);
     delete pi;
  }
  while (OrderArray[i]->Count){
     ai = (ArrayInfo *)OrderArray[i]->Last();
     OrderArray[i]->Remove(ai);
     delete ai;
  }
  while(1){
     ya = (TYarnArray *)Yarn->Array[i]->Items[o];
     IsNew = true;
     for (a = 0; a < ProductArray[i]->Count; a++){
        if (((ProductInfo *)ProductArray[i]->Items[a])->Code == ya->code) {IsNew = false;  break;}
     }
     if (IsNew) {
        pi = new ProductInfo;
        pi->Code = ya->code;
        pi->Count = Yarn->Choice[(ya->code-1)>>3].Data->Infor.Detail.Count;
        pi->Yarns = ya->yarns;
        pi->Length = ya->length;
        ProductArray[i]->Add(pi);
        ai = new ArrayInfo;
        ai->Code = char(65+cnt);
        ai->Yarns = ya->yarns;
        OrderArray[i]->Add(ai);
        TotalCnt += ya->yarns;
        TotalLen += ya->length;
        cnt++;
     } else {
        pi = ((ProductInfo *)ProductArray[i]->Items[a]);
        pi->Yarns += ya->yarns;
        pi->Length += ya->length;
        ai = new ArrayInfo;
        ai->Code = char(65+a);
        ai->Yarns = ya->yarns;
        OrderArray[i]->Add(ai);
        TotalCnt += ya->yarns;
        TotalLen += ya->length;
     }
     if(Change(i, n, o, r, Repeat, CRepeat, rs, rn)) return;
  }
}
//----------------------------------------------------------------------------

