//---------------------------------------------------------------------------
#include <vcl.h>
#include <printers.hpp>
#pragma hdrstop

#include "Printer_F.h"
#include "Plan.h"
#include "NewProductData.h"
#include "OldProductData.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TPSpin"
#pragma resource "*.dfm"
//---------------------------------------------------------------------------
#define IDS_PRINTFORM       StringTable[0]
#define IDS_A4              StringTable[1]
#define IDS_FREE            StringTable[2]
#define IDS_HEADER          StringTable[3]
#define IDS_PRODUCTIONDATA  StringTable[4]
#define IDS_FRONTBACK       StringTable[5]
//---------------------------------------------------------------------------
__fastcall TPrintForm::TPrintForm(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TPrintForm::FormClose(TObject *Sender,
      TCloseAction &Action)
{
 	TIniFile *IniFile = new TIniFile(DirectoryItem + "\\Environment.ini");
 	if (IniFile) {
		IniFile->WriteBool("Printer", "Method", cbMethod->ItemIndex);
	  delete IniFile;
  }
}
//---------------------------------------------------------------------------
void __fastcall TPrintForm::FormCreate(TObject *Sender)
{
	Method = 0;
//=============================================
  StringTable.Create(DirectoryItem, Language, "Printer");
  SetSmallFont(Font);
  Caption                         = IDS_PRINTFORM;
  lbPrinter->Caption = IDS_COMMON_PRINTER + " : " + Printer()->Printers->Strings[Printer()->PrinterIndex];
  for (int i = 0; i < 3; i++) {
    cbMethod->Items->Strings[i] = IDS_COMMON_PRINTMETHOD + " - " + AnsiString(i+1);
  }
  Label1->Caption                 = IDS_COMMON_PAGE;
  rgSize->Caption                 = IDS_COMMON_SIZE;
  rgSize->Items->Strings[0]       = IDS_A4;
  rgSize->Items->Strings[1]       = IDS_FREE;
  rgA4Header->Caption             = IDS_HEADER;
  rgA4Header->Items->Strings[0]   = IDS_COMMON_BUTTONNO;
  rgA4Header->Items->Strings[1]   = IDS_COMMON_BUTTONYES;
  rgA4Header->Items->Strings[2]   = IDS_FRONTBACK;
  rgA4Header->Items->Strings[3]   = IDS_PRODUCTIONDATA+" A";
  rgA4Header->Items->Strings[4]   = IDS_PRODUCTIONDATA+" B";
  rgFreeHeader->Caption           = IDS_HEADER;
  rgFreeHeader->Items->Strings[0] = IDS_COMMON_BUTTONNO;
  rgFreeHeader->Items->Strings[1] = IDS_COMMON_BUTTONYES;
  PrinterSetupBtn->Caption        = IDS_COMMON_SETUP;
  PrintBtn->Caption               = IDS_COMMON_PRINT;
  CancelBtn->Caption              = IDS_COMMON_BUTTONCANCEL;
//=============================================
  TIniFile *IniFile = new TIniFile(DirectoryItem + "\\Environment.ini");
 	if (IniFile) {
    cbMethod->ItemIndex = IniFile->ReadBool("Printer", "Method", 0);
	  delete IniFile;
  }
}
//---------------------------------------------------------------------------
void __fastcall TPrintForm::FormShow(TObject *Sender)
{
  PrintBtn->Enabled = FbRun;
}
//---------------------------------------------------------------------------
void __fastcall TPrintForm::rgSizeClick(TObject *Sender)
{
  if(rgSize->ItemIndex==0) {
    pnA4->BringToFront();
    rgA4Header->ItemIndex = 0;
    Method = 0;
  } else {
    rgFreeHeader->BringToFront();
    rgFreeHeader->ItemIndex = 0;
    Method = 5;
  }
}
//---------------------------------------------------------------------------
void __fastcall TPrintForm::rgHeaderClick(TObject *Sender)
{
	TRadioGroup *rg = (TRadioGroup *) Sender;
 	Method = rg->ItemIndex;
	if (rg->Tag) Method = rg->ItemIndex + 5;
  if (Method == 3) {
    ProductDataForm = NULL;
  	ProductDataForm = new TProductDataForm(this);
    if (ProductDataForm == NULL) goto fail;
    ProductDataForm->ShowModal();
    ActingReedWidth = ProductDataForm->arWidth;
    WeftDensity = ProductDataForm->weDensity;
    TotalWarpCnt = ProductDataForm->TotalWarpCnt;
    TotalLength[0] = ProductDataForm->TotalLength[0];
    TotalLength[1] = ProductDataForm->TotalLength[1];
    TotalYarns[0] = ProductDataForm->TotalCnt[0];
    TotalYarns[1] = ProductDataForm->TotalCnt[1];
    delete ProductDataForm;  ProductDataForm = NULL;
  } else if (Method == 4) {
    NewProductDataForm = NULL;
  	NewProductDataForm = new TNewProductDataForm(this);
    if (NewProductDataForm == NULL) goto fail;
    NewProductDataForm->ShowModal();
    delete NewProductDataForm;  NewProductDataForm = NULL;
  }
  return;

fail:
  EXCEPTION_MESSAGE_OK(EC_MEMORY_LACK);
}
//---------------------------------------------------------------------------
void __fastcall TPrintForm::PrinterSetupBtnClick(TObject *Sender)
{
  PrinterSetupDialog1->Execute();
  lbPrinter->Caption = IDS_COMMON_PRINTER + " : " + Printer()->Printers->Strings[Printer()->PrinterIndex];
}
//---------------------------------------------------------------------------


