//---------------------------------------------------------------------------
#include <vcl.h>
#include <math.h>
#include <stdio.h>
#pragma hdrstop

#include "Main.h"
#include "About.h"
#include "ColorChart.h"
#include "ColorLibrary_f.h"
#include "Common.h"
#include "Define.h"
#include "Des.h"
#include "EnlargeCanvas.h"
#include "Environment.h"
#include "Exception.h"
#include "FileManager_F.h"
#include "FullView.h"
#include "History.h"
#include "ProtectCard.h"
#include "MainMenu.h"
#include "NewCanvas.h"
#include "Palette.h"
#include "Printer_F.h"
#include "StatusProgress.h"
#include "UserColor_F.h"
#include "Texture_F.h"
#include "TextureDesign_F.h"
#include "YarnBrightness_F.h"
#include "YarnDesign_F.h"
#include "YarnScan_F.h"
#include "YarnTable_F.h"
#include "ColorChange_F.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

#define IDS_WTEXPIADESIGNCAD  StringTable[0]
#define IDS_WNEWCANVAS        StringTable[1]
#define IDS_WFILEMANAGER      StringTable[2]
#define IDS_WREOPEN           StringTable[3]
#define IDS_WCLOSE            StringTable[4]
#define IDS_WCLOSEALL         StringTable[5]
#define IDS_WENLARGECANVAS    StringTable[6]
#define IDS_WPRINTERSETUP     StringTable[7]
#define IDS_WPRINTING         StringTable[8]

#define IDS_WOPTIONS          StringTable[9]
#define IDS_WFONT             StringTable[10]
#define IDS_WYARNBRIGHT       StringTable[11]

#define IDS_WEDIT             StringTable[12]
#define IDS_WCOPY             StringTable[13]
#define IDS_WYARNDESIGN       StringTable[14]
#define IDS_WYARNMAKER        StringTable[15]
#define IDS_WYARNSCAN         StringTable[16]
#define IDS_WTEXTUREDESIGN    StringTable[17]
#define IDS_WPATTERNDESIGN    StringTable[18]

#define IDS_WYARN             StringTable[19]
#define IDS_WTEXTURE          StringTable[20]
#define IDS_WWEAVING          StringTable[21]
#define IDS_WVIEW             StringTable[22]
#define IDS_WFULLVIEW         StringTable[23]
#define IDS_WPALETTE          StringTable[24]
#define IDS_WMAINMENU         StringTable[25]
#define IDS_WSTATUSBAR        StringTable[26]
#define IDS_WTOOLSREARRANGE   StringTable[27]
#define IDS_WWINDOW           StringTable[28]

#define IDS_WCASCADE          StringTable[29]
#define IDS_WTILE             StringTable[30]
#define IDS_WARRANGEICONS     StringTable[31]
#define IDS_WMINIMIZEALL      StringTable[32]
#define IDS_WHELP             StringTable[33]
#define IDS_WABOUT            StringTable[34]
#define IDS_WFILE             StringTable[35]
#define IDS_WEXIT             StringTable[36]

#define IDS_WE1               StringTable[37]
#define IDS_WE2               StringTable[38]
#define IDS_WE3               StringTable[39]
#define IDS_WE4               StringTable[40]
#define IDS_WE5               StringTable[41]

#define IDS_WE6               StringTable[42]
#define IDS_WE7               StringTable[43]
#define IDS_WE8               StringTable[44]
#define IDS_WE9               StringTable[45]

#define IDS_WE10              StringTable[46]
#define IDS_WE11              StringTable[47]
#define IDS_WE12              StringTable[48]
#define IDS_WE13              StringTable[49]
#define IDS_WE14              StringTable[50]

#define IDS_WE15              StringTable[51]
#define IDS_WE16              StringTable[52]
#define IDS_WE17              StringTable[53]
#define IDS_WE18              StringTable[54]
#define IDS_WE19              StringTable[55]
#define IDS_WE20              StringTable[56]
#define IDS_WE21              StringTable[57]
#define IDS_WE22              StringTable[58]
#define IDS_WE23              StringTable[59]
//---------------------------------------------------------------------
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
  : TForm(Owner)
{
  bFirst = 0;
  if(GetSystemMetrics(SM_CXSCREEN)>=1280&&GetSystemMetrics(SM_CYSCREEN)>=1024){
    HorzScrollBar->Tracking=false;
    HorzScrollBar->Visible=false;
    VertScrollBar->Tracking=false;
    VertScrollBar->Visible=false;
  } else {
    HorzScrollBar->Tracking=true;
    HorzScrollBar->Visible=true;
    VertScrollBar->Tracking=true;
    VertScrollBar->Visible=true;
  }
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormActivate(TObject *Sender)
{
  TMainImageForm *Child = NULL;
  TPCanvasInfor p;
  TPException ec = EC_NONE;
  AnsiString FileName, DirName;
  int WeaveDPI;

	if (bFirst==1) {
//============================
    if (ParamStr(1) != ""){
      DirName = ExtractFileDir(ParamStr(1));
      FileName = ExtractFileName(ParamStr(1));
      OpenFile(DirName, DirName + "\\" + FileName, gffWAV, 8);
    } else {
  	  if ((Child = new TMainImageForm(Application))==NULL) { ec = EC_FORM_NOT_CREATE; goto fail; }
      p.Orientation = coPortrait;
 //================================ //2001.4.10. by lhskys congi  size ֱ

    TIniFile *IniFile = new TIniFile(DirectoryItem+"\\Environment.ini");
    int cst;
    if(Size_Type == "cstA4"){p.SetSize(cstA4);
      cst = 0;
      IniFile->WriteInteger("MainImage","Size",cst);
    }else if(Size_Type == "cstA3"){p.SetSize(cstA3);
      cst = 1;
      IniFile->WriteInteger("MainImage","Size",cst);
    }else if(Size_Type == "cstA2"){p.SetSize(cstA2);
      cst = 2;
      IniFile->WriteInteger("MainImage","Size",cst);
    }else if(Size_Type == "cstA1"){p.SetSize(cstA1);
      cst = 3;
      IniFile->WriteInteger("MainImage","Size",cst);
    }else if(Size_Type == "cstA0"){p.SetSize(cstA0);
      cst = 4;
      IniFile->WriteInteger("MainImage","Size",cst);
    }else if(Size_Type == "cstLetter"){p.SetSize(cstLetter);
      cst = 6;
      IniFile->WriteInteger("MainImage","Size",cst);
    }else if(Size_Type == "cstLegal"){p.SetSize(cstLegal);
      cst = 7;
      IniFile->WriteInteger("MainImage","Size",cst);
    }else if(Size_Type == "cstTabloid"){p.SetSize(cstTabloid);
      cst = 8;
      IniFile->WriteInteger("MainImage","Size",cst);
    }
 //====================================== //2001.4.10. by lhskys 
      WeaveDPI = IniFile->ReadInteger("CanvasInfor", "DPI", 160);
      p.DotsPerInch = WeaveDPI;
//        p.SetSize(cstA4);
      if ((ec = Child->InitForm(p))!=EC_NONE) goto fail;
    }
//============================
  	bFirst = 2;
    ToolsRearrange();
  }
  return;
fail:
	if (Child) delete Child;
  EXCEPTION_MESSAGE_OK(ec);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
  int Items;
  TIniFile *IniFile;
  TPException ec = EC_NONE;

  Application->OnActivate = ApplicationActivate;
	Application->OnHint = ShowHint;
	Screen->OnActiveFormChange = UpdateMenuItems;
  LoadFromMainRegIniFile();
  MessageStringTable.Create(DirectoryBin, Language, "Message");
  if ((ProtectCard = new TProtectCard)==NULL) { ec = EC_INTERFACE_NONE; goto fail; }
#ifndef LOCK_CRYPKEY
#ifdef LOCK_IFC
 	Items = ProtectCard->Init(RegFilename);
  if (Items==0 || (Items&PCN_WEAVE)!=PCN_WEAVE) { ec = EC_INTERFACE_NONE; goto fail; }
	if (!ProtectCard->CheckPassword()) { ec = EC_INTERFACE_NONE; goto fail; }
#else
  Items = ProtectCard->Init(Password);
  if ((((Items>>14)&3)==3) || Items<1 || (Items&PCN_WEAVE)!=PCN_WEAVE) { ec = EC_INTERFACE_NONE; goto fail; }
#endif  
#endif
  CommonStringTable.Create(DirectoryBin, Language, "Common");
 	if ((SmallFont = new TFont)==NULL) { ec = EC_MEMORY_LACK; goto fail; }
	IniFile = new TIniFile(DirectoryItem + "\\Environment.ini");
 	if (IniFile) {
   	LoadFont(IniFile, SmallFont, "Font");
   	for (int i=0; i<7; i++) {
    	YarnBrightness[i] = IniFile->ReadFloat("YarnBrightness", AnsiString(i), -0.03+i*0.01);
    }
	  delete IniFile;
  } else {
   	SmallFont->Name = DefaultFontName;
   	SmallFont->Size = 10;
  }
  if ((Tablet = new TTablet)==NULL) { ec = EC_MEMORY_LACK; goto fail; }
  Tablet->Init(Handle, RegFilename.c_str());
	if ((PrinterColor = new TPrinterColor)==NULL) { ec = EC_MEMORY_LACK; goto fail; }
 	if ((StandardColor = new TStandardColor(DirectoryColor+"\\Standard.tpc"))==NULL) {
    ec = EC_MEMORY_LACK; goto fail;
  }
	if ((TextileColor = new TTextileColor(DirectoryColor+"\\Textile.tpc"))==NULL) {
    ec = EC_MEMORY_LACK; goto fail;
  }
 	if ((Pantone1000 = new TPantone1000(DirectoryColor+"\\Thousand.ptc"))==NULL) {
    ec = EC_MEMORY_LACK; goto fail;
  }
	if ((PantoneTextile = new TPantoneTextile(DirectoryColor+"\\Textile.ptc"))==NULL) {
    ec = EC_MEMORY_LACK; goto fail;
  }
	if ((MainMenuForm = new TMainMenuForm(this))==NULL) goto fail;
	MainMenuForm->Parent = this;
	MainMenuForm->Visible = true;
  MainMenuForm->OnUpdateMenu = UpdateMenuItems;
	if ((FullViewForm = new TFullViewForm(this))==NULL) goto fail;
 	FullViewForm->Parent = this;
 	FullViewForm->Visible = true;
  FullViewForm->OnUpdateMenu = UpdateMenuItems;
 	if ((PaletteForm = new TPaletteForm(this))==NULL) goto fail;
	PaletteForm->Parent = this;
  PaletteForm->Visible = true;
  PaletteForm->OnUpdateMenu = UpdateMenuItems;
	ToolsRearrange();
 	if ((ColorChartForm = new TColorChartForm(this))==NULL) goto fail;
	ColorChartForm->Parent = this;
 	if ((ColorLibraryForm = new TColorLibraryForm(this))==NULL) goto fail;
	ColorLibraryForm->Parent = this;
	ColorLibraryForm->OnColorChange = ::RepaintYarnColor;
  if ((UserColorLibForm = new TUserColorLibForm(this))==NULL) goto fail;
	UserColorLibForm->Parent = this;
  ClipboardFormat = RegisterClipboardFormat("Texpro");
	if ((StatusProgress = new TStatusProgress(StatusBar, StatusBarHint))==NULL) {
    ec = EC_MEMORY_LACK; goto fail;
  }
  if ((FileHistory = new TFileHistory(DirectoryItem + "\\Main.ini", 8, FReopenItem, &OpenFile))==NULL) {
    ec = EC_MEMORY_LACK; goto fail;
  }
	bFirst = 1;
  WeaveMenuItem = W_NONE;
  YarnRatio = 0.4;
  CompressMethod = cmZLib;
//=====================================================
  StringTable.Create(DirectoryItem, Language, "Main");
  SetSmallFont(Font);
  SetSmallFont(StatusBar->Font);
/*                                 // source code before ifdef lock+crypkey......
//  Caption                       = IDS_WTEXPIADESIGNCAD;
#ifdef JAPAN
  switch (Items >> 14) {
    case 1:	Caption = "Yuka & Alpha - Weave (Education)"; break;
    case 2:	Caption = "Yuka & Alpha - Weave (Demo)"; break;
    default: Caption = "Yuka & Alpha - Weave (Professional)"; break;
  }
#else
  #ifdef ACADEMY
  Caption = "Texpro Design CAD System - Weave (Academy)";
  #else
    #ifdef LOCK_IFC
  Caption = "Texpro Design CAD System - Weave (Professional)";
    #else
  switch (Items >> 14) {
    case 1: Caption = "Texpro Design CAD System - Weave (Education)"; break;
    case 2: Caption = "Texpro Design CAD System - Weave (Demo)"; break;
    default: Caption = "Texpro Design CAD System - Weave (Professional)"; break;
  }
    #endif
  #endif
#endif
*/
#ifdef LOCK_CRYPKEY
#ifdef JAPAN
  #ifdef EDUCATION
  Caption = "Yuka & Alpha - Weave (Education)";
  #endif
  #ifdef DEMO
  Caption = "Yuka & Alpha - Weave (Demo)";
  #endif
  #ifdef PROFESSIONAL
  Caption = "Yuka & Alpha - Weave (Professional)";
  #endif
#else
  #ifdef ACADEMY
  Caption = "Texpro Design CAD System - Weave (Academy)";
  #else
    #ifdef EDUCATION
  Caption = "Texpro Design CAD System - Weave (Education)";
    #endif
    #ifdef DEMO
  Caption = "Texpro Design CAD System - Weave (Demo)";
    #endif
    #ifdef PROFESSIONAL
  Caption = "Texpro Design CAD System - Weave (Professional)";
    #endif
  #endif
#endif
#else
#ifdef JAPAN
  switch (Items >> 14) {
    case 1:	Caption = "Yuka & Alpha - Weave (Education)"; break;
    case 2:	Caption = "Yuka & Alpha - Weave (Demo)"; break;
    default: Caption = "Yuka & Alpha - Weave (Professional)"; break;
  }
#else
  #ifdef ACADEMY
  Caption = "Texpro Design CAD System - Weave (Academy)";
  #else
    #ifdef LOCK_IFC
  Caption = "Texpro Design CAD System - Weave (Professional)";
    #else
  switch (Items >> 14) {
    case 1: Caption = "Texpro Design CAD System - Weave (Education)"; break;
    case 2: Caption = "Texpro Design CAD System - Weave (Demo)"; break;
    default: Caption = "Texpro Design CAD System - Weave (Professional)"; break;
  }
    #endif
  #endif
#endif
#endif
  FileItem->Caption             = IDS_WTEXPIADESIGNCAD;
  FNewCanvasItem->Caption       = IDS_WNEWCANVAS;
  FFileManagerItem->Caption     = IDS_WFILEMANAGER;
  FReopenItem->Caption          = IDS_WREOPEN;
  FCloseItem->Caption           = IDS_WCLOSE;
//  FCloseAllItem->Caption        = IDS_WCLOSEALL;
  FEnlargeCanvasItem->Caption   = IDS_WENLARGECANVAS;
  FFontItem->Caption            = IDS_WFONT;
  FEnvironmentItem->Caption     = IDS_COMMON_ENVIRONMENTSETUP;
  FPrinterSetupItem->Caption    = IDS_WPRINTERSETUP;
  FPrintingItem->Caption        = IDS_WPRINTING;

  EditItem->Caption             = IDS_WEDIT;
  ECopyItem->Caption            = IDS_WCOPY;
  YarnItem->Caption             = IDS_WYARNDESIGN;
  YYarnMakerItem->Caption       = IDS_WYARNMAKER;
  YYarnScanItem->Caption        = IDS_WYARNSCAN;
  TextureItem->Caption          = IDS_WTEXTUREDESIGN;
  PatternDesignItem->Caption    = IDS_WPATTERNDESIGN;

  PYarnItem->Caption            = IDS_WYARN;
  PTextureItem->Caption         = IDS_WTEXTURE;
  PWeavingItem->Caption         = IDS_WWEAVING;
  ViewItem->Caption             = IDS_WVIEW;
  VFullViewItem->Caption        = IDS_WFULLVIEW;
  VPaletteItem->Caption         = IDS_WPALETTE;
  VMainMenuItem->Caption        = IDS_WMAINMENU;
  VStatusBarItem->Caption       = IDS_WSTATUSBAR;
  VToolsRearrangeItem->Caption  = IDS_WTOOLSREARRANGE;
  WindowItem->Caption           = IDS_WWINDOW;

  WCascadeItem->Caption         = IDS_WCASCADE;
  WTileItem->Caption            = IDS_WTILE;
  WArrangeItem->Caption         = IDS_WARRANGEICONS;
  WMinimizeItem->Caption        = IDS_WMINIMIZEALL;
  HelpItem->Caption             = IDS_WHELP;
  HAboutItem->Caption           = IDS_WABOUT;
  FileItem->Caption             = IDS_WFILE;
  FExitItem->Caption            = IDS_WEXIT;


  Weave11->Caption              = IDS_WE1;
  Weave21->Caption              = IDS_WE2;
  N3->Caption                   = IDS_WE3;
  N8->Caption                   = IDS_WE4;
  N14->Caption                  = IDS_WE5;

  I1->Caption                   = IDS_WE6;
  II1->Caption                  = IDS_WE7;
  III1->Caption                 = IDS_WE8;
  N7->Caption                   = IDS_WE9;

  N9->Caption                   = IDS_WE10;
  N10->Caption                  = IDS_WE11;
  N11->Caption                  = IDS_WE12;
  N12->Caption                  = IDS_WE13;
  N13->Caption                  = IDS_WE14;

  N15->Caption                  = IDS_WE15;
  N16->Caption                  = IDS_WE16;
  N17->Caption                  = IDS_WE17;
  N18->Caption                  = IDS_WE18;
  N19->Caption                  = IDS_WE19;
  N20->Caption                  = IDS_WE20;
  N21->Caption                  = IDS_WE21;
  N22->Caption                  = IDS_WE22;
  N23->Caption                  = IDS_WE23;
	return;
fail:
	::doDestroy(FileHistory);
  ::doDestroy(StatusProgress);
	::doDestroy(UserColorLibForm);
	::doDestroy(ColorLibraryForm);
  ::doDestroy(ColorChartForm);
	::doDestroy(PaletteForm);
  ::doDestroy(FullViewForm);
	::doDestroy(MainMenuForm);
 	::doDestroy(PantoneTextile);
  ::doDestroy(Pantone1000);
 	::doDestroy(TextileColor);
  ::doDestroy(StandardColor);
 	::doDestroy(PrinterColor);
  ::doDestroy(Tablet);
	::doDestroy(SmallFont);
	::doDestroy(ProtectCard);
  if (ec == EC_NONE) ec = EC_FORM_NOT_CREATE;
  EXCEPTION_MESSAGE_OK(ec);
	Application->Terminate();  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormDestroy(TObject *Sender)
{
	TIniFile *IniFile;

	ExitMenuItem();
  changeDueDay();
  ::doDestroy(FileHistory);
	::doDestroy(StatusProgress);
	::doDestroy(ColorLibraryForm);
	::doDestroy(UserColorLibForm);
  ::doDestroy(ColorChartForm);
  ::doDestroy(PaletteForm);
  ::doDestroy(FullViewForm);
	::doDestroy(MainMenuForm);
 	::doDestroy(PantoneTextile);
  ::doDestroy(Pantone1000);
  ::doDestroy(TextileColor);
  ::doDestroy(StandardColor);
  ::doDestroy(PrinterColor);
  ::doDestroy(Tablet);
 	::doDestroy(SmallFont);
 	::doDestroy(ProtectCard);
	Screen->OnActiveFormChange = NULL;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormResize(TObject *Sender)
{
	int w = StatusBar->Width-(160+80+100+100+200);
	StatusBar->Panels->Items[StatusBarHint]->Width = w<100 ? 100 : w;
  if (StatusProgress) StatusProgress->Resize();  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormShow(TObject *Sender)
{
	if (MDIChildCount>0) ToolsRearrange();  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FNewCanvasItemClick(TObject *Sender)
{
  TCursor cur;
  TMainImageForm *Child = NULL;
  TNewCanvasForm *Form = NULL;
  TPException ec = EC_NONE;

	ExitMenuItem();
	MainMenuForm->ExitForm();
#ifndef LOCK_CRYPKEY
#ifdef LOCK_IFC
	if (ProtectCard->CheckPassword()) {
#else
    ProtectCard->Read();
#endif
#endif
	  if ((Form = new TNewCanvasForm(NULL))==NULL) { ec = EC_FORM_NOT_CREATE; goto fail; }
	  if (Form->ShowModal()==mrOk) {
  	  cur = Screen->Cursor;
    	Screen->Cursor = crHourGlass;
		  if ((Child = new TMainImageForm(Application))==NULL) { ec = EC_FORM_NOT_CREATE; goto fail; }
    	if ((ec = Child->InitForm(Form->CanvasInfor))!=EC_NONE) goto fail;
	    Screen->Cursor = cur;
    }
    delete Form;
#ifndef LOCK_CRYPKEY
#ifdef LOCK_IFC
  } else {
    EXCEPTION_MESSAGE_OK(EC_INTERFACE_NONE);
  	Application->Terminate();
  }
#endif
#endif
	return;
fail:
  if (Form) {
  	if (Child) delete Child;
    Screen->Cursor = cur;
    delete Form;
  }
  EXCEPTION_MESSAGE_OK(ec);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FFileManagerItemClick(TObject *Sender)
{
	TFileManagerForm *Form;

	ExitMenuItem();
	MainMenuForm->ExitForm();
#ifndef LOCK_CRYPKEY
#ifdef LOCK_IFC
	if (ProtectCard->CheckPassword()) {
#else
    ProtectCard->Read();
#endif
#endif
  	if ((Form = new TFileManagerForm(this)) == NULL) goto fail;
    if (MainImageForm) {
      Form->Extension = MainImageForm->iMainImage->Bitmap->BitsPerPixel;
      if (MainImageForm->Plan) {
        if (MainImageForm->Plan->Finish) {
          Form->SpeedButtonSave->Enabled = true;
          Form->SpeedButtonSaveAs->Enabled = true;
          Form->OnSave = FMOnSave;
        } else {
          Form->SpeedButtonSave->Enabled = false;
          Form->SpeedButtonSaveAs->Enabled = false;
        }
      } else {
        Form->SpeedButtonSave->Enabled = false;
        Form->SpeedButtonSaveAs->Enabled = false;
      }
    } else {
      Form->Extension = 8;
      Form->SpeedButtonSave->Enabled = false;
      Form->SpeedButtonSaveAs->Enabled = false;
    }
    Form->CompressCheckBox->Checked = (CompressMethod == cmNone) ? false: true;
    Form->FilterComboBox->Filter =
      "Texpro Weave File (*.wea)|*.wea|"
      "Texpro Weave File - V7.01 (*.wav)|*.wav";
    Form->OnRead = FMOnRead;
    Form->OnFileName = FMOnFileName;
//    Form->OnSave = FMOnSave;
  	Form->ShowModal();
    delete Form;
#ifndef LOCK_CRYPKEY
#ifdef LOCK_IFC
  } else {
    EXCEPTION_MESSAGE_OK(EC_INTERFACE_NONE);
	  Application->Terminate();
  }
#endif
#endif
  return;
fail:
  EXCEPTION_MESSAGE_OK(EC_FORM_NOT_CREATE);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FCloseItemClick(TObject *Sender)
{
	ExitMenuItem();
	MainMenuForm->ExitForm();
	if (ActiveMDIChild)	ActiveMDIChild->Close();  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FEnlargeCanvasItemClick(TObject *Sender)
{
  TCursor cur;
  TEnlargeCanvasForm *Form;

	ExitMenuItem();
	MainMenuForm->ExitForm();
#ifndef LOCK_CRYPKEY
#ifdef LOCK_IFC
	if (ProtectCard->CheckPassword()) {
#endif
#endif
  	Form = new TEnlargeCanvasForm(this);
    Form->CanvasInfor = MainImageForm->CanvasInfor;
	  if (Form->ShowModal()==mrOk) {
  	  cur = Screen->Cursor;
    	Screen->Cursor = crHourGlass;
      PaletteForm->Repaint();
			MainImageForm->EnlargeCanvas(Form->NewSize.cx, Form->NewSize.cy);
	    Screen->Cursor = cur;
    }
    delete Form;
#ifndef LOCK_CRYPKEY
#ifdef LOCK_IFC
  } else {
    EXCEPTION_MESSAGE_OK(EC_INTERFACE_NONE);
  	Application->Terminate();
  }
#endif
#endif
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FPrinterSetupItemClick(TObject *Sender)
{
  PrinterSetupDialog->Execute();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FPrintingItemClick(TObject *Sender)
{
	TPrintForm *Form = NULL;
  TTexpiaBitmap *Pattern = NULL;
  int DPI, len, item, zoom, mx, my;
  TSize r;
  bool checkback = true;

	ExitMenuItem();
	MainMenuForm->ExitForm();
  if ((Form = new TPrintForm(this)) == NULL) goto fail;
  if (MainImageForm && MainImageForm->Plan) Form->bRun = MainImageForm->Plan->Finish;
//if (MainImageForm->Plan->bOld == true) Form->rgA4Header->Items
  if (Form->ShowModal() == mrOk) {
    if ((Pattern = new TTexpiaBitmap)==NULL) goto fail;
    DPI = MainImageForm->CanvasInfor.DotsPerInch;
    if(Form->cbHigh->Checked == true) {
       TIniFile *IniFile = new TIniFile(DirectoryItem+"\\Environment.ini");
       if(IniFile){
          DPI = IniFile->ReadInteger("Printing", "DPI", 480);
          delete IniFile;
       } else DPI = 480;
       if (MainImageForm->Plan->WeaveCondition.HairEffect != HENone) DPI = 160;
       MainImageForm->Plan->bOld = false;
       MainImageForm->Plan->MakeYarnMap4HighDPI(DPI);
       MainImageForm->Plan->calc_weave(NULL,MainImageForm->Palette->ColorData[1]->RGB, DPI);
       MainImageForm->Plan->DrawWarpBar(NULL, MainImageForm->Palette->ColorData[1]->RGB, false, DPI);
       MainImageForm->Plan->DrawWeftBar(NULL, MainImageForm->Palette->ColorData[1]->RGB, DPI);
     }
    switch (Form->Method) {
    	case 0: // A4 Header No
        if(DPI >= 320) {
           if (MainImageForm->A4HighNoPrint(Pattern, DPI) == false) goto fail;
        } else {
           DPI = MainImageForm->CanvasInfor.DotsPerInch;
           if (MainImageForm->A4NoPrint(Pattern) == false) goto fail;
        }
     	  break;
      case 1: // A4 Header Yes
        if(DPI >= 320) {
    			 if (MainImageForm->A4HighYesPrint(Pattern, DPI) == false) goto fail;
        } else {
           DPI = MainImageForm->CanvasInfor.DotsPerInch;
           if (MainImageForm->A4YesPrint(Pattern) == false) goto fail;
        }
      	break;
      case 2: // A4 FrontBack
        if(DPI >= 320){
				   if (MainImageForm->A4HighFrontBackPrint(Pattern, checkback, DPI) == false) goto fail;
        } else {
           DPI = MainImageForm->CanvasInfor.DotsPerInch;
           if (MainImageForm->A4FrontBackPrint(Pattern, checkback) == false) goto fail;
        }
        break;
      case 3: // A4 Header Production Data A
        DPI = 160;
        if (MainImageForm->A4ProductDataAPrint(Pattern, Form->TotalLength, Form->TotalYarns,
            Form->ActingReedWidth, Form->WeftDensity, Form->TotalWarpCnt) == false) goto fail;
      	break;
      case 4: // A4 Header Production Data B
        DPI = 160;
        if (MainImageForm->A4ProductDataBPrint(Pattern) == false) goto fail;
      	break;

      case 5: // Free Header No
        if(DPI >= 320) {
           if(MainImageForm->FreeHighNoPrint(Pattern, DPI) == false) goto fail;
        } else {
           DPI = MainImageForm->CanvasInfor.DotsPerInch;
				   if (MainImageForm->FreeNoPrint(Pattern) == false) goto fail;
        }
      	break;
      case 6: // Free Header Yes
        if(DPI >= 320) {
           if(MainImageForm->FreeHighYesPrint(Pattern, DPI) == false) goto fail;
        } else {
           DPI = MainImageForm->CanvasInfor.DotsPerInch;
           if (MainImageForm->FreeYesPrint(Pattern) == false) goto fail;
        }
      	break;
    }
    if (checkback) {
      SendToPrinter(Pattern, DPI, "Weave - "+MainImageForm->FileName, Form->spPage->Value,
        Form->cbMethod->ItemIndex);
    }
    delete Pattern;
  }
  delete Form;
  return;
fail:
	if (Pattern) delete Pattern;
  if (Form) delete Form;
	EXCEPTION_MESSAGE_OK(EC_MEMORY_LACK);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FFontItemClick(TObject *Sender)
{
	ExitMenuItem();
	MainMenuForm->ExitForm();
 	FontDialog1->Font->Assign(SmallFont);
	if (FontDialog1->Execute()) {
    FontDialog1->Font->Size = 10;
  	SmallFont->Assign(FontDialog1->Font);
		TIniFile *IniFile = new TIniFile(DirectoryItem + "\\Environment.ini");
 		if (IniFile) {
   		SaveFont(IniFile, SmallFont, "Font");
		  delete IniFile;
  	}
    FullViewForm->SetFont();
    PaletteForm->SetFont();
    AboutBox->SetFont();
  }  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FEnvironmentItemClick(TObject *Sender)
{
  int unit;

	ExitMenuItem();
	MainMenuForm->ExitForm();
	TEnvironmentForm *Form = new TEnvironmentForm(this);
  if (Form->ShowModal()==mrOk) {
	  TIniFile *IniFile = new TIniFile(DirectoryItem+"\\Environment.ini");
  	if (IniFile) {
			for (int i=0; i<7; i++) {
    		YarnBrightness[i] = IniFile->ReadFloat("YarnBrightness", AnsiString(i), -0.03+i*0.01);
	    }
      unit = IniFile->ReadInteger("MainImage", "Unit", 0);
      if (unit == 0) MainImageForm->UnitChange(uCm);
      else MainImageForm->UnitChange(uInch);
  	  delete IniFile;
	  }
  }
  delete Form;
  if (MainImageForm) MainImageForm->ApplyEnvironment();  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FExitItemClick(TObject *Sender)
{
	ExitMenuItem();
	MainMenuForm->ExitForm();
	Close();  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ECopyItemClick(TObject *Sender)
{
	MainImageForm->EditCopy();  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::YYarnMakerItemClick(TObject *Sender)
{
  MainMenuForm->YarnMakerStart = 1;                                               //lhskys Ǹ  ˸
	ExitMenuItem();
	MainMenuForm->ExitForm();
	InitMenuItem(W_YARN_MAKE);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::YYarnScanItemClick(TObject *Sender)
{
	ExitMenuItem();
	MainMenuForm->ExitForm();
	InitMenuItem(W_YARN_SCAN);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::TextureItemClick(TObject *Sender)
{
	ExitMenuItem();
	MainMenuForm->ExitForm();
	InitMenuItem(W_TEXTURE);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::PYarnItemClick(TObject *Sender)
{
	MainMenuForm->sbYarnClick(NULL);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::PTextureItemClick(TObject *Sender)
{
	MainMenuForm->sbTextureClick(NULL);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::PWeavingItemClick(TObject *Sender)
{
	MainMenuForm->sbWeavingClick(NULL);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::VFullViewItemClick(TObject *Sender)
{
	if (VFullViewItem->Checked) {
		VFullViewItem->Checked = false;
  	FullViewForm->Visible = false;
  } else {
		VFullViewItem->Checked = true;
  	FullViewForm->Visible = true;;
  	FullViewForm->InitForm(MainImageForm->iMainImage);
  }
  UpdateMenuItems(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::VPaletteItemClick(TObject *Sender)
{
	if (VPaletteItem->Checked) {
		VPaletteItem->Checked = false;
  	PaletteForm->Visible = false;
  } else {
		VPaletteItem->Checked = true;
  	PaletteForm->Visible = true;
  	PaletteForm->InitForm(MainImageForm->Palette);
  }
  UpdateMenuItems(Sender);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::VMainMenuItemClick(TObject *Sender)
{
 	MainMenuForm->ExitForm();
	if (VMainMenuItem->Checked) {
		VMainMenuItem->Checked = false;
  	MainMenuForm->Visible = false;
  } else {
		VMainMenuItem->Checked = true;
  	MainMenuForm->Visible = true;
  }
  UpdateMenuItems(Sender);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::VStatusBarItemClick(TObject *Sender)
{
	if (VStatusBarItem->Checked) {
		VStatusBarItem->Checked = false;
  	StatusBar->Visible = false;
  } else {
		VStatusBarItem->Checked = true;
  	StatusBar->Visible = true;
  }
  UpdateMenuItems(Sender);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::VToolsRearrangeItemClick(TObject *Sender)
{
	ToolsRearrange();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::WCascadeItemClick(TObject *Sender)
{
	int i;
	//---- Must be done backwards through the MDIChildren array ----   added by k3dogs(20001114)
	for (i=0; MDIChildCount-1 >= i; i++)
    if (MDIChildren[i]->WindowState == wsMinimized)
  		MDIChildren[i]->WindowState = wsNormal;

	Cascade();  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::WTileItemClick(TObject *Sender)
{
	int i;
	//---- Must be done backwards through the MDIChildren array ----
	for (i=0; MDIChildCount-1 >= i; i++)
    if (MDIChildren[i]->WindowState == wsMinimized)
  		MDIChildren[i]->WindowState = wsNormal;

	Tile();  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::WArrangeItemClick(TObject *Sender)
{
	ArrangeIcons();  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::WMinimizeItemClick(TObject *Sender)
{
	int i;

	//---- Must be done backwards through the MDIChildren array ----
	for (i=MDIChildCount-1; i >= 0; i--)
		MDIChildren[i]->WindowState = wsMinimized;  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::HAboutItemClick(TObject *Sender)
{
  AboutBox->ShowModal();  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::Timer200msTimer(TObject *Sender)
{
	if (MainImageForm) MainImageForm->Timer200ms();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::Timer1000msTimer(TObject *Sender)
{
	TDateTime Date1;
  Date1 = Now();
  String S;
  DateTimeToString(S,"yyyy-mm-dd ampm hh-nn-ss",Date1.CurrentDateTime());
	StatusBar->Panels->Items[StatusBarDate]->Text = S;
//  StatusBar->Panels->Items[StatusBarDate]->Text = DateTimeToStr(Now());
	if (MainImageForm) MainImageForm->Timer1000ms();
#ifndef LOCK_CRYPKEY
#ifndef LOCK_IFC
 if (ProtectCard->isHacking) Application->Terminate();
#endif
#endif
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::UpdateTools(TObject *Sender)
{
	MainImageForm = (TMainImageForm *)ActiveMDIChild;
  if (MainImageForm) {
 		::RepaintColor();
	} else {
    PaletteForm->InitForm(NULL);
  }
}

//---------------------------------------------------------------------
void __fastcall TMainForm::UpdateMenuItems(TObject *Sender)
{
	if (bFirst==0) return;
  UpdateTools(Sender);
	FCloseItem->Enabled = MDIChildCount > 0;
//	FCloseAllItem->Enabled = MDIChildCount > 0;
	FEnlargeCanvasItem->Enabled = MDIChildCount > 0;
 	FPrintingItem->Enabled = MDIChildCount > 0;
	EditItem->Enabled = MDIChildCount > 0;
 	YarnItem->Enabled = MDIChildCount > 0;
  TextureItem->Enabled = MDIChildCount > 0;
	PatternDesignItem->Enabled = MDIChildCount > 0;
	PWeavingItem->Enabled = false;
 	if (MainImageForm && MainImageForm->Plan) {
 		PWeavingItem->Enabled = MainImageForm->Plan->Finish;
  }
 	ViewItem->Enabled = MDIChildCount > 0;
  VFullViewItem->Checked = FullViewForm->Visible;
 	VPaletteItem->Checked = PaletteForm->Visible;
  VMainMenuItem->Checked = MainMenuForm->Visible;
 	VStatusBarItem->Checked = StatusBar->Visible;
	WCascadeItem->Enabled = MDIChildCount > 0;
	WTileItem->Enabled = MDIChildCount > 0;
	WArrangeItem->Enabled = MDIChildCount > 0;
	WMinimizeItem->Enabled = MDIChildCount > 0;
  Timer200ms->Enabled = MDIChildCount > 0;
  Timer1000ms->Enabled = MDIChildCount > 0;
  FullViewForm->Enabled = MDIChildCount > 0;
  PaletteForm->Enabled = MDIChildCount > 0;
  MainMenuForm->Enabled = MDIChildCount > 0;
}
//---------------------------------------------------------------------
// Private Function
//---------------------------------------------------------------------
void TMainForm::WTPacket(TMessage &msg)
{
  WTPKT Result = Tablet->WTMPacket(msg);
}
//--------------------------------------------------------------------------
void TMainForm::TPMExitFunction(TMessage &msg)
{
	ExitMenuItem();
}
//---------------------------------------------------------------------
void __fastcall TMainForm::ApplicationActivate(TObject *Sender)
{
  TMainImageForm *mif = (TMainImageForm *)ActiveMDIChild;

  if (Tablet) Tablet->Activate();
	if (mif) mif->FormActivate(mif);
}
//---------------------------------------------------------------------
void __fastcall TMainForm::ShowHint(TObject *Sender)
{
	Application->HintPause = 100;
  StatusBar->Panels->Items[StatusBarHint]->Text = Application->Hint;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ToolsRearrange()
{
	FullViewFormPos = Point(ClientWidth-FullViewForm->Width-2, 2);
	PaletteFormPos = Point(ClientWidth-PaletteForm->Width-2, FullViewFormPos.y+FullViewForm->Height+1);
	MainMenuFormPos = Point(ClientWidth-MainMenuForm->Width-2, PaletteFormPos.y+PaletteForm->Height+1);
	FullViewForm->Left = FullViewFormPos.x;
	FullViewForm->Top = FullViewFormPos.y;
	PaletteForm->Left = PaletteFormPos.x;
	PaletteForm->Top = PaletteFormPos.y;
	MainMenuForm->Left = MainMenuFormPos.x;
	MainMenuForm->Top = MainMenuFormPos.y;
}
//---------------------------------------------------------------------
TPException __fastcall TMainForm::FMOnRead(TFMReadParameter rp)
{
  TCursor cur;
  TMainImageForm *Child = NULL;
  TPException ec = EC_NONE;

	MainMenuForm->ExitForm();
  cur = Screen->Cursor;
 	Screen->Cursor = crHourGlass;
  if ((Child = new TMainImageForm(Application))==NULL) { ec = EC_FORM_NOT_CREATE; goto fail; }
 	if ((ec = Child->InitFormFile(rp.DirName, rp.FileName))!=EC_NONE) goto fail;
  Screen->Cursor = cur;
  return EC_NONE;
fail:
	if (Child) delete Child;
  Screen->Cursor = cur;
	return ec;
}
//---------------------------------------------------------------------
AnsiString __fastcall TMainForm::FMOnFileName(AnsiString FileName,
	TGraphicFileFormat ExtIndex)
{
  char *s;

  s = AnsiStrScan(FileName.c_str(), '.');
  if (s==NULL) {
    if (ExtIndex == gffWEA) {
      return FileName+".wea";
    } else {
      return FileName+".wav";
    }
  } else {
    return FileName;
  }
}
//---------------------------------------------------------------------
TPException __fastcall TMainForm::FMOnSave(AnsiString DirName, AnsiString FileName,
	TGraphicFileFormat ExtIndex, TCompressMethod cm)
{
#ifndef LOCK_CRYPKEY
#ifndef LOCK_IFC
  ProtectCard->Check();
#endif
#endif
 	return MainImageForm->SaveToFile(DirName, FileName, cm);
}
//---------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////for  
void __fastcall TMainForm::FMColorItem()
{
  TFileManagerForm *Form = NULL;

  #ifndef LOCK_CRYPKEY
#ifdef LOCK_IFC
	if (ProtectCard->CheckPassword()) {
#else
    ProtectCard->Read();
#endif
#endif
  	if ((Form = new TFileManagerForm(this)) == NULL) goto fail;
    Form->Extension = MainImageForm->iMainImage->Bitmap->BitsPerPixel;
    if (MainImageForm->Plan) {
      if (MainImageForm->Plan->Finish) {
        Form->SpeedButtonSave->Enabled = true;
        Form->SpeedButtonSaveAs->Enabled = true;
        Form->OnSave = FMColorOnSave;
      } else {
        Form->SpeedButtonSave->Enabled = false;
        Form->SpeedButtonSaveAs->Enabled = false;
      }
    } else {
      Form->SpeedButtonSave->Enabled = false;
      Form->SpeedButtonSaveAs->Enabled = false;
    }
    Form->CompressCheckBox->Checked = (CompressMethod == cmNone) ? false: true;
    Form->Extension = 0;
    Form->FilterComboBox->Filter = "Texpro Weave Color File (*.wec)|*.wec";
    Form->OnRead = FMColorOnRead;
    Form->OnFileName = FMColorOnFileName;
    Form->ShowModal();
    delete Form;
#ifndef LOCK_CRYPKEY
#ifdef LOCK_IFC
  } else {
    EXCEPTION_MESSAGE_OK(EC_INTERFACE_NONE);
	  Application->Terminate();
  }
#endif
#endif
  return;
fail:
  EXCEPTION_MESSAGE_OK(EC_FORM_NOT_CREATE);
}
//----------------------------------------------------------------------------
TPException __fastcall TMainForm::FMColorOnRead(TFMReadParameter rp)
{
  TEXPIAFILEHEADER tpfh;
  HANDLE hFile = INVALID_HANDLE_VALUE;
  TCursor cur;
  TMainImageForm *Child = NULL;
  TPException ec = EC_NONE;
  TTexpiaBitmap *bitmap;
  TPalette *palette;
	MainMenuForm->ExitForm();
  cur = Screen->Cursor;
 	Screen->Cursor = crHourGlass;
  if ((Child = new TMainImageForm(Application))==NULL) { ec = EC_FORM_NOT_CREATE; goto fail; }
  if ((hFile = CreateFile(rp.FileName.c_str(), GENERIC_READ, 0, NULL, OPEN_EXISTING,
      FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) {
    ec = EC_FILE_NOT_OPEN; goto fail;
  }
  Child->InitFormColorFile(hFile);
  ColorChangeForm = new TColorChangeForm(this);
  ColorChangeForm->Parent = this;
  for (int i = 0; i < 4; i++) {
     ColorChangeForm->palette[i]->LoadFromFileHandle((int)hFile, 1);
  }
  CloseHandle(hFile);
  MainMenuForm->InitForColorChangeForm();
  Screen->Cursor = cur;
  return EC_NONE;
fail:
	if (Child) delete Child;
  Screen->Cursor = cur;
	return ec;
}
//---------------------------------------------------------------------------
TPException __fastcall TMainForm::FMColorOnSave(AnsiString dn, AnsiString fn,
	TGraphicFileFormat ExtIndex, TCompressMethod cm)
{
  HANDLE hFile = INVALID_HANDLE_VALUE;
  int ec = EC_NONE;
  int ww, hh;
	TEXPIAFILEHEADER tpfh;
  TCanvas *cv = NULL;
  HDC dcSrc = NULL;
  RGBQUAD rgb[256];
  TTexpiaBitmap *tag = NULL;

  if ((hFile = CreateFile((FullPathName(dn, fn)).c_str(), GENERIC_WRITE, 0, NULL, OPEN_ALWAYS,
      FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) {
    ec = EC_FILE_NOT_CREATE; goto fail;
  }
	tpfh.Version = TexVersion('P', 'T', 240);  //2001.5.11 230ּ 240 ٲ..7.3Version
  tpfh.CanvasInfor = MainImageForm->CanvasInfor;
  tpfh.BitsPerPixel = MainImageForm->iMainImage->Bitmap->BitsPerPixel;
  tpfh.Compress = cm;

	if ((tag = new TTexpiaBitmap)==NULL) { ec = EC_MEMORY_LACK; goto fail; }
  if (!tag->Create(80, 100, 24)) { ec = EC_MEMORY_LACK; goto fail; }
  if ((cv = tag->CreateCanvas()) == NULL) { ec = EC_RESOURCE_LACK; goto fail; }
  cv->Brush->Color = clWhite;
  cv->FillRect(Rect(0, 0, 80, 100));
  ww =  ColorChangeForm->Image0->Bitmap->Width;
  hh =  ColorChangeForm->Image0->Bitmap->Height;
  if ((dcSrc = ColorChangeForm->Image0->Bitmap->CreateDC()) == NULL) { ec = EC_RESOURCE_LACK; goto fail; }
 	SetStretchBltMode(cv->Handle, COLORONCOLOR);
	StretchBlt(cv->Handle, 0, 0, 38, 48, dcSrc, 0, 0, ww, hh, SRCCOPY);
  ColorChangeForm->Image0->Bitmap->DeleteDC(dcSrc); dcSrc = NULL;
  if ((dcSrc = ColorChangeForm->Image1->Bitmap->CreateDC()) == NULL) { ec = EC_RESOURCE_LACK; goto fail; }
 	SetStretchBltMode(cv->Handle, COLORONCOLOR);
	StretchBlt(cv->Handle, 42, 0, 38, 48, dcSrc, 0, 0, ww, hh, SRCCOPY);
  ColorChangeForm->Image1->Bitmap->DeleteDC(dcSrc); dcSrc = NULL;
  if ((dcSrc = ColorChangeForm->Image2->Bitmap->CreateDC()) == NULL) { ec = EC_RESOURCE_LACK; goto fail; }
 	SetStretchBltMode(cv->Handle, COLORONCOLOR);
	StretchBlt(cv->Handle, 0, 52, 38, 48, dcSrc, 0, 0, ww, hh, SRCCOPY);
  ColorChangeForm->Image2->Bitmap->DeleteDC(dcSrc); dcSrc = NULL;
  if ((dcSrc = ColorChangeForm->Image3->Bitmap->CreateDC()) == NULL) { ec = EC_RESOURCE_LACK; goto fail; }
 	SetStretchBltMode(cv->Handle, COLORONCOLOR);
	StretchBlt(cv->Handle, 42, 52, 38, 48, dcSrc, 0, 0, ww, hh, SRCCOPY);
  ColorChangeForm->Image3->Bitmap->DeleteDC(dcSrc); dcSrc = NULL;
  tag->DeleteCanvas(cv); cv = NULL;

  if (!SaveToTexpiaFile(hFile, ColorChangeForm->palette[0], tpfh, tag, MainImageForm->iMainImage->Bitmap)) goto fail;
	delete tag; tag = NULL;
  if ((ec = MainImageForm->Plan->SaveToFile(hFile, tpfh.Compress)) != EC_NONE) goto fail;
  for (int i = 0; i < 4; i++) {
     ColorChangeForm->palette[i]->SaveToFileHandle((int)hFile);
  }
  CloseHandle(hFile);
  MainImageForm->DirName = dn;
  MainImageForm->FileName = fn;
//  SetCaption();
  return EC_NONE;
fail:
 	if (tag) delete tag;
	if (hFile != INVALID_HANDLE_VALUE) CloseHandle(hFile);
  if (ec == EC_NONE) ec = EC_FILE_NOT_WRITE;
  return ec;
}
//----------------------------------------------------------------------------
AnsiString __fastcall TMainForm::FMColorOnFileName(AnsiString FileName,
	TGraphicFileFormat ExtIndex)
{
  PChar s = AnsiStrScan(FileName.c_str(), '.');
  if (s==NULL) {
  	AnsiString fn = FileName+".wec";
    return fn;
  } else {
    return FileName;
  }
}
//---------------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void __fastcall TMainForm::OpenFile(AnsiString DirName, AnsiString FileName,
	int Index, WORD bpp)
{
  TCursor cur;
  TMainImageForm *Child = NULL;
  TPException ec = EC_NONE;

#ifndef LOCK_CRYPKEY
#ifndef LOCK_IFC
  ProtectCard->Read();
#endif
#endif
	MainMenuForm->ExitForm();
 	cur = Screen->Cursor;
	Screen->Cursor = crHourGlass;
 	if ((Child = new TMainImageForm(Application))==NULL) { ec = EC_FORM_NOT_CREATE; goto fail; }
 	if ((ec = Child->InitFormFile(DirName, FileName))!=EC_NONE) goto fail;
 	Screen->Cursor = cur;
  return;
fail:
	if (Child) delete Child;
 	Screen->Cursor = cur;
  EXCEPTION_MESSAGE_OK(ec);
}
//---------------------------------------------------------------------
void __fastcall TMainForm::InitMenuItem(TWeaveMenuItem wmi)
{
  WeaveMenuItem = wmi;
	switch (WeaveMenuItem) {
    case W_YARN_MAKE:
		  YarnTableForm = new TYarnTableForm(this);
  		YarnTableForm->Parent = this;
	  	YarnTableForm->Visible = false;
      YarnTableForm->InitForm(false);
      YarnDesignForm = new TYarnDesignForm(this);
      YarnDesignForm->Parent = this;
      YarnDesignForm->Visible = true;
      YarnDesignForm->MakeButton->SetFocus();                        //lhskys ͷ ϱ!
    	break;
    case W_YARN_SCAN:
		  YarnTableForm = new TYarnTableForm(this);
  		YarnTableForm->Parent = this;
	  	YarnTableForm->Visible = false;
      YarnScanForm = new TYarnScanForm(this);
      YarnScanForm->Parent = this;
      YarnScanForm->Visible = true;
    	break;
    case W_TEXTURE:
		  TextureForm = new TTextureForm(this);
  		TextureForm->Parent = this;
	  	TextureForm->Visible = false;
  		TextureForm->InitForm();
      TextureDesignForm = new TTextureDesignForm(this);
      TextureDesignForm->Parent = this;
      TextureDesignForm->Visible = true;
    	break;
  }
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::changeDueDay()
{
  unsigned char blk[8], newk[8] = {'^', '*', 'F', 'S', '0', '>', '?', '['},
                k[8] = {'^', '*', 'F', 'S', '0', '>', '?', '['};
  int nowJul, pastJul, due, sumDay;
	TRegIniFile *RegIniFile;
  AnsiString pw, str;
  int timePass[4];

 	RegIniFile = new TRegIniFile(RegFilename);
  if (RegIniFile) {
    pw = RegIniFile->ReadString("Common", "Product No.", "");
    if (pw == "") return;
    sscanf(pw.c_str(), "%d-%d-%d-%d", &timePass[0], &timePass[1], &timePass[2], &timePass[3]);
  	delete RegIniFile;
  } else return;
  blk[0] = timePass[0] & 0xFF;
  blk[1] = (timePass[0] >> 8) & 0xFF;
  blk[2] = timePass[1] & 0xFF;
  blk[3] = (timePass[1] >> 8) & 0xFF;
  blk[4] = timePass[2] & 0xFF;
  blk[5] = (timePass[2] >> 8) & 0xFF;
  blk[6] = timePass[3] & 0xFF;
  blk[7] = (timePass[3] >> 8) & 0xFF;
  decrypt(k, blk);
  sumDay = blk[0];
  sumDay |= blk[1] << 8;
  sumDay |= blk[2] << 16;
  sumDay |= blk[3] << 24;

  pastJul = sumDay;
  sumDay = blk[4];
  sumDay |= blk[5] << 8;
  sumDay |= blk[6] << 16;
  sumDay |= blk[7] << 24;
  due = sumDay;
  nowJul = toJulian();
//=======================================================
  blk[0] = nowJul & 0xFF;
  blk[1] = (nowJul >> 8) & 0xFF;
  blk[2] = (nowJul >> 16) & 0xFF;
  blk[3] = (nowJul >> 24) & 0xFF;

  due = (pastJul+due) - nowJul;
  blk[4] = due & 0xFF;
  blk[5] = (due >> 8) & 0xFF;
  blk[6] = (due >> 16) & 0xFF;
  blk[7] = (due >> 24) & 0xFF;
  encrypt(newk, blk);
  str = Format("%d-%d-%d-%d", OPENARRAY(TVarRec, ((blk[1]<<8)|blk[0], (blk[3]<<8)|blk[2],
                   (blk[5]<<8)|blk[4], (blk[7]<<8)|blk[6])));

 	RegIniFile = new TRegIniFile(RegFilename);
  if (RegIniFile) {
    RegIniFile->WriteString("Common", "Product No.", str);
    delete RegIniFile;
  }
//=======================================================
}
//---------------------------------------------------------------------
// Public Function
//---------------------------------------------------------------------------

void __fastcall TMainForm::ExitMenuItem()
{
	switch (WeaveMenuItem) {
    case W_YARN_MAKE:
      ::doDestroy(YarnDesignForm);
    	::doDestroy(YarnTableForm);
    	break;
    case W_YARN_SCAN:
      ::doDestroy(YarnScanForm);
    	::doDestroy(YarnTableForm);
      break;
    case W_TEXTURE:
      ::doDestroy(TextureDesignForm);
    	::doDestroy(TextureForm);
    	break;
  }
	WeaveMenuItem = W_NONE;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FormKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
  if((Key == 65) || (Key == 97))
    MainImageForm->FormKeyDown(this, Key, Shift);
  if((Key == 83) || (Key == 115))
    MainImageForm->FormKeyDown(this, Key, Shift);
  if(TextureDesignForm) TextureDesignForm->FormKeyDown(this, Key, Shift); //  Ű
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::educationweave(AnsiString str)
{
  AnsiString screencam, cam, camdir;
  TRegistry *Registry;
  SHELLEXECUTEINFO screeninfo;
  Registry = new TRegistry;
  if (!Registry) return;
    Registry->RootKey = HKEY_CURRENT_USER;
    Registry->OpenKey("SOFTWARE\\Youngwoo\\TexPro\\7.2\\Directory",TRUE);
    screencam = Registry->ReadString("screencam");
    delete Registry;
    memset(&screeninfo,0,sizeof(screeninfo));
    screeninfo.cbSize = sizeof(screeninfo);
    screeninfo.lpVerb = "open";
    screeninfo.lpDirectory = screencam.c_str();
    screeninfo.lpFile = "scplayer.exe";
    cam = screencam + "\\weave\\" + str;
    camdir = "\"" + cam + "\"";
    screeninfo.lpParameters = camdir.c_str();

    screeninfo.fMask = SEE_MASK_NOCLOSEPROCESS;
    screeninfo.nShow = SW_SHOWDEFAULT;
    if(!ShellExecuteEx(&screeninfo)) {
      ShowMessage("can't play screencam movie.");
      return;
    }
}

//---------------------------------------------------------------------------
void __fastcall TMainForm::Weave11Click(TObject *Sender)
{
  AnsiString filename;
  filename = "all_weave1.scm";
  educationweave(filename);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::Weave21Click(TObject *Sender)
{
  AnsiString filename;
  filename = "all_weave2.scm";
  educationweave(filename);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::I1Click(TObject *Sender)
{
  AnsiString filename;
  filename = "yarn_making1.scm";
  educationweave(filename);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::II1Click(TObject *Sender)
{
  AnsiString filename;
  filename = "yarn_making2.scm";
  educationweave(filename);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::III1Click(TObject *Sender)
{
  AnsiString filename;
  filename = "yarn_making3.scm";
  educationweave(filename);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::N7Click(TObject *Sender)
{
  AnsiString filename;
  filename = "yarn_scan.scm";
  educationweave(filename);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::N9Click(TObject *Sender)
{
  AnsiString filename;
  filename = "setting.scm";
  educationweave(filename);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::N10Click(TObject *Sender)
{
  AnsiString filename;
  filename = "sketch.scm";
  educationweave(filename);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::N11Click(TObject *Sender)
{
  AnsiString filename;
  filename = "selection(weave).scm";
  educationweave(filename);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::N12Click(TObject *Sender)
{
  AnsiString filename;
  filename = "preview(weave).scm";
  educationweave(filename);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::N13Click(TObject *Sender)
{
  AnsiString filename;
  filename = "rotate(weave).scm";
  educationweave(filename);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::N15Click(TObject *Sender)
{
  AnsiString filename;
  filename = "yarn_table.scm";
  educationweave(filename);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::N16Click(TObject *Sender)
{
  AnsiString filename;
  filename = "yarn_dye.scm";
  educationweave(filename);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::N17Click(TObject *Sender)
{
  AnsiString filename;
  filename = "yarn_arrange.scm";
  educationweave(filename);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::N18Click(TObject *Sender)
{
  AnsiString filename;
  filename = "texture_table.scm";
  educationweave(filename);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::N19Click(TObject *Sender)
{
  AnsiString filename;
  filename = "texture_selection.scm";
  educationweave(filename);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::N20Click(TObject *Sender)
{
  AnsiString filename;
  filename = "weaving.scm";
  educationweave(filename);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::N21Click(TObject *Sender)
{
  AnsiString filename;
  filename = "printer(weave).scm";
  educationweave(filename);  
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::N22Click(TObject *Sender)
{
  AnsiString filename;
  filename = "yarn_brightness.scm";
  educationweave(filename);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::N23Click(TObject *Sender)
{
  AnsiString filename;
  filename = "weaving_window_file(weave).scm";
  educationweave(filename);  
}
//---------------------------------------------------------------------------
