//---------------------------------------------------------------------------

#ifndef MainH
#define MainH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <Dialogs.hpp>
#include <ExtCtrls.hpp>
#include <Menus.hpp>
#include "Tablet.h"
#include "StringTable.h"
#include "MainImage.h"
//---------------------------------------------------------------------------
#define StatusBarSize 			0
#define StatusBarDPI 				1
#define StatusBarZoom 			2
#define StatusBarAxis 			3
#define StatusBarHint 			4
#define StatusBarDate 			5
//----------------------------------------------------------------------------
typedef enum { W_NONE, W_YARN_MAKE, W_YARN_SCAN, W_TEXTURE } TWeaveMenuItem;

class TMainForm : public TForm
{
__published:	// IDE-managed Components
  TStatusBar *StatusBar;
  TMainMenu *MainMenu1;
  TMenuItem *FileItem;
  TMenuItem *FNewCanvasItem;
  TMenuItem *FFileManagerItem;
  TMenuItem *FReopenItem;
  TMenuItem *FCloseItem;
  TMenuItem *N1;
  TMenuItem *FEnlargeCanvasItem;
  TMenuItem *N4;
  TMenuItem *FPrinterSetupItem;
  TMenuItem *FPrintingItem;
  TMenuItem *N2;
  TMenuItem *FFontItem;
  TMenuItem *FEnvironmentItem;
  TMenuItem *N6;
  TMenuItem *FExitItem;
  TMenuItem *EditItem;
  TMenuItem *ECopyItem;
  TMenuItem *YarnItem;
  TMenuItem *YYarnMakerItem;
  TMenuItem *YYarnScanItem;
  TMenuItem *TextureItem;
  TMenuItem *PatternDesignItem;
  TMenuItem *PYarnItem;
  TMenuItem *PTextureItem;
  TMenuItem *PWeavingItem;
  TMenuItem *ViewItem;
  TMenuItem *VFullViewItem;
  TMenuItem *VPaletteItem;
  TMenuItem *VMainMenuItem;
  TMenuItem *VStatusBarItem;
  TMenuItem *N5;
  TMenuItem *VToolsRearrangeItem;
  TMenuItem *WindowItem;
  TMenuItem *WCascadeItem;
  TMenuItem *WTileItem;
  TMenuItem *WArrangeItem;
  TMenuItem *WMinimizeItem;
  TMenuItem *HelpItem;
  TMenuItem *HAboutItem;
  TMenuItem *Education1;
  TMenuItem *Weave11;
  TMenuItem *Weave21;
  TMenuItem *N3;
  TMenuItem *I1;
  TMenuItem *II1;
  TMenuItem *III1;
  TMenuItem *N7;
  TMenuItem *N8;
  TMenuItem *N9;
  TMenuItem *N10;
  TMenuItem *N11;
  TMenuItem *N12;
  TMenuItem *N13;
  TMenuItem *N14;
  TMenuItem *N15;
  TMenuItem *N16;
  TMenuItem *N17;
  TMenuItem *N18;
  TMenuItem *N19;
  TMenuItem *N20;
  TMenuItem *N21;
  TMenuItem *N22;
  TMenuItem *N23;
  TTimer *Timer1000ms;
  TFontDialog *FontDialog1;
  TPrinterSetupDialog *PrinterSetupDialog;
  TTimer *Timer200ms;
  TSaveDialog *SaveDialog;
  void __fastcall FormActivate(TObject *Sender);
  void __fastcall FormCreate(TObject *Sender);
  void __fastcall FormDestroy(TObject *Sender);
  void __fastcall FormResize(TObject *Sender);
  void __fastcall FormShow(TObject *Sender);
  void __fastcall FNewCanvasItemClick(TObject *Sender);
  void __fastcall FFileManagerItemClick(TObject *Sender);
  void __fastcall FCloseItemClick(TObject *Sender);
  void __fastcall FEnlargeCanvasItemClick(TObject *Sender);
  void __fastcall FPrinterSetupItemClick(TObject *Sender);
  void __fastcall FPrintingItemClick(TObject *Sender);
  void __fastcall FFontItemClick(TObject *Sender);
  void __fastcall FEnvironmentItemClick(TObject *Sender);
  void __fastcall FExitItemClick(TObject *Sender);
  void __fastcall ECopyItemClick(TObject *Sender);
  void __fastcall YYarnMakerItemClick(TObject *Sender);
  void __fastcall YYarnScanItemClick(TObject *Sender);
  void __fastcall TextureItemClick(TObject *Sender);
  void __fastcall PYarnItemClick(TObject *Sender);
  void __fastcall PTextureItemClick(TObject *Sender);
  void __fastcall PWeavingItemClick(TObject *Sender);
  void __fastcall VFullViewItemClick(TObject *Sender);
  void __fastcall VPaletteItemClick(TObject *Sender);
  void __fastcall VMainMenuItemClick(TObject *Sender);
  void __fastcall VStatusBarItemClick(TObject *Sender);
  void __fastcall VToolsRearrangeItemClick(TObject *Sender);
  void __fastcall WCascadeItemClick(TObject *Sender);
  void __fastcall WTileItemClick(TObject *Sender);
  void __fastcall WArrangeItemClick(TObject *Sender);
  void __fastcall WMinimizeItemClick(TObject *Sender);
  void __fastcall HAboutItemClick(TObject *Sender);
  void __fastcall Timer200msTimer(TObject *Sender);
  void __fastcall Timer1000msTimer(TObject *Sender);
  void __fastcall FormKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
  void __fastcall Weave11Click(TObject *Sender);
  void __fastcall Weave21Click(TObject *Sender);
  void __fastcall I1Click(TObject *Sender);
  void __fastcall II1Click(TObject *Sender);
  void __fastcall III1Click(TObject *Sender);
  void __fastcall N7Click(TObject *Sender);
  void __fastcall N9Click(TObject *Sender);
  void __fastcall N10Click(TObject *Sender);
  void __fastcall N11Click(TObject *Sender);
  void __fastcall N12Click(TObject *Sender);
  void __fastcall N13Click(TObject *Sender);
  void __fastcall N15Click(TObject *Sender);
  void __fastcall N16Click(TObject *Sender);
  void __fastcall N17Click(TObject *Sender);
  void __fastcall N18Click(TObject *Sender);
  void __fastcall N19Click(TObject *Sender);
  void __fastcall N20Click(TObject *Sender);
  void __fastcall N21Click(TObject *Sender);
  void __fastcall N22Click(TObject *Sender);
  void __fastcall N23Click(TObject *Sender);
private:	// User declarations
  TStringTable StringTable;
  int bFirst;
	TWeaveMenuItem WeaveMenuItem;
  void WTPacket(TMessage &msg);
  void TPMExitFunction(TMessage &msg);
  void __fastcall ApplicationActivate(TObject *Sender);
	void __fastcall ShowHint(TObject *Sender);
	void __fastcall ToolsRearrange();
	TPException __fastcall FMOnRead(TFMReadParameter rp);
	AnsiString __fastcall FMOnFileName(AnsiString FileName, TGraphicFileFormat ExtIndex);
  TPException __fastcall FMOnSave(AnsiString DirName, AnsiString FileName,
  	TGraphicFileFormat ExtIndex, TCompressMethod cm);
  void __fastcall OpenFile(AnsiString DirName, AnsiString FileName, int Index, WORD bpp);
  TPException __fastcall FMColorOnRead(TFMReadParameter rp);
  AnsiString __fastcall FMColorOnFileName(AnsiString FileName, TGraphicFileFormat ExtIndex);
  TPException __fastcall FMColorOnSave(AnsiString DirName, AnsiString FileName,
  	TGraphicFileFormat ExtIndex, TCompressMethod cm);
  void __fastcall InitMenuItem(TWeaveMenuItem wmi);
  void __fastcall changeDueDay();
  void __fastcall educationweave(AnsiString str);
public:		// User declarations
  TPoint FullViewFormPos, PaletteFormPos, MainMenuFormPos;
  UINT ClipboardFormat;
	TCompressMethod CompressMethod;
  __fastcall TMainForm(TComponent* Owner);
    void __fastcall ExitMenuItem();
	void __fastcall UpdateTools(TObject *Sender);
  void __fastcall UpdateMenuItems(TObject *Sender);
  void __fastcall FMColorItem();
  BEGIN_MESSAGE_MAP
  	MESSAGE_HANDLER(WT_PACKET, TMessage, WTPacket);
  	MESSAGE_HANDLER(TPM_EXITFUNCTION, TMessage, TPMExitFunction);
  END_MESSAGE_MAP(TForm)
};
//---------------------------------------------------------------------------
extern PACKAGE TMainForm *MainForm;
//---------------------------------------------------------------------------
#endif
