//---------------------------------------------------------------------------
#include <vcl.h>
#include <math.h>
#include <registry.hpp>
#include <printers.hpp>
#pragma hdrstop

#include "MainImage.h"
#include "chart.h"
#include "ColorLibrary_F.h"
#include "FullView.h"
#include "History.h"
#include "Main.h"
#include "MainMenu.h"
#include "Palette.h"
#include "ProtectCard.h"
#include "UserColor_F.h"
#include "YarnDesign_F.h"                                        //lhskys YarnDesign  ͷ ϱ 
#include "Weaving_F.h"                                           //lhskys Weaqving  ͷ ϱ
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TPImage"
#pragma link "TPSelectImage"
#pragma link "TPWeaveImage"
#pragma link "TPRuler2D"
#pragma link "TPImage"
#pragma link "TPRuler2D"
#pragma link "TPSelectImage"
#pragma link "TPWeaveImage"
#pragma resource "*.dfm"
//---------------------------------------------------------------------
#define IDS_WZOOMIN     StringTable[0]
#define IDS_WZOOMOUT    StringTable[1]
#define IDS_WRULER      StringTable[2]
#define IDS_WFRONTBACK  StringTable[3]
#define IDS_MAINIMAGE_MESSAGE  StringTable[4]
#define IDS_WEIGHT      StringTable[5]
#define IDS_WAWIDTH      StringTable[6]
#define IDS_WEWIDTH      StringTable[7]
#define IDS_TOTAL      StringTable[8]
#define IDS_TOTAL1     StringTable[9]

TMainImageForm *MainImageForm;
int MainImageCount = 0;
//---------------------------------------------------------------------------
__fastcall TMainImageForm::TMainImageForm(TComponent* Owner)
  : TForm(Owner)
{
  Number = MainImageCount;
	MainImageCount++;
  LineList = new TList;
//================================ //2001.4.11. by lhskys congi unit ֱ
  TIniFile *IniFile = new TIniFile(DirectoryItem+"\\Environment.ini");
  int UNITS;
      if (WUnits == "uCm")UNITS = 0;
      else if (WUnits == "uInch")UNITS = 1;
  IniFile->WriteInteger("MainImage", "Unit", UNITS);
//=================================
}
//---------------------------------------------------------------------------

void __fastcall TMainImageForm::FormActivate(TObject *Sender)
{
  if (MainImageForm!=this) {
    MainMenuForm->ExitForm();
    MainImageForm = this;
  }
  PaletteForm->UpdateForm(16);
  WorkAreaChange();
 	ReviewStatusBar();
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::FormClose(TObject *Sender,
      TCloseAction &Action)
{
  MainImageForm = NULL;
	Action = caFree;
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::FormCloseQuery(TObject *Sender,
      bool &CanClose)
{
  AnsiString msg, fn, ext;
  char *s;

 	ext = ".wea";
  if (Plan->Weaving) {
    msg = Format("Save changes to %s!", OPENARRAY (TVarRec,(FileName)));
    int Btn = MessageDlg(msg, mtWarning, TMsgDlgButtons()<<mbYes<<mbNo<<mbCancel, 0);
    if (Btn == mrYes) {
      if (FileName == Format("Noname%d%s", OPENARRAY(TVarRec, (Number+1, ext)))) {
        if (MainForm->SaveDialog->Execute()) {
          s = AnsiStrScan(MainForm->SaveDialog->FileName.c_str(), '.');
          if (s==NULL) fn = MainForm->SaveDialog->FileName+ext;
          else fn = MainForm->SaveDialog->FileName;
          DirName = ExtractFileDir(fn);
          FileName = ExtractFileName(fn);
          SaveToFile(DirName, FileName, MainForm->CompressMethod);
          CanClose = true;
        }
      } else {
        SaveToFile(DirName, FileName, MainForm->CompressMethod);
        CanClose = true;
      }
    } else if (Btn == mrNo) {
      CanClose = true;
    } else {
      CanClose = false;
    }
  } else {
	  CanClose = true;
  }
  if (CanClose) {
    if (FileExists(FileName)) {
 			FileHistory->InsertHistory(DirName, ExtractFileName(FileName), 1,
      		iMainImage->Bitmap->BitsPerPixel);
    }
  }
	MainMenuForm->ExitForm();  
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::FormCreate(TObject *Sender)
{
#ifndef LOCK_CRYPKEY
#ifndef LOCK_IFC
  ProtectCard->Check();
#endif
#endif
  int unit;

  TIniFile *IniFile = new TIniFile(DirectoryItem+"\\Environment.ini");
  if (IniFile) {
    unit = IniFile->ReadInteger("MainImage", "Unit", 0);
    delete IniFile;
  }
//=================================================
  StringTable.Create(DirectoryItem, Language, "MainImage");
  SetSmallFont(Font);
  SetSmallFont(TempLabel->Font);
  SetSmallFont(sbUnit->Font);
  sbZoomIn->Hint       = IDS_WZOOMIN;
  sbZoomOut->Hint      = IDS_WZOOMOUT;
  sbGrid->Hint         = IDS_COMMON_GRID;
  sbRuler->Hint        = IDS_WRULER;
  sbFrontBack->Hint    = IDS_WFRONTBACK;
//=================================================
  if ((WorkArea = new TPWorkArea(&(iMainImage->Bitmap)))==NULL) goto fail;
 	if ((Palette = new TPalette)==NULL) goto fail;
  if ((Plan = new TPlan)==NULL) goto fail;
	MainImageForm = this;
	CanvasInfor.DotsPerInch = 160;
	CanvasInfor.SetExtFileOption();
  if (unit == 0) {
    UnitChange(uCm);
    sbUnit->Caption = AnsiString(IDS_COMMON_UNIT) + " : Cm";
  } else {
    UnitChange(uInch);
    sbUnit->Caption = AnsiString(IDS_COMMON_UNIT) + " : Inch";
  }
  ApplyEnvironment();
  ZoomChange(1, 1);
  PaletteForm->InitForm(Palette);
  ReviewStatusBar();
  bChoiceExchange = false;
	return;
fail:
	::doDestroy(Plan);
	::doDestroy(Palette);
  ::doDestroy(WorkArea);  
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::FormDestroy(TObject *Sender)
{
 	MainMenuForm->ExitForm();
	::doDestroy(Plan);
	::doDestroy(Palette);
  ::doDestroy(WorkArea);
  FullViewForm->InitForm(NULL);
  delete LineList;
	MainImageForm = NULL;  
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::FormResize(TObject *Sender)
{
  Ruler->Width = ClientWidth-ImageWeft->Width-PanelVert->Width-8;
 	Ruler->Height = ClientHeight-ImageWarp->Height-PanelHorz->Height-8;
	if (sbRuler->Down) {
	  Panel->Left = Ruler->Thick;
	  Panel->Width = Ruler->Width-Ruler->Thick;
 		Panel->Height = Ruler->Height-Ruler->Thick;
    ImageWarp->Left = Ruler->Thick;
  } else {
	  Panel->Left = 0;
	  Panel->Width = Ruler->Width;
 		Panel->Height = Ruler->Height;
    ImageWarp->Left = 0;
  }
  ImageWarp->Width = Panel->Width;
  ImageWeft->Left = Ruler->Width+4;
  ImageWeft->Height = Panel->Height;
	PanelHorz->Top = Ruler->Top+Ruler->Height+4;
	PanelHorz->Width = ClientWidth-PanelVert->Width;
	PanelVert->Left = ImageWeft->Left+ImageWeft->Width+4;
	PanelVert->Height = ClientHeight-PanelHorz->Height;
	sbHorz->Width = PanelHorz->Width-sbHorz->Left-2;
	sbVert->Height = PanelVert->Height-sbVert->Top-2;
  iMainImage->SetPosition();
  ImageWarp->SetPosition();
  ImageWeft->SetPosition();
  FullViewForm->SetSize();  
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::iMainImageMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
	if (Active) {
   	DownState = true;
    if (Shift.Contains(ssCtrl) && Button==mbLeft) {
			MouseState = 1;
      iMainImage->Cursor = crHandPoint;
      ptFirst = Point(X, iMainImage->Bitmap->Height-1-Y);
    } else {
   		if (MainMenuForm->iMainImageMouseDown(this, Button, Shift, X, Y)) {
	  	  PaletteForm->iMainImageMouseDown(Sender, Button, Shift, X, Y);
 		  	if (Button==mbLeft) {
 	  	  	FullViewForm->iMainImageMouseDown(Sender, X, Y);
   	  	}
      }
 	  }
	}  
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::iMainImageMouseMove(TObject *Sender,
      TShiftState Shift, int X, int Y)
{
	POINT pt;
  COLORREF color;

	if (Active) {
    if (X > 0 && X <= iMainImage->Bitmap->Width && Y > 0 && Y <= iMainImage->Bitmap->Height) {
   	  CursorPosition.x = X;
 	 	  CursorPosition.y = iMainImage->Bitmap->Height-1-Y;
      if (MouseState) {
 	   	  ptSecond = Point(X, iMainImage->Bitmap->Height-1-Y);
			  pt.x = ptSecond.x-ptFirst.x;
			  pt.y = ptSecond.y-ptFirst.y;
			  iMainImage->SetPosition(iMainImage->PositionX-pt.x, iMainImage->PositionY-pt.y);
        ptFirst.x = ptSecond.x-pt.x;
 	      ptFirst.y = ptSecond.y-pt.y;
 	    } else {
 	  	  if (DownState==false) {
          if (bChoiceExchange == false) {
            WORD yarn = Plan->GetYarn(X, CursorPosition.y, sbFrontBack->Down);
		        if (yarn>0) {
					    if (Plan->Yarn->Choice[(yarn>>11)&7].Color[(yarn>>8)&7]) {
                if (((yarn>>3)&0x1F) < Plan->Yarn->Choice[(yarn>>11)&7].Data->Colors) {
                  PaletteForm->DIB256Palette->CursorIndex
          	          = Plan->Yarn->Choice[(yarn>>11)&7].Color[(yarn>>8)&7][(yarn>>3)&0x1F]->Index;
                }
              }
		        } else {
					    PaletteForm->DIB256Palette->CursorIndex = 1;
            }
          }
        }
			  if (MainMenuForm->iMainImageMouseMove(this, Shift, X, Y)) {
       	  FullViewForm->iMainImageMouseMove(Sender, X, Y);
     	    PaletteForm->iMainImageMouseMove(Sender, Shift, X, Y);
        }
   	  }
    }
  } else iMainImage->Cursor = crDefault;

  if (iMainImage->Cross) {
    iMainImage->SetCrossPos(Point(X, Y));
    static int oldx;
    static int oldy;
    RECT rc1,rc2;
    rc1.left = oldx ;
    rc1.right = oldx + 1;
    rc1.top = iMainImage->Parent->Top-30;
    rc1.bottom = iMainImage->Parent->Top + iMainImage->Parent->Height;
    rc2.left = iMainImage->Parent->Left-30;
    rc2.right = iMainImage->Parent->Left + iMainImage->Parent->Width;
    rc2.top = oldy ;
    rc2.bottom = oldy + 1;

    InvalidateRect(iMainImage->Parent->Handle, &rc1, false);
    InvalidateRect(iMainImage->Parent->Handle, &rc2, false);

    iMainImage->SetCrossPos(Point(X, Y));
    iMainImage->Cursor = crNone;

    rc1.left = iMainImage->BitmapToCanvasX(X) ;
    rc1.right = iMainImage->BitmapToCanvasX(X) + 1;
    rc1.top = iMainImage->Parent->Top-30;
    rc1.bottom = iMainImage->Parent->Top + iMainImage->Parent->Height;
    rc2.left = iMainImage->Parent->Left-30;
    rc2.right = iMainImage->Parent->Left + iMainImage->Parent->Width;
    rc2.top = iMainImage->BitmapToCanvasY(Y) ;
    rc2.bottom = iMainImage->BitmapToCanvasY(Y) + 1;

    InvalidateRect(iMainImage->Parent->Handle, &rc1, false);
    InvalidateRect(iMainImage->Parent->Handle, &rc2, false);

    oldx = iMainImage->BitmapToCanvasX(X);
    oldy = iMainImage->BitmapToCanvasY(Y);
  } else iMainImage->Cursor = crCross;  
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::iMainImageMouseUp(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
	if (Active) {
    if (MouseState) {
     	ptSecond = Point(X, iMainImage->Bitmap->Height-1-Y);
			iMainImage->SetPosition(iMainImage->PositionX-(ptSecond.x-ptFirst.x),
				iMainImage->PositionY-(ptSecond.y-ptFirst.y));
      MouseState = 0;
    } else {
			MainMenuForm->iMainImageMouseUp(this, Button, Shift, X, Y);
		  FullViewForm->View();
 		 	DownState = false;
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::iMainImagePaint(TObject *Sender)
{
	if (MainMenuForm->iMainImagePaint(this)) {
	 	PaletteForm->iMainImagePaint();
  }  
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::iMainImagePositionChange(TObject *Sender)
{
	UpdateImage();
  Ruler->StartX = iMainImage->PositionX;
  Ruler->StartY = iMainImage->PositionY;
  sbHorz->Position = iMainImage->PositionX;
  sbVert->Position = sbVert->Max-iMainImage->PositionY;
  FullViewForm->SetPositionX(iMainImage->PositionX);
  FullViewForm->SetPositionY(iMainImage->PositionY);
	ImageWarp->PositionX = iMainImage->PositionX;
  ImageWeft->PositionY = iMainImage->PositionY;  
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::sbUnitClick(TObject *Sender)
{
	if (CurrentUnit==uCm) UnitChange(uInch);
  else if (CurrentUnit==uInch) UnitChange(uCm);  
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::sbHorzScroll(TObject *Sender,
      TScrollCode ScrollCode, int &ScrollPos)
{
  iMainImageChange();
	iMainImage->PositionX = sbHorz->Position;  
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::sbZoomInClick(TObject *Sender)
{
	switch (iMainImage->ZoomIn) {
  	case 1:
			switch (iMainImage->ZoomOut) {
      	case 1:	ZoomChange(2, 1); break;
		  	case 2: ZoomChange(1, 1); break;
  			case 4: ZoomChange(1, 2); break;
		  	case 8:	ZoomChange(1, 4); break;
  			case 16: ZoomChange(1, 8); break;
      }
      break;
  	case 2: ZoomChange(4, 1); break;
  	case 4: ZoomChange(8, 1); break;
  	case 8: ZoomChange(16, 1); break;
  }  
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::sbZoomOutClick(TObject *Sender)
{
	switch (iMainImage->ZoomIn) {
  	case 1:
			switch (iMainImage->ZoomOut) {
      	case 1:	ZoomChange(1, 2); break;
		  	case 2: ZoomChange(1, 4); break;
  			case 4:	ZoomChange(1, 8); break;
		  	case 8: ZoomChange(1, 16); break;
      }
      break;
  	case 2: ZoomChange(1, 1); break;
  	case 4:	ZoomChange(2, 1); break;
  	case 8: ZoomChange(4, 1); break;
  	case 16: ZoomChange(8, 1); break;
  }  
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::sbGridClick(TObject *Sender)
{
	iMainImageChange();
 	iMainImage->Grid = sbGrid->Down;  
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::sbRulerClick(TObject *Sender)
{
  iMainImageChange();
  FormResize(this);  
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::sbFrontBackClick(TObject *Sender)
{
  bool dweft = false;
  if (MainImageForm->bChoiceExchange) { //Ƿ  ٲٰ weaving  
    if (Plan->Finish) {
       	Plan->calc_weave(iMainImage->Bitmap, Palette->ColorData[1]->RGB);
        MainImageForm->bChoiceExchange = false;
        dweft = true;
    } else return;                     // ޽ ? ?
  }
	if (sbFrontBack->Down) {
  	Plan->DrawBack(iMainImage->Bitmap);
  } else {
  	Plan->DrawFront(iMainImage->Bitmap);
  }
  DrawWarpBar();
  if (dweft) {
    DrawWeftBar();
    ::RepaintImage();
  } else {
    iMainImage->Repaint();
  }  
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::sbVertScroll(TObject *Sender,
      TScrollCode ScrollCode, int &ScrollPos)
{
  iMainImageChange();
	iMainImage->PositionY = sbVert->Max-sbVert->Position;  
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::PopupMenu1Popup(TObject *Sender)
{
  GetCursorPos(&ptScreen);  
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::ZoomClick(TObject *Sender)
{
	if (Sender==Zoom1161) ZoomChange(1, 16, &ptScreen);
  else if (Sender==Zoom181) ZoomChange(1, 8, &ptScreen);
  else if (Sender==Zoom141) ZoomChange(1, 4, &ptScreen);
  else if (Sender==Zoom121) ZoomChange(1, 2, &ptScreen);
  else if (Sender==Zoom11) ZoomChange(1, 1, &ptScreen);
  else if (Sender==Zoom21) ZoomChange(2, 1, &ptScreen);
  else if (Sender==Zoom41) ZoomChange(4, 1, &ptScreen);
  else if (Sender==Zoom81) ZoomChange(8, 1, &ptScreen);
  else if (Sender==Zoom161) ZoomChange(16, 1, &ptScreen);
}
//---------------------------------------------------------------------------
// Private Function
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::SetCaption()
{
  AnsiString fn = ExtractFileName(FileName);
  Caption = (DirName.Length()>0 ? DirName+"\\"+ fn: fn);
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::UnitChange(TUnit unit)
{
  CurrentUnit = unit;
  Ruler->AUnit = CurrentUnit;
 	if (CurrentUnit==uInch) sbUnit->Caption = AnsiString(IDS_COMMON_UNIT) + " : Inch";
  else if (CurrentUnit==uCm) sbUnit->Caption = AnsiString(IDS_COMMON_UNIT) + " : Cm";
	FullViewForm->UnitChange();
	MainMenuForm->UnitChange();
  ReviewStatusBar();
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::ReviewStatusBar()
{
 	MainForm->StatusBar->Panels->Items[StatusBarSize]->Text = "Size : " +
    CanvasInfor.Name(CurrentUnit, iMainImage->Bitmap->Width, iMainImage->Bitmap->Height);
  MainForm->StatusBar->Panels->Items[StatusBarDPI]->Text =
   	Format("DPI : %d", OPENARRAY(TVarRec, (CanvasInfor.DotsPerInch)));
}
//---------------------------------------------------------------------------
TPException __fastcall TMainImageForm::LoadFromFile(AnsiString FileName,
	TTexpiaBitmap *pBitmap, TPalette *pPalette, TPCanvasInfor &ci)
{
	TEXPIAFILEHEADER tpfh;
	HANDLE hFile = INVALID_HANDLE_VALUE;
  TPException ec = EC_NONE;

  if ((hFile = CreateFile(FileName.c_str(), GENERIC_READ, 0, NULL, OPEN_EXISTING,
      FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) {
    ec = EC_FILE_NOT_OPEN; goto fail;
  }
	if ((ec = LoadFromTexpiaFile(hFile, pPalette, tpfh, pBitmap)) != EC_NONE) goto fail;
  if ((ec = Plan->LoadFromFile(hFile, tpfh)) != EC_NONE) goto fail;
  UserColorLibForm->ThisFileHasUserColor(pPalette);
  ci = tpfh.CanvasInfor;
  CloseHandle(hFile);
  return EC_NONE;
fail:
	if (hFile != INVALID_HANDLE_VALUE) CloseHandle(hFile);
  if (ec == EC_NONE) ec = EC_FILE_NOT_READ;
	return ec;
}
//---------------------------------------------------------------------------
//Print Private Method//
//----------------------------------------------------------------------------
int __fastcall TMainImageForm::GetYarnHeight()
{
  int i, j, H, totalH = 0;
  int LH[6] = {0, 0, 0, 0, 0, 0};
	int warpcnt, weftcnt, colorcnt, cnt = 0;
  bool IsWeft;
  TYarnArray *ya;

	warpcnt = Plan->Yarn->Array[0]->Count;
  weftcnt = Plan->Yarn->Array[1]->Count;
  for (i = 1; i <= 32; i++) {
    IsWeft = true;
  	for (j = 0; j < warpcnt; j++) {
    	ya = (TYarnArray *) Plan->Yarn->Array[0]->Items[j];
      if (i == ya->code) {
        colorcnt = Plan->Yarn->Choice[((i-1)/8)].Data->Colors;
        H = (colorcnt / 2 + colorcnt % 2) * 70 + 70;
        if (H > LH[cnt % 6]) LH[cnt % 6] += H;
        cnt++;
      	IsWeft = false;
        break;
      }
    }
    if (IsWeft) {
	  	for (j = 0; j < weftcnt; j++) {
	    	ya = (TYarnArray *) Plan->Yarn->Array[1]->Items[j];
      	if (i == ya->code) {
        	colorcnt = Plan->Yarn->Choice[((i-1)/8)].Data->Colors;
        	H = (colorcnt / 2 + colorcnt % 2) * 70 + 70;
        	if (H > LH[cnt % 6]) LH[cnt % 6] += H;
        	cnt++;
        	break;
      	}
    	}
    }
  }
//  for (i = 0; i < 6; i++) totalH += LH[i];
	totalH = LH[0];
	for(i = 1 ; i < 6;i++){
  	if(LH[i] > totalH) totalH = LH[i];
  }
  return totalH;
}
//---------------------------------------------------------------------------

bool __fastcall TMainImageForm::GetTextureHeight(int w, int &h)
{
  int i, k, sy, lx, ly, wid, hei;
  int ds[4] = {16, 8, 4, 2};
  if (Plan->Texture->InitTexture() == false) return false;
  h = 0;
  for (i = 0; i < Plan->Texture->ChoiceCount; i++) {
	  wid = Plan->Texture->Choice[i].width;
	  hei = Plan->Texture->Choice[i].height;
    for (k = 0; k < 4; k++) {
   		lx = ChartSx*2 + (wid+Plan->Texture->tm[i].cnt)*ds[k] + 12;
   		ly = ChartSy*2 + (hei+Plan->Texture->tm[i].cnt)*ds[k] + 42;
    	if (lx < w - 22) break;
    }
    h += ly;
  }
  Plan->Texture->ExitTexture();
  return true;
}
//---------------------------------------------------------------------------

bool __fastcall TMainImageForm::DrawOutLine(TTexpiaBitmap *Pattern, int H, int PatternDPI)
{
	int w, h, x;
  AnsiString str, company = "", date, time;
  TCanvas *Canvas = NULL;
  TRegIniFile *Reg = NULL;

  Reg = new TRegIniFile("");
  if (Reg) {
 		Reg->RootKey = HKEY_LOCAL_MACHINE;
  	if (Reg->OpenKey("\\SOFTWARE\\MicroSoft\\Windows", false))
			company = Reg->ReadString("CurrentVersion", "RegisteredOrganization", "");
  	delete Reg;
  }

  if ((Canvas = Pattern->CreateCanvas()) == NULL) return false;
  w = A4Width-1;
  h = A4Height-1;
  Canvas->Font->Size = 15*PatternDPI/160;
  Canvas->Font->Color = clPurple;
  Canvas->Pen->Width = 1*PatternDPI/160;
  Canvas->MoveTo(0, H);
  Canvas->LineTo(w, H);
  Canvas->LineTo(w, H+30*PatternDPI/160);
  Canvas->LineTo(0, H+30*PatternDPI/160);
  Canvas->LineTo(0, H);
  str = "PATTERN NAME : " + FileName;
  Canvas->TextOut(30*PatternDPI/160, H+5*PatternDPI/160, str);
  switch (Plan->WeaveCondition.HairEffect) {
  	case 1:  str = "HAIR EFFECT  :  FICTION (SHORT)";   break;
  	case 2:  str = "HAIR EFFECT  :  FICTION (NORMAL)";  break;
  	case 3:  str = "HAIR EFFECT  :  FICTION (LONG)";    break;
  	case 4:  str = "HAIR EFFECT  :  ACTUAL";            break;
  	default: str = "HAIR EFFECT  :  NONE";              break;
  }
  x = (w - Canvas->TextWidth(str)) / 2;
  Canvas->TextOut(x, H+5, str);

  date = DateToStr(Date()); time = TimeToStr(Time());
  str = Format("%s   %s", OPENARRAY(TVarRec, (date.c_str(), time.c_str())));
  x = w - Canvas->TextWidth(str) - 20*PatternDPI/160;
  Canvas->TextOut(x, H+5*PatternDPI/160, str);
  Canvas->Font->Size = 12*PatternDPI/160;
  Canvas->Font->Color = clBlack;
  Canvas->MoveTo(0, H+35*PatternDPI/160);
  Canvas->LineTo(w, H+35*PatternDPI/160);
  Canvas->LineTo(w, H+h-22*PatternDPI/160);
  Canvas->LineTo(0, H+h-22*PatternDPI/160);
  Canvas->LineTo(0, H+35*PatternDPI/160);

  x = Canvas->TextWidth(company);
  Canvas->TextOut(w-x-80*PatternDPI/160, H+h-19*PatternDPI/160, company);
  Pattern->DeleteCanvas(Canvas);
  return true;
}
//---------------------------------------------------------------------------
bool __fastcall TMainImageForm::ProductDrawOutLine(TTexpiaBitmap *Pattern, int H)
{
	int w, h, x;
  AnsiString str, company = "", date, time;
  TCanvas *Canvas = NULL;
  TRegIniFile *Reg = NULL;

  Reg = new TRegIniFile("");
  if (Reg) {
 		Reg->RootKey = HKEY_LOCAL_MACHINE;
  	if (Reg->OpenKey("\\SOFTWARE\\MicroSoft\\Windows", false))
			company = Reg->ReadString("CurrentVersion", "RegisteredOrganization", "");
  	delete Reg;
  }

  if ((Canvas = Pattern->CreateCanvas()) == NULL) return false;
  w = A4Width-1;
  h = A4Height-1;
  Canvas->Font->Size = 15;
  Canvas->Font->Color = clPurple;
  Canvas->Pen->Width = 1;
  Canvas->MoveTo(0, H);
  Canvas->LineTo(w, H);
  Canvas->LineTo(w, H+30);
  Canvas->LineTo(0, H+30);
  Canvas->LineTo(0, H);
  str = "PATTERN NAME : " + FileName;
  Canvas->TextOut(30, H+5, str);

  date = DateToStr(Date()); time = TimeToStr(Time());
  str = Format("%s   %s", OPENARRAY(TVarRec, (date.c_str(), time.c_str())));
  x = w - Canvas->TextWidth(str) - 20;
  Canvas->TextOut(x, H+5, str);
  Canvas->Font->Size = 12;
  Canvas->Font->Color = clBlack;
  Canvas->MoveTo(0, H+35);
  Canvas->LineTo(w, H+35);
  Canvas->LineTo(w, H+h-122);
  Canvas->LineTo(0, H+h-122);
  Canvas->LineTo(0, H+35);

  x = Canvas->TextWidth(company);
  Canvas->TextOut(w-x-80, H+h-119, company);
  Pattern->DeleteCanvas(Canvas);
  return true;
}
//---------------------------------------------------------------------------

bool __fastcall TMainImageForm::YarnDraw(TTexpiaBitmap *Pattern, int x, int &y,
	bool product, int h)
{
  TYarnData *yd;
  TYarnInfor *yi;
  int Hei, i, Index;
  AnsiString str, c, unit;
  TCanvas *Canvas = NULL;
  if ((Canvas = Pattern->CreateCanvas()) == NULL) return false;
  for (i = 0; i < 8; i++) {
  	if (Plan->Yarn->Choice[i].Data) {
    	if (FindData(i)) {
        switch (i) {
        	case 0: str = "Code: 1~8> ";   break;
        	case 1: str = "Code: 9~16> ";  break;
        	case 2: str = "Code: 17~24> "; break;
        	case 3: str = "Code: 25~32> "; break;
          case 4: str = "Code: 33~40> "; break;
          case 5: str = "Code: 41~48> "; break;
          case 6: str = "Code: 49~56> "; break;
          case 7: str = "Code: 57~64> "; break;
        }
      	yd = Plan->Yarn->Choice[i].Data;
        unit = yd->Unit.Name();
      	yi = &yd->Infor;
        if (yi->Detail.SZ) c = "Z"; else c = "S";
        str = Format("%s %4d %s,  %2d twist yarn,  %s twist,  %.2f TPI.", OPENARRAY(
        	TVarRec, (str.c_str(), yi->Detail.Count, unit.c_str(), yi->Detail.TYC, c.c_str(), yi->Detail.TPI)));
        Canvas->Font->Color = clBlue;
        Canvas->TextOut(x, y, str);

        y += 20;
      }
    }
  }
  Pattern->DeleteCanvas(Canvas);
  x = 5;
  Hei = 0;
  Index = 1;
  for (i = 0; i < 8; i++) {
  	if (Plan->Yarn->Choice[i].Data) {
    	if (FindData(i)) {
        if (product) h = ((y / h) + 1 ) * h;
        if (YarnSubDraw(Pattern, i, x, y, Index, Hei, product, h) == false)
          return false;
      }
    }
  }
  if (x != 5)	y = y + Hei + 10;
  return true;
}
//---------------------------------------------------------------------------
bool __fastcall TMainImageForm::YarnSubDraw(TTexpiaBitmap *Pattern, int i,
	int &xxx, int &yyy, int &Ind, int &Hi, bool product, int h)
{
  TYarnArray *ya;
  int colors, wid, chipw, chiph;
  int k, m, n, p, warpcnt, weftcnt;
  int a, b, x;
  bool IsWeft;
  TPoint sp;
  TSize sz;
  RECT Dst, Src, trect, brect;
  AnsiString str;
  TColorData *cd;
  TTexpiaBitmap *YarnBit = NULL;
	//Graphics::TBitmap *YarnBit = NULL;
  TCanvas *Canvas = NULL, *YarnCanvas = NULL;


 // YarnBit = new Graphics::TBitmap;
 	YarnBit = new TTexpiaBitmap;
  if (YarnBit == NULL) return false;


//  YarnBit->PixelFormat = pf15bit;
  wid = (Pattern->Width / 6) - 10;
//  YarnBit->Width = wid;
 	chipw = wid / 2;
  colors = Plan->Yarn->Choice[i].Data->Colors;
//  YarnBit->Height = 150 + ((colors-1) / 2) * 70;

  if (!YarnBit->Create(wid,150 + ((colors-1) / 2) * 70, 16)) goto fail;


  if (xxx == 5) Hi = YarnBit->Height;
  else {
  	if (Hi < YarnBit->Height) Hi = YarnBit->Height;
  }
  warpcnt = Plan->Yarn->Array[0]->Count;
  weftcnt = Plan->Yarn->Array[1]->Count;

  sp.x = 0; sp.y = 20 + (50 - Plan->Yarn->Choice[i].Data->Width) / 2;
  sz.cx = YarnBit->Width;
  sz.cy = 50;

  Src = Rect(0, 0, YarnBit->Width, YarnBit->Height);
 	Dst = Rect(xxx, yyy, xxx+YarnBit->Width, yyy+YarnBit->Height);

  if (product) {
    if (yyy+YarnBit->Height > h) {
    	yyy = h + 45;
		 	Dst = Rect(xxx, yyy, xxx+YarnBit->Width, yyy+YarnBit->Height);
      h  = h + A4Height;
    }
  }

  n = i*8;
  if ((Canvas = Pattern->CreateCanvas()) == NULL) return false;
  if ((YarnCanvas = YarnBit->CreateCanvas()) == NULL) return false;

	Canvas->CopyMode = cmSrcCopy;
  for (k = 1; k <= 8; k++) {
    IsWeft = true;
    YarnCanvas->Brush->Color = clWhite;
    YarnCanvas->FillRect(Src);
  	for (m = 0; m < warpcnt; m++) {
    	ya = (TYarnArray *) Plan->Yarn->Array[0]->Items[m];
      if ((n+k) == ya->code) {
			  YarnCanvas->Font->Size = 12;
      	if (IsThereWarp(n+k)) str = "Code: " + IntToStr(n+k) + ": WARP / WEFT";
        else str = "Code: " + IntToStr(n+k) + ": WARP";
        Ind++;
        YarnCanvas->TextOut(10, 4, str);
        Plan->Yarn->Choice[i].Data->Draw(YarnCanvas, sp, sz,
        	Plan->Yarn->Choice[i].Color[k-1]);
			  YarnCanvas->Font->Size = 8;
        for (p = 0; p < colors; p++) {
          a = p / 2;  b = p % 2;
        	brect = Rect(2+b*chipw, 70+a*70,  (2+chipw-5)+b*chipw,  120+a*70);
        	trect = Rect(2+b*chipw, 120+a*70, (2+chipw-5)+b*chipw, 140+a*70);
          cd = Plan->Yarn->Choice[i].Color[k-1][p]->GetColor(0);
          PrintColorChip15(YarnBit, brect, cd->RGB.rgbRed, cd->RGB.rgbGreen, cd->RGB.rgbBlue);
          YarnCanvas->Brush->Color = clWhite;
					str = GetColorName(cd);
          x = ((chipw-5) - YarnCanvas->TextWidth(str)) / 2;
          YarnCanvas->TextRect(trect, trect.left+x, trect.top+4,  str);
        }
        Canvas->CopyRect(Dst, YarnCanvas, Src);
        xxx = Dst.right + 10;
        yyy = Dst.top;
        if (xxx+YarnBit->Width > Pattern->Width-1) {
        	xxx = 5; yyy = Dst.top + Hi + 10;
          Hi = YarnBit->Height;
        }
        Dst = Rect(xxx, yyy, xxx + YarnBit->Width, yyy + YarnBit->Height);

			  if (product) {
    			if (yyy+YarnBit->Height > h) {
    				yyy = h + 45;
		 				Dst = Rect(xxx, yyy, xxx+YarnBit->Width, yyy+YarnBit->Height);
      			h  = h + A4Height;
          }
        }

        IsWeft = false;
        break;
      }
//      YarnBit->DeleteCanvas(YarnCanvas);
    }
    if (IsWeft) {
    	for (m = 0; m < weftcnt; m++) {
	    	ya = (TYarnArray *) Plan->Yarn->Array[1]->Items[m];
	      if ((n+k) == ya->code) {
			  	YarnCanvas->Font->Size = 12;
        	str = "Code: " + IntToStr(n+k) + ": WEFT";
          Ind++;
        	YarnCanvas->TextOut(10, 4, str);
        	Plan->Yarn->Choice[i].Data->Draw(YarnCanvas, sp, sz,
        		Plan->Yarn->Choice[i].Color[k-1]);
			  	YarnCanvas->Font->Size = 8;
        	for (p = 0; p < colors; p++) {
          	a = p / 2;  b = p % 2;
        		brect = Rect(2+b*chipw, 70+a*70,  (2+chipw-5)+b*chipw,  120+a*70);
        		trect = Rect(2+b*chipw, 120+a*70, (2+chipw-5)+b*chipw, 140+a*70);
          	cd = Plan->Yarn->Choice[i].Color[k-1][p]->GetColor(0);
	          PrintColorChip15(YarnBit, brect, cd->RGB.rgbRed, cd->RGB.rgbGreen, cd->RGB.rgbBlue);
          	YarnCanvas->Brush->Color = clWhite;
   					str = GetColorName(cd);
          	x = ((chipw-5) - YarnCanvas->TextWidth(str)) / 2;
          	YarnCanvas->TextRect(trect, trect.left+x, trect.top+4,  str);
        	}
        	Canvas->CopyRect(Dst, YarnCanvas, Src);
        	xxx = Dst.right + 10;
        	yyy = Dst.top;
        	if (xxx+YarnBit->Width > Pattern->Width-1) {
        		xxx = 5; yyy = Dst.top + Hi + 10;
	          Hi = YarnBit->Height;
        	}
        	Dst = Rect(xxx, yyy, xxx + YarnBit->Width, yyy + YarnBit->Height);
				  if (product) {
  	  			if (yyy+YarnBit->Height > h) {
    					yyy = h + 45;
		 					Dst = Rect(xxx, yyy, xxx+YarnBit->Width, yyy+YarnBit->Height);
      				h  = h + A4Height;
            }
        	}
        	break;
        }
      }
    }
  }
  Pattern->DeleteCanvas(Canvas);
  YarnBit->DeleteCanvas(YarnCanvas);
  delete YarnBit;
  return true;
fail:
	if(YarnBit) delete YarnBit;
  return false;
}
//---------------------------------------------------------------------------
bool __fastcall TMainImageForm::FindData(int i)
{
	TYarnArray *ya;
	for (int m = 0; m < 2; m++) {
  	for (int n = 0; n < Plan->Yarn->Array[m]->Count; n++) {
    	ya = (TYarnArray *) Plan->Yarn->Array[m]->Items[n];
      if (i == ((ya->code - 1) /8)) return true;
    }
  }
	return false;
}
//---------------------------------------------------------------------------
bool __fastcall TMainImageForm::IsThereWarp(int i)
{
	TYarnArray *ya;
  int cnt = Plan->Yarn->Array[1]->Count;
	for (int k = 0; k < cnt; k++) {
  	ya = (TYarnArray *) Plan->Yarn->Array[1]->Items[k];
    if (ya->code == i) return true;
  }
  return false;
}
//---------------------------------------------------------------------------
int __fastcall TMainImageForm::TableDrawA(TTexpiaBitmap *Pattern, int H, double Length[2],
                 int Yarns[2], AnsiString arWidth, AnsiString weDensity, AnsiString totWarpCnt)
{
  int tsx, tsy, tex, tey, tw, x;
  int CellWidth, TableWidth, CellCnt, ArrayCellCnt;
  int i, j, k;
  int a, b;
  AnsiString str;
  TCanvas *Canvas = NULL;
  SimpleProductInfo *pi;
  TYarnArray *pd;


  tw = Pattern->Width  - 1;
  tsx = 10;  tex = tw - 10;
  TableWidth = (tex - tsx -10)/2;
  Canvas = Pattern->CreateCanvas();
  Canvas->Font->Size  = 12;
  a = Plan->SimpleProductArray[0]->Count > 6 ? Plan->SimpleProductArray[0]->Count + 2 : 8;
  b = Plan->SimpleProductArray[1]->Count > 6 ? Plan->SimpleProductArray[1]->Count +2 : 8;
  CellCnt = Max(a, b);
  ArrayCellCnt = Max(Plan->Yarn->PData[0]->Count+2, Plan->Yarn->PData[1]->Count+2);
  for (j = 0; j < 2; j++){
     Canvas->Font->Color = clBlue;
     if (j == 0) {
        str = "<<WARP>>";
        Canvas->TextOut(tsx + 20, H, str);
     } else {
        str = "<<WEFT>>";
        tsx = tsx + TableWidth + 10;
        Canvas->TextOut(tsx + 20, H, str);

     }
     tsy = H+30;
     CellWidth = TableWidth/5;
     for (i = 0; i <= 5; i++){                      //
        if (i == 5) tex = tsx + TableWidth;
        else tex = tsx + i*CellWidth;
        Canvas->MoveTo(tex, tsy);
        Canvas->LineTo(tex, tsy+30*CellCnt);
     }
     tey = tsy;
     for (i = 0; i <= CellCnt; i++){                 //
        Canvas->MoveTo(tsx, tey);
        Canvas->LineTo(tsx+TableWidth, tey);
        tey += 30;
     }
     for (i = 1; i < CellCnt-1; i++) {       //A, B, C, D, E,.. Է
        tey = tsy + i *30;
        str = AnsiString(char(64+i));
        x = (CellWidth - Canvas->TextWidth(str))/2;
        Canvas->TextOut(tsx+x, tey+10, str);
     }
     str = "Code";
     x = (CellWidth - Canvas->TextWidth(str))/2;
     Canvas->TextOut(tsx+CellWidth+x, tsy+5, str);
     str = "Length";
     x = (CellWidth - Canvas->TextWidth(str))/2;
     Canvas->TextOut(tsx+2*CellWidth+x, tsy+5, str);
     str = "Yarns";
     x = (CellWidth - Canvas->TextWidth(str))/2;
     Canvas->TextOut(tsx+3*CellWidth+x, tsy+5, str);
     str = "Weight";
     x = (CellWidth - Canvas->TextWidth(str))/2;
     Canvas->TextOut(tsx+4*CellWidth+x, tsy+5, str);

     Canvas->Font->Color = clBlack;
     for (i = 0; i < Plan->SimpleProductArray[j]->Count; i++){
        tey = tsy + (i+1)*30;
        pi = (SimpleProductInfo *)Plan->SimpleProductArray[j]->Items[i];
        str = IntToStr(pi->Code);
        x = (CellWidth - Canvas->TextWidth(str))/2;
        Canvas->TextOut(tsx+CellWidth+x, tey+5, str);
        str = Format("%.2f", OPENARRAY(TVarRec, (pi->Length)));
        x = (CellWidth - Canvas->TextWidth(str))/2;
        Canvas->TextOut(tsx+2*CellWidth+x, tey+5, str);
        str = IntToStr(pi->Yarns);
        x = (CellWidth - Canvas->TextWidth(str))/2;
        Canvas->TextOut(tsx+3*CellWidth+x, tey+5, str);
        str = Format("%.4f", OPENARRAY(TVarRec, (pi->Weight)));
        x = (CellWidth - Canvas->TextWidth(str))/2;
        Canvas->TextOut(tsx+4*CellWidth+x, tey+5, str);
     }

     tey = tsy+30*(CellCnt-1);
     if (j == 0){
        Canvas->Font->Color = clBlue;
        Canvas->Font->Size = 10;
        str = "Acting Reed Width";
        x = (CellWidth - Canvas->TextWidth(str))/2;
        Canvas->TextOut(tsx+x, tey+5, str);
        x = (CellWidth - Canvas->TextWidth(arWidth))/2;
        Canvas->Font->Color = clBlack;
        Canvas->Font->Size = 12;
        Canvas->TextOut(tsx+CellWidth+x, tey+5, arWidth);
        Canvas->Font->Color = clBlue;
        Canvas->Font->Size = 10;
        str = "Total Warp Count";
        x = (CellWidth - Canvas->TextWidth(str))/2;
        Canvas->TextOut(tsx+2*CellWidth+x, tey+5, str);
        x = (CellWidth - Canvas->TextWidth(totWarpCnt))/2;
        Canvas->Font->Color = clBlack;
        Canvas->Font->Size = 12;
        Canvas->TextOut(tsx+3*CellWidth+x, tey+5, totWarpCnt);
     } else {
        Canvas->Font->Color = clBlue;
        Canvas->Font->Size = 10;
        str = "Weft Density";
        x = (CellWidth - Canvas->TextWidth(str))/2;
        Canvas->TextOut(tsx+x, tey+5, str);
        x = (CellWidth - Canvas->TextWidth(weDensity))/2;
        Canvas->Font->Color = clBlack;
        Canvas->Font->Size = 12;
        Canvas->TextOut(tsx+CellWidth+x, tey+5, weDensity);
     }

     tsy = tey+60;;
     CellWidth = TableWidth/7;
     for (i = 0; i <= 7; i++){
        if (i == 7) tex = tsx +TableWidth;         //Ȯ ̸ ߾ֱ 
        else tex = tsx + i*CellWidth;
        Canvas->MoveTo(tex, tsy);
        Canvas->LineTo(tex, tsy+30*ArrayCellCnt);
     }
     tey = tsy;
     for (i = 0; i <= ArrayCellCnt; i++){
        Canvas->MoveTo(tsx, tey);
        Canvas->LineTo(tsx+TableWidth, tey);
        tey += 30;
     }
     Canvas->Font->Color = clBlue;
     Canvas->Font->Size = 12;
     str = "No";
     x = (CellWidth - Canvas->TextWidth(str))/2;
     Canvas->TextOut(tsx+x, tsy+5, str);
     str = "Code";
     x = (CellWidth - Canvas->TextWidth(str))/2;
     Canvas->TextOut(tsx+CellWidth+x, tsy+5, str);
     str = "Method";
     x = (CellWidth - Canvas->TextWidth(str))/2;
     Canvas->TextOut(tsx+2*CellWidth+x, tsy+5, str);
     str = "Length";
     x = (CellWidth - Canvas->TextWidth(str))/2;
     Canvas->TextOut(tsx+3*CellWidth+x, tsy+5, str);
     str = "Yarns";
     x = (CellWidth - Canvas->TextWidth(str))/2;
     Canvas->TextOut(tsx+4*CellWidth+x, tsy+5, str);
     str = "Density";
     x = (CellWidth - Canvas->TextWidth(str))/2;
     Canvas->TextOut(tsx+5*CellWidth+x, tsy+5, str);
     str = "Repeat";
     x = (CellWidth - Canvas->TextWidth(str))/2;
     Canvas->TextOut(tsx+6*CellWidth+x, tsy+5, str);
     tey = tsy+30;
     for (i = 0; i < Plan->Yarn->PData[j]->Count; i++) {
        Canvas->Font->Color = clBlue;
        str = IntToStr(i+1);
	      x = (CellWidth - Canvas->TextWidth(str)) / 2;
  	    Canvas->TextOut(tsx+x, tey+5, str);
        Canvas->Font->Color = clBlack;
        pd = (TYarnArray *)Plan->Yarn->PData[j]->Items[i];
        str = IntToStr(pd->code);
	      x = (CellWidth - Canvas->TextWidth(str)) / 2;
  	    Canvas->TextOut(tsx+CellWidth+x, tey+5, str);
        switch (pd->method) {
    	     case 0: str = "Normal";   break;
    	     case 1: str = "Reverse";  break;
    	     case 2: str = "Center";   break;
        }
	      x = (CellWidth - Canvas->TextWidth(str)) / 2;
  	    Canvas->TextOut(tsx+2*CellWidth+x, tey+5, str);
        str = Format("%.2f", OPENARRAY(TVarRec, (pd->length)));
	      x = (CellWidth - Canvas->TextWidth(str)) / 2;
  	    Canvas->TextOut(tsx+3*CellWidth+x, tey+5, str);
        str = IntToStr(pd->yarns);
	      x = (CellWidth - Canvas->TextWidth(str)) / 2;
  	    Canvas->TextOut(tsx+4*CellWidth+x, tey+5, str);
      	str = Format("%.2f", OPENARRAY(TVarRec, (pd->density)));
	      x = (CellWidth - Canvas->TextWidth(str)) / 2;
  	    Canvas->TextOut(tsx+5*CellWidth+x, tey+5, str);
        str = IntToStr(pd->repeat);
	      x = (CellWidth - Canvas->TextWidth(str)) / 2;
  	    Canvas->TextOut(tsx+6*CellWidth+x, tey+5, str);
        tey += 30;
     }
     str = "Total";
     x = (CellWidth - Canvas->TextWidth(str))/2;
     Canvas->TextOut(tsx+x, tey+5, str);
     str = Format("%.2f", OPENARRAY(TVarRec, (Length[j])));
     x = (CellWidth - Canvas->TextWidth(str))/2;
     Canvas->TextOut(tsx+3*CellWidth+x, tey+5, str);
     str = IntToStr(Yarns[j]);
     x = (CellWidth - Canvas->TextWidth(str))/2;
     Canvas->TextOut(tsx+4*CellWidth+x, tey+5, str);
  }
  Pattern->DeleteCanvas(Canvas);
  return (H + CellCnt*30 + ArrayCellCnt*30 + 80);

}
//---------------------------------------------------------------------------

int __fastcall TMainImageForm::TableDrawB(TTexpiaBitmap *Pattern, int H)
{
  int tsx, tsy, tex, tey, tw, x, CellCnt, CellSmall, CellMedium, CellLarge;
  int i, j, k, Add;
  AnsiString str;
  TCanvas *Canvas = NULL;
  ProductInfo *pi;
  ArrayInfo ai;


  tw = Pattern->Width  - 1;
  tsx = 10;  tex = tw - 10;
  CellSmall = 40;
  CellMedium = 100;
  CellLarge = tex - tsx - 6*CellMedium - CellSmall;
  Canvas = Pattern->CreateCanvas();
  Canvas->Font->Size  = 12;
  Add = 0;
  for (j = 0; j < 2; j++){
     Canvas->Font->Color = clBlue;
//     Canvas->Font->Style->fsBold = true;
     if (j == 0) {
        str = "<<WARP>>";
        Canvas->TextOut(tsx + 20, H, str);
        tsy = H + 30;
     } else {
        str = "<<WEFT>>";
        Canvas->TextOut(tsx + 20, H+40*CellCnt+40, str);
        tsy = H + 40*CellCnt + 70;
     }
//     Canvas->Font->Style->fsBold = true;
     CellCnt = Plan->ProductArray[j]->Count > 6 ? Plan->ProductArray[j]->Count + 1 : 7;
     tex = tw - 10;
     for (i = 0; i <= CellCnt; i++) {      //Table  ׸
     	  tey = tsy + i * 40;
        Canvas->MoveTo(tsx, tey);
     	  Canvas->LineTo(tex, tey);
     }
     tex = tsx;
     for (i = 0; i <= 8; i++) {            //Table  ׸
        Canvas->MoveTo(tex , tsy);
     	  Canvas->LineTo(tex, tey);
        if (i == 0) tex += CellSmall;
        else if (i == 6) tex += CellLarge;
        else tex += CellMedium;
     }
     for (i = 1; i < CellCnt; i++) {       //A, B, C, D, E,.. Է
        tey = tsy + i *40;
        str = AnsiString(char(64+i));
        x = (CellSmall - Canvas->TextWidth(str))/2;
        Canvas->TextOut(tsx+x, tey+10, str);
     }
     str = "Code";
     x = (CellMedium - Canvas->TextWidth(str))/2;
     Canvas->TextOut(tsx+CellSmall+x, tsy+10, str);
     str = "Kind";
     x = (CellMedium - Canvas->TextWidth(str))/2;
     Canvas->TextOut(tsx+CellSmall+CellMedium+x, tsy+10, str);
     str = "Yarn No.";
     x = (CellMedium - Canvas->TextWidth(str))/2;
     Canvas->TextOut(tsx+CellSmall+2*CellMedium+x, tsy+10, str);
     str = "Count";
     x = (CellMedium - Canvas->TextWidth(str))/2;
     Canvas->TextOut(tsx+CellSmall+3*CellMedium+x, tsy+10, str);
     str = "Color";
     x = (CellMedium - Canvas->TextWidth(str))/2;
     Canvas->TextOut(tsx+CellSmall+4*CellMedium+x, tsy+10, str);
     str = "Array Order";
     x = (CellLarge - Canvas->TextWidth(str))/2;
     Canvas->TextOut(tsx+CellSmall+5*CellMedium+x, tsy+10, str);
     str = "Weight";
     x = (CellMedium - Canvas->TextWidth(str))/2;
     Canvas->TextOut(tsx+CellSmall+5*CellMedium+CellLarge+x, tsy+10, str);
     Canvas->Font->Color = clBlack;
     for (i = 0; i < Plan->ProductArray[j]->Count; i++){
        tey = tsy + (i+1)*40;
        pi = (ProductInfo *)Plan->ProductArray[j]->Items[i];
        str = IntToStr(pi->Code);
        x = (CellMedium - Canvas->TextWidth(str))/2;
        Canvas->TextOut(tsx+CellSmall+x, tey+10, str);
        str = pi->Kind;
        x = (CellMedium - Canvas->TextWidth(str))/2;
        Canvas->TextOut(tsx+CellSmall+CellMedium+x, tey+10, str);
        str = pi->YarnNo;
        x = (CellMedium - Canvas->TextWidth(str))/2;
        Canvas->TextOut(tsx+CellSmall+2*CellMedium+x, tey+10, str);
        str = IntToStr(pi->Count)+Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.Name();
        x = (CellMedium - Canvas->TextWidth(str))/2;
        Canvas->TextOut(tsx+CellSmall+3*CellMedium+x, tey+10, str);
        str = pi->Color;
        x = (CellMedium - Canvas->TextWidth(str))/2;
        Canvas->TextOut(tsx+CellSmall+4*CellMedium+x, tey+10, str);
        str = pi->Weight;
        x = (CellMedium - Canvas->TextWidth(str))/2;
        Canvas->TextOut(tsx+CellSmall+5*CellMedium+CellLarge+x, tey+10, str);
     }

     if (Plan->OrderArray[j]->Count <= 10) {
        x = 50;
        for (k = 0; k < Plan->OrderArray[j]->Count; k++) {
           str = AnsiString(((ArrayInfo *)Plan->OrderArray[j]->Items[k])->Code);
           Canvas->TextOut(tsx+CellSmall+5*CellMedium+x, tsy+40+10, str);
           str = AnsiString(((ArrayInfo *)Plan->OrderArray[j]->Items[k])->Yarns);
           Canvas->TextOut(tsx+CellSmall+5*CellMedium+x, tsy+80+10, str);
           x += 50;
        }
     } else if (Plan->OrderArray[j]->Count <= 20) {
        x = 50;
        for (k = 0; k < 10; k++) {
           str = AnsiString(((ArrayInfo *)Plan->OrderArray[j]->Items[k])->Code);
           Canvas->TextOut(tsx+CellSmall+5*CellMedium+x, tsy+40+10, str);
           str = AnsiString(((ArrayInfo *)Plan->OrderArray[j]->Items[k])->Yarns);
           Canvas->TextOut(tsx+CellSmall+5*CellMedium+x, tsy+80+10, str);
           x += 50;
        }
        x = 50;
        for(k = 10; k < Plan->OrderArray[j]->Count; k++) {
           str = AnsiString(((ArrayInfo *)Plan->OrderArray[j]->Items[k])->Code);
           Canvas->TextOut(tsx+CellSmall+5*CellMedium+x, tsy+120+10, str);
           str = AnsiString(((ArrayInfo *)Plan->OrderArray[j]->Items[k])->Yarns);
           Canvas->TextOut(tsx+CellSmall+5*CellMedium+x, tsy+160+10, str);
           x += 50;
        }
     } else {
        x = 50;
        for (k = 0; k < 10; k++) {
           str = AnsiString(((ArrayInfo *)Plan->OrderArray[j]->Items[k])->Code);
           Canvas->TextOut(tsx+CellSmall+5*CellMedium+x, tsy+40+10, str);
           str = AnsiString(((ArrayInfo *)Plan->OrderArray[j]->Items[k])->Yarns);
           Canvas->TextOut(tsx+CellSmall+5*CellMedium+x, tsy+80+10, str);
           x += 50;
        }
        x = 50;
        for(k = 10; k < 20; k++) {
           str = AnsiString(((ArrayInfo *)Plan->OrderArray[j]->Items[k])->Code);
           Canvas->TextOut(tsx+CellSmall+5*CellMedium+x, tsy+120+10, str);
           str = AnsiString(((ArrayInfo *)Plan->OrderArray[j]->Items[k])->Yarns);
           Canvas->TextOut(tsx+CellSmall+5*CellMedium+x, tsy+160+10, str);
           x += 50;
        }
        x = 50;
        for(k = 10; k < Plan->OrderArray[j]->Count; k++) {
           str = AnsiString(((ArrayInfo *)Plan->OrderArray[j]->Items[k])->Code);
           Canvas->TextOut(tsx+CellSmall+5*CellMedium+x, tsy+200+10, str);
           str = AnsiString(((ArrayInfo *)Plan->OrderArray[j]->Items[k])->Yarns);
           Canvas->TextOut(tsx+CellSmall+5*CellMedium+x, tsy+240+10, str);
           x += 50;
        }
     }
     Add += CellCnt*40;
  }
  Pattern->DeleteCanvas(Canvas);
  return (H + Add + 70);
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::AddData(TTexpiaBitmap *Pattern, int H)
{
  TCanvas *Canvas = NULL;
  int tsx, tsy, tex, tey, x, CellWidth;
  int i;
  AnsiString str;
  tsy = H+40;
  tsx = 10;
  CellWidth = 200;
  Canvas = Pattern->CreateCanvas();
  tex = tsx + 2*CellWidth;
  tey = tsy;
  for (i = 0; i <=  7; i++){           //
     Canvas->MoveTo(tsx, tey);
     Canvas->LineTo(tex, tey);
     tey += 40;
  }
  tex = tsx;
  tey = tsy+40*7;
  for (i = 0; i < 3; i++){           //
     Canvas->MoveTo(tex, tsy);
     Canvas->LineTo(tex, tey);
     tex += CellWidth;
  }
  tex = tsx+CellWidth;
  tey = tsy;
  Canvas->Font->Size  = 12;
  str = "Warping Field";
  x = (CellWidth - Canvas->TextWidth(str))/2;
  Canvas->Font->Color = clBlue;
  Canvas->TextOut(tsx+x, tey+10, str);
  str = Plan->ProductStringData.WarpingFront+" M x "+Plan->ProductStringData.WarpingBack +Plan->ProductStringData.Warping;
  x = (CellWidth - Canvas->TextWidth(str))/2;
  Canvas->Font->Color = clBlack;
  Canvas->TextOut(tex+x, tey+10, str);
  tey += 40;
  str = "Total Warp Counts";
  x = (CellWidth - Canvas->TextWidth(str))/2;
  Canvas->Font->Color = clBlue;
  Canvas->TextOut(tsx+x, tey+10, str);
  str = Plan->ProductStringData.TotalWarpCount;
  x = (CellWidth - Canvas->TextWidth(str))/2;
  Canvas->Font->Color = clBlack;
  Canvas->TextOut(tex+x, tey+10, str);
  tey += 40;
  str = "Reed";
  x = (CellWidth - Canvas->TextWidth(str))/2;
  Canvas->Font->Color = clBlue;
  Canvas->TextOut(tsx+x, tey+10, str);
  str = Plan->ProductStringData.Reed;
  x = (CellWidth - Canvas->TextWidth(str))/2;
  Canvas->Font->Color = clBlack;
  Canvas->TextOut(tex+x, tey+10, str);
  tey += 40;
  str = "Inserting No.";
  x = (CellWidth - Canvas->TextWidth(str))/2;
  Canvas->Font->Color = clBlue;
  Canvas->TextOut(tsx+x, tey+10, str);
  str = Plan->ProductStringData.InsertingNo;
  x = (CellWidth - Canvas->TextWidth(str))/2;
  Canvas->Font->Color = clBlack;
  Canvas->TextOut(tex+x, tey+10, str);
  tey += 40;
  str = "Acting Reed Width";
  x = (CellWidth - Canvas->TextWidth(str))/2;
  Canvas->Font->Color = clBlue;
  Canvas->TextOut(tsx+x, tey+10, str);
  str = Plan->ProductStringData.ActingReedWidth;
  x = (CellWidth - Canvas->TextWidth(str))/2;
  Canvas->Font->Color = clBlack;
  Canvas->TextOut(tex+x, tey+10, str);
  tey += 40;
  str = "Weft Density";
  x = (CellWidth - Canvas->TextWidth(str))/2;
  Canvas->Font->Color = clBlue;
  Canvas->TextOut(tsx+x, tey+10, str);
  str = Plan->ProductStringData.WeftDensity;
  x = (CellWidth - Canvas->TextWidth(str))/2;
  Canvas->Font->Color = clBlack;
  Canvas->TextOut(tex+x, tey+10, str);
  tey += 40;
  Canvas->Font->Color = clBlue;
  str = "Total Weight";
  x = (CellWidth - Canvas->TextWidth(str))/2;
  Canvas->TextOut(tsx+x, tey+10, str);
  str = Plan->ProductStringData.Weight;
  x = (CellWidth - Canvas->TextWidth(str))/2;
  Canvas->Font->Color = clBlack;
  Canvas->TextOut(tex+x, tey+10, str);
  Pattern->DeleteCanvas(Canvas);
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::ExtractLengthYarns(int Index, int i)//, AnsiString &length, AnsiString &yarn)
{
	TYarnArray *pd;
  int cnt = Plan->Yarn->PData[i]->Count, l;
  if (cnt) {
    double totlen = 0.0; int totyar = 0;
  	for (int m = 0; m < cnt; m++) {
    	pd = (TYarnArray *)Plan->Yarn->PData[i]->Items[m];
      if (Index == pd->code) {
//============================================================================== lhskys
            int j, k, method1;
            method1 = 0;
            int repeat1;                                                   //Center ϶ repeat ˱
            if(pd->method == 2){
//******************************************************************************
          l = pd->code-1;                                                     //
          len[l] += pd->length*pd->repeat;                                    //
          yar[l] += pd->yarns*pd->repeat;                                     //
//******************************************************************************
                repeat1 = pd->repeat;
                for (j=m-1;j>-1;j--){
                    pd = (TYarnArray *)Plan->Yarn->PData[i]->Items[j];
                    if (pd->method == 1){
//******************************************************************************
          l = pd->code-1;                                                     //
          len[l] += pd->length*(repeat1*2 - 1);                               //
          yar[l] += pd->yarns*(repeat1*2 - 1);                                //
//******************************************************************************
                        method1 = 1;                                       //reverse Ȯ ƴϸ nomal  Ͽ ϱ⶧
                    }else j = -1;
                }
                for (k=m-1;k>-1;k--){
                    pd = (TYarnArray *)Plan->Yarn->PData[i]->Items[k];
                    if (method1 == 0){
//******************************************************************************
          l = pd->code-1;                                                     //
          len[l] += pd->length*(repeat1 - 1);                                 //
          yar[l] += pd->yarns*(repeat1 - 1);                                  //
//******************************************************************************
                    }else k = -1;
                }
            }else {
//******************************************************************************
          l = pd->code-1;                                                     //
          len[l] += pd->length*pd->repeat;                                    //
          yar[l] += pd->yarns*pd->repeat;                                     //
//******************************************************************************
            }
      }
    }
//==============================================================================
//      	totlen += pd->length * pd->repeat;
//      	totyar += pd->yarns * pd->repeat;
//      }
//    }
/*    if (len[l] != 0){
        totlen = len[l];
        totyar = yar[l];
    }

    if (totlen) {
    	if (CurrentUnit == uCm)
        	//length = Format("%.2f", OPENARRAY(TVarRec, (totlen * 2.54)));
            len[l] = double(int (totlen*254.0))/100.0;
            //len[l] = Format("%.2f", OPENARRAY(TVarRec, (totlen * 2.54)));
        else
      	    //Length = Format("%.2f", OPENARRAY(TVarRec, (totlen)));
            len[l] = double(int (totlen*100.0))/100.0;
      yar[l] = totyar;
    } else {
      len[l] = 0; yar[l] = 0;
    }*/
  }
}
//----------------------------------------------------------------------------
void __fastcall TMainImageForm::ExtractLengthYarns1(int Index, int i)//, AnsiString &length, AnsiString &yarn)
{
	TYarnArray *pd;
  int cnt = Plan->Yarn->PData[i]->Count, l;
  if (cnt) {
    double totlen = 0.0; int totyar = 0;
  	for (int m = 0; m < cnt; m++) {
    	pd = (TYarnArray *)Plan->Yarn->PData[i]->Items[m];
      if (Index == pd->code) {
            int j, k, method1;
            method1 = 0;
            int repeat1;                                                   //Center ϶ repeat ˱
            if(pd->method == 2){
//****************************************************************************** lhskys
          l = pd->code-1;                                                     //
          len1[l] += pd->length*pd->repeat;                                    //
          yar1[l] += pd->yarns*pd->repeat;                                     //
//******************************************************************************
                repeat1 = pd->repeat;
                for (j=m-1;j>-1;j--){
                    pd = (TYarnArray *)Plan->Yarn->PData[i]->Items[j];
                    if (pd->method == 1){
//******************************************************************************
          l = pd->code-1;                                                     //
          len1[l] += pd->length*(repeat1*2 - 1);                               //
          yar1[l] += pd->yarns*(repeat1*2 - 1);                                //
//******************************************************************************
                        method1 = 1;                                       //reverse Ȯ ƴϸ nomal  Ͽ ϱ⶧
                    }else j = -1;
                }
                for (k=m-1;k>-1;k--){
                    pd = (TYarnArray *)Plan->Yarn->PData[i]->Items[k];
                    if (method1 == 0){
//******************************************************************************
          l = pd->code-1;                                                     //
          len1[l] += pd->length*(repeat1 - 1);                                 //
          yar1[l] += pd->yarns*(repeat1 - 1);                                  //
//******************************************************************************
                    }else k = -1;
                }
            }else {
//******************************************************************************
          l = pd->code-1;                                                     //
          len1[l] += pd->length*pd->repeat;                                    //
          yar1[l] += pd->yarns*pd->repeat;                                     //
//******************************************************************************
            }
      }
    }
  }
}
//----------------------------------------------------------------------------
void __fastcall TMainImageForm::ExtractTotal(int Index, int i, AnsiString &length,
	AnsiString &yarn)
{
  TYarnArray *pd;
  int cnt = Plan->Yarn->PData[i]->Count;
 	double totlen = 0.0; int totyar = 0;
  if (cnt) {
    if (Index >= 0) {
    	for (int m = 0; m < cnt; m++) {
    		pd = (TYarnArray *)Plan->Yarn->PData[i]->Items[m];
      	if (Index == (pd->code-1)/8) {
      		totlen += pd->length * pd->repeat;
      		totyar += pd->yarns * pd->repeat;
      	}
    	}
    } else {
    	for (int m = 0; m < cnt; m++) {
    		pd = (TYarnArray *)Plan->Yarn->PData[i]->Items[m];
//============================================================================== lhskys
            int j, k, method1;
            method1 = 0;
            int repeat1;                                                   //Center ϶ repeat ˱
            if(pd->method == 2){
                totlen += pd->length*pd->repeat; //*unit;
                totyar += pd->yarns*pd->repeat;
                repeat1 = pd->repeat;
                for (j=m-1;j>-1;j--){
                    pd = (TYarnArray *)Plan->Yarn->PData[i]->Items[j];
                    if (pd->method == 1){
                        totlen += pd->length*(repeat1*2 - 1); //*unit;
                        totyar += pd->yarns*(repeat1*2 - 1);
                        method1 = 1;                                       //reverse Ȯ ƴϸ nomal  Ͽ ϱ⶧
                    }else j = -1;
                }
                for (k=m-1;k>-1;k--){
                    pd = (TYarnArray *)Plan->Yarn->PData[i]->Items[k];
                    if (method1 == 0){
                        totlen += pd->length*(repeat1 - 1); //*unit;
                        totyar += pd->yarns*(repeat1 - 1);
                    }else k = -1;
                }
            }else {
            totlen += pd->length*pd->repeat; //*unit;
            totyar += pd->yarns*pd->repeat;
            }
//==============================================================================
//     		totlen += pd->length * pd->repeat;
//     		totyar += pd->yarns * pd->repeat;
    	}
    }
    if (totlen) {
    	if (CurrentUnit == uCm)
      	length = Format("%.2f", OPENARRAY(TVarRec, (totlen * 2.54)));
      else
      	length = Format("%.2f", OPENARRAY(TVarRec, (totlen)));
      yarn = totyar;
    } else {
    	length = ""; yarn = "";
    }
  }
}
//----------------------------------------------------------------------------
void __fastcall TMainImageForm::point(TCanvas *area, int sx, int sy, int lx, int ly,
	Byte *p, int sizex, int sizey, double g)
{
  TPChart *chart = NULL;
  chart = new TPChart(area, sx, sy, lx, ly, g, g);
  chart->outline(7);
  for (int y = 0; y < sizey; y++) {
    for (int x=0; x < sizex; x++) {
      if (*p++) chart->point(x, y, clRed);
    }
  }
	delete chart;
}
//----------------------------------------------------------------------------
bool __fastcall TMainImageForm::ProductDrawTextureA (TTexpiaBitmap *Pattern, int &H)
{
	short lx, ly, sy, g[4], tsx[2], tsy[2], tex[2], tey[2];
  short ds[4] = { 16, 8, 4, 2};
  int realds[4] = { 16, 16, 16, 16};
  int i, k, cnt, wid, hei, tempH, rest, tmCnt, nopi;
  int dstH[4]= {0, 0, 0, 0}, srcH[4]= {0, 0, 0, 0};
  int srcS[4]={H,0,0,0};
  Byte *td, *tmMap[2];
  TRect Dst, Src;
  AnsiString str;
  TCanvas *Canvas = NULL;
	Graphics::TBitmap *TexBit = NULL;
  bool btex = false;
  btex = Plan->Texture->InitTexture();
  if (btex == false) goto fail;
  sy = 0;
  dstH[0] = H;

//================================= 2001.5.16 by lhskys  Ʈ
  for(i = 0; i < Plan->Texture->ChoiceCount; i++) {
    for (k = 0; k < 4; k++) {
      wid = Plan->Texture->Choice[i].width;
      hei = Plan->Texture->Choice[i].height;
      lx = ChartSx*2 + (wid+Plan->Texture->tm[i].cnt)* ds[k]+12;
      ly = ChartSy*2 + (hei+Plan->Texture->tm[i].cnt)* ds[k]+42;
      if (lx < A4Width-22) break;
      int l;
      l = (A4Width-22 - ChartSy*2 - 42) / (hei+Plan->Texture->tm[i].cnt);
      realds[i]=l;
    }
  }

  rest = A4Height - H - 25;
  wid = Plan->Texture->Choice[0].width;
  hei = Plan->Texture->Choice[0].height;
  srcH[0] = ChartSy*2 + (hei+Plan->Texture->tm[0].cnt)*realds[0] +42;

 	if (rest < srcH[0]){
    srcS[0] = (srcS[0] + rest + 70);  // 25+ 45
  }

  for(i = 1; i < Plan->Texture->ChoiceCount; i++) {
    srcS[i] = srcS[i-1] + srcH[i-1];
    rest = A4Height - ((srcS[i]) % A4Height) - 25;
    wid = Plan->Texture->Choice[i].width;
    hei = Plan->Texture->Choice[i].height;

    srcH[i] = ChartSy*2 + (hei+Plan->Texture->tm[i].cnt)*realds[i] +42;

   	if (rest < srcH[i]){
      srcS[i] = (srcS[i] + rest + 70);  // 25+ 45
    }
  }
//==========================================

  for (cnt = 0; cnt < Plan->Texture->ChoiceCount; cnt++) {
  	if ((TexBit = new Graphics::TBitmap) == NULL ) goto fail;
    TexBit->PixelFormat = pf15bit;
    TexBit->Width =  Pattern->Width - 22;
    TexBit->Height = srcH[cnt];
    TexBit->Canvas->Pen->Color = clBlack;
    BitBlt(TexBit->Canvas->Handle,0,0,TexBit->Width,TexBit->Height,NULL,0,0,WHITENESS);

    tmCnt = Plan->Texture->tm[cnt].cnt;
    tmMap[0] = Plan->Texture->tm[cnt].map[0];
    tmMap[1] = Plan->Texture->tm[cnt].map[1];

    td = Plan->Texture->Choice[cnt].data;
    wid = Plan->Texture->Choice[cnt].width;
    hei = Plan->Texture->Choice[cnt].height;
    TexBit->Canvas->Brush->Color = clWhite;
    str = Format("Texture size : %d x %d", OPENARRAY(TVarRec, (wid, hei)));
    TexBit->Canvas->TextOut(11, 0, str);

    point(TexBit->Canvas, 11, 20, wid, hei, td, wid, hei, realds[cnt]);
    lx = ChartSx*2+(wid + tmCnt)*realds[cnt]+12;
    ly = ChartSy*2+(hei + tmCnt)*realds[cnt]+42;

    tsx[0] = 11+ChartSx+wid*realds[cnt]+10;
    tsy[0] = 20;
    point(TexBit->Canvas, tsx[0], tsy[0], tmCnt, hei, tmMap[0],
     	wid, hei, realds[cnt]);
    tsx[1] = 11;
    tsy[1] = ChartSy + hei * realds[cnt] + 31;
    point(TexBit->Canvas, tsx[1], tsy[1], wid, tmCnt, tmMap[1],
    	wid, hei, realds[cnt]);
    tsx[0] += ChartSx;
    tex[0] = tsx[0] + tmCnt * realds[cnt];
    tey[0] = tsy[0] + hei * realds[cnt];
    tsx[1] += ChartSx;
    tex[1] = tsx[1] + wid * realds[cnt];
    tey[1] = tsy[1] + tmCnt * realds[cnt];
    TexBit->Canvas->MoveTo(tex[1]+10, tsy[1]);
    TexBit->Canvas->LineTo(tex[0], tsy[1]);
    TexBit->Canvas->MoveTo(tex[0], tey[0]+ChartSy);
    TexBit->Canvas->LineTo(tex[0], tsy[1]);
    TexBit->Canvas->MoveTo(tex[1]+10, tey[1]);
    TexBit->Canvas->LineTo(tsx[0], tey[1]);
    TexBit->Canvas->MoveTo(tsx[0], tey[0]+ChartSy);
    TexBit->Canvas->LineTo(tsx[0], tey[1]);

    if ((Canvas = Pattern->CreateCanvas()) == NULL) return false;

   	Dst = Rect(10, srcS[cnt], TexBit->Width, srcS[cnt] + srcH[cnt]);
    Src = Rect(0, 0, TexBit->Width, srcH[cnt]);
    Canvas->CopyRect(Dst, TexBit->Canvas, Src);

    Pattern->DeleteCanvas(Canvas);
    delete TexBit;
	}

  Plan->Texture->ExitTexture();
  cnt = Plan->Texture->ChoiceCount;

  H = srcS[cnt-1] + srcH[cnt-1];
  return true;
fail:
  if (btex) Plan->Texture->ExitTexture();
  if (TexBit) delete TexBit;
  return false;
}
//----------------------------------------------------------------------------
bool __fastcall TMainImageForm::ProductDrawTextureB (TTexpiaBitmap *Pattern, int H)
{
  char *tp;
  short x, y, sx, syy;
  int i, j, wid, hei;
  TCanvas *Canvas = NULL;
  struct {
    short size, gap, ld, ru;
  } ht[4] = {
      { 12, 20, 2, 18 }, { 24, 10, 2, 8 }, {48 , 5, 1, 4 }, { 80, 3, 1, 2 }
  };
  Byte *td;
  AnsiString str;

  sx = 700;
  syy = H+320;

  if ((Canvas = Pattern->CreateCanvas()) == NULL) return false;

  td = Plan->Texture->Choice[8].data;
  wid = Plan->Texture->Choice[8].width;
  hei = Plan->Texture->Choice[8].height;
  str = Format("Texture size : %d x %d", OPENARRAY (TVarRec, (wid, hei)));

  Canvas->Font->Color = clBlack;
  Canvas->Font->Size = 12;
  Canvas->Pen->Color = clBlack;
  Canvas->Brush->Color = clWhite;
  Canvas->TextOut(sx, H + 50, str);

  Canvas->Rectangle(sx, syy-240, sx+240, syy);
  for (j = 0; j < 4; j++) {
    if (ht[j].size > wid && ht[j].size > hei) break;
  }
  if (j<4) {
    for (y = 1; y < ht[j].size; y++) {                         //Ķ 
      for (x = 1; x < ht[j].size; x++) {
        Canvas->Pixels[sx+x*ht[j].gap][syy-y*ht[j].gap] = clBlue;
      }
    }
    x = 0;
    while (1) {
  	  x += wid;
      if (x < ht[j].size) {
         Canvas->Pen->Color = clBlue;
      	 Canvas->MoveTo(sx+x*ht[j].gap, syy-239);
      	 Canvas->LineTo(sx+x*ht[j].gap, syy-1);
       } else break;
    }
    y = 0;
    while (1) {
    	y += hei;
      if (y < ht[j].size) {
        Canvas->Pen->Color = clBlue;
      	Canvas->MoveTo(sx+1, syy-y*ht[j].gap);
      	Canvas->LineTo(sx+239, syy-y*ht[j].gap);
      } else break;
    }
    for (y = 0; y < ht[j].size; y++) {
     	tp = td + wid * (y % hei);
     	for (x = 0; x < ht[j].size; x++) {
       	if (*(tp + x % wid)) {
          Canvas->Pen->Color = clRed;
          Canvas->Brush->Color = clRed;
         	Canvas->Rectangle(sx+x*ht[j].gap+ht[j].ld,
         	syy-y*ht[j].gap-ht[j].ru, sx+x*ht[j].gap+ht[j].ru,
       	 	syy-y*ht[j].gap-ht[j].ld);
       	}
     	}
    }
  } else {
   	for (y = 0; y < 239; y++) {
     	tp = td + wid * (y % hei);
     	for (x = 0; x < 239; x++) {
       	if (*(tp + x % wid)) {
         	Canvas->Pixels[sx+x+1][syy-y-1] = clRed;
       	}
     	}
    }
  }
  Pattern->DeleteCanvas(Canvas);
  return true;
}
//----------------------------------------------------------------------------
int __fastcall TMainImageForm::HeaderYesDrawTexture(TTexpiaBitmap *Pattern,
	int H)
{
	char *tp;
  short x, y, sx, syy;
  int i, j, wid, hei;
  TCanvas *Canvas = NULL;
  struct {
    short size, gap, ld, ru;
  } ht[4] = {
      { 10, 20, 2, 18 }, { 20, 10, 2, 8 }, { 40, 5, 1, 4 }, { 50, 4, 1, 3 }
  };
  Byte *td;
  AnsiString str;

  sx = 11;
  syy = H+220;

  if ((Canvas = Pattern->CreateCanvas()) == NULL) return false;
  for (i = 0; i < Plan->Texture->ChoiceCount; i++) {
    td = Plan->Texture->Choice[i].data;
    wid = Plan->Texture->Choice[i].width;
    hei = Plan->Texture->Choice[i].height;
    str = Format("Texture size : %d x %d", OPENARRAY (TVarRec, (wid, hei)));

    Canvas->Font->Color = clBlack;
    Canvas->Pen->Color = clBlack;
    Canvas->Brush->Color = clWhite;
    Canvas->TextOut(sx, H, str);

    Canvas->Rectangle(sx, syy-200, sx+200, syy);
    for (j = 0; j < 4; j++) {
      if (ht[j].size > wid && ht[j].size > hei) break;
    }
    if (j<4) {
      for (y = 1; y < ht[j].size; y++) {
        for (x = 1; x < ht[j].size; x++) {
          Canvas->Pixels[sx+x*ht[j].gap][syy-y*ht[j].gap] = clBlue;
        }
      }
      x = 0;
      while (1) {
    	  x += wid;
        if (x < ht[j].size) {
          Canvas->Pen->Color = clBlue;
      	  Canvas->MoveTo(sx+x*ht[j].gap, syy-199);
      	  Canvas->LineTo(sx+x*ht[j].gap, syy+1);
        } else break;
      }
    	y = 0;
    	while (1) {
    		y += hei;
      	if (y < ht[j].size) {
          Canvas->Pen->Color = clBlue;
      	  Canvas->MoveTo(sx+1, syy-y*ht[j].gap);
      	  Canvas->LineTo(sx+199, syy-y*ht[j].gap);
      	} else break;
    	}
    	for (y = 0; y < ht[j].size; y++) {
      	tp = td + wid * (y % hei);
      	for (x = 0; x < ht[j].size; x++) {
        	if (*(tp + x % wid)) {
            Canvas->Pen->Color = clRed;
            Canvas->Brush->Color = clRed;
          	Canvas->Rectangle(sx+x*ht[j].gap+ht[j].ld,
            	syy-y*ht[j].gap-ht[j].ru, sx+x*ht[j].gap+ht[j].ru,
          	 	syy-y*ht[j].gap-ht[j].ld);
        	}
      	}
    	}
  	} else {
    	for (y = 0; y < 199; y++) {
      	tp = td + wid * (y % hei);
      	for (x = 0; x < 199; x++) {
        	if (*(tp + x % wid)) {
          	Canvas->Pixels[sx+x+1][syy-y-1] = clRed;
        	}
      	}
    	}
  	}
  	sx += 211;
  }
  Pattern->DeleteCanvas(Canvas);
  return H+231;
}
//---------------------------------------------------------------------------
// Public Function
//---------------------------------------------------------------------------
TPException __fastcall TMainImageForm::InitForm(TPCanvasInfor &ci)
{
  PALETTEENTRY peEntry[256];
	RGBQUAD rgb[256];

  MainMenuForm->YarnMakerStart = 0;                               //lhskys Ǹ  ˸
  if (Palette==NULL || WorkArea==NULL || Plan==NULL) return EC_MEMORY_LACK;
	Top = 0;
	Left = 0;
//	if (Palette->LoadFromFile((DirectoryColor+"\\Textile.fcr").c_str())==false) {//qe test
  	GetSystemPaletteEntries(Canvas->Handle, 0, 256, peEntry);
		Palette->SetNormal(0, 0, 0, 0);
		Palette->SetNormal(1, 255, 255, 255);
		Palette->SetNormal(2, 0, 0, 0);
    for (int i=3; i<255; i++) {
			Palette->SetNormal(i, peEntry[i].peRed, peEntry[i].peGreen, peEntry[i].peBlue);
    }
		Palette->SetNormal(255, 255, 255, 255);
//  }
  if (!ResizePattern(ci)) return EC_MEMORY_LACK;
  COLORREF c =	PaletteForm->DIB256Palette->GetBGCOLORREF(iMainImage->Bitmap->BitsPerPixel);
	iMainImage->Bitmap->FillRect(Rect(0, 0, CanvasInfor.Width, CanvasInfor.Height),	c);
	iMainImage->Repaint();
	ImageWarp->Bitmap->FillRect(Rect(0, 0, CanvasInfor.Width, 32), c);
	ImageWarp->Repaint();
	ImageWeft->Bitmap->FillRect(Rect(0, 0, 32, CanvasInfor.Height),	c);
	ImageWeft->Repaint();
	FileName = Format("Noname%d.wea", OPENARRAY(TVarRec, (Number+1)));
	iMainImage->Bitmap->FillRect(Rect(0, 0, CanvasInfor.Width, CanvasInfor.Height),
  	PaletteForm->DIB256Palette->GetBGCOLORREF(iMainImage->Bitmap->BitsPerPixel));
	ClientWidth = MainForm->ClientWidth-267;
	ClientHeight = MainForm->ClientHeight-MainForm->StatusBar->Height
  	-GetSystemMetrics(SM_CYSMCAPTION)-GetSystemMetrics(SM_CYMENU)+3;
  SetCaption();
  iMainImage->SetPosition(0, 0);
  MainForm->UpdateMenuItems(NULL);
  return EC_NONE;
}
//---------------------------------------------------------------------------
TPException __fastcall TMainImageForm::InitFormFile(AnsiString dn, AnsiString fn)
{
  int pw, ph, sw, sh, x, y;
	RGBQUAD rgb[256];
  TTexpiaBitmap *tb = NULL;
  TPCanvasInfor ci;
  Byte c[256], *bp;
  TPException ec = EC_NONE;
  AnsiString Ext;

  if (Palette==NULL || WorkArea==NULL || Plan==NULL) return EC_MEMORY_LACK;
	Top = 0;
	Left = 0;
	sw = MainForm->ClientWidth-267;
	sh = MainForm->ClientHeight-MainForm->StatusBar->Height
 		-GetSystemMetrics(SM_CYSMCAPTION)-GetSystemMetrics(SM_CYMENU)+3;
  if ((tb = new TTexpiaBitmap)==NULL) { ec = EC_MEMORY_LACK; goto fail; }
  tb->CoordinateSystem = csBottomLeft;
 	if ((ec = LoadFromFile(fn, tb, Palette, ci))!=EC_NONE) goto fail;
 	if (!ResizePattern(ci)) { ec = EC_MEMORY_LACK; goto fail; }
  DrawWarpBar();
  DrawWeftBar();
  if (Plan->Weaving) {
		if (!iMainImage->Bitmap->Copy(tb, SRCCOPY)) { ec = EC_MEMORY_LACK; goto fail; }
  } else {
    if(Plan->bOld) {
      Plan->calc_weave(iMainImage->Bitmap);
		  if (sbFrontBack->Down) Plan->DrawBack(iMainImage->Bitmap, Palette->ColorData[1]->RGB);
  	  else Plan->DrawFront(iMainImage->Bitmap, Palette->ColorData[1]->RGB);
	  } else {
   	  Plan->calc_weave(iMainImage->Bitmap, Palette->ColorData[1]->RGB);
		  if (sbFrontBack->Down) Plan->DrawBack(iMainImage->Bitmap);
      else  Plan->DrawFront(iMainImage->Bitmap);
    }
  }
	pw = iMainImage->Bitmap->Width+PanelVert->Width;
	ph = iMainImage->Bitmap->Height+PanelHorz->Height;
  if (sbRuler->Down) {
		pw += Ruler->Thick;
		ph += Ruler->Thick;
  }
  if (pw<sw) sw = pw;
 	if (ph<sh) sh = ph;
  DirName = dn;
  Ext = ExtractFileExt(fn);
  if (Ext == ".wav") {
    StrMove(StrPos(fn.c_str(), "."), ".wav", 4);
    FileName = fn;
    SetCaption();
  } else if (Ext == ".wea"){
    StrMove(StrPos(fn.c_str(), "."), ".wea", 4);
    FileName = fn;
    SetCaption();
  }
  delete tb;
	ClientWidth = sw;
	ClientHeight = sh;
  iMainImage->SetPosition(0, 0);
  MainForm->UpdateMenuItems(NULL);
  return EC_NONE;
fail:
	if (tb) delete tb;
	return ec;
}
//---------------------------------------------------------------------------
TPException __fastcall TMainImageForm::InitFormColorFile(HANDLE hFile)
{
  int pw, ph, sw, sh, x, y;
	RGBQUAD rgb[256];
  TTexpiaBitmap *tb = NULL;
  TPCanvasInfor ci;
  Byte c[256], *bp;
  TPException ec = EC_NONE;
  TEXPIAFILEHEADER tpfh;

  if (Palette==NULL || WorkArea==NULL || Plan==NULL) return EC_MEMORY_LACK;
	Top = 0;
	Left = 0;
	sw = MainForm->ClientWidth-267;
	sh = MainForm->ClientHeight-MainForm->StatusBar->Height
 		-GetSystemMetrics(SM_CYSMCAPTION)-GetSystemMetrics(SM_CYMENU)+3;
  if ((tb = new TTexpiaBitmap)==NULL) { ec = EC_MEMORY_LACK; goto fail; }
  tb->CoordinateSystem = csBottomLeft;
	if ((ec = LoadFromTexpiaFile(hFile, Palette, tpfh, tb)) != EC_NONE) goto fail;
  if ((ec = Plan->LoadFromFile(hFile, tpfh)) != EC_NONE) goto fail;
  UserColorLibForm->ThisFileHasUserColor(Palette);
  ci = tpfh.CanvasInfor;
 	if (!ResizePattern(ci)) { ec = EC_MEMORY_LACK; goto fail; }
  DrawWarpBar();
  DrawWeftBar();
  if (Plan->Weaving) {
		if (!iMainImage->Bitmap->Copy(tb, SRCCOPY)) { ec = EC_MEMORY_LACK; goto fail; }
  } else {
    Plan->calc_weave(iMainImage->Bitmap, Palette->ColorData[1]->RGB);
		if (sbFrontBack->Down) Plan->DrawBack(iMainImage->Bitmap);
    else  Plan->DrawFront(iMainImage->Bitmap);
  }
	pw = iMainImage->Bitmap->Width+PanelVert->Width;
	ph = iMainImage->Bitmap->Height+PanelHorz->Height;
  if (sbRuler->Down) {
		pw += Ruler->Thick;
		ph += Ruler->Thick;
  }
  if (pw<sw) sw = pw;
 	if (ph<sh) sh = ph;
  delete tb;
  FileName = Format("Noname%d.wea", OPENARRAY(TVarRec, (Number+1)));
  SetCaption();
	ClientWidth = sw;
	ClientHeight = sh;
  iMainImage->SetPosition(0, 0);
  MainForm->UpdateMenuItems(NULL);
  return EC_NONE;
fail:
	if (tb) delete tb;
	return ec;
}
//---------------------------------------------------------------------------
bool __fastcall TMainImageForm::ResizePattern(TPCanvasInfor &pi)
{
  if (pi.SizeType!=cstFree) {
  	pi.Width = pi.GetWidth();
  	pi.Height = pi.GetHeight();
  }
	CanvasInfor = pi;
	CanvasInfor.SetExtFileOption();
  Ruler->DPI = CanvasInfor.DotsPerInch;
 	if (!iMainImage->Create(CanvasInfor.Width, CanvasInfor.Height)) return false;
 	if (!ImageWarp->Bitmap->Create(CanvasInfor.Width, 32, 16)) return false;
  ImageWeft->Bitmap->CoordinateSystem = csBottomLeft;
 	if (!ImageWeft->Bitmap->Create(32, CanvasInfor.Height, 16)) return false;
  if (!Plan->Init(CanvasInfor.Width, CanvasInfor.Height)) return false;
  ReviewStatusBar();
  return true;
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::EnlargeCanvas(int w, int h)
{
  COLORREF bc = PaletteForm->DIB256Palette->GetBGCOLORREF(iMainImage->Bitmap->BitsPerPixel);

	WorkArea->ResetRegion(iMainImage);
	CanvasInfor.SetSize(cstFree, w, h);
 	iMainImage->Bitmap->Resize(w, h, bc);
 	ImageWarp->Bitmap->Resize(w, 32, bc);
 	ImageWeft->Bitmap->Resize(32, h, bc);
  Plan->Init(w, h);
  DrawWarpBar();
  DrawWeftBar();
  if (Plan->Finish) {
  	Plan->calc_weave(iMainImage->Bitmap, Palette->ColorData[1]->RGB);
		if (sbFrontBack->Down) {
			Plan->DrawBack(iMainImage->Bitmap);
	 	} else {
			Plan->DrawFront(iMainImage->Bitmap);
	  }
  }
  ::RepaintImage();
  ReviewStatusBar();
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::ZoomChange(int zi, int zo, POINT *ptScreen)
{
	POINT ptClient, pt;
  AnsiString sbZoom;

  if (zi!=iMainImage->ZoomIn || zo!=iMainImage->ZoomOut) {
	  iMainImageChange();
  	if (ptScreen) {
			ptClient = iMainImage->ScreenToClient(*ptScreen);
      ptClient.y = iMainImage->Height - ptClient.y;
  		iMainImage->SetZoom(zi, zo, &ptClient);
      pt = Point(ptClient.x, 0);
  		ImageWarp->SetZoom(zi, zo, &ptClient);
      pt = Point(0, ptClient.y);
  		ImageWeft->SetZoom(zi, zo, &ptClient);
    } else {
  		iMainImage->SetZoom(zi, zo);
  		ImageWarp->SetZoom(zi, zo);
  		ImageWeft->SetZoom(zi, zo);
    }
    ImageWarp->PositionX = iMainImage->PositionX;
    ImageWeft->PositionY = iMainImage->PositionY;
    Ruler->Zoom = (double)zi/zo;
  	FullViewForm->SetZoom();
  }
	switch (iMainImage->ZoomIn) {
  	case 1:
			switch (iMainImage->ZoomOut) {
      	case 1: sbZoom = "Zoom : 1"; break;
		  	case 2:	sbZoom = "Zoom : 1/2"; break;
  			case 4:	sbZoom = "Zoom : 1/4"; break;
		  	case 8:	sbZoom = "Zoom : 1/8"; break;
  			case 16: sbZoom = "Zoom : 1/16"; break;
      }
      break;
  	case 2: sbZoom = "Zoom : 2"; break;
  	case 4:	sbZoom = "Zoom : 4"; break;
   	case 8:	sbZoom = "Zoom : 8"; break;
   	case 16: sbZoom = "Zoom : 16"; break;
  }
	MainForm->StatusBar->Panels->Items[StatusBarZoom]->Text = sbZoom;
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::ZoomChangeIn(POINT ptScreen)
{
	switch (iMainImage->ZoomIn) {
  	case 1:
			switch (iMainImage->ZoomOut) {
      	case 1:	ZoomChange(2, 1, &ptScreen); break;
		  	case 2: ZoomChange(1, 1, &ptScreen); break;
  			case 4: ZoomChange(1, 2, &ptScreen); break;
		  	case 8:	ZoomChange(1, 4, &ptScreen); break;
  			case 16: ZoomChange(1, 8, &ptScreen); break;
      }
      break;
  	case 2: ZoomChange(4, 1, &ptScreen); break;
  	case 4: ZoomChange(8, 1, &ptScreen); break;
  	case 8: ZoomChange(16, 1, &ptScreen); break;
  }
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::ZoomChangeOut(POINT ptScreen)
{
	switch (iMainImage->ZoomIn) {
  	case 1:
			switch (iMainImage->ZoomOut) {
      	case 1:	ZoomChange(1, 2, &ptScreen); break;
		  	case 2: ZoomChange(1, 4, &ptScreen); break;
  			case 4:	ZoomChange(1, 8, &ptScreen); break;
		  	case 8: ZoomChange(1, 16, &ptScreen); break;
      }
      break;
  	case 2: ZoomChange(1, 1, &ptScreen); break;
  	case 4:	ZoomChange(2, 1, &ptScreen); break;
  	case 8: ZoomChange(4, 1, &ptScreen); break;
  	case 16: ZoomChange(8, 1, &ptScreen); break;
  }
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::iMainImageChange()
{
	FullViewForm->iMainImageChange();
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::WorkAreaChange()
{
  if (WorkArea->Mask) {
	  MainForm->ECopyItem->Enabled = true;
  } else {
	  MainForm->ECopyItem->Enabled = false;
  }
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::UpdateImage()
{
	TPoint Size;

    Size.x = Panel->Width*iMainImage->ZoomOut/iMainImage->ZoomIn;
	Size.y = Panel->Height*iMainImage->ZoomOut/iMainImage->ZoomIn;
	if (iMainImage->Bitmap->Width<Size.x) sbHorz->Max = 0;
	else sbHorz->Max = iMainImage->Bitmap->Width-Size.x;
//	sbHorz->SmallChange = Size.x/4;
	sbHorz->SmallChange = sbHorz->Max/10;
    sbHorz->LargeChange = sbHorz->Max/5;
//	ũѹ ̵    By GreenFish
//  ⼭ Form ũ Ͽµ
//	ƹ Form ũⰡ ƴ
// 	ü   ٲ
	if (iMainImage->Bitmap->Height<Size.y) sbVert->Max = 0;
  else sbVert->Max = iMainImage->Bitmap->Height-Size.y;
  	sbVert->SmallChange = sbVert->Max/10;    // SmallChange ü  1/10
    sbVert->LargeChange = sbVert->Max/5;     // LargeChange ü  1/5
  //	sbVert->SmallChange = Size.y/4;
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::Timer200ms()
{
  if (CurrentUnit==uInch) {
 	  MainForm->StatusBar->Panels->Items[StatusBarAxis]->Text = Format("%f : %f",
   		OPENARRAY(TVarRec, ((double)CursorPosition.x/CanvasInfor.DotsPerInch,
      (double)CursorPosition.y/CanvasInfor.DotsPerInch)));
  } else if (CurrentUnit==uCm) {
 	  MainForm->StatusBar->Panels->Items[StatusBarAxis]->Text = Format("%f : %f",
   		OPENARRAY(TVarRec, (2.54*CursorPosition.x/CanvasInfor.DotsPerInch,
      2.54*CursorPosition.y/CanvasInfor.DotsPerInch)));
  }
  if (sbRuler->Down) Ruler->PositionBar(CursorPosition);
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::Timer1000ms()
{
  if (iMainImage) iMainImage->OutlineBitmapRgn();
}
//---------------------------------------------------------------------
TPException __fastcall TMainImageForm::DrawWarpBar()
{
  TPException ec = EC_NONE;

  if (Plan->bOld) {
    if (sbFrontBack->Down) {
       if ((ec = Plan->DrawWarpBarBack(ImageWarp->Bitmap)) != EC_NONE) return ec;
    } else {
      if ((ec = Plan->DrawWarpBarFront(ImageWarp->Bitmap)) != EC_NONE) return ec;
    }
  } else {
    if ((ec = Plan->DrawWarpBar(ImageWarp->Bitmap, Palette->ColorData[1]->RGB, sbFrontBack->Down)) != EC_NONE) return ec;
  }
  ImageWarp->Repaint();
  return ec;
}
//---------------------------------------------------------------------
TPException __fastcall TMainImageForm::DrawWeftBar()
{
  TPException ec = EC_NONE;

  if (Plan->bOld) {
    if ((ec = Plan->DrawWeftBar(ImageWeft->Bitmap)) != EC_NONE) return ec;
  } else {
	  if ((ec = Plan->DrawWeftBar(ImageWeft->Bitmap, Palette->ColorData[1]->RGB)) != EC_NONE) return ec;
  }
  ImageWeft->Repaint();
  return ec;
}
//---------------------------------------------------------------------
void __fastcall TMainImageForm::Weaving()
{
  TPException ec = EC_NONE;

  Plan->bOld = false;
  if ((ec = DrawWarpBar()) != EC_NONE) goto fail;
  if ((ec = DrawWeftBar()) != EC_NONE) goto fail;
  Plan->calc_weave(iMainImage->Bitmap, Palette->ColorData[1]->RGB);
	if (sbFrontBack->Down) {
  	Plan->DrawBack(iMainImage->Bitmap);
  } else {
  	Plan->DrawFront(iMainImage->Bitmap);
  }
  ::RepaintImage();
  if (Plan->CopyBitmap) delete Plan->CopyBitmap;
  Plan->CopyBitmap = new TTexpiaBitmap;
  Plan->CopyBitmap->Copy(iMainImage->Bitmap, SRCCOPY);
  if (Plan->WeaveCondition.SuckerEffect) Plan->Sucking(sbFrontBack->Down);
  return;
fail :
  EXCEPTION_MESSAGE_OK(ec);
}
//---------------------------------------------------------------------
TPException __fastcall TMainImageForm::SaveToFile(AnsiString dn, AnsiString fn, TCompressMethod cm)
{
	HANDLE hFile = INVALID_HANDLE_VALUE;
  int ec = EC_NONE;
	TEXPIAFILEHEADER tpfh;
  TRect src;
  RGBQUAD rgb[256];
  TTexpiaBitmap *tag = NULL;

  if ((hFile = CreateFile((FullPathName(dn, fn)).c_str(), GENERIC_WRITE, 0, NULL, OPEN_ALWAYS,
      FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) {
    ec = EC_FILE_NOT_CREATE; goto fail;
  }
	tpfh.Version = TexVersion('P', 'T', 240);  //2001.5.11 230ּ 240 ٲ..7.3Version
  tpfh.CanvasInfor = CanvasInfor;
  tpfh.BitsPerPixel = iMainImage->Bitmap->BitsPerPixel;
  tpfh.Compress = cm;
	src.Left = 0;
  src.Top = 0;
	src.Right = iMainImage->Bitmap->Width;
	src.Bottom = iMainImage->Bitmap->Height;

	if ((tag = new TTexpiaBitmap)==NULL) { ec = EC_MEMORY_LACK; goto fail; }
  MakeTexpiaTag(tag, iMainImage->Bitmap, src, 0);
	if (!SaveToTexpiaFile(hFile, Palette, tpfh, tag, iMainImage->Bitmap)) goto fail;
	delete tag; tag = NULL;

  if ((ec = Plan->SaveToFile(hFile, tpfh.Compress)) != EC_NONE) goto fail;
  CloseHandle(hFile);
  DirName = dn;
  FileName = fn;
  SetCaption();
  return EC_NONE;
fail:
 	if (tag) delete tag;
	if (hFile != INVALID_HANDLE_VALUE) CloseHandle(hFile);
  if (ec == EC_NONE) ec = EC_FILE_NOT_WRITE;
  return ec;
}
//---------------------------------------------------------------------
bool __fastcall TMainImageForm::FreeNoPrint(TTexpiaBitmap *Pattern)
{
  HDC dc = NULL;
  int Warp_w, Warp_h, Weft_w, Weft_h;    //Width and Height of Images
  int left, top, iMain_w, iMain_h;
  TCanvas *Canvas = NULL;
  RECT range;

  Warp_h = ImageWarp->Bitmap->Height;
  Weft_w = ImageWeft->Bitmap->Width;
	if (WorkArea->Mask) {
    left = WorkArea->Range.left;
    top = WorkArea->Range.top;
  	iMain_w = WorkArea->Range.right - WorkArea->Range.left;
    iMain_h = WorkArea->Range.bottom - WorkArea->Range.top;
  } else {
    left = 0; top = 0;
  	iMain_w = iMainImage->Bitmap->Width;
  	iMain_h = iMainImage->Bitmap->Height;
  }

  if (!Pattern->Create(iMain_w + 5 + Weft_w,Warp_h + 5 + iMain_h, 16)) goto fail;
  range.left = 0;
  range.right = Pattern->Width;
  range.top = 0;
  range.bottom = Pattern->Height;
  Pattern->FillRect(range,clWhite);

  if ((Canvas = Pattern->CreateCanvas()) == NULL) return false;
	dc = ImageWarp->Bitmap->CreateDC();      // Create HDC of ImageWarp
  if (dc) {
    BitBlt(Canvas->Handle, 0, 0, iMain_w, Warp_h, dc, left, 0, SRCCOPY);
    ImageWarp->Bitmap->DeleteDC(dc); dc = NULL;
  } else {
#ifdef TPDEBUG
    SHOWDEBUG;
    return false;
#endif
  }
  dc = iMainImage->Bitmap->CreateDC();     //Create HDC of iMainImage
  if (dc) {
    BitBlt(Canvas->Handle, 0, Warp_h + 5, iMain_w, iMain_h, dc, left, top, SRCCOPY);
    iMainImage->Bitmap->DeleteDC(dc); dc = NULL;
  } else {
#ifdef TPDEBUG
    SHOWDEBUG;
    return false;
#endif
  }
	dc = ImageWeft->Bitmap->CreateDC();      // Create HDC of ImageWeft
  if (dc) {
    BitBlt(Canvas->Handle, iMain_w + 5, Warp_h + 5, Weft_w, iMain_h, dc, 0, top, SRCCOPY);
    ImageWeft->Bitmap->DeleteDC(dc);
  } else {
#ifdef TPDEBUG
    SHOWDEBUG;
    return false;
#endif
  }
  Pattern->DeleteCanvas(Canvas);
  return true;
fail:
	return false;
}
//---------------------------------------------------------------------------
bool __fastcall TMainImageForm::FreeYesPrint(TTexpiaBitmap *Pattern)
{
	int w, h, weftW, warpH, Mwid, Mhei, left, top, ttt;
  TPoint current;
  HDC hdc = NULL;
  TRect Dst, Src;
  TCanvas *Canvas = NULL,*YesCanvas = NULL;
  TTexpiaBitmap *YesBit = NULL;
  RECT range;
  w = GetDeviceCaps(Printer()->Handle, HORZRES)*160/
  		GetDeviceCaps(Printer()->Handle, LOGPIXELSX);
 	h = GetDeviceCaps(Printer()->Handle, VERTRES)*160/
  		GetDeviceCaps(Printer()->Handle, LOGPIXELSY);

  if((YesBit = new TTexpiaBitmap) == NULL) goto fail;
  if (!YesBit->Create(w,h, 16)) goto fail;
  range.left = 0;
  range.right = YesBit->Width;
  range.top = 0;
  range.bottom = YesBit->Height;
  YesBit->FillRect(range,clWhite);
  current.x = 10; current.y = 20;
  ttt = 20;
  if (YarnDraw(YesBit, current.x, ttt) == false) goto fail;
  current.y = HeaderYesDrawTexture(YesBit, ttt);

  weftW = ImageWeft->Bitmap->Width;
  warpH = ImageWarp->Bitmap->Height;
  if (WorkArea->Mask) {
  	left = WorkArea->Range.left;  top = WorkArea->Range.top;
	  Mwid = WorkArea->Range.right - WorkArea->Range.left;
  	Mhei = WorkArea->Range.bottom - WorkArea->Range.top;
  } else {
  	left = 0; top = 0;
	  Mwid = iMainImage->Bitmap->Width;
  	Mhei = iMainImage->Bitmap->Height;
  }

  if (w > Mwid + weftW + 5){
  	if (!Pattern->Create(w,Mhei + current.y + warpH + 5,16)) goto fail;
  } else {
  	if (!Pattern->Create(Mwid + weftW + 5,Mhei + current.y + warpH + 5,16)) goto fail;
  }

  range.left = 0;
  range.right = Pattern->Width;
  range.top = 0;
  range.bottom = Pattern->Height;

  Pattern->FillRect(range,clWhite);

  if ((Canvas = Pattern->CreateCanvas()) == NULL) return false;

  hdc = ImageWarp->Bitmap->CreateDC();
  if (hdc) {
    BitBlt(Canvas->Handle, 0, 0, Mwid, warpH, hdc, left, 0, SRCCOPY);
    ImageWarp->Bitmap->DeleteDC(hdc); hdc = NULL;
  } else {
#ifdef TPDEBUG
    SHOWDEBUG;
    return false;
#endif
  }
  hdc = iMainImage->Bitmap->CreateDC();
  if (hdc) {
    BitBlt(Canvas->Handle, 0, warpH + 5, Mwid, Mhei, hdc, left, top, SRCCOPY);
    iMainImage->Bitmap->DeleteDC(hdc); hdc = NULL;
  } else {
#ifdef TPDEBUG
    SHOWDEBUG;
    return false;
#endif
  }
  hdc = ImageWeft->Bitmap->CreateDC();
  if (hdc) {
    BitBlt(Canvas->Handle, Mwid + 5, warpH + 5, weftW, Mhei, hdc, 0, top, SRCCOPY);
    ImageWeft->Bitmap->DeleteDC(hdc);  hdc = NULL;
  } else {
#ifdef TPDEBUG
    SHOWDEBUG;
    return false;
#endif
  }
  Dst = Rect(0, Mhei + 5 + warpH, w, Pattern->Height);
  Src = Rect(0, 0, w, current.y);
  if ((YesCanvas = YesBit->CreateCanvas()) == NULL) return false;
  Canvas->CopyRect(Dst, YesCanvas, Src);
  YesBit->DeleteCanvas(YesCanvas);
  Pattern->DeleteCanvas(Canvas);;
  delete YesBit;
  return true;
fail:
  if (YesBit) delete YesBit;
  return false;
}
//---------------------------------------------------------------------------
bool __fastcall TMainImageForm::A4NoPrint(TTexpiaBitmap *Pattern)
{
	int weftW, warpH, Mwid, Mhei, left, Hei_gab;
  HDC dcSrc[3] = { NULL, NULL, NULL }, dcDst = NULL;
  RECT range;
  if (!Pattern->Create(
      GetDeviceCaps(Printer()->Handle, HORZRES)*160/
  		GetDeviceCaps(Printer()->Handle, LOGPIXELSX),
   	  GetDeviceCaps(Printer()->Handle, VERTRES)*160/
  		GetDeviceCaps(Printer()->Handle, LOGPIXELSY), 16)) goto fail;

  range.left = 0;
  range.right = Pattern->Width;
  range.top = 0;
  range.bottom = Pattern->Height;
  Pattern->FillRect(range,clWhite);
  A4Width  = Pattern->Width;
  A4Height = Pattern->Height;
  DrawOutLine(Pattern, 0);
  weftW = ImageWeft->Bitmap->Width;
  warpH = ImageWarp->Bitmap->Height;

  left = 0;
	Mwid = iMainImage->Bitmap->Width;
	Mhei = iMainImage->Bitmap->Height;

  if (Mwid >  A4Width - weftW - 16)  Mwid  = A4Width - weftW - 16;
  if (Mhei >  A4Height - warpH - 76) Mhei = A4Height - warpH - 76;

  Hei_gab = iMainImage->Bitmap->Height - Mhei;                //Determine the start point
  if ((dcDst = Pattern->CreateDC()) == NULL) goto fail;
  if ((dcSrc[0] = ImageWarp->Bitmap->CreateDC()) == NULL) goto fail;
  BitBlt(dcDst, 5, 40, Mwid, warpH, dcSrc[0], left, 0, SRCCOPY);
  ImageWarp->Bitmap->DeleteDC(dcSrc[0]); dcSrc[0] = NULL;

  if ((dcSrc[1] = iMainImage->Bitmap->CreateDC()) == NULL) goto fail;
  BitBlt(dcDst, 5, warpH + 45, Mwid, Mhei, dcSrc[1], 0, Hei_gab, SRCCOPY);
  iMainImage->Bitmap->DeleteDC(dcSrc[1]); dcSrc[1] = NULL;

  if ((dcSrc[2] = ImageWeft->Bitmap->CreateDC()) == NULL) goto fail;
  BitBlt(dcDst, Mwid + 10, warpH + 45, weftW, Mhei, dcSrc[2], 0, Hei_gab, SRCCOPY);
  ImageWeft->Bitmap->DeleteDC(dcSrc[2]); dcSrc[2] = NULL;

  Pattern->DeleteDC(dcDst);
  return true;
fail:
  if (dcDst) Pattern->DeleteDC(dcDst);
  if (dcSrc[2]) ImageWeft->Bitmap->DeleteDC(dcSrc[2]);
  if (dcSrc[1]) iMainImage->Bitmap->DeleteDC(dcSrc[1]);
  if (dcSrc[0]) ImageWarp->Bitmap->DeleteDC(dcSrc[0]);
  return false;
}
//---------------------------------------------------------------------------

bool __fastcall TMainImageForm::A4YesPrint(TTexpiaBitmap *Pattern)
{
	int weftW, warpH, Mwid, Mhei, dh, left, Hei_gab, ttt;
  TPoint current;
  HDC hdc = NULL,dcDst;
  TRect Dst, Src;
  TCanvas *Canvas = NULL,*YesCanvas;
  TTexpiaBitmap *YesBit = NULL;
  RECT range;

  if (!Pattern->Create(
    GetDeviceCaps(Printer()->Handle, HORZRES)*160/
 		GetDeviceCaps(Printer()->Handle, LOGPIXELSX),
   	GetDeviceCaps(Printer()->Handle, VERTRES)*160/
 		GetDeviceCaps(Printer()->Handle, LOGPIXELSY), 16)) goto fail;

	range.left = 0;
  range.right = Pattern->Width;
  range.top = 0;
  range.bottom = Pattern->Height;
  Pattern->FillRect(range,clWhite);
  A4Width  = Pattern->Width;
  A4Height = Pattern->Height;
  DrawOutLine(Pattern, 0);
  YesBit = new TTexpiaBitmap;
  if (YesBit == NULL) goto fail;
	if (!YesBit->Create(A4Width  - 1,A4Height - 1, 16)) goto fail;
  range.left = 0;
  range.right = YesBit->Width;
  range.top = 0;
  range.bottom = YesBit->Height;
  YesBit->FillRect(range,clWhite);

  current.x = 10; current.y = 20;
  ttt = 20;
  if (YarnDraw(YesBit, current.x, ttt) == false) goto fail;
  current.y = HeaderYesDrawTexture(YesBit, ttt);

  weftW = ImageWeft->Bitmap->Width;
  warpH = ImageWarp->Bitmap->Height;

  left = 0;
	Mwid = iMainImage->Bitmap->Width;
	Mhei = iMainImage->Bitmap->Height;

  dh = A4Height - current.y - 70 - warpH;
  if (Mwid >  A4Width - weftW - 16) Mwid  = A4Width - weftW - 16;
  if (Mhei > dh) Mhei  = dh;

  Hei_gab = iMainImage->Bitmap->Height - Mhei;             //Determine the start point

  if ((dcDst = Pattern->CreateDC()) == NULL) goto fail;
  hdc = ImageWarp->Bitmap->CreateDC();
  if (hdc) {
    BitBlt(dcDst, 5, 40, Mwid, warpH, hdc, left, 0, SRCCOPY);
    ImageWarp->Bitmap->DeleteDC(hdc); hdc = NULL;
  } else goto fail;

  hdc = iMainImage->Bitmap->CreateDC();
  if (hdc) {
    BitBlt(dcDst, 5, warpH + 45, Mwid, Mhei,
             hdc, 0, Hei_gab, SRCCOPY);
    iMainImage->Bitmap->DeleteDC(hdc); hdc = NULL;
  } else goto fail;

  hdc = ImageWeft->Bitmap->CreateDC();
  if (hdc) {
    BitBlt(dcDst, Mwid + 10, warpH + 45, weftW, Mhei,
             hdc, 0, Hei_gab, SRCCOPY);
    ImageWeft->Bitmap->DeleteDC(hdc); hdc = NULL;
  } else goto fail;

  Dst = Rect(5, Mhei + 45 + warpH, A4Width - 6, Mhei + 45 + warpH + current.y);
  Src = Rect(5, 0, A4Width - 6, current.y);
  Pattern->DeleteDC(dcDst);
  if ((Canvas = Pattern->CreateCanvas()) == NULL) return false;
  if(( YesCanvas = YesBit->CreateCanvas()) == NULL) return false;
  Canvas->CopyRect(Dst, YesCanvas, Src);
  Pattern->DeleteCanvas(Canvas);
  Pattern->DeleteCanvas(YesCanvas);
  delete YesBit;
  return true;
fail:
	if (dcDst) Pattern->DeleteDC(dcDst);
  if (YesBit) delete YesBit;
  return false;
}
//---------------------------------------------------------------------------
bool __fastcall TMainImageForm::A4ProductDataAPrint(TTexpiaBitmap *Pattern, double Length[2],
                int Yarns[2], AnsiString arWidth, AnsiString weDensiy, AnsiString totWarpCnt)
{
	int currentH, clientH, w, h, temp, sheet;
  int DTextHeight, DYarnHeight, DTableHeight, DTextureHeight;
  int CellCnt, ArrayCellCnt;
  int i;
  RECT range;
  int number;

  w = GetDeviceCaps(Printer()->Handle, HORZRES)*160/
  		GetDeviceCaps(Printer()->Handle, LOGPIXELSX);
 	h = GetDeviceCaps(Printer()->Handle, VERTRES)*160/
  		GetDeviceCaps(Printer()->Handle, LOGPIXELSY);
  A4Height = h;
  A4Width =  w;
  clientH =  h - 70; //  (45+25)
  DTextHeight = Plan->Yarn->ChoiceCount * 20;
  DYarnHeight = GetYarnHeight();
  int a = Plan->SimpleProductArray[0]->Count > 6 ? Plan->SimpleProductArray[0]->Count + 2 : 8;
  int b = Plan->SimpleProductArray[1]->Count > 6 ? Plan->SimpleProductArray[1]->Count +2 : 8;
  CellCnt = Max(a, b);
  ArrayCellCnt = Max(Plan->Yarn->PData[0]->Count+2, Plan->Yarn->PData[1]->Count+2);
  DTableHeight = 30*(CellCnt+ArrayCellCnt)+30+30;
  if (GetTextureHeight(w, DTextureHeight) == false) return false;
  temp = DTextHeight + DYarnHeight + DTableHeight + DTextureHeight;
  sheet = temp / clientH + 1;
  currentH = 145;

  if(!Pattern->Create(w, temp + 2000, 16)) goto fail;
  Pattern->FillRect(Rect(0, 0, Pattern->Width, Pattern->Height), clWhite);

	if (YarnDraw(Pattern, 10, currentH, true, h) == false) return false;
 	currentH = TableDrawA(Pattern, currentH, Length, Yarns, arWidth, weDensiy, totWarpCnt);
  ProductDrawTextureA(Pattern, currentH);
  sheet = (currentH / A4Height) + 1;
	Pattern->Resize(w,sheet * A4Height,clWhite);
  for (i = 0; i < sheet; i++) ProductDrawOutLine(Pattern, 100+A4Height*i);
  return true;
fail:
  return false;
}
//----------------------------------------------------------------------------
bool __fastcall TMainImageForm::A4ProductDataBPrint(TTexpiaBitmap *Pattern)
{
	int currentH, clientH, w, h, temp, sheet;
  int DTextHeight, DYarnHeight, DTableHeight;
  int warpcnt, weftcnt;
  int i;
  RECT range;
  int number;

	w = GetDeviceCaps(Printer()->Handle, HORZRES)*160/
  		GetDeviceCaps(Printer()->Handle, LOGPIXELSX);
 	h = GetDeviceCaps(Printer()->Handle, VERTRES)*160/
  		GetDeviceCaps(Printer()->Handle, LOGPIXELSY);
  A4Height = h;
  A4Width =  w;
  clientH =  h - 70; //  (45+25)
  DTextHeight = Plan->Yarn->ChoiceCount * 20;
  DYarnHeight = GetYarnHeight();
  int a = Plan->ProductArray[0]->Count > 6 ? Plan->SimpleProductArray[0]->Count + 2 : 8;
  int b = Plan->ProductArray[1]->Count > 6 ? Plan->SimpleProductArray[1]->Count +2 : 8;
  DTableHeight = 40*(a+b) + 80;
  temp = DTextHeight + DYarnHeight + DTableHeight + 280;
  sheet = temp / clientH + 1;
  currentH = 145;

  if(!Pattern->Create(w, temp + 2000, 16)) goto fail;
  Pattern->FillRect(Rect(0, 0, Pattern->Width, Pattern->Height), clWhite);

	if (YarnDraw(Pattern, 10, currentH, true, h) == false) return false;

 	currentH = TableDrawB(Pattern, currentH);
  DrawMemo(Pattern, currentH, true);
  currentH += 160;
  AddData(Pattern, currentH);
  ProductDrawTextureB(Pattern, currentH);
  currentH += 320;
  DrawMemo(Pattern, currentH, false);

  sheet = (currentH / A4Height) + 1;
	Pattern->Resize(w,sheet * A4Height,clWhite);
  for (i = 0; i < sheet; i++) ProductDrawOutLine(Pattern, 100+A4Height*i);
  return true;
fail:
  return false;
}
//----------------------------------------------------------------------------
bool __fastcall TMainImageForm::A4FrontBackPrint(TTexpiaBitmap *Pattern, bool &back)
{
	int weftW, warpH, Mwid, Mhei, str_length;
  HDC hdc = NULL;
  TRect Temp;
  AnsiString F_str, B_str;
  TTexpiaBitmap *TempBitmap = NULL;
  TCanvas *Canvas = NULL;
  RECT range;

  if (Plan->CheckFrontBackPrint()) {
    if(!Pattern->Create(GetDeviceCaps(Printer()->Handle, HORZRES)*160/
  	  							GetDeviceCaps(Printer()->Handle, LOGPIXELSX),
        						GetDeviceCaps(Printer()->Handle, VERTRES)*160/
  									GetDeviceCaps(Printer()->Handle, LOGPIXELSY), 16)) goto fail;
    range.left = 0;
  	range.right = Pattern->Width;
  	range.top = 0;
  	range.bottom = Pattern->Height;
  	Pattern->FillRect(range,clWhite);
    A4Width  = Pattern->Width;
    A4Height = Pattern->Height;
    DrawOutLine(Pattern, 0);

    if ((Canvas = Pattern->CreateCanvas()) == NULL) return false;
    Canvas->Font->Size = 18;
    Canvas->Font->Color = clBlue;
    Canvas->Font->Name=fsItalic;
    F_str = "[ FRONT   SIDE ]"; B_str = "[ BACK   SIDE ]";
    Canvas->TextOut(70, 48 ,F_str );
    Canvas->TextOut(70, A4Height/2 + 19 -3, B_str);

    str_length = Canvas->TextWidth(F_str);
    Canvas->Pen->Width = 3;
    Canvas->MoveTo(80 + str_length, 62);
    Canvas->LineTo(A4Width-10, 62);
    Canvas->LineTo(A4Width - 10, A4Height/2 + 3);
    Canvas->LineTo(10, A4Height/2 +3);
    Canvas->LineTo(10, 62);
    Canvas->LineTo(60, 62);

    str_length = Canvas->TextWidth(B_str);
    Canvas->MoveTo(80 + str_length, A4Height/2 + 30);
    Canvas->LineTo(A4Width-10, A4Height/2 + 30);
    Canvas->LineTo(A4Width - 10, A4Height - 31);
    Canvas->LineTo(10, A4Height - 31);
    Canvas->LineTo(10, A4Height/2 + 30);
    Canvas->LineTo(60, A4Height/2 + 30);

    weftW = ImageWeft->Bitmap->Width;
    warpH = ImageWarp->Bitmap->Height;
	  Mwid = iMainImage->Bitmap->Width;
	  Mhei = iMainImage->Bitmap->Height;
    if (Mwid >  A4Width - weftW - 46)  Mwid  = A4Width - weftW - 46;
    if (Mhei >  A4Height/2 - warpH - 89) Mhei = A4Height/2 - warpH - 89;

    TempBitmap = new TTexpiaBitmap;
    if (TempBitmap == NULL) goto fail;

//Front of ImageWarp
    if (TempBitmap->Create(Mwid, warpH, 16) == false) goto fail;
    Plan->DrawWarpBar(TempBitmap, Palette->ColorData[1]->RGB, false);
    hdc = TempBitmap->CreateDC();
    if (hdc) {
      BitBlt(Canvas->Handle, 20, 80, Mwid, warpH, hdc, 0, 0, SRCCOPY);
      TempBitmap->DeleteDC(hdc); hdc = NULL;
    } else goto fail;

//Front of iMainImage
    if (TempBitmap->Create(Mwid, Mhei, 16) == false) goto fail;
    Plan->DrawFront(TempBitmap);
    hdc = TempBitmap->CreateDC();
    if (hdc) {
      BitBlt(Canvas->Handle, 20, warpH + 85, Mwid, Mhei, hdc, 0, 0, SRCCOPY);
      TempBitmap->DeleteDC(hdc); hdc = NULL;
    } else goto fail;

//Front and Back of ImageWeft
    if (TempBitmap->Create(weftW, Mhei, 16) == false) goto fail;
    Plan->DrawWeftBar(TempBitmap, Palette->ColorData[1]->RGB);
    hdc = TempBitmap->CreateDC();
    if (hdc) {
      BitBlt(Canvas->Handle, Mwid + 30, warpH + 85, weftW, Mhei,
               hdc, 0, 0, SRCCOPY);
      BitBlt(Canvas->Handle, Mwid + 30, A4Height/2 + warpH + 53, weftW, Mhei,
               hdc, 0, 0, SRCCOPY);
      TempBitmap->DeleteDC(hdc); hdc = NULL;
    } else goto fail;

//Back of ImageWarp
    if (TempBitmap->Create(Mwid, warpH, 16) == false) goto fail;
    Plan->DrawWarpBar(TempBitmap, Palette->ColorData[1]->RGB, true);
    hdc = TempBitmap->CreateDC();
    if (hdc) {
      BitBlt(Canvas->Handle, 20, A4Height/2 + 48, Mwid, warpH,
               hdc, 0, 0, SRCCOPY);
      TempBitmap->DeleteDC(hdc); hdc = NULL;
    } else goto fail;

//Back of iMainImage
    if (TempBitmap->Create(Mwid, Mhei, 16) == false) goto fail;
    Plan->DrawBack(TempBitmap);
    hdc = TempBitmap->CreateDC();
    if (hdc) {
      BitBlt(Canvas->Handle, 20, A4Height/2 + warpH + 53, Mwid, Mhei,
							 hdc, 0, 0, SRCCOPY);
      TempBitmap->DeleteDC(hdc); hdc = NULL;
    } else goto fail;
    delete TempBitmap;
    Pattern->DeleteCanvas(Canvas);
    back = true;
    return true;
  } else {
    ShowMessage(IDS_MAINIMAGE_MESSAGE);
    back = false;
    return true;
  }
fail:
  if (TempBitmap) delete TempBitmap;
  return false;
}
//----------------------------------------------------------------------------
bool __fastcall TMainImageForm::A4HighNoPrint(TTexpiaBitmap *Pattern, int PatternDPI)
{
  WORD *pp, *rp;
	int weftW, warpH, Mwid, Mhei, left, Hei_gab;
  RECT range;
  int x, y, h, indexX, indexY;
  if (!Pattern->Create(
      GetDeviceCaps(Printer()->Handle, HORZRES)*PatternDPI/
  		GetDeviceCaps(Printer()->Handle, LOGPIXELSX),
   	  GetDeviceCaps(Printer()->Handle, VERTRES)*PatternDPI/
  		GetDeviceCaps(Printer()->Handle, LOGPIXELSY), 16)) goto fail;

  range.left = 0;
  range.right = Pattern->Width - 1;
  range.top = 0;
  range.bottom = Pattern->Height - 1;
  Pattern->FillRect(range,clWhite);
  A4Width  = Pattern->Width;
  A4Height = Pattern->Height;
  DrawOutLine(Pattern, 0, PatternDPI);
  weftW = ImageWeft->Bitmap->Width*PatternDPI/160;
  warpH = ImageWarp->Bitmap->Height*PatternDPI/160;
	Mwid = iMainImage->Bitmap->Width*PatternDPI/160;
	Mhei = iMainImage->Bitmap->Height*PatternDPI/160;

  if (Mwid >  A4Width - weftW - 16*PatternDPI/160)  Mwid  = A4Width - weftW - 16*PatternDPI/160;
  if (Mhei >  A4Height - warpH - 76*PatternDPI/160) Mhei = A4Height - warpH - 76*PatternDPI/160;

  if(Pattern->StartScanLine() == false) goto fail;
  if(Plan->WarpBitmap->StartScanLine() == false) goto fail;
  for(y = 40*PatternDPI/160, h = 0, indexY = 0; y < 40*PatternDPI/160 + warpH; y++, h++, indexY++){
     pp = (WORD *)Pattern->GetScanLine(40*PatternDPI/160 + h);
     rp = (WORD *)Plan->WarpBitmap->GetScanLine(indexY);
     for(x = 5*PatternDPI/160, indexX = 0; x < 5*PatternDPI/160 + Mwid; x++, indexX++){
        if(indexX == Plan->WarpBitmap->Width) indexX = 0;
        *(pp+x) = *(rp + indexX);
     }
     Pattern->PutScanLine(40*PatternDPI/160 + h);
  }
  Plan->WarpBitmap->StopScanLine();

  if(Plan->HighPatternBitmap->StartScanLine() == false) goto fail;
  for(y = warpH + 45*PatternDPI/160, indexY = 0, h = 0; y < warpH + 45*PatternDPI/160 + Mhei; y++, h++, indexY++){
     if(indexY == Plan->HighPatternBitmap->Height) indexY = 0;
     pp = (WORD *)Pattern->GetScanLine(warpH + 45*PatternDPI/160 + Mhei - h -1);
     rp = (WORD *)Plan->HighPatternBitmap->GetScanLine(Plan->HighPatternBitmap->Height - indexY -1);
     for(x = 5*PatternDPI/160, indexX = 0; x < 5*PatternDPI/160+Mwid;  x++, indexX++){
       if(indexX == Plan->HighPatternBitmap->Width) indexX = 0;
       *(pp+x) = *(rp + indexX);
     }
     Pattern->PutScanLine(warpH + 45*PatternDPI/160 + Mhei - h -1);
  }
  Plan->HighPatternBitmap->StopScanLine();

  if(Plan->WeftBitmap->StartScanLine() == false) goto fail;
  for(y = warpH + 45*PatternDPI/160, h = 0, indexY = 0; y < warpH + 45*PatternDPI/160 + Mhei; y++, h++, indexY++){
     if(indexY == Plan->WeftBitmap->Height) indexY = 0;
     pp = (WORD *)Pattern->GetScanLine(warpH + 45*PatternDPI/160 + Mhei - h -1);
     rp = (WORD *)Plan->WeftBitmap->GetScanLine(Plan->WeftBitmap->Height - indexY -1);
     for(x = Mwid + 10*PatternDPI/160, indexX = 0; x < Mwid + 10*PatternDPI/160 + weftW; x++, indexX++){
        *(pp+x) = *(rp + indexX);
     }
     Pattern->PutScanLine(warpH + 45*PatternDPI/160 + Mhei - h -1);
  }
  Plan->WeftBitmap->StopScanLine();
  Pattern->StopScanLine();
  delete Plan->HighPatternBitmap;   Plan->HighPatternBitmap = NULL;
  delete Plan->WarpBitmap;          Plan->WarpBitmap = NULL;
  delete Plan->WeftBitmap;          Plan->WeftBitmap = NULL;
  return true;
fail:
  ShowMessage("Too Big Pattern");
  return false;
}
//---------------------------------------------------------------------------
bool __fastcall TMainImageForm::A4HighYesPrint(TTexpiaBitmap *Pattern, int PatternDPI)
{
	int weftW, warpH, Mwid, Mhei, dh, left, Hei_gab, ttt;
  int x, y, h, indexX, indexY;
  WORD *pp, *rp;
  TPoint current;
  HDC dcDst = NULL, dcSrc = NULL;
  TTexpiaBitmap *YesBit = NULL;
  RECT range;

  if (!Pattern->Create(
    GetDeviceCaps(Printer()->Handle, HORZRES)*PatternDPI/
 		GetDeviceCaps(Printer()->Handle, LOGPIXELSX),
   	GetDeviceCaps(Printer()->Handle, VERTRES)*PatternDPI/
 		GetDeviceCaps(Printer()->Handle, LOGPIXELSY), 16)) goto fail;

	range.left = 0;
  range.right = Pattern->Width;
  range.top = 0;
  range.bottom = Pattern->Height;
  Pattern->FillRect(range,clWhite);
  A4Width  = Pattern->Width;
  A4Height = Pattern->Height;
  DrawOutLine(Pattern, 0, PatternDPI);
  YesBit = new TTexpiaBitmap;
  if (YesBit == NULL) goto fail;
	if (!YesBit->Create(A4Width*160/PatternDPI ,A4Height*160/PatternDPI , 16)) goto fail;
  range.left = 0;
  range.right = YesBit->Width;
  range.top = 0;
  range.bottom = YesBit->Height;
  YesBit->FillRect(range,clWhite);

  current.x = 10; current.y = 20;
  ttt = 20;
  if (YarnDraw(YesBit, current.x, ttt) == false) goto fail;
  current.y = HeaderYesDrawTexture(YesBit, ttt);

  weftW = ImageWeft->Bitmap->Width*PatternDPI/160;
  warpH = ImageWarp->Bitmap->Height*PatternDPI/160;

  left = 0;
	Mwid = iMainImage->Bitmap->Width*PatternDPI/160;
	Mhei = iMainImage->Bitmap->Height*PatternDPI/160;

  dh = A4Height - current.y*PatternDPI/160 - 70*PatternDPI/160 - warpH;
  if (Mwid >  A4Width - weftW - 16*PatternDPI/160) Mwid  = A4Width - weftW - 16*PatternDPI/160;
  if (Mhei > dh) Mhei  = dh;

  Hei_gab = iMainImage->Bitmap->Height - Mhei;             //Determine the start point

  if(Pattern->StartScanLine() == false) goto fail;
  if(Plan->WarpBitmap->StartScanLine() == false) goto fail;
  for(y = 40*PatternDPI/160, h = 0, indexY = 0; y < 40*PatternDPI/160 + warpH; y++, h++, indexY++){
     pp = (WORD *)Pattern->GetScanLine(40*PatternDPI/160 + h);
     rp = (WORD *)Plan->WarpBitmap->GetScanLine(indexY);
     for(x = 5*PatternDPI/160, indexX = 0; x < 5*PatternDPI/160 + Mwid; x++, indexX++){
        if(indexX == Plan->WarpBitmap->Width) indexX = 0;
        *(pp+x) = *(rp + indexX);
     }
     Pattern->PutScanLine(40*PatternDPI/160 + h);
  }
  Plan->WarpBitmap->StopScanLine();

  if(Plan->HighPatternBitmap->StartScanLine() == false) goto fail;
  for(y = warpH + 45*PatternDPI/160, indexY = 0, h = 0; y < warpH + 45*PatternDPI/160 + Mhei; y++, h++, indexY++){
     if(indexY == Plan->HighPatternBitmap->Height) indexY = 0;
     pp = (WORD *)Pattern->GetScanLine(warpH + 45*PatternDPI/160 + Mhei - h -1);
     rp = (WORD *)Plan->HighPatternBitmap->GetScanLine(Plan->HighPatternBitmap->Height - indexY -1);
     for(x = 5*PatternDPI/160, indexX = 0; x < 5*PatternDPI/160+Mwid;  x++, indexX++){
       if(indexX == Plan->HighPatternBitmap->Width) indexX = 0;
       *(pp+x) = *(rp + indexX);
     }
     Pattern->PutScanLine(warpH + 45*PatternDPI/160 + Mhei - h -1);
  }
  Plan->HighPatternBitmap->StopScanLine();

  if(Plan->WeftBitmap->StartScanLine() == false) goto fail;
  for(y = warpH + 45*PatternDPI/160, h = 0, indexY = 0; y < warpH + 45*PatternDPI/160 + Mhei; y++, h++, indexY++){
     if(indexY == Plan->WeftBitmap->Height) indexY = 0;
     pp = (WORD *)Pattern->GetScanLine(warpH + 45*PatternDPI/160 + Mhei - h -1);
     rp = (WORD *)Plan->WeftBitmap->GetScanLine(Plan->WeftBitmap->Height - indexY -1);
     for(x = Mwid + 10*PatternDPI/160, indexX = 0; x < Mwid + 10*PatternDPI/160 + weftW; x++, indexX++){
        *(pp+x) = *(rp + indexX);
     }
     Pattern->PutScanLine(warpH + 45*PatternDPI/160 + Mhei - h -1);
  }
  Plan->WeftBitmap->StopScanLine();
  Pattern->StopScanLine();
  delete Plan->HighPatternBitmap;   Plan->HighPatternBitmap = NULL;
  delete Plan->WarpBitmap;          Plan->WarpBitmap = NULL;
  delete Plan->WeftBitmap;          Plan->WeftBitmap = NULL;

  dcDst = Pattern->CreateDC();
  dcSrc = YesBit->CreateDC();
  SetStretchBltMode(dcDst, COLORONCOLOR);
  StretchBlt(dcDst, 5*PatternDPI/160, Mhei + 45*PatternDPI/160 + warpH, A4Width -10*PatternDPI/160, current.y*PatternDPI/160,
             dcSrc, 5, 0, A4Width*160/PatternDPI, current.y, SRCCOPY);
  Pattern->DeleteDC(dcDst);
  YesBit->DeleteDC(dcSrc);
  delete YesBit;
  return true;
fail:
  if (YesBit) delete YesBit;
  return false;
}
//----------------------------------------------------------------------------
bool __fastcall TMainImageForm::FreeHighNoPrint(TTexpiaBitmap *Pattern, int PatternDPI)
{
  int Warp_h, Weft_w;    //Width and Height of Images
  int left, top, iMain_w, iMain_h;
  int x, y, h, indexX, indexY;
  WORD *pp, *rp;
  RECT range;

  Warp_h = ImageWarp->Bitmap->Height*PatternDPI/160;
  Weft_w = ImageWeft->Bitmap->Width*PatternDPI/160;
	if (WorkArea->Mask) {
    left = (WorkArea->Range.left % Plan->PatternBitmap->Width)*PatternDPI/160;
    if(left > Plan->HighPatternBitmap->Width -1) left = Plan->HighPatternBitmap->Width - 1;
    top = Plan->HighPatternBitmap->Height -
       ((iMainImage->Bitmap->Height - WorkArea->Range.top -1) % Plan->PatternBitmap->Height)*PatternDPI/160 -1;
    if(top > Plan->HighPatternBitmap->Height -1) top = Plan->HighPatternBitmap->Height - 1;
    iMain_w = (WorkArea->Range.right - WorkArea->Range.left)*PatternDPI/160;
    iMain_h = (WorkArea->Range.bottom - WorkArea->Range.top)*PatternDPI/160;
  } else {
    left = 0; top = 0;
  	iMain_w = iMainImage->Bitmap->Width*PatternDPI/160;
  	iMain_h = iMainImage->Bitmap->Height*PatternDPI/160;
  }

  if (!Pattern->Create(iMain_w + 5*PatternDPI/160 + Weft_w, Warp_h + 5*PatternDPI/160 + iMain_h, 16)) goto fail;
  range.left = 0;
  range.right = Pattern->Width;
  range.top = 0;
  range.bottom = Pattern->Height;
  Pattern->FillRect(range,clWhite);

  if(Pattern->StartScanLine() == false) goto fail;
  if(Plan->WarpBitmap->StartScanLine() == false) goto fail;
  for(y = 0, h = 0; y < Warp_h; y++, h++){
     pp = (WORD *)Pattern->GetScanLine(h);
     rp = (WORD *)Plan->WarpBitmap->GetScanLine(y);
     for(x = 0, indexX = left; x < iMain_w; x++, indexX++){
        if(indexX == Plan->WarpBitmap->Width) indexX = 0;
        *(pp+x) = *(rp + indexX);
     }
     Pattern->PutScanLine(h);
  }
  Plan->WarpBitmap->StopScanLine();

  if(Plan->HighPatternBitmap->StartScanLine() == false) goto fail;
  for(y = Warp_h + 5*PatternDPI/160, h = 0, indexY = top; y < Warp_h + 5*PatternDPI/160 + iMain_h; y++, h++, indexY--){
     if(indexY == 0) indexY = Plan->HighPatternBitmap->Height - 1;
     pp = (WORD *)Pattern->GetScanLine(Warp_h + 5*PatternDPI/160 + iMain_h - h -1);
     rp = (WORD *)Plan->HighPatternBitmap->GetScanLine(indexY);
     for(x = 0, indexX = left; x < iMain_w;  x++, indexX++){
       if(indexX == Plan->HighPatternBitmap->Width) indexX = 0;
       *(pp+x) = *(rp + indexX);
     }
     Pattern->PutScanLine(Warp_h + 5*PatternDPI/160 + iMain_h - h -1);
  }
  Plan->HighPatternBitmap->StopScanLine();

  if(Plan->WeftBitmap->StartScanLine() == false) goto fail;
  for(y = Warp_h + 5*PatternDPI/160, h = 0, indexY = top; y < Warp_h + 5*PatternDPI/160 + iMain_h; y++, h++, indexY--){
     if(indexY == 0) indexY = Plan->HighPatternBitmap->Height - 1;
     pp = (WORD *)Pattern->GetScanLine(Warp_h + 5*PatternDPI/160 + iMain_h - h -1);
     rp = (WORD *)Plan->WeftBitmap->GetScanLine(indexY);
     for(x = iMain_w + 5*PatternDPI/160, indexX = 0; x < iMain_w + 5*PatternDPI/160 + Weft_w; x++, indexX++){
        *(pp+x) = *(rp + indexX);
     }
     Pattern->PutScanLine(Warp_h + 5*PatternDPI/160 + iMain_h - h -1);
  }
  Plan->WeftBitmap->StopScanLine();
  Pattern->StopScanLine();

  delete Plan->HighPatternBitmap;   Plan->HighPatternBitmap = NULL;
  delete Plan->WarpBitmap;          Plan->WarpBitmap = NULL;
  delete Plan->WeftBitmap;          Plan->WeftBitmap = NULL;

  return true;
fail:
	return false;
}
//---------------------------------------------------------------------------
bool __fastcall TMainImageForm::FreeHighYesPrint(TTexpiaBitmap *Pattern, int PatternDPI)
{
  int Warp_h, Weft_w;    //Width and Height of Images
  int left, top, iMain_w, iMain_h, wid, hei, ttt;
  int x, y, h, indexX, indexY;
  WORD *pp, *rp;
  RECT range;
  TTexpiaBitmap *YesBit = NULL;
  TPoint current;
  HDC dcDst = NULL, dcSrc = NULL;

  wid = GetDeviceCaps(Printer()->Handle, HORZRES)*160/
  		GetDeviceCaps(Printer()->Handle, LOGPIXELSX);
 	hei = GetDeviceCaps(Printer()->Handle, VERTRES)*160/
  		GetDeviceCaps(Printer()->Handle, LOGPIXELSY);

  if((YesBit = new TTexpiaBitmap) == NULL) goto fail;
  if (!YesBit->Create(wid,hei, 16)) goto fail;
  range.left = 0;
  range.right = YesBit->Width;
  range.top = 0;
  range.bottom = YesBit->Height;
  YesBit->FillRect(range,clWhite);
  current.x = 10; current.y = 20;
  ttt = 20;
  if (YarnDraw(YesBit, current.x, ttt) == false) goto fail;
  current.y = HeaderYesDrawTexture(YesBit, ttt);


  Warp_h = ImageWarp->Bitmap->Height*PatternDPI/160;
  Weft_w = ImageWeft->Bitmap->Width*PatternDPI/160;
	if (WorkArea->Mask) {
    left = (WorkArea->Range.left % Plan->PatternBitmap->Width)*PatternDPI/160;
    if(left > Plan->HighPatternBitmap->Width -1) left = Plan->HighPatternBitmap->Width - 1;
    top = Plan->HighPatternBitmap->Height -
       ((iMainImage->Bitmap->Height - WorkArea->Range.top -1) % Plan->PatternBitmap->Height)*PatternDPI/160 -1;
    if(top > Plan->HighPatternBitmap->Height -1) top = Plan->HighPatternBitmap->Height - 1;
    iMain_w = (WorkArea->Range.right - WorkArea->Range.left)*PatternDPI/160;
    iMain_h = (WorkArea->Range.bottom - WorkArea->Range.top)*PatternDPI/160;
  } else {
    left = 0; top = 0;
  	iMain_w = iMainImage->Bitmap->Width*PatternDPI/160;
  	iMain_h = iMainImage->Bitmap->Height*PatternDPI/160;
  }
  if (!Pattern->Create(wid*PatternDPI/160, Warp_h + 5*PatternDPI/160 + iMain_h + current.y*PatternDPI/160, 16)) goto fail;
  range.left = 0;
  range.right = Pattern->Width;
  range.top = 0;
  range.bottom = Pattern->Height;
  Pattern->FillRect(range,clWhite);

  if(Pattern->StartScanLine() == false) goto fail;
  if(Plan->WarpBitmap->StartScanLine() == false) goto fail;
  for(y = 0, h = 0; y < Warp_h; y++, h++){
     pp = (WORD *)Pattern->GetScanLine(h);
     rp = (WORD *)Plan->WarpBitmap->GetScanLine(y);
     for(x = 0, indexX = left; x < iMain_w; x++, indexX++){
        if(indexX == Plan->WarpBitmap->Width) indexX = 0;
        *(pp+x) = *(rp + indexX);
     }
     Pattern->PutScanLine(h);
  }
  Plan->WarpBitmap->StopScanLine();

  if(Plan->HighPatternBitmap->StartScanLine() == false) goto fail;
  for(y = Warp_h + 5*PatternDPI/160, h = 0, indexY = top; y < Warp_h + 5*PatternDPI/160 + iMain_h; y++, h++, indexY--){
     if(indexY == 0) indexY = Plan->HighPatternBitmap->Height - 1;
     pp = (WORD *)Pattern->GetScanLine(Warp_h + 5*PatternDPI/160 + iMain_h - h -1);
     rp = (WORD *)Plan->HighPatternBitmap->GetScanLine(indexY);
     for(x = 0, indexX = left; x < iMain_w;  x++, indexX++){
       if(indexX == Plan->HighPatternBitmap->Width) indexX = 0;
       *(pp+x) = *(rp + indexX);
     }
     Pattern->PutScanLine(Warp_h + 5*PatternDPI/160 + iMain_h - h -1);
  }
  Plan->HighPatternBitmap->StopScanLine();

  if(Plan->WeftBitmap->StartScanLine() == false) goto fail;
  for(y = Warp_h + 5*PatternDPI/160, h = 0, indexY = top; y < Warp_h + 5*PatternDPI/160 + iMain_h; y++, h++, indexY--){
     if(indexY == 0) indexY = Plan->HighPatternBitmap->Height - 1;
     pp = (WORD *)Pattern->GetScanLine(Warp_h + 5*PatternDPI/160 + iMain_h - h -1);
     rp = (WORD *)Plan->WeftBitmap->GetScanLine(indexY);
     for(x = iMain_w + 5*PatternDPI/160, indexX = 0; x < iMain_w + 5*PatternDPI/160 + Weft_w; x++, indexX++){
        *(pp+x) = *(rp + indexX);
     }
     Pattern->PutScanLine(Warp_h + 5*PatternDPI/160 + iMain_h - h -1);
  }
  Plan->WeftBitmap->StopScanLine();
  Pattern->StopScanLine();

  delete Plan->HighPatternBitmap;   Plan->HighPatternBitmap = NULL;
  delete Plan->WarpBitmap;          Plan->WarpBitmap = NULL;
  delete Plan->WeftBitmap;          Plan->WeftBitmap = NULL;

  dcDst = Pattern->CreateDC();
  dcSrc = YesBit->CreateDC();
  SetStretchBltMode(dcDst, COLORONCOLOR);
  StretchBlt(dcDst, 0, iMain_h + 5*PatternDPI/160 + Warp_h, Pattern->Width, current.y*PatternDPI/160,
             dcSrc, 0, 0, wid, current.y, SRCCOPY);
  Pattern->DeleteDC(dcDst);
  YesBit->DeleteDC(dcSrc);
  delete YesBit;
  return true;
fail:
	return false;
}
//---------------------------------------------------------------------------
bool __fastcall TMainImageForm::A4HighFrontBackPrint(TTexpiaBitmap *Pattern, bool &back, int PatternDPI)
{
	int weftW, warpH, Mwid, Mhei, str_length;
  int x, y, h, indexX, indexY;
  HDC hdc = NULL;
  TRect Temp;
  AnsiString F_str, B_str;
  WORD *pp, *rp;
  RECT range;
  TCanvas *Canvas = NULL;


  if (Plan->CheckFrontBackPrint()) {
    if(!Pattern->Create(GetDeviceCaps(Printer()->Handle, HORZRES)*PatternDPI/
  	  							GetDeviceCaps(Printer()->Handle, LOGPIXELSX),
        						GetDeviceCaps(Printer()->Handle, VERTRES)*PatternDPI/
  									GetDeviceCaps(Printer()->Handle, LOGPIXELSY), 16)) goto fail;
    range.left = 0;
  	range.right = Pattern->Width;
  	range.top = 0;
  	range.bottom = Pattern->Height;
  	Pattern->FillRect(range,clWhite);
    A4Width  = Pattern->Width;
    A4Height = Pattern->Height;
    DrawOutLine(Pattern, 0, PatternDPI);

    if ((Canvas = Pattern->CreateCanvas()) == NULL) return false;
    Canvas->Font->Size = 18*PatternDPI/160;
    Canvas->Font->Color = clBlue;
    Canvas->Font->Name=fsItalic;
    F_str = "[ FRONT   SIDE ]"; B_str = "[ BACK   SIDE ]";
    Canvas->TextOut(70*PatternDPI/160, 48*PatternDPI/160 ,F_str );
    Canvas->TextOut(70*PatternDPI/160, A4Height/2 + 16*PatternDPI/160, B_str);

    str_length = Canvas->TextWidth(F_str);
    Canvas->Pen->Width = 3*PatternDPI/160;
    Canvas->MoveTo(80*PatternDPI/160 + str_length, 62*PatternDPI/160);
    Canvas->LineTo(A4Width - 10*PatternDPI/160, 62*PatternDPI/160);
    Canvas->LineTo(A4Width - 10*PatternDPI/160, A4Height/2 + 3*PatternDPI/160);
    Canvas->LineTo(10*PatternDPI/160, A4Height/2 +3*PatternDPI/160);
    Canvas->LineTo(10*PatternDPI/160, 62*PatternDPI/160);
    Canvas->LineTo(60*PatternDPI/160, 62*PatternDPI/160);

    str_length = Canvas->TextWidth(B_str);
    Canvas->MoveTo(80*PatternDPI/160 + str_length, A4Height/2 + 30*PatternDPI/160);
    Canvas->LineTo(A4Width - 10*PatternDPI/160, A4Height/2 + 30*PatternDPI/160);
    Canvas->LineTo(A4Width - 10*PatternDPI/160, A4Height - 31*PatternDPI/160);
    Canvas->LineTo(10*PatternDPI/160, A4Height - 31*PatternDPI/160);
    Canvas->LineTo(10*PatternDPI/160, A4Height/2 + 30*PatternDPI/160);
    Canvas->LineTo(60*PatternDPI/160, A4Height/2 + 30*PatternDPI/160);
    Pattern->DeleteCanvas(Canvas);

    weftW = ImageWeft->Bitmap->Width*PatternDPI/160;
    warpH = ImageWarp->Bitmap->Height*PatternDPI/160;
	  Mwid = iMainImage->Bitmap->Width*PatternDPI/160;
	  Mhei = iMainImage->Bitmap->Height*PatternDPI/160;
    if (Mwid >  A4Width - weftW - 46*PatternDPI/160)  Mwid  = A4Width - weftW - 46*PatternDPI/160;
    if (Mhei >  A4Height/2 - warpH - 89*PatternDPI/160) Mhei = A4Height/2 - warpH - 89*PatternDPI/160;

    if(Pattern->StartScanLine() == false) goto fail;
    if(Plan->WarpBitmap->StartScanLine() == false) goto fail;
    for(y = 80*PatternDPI/160, h = 0, indexY = 0; y < 80*PatternDPI/160 + warpH; y++, h++, indexY++){
       pp = (WORD *)Pattern->GetScanLine(80*PatternDPI/160 + h);
       rp = (WORD *)Plan->WarpBitmap->GetScanLine(indexY);
       for(x = 20*PatternDPI/160, indexX = 0; x < 20*PatternDPI/160 + Mwid; x++, indexX++){
          if(indexX == Plan->WarpBitmap->Width) indexX = 0;
          *(pp+x) = *(rp + indexX);
       }
       Pattern->PutScanLine(80*PatternDPI/160 + h);
    }
    Plan->WarpBitmap->StopScanLine();

    if(Plan->HighPatternBitmap->StartScanLine() == false) goto fail;
    for(y = warpH + 85*PatternDPI/160, indexY = 0, h = 0; y < warpH + 85*PatternDPI/160 + Mhei; y++, h++, indexY++){
       if(indexY == Plan->HighPatternBitmap->Height) indexY = 0;
       pp = (WORD *)Pattern->GetScanLine(warpH + 85*PatternDPI/160 + Mhei - h -1);
       rp = (WORD *)Plan->HighPatternBitmap->GetScanLine(Plan->HighPatternBitmap->Height - indexY -1);
       for(x = 20*PatternDPI/160, indexX = 0; x < 20*PatternDPI/160+Mwid;  x++, indexX++){
         if(indexX == Plan->HighPatternBitmap->Width) indexX = 0;
         *(pp+x) = *(rp + indexX);
       }
       Pattern->PutScanLine(warpH + 85*PatternDPI/160 + Mhei - h -1);
    }
    Plan->HighPatternBitmap->StopScanLine();

    if(Plan->WeftBitmap->StartScanLine() == false) goto fail;
    for(y = warpH + 85*PatternDPI/160, h = 0, indexY = 0; y < warpH + 85*PatternDPI/160 + Mhei; y++, h++, indexY++){
       if(indexY == Plan->WeftBitmap->Height) indexY = 0;
       pp = (WORD *)Pattern->GetScanLine(warpH + 85*PatternDPI/160 + Mhei - h -1);
       rp = (WORD *)Plan->WeftBitmap->GetScanLine(Plan->WeftBitmap->Height - indexY -1);
       for(x = Mwid + 30*PatternDPI/160, indexX = 0; x < Mwid + 30*PatternDPI/160 + weftW; x++, indexX++){
          *(pp+x) = *(rp + indexX);
       }
       Pattern->PutScanLine(warpH + 85*PatternDPI/160 + Mhei - h -1);
    }
    Plan->WeftBitmap->StopScanLine();

    if(Pattern->StartScanLine() == false) goto fail;
    if(Plan->WarpBitmap->StartScanLine() == false) goto fail;
    for(y = A4Height/2 + 48*PatternDPI/160, h = 0, indexY = 0; y < A4Height/2 + 48*PatternDPI/160 + warpH; y++, h++, indexY++){
       pp = (WORD *)Pattern->GetScanLine(A4Height/2 + 48*PatternDPI/160 + h);
       rp = (WORD *)Plan->WarpBitmap->GetScanLine(indexY);
       for(x = 20*PatternDPI/160 + Mwid -1, indexX = 0; x >= 20*PatternDPI/160 ; x--, indexX++){
          if(indexX == Plan->WarpBitmap->Width) indexX = 0;
          *(pp+x) = *(rp + indexX);
       }
       Pattern->PutScanLine(A4Height/2 + 48*PatternDPI/160 + h);
    }
    Plan->WarpBitmap->StopScanLine();

    if(Plan->HighBackPatternBitmap->StartScanLine() == false) goto fail;
    for(y = A4Height/2 + warpH + 53*PatternDPI/160, indexY = 0, h = 0; y < A4Height/2 + warpH + 53*PatternDPI/160 + Mhei; y++, h++, indexY++){
       if(indexY == Plan->HighPatternBitmap->Height) indexY = 0;
       pp = (WORD *)Pattern->GetScanLine(A4Height/2 + warpH + 53*PatternDPI/160 + Mhei - h -1);
       rp = (WORD *)Plan->HighBackPatternBitmap->GetScanLine(Plan->HighPatternBitmap->Height - indexY -1);
       for(x = 20*PatternDPI/160+Mwid -1, indexX = 0; x >= 20*PatternDPI/160 ;  x--, indexX++){
         if(indexX == Plan->HighBackPatternBitmap->Width) indexX = 0;
         *(pp+x) = *(rp + indexX);
       }
       Pattern->PutScanLine(A4Height/2 + warpH + 53*PatternDPI/160 + Mhei - h -1);
    }
    Plan->HighBackPatternBitmap->StopScanLine();

    if(Plan->WeftBitmap->StartScanLine() == false) goto fail;
    for(y = A4Height/2 + warpH + 53*PatternDPI/160, h = 0, indexY = 0; y < A4Height/2 + warpH + 53*PatternDPI/160 + Mhei; y++, h++, indexY++){
       if(indexY == Plan->WeftBitmap->Height) indexY = 0;
       pp = (WORD *)Pattern->GetScanLine(A4Height/2 + warpH + 53*PatternDPI/160 + Mhei - h -1);
       rp = (WORD *)Plan->WeftBitmap->GetScanLine(Plan->WeftBitmap->Height - indexY -1);
       for(x = Mwid + 30*PatternDPI/160, indexX = 0; x < Mwid + 30*PatternDPI/160 + weftW; x++, indexX++){
          *(pp+x) = *(rp + indexX);
       }
       Pattern->PutScanLine(A4Height/2 + warpH + 53*PatternDPI/160 + Mhei - h -1);
    }
    Plan->WeftBitmap->StopScanLine();

    Pattern->StopScanLine();
    delete Plan->HighPatternBitmap;   Plan->HighPatternBitmap = NULL;
    delete Plan->WarpBitmap;          Plan->WarpBitmap = NULL;
    delete Plan->WeftBitmap;          Plan->WeftBitmap = NULL;
    back = true;
    return true;
  } else {
    ShowMessage(IDS_MAINIMAGE_MESSAGE);
    back = false;
    return true;
  }
fail:
  return false;
}
//----------------------------------------------------------------------------
void __fastcall TMainImageForm::EditCopy()
{
  RGBQUAD rgb[256];
  BITMAPHANDLE bh, *pbh;
  int w, h, i, x, y;
  HDC dcSrc = NULL, dcDst = NULL, dcMask = NULL;
  HGLOBAL hMem = NULL;
  Byte *lpData = NULL;
  TClipboardInfo cbi;
  TColorData *cd;
  Byte *mp, *bp;
  COLORREF c;
  bool bClipboard = false;
  TPException ec = EC_NONE;

	TCursor cursor = Screen->Cursor;
 	Screen->Cursor = crHourGlass;
  if (WorkArea->Mask) {
	  memset(&bh, 0, sizeof(BITMAPHANDLE));
  	w = WorkArea->Range.right-WorkArea->Range.left;
    h = WorkArea->Range.bottom-WorkArea->Range.top;
//
  	if (L_CreateBitmap(&bh, TYPE_CONV, w, h, iMainImage->Bitmap->BitsPerPixel,
      ORDER_BGR, NULL, TOP_LEFT)<1) goto next1;
    if ((dcDst = L_CreateLeadDC(&bh))==NULL) goto next1;
    if ((dcSrc = iMainImage->Bitmap->CreateDC())==NULL) goto next1;
 	  BitBlt(dcDst, 0, 0, w, h, dcSrc, WorkArea->Range.left, WorkArea->Range.top, SRCCOPY);
   	iMainImage->Bitmap->DeleteDC(dcSrc); dcSrc = NULL;
    if ((dcMask = WorkArea->Mask->CreateDC())==NULL) goto next1;
 	 	BitBlt(dcDst, 0, 0, w, h, dcMask, 0, 0, SRCAND);
    WorkArea->Mask->DeleteDC(dcMask); dcMask = NULL;
  	L_DeleteLeadDC(dcDst); dcDst = NULL;
	  if (L_CopyToClipboard(MainForm->Handle, &bh)<1) goto next1;
	  L_FreeBitmap(&bh);
    goto next2;
next1:
		if (dcDst) {
  		if (dcMask) WorkArea->Mask->DeleteDC(dcMask);
  		if (dcSrc) iMainImage->Bitmap->DeleteDC(dcSrc);
	  	L_DeleteLeadDC(dcDst);
  	}
	  L_FreeBitmap(&bh);
next2:
//
	  if (!OpenClipboard(MainForm->Handle)) { ec = EC_CLIPBOARD_NOT_OPEN; goto fail; }
    bClipboard = true;
    if (MainForm->ClipboardFormat) {
	    cbi.Version = 0;
      cbi.Time = clock();
 	 		cbi.Width = w;
   		cbi.Height = h;
  	  cbi.Mask = true;
 		  cbi.BitsPerPixel = 15;
	  	if ((hMem = GlobalAlloc(GHND, sizeof(TClipboardInfo)+sizeof(COLORREF)+
      	 	2*cbi.Width*cbi.Height+WorkArea->Mask->BytesPerLine*cbi.Height))==NULL) {
        ec = EC_MEMORY_LACK; goto fail;
      }
 		  if ((lpData = (Byte *)GlobalLock(hMem))==NULL) { ec = EC_MEMORY_LACK; goto fail; }
			memcpy(lpData, &cbi, sizeof(TClipboardInfo));
   	  lpData += sizeof(TClipboardInfo);
      c = Palette->Color[1];
      memcpy(lpData, &c, sizeof(COLORREF));
   	  lpData += sizeof(COLORREF);
	    if (!iMainImage->Bitmap->StartScanLine()) { ec = EC_MEMORY_LACK; goto fail; }
   	  for (y=0; y<cbi.Height; y++) {
     	  bp = iMainImage->Bitmap->GetScanLine(WorkArea->Range.top+y)+2*WorkArea->Range.left;
        memcpy(lpData, bp, 2*cbi.Width);
				lpData += 2*cbi.Width;
      }
 	    iMainImage->Bitmap->StopScanLine();
    	if (!WorkArea->Mask->StartScanLine()) { ec = EC_MEMORY_LACK; goto fail; }
   	  for (y=0; y<cbi.Height; y++) {
       	mp = WorkArea->Mask->GetScanLine(y);
    	  for (x=0; x<WorkArea->Mask->BytesPerLine; x++) {
         	*(lpData+x) = ~*(mp+x);
       	}
				lpData += WorkArea->Mask->BytesPerLine;
      }
     	WorkArea->Mask->StopScanLine();
   	  GlobalUnlock(hMem);
 		  SetClipboardData(MainForm->ClipboardFormat, hMem);
    }
	  CloseClipboard();
  } else {
		if ((pbh = iMainImage->Bitmap->Handle)==NULL) { ec = EC_CLIPBOARD_NOT_OPEN; goto fail; }
//
	  L_CopyToClipboard(MainForm->Handle, &bh);
//
	  if (!OpenClipboard(MainForm->Handle)) { ec = EC_CLIPBOARD_NOT_OPEN; goto fail; }
    bClipboard = true;
    if (MainForm->ClipboardFormat) {
	    cbi.Version = 0;
      cbi.Time = clock();
  		cbi.Width = iMainImage->Bitmap->Width;
 	  	cbi.Height = iMainImage->Bitmap->Height;
 	  	cbi.Mask = false;
 		  cbi.BitsPerPixel = 15;
 	  	if ((hMem = GlobalAlloc(GHND, sizeof(TClipboardInfo)+sizeof(COLORREF)+2*cbi.Width*cbi.Height))) {
        ec = EC_MEMORY_LACK; goto fail;
      }
 		  if ((lpData = (Byte *)GlobalLock(hMem))==NULL) { ec = EC_MEMORY_LACK; goto fail; }
			memcpy(lpData, &cbi, sizeof(TClipboardInfo));
   	  lpData += sizeof(TClipboardInfo);
      c = Palette->Color[1];
      memcpy(lpData, &c, sizeof(COLORREF));
 	 	  lpData += sizeof(COLORREF);
	    if (!iMainImage->Bitmap->StartScanLine()) { ec = EC_MEMORY_LACK; goto fail; }
     	for (y=0; y<cbi.Height; y++) {
      	bp = iMainImage->Bitmap->GetScanLine(y);
				memcpy(lpData, bp, 2*cbi.Width);
				lpData += 2*cbi.Width;
 	    }
   	  iMainImage->Bitmap->StopScanLine();
     	GlobalUnlock(hMem);
     	GlobalFree(hMem);
 		  SetClipboardData(MainForm->ClipboardFormat, hMem);
    }
	  CloseClipboard();
  }
  Screen->Cursor = cursor;
  return;
fail:
	if (bClipboard) {
	  if (hMem) {
			if (lpData)	{
			  if (WorkArea->Mask) WorkArea->Mask->StopScanLine();
  	    iMainImage->Bitmap->StopScanLine();
      	GlobalUnlock(hMem);
      }
     	GlobalFree(hMem);
  	}
	  CloseClipboard();
  }
  if (WorkArea->Mask) {
		if (dcDst) {
 			if (dcMask) WorkArea->Mask->DeleteDC(dcMask);
 			if (dcSrc) iMainImage->Bitmap->DeleteDC(dcSrc);
	  	L_DeleteLeadDC(dcDst);
 		}
	  L_FreeBitmap(&bh);
 	}
  Screen->Cursor = cursor;
	EXCEPTION_MESSAGE_OK(ec);
}
//----------------------------------------------------------------------------
void __fastcall TMainImageForm::ChangeColor(int i)
{
  int k, m, n, cnt, num = 0;
  TYarnChoice *yarnchoice;
  WORD *yc, bgc;
  TCursor OldCursor;

  if (PaletteForm->DIB256Palette->ChoiceIndex == 1) {
    OldCursor = Screen->Cursor;
    Screen->Cursor = crHourGlass;
    if(Plan->bOld) {
      bgc = RGBToColor15(Palette->ColorData[1]->RGB);
		  if (sbFrontBack->Down) Plan->ChangeBackGroundColorBack(iMainImage->Bitmap, bgc);
		  else Plan->ChangeBackGroundColorFront(iMainImage->Bitmap, bgc);
    } else {
      if (sbFrontBack->Down) Plan->ChangeColorBack(iMainImage->Bitmap, Palette->ColorData[1]->RGB, true);
		  else Plan->ChangeColorFront(iMainImage->Bitmap, Palette->ColorData[1]->RGB, true);
    }
    DrawWarpBar();
		DrawWeftBar();
  	iMainImage->Repaint();
	  FullViewForm->InitForm(iMainImage);
    Screen->Cursor = OldCursor;
  } else {
    if (Plan->Yarn->ChoiceCount > 0) {
        OldCursor = Screen->Cursor;
        Screen->Cursor = crHourGlass;
        yarnchoice = Plan->Yarn->Choice;
    	  for (k = 0; k < Plan->Yarn->ChoiceCount; k++) {
     		  if (yarnchoice[k].Data) {
     			  num += 8*yarnchoice[k].Data->Colors;
          }
        }
        if (Plan->bOld) yc = (WORD *)HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, num*sizeof(WORD));
        num = 0;
    		for (k = 0; k < Plan->Yarn->ChoiceCount; k++) {
      		if (yarnchoice[k].Data) {
      			cnt = yarnchoice[k].Data->Colors;
    				for (m = 0; m < 8; m++) {
        			if (yarnchoice[k].Color[m]) {
            		for (n = 0; n < cnt; n++) {
              		if (i == yarnchoice[k].Color[m][n]->Index) {
                  	yarnchoice[k].Color[m][n]->SetColor(Palette->ColorData[i], i);
                  	yarnchoice[k].Data->Color[n]->SetColor(Palette->ColorData[i]);
                    if (Plan->bOld) yc[num] = (k<<11)|(m<<8)|(n<<3);
                    num++;
                    if (FOnYarnColorChange) FOnYarnColorChange(k, m, n, i);
                	}
              	}
            	}
        		}
      		}
    		}
        DrawWarpBar();
    		DrawWeftBar();
        if (Plan->bOld) {
          if (sbFrontBack->Down) Plan->ChangeColorBack(iMainImage->Bitmap, yc, num);
          else Plan->ChangeColorFront(iMainImage->Bitmap, yc, num);
          HeapFree(GetProcessHeap(), 0, yc);
        } else {
          if (sbFrontBack->Down) Plan->ChangeColorBack(iMainImage->Bitmap, Palette->ColorData[1]->RGB);
          else Plan->ChangeColorFront(iMainImage->Bitmap, Palette->ColorData[1]->RGB);
          if (Plan->WeaveCondition.SuckerEffect) {
             if (Plan->CopyBitmap) delete Plan->CopyBitmap;
             Plan->CopyBitmap = new TTexpiaBitmap;
             Plan->CopyBitmap->Copy(iMainImage->Bitmap, SRCCOPY);
             Plan->Sucking(sbFrontBack->Down);
          }
        }
        iMainImage->Repaint();
        FullViewForm->InitForm(iMainImage);
        Screen->Cursor = OldCursor;
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::RearrangeColor()
{
  int i, k, m, n, cnt, num = 0;
  WORD *yc, bgc;
  TYarnChoice *yarnchoice;

  if (PaletteForm->DIB256Palette->ChoiceIndex == 1) {
    if(Plan->bOld) {
      bgc = RGBToColor15(Palette->ColorData[1]->RGB);
		  if (sbFrontBack->Down) Plan->ChangeBackGroundColorBack(iMainImage->Bitmap, bgc);
  		else Plan->ChangeBackGroundColorFront(iMainImage->Bitmap, bgc);
    } else {
      if (sbFrontBack->Down) Plan->ChangeColorBack(iMainImage->Bitmap, Palette->ColorData[1]->RGB, true);
  		else Plan->ChangeColorFront(iMainImage->Bitmap, Palette->ColorData[1]->RGB, true);
    }
  } else {
    if (Plan->Yarn->ChoiceCount > 0) {
      yarnchoice = Plan->Yarn->Choice;
		  for (k = 0; k < Plan->Yarn->ChoiceCount; k++) {
   		  if (yarnchoice[k].Data) {
   			  num += 8*yarnchoice[k].Data->Colors;
        }
      }
      if (Plan->bOld) yc = (WORD *)HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, num*sizeof(WORD));
      num = 0;
		  for (k = 0; k < Plan->Yarn->ChoiceCount; k++) {
   		  if (yarnchoice[k].Data) {
   			  cnt = yarnchoice[k].Data->Colors;
 				  for (m = 0; m < 8; m++) {
     			  if (yarnchoice[k].Color[m]) {
         		  for (n = 0; n < cnt; n++) {
                i = yarnchoice[k].Color[m][n]->Index;
                yarnchoice[k].Color[m][n]->SetColor(Palette->ColorData[i], i);
                yarnchoice[k].Data->Color[n]->SetColor(Palette->ColorData[i]);
                if (Plan->bOld) yc[num] = (k<<11)|(m<<8)|(n<<3);
                num++;
                if (FOnYarnColorChange) FOnYarnColorChange(k, m, n, i);
              }
      		  }
    		  }
        }
  		}
   	  DrawWarpBar();
      DrawWeftBar();
      if (Plan->bOld) {
        if (sbFrontBack->Down) Plan->ChangeColorBack(iMainImage->Bitmap, yc, num);
        else Plan->ChangeColorFront(iMainImage->Bitmap, yc, num);
        HeapFree(GetProcessHeap(), 0, yc);
      } else {
        if (sbFrontBack->Down) Plan->ChangeColorBack(iMainImage->Bitmap, Palette->ColorData[1]->RGB);
        else Plan->ChangeColorFront(iMainImage->Bitmap, Palette->ColorData[1]->RGB);
        if (Plan->WeaveCondition.SuckerEffect) {
           if (Plan->CopyBitmap) delete Plan->CopyBitmap;
           Plan->CopyBitmap = new TTexpiaBitmap;
           Plan->CopyBitmap->Copy(iMainImage->Bitmap, SRCCOPY);
           Plan->Sucking(sbFrontBack->Down);
        }
      }
  	}
  }
}
//---------------------------------------------------------------------------
// External Function
//---------------------------------------------------------------------------

void __fastcall RepaintImage()
{
	if (MainImageForm) {
	  MainImageForm->iMainImage->Repaint();
    FullViewForm->InitForm(MainImageForm->iMainImage);
  }
}
//---------------------------------------------------------------------

void __fastcall RepaintColor()
{
	if (MainImageForm) {
  	MainImageForm->iMainImage->Repaint();
    FullViewForm->InitForm(MainImageForm->iMainImage);
	  PaletteForm->InitForm(MainImageForm->Palette);
 		ColorLibraryForm->View();
  }
}
//---------------------------------------------------------------------------

void __fastcall RepaintYarnColor()
{
	if (MainImageForm) {
    MainImageForm->RearrangeColor();
  	MainImageForm->iMainImage->Repaint();
    FullViewForm->InitForm(MainImageForm->iMainImage);
	  PaletteForm->InitForm(MainImageForm->Palette);
 		ColorLibraryForm->View();
  }
}
//---------------------------------------------------------------------------

void __fastcall TMainImageForm::ApplyEnvironment()
{
  TIniFile *IniFile = new TIniFile(DirectoryItem+"\\Environment.ini");
  if (IniFile) {
    WorkArea->undoMax = IniFile->ReadInteger("Window", "MaxUndo", 5);
    delete IniFile;
  }
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::FormKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
  if(TextureDesignForm) TextureDesignForm->FormKeyDown(this, Key, Shift); //  Ű
  if (Key == 13 && MainMenuForm->YarnMakerStart == 1)YarnDesignForm->MakeButtonClick(this);  //lhskys YarnDesign  ͷ ϱ 
  if(WeavingForm)
   if (Key == 13 && WeavingForm->btnOK->Enabled)WeavingForm->btnOKClick(this);                //lhskys Weaving  ͷ ϱ
  int Ratio;
   if(Key == 65){        //'a' 
     switch (iMainImage->ZoomIn) {
  	    case 1: switch (iMainImage->ZoomOut) {
      	           case 1: Ratio = 2 ;  break;
		               case 2: Ratio = 1;  break;
  		             case 4: Ratio = 12;  break;
		               case 8: Ratio = 14;  break;
  		             case 16: Ratio = 18; break;
                }
                break;
        case 2: Ratio = 4; break;
  	    case 4: Ratio = 8; break;
  	    case 8: Ratio = 16; break;
     }
     RatioZoom(Ratio);
   }
   if(Key == 83){         // 's'
     switch (iMainImage->ZoomIn) {
  	    case 1: switch (iMainImage->ZoomOut) {
      	           case 1: Ratio = 12 ;  break;
		               case 2: Ratio = 14;  break;
  		             case 4: Ratio = 18;  break;
		               case 8: Ratio = 116;  break;
                }
                break;
        case 2: Ratio = 1; break;
  	    case 4: Ratio = 2; break;
  	    case 8: Ratio = 4; break;
        case 16 : Ratio = 8; break;
     }
     RatioZoom(Ratio);
   }
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::RatioZoom(int r)       //by qe
{
  GetCursorPos(&ptScreen);
  switch (r){
     case 116 : ZoomChange(1, 16, &ptScreen);  break;
     case 18  : ZoomChange(1, 8, &ptScreen);   break;
     case 14  : ZoomChange(1, 4, &ptScreen);   break;
     case 12  : ZoomChange(1, 2, &ptScreen);   break;
     case 1   : ZoomChange(1, 1, &ptScreen);  break;
     case 2   : ZoomChange(2, 1, &ptScreen);  break;
     case 4   : ZoomChange(4, 1, &ptScreen);  break;
     case 8   : ZoomChange(8, 1, &ptScreen);  break;
     case 16  : ZoomChange(16, 1, &ptScreen); break;
  }
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::sbCrossLineClick(TObject *Sender)
{
  if (sbCrossLine->Down) {                            //  for CrossLine
    MainImageForm->iMainImage->Cross = true;          //  by playzzang
    MainImageForm->iMainImage->CrossLine = true;
    MainImageForm->iMainImage->OnPaintCrossLine=PaintCrossLine;
  } else {
    MainImageForm->iMainImage->Cross = false;
    MainImageForm->iMainImage->CrossLine = false;
    MainImageForm->iMainImage->OnPaintCrossLine=NULL;
  }
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::PaintLineLocate(TObject *Sender, HDC formDC)
{
//  HDC formDC;
  HBRUSH hOldBrush;
  HPEN hOldPen;
  int nDrawMode;
  int NOL=NumberOfLine;

  hOldBrush = SelectObject(formDC, GetStockObject(NULL_BRUSH));
  nDrawMode = GetROP2(formDC);

  hOldPen = SelectObject(formDC, GetStockObject(BLACK_PEN));
  SetROP2(formDC, R2_NOT);
//  formDC = iMainImage->Canvas->Handle;

  POINT pt;
  POINT First;
  POINT Second;
  LineListData *line;
  for(int i=0;i<NOL;i++){
    line=(LineListData *)LineList->Items[i];
    First=line->First;
    Second=line->Second;
    pt.x = iMainImage->BitmapToCanvasX(First.x);
  	pt.y = iMainImage->BitmapToCanvasY(First.y);
    MoveToEx(formDC, pt.x, pt.y, NULL);
    pt.x = iMainImage->BitmapToCanvasX(Second.x);
    pt.y = iMainImage->BitmapToCanvasY(Second.y);
    LineTo(formDC, pt.x, pt.y);
  }

  SetROP2(formDC, nDrawMode);

  SelectObject(formDC, hOldBrush);
  SelectObject(formDC, hOldPen);

}
//---------------------------------------------------------------------------


void __fastcall TMainImageForm::DrawLineLocate(POINT First, POINT Second, int NOL)
{

  NumberOfLine=NOL;
  static RECT oldlines=Rect(0,0,0,0);
  if(NOL==0) {
    LineList->Clear();
    iMainImage->OnPaintLocate = NULL;
    InvalidateRect(iMainImage->Parent->Handle,&oldlines,false);
  } else {
    iMainImage->OnPaintLocate = PaintLineLocate;/////////////////by jeegeo
    LineListData *line=new LineListData;
    static int cnt = 0;
    if(cnt==0)LineList->Clear();
    cnt++;
    line->First=First;
    line->Second=Second;
    LineList->Add(line);

    if(NOL==cnt) {
      cnt=0;
      line=(LineListData *)LineList->Items[0];
      int minx,miny,maxx,maxy;
      minx = iMainImage->BitmapToCanvasX(min( line->First.x, line->Second.x ));
      maxx = iMainImage->BitmapToCanvasX(max( line->First.x, line->Second.x ));
      miny = iMainImage->BitmapToCanvasY(min( line->First.y, line->Second.y ));
      maxy = iMainImage->BitmapToCanvasY(max( line->First.y, line->Second.y ));
      for(int i=1;i<NOL;i++){
        line=(LineListData *)LineList->Items[i];
        minx = min(minx,iMainImage->BitmapToCanvasX(min(line->First.x,line->Second.x)));
        maxx = max(maxx,iMainImage->BitmapToCanvasX(max(line->First.x,line->Second.x)));
        miny = min(miny,iMainImage->BitmapToCanvasY(min(line->First.y,line->Second.y)));
        maxy = max(maxy,iMainImage->BitmapToCanvasY(max(line->First.y,line->Second.y)));
      }
      RECT rc = {minx-1,miny-1,maxx+1,maxy+1};

    #if defined(TEXTILE)
      #if defined(CARPET)
      InvalidateRect(iMainImage->Parent->Handle,&oldlines,false);
      InvalidateRect(iMainImage->Parent->Handle,&rc,false);
      #else
      #endif
    #else
      InvalidateRect(iMainImage->Parent->Handle,&oldlines,false);
      InvalidateRect(iMainImage->Parent->Handle,&rc,false);
    #endif

      oldlines=rc;
    }
  }
}

//---------------------------------------------------------------------------
void __fastcall TMainImageForm::PaintFreeLineLocate(TObject *Sender, HDC formDC)
{
//  HDC formDC;
  HBRUSH hOldBrush;
  HPEN hOldPen;
  int nDrawMode;
//  int NOL=NumberOfLine;
  hOldBrush = SelectObject(formDC, GetStockObject(NULL_BRUSH));
  nDrawMode = GetROP2(formDC);

  hOldPen = SelectObject(formDC, GetStockObject(BLACK_PEN));
  SetROP2(formDC, R2_NOT);

//  formDC = iMainImage->Canvas->Handle;

  POINT pt;
  POINT First;
  POINT Second;
  LineListData *line;

  if(LineList->Count>0){
    line=(LineListData *)LineList->Items[0];
    Second=line->Second;
    pt.x = iMainImage->BitmapToCanvasX(Second.x);
  	pt.y = iMainImage->BitmapToCanvasY(Second.y);
    MoveToEx(formDC, pt.x, pt.y, NULL);
  }
  for(int i=1;i<LineList->Count;i++){
    line=(LineListData *)LineList->Items[i];
    First=line->First;
    Second=line->Second;
    pt.x = iMainImage->BitmapToCanvasX(First.x);
  	pt.y = iMainImage->BitmapToCanvasY(First.y);
    MoveToEx(formDC, pt.x, pt.y, NULL);
    pt.x = iMainImage->BitmapToCanvasX(Second.x);
    pt.y = iMainImage->BitmapToCanvasY(Second.y);
    LineTo(formDC, pt.x, pt.y);
  }

  SetROP2(formDC, nDrawMode);
  SelectObject(formDC, hOldBrush);
  SelectObject(formDC, hOldPen);

}
//---------------------------------------------------------------------------

void __fastcall TMainImageForm::DrawFreeLineLocate(POINT Second, int resetCount)
{

  static RECT oldlines=Rect(0,0,0,0);
  static POINT First = Second;
  if(resetCount==0) {
    First=Second;
    LineList->Clear();
    iMainImage->OnPaintLocate = NULL;
    InvalidateRect(iMainImage->Parent->Handle,&oldlines,false);

  } else {
    iMainImage->OnPaintLocate = PaintFreeLineLocate;/////////////////by jeegeo

    LineListData *line;
    if(resetCount==-1||resetCount==-2){
      line=new LineListData;
      line->First=First;
      line->Second=Second;
      LineList->Add(line);
      First=Second;
    } else {
      while(LineList->Count>resetCount){
        line = (LineListData *)LineList->Last();
        LineList->Remove(line);
      }
      First= ((LineListData *)LineList->Last())->Second;
    }

    line=(LineListData *)LineList->Items[0];
    int minx,miny,maxx,maxy;
    minx = iMainImage->BitmapToCanvasX(min( line->First.x, line->Second.x ));
    maxx = iMainImage->BitmapToCanvasX(max( line->First.x, line->Second.x ));
    miny = iMainImage->BitmapToCanvasY(min( line->First.y, line->Second.y ));
    maxy = iMainImage->BitmapToCanvasY(max( line->First.y, line->Second.y ));
    for(int i=1;i<LineList->Count;i++){
      line=(LineListData *)LineList->Items[i];
      minx = min(minx,iMainImage->BitmapToCanvasX(min(line->First.x,line->Second.x)));
      maxx = max(maxx,iMainImage->BitmapToCanvasX(max(line->First.x,line->Second.x)));
      miny = min(miny,iMainImage->BitmapToCanvasY(min(line->First.y,line->Second.y)));
      maxy = max(maxy,iMainImage->BitmapToCanvasY(max(line->First.y,line->Second.y)));
    }
    RECT rc = {minx-1,miny-1,maxx+1,maxy+1};

    if(resetCount!=-2){

    #if defined(TEXTILE)
      #if defined(CARPET)
      InvalidateRect(iMainImage->Parent->Handle,&oldlines,false);
      InvalidateRect(iMainImage->Parent->Handle,&rc,false);
      #else
      #endif
    #else
      InvalidateRect(iMainImage->Parent->Handle,&oldlines,false);
      InvalidateRect(iMainImage->Parent->Handle,&rc,false);
    #endif
    }

    oldlines=rc;
  }
}

//---------------------------------------------------------------------------

void __fastcall TMainImageForm::DrawRectangleLocate(RECT rc,int NOR)
{
  static RECT oldrc=Rect(0,0,0,0);
  if(NOR==0) {
    iMainImage->OnPaintLocate = NULL;
    InvalidateRect(iMainImage->Parent->Handle,&oldrc,false);
  }
	else {
    iMainImage->OnPaintLocate = PaintRectangleLocate;/////////////////by jeegeo
    FloatingRect.left = iMainImage->BitmapToCanvasX(min(rc.left,rc.right));
    FloatingRect.right = iMainImage->BitmapToCanvasX(max(rc.left,rc.right));
    FloatingRect.top = iMainImage->BitmapToCanvasY(min(rc.top,rc.bottom));
    FloatingRect.bottom = iMainImage->BitmapToCanvasY(max(rc.top,rc.bottom));

    #if defined(TEXTILE)
      #if defined(CARPET)
      InvalidateRect(iMainImage->Parent->Handle,&oldrc,false);
      InvalidateRect(iMainImage->Parent->Handle,&FloatingRect,false);
      #else
      #endif
    #else
      InvalidateRect(iMainImage->Parent->Handle,&oldrc,false);
      InvalidateRect(iMainImage->Parent->Handle,&FloatingRect,false);
    #endif

    oldrc=FloatingRect;
  }
}
//---------------------------------------------------------------------------


void __fastcall TMainImageForm::PaintRectangleLocate(TObject *Sender, HDC formDC)
{

  RECT rc = FloatingRect;
//  HDC formDC;
  HBRUSH hOldBrush;
  HPEN hOldPen;
  int nDrawMode;

  hOldBrush = SelectObject(formDC, GetStockObject(NULL_BRUSH));
  nDrawMode = GetROP2(formDC);

  hOldPen = SelectObject(formDC, GetStockObject(BLACK_PEN));
  SetROP2(formDC, R2_NOT);

//  formDC = iMainImage->Canvas->Handle;

  Rectangle(formDC, min(rc.left, rc.right)+1, min(rc.top, rc.bottom)+1,
    max(rc.left, rc.right), max(rc.top, rc.bottom));
  SetROP2(formDC, nDrawMode);
  SelectObject(formDC, hOldBrush);
  SelectObject(formDC, hOldPen);
}

//---------------------------------------------------------------------------

void __fastcall TMainImageForm::DrawEllipseLocate(RECT rc,int NOE)
{
  static RECT oldrc=Rect(0,0,0,0);
  if(NOE==0) {
    iMainImage->OnPaintLocate = NULL;
    InvalidateRect(iMainImage->Parent->Handle,&oldrc,false);
  }
	else {
    iMainImage->OnPaintLocate = PaintEllipseLocate;/////////////////by jeegeo
    FloatingRect.left = iMainImage->BitmapToCanvasX(min(rc.left,rc.right));
    FloatingRect.right = iMainImage->BitmapToCanvasX(max(rc.left,rc.right));
    FloatingRect.top = iMainImage->BitmapToCanvasY(min(rc.top,rc.bottom));
    FloatingRect.bottom = iMainImage->BitmapToCanvasY(max(rc.top,rc.bottom));

    #if defined(TEXTILE)
      #if defined(CARPET)
      InvalidateRect(iMainImage->Parent->Handle,&oldrc,false);
      InvalidateRect(iMainImage->Parent->Handle,&FloatingRect,false);
      #else
      #endif
    #else
      InvalidateRect(iMainImage->Parent->Handle,&oldrc,false);
      InvalidateRect(iMainImage->Parent->Handle,&FloatingRect,false);
    #endif

    oldrc=FloatingRect;
  }
}
//---------------------------------------------------------------------------


void __fastcall TMainImageForm::PaintEllipseLocate(TObject *Sender, HDC formDC)
{

  RECT rc = FloatingRect;
//  HDC formDC;
  HBRUSH hOldBrush;
  HPEN hOldPen;
  int nDrawMode;

  hOldBrush = SelectObject(formDC, GetStockObject(NULL_BRUSH));
  nDrawMode = GetROP2(formDC);

  hOldPen = SelectObject(formDC, GetStockObject(BLACK_PEN));
  SetROP2(formDC, R2_NOT);

//  formDC = iMainImage->Canvas->Handle;
  Ellipse(formDC, min(rc.left, rc.right)+1, min(rc.top, rc.bottom)+1,
    max(rc.left, rc.right), max(rc.top, rc.bottom));
  SetROP2(formDC, nDrawMode);
  SelectObject(formDC, hOldBrush);
  SelectObject(formDC, hOldPen);
}

//---------------------------------------------------------------------------
void __fastcall TMainImageForm::DrawArcLocate(POINT center2, double LRadius2, double SRadius2,
    double angleS2, double angleE2, bool isFan2, bool isClosed2, int NOA) {
                                              //////isFan true̸ fan̰ false̸ tube̴
  center=center2;                             //////tube SRadius Ʃ    ̴
  LRadius=LRadius2;                           //////angleS 氢̰
  SRadius=SRadius2;                           //////angleE ̴
  angleS=angleS2;
  angleE=angleE2;
  isFan=isFan2;
  isClosed=isClosed2;

  RECT rc = Rect(center.x-LRadius-SRadius,center.y-LRadius-SRadius,
    center.x+LRadius+SRadius,center.y+LRadius+SRadius);
  static RECT oldrc=Rect(0,0,0,0);
  if(NOA==0) {
    iMainImage->OnPaintLocate = NULL;
    InvalidateRect(iMainImage->Parent->Handle,&oldrc,false);
  }
	else {
    iMainImage->OnPaintLocate = PaintArcLocate;/////////////////by jeegeo
    FloatingRect.left = iMainImage->BitmapToCanvasX(min(rc.left,rc.right));
    FloatingRect.right = iMainImage->BitmapToCanvasX(max(rc.left,rc.right));
    FloatingRect.top = iMainImage->BitmapToCanvasY(min(rc.top,rc.bottom));
    FloatingRect.bottom = iMainImage->BitmapToCanvasY(max(rc.top,rc.bottom));

    #if defined(TEXTILE)
      #if defined(CARPET)
      InvalidateRect(iMainImage->Parent->Handle,&oldrc,false);
      InvalidateRect(iMainImage->Parent->Handle,&FloatingRect,false);
      #else
      #endif
    #else
      InvalidateRect(iMainImage->Parent->Handle,&oldrc,false);
      InvalidateRect(iMainImage->Parent->Handle,&FloatingRect,false);
    #endif

    oldrc=FloatingRect;
  }
}
//---------------------------------------------------------------------------


void __fastcall TMainImageForm::PaintArcLocate(TObject *Sender, HDC formDC) /////by jeegeo
{

  RECT rc,rr;
  POINT p,ps,pe;
//  HDC formDC;
  HBRUSH hOldBrush;
  HPEN hOldPen;
  int nDrawMode;

  hOldBrush = SelectObject(formDC, GetStockObject(NULL_BRUSH));
  nDrawMode = GetROP2(formDC);

  hOldPen = SelectObject(formDC, GetStockObject(BLACK_PEN));
  SetROP2(formDC, R2_NOT);

//  formDC = iMainImage->Canvas->Handle;

  if(isFan){
    rc = Rect(center.x - LRadius,center.y - LRadius,
      center.x + LRadius,center.y + LRadius);
    rr.left = iMainImage->BitmapToCanvasX(rc.left);
	  rr.top = iMainImage->BitmapToCanvasY(rc.top);
    rr.right = iMainImage->BitmapToCanvasX(rc.right);
	  rr.bottom = iMainImage->BitmapToCanvasY(rc.bottom);
    p = Point(center.x+cos(angleS)*LRadius,center.y-sin(angleS)*LRadius);
    ps.x = iMainImage->BitmapToCanvasX(p.x);
  	ps.y = iMainImage->BitmapToCanvasY(p.y);
    p = Point(center.x+cos(angleE)*LRadius,center.y-sin(angleE)*LRadius);
    pe.x = iMainImage->BitmapToCanvasX(p.x);
	  pe.y = iMainImage->BitmapToCanvasY(p.y);

    Arc(formDC,rr.left,rr.top,rr.right,rr.bottom,ps.x,ps.y,pe.x,pe.y);

    rc = Rect(center.x - SRadius,center.y - SRadius,
      center.x + SRadius,center.y + SRadius);
    rr.left = iMainImage->BitmapToCanvasX(rc.left);
	  rr.top = iMainImage->BitmapToCanvasY(rc.top);
    rr.right = iMainImage->BitmapToCanvasX(rc.right);
	  rr.bottom = iMainImage->BitmapToCanvasY(rc.bottom);
    p = Point(center.x+cos(angleS)*SRadius,center.y-sin(angleS)*SRadius);
    ps.x = iMainImage->BitmapToCanvasX(p.x);
  	ps.y = iMainImage->BitmapToCanvasY(p.y);
    p = Point(center.x+cos(angleE)*SRadius,center.y-sin(angleE)*SRadius);
    pe.x = iMainImage->BitmapToCanvasX(p.x);
	  pe.y = iMainImage->BitmapToCanvasY(p.y);

    Arc(formDC,rr.left,rr.top,rr.right,rr.bottom,ps.x,ps.y,pe.x,pe.y);

    if(isClosed) {                                       /////////Arc ݴ  ׸
      p = Point(center.x+cos(angleS)*LRadius,center.y-sin(angleS)*LRadius);
      p.x = iMainImage->BitmapToCanvasX(p.x);
  	  p.y = iMainImage->BitmapToCanvasY(p.y);
      MoveToEx(formDC,p.x,p.y,NULL);
      p = Point(center.x+cos(angleS)*SRadius,center.y-sin(angleS)*SRadius);
      p.x = iMainImage->BitmapToCanvasX(p.x);
  	  p.y = iMainImage->BitmapToCanvasY(p.y);
      LineTo(formDC,p.x,p.y);

      p = Point(center.x+cos(angleE)*LRadius,center.y-sin(angleE)*LRadius);
      p.x = iMainImage->BitmapToCanvasX(p.x);
    	p.y = iMainImage->BitmapToCanvasY(p.y);
      MoveToEx(formDC,p.x,p.y,NULL);
      p = Point(center.x+cos(angleE)*SRadius,center.y-sin(angleE)*SRadius);
      p.x = iMainImage->BitmapToCanvasX(p.x);
    	p.y = iMainImage->BitmapToCanvasY(p.y);
      LineTo(formDC,p.x,p.y);
    }
  } else {
    rc = Rect(center.x - LRadius,center.y - LRadius,
      center.x + LRadius,center.y + LRadius);
    rr.left = iMainImage->BitmapToCanvasX(rc.left);
	  rr.top = iMainImage->BitmapToCanvasY(rc.top);
    rr.right = iMainImage->BitmapToCanvasX(rc.right);
	  rr.bottom = iMainImage->BitmapToCanvasY(rc.bottom);
    p = Point(center.x+cos(angleS)*LRadius,center.y-sin(angleS)*LRadius);
    ps.x = iMainImage->BitmapToCanvasX(p.x);
  	ps.y = iMainImage->BitmapToCanvasY(p.y);
    p = Point(center.x+cos(angleE)*LRadius,center.y-sin(angleE)*LRadius);
    pe.x = iMainImage->BitmapToCanvasX(p.x);
	  pe.y = iMainImage->BitmapToCanvasY(p.y);

    Arc(formDC,rr.left,rr.top,rr.right,rr.bottom,ps.x,ps.y,pe.x,pe.y);

    double midAngle=(angleS+angleE)/2.0;
    float ratio=(float)iMainImage->ZoomIn/(float)iMainImage->ZoomOut;
    POINT plus = Point(-SRadius*cos(midAngle)*ratio,SRadius*sin(midAngle)*ratio);

    rc = Rect(center.x - LRadius,center.y - LRadius,
      center.x + LRadius,center.y + LRadius);
    rr.left = iMainImage->BitmapToCanvasX(rc.left);
	  rr.top = iMainImage->BitmapToCanvasY(rc.top);
    rr.right = iMainImage->BitmapToCanvasX(rc.right);
	  rr.bottom = iMainImage->BitmapToCanvasY(rc.bottom);
    p = Point(center.x+cos(angleS)*LRadius,center.y-sin(angleS)*LRadius);
    ps.x = iMainImage->BitmapToCanvasX(p.x);
  	ps.y = iMainImage->BitmapToCanvasY(p.y);
    p = Point(center.x+cos(angleE)*LRadius,center.y-sin(angleE)*LRadius);
    pe.x = iMainImage->BitmapToCanvasX(p.x);
	  pe.y = iMainImage->BitmapToCanvasY(p.y);

    Arc(formDC,rr.left+plus.x,rr.top+plus.y,rr.right+plus.x,rr.bottom+plus.y,
      ps.x+plus.x,ps.y+plus.y,pe.x+plus.x,pe.y+plus.y);

    if(isClosed) {                                       /////////Arc ݴ  ׸
      p = Point(center.x+cos(angleS)*LRadius,center.y-sin(angleS)*LRadius);
      p.x = iMainImage->BitmapToCanvasX(p.x);
  	  p.y = iMainImage->BitmapToCanvasY(p.y);
      MoveToEx(formDC,p.x,p.y,NULL);
      LineTo(formDC,p.x+plus.x,p.y+plus.y);

      p = Point(center.x+cos(angleE)*LRadius,center.y-sin(angleE)*LRadius);
      p.x = iMainImage->BitmapToCanvasX(p.x);
    	p.y = iMainImage->BitmapToCanvasY(p.y);
      MoveToEx(formDC,p.x,p.y,NULL);
      LineTo(formDC,p.x+plus.x,p.y+plus.y);
    }

  }


  SetROP2(formDC, nDrawMode);
  SelectObject(formDC, hOldBrush);
  SelectObject(formDC, hOldPen);
}

//---------------------------------------------------------------------------
void __fastcall TMainImageForm::PaintCrossLine(TObject *Sender, HDC formDC)
{
  HPEN hOldPen;
  HBRUSH hOldBrush;
  int nDrawMode;
  POINT cp=iMainImage->GetCrossPos();
  RGBQUAD rgb;

  hOldBrush = SelectObject(formDC, GetStockObject(NULL_BRUSH));
  nDrawMode = GetROP2(formDC);

  hOldPen = SelectObject(formDC, GetStockObject(BLACK_PEN));
  SetROP2(formDC, R2_NOT);

  #ifdef WEAVE
  MoveToEx(formDC, cp.x, iMainImage->Parent->Top-30, NULL);
  LineTo(formDC, cp.x, iMainImage->Parent->Top + iMainImage->Parent->Height);
  MoveToEx(formDC, iMainImage->Parent->Left-30, cp.y, NULL);
  LineTo(formDC, iMainImage->Parent->Left + iMainImage->Parent->Width, cp.y);
  #else
  MoveToEx(formDC, cp.x, iMainImage->Parent->Top, NULL);
  LineTo(formDC, cp.x, iMainImage->Parent->Top + iMainImage->Parent->Height);
  MoveToEx(formDC, iMainImage->Parent->Left, cp.y, NULL);
  LineTo(formDC, iMainImage->Parent->Left + iMainImage->Parent->Width, cp.y);
  #endif

  SetROP2(formDC, nDrawMode);
  SelectObject(formDC, hOldBrush);
  SelectObject(formDC, hOldPen);

}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::PaintDirectly(HDC dcDst, int px, int py, int vw, int vh){

  if(!isPaintDirectlyClean){
    if(!isFirst){
      if(iMainImage->OnPaintCursor) iMainImage->OnPaintCursor(iMainImage,dcDst,Pen.x,Pen.y);
      if(iMainImage->OnPaintCrossLine) iMainImage->OnPaintCrossLine(iMainImage,dcDst);
    }
    if(iMainImage->OnPaintZoom) iMainImage->OnPaintZoom(iMainImage, dcDst);
    if(iMainImage->OnPaintLocate) iMainImage->OnPaintLocate(iMainImage, dcDst);
  }

}
//---------------------------------------------------------------------------
int __fastcall TMainImageForm::GetLineListCount(void){
  return LineList->Count;
}
//---------------------------------------------------------------------------
void __fastcall TMainImageForm::ResetDraw(bool repaint){

  iMainImage->OnPaintLocate=NULL;
  LineList->Clear();
  FloatingRect=Rect(0,0,0,0);
  NumberOfLine=0;
  center=Point(0,0);
  SRadius=0;LRadius=0;angleS=0;angleE=0;
  isClosed=false;isFan=true;
  if(repaint)iMainImage->Repaint();
}
//------------------------------------------------------------------------------lhskys
void __fastcall TMainImageForm::Extractdensity(int Index, int i)
{
	TYarnArray *pd;
  int cnt = Plan->Yarn->PData[i]->Count, l;
  if (cnt) {
  	for (int m = 0; m < cnt; m++) {
    	pd = (TYarnArray *)Plan->Yarn->PData[i]->Items[m];
      if (Index == pd->code) {
            int j, k, method1;
            method1 = 0;
            int repeat1;                                                   //Center ϶ repeat ˱
            if(pd->method == 2){
              if (CurrentUnit == uCm) {
                tDen = pd->density / 2.54;
              } else {
                tDen = pd->density;
              }
              wasum += tDen*pd->repeat;
              densityCnt += 1*pd->repeat;
              repeat1 = pd->repeat;
              for (j=m-1;j>-1;j--){
                pd = (TYarnArray *)Plan->Yarn->PData[i]->Items[j];
                if (pd->method == 1){
                  if (CurrentUnit == uCm) {
                    tDen = pd->density / 2.54;
                  } else {
                    tDen = pd->density;
                  }
                  wasum += tDen*(repeat1*2 - 1);
                  densityCnt += 1*(repeat1*2 - 1);
                  method1 = 1;                                       //reverse Ȯ ƴϸ nomal  Ͽ ϱ⶧
                }else j = -1;
              }
              for (k=m-1;k>-1;k--){
                pd = (TYarnArray *)Plan->Yarn->PData[i]->Items[k];
                if (method1 == 0){
                  if (CurrentUnit == uCm) {
                    tDen = pd->density / 2.54;
                  } else {
                    tDen = pd->density;
                  }
                  wasum += tDen*(repeat1 - 1);
                  densityCnt += 1*(repeat1 - 1);
                }else k = -1;
              }
            }else {
              if (CurrentUnit == uCm) {
                tDen = pd->density / 2.54;
              } else {
                tDen = pd->density;
              }
              wasum += tDen*pd->repeat;
              densityCnt += 1*pd->repeat;
            }
      }
    }
  }
}
//------------------------------------------------------------------------------ lhskys
void __fastcall TMainImageForm::Extractdensity1(int Index, int i)
{
	TYarnArray *pd;
  int cnt = Plan->Yarn->PData[i]->Count, l;
  if (cnt) {
  	for (int m = 0; m < cnt; m++) {
    	pd = (TYarnArray *)Plan->Yarn->PData[i]->Items[m];
      if (Index == pd->code) {
            int j, k, method1;
            method1 = 0;
            int repeat1;                                                   //Center ϶ repeat ˱
            if(pd->method == 2){
              if (CurrentUnit == uCm) {
                tDen1 = pd->density / 2.54;
              } else {
                tDen1 = pd->density;
              }
              wasum1 += tDen1*pd->repeat;
              densityCnt1 += 1*pd->repeat;
              repeat1 = pd->repeat;
              for (j=m-1;j>-1;j--){
                pd = (TYarnArray *)Plan->Yarn->PData[i]->Items[j];
                if (pd->method == 1){
                  if (CurrentUnit == uCm) {
                    tDen1 = pd->density / 2.54;
                  } else {
                    tDen1 = pd->density;
                  }
                  wasum1 += tDen1*(repeat1*2 - 1);
                  densityCnt1 += 1*(repeat1*2 - 1);
                  method1 = 1;                                       //reverse Ȯ ƴϸ nomal  Ͽ ϱ⶧
                }else j = -1;
              }
              for (k=m-1;k>-1;k--){
                pd = (TYarnArray *)Plan->Yarn->PData[i]->Items[k];
                if (method1 == 0){
                  if (CurrentUnit == uCm) {
                    tDen1 = pd->density / 2.54;
                  } else {
                    tDen1 = pd->density;
                  }
                  wasum1 += tDen1*(repeat1 - 1);
                  densityCnt1 += 1*(repeat1 - 1);
                }else k = -1;
              }
            }else {
              if (CurrentUnit == uCm) {
                tDen1 = pd->density / 2.54;
              } else {
                tDen1 = pd->density;
              }
              wasum1 += tDen1*pd->repeat;
              densityCnt1 += 1*pd->repeat;
            }
      }
    }
  }
}
//----------------------------------------------------------------------------
void __fastcall TMainImageForm::DrawMemo(TTexpiaBitmap *Pattern, int H, bool IsJi)
{
  int tsx, tsy, tex, tey;
  AnsiString str;
  TCanvas *Canvas = NULL;
  Canvas = Pattern->CreateCanvas();
  tsx = 10;
  tex = Pattern->Width - 1 - 10;
  tsy = H + 40;
  tey = tsy + 120;
  Canvas->Font->Size = 12;
  Canvas->Font->Color = clBlack;
  Canvas->Rectangle(tsx, tsy, tex, tey);
  if (IsJi == true) {
     for (int i = 0; i < Plan->ProductStringData.Ji->Count; i++){
        str = Plan->ProductStringData.Ji->Strings[i];
        Canvas->TextOut(tsx+10, tsy+i*40+10, str);
     }
  } else {
     for (int i = 0; i < Plan->ProductStringData.Attention->Count; i++){
        str = Plan->ProductStringData.Attention->Strings[i];
        Canvas->TextOut(tsx+10, tsy+i*40+10, str);
     }
  }
  Pattern->DeleteCanvas(Canvas);
}
//----------------------------------------------------------------------------
