//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "NewProductData.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TNewProductDataForm *NewProductDataForm;
//---------------------------------------------------------------------------
__fastcall TNewProductDataForm::TNewProductDataForm(TComponent* Owner)
 : TForm(Owner)
{

}
//---------------------------------------------------------------------------

void __fastcall TNewProductDataForm::FormCreate(TObject *Sender)
{
  WriteText();
  if (MainImageForm->Plan->Finish) {
     for (int i = 0; i < 2; i++) {
        TotalCnt[i] = 0;
        TotalLen[i] = 0;
     }
     MainImageForm->Plan->GetProductDataB(0, TotalCnt[0], TotalLen[0]); //warp
     MainImageForm->Plan->GetProductDataB(1, TotalCnt[1], TotalLen[1]); //weft
     WarpDensity = TotalCnt[0]/TotalLen[0];
     InitStringGrid();
     ArrangeProductStringData();
     if (edWeft->Text == "0") edWeft->Text = Format("%.2f", OPENARRAY(TVarRec,(TotalCnt[1]/TotalLen[1])));
  }
}
//---------------------------------------------------------------------------
void __fastcall TNewProductDataForm::WriteText()
{
  int Row, Col, i;
  AnsiString str, strCode, strYarns;
  sgWarp->ColWidths[0] = 24;      sgWeft->ColWidths[0] = 24;
  sgWarp->ColWidths[1] = 48;      sgWeft->ColWidths[1] = 48;
  sgWarp->ColWidths[2] = 48;      sgWeft->ColWidths[2] = 48;
  sgWarp->ColWidths[3] = 48;      sgWeft->ColWidths[3] = 48;
  sgWarp->ColWidths[4] = 48;      sgWeft->ColWidths[4] = 48;
  sgWarp->ColWidths[5] = 48;      sgWeft->ColWidths[5] = 48;
  sgWarp->ColWidths[6] = 248;     sgWeft->ColWidths[6] = 248;
  sgWarp->ColWidths[7] = 56;      sgWeft->ColWidths[7] = 56;

  for (Row = 0; Row < sgWarp->RowCount; Row++) {
     if (Row == 0) {
        for (Col = 0; Col < sgWarp->ColCount; Col++) {
           switch (Col) {
              case 0: str = "";              break;
              case 1: str = "Code";          break;
              case 2: str = "Kind";          break;
              case 3: str = "Yarn No.";      break;
              case 4: str = "Count";         break;
              case 5: str = "Color";         break;
              case 6: str = "Array Order";   break;
              case 7: str = "Weight";        break;
           }
           sgWarp->Cells[Col][Row] = str;
        }
     } else {
        sgWarp->Cells[0][Row] = AnsiString(char(64+Row));   //65--->A, 66---->B,...
     }
  }

  for (Row = 0; Row < sgWeft->RowCount; Row++) {
     if (Row == 0) {
        for (Col = 0; Col < sgWeft->ColCount; Col++) {
           switch (Col) {
              case 0: str = "";              break;
              case 1: str = "Code";          break;
              case 2: str = "Kind";          break;
              case 3: str = "Yarn No.";      break;
              case 4: str = "Count";         break;
              case 5: str = "Color";         break;
              case 6: str = "Array Order";   break;
              case 7: str = "Weight";        break;
           }
           sgWeft->Cells[Col][Row] = str;
        }
     } else {
        sgWeft->Cells[0][Row] = AnsiString(char(64+Row));   //65--->A, 66---->B,...
     }
  }

}
//-----------------------------------------------------------------------------
void __fastcall TNewProductDataForm::InitStringGrid()
{
  int Row, Col, i, x;
  AnsiString str, strCode, strYarns;

  for (Row = 0; Row < MainImageForm->Plan->ProductArray[0]->Count; Row++) {
     sgWarp->Cells[1][Row+1] = IntToStr(((ProductInfo *)MainImageForm->Plan->ProductArray[0]->Items[Row])->Code);
     sgWarp->Cells[2][Row+1] = ((ProductInfo *)MainImageForm->Plan->ProductArray[0]->Items[Row])->Kind;
     sgWarp->Cells[3][Row+1] = ((ProductInfo *)MainImageForm->Plan->ProductArray[0]->Items[Row])->YarnNo;
     sgWarp->Cells[4][Row+1] = IntToStr(((ProductInfo *)MainImageForm->Plan->ProductArray[0]->Items[Row])->Count);
     sgWarp->Cells[5][Row+1] = ((ProductInfo *)MainImageForm->Plan->ProductArray[0]->Items[Row])->Color;
     sgWarp->Cells[7][Row+1] = ((ProductInfo *)MainImageForm->Plan->ProductArray[0]->Items[Row])->Weight;
  }
  for (Row = 0; Row < MainImageForm->Plan->ProductArray[1]->Count; Row++) {
     sgWeft->Cells[1][Row+1] = IntToStr(((ProductInfo *)MainImageForm->Plan->ProductArray[1]->Items[Row])->Code);
     sgWeft->Cells[2][Row+1] = ((ProductInfo *)MainImageForm->Plan->ProductArray[1]->Items[Row])->Kind;
     sgWeft->Cells[3][Row+1] = ((ProductInfo *)MainImageForm->Plan->ProductArray[1]->Items[Row])->YarnNo;
     sgWeft->Cells[4][Row+1] = IntToStr(((ProductInfo *)MainImageForm->Plan->ProductArray[1]->Items[Row])->Count);
     sgWeft->Cells[5][Row+1] = ((ProductInfo *)MainImageForm->Plan->ProductArray[1]->Items[Row])->Color;
     sgWeft->Cells[7][Row+1] = ((ProductInfo *)MainImageForm->Plan->ProductArray[1]->Items[Row])->Weight;
  }
}
//----------------------------------------------------------------------------
void __fastcall TNewProductDataForm::ArrangeProductStringData()
{
  edWarpingFront->Text = MainImageForm->Plan->ProductStringData.WarpingFront;
  edWarpingBack->Text = MainImageForm->Plan->ProductStringData.WarpingBack;
  lbWarping->Caption = "= " + MainImageForm->Plan->ProductStringData.Warping;
  edWarp->Text = MainImageForm->Plan->ProductStringData.TotalWarpCount;
  edReed->Text = MainImageForm->Plan->ProductStringData.Reed;
  edInserting->Text = MainImageForm->Plan->ProductStringData.InsertingNo;
  edWidth->Text = MainImageForm->Plan->ProductStringData.ActingReedWidth;
  edWeft->Text = MainImageForm->Plan->ProductStringData.WeftDensity;
  edWeight->Text = MainImageForm->Plan->ProductStringData.Weight;
}
//----------------------------------------------------------------------------
void __fastcall TNewProductDataForm::sgWarpDrawCell(TObject *Sender,
      int ACol, int ARow, TRect &Rect, TGridDrawState State)
{
  int i, x;
  AnsiString str;
  SetTextAlign(sgWarp->Canvas->Handle, TA_CENTER);
  if (ARow != 0 && ACol == 6) {
     if (MainImageForm->Plan->OrderArray[0]->Count <= 10) {
        if (ARow == 1) {
           x = 20;
           for (i = 0; i < MainImageForm->Plan->OrderArray[0]->Count; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[0]->Items[i])->Code);
              sgWarp->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        } else if (ARow == 2) {
           x = 20;
           for (i = 0; i < MainImageForm->Plan->OrderArray[0]->Count; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[0]->Items[i])->Yarns);
              sgWarp->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        }
     } else if (MainImageForm->Plan->OrderArray[0]->Count <= 20) {
        if (ARow == 1) {
           x = 20;
           for (i = 0; i < 10; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[0]->Items[i])->Code);
              sgWarp->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        } else if (ARow == 2) {
           x = 20;
           for (i = 0; i < 10; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[0]->Items[i])->Yarns);
              sgWarp->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        } else if (ARow == 3) {
           x = 20;
           for (i = 10; i < MainImageForm->Plan->OrderArray[0]->Count; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[0]->Items[i])->Code);
              sgWarp->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        } else if (ARow == 4) {
           x = 20;
           for (i = 10; i < MainImageForm->Plan->OrderArray[0]->Count; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[0]->Items[i])->Yarns);
              sgWarp->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        }
     } else {
        if (ARow == 1) {
           x = 20;
           for (i = 0; i < 10; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[0]->Items[i])->Code);
              sgWarp->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        } else if (ARow == 2) {
           x = 20;
           for (i = 0; i < 10; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[0]->Items[i])->Yarns);
              sgWarp->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        } else if (ARow == 3) {
           x = 20;
           for (i = 10; i < 20; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[0]->Items[i])->Code);
              sgWarp->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        } else if (ARow == 4) {
           x = 20;
           for (i = 10; i < 20; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[0]->Items[i])->Yarns);
              sgWarp->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        } else if (ARow == 5) {
           x = 20;
           for (i = 20; i < MainImageForm->Plan->OrderArray[0]->Count; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[0]->Items[i])->Code);
              sgWarp->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        } else if (ARow == 6) {
           x = 20;
           for (i = 20; i < MainImageForm->Plan->OrderArray[0]->Count; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[0]->Items[i])->Yarns);
              sgWarp->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        }
     }
  } else {
     sgWarp->Canvas->TextRect(Rect, Rect.Left+(Rect.Right-Rect.Left)/2,
           Rect.Top+3, sgWarp->Cells[ACol][ARow]);
  }
}
//---------------------------------------------------------------------------

void __fastcall TNewProductDataForm::sgWeftDrawCell(TObject *Sender,
      int ACol, int ARow, TRect &Rect, TGridDrawState State)
{
  int i, x;
  AnsiString str;
  SetTextAlign(sgWeft->Canvas->Handle, TA_CENTER);
  if (ARow != 0 && ACol == 6) {
     if (MainImageForm->Plan->OrderArray[1]->Count <= 10) {
        if (ARow == 1) {
           x = 20;
           for (i = 0; i < MainImageForm->Plan->OrderArray[1]->Count; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[1]->Items[i])->Code);
              sgWeft->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        } else if (ARow == 2) {
           x = 20;
           for (i = 0; i < MainImageForm->Plan->OrderArray[1]->Count; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[1]->Items[i])->Yarns);
              sgWeft->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        }
     } else if (MainImageForm->Plan->OrderArray[1]->Count <= 20) {
        if (ARow == 1) {
           x = 20;
           for (i = 0; i < 10; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[1]->Items[i])->Code);
              sgWeft->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        } else if (ARow == 2) {
           x = 20;
           for (i = 0; i < 10; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[1]->Items[i])->Yarns);
              sgWeft->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        } else if (ARow == 3) {
           x = 20;
           for (i = 10; i < MainImageForm->Plan->OrderArray[1]->Count; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[1]->Items[i])->Code);
              sgWeft->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        } else if (ARow == 4) {
           x = 20;
           for (i = 10; i < MainImageForm->Plan->OrderArray[1]->Count; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[1]->Items[i])->Yarns);
              sgWeft->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        }
     } else {
        if (ARow == 1) {
           x = 20;
           for (i = 0; i < 10; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[1]->Items[i])->Code);
              sgWeft->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        } else if (ARow == 2) {
           x = 20;
           for (i = 0; i < 10; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[1]->Items[i])->Yarns);
              sgWeft->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        } else if (ARow == 3) {
           x = 20;
           for (i = 10; i < 20; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[1]->Items[i])->Code);
              sgWeft->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        } else if (ARow == 4) {
           x = 20;
           for (i = 10; i < 20; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[1]->Items[i])->Yarns);
              sgWeft->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        } else if (ARow == 5) {
           x = 20;
           for (i = 20; i < MainImageForm->Plan->OrderArray[1]->Count; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[1]->Items[i])->Code);
              sgWeft->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        } else if (ARow == 6) {
           x = 20;
           for (i = 20; i < MainImageForm->Plan->OrderArray[1]->Count; i++) {
              str = AnsiString(((ArrayInfo *)MainImageForm->Plan->OrderArray[1]->Items[i])->Yarns);
              sgWeft->Canvas->TextOut(Rect.Left+x, Rect.Top+3, str);
              x += 20;
           }
        }
     }
  } else {
     sgWeft->Canvas->TextRect(Rect, Rect.Left+(Rect.Right-Rect.Left)/2,
           Rect.Top+3, sgWeft->Cells[ACol][ARow]);
  }
}
//---------------------------------------------------------------------------

void __fastcall TNewProductDataForm::Calculate()
{
  int i, arWidth;
  double Weight, TotalWeight, weDensity;
  ProductInfo *pi;
  TYarnUnit *yu;
  TotalWeight = 0;
  MainImageForm->Plan->ProductStringData.Weight = 0;
  arWidth = StrToInt(edWidth->Text);
  weDensity = StrToFloat(edWeft->Text);

  for (i = 0; i < MainImageForm->Plan->ProductArray[0]->Count; i++){
     pi = (ProductInfo *)MainImageForm->Plan->ProductArray[0]->Items[i];
     if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.Method == YU_DIRECT){
       if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 0)
          Weight = arWidth*(pi->Yarns/pi->Length)*pi->Yarns/TotalCnt[0]*pi->Count/(1093.6*1000);
       else if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 1)
          Weight = arWidth*(pi->Yarns/pi->Length)*pi->Yarns/TotalCnt[0]*pi->Count/(9842.4*1000);
     } else {
       if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 0)
          Weight = arWidth*(pi->Yarns/pi->Length)*pi->Yarns/(TotalCnt[0]*pi->Count)*(0.5399/1000);
       else if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 1)
          Weight = arWidth*(pi->Yarns/pi->Length)*pi->Yarns/(TotalCnt[0]*pi->Count)*(0.8100/1000);
       else if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 2)
          Weight = arWidth*(pi->Yarns/pi->Length)*pi->Yarns/(TotalCnt[0]*pi->Count)*(1.7718/1000);
       else if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 3)
          Weight = arWidth*(pi->Yarns/pi->Length)*pi->Yarns/(TotalCnt[0]*pi->Count)*(1.5120/1000);
     }
     TotalWeight += Weight;
     sgWarp->Cells[7][i+1] = Format("%.4f", OPENARRAY (TVarRec,(Weight)));
  }
  for (i = 0; i < MainImageForm->Plan->ProductArray[1]->Count; i++){
     pi = (ProductInfo *)MainImageForm->Plan->ProductArray[1]->Items[i];
     if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.Method == YU_DIRECT){
       if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 0)
          Weight = arWidth*weDensity*pi->Yarns*0.9144/TotalCnt[1]*pi->Count/(1093.6*1000);
       else if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 1)
          Weight = arWidth*weDensity*pi->Yarns*0.9144/TotalCnt[1]*pi->Count/(9842.4*1000);
     } else {
       if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 0)
          Weight = arWidth*weDensity*pi->Yarns*0.9144/(TotalCnt[1]*pi->Count)*(0.5399/1000);
       else if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 1)
          Weight = arWidth*weDensity*pi->Yarns*0.9144/(TotalCnt[1]*pi->Count)*(0.8100/1000);
       else if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 2)
          Weight = arWidth*weDensity*pi->Yarns*0.9144/(TotalCnt[1]*pi->Count)*(1.7718/1000);
       else if (MainImageForm->Plan->Yarn->Choice[(pi->Code-1)/8].Data->Unit.System == 3)
          Weight = arWidth*weDensity*pi->Yarns*0.9144/(TotalCnt[1]*pi->Count)*(1.5120/1000);
     }
     TotalWeight += Weight;
     sgWeft->Cells[7][i+1] = Format("%.4f", OPENARRAY (TVarRec,(Weight)));
  }
  sgWarp->Repaint();
  sgWeft->Repaint();
  edWarp->Text = IntToStr(int(WarpDensity * arWidth + 0.5));
  edWarp->Enabled = true;
  edWeight->Text = Format("%.4f", OPENARRAY (TVarRec,(TotalWeight)));
  edWeight->Enabled = true;
}
//----------------------------------------------------------------------------
void __fastcall TNewProductDataForm::edWarpingFrontKeyDown(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
  if (Key == VK_RETURN){
     int WarpingFront = StrToInt(edWarpingFront->Text);
     int WarpingBack = StrToInt(edWarpingBack->Text);
     lbWarping->Caption = " = "+ IntToStr(WarpingFront*WarpingBack);
     edWarpingBack->SetFocus();
  }
}
//---------------------------------------------------------------------------

void __fastcall TNewProductDataForm::edWarpingBackKeyDown(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
  if (Key == VK_RETURN) {
     int WarpingFront = StrToInt(edWarpingFront->Text);
     int WarpingBack = StrToInt(edWarpingBack->Text);
     lbWarping->Caption = "= "+ IntToStr(WarpingFront*WarpingBack);
     edWidth->SetFocus();
  }
}
//---------------------------------------------------------------------------
void __fastcall TNewProductDataForm::edWidthKeyDown(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
  if (Key == VK_RETURN) {
     Calculate();
     edReed->SetFocus();
  }
}
//---------------------------------------------------------------------------
void __fastcall TNewProductDataForm::edReedKeyDown(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
  if (Key == VK_RETURN) {
     edInserting->SetFocus();
  }
}
//---------------------------------------------------------------------------
void __fastcall TNewProductDataForm::edWeftKeyDown(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
  if (Key == VK_RETURN) {
     Calculate();
     edReed->SetFocus();
  }
}
//---------------------------------------------------------------------------


void __fastcall TNewProductDataForm::btOKClick(TObject *Sender)
{
  int i;
  ProductInfo *pi;

  MainImageForm->Plan->ProductStringData.WarpingFront = edWarpingFront->Text;
  MainImageForm->Plan->ProductStringData.WarpingBack = edWarpingBack->Text;
  MainImageForm->Plan->ProductStringData.Warping = lbWarping->Caption;
  MainImageForm->Plan->ProductStringData.TotalWarpCount = edWarp->Text;
  MainImageForm->Plan->ProductStringData.Reed = edReed->Text;
  MainImageForm->Plan->ProductStringData.InsertingNo = edInserting->Text;
  MainImageForm->Plan->ProductStringData.ActingReedWidth = edWidth->Text;
  MainImageForm->Plan->ProductStringData.WeftDensity = edWeft->Text;
  MainImageForm->Plan->ProductStringData.Weight = edWeight->Text;
  MainImageForm->Plan->ProductStringData.Ji->Clear();
  MainImageForm->Plan->ProductStringData.Attention->Clear();
  MainImageForm->Plan->ProductStringData.Ji->Assign(Memo1->Lines);
  MainImageForm->Plan->ProductStringData.Attention->Assign(Memo2->Lines);

//  for (i = 0; i <  Memo1->Lines->Count; i++) MainImageForm->Plan->ProductData.Ji->Add(Memo1->Lines->Strings[i]);
//  for (i = 0; i < Memo2->Lines->Countl i++) MainImageForm->Plan->ProductData.Attention->Add(Memo2->Lines->Strings[i]);
  for(i = 0; i < MainImageForm->Plan->ProductArray[0]->Count; i++){
     pi = (ProductInfo *)MainImageForm->Plan->ProductArray[0]->Items[i];
     pi->Kind = sgWarp->Cells[2][i+1];
     pi->YarnNo = sgWarp->Cells[3][i+1];
     pi->Color = sgWarp->Cells[5][i+1];
     pi->Weight = sgWarp->Cells[7][i+1];
  }
  for(i = 0; i < MainImageForm->Plan->ProductArray[1]->Count; i++){
     pi = (ProductInfo *)MainImageForm->Plan->ProductArray[1]->Items[i];
     pi->Kind = sgWeft->Cells[2][i+1];
     pi->YarnNo = sgWeft->Cells[3][i+1];
     pi->Color = sgWeft->Cells[5][i+1];
     pi->Weight = sgWeft->Cells[7][i+1];
  }
}
//---------------------------------------------------------------------------

void __fastcall TNewProductDataForm::sgWarpSelectCell(TObject *Sender,
      int ACol, int ARow, bool &CanSelect)
{
  if (ARow) {
     if (ACol == 2 || ACol == 3 || ACol == 5) {
        if (sgWarp->Row <= MainImageForm->Plan->ProductArray[0]->Count) sgWarp->Options<<goEditing;
        else sgWarp->Options>>goEditing;
     } else sgWarp->Options>>goEditing;
  } else sgWarp->Options>>goEditing;
}
//---------------------------------------------------------------------------

void __fastcall TNewProductDataForm::sgWeftSelectCell(TObject *Sender,
      int ACol, int ARow, bool &CanSelect)
{
  if (ARow) {
     if (ACol == 2 || ACol == 3 || ACol == 5) {
        if (sgWeft->Row <= MainImageForm->Plan->ProductArray[1]->Count) sgWeft->Options<<goEditing;
        else sgWeft->Options>>goEditing;
     } else sgWeft->Options>>goEditing;
  } else sgWeft->Options>>goEditing;
}
//---------------------------------------------------------------------------
void __fastcall TNewProductDataForm::sgWarpClick(TObject *Sender)
{
  if (sgWarp->Row) {
     if (sgWarp->Col == 2 || sgWarp->Col == 3 || sgWarp->Col == 5) {
        if (sgWarp->Row <= MainImageForm->Plan->ProductArray[0]->Count) sgWarp->EditorMode = true;
        else sgWarp->EditorMode = false;
     } else sgWarp->EditorMode = false;
  } else sgWarp->EditorMode = false;
}
//---------------------------------------------------------------------------
void __fastcall TNewProductDataForm::sgWeftClick(TObject *Sender)
{
  if (sgWeft->Row) {
     if (sgWeft->Col == 2 || sgWeft->Col == 3 || sgWeft->Col == 5) {
       if (sgWeft->Row <= MainImageForm->Plan->ProductArray[1]->Count) sgWeft->EditorMode = true;
       else sgWeft->EditorMode = false;
     } else sgWeft->EditorMode = false;
  } else sgWeft->EditorMode = false;
}
//---------------------------------------------------------------------------

void __fastcall TNewProductDataForm::sgWarpKeyDown(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
  if (sgWarp->Row){
     if (sgWarp->EditorMode) {
        if (Key == VK_RETURN) {
           if (sgWarp->Col == 2) sgWarp->Col = 3;
           else if (sgWarp->Col == 3) sgWarp->Col = 5;
           else if (sgWarp->Col == 5 && sgWarp->Row < MainImageForm->Plan->ProductArray[0]->Count) {
              sgWarp->Col = 2;
              sgWarp->Row = sgWarp->Row + 1;
           }   
           sgWarp->EditorMode = false;
        }
     }
  }
}
//---------------------------------------------------------------------------

void __fastcall TNewProductDataForm::sgWeftKeyDown(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
  if (sgWeft->Row){
     if (sgWeft->EditorMode){
        if (Key == VK_RETURN) {
           if (sgWeft->Col == 2) sgWeft->Col = 3;
           else if (sgWeft->Col == 3) sgWeft->Col = 5;
           else if (sgWeft->Col == 5 && sgWeft->Row < MainImageForm->Plan->ProductArray[1]->Count) {
              sgWeft->Col = 2;
              sgWeft->Row = sgWeft->Row + 1;
           }
           sgWeft->EditorMode = false;
        }
     }
  }
}
//---------------------------------------------------------------------------

