﻿using AForge;
using AForge.Imaging.Filters;
using AForge.Imaging.Textures;
using OpenCvSharp;
using System;
using System.Drawing;
using System.Windows.Forms;

namespace TexMaster
{
    public partial class AForge : Form
    {
        IFilter filter;
        bool needGray;
        int in_numR;
        int in_numG;
        int in_numB;
        int value;
        public AForge()
        {
            InitializeComponent();
        }

        private void AForge_Load(object sender, EventArgs e)
        {
            pictureBoxIpl1.Image = System.Drawing.Image.FromFile("d:\\bono.jpg");
            comboBox1.SelectedIndex = 21;
            needGray = false;
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            needGray = false;
            Mat src = Cv2.ImRead("d:\\bono.jpg");
            Mat dst = new Mat(src.Size(), MatType.CV_8UC1);

            switch (comboBox1.SelectedIndex)
            {
                case 0:
                    filter = new Grayscale(0.2125, 0.7154, 0.0721);
                    break;
                case 1:
                    filter = new Sepia();
                    break;
                case 2:
                    filter = new Invert();
                    break;
                case 3:
                    filter = new RotateChannels();
                    break;
                case 4:
                    filter = new ColorFiltering(new IntRange(25, 230), new IntRange(25, 230), new IntRange(25, 230));
                    break;
                case 5:
                    LevelsLinear m_filter = new LevelsLinear();
                    m_filter.InRed = new IntRange(30, 230);
                    m_filter.InGreen = new IntRange(50, 240);
                    m_filter.InBlue = new IntRange(10, 210);
                    filter = m_filter;
                    break;
                case 6:
                    filter = new HueModifier(50);
                    break;
                case 7:
                    filter = new SaturationCorrection(0.15F);
                    break;
                case 8:
                    filter = new BrightnessCorrection();
                    break;
                case 9:
                    filter = new ContrastCorrection();
                    break;
                case 10:
                    filter = new HSLFiltering();
                    break;
                case 11:
                    needGray = true;
                    int[,] kernel = { { -2, -1, 0 }, { -1, 1, 1 }, { 0, 1, 2 } };
                    filter = new Convolution(kernel);
                    break;
                case 12:
                    needGray = true;
                    filter = new FloydSteinbergDithering();
                    break;
                case 13:
                    filter = new Sharpen();
                    break;
                case 14:
                    filter = new Jitter();
                    break;
                case 15:
                    filter = new OilPainting();
                    break;
                case 16:
                    filter = new Texturer(new TextileTexture(), 1.0, 0.8);
                    break;
                case 17:
                    needGray = true;
                    filter = new DifferenceEdgeDetector();
                    break;
                case 18:
                    needGray = true;
                    filter = new HomogenityEdgeDetector();
                    break;
                case 19:
                    needGray = true;
                    filter = new SobelEdgeDetector();
                    break;
                case 20:
                    needGray = true;
                    filter = new Threshold();
                    break;
                case 21:
                    SetLowFilter();
                    break;

            }

            applyImage((Bitmap)pictureBoxIpl1.Image);
        }

        private void applyImage(Bitmap image)
        {
            if (needGray)
            {
                using (Bitmap originalImage = Grayscale.CommonAlgorithms.RMY.Apply(image))
                {
                    pictureBoxIpl2.Image = filter.Apply(originalImage);
                }
            }
            else
            {
                pictureBoxIpl2.Image = filter.Apply(image);
            }
        }

        private void trackBar1_Scroll(object sender, EventArgs e)
        {
            in_numR = (int)numericUpDown1.Value;
            value = trackBar1.Value;

            SetLowFilter();
            textBox1.Text = String.Format("{0}", trackBar1.Value);
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            SetLowFilter();
        }

        private void checkBox2_CheckedChanged(object sender, EventArgs e)
        {
            SetLowFilter();
        }

        private void checkBox3_CheckedChanged(object sender, EventArgs e)
        {
            SetLowFilter();
        }

        private void numericUpDown1_ValueChanged(object sender, EventArgs e)
        {
            in_numR = (int)numericUpDown1.Value;
            SetLowFilter();
        }

        private void numericUpDown2_ValueChanged(object sender, EventArgs e)
        {
            in_numG = (int)numericUpDown2.Value;
            SetLowFilter();
        }
        private void numericUpDown3_ValueChanged(object sender, EventArgs e)
        {
            in_numB = (int)numericUpDown3.Value;
            SetLowFilter();
        }


        private void SetLowFilter()
        {
            needGray = false;

            LevelsLinear lowFilter = new LevelsLinear();

            /* red green blue 255 255 255 */
            lowFilter.InRed = new IntRange(value, value);
            lowFilter.InGreen = new IntRange(value, value);
            lowFilter.InBlue = new IntRange(value, value);

            filter = lowFilter;
            applyImage((Bitmap)pictureBoxIpl1.Image);
        }
    }
}
