﻿using System;
using System.Drawing;

namespace TexMaster
{
    public static class ColorConvert
    {
        #region Static Methods

        public static Color ConvertCmykToRgb(float c, float m, float y, float k)
        {
            int r;
            int g;
            int b;

            r = Convert.ToInt32(255 * (1 - c) * (1 - k));
            g = Convert.ToInt32(255 * (1 - m) * (1 - k));
            b = Convert.ToInt32(255 * (1 - y) * (1 - k));

            return Color.FromArgb(r, g, b);
        }

        public static CmykColor ConvertRgbToCmyk(int r, int g, int b)
        {
            float c;
            float m;
            float y;
            float k;
            float rf;
            float gf;
            float bf;

            rf = r / 255F;
            gf = g / 255F;
            bf = b / 255F;

            k = ClampCmyk(1 - Math.Max(Math.Max(rf, gf), bf));
            c = ClampCmyk((1 - rf - k) / (1 - k));
            m = ClampCmyk((1 - gf - k) / (1 - k));
            y = ClampCmyk((1 - bf - k) / (1 - k));

            return new CmykColor(c, m, y, k);
        }

        private static float ClampCmyk(float value)
        {
            if (value < 0 || float.IsNaN(value))
            {
                value = 0;
            }

            return value;
        }

        #endregion
    }

    public struct CmykColor
  {
    private readonly float _c;

    private readonly float _m;

    private readonly float _y;

    private readonly float _k;

    public CmykColor(float c, float m, float y, float k)
    {
      _c = c;
      _m = m;
      _y = y;
      _k = k;
    }

    public float C
    {
      get { return _c; }
    }

    public float M
    {
      get { return _m; }
    }

    public float Y
    {
      get { return _y; }
    }

    public float K
    {
      get { return _k; }
    }
  }
}
