﻿using System;
using System.Drawing;
using System.Windows.Forms;
using System.Drawing.Printing;

namespace TexMaster
{
    public partial class ColorChart : Form
    {
        Canvas mCanvas;
        public ColorChart(Canvas canvas)
        {
            mCanvas = canvas;
            InitializeComponent();
        }

        private void ColorChart_Load(object sender, EventArgs e)
        {
            int x = 5;
            int y = 5;

            for (int i = 0; i < mCanvas.mPalette.mColorList.Count; i++)
            {
                Panel panel = new Panel();
                panel.Size = new Size(45, 30);
                panel.Location = new Point(x, y);
                panel.Parent = pnl_color;
                //panel.BackColor = Palette.gPalette.customColors[i];
                ColorChip c = mCanvas.mPalette.mColorList[i];
                panel.BackColor = Color.FromArgb(c.r, c.g, c.b);
                panel.BorderStyle = BorderStyle.FixedSingle;
                panel.MouseEnter += new System.EventHandler(this.panel_MouseEnter);

                if ((i + 1) % 16 != 0)
                {
                    x += panel.Width + 5;
                }
                else
                {
                    x = 5;
                    y += panel.Height + 5;
                }
            }
        }

        Panel focus = new Panel();
        private void panel_MouseEnter(object sender, EventArgs e)
        {
            lbl_color_value.Text = String.Format("{0}-{1}-{2}", ((Panel)sender).BackColor.R, ((Panel)sender).BackColor.G, ((Panel)sender).BackColor.B);
            Rectangle rect = ((Panel)sender).Bounds;
            focus.Location = new Point(rect.X - 3, rect.Y - 3);
            focus.Size = new Size(rect.Width + 6, rect.Height + 6);
            focus.BackColor = Color.DarkBlue;
            focus.Parent = pnl_color;
            ((Panel)sender).BringToFront();
            
        }

        private void printDocument1_PrintPage(object sender, PrintPageEventArgs e)
        {
            Graphics g = e.Graphics;
            Point drawPoint = new Point(0, 0);
            using (Font font = new Font("나눔고딕", 5.5F))
            using (SolidBrush drawBrush = new SolidBrush(Color.Black))
            {
                //g.FillRectangle(new SolidBrush(Color.White), new Rectangle(drawPoint, new Size(70,70)));
                //g.DrawString(String.Format("{0}-{1}-{2}", Color.White.R, Color.White.G, Color.White.B), font, drawBrush, drawPoint);
                //drawPoint.X += 70;
                for (int i = 0; i < mCanvas.mPalette.mColorList.Count; i++)
                {
                    ColorChip color = mCanvas.mPalette.mColorList[i];
                    Color c = Color.FromArgb(color.r, color.g, color.b);
                    g.FillRectangle(new SolidBrush(c), new Rectangle(drawPoint, new Size(53, 53)));
                    if ((c.R + c.G + c.B) / 3 < 128)
                    {
                        drawBrush.Color = Color.White;
                    }
                    else
                    {
                        drawBrush.Color = Color.Black;
                    }
                    g.DrawString(String.Format("{0}", i), font, drawBrush, drawPoint);
                    g.DrawString(String.Format("{0}-{1}-{2}", c.R, c.G, c.B), font, drawBrush, new Point(drawPoint.X, drawPoint.Y + 16));
                    g.DrawString(String.Format("R G B"), font, drawBrush, new Point(drawPoint.X, drawPoint.Y + 24));

                    if ((i + 1) % 14 != 0)
                    {
                        drawPoint.X += 55;
                    }
                    else
                    {
                        drawPoint.X = 0;
                        drawPoint.Y += 55;
                    }
                }
            }

        }

        private void btn_print_Click(object sender, EventArgs e)
        {
            printDocument1.Print();
        }
    }

}
