﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;

namespace TexMaster
{
    public partial class ColorLibrary : Form
    {
        public List<Color> colList;
        public List<int> intList;
        public int cnt = 0;
        public Canvas mCanvas;

        public ColorLibrary(Canvas canvas)
        {
            InitializeComponent();
            mCanvas = canvas;
        }

        public string GetColorBookName(Library li)
        {
            string result = null;
            switch (li)
            {
                case Library.PANTONE:
                    result = "PANTONE® Color";
                    break;
                case Library.PRINTER:
                    result = "Printer Color";
                    break;
                case Library.STANDARD:
                    result = "TP Standard";
                    break;
                case Library.TEXTILE:
                    result = "TP Textile";
                    break;
                case Library.USER:
                    result = "User Color";
                    break;
            }
            return result;
        }

        private void ColorLibrary_Load(object sender, EventArgs e)
        {
            if (mCanvas.PictureBox1.Image == null) return;
            GetRatio();

            List<ColorChip> list = mCanvas.mPalette.mColorList;
            dgv_color_library.RowCount = list.Count;

            for (int i = 0; i < dgv_color_library.RowCount; i++)
            {
                Bitmap bm = new Bitmap(Column1.Width - 5,20);
                Graphics gp = Graphics.FromImage(bm);
                Color color = Color.FromArgb(list[i].r, list[i].g, list[i].b);
                gp.FillRectangle(new SolidBrush(color), new Rectangle(0, 0, bm.Width, bm.Height));
                gp.DrawRectangle(new Pen(Color.Gray), new Rectangle(0, 0, bm.Width-1, bm.Height-1));
                int r = list[i].r;
                int g = list[i].g;
                int b = list[i].b;
                CmykColor converted = ColorConvert.ConvertRgbToCmyk(r, g, b);
                int c = Convert.ToInt32(converted.C * 100);
                int m = Convert.ToInt32(converted.M * 100);
                int y = Convert.ToInt32(converted.Y * 100);
                int k = Convert.ToInt32(converted.K * 100);

                int h = Convert.ToInt32(color.GetHue());
                int l = Convert.ToInt32(color.GetBrightness() * 100);
                int s = Convert.ToInt32(color.GetSaturation() * 100);

                //dgv_color_library.Rows[i].Cells[0].Style.BackColor = Palette.gPalette.customColors[i];
                dgv_color_library.Rows[i].Cells[0].Value = bm;
                dgv_color_library.Rows[i].Cells[1].Value = GetColorBookName(list[i].library);
                dgv_color_library.Rows[i].Cells[2].Value = list[i].code;
                dgv_color_library.Rows[i].Cells[3].Value = String.Format("{0}-{1}-{2}-{3}", c, m ,y, k);
                dgv_color_library.Rows[i].Cells[4].Value = String.Format("{0}-{1}-{2}", h, l, s);

                if (colList.Contains(color))
                {
                    dgv_color_library.Rows[i].Cells[5].Value = ((float)intList[colList.IndexOf(color)] / (float)cnt).ToString("0.0%");
                }
                dgv_color_library.Rows[i].Cells[6].Value = "NO";
                dgv_color_library.Rows[i].HeaderCell.Value = String.Format("{0}", i + 1);
            }
        }

        private void GetRatio()
        {
            // Create a new bitmap.
            if (mCanvas.PictureBox1.Image == null) return;
            Bitmap bmp = new Bitmap(mCanvas.PictureBox1.Image);

            Rectangle rect = new Rectangle(0, 0, bmp.Width, bmp.Height);
            System.Drawing.Imaging.BitmapData bmpData =
                bmp.LockBits(rect, System.Drawing.Imaging.ImageLockMode.ReadWrite,
                bmp.PixelFormat);

            // Get the address of the first line.
            IntPtr ptr = bmpData.Scan0;

            // Declare an array to hold the bytes of the bitmap.
            int bytes = Math.Abs(bmpData.Stride) * bmp.Height;
            byte[] rgbValues = new byte[bytes];

            System.Runtime.InteropServices.Marshal.Copy(ptr, rgbValues, 0, bytes);

            int numBytes = 0;
            Color back = mCanvas.gBackColor;
            colList = new List<Color>();
            intList = new List<int>();


            for (int y = 0; y < bmp.Height; y++)
            {
                for (int x = 0; x < bmp.Width; x++)
                {
                    numBytes = (y * (bmp.Width * 4)) + (x * 4);

                    byte blue = rgbValues[numBytes++];
                    byte green = rgbValues[numBytes++];
                    byte red = rgbValues[numBytes++];
                    byte alpha = rgbValues[numBytes];

                    Color color = Color.FromArgb(alpha, red, green, blue);

                    if (color != back)
                    {
                        cnt++;
                        if (!colList.Contains(color))
                        {
                            colList.Add(color);
                            intList.Add(1);
                        }
                        else
                        {
                            intList[colList.IndexOf(color)]++;
                        }
                    }
                }
            }

            // Unlock the bits.
            bmp.UnlockBits(bmpData);
        }
    }
}
