﻿using OpenCvSharp;
using OpenCvSharp.Extensions;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;
using cvPoint = OpenCvSharp.Point;
using Point = System.Drawing.Point;
using cvRect = OpenCvSharp.Rect;
using System.Drawing.Drawing2D;

namespace TexMaster
{
    public partial class ColorWayForm : Form
    {
        public List<int> colList;
        Canvas mCanvas;
        MultiColor multi;
        public List<Mat> matList;

        public ColorWayForm(Canvas canvas)
        {
            InitializeComponent();
            mCanvas = canvas;
            colList = new List<int>();

            multi = new MultiColor();
        }

        private void ColorWayForm_Load(object sender, EventArgs e)
        {

        }

        public void DrawColorChip()
        {
            Mat tempMat = pictureBoxIpl1.ImageIpl.Clone();

            colList.Clear();

            for (int row = 0; row < tempMat.Height - 1; row++)
            {
                for (int col = 0; col < tempMat.Width - 1; col++)
                {
                    Color c = Color.FromArgb(tempMat.At<int>(row, col));
                    if (c.A == 255)
                    {
                        if (tempMat.At<int>(row, col) != tempMat.At<int>(row + 1, col + 1) && !colList.Contains(tempMat.At<int>(row, col)))
                        {
                            colList.Add(tempMat.At<int>(row, col));
                        }
                    }
                }
            }


            flowLayoutPanel1.Controls.Clear();
            for (int i = 0; i < colList.Count; i++)
            {
                Panel panel = new Panel();
                panel.MouseClick += PanelClick;
                panel.Tag = i; 
                panel.Width = 24;
                panel.Height = 24;
                panel.BackColor = Color.FromArgb(colList[i]);
                panel.BorderStyle = BorderStyle.FixedSingle;
                flowLayoutPanel1.Controls.Add(panel);
            }
            
            cvPoint[][] contours;
            HierarchyIndex[] hierarchy;
            matList = new List<Mat>();

            for (int i = 0; i < colList.Count; i++)
            {
                Mat hsv = new Mat();
                Color c = Color.FromArgb((int)colList[i]);
                Scalar selColor = new Scalar(c.B, c.G, c.R, c.A);
                Mat ori = tempMat;
                Cv2.CvtColor(ori, hsv, ColorConversionCodes.BGR2HSV);
                Cv2.InRange(ori, selColor, selColor, hsv);
                Cv2.FindContours(hsv, out contours, out hierarchy, RetrievalModes.Tree, ContourApproximationModes.ApproxTC89KCOS);
                matList.Add(hsv);
            }
        }

        public void PanelClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                Mat tempMat = pictureBoxIpl1.ImageIpl.Clone();
                Color c = mCanvas.mPalette.color;
                Scalar s = new Scalar(c.B, c.G, c.R, c.A);

                ((Panel)sender).BackColor = c;
                tempMat.SetTo(s, matList[(int)((Panel)sender).Tag]);

                pictureBoxIpl1.ImageIpl = tempMat;
            }
            else if (e.Button == MouseButtons.Left)
            {
                mCanvas.mPalette.cgd_256.Color = ((Panel)sender).BackColor;
            }
        }

        private void ColorWayForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            DialogResult res = MessageBox.Show("적용하시겠습니까?", "Question", MessageBoxButtons.YesNoCancel);
            switch (res)
            {
                case DialogResult.Yes:
                    Rectangle r = Rectangle.Round(mCanvas.mWorkarea.totalPath.GetBounds());
                    cvRect rect = new cvRect((int)r.X, (int)r.Y, (int)r.Width, (int)r.Height);

                    mCanvas.PictureBox1.ImageIpl[rect].CopyTo(pictureBoxIpl1.ImageIpl);
                    mCanvas.dst = mCanvas.PictureBox1.ImageIpl;
                    mCanvas.restore = mCanvas.dst.Clone();
                    mCanvas.matList.Add(mCanvas.dst);
                    break;
                case DialogResult.No:
                    e.Cancel = false;
                    break;
                case DialogResult.Cancel:
                    e.Cancel = true;
                    return;
            }
        }

        private void pictureBoxIpl1_MouseDown(object sender, MouseEventArgs e)
        {
            GraphicsPath gp = new GraphicsPath();
            gp.AddRectangle(new RectangleF(0, 0, pictureBoxIpl1.ImageIpl.Width, pictureBoxIpl1.ImageIpl.Height));
            multi.MouseDown(pictureBoxIpl1.ImageIpl, gp, mCanvas.mColorWay.pnl_color, e);
            mCanvas.drawing = true;
        }

        private void pictureBoxIpl1_MouseMove(object sender, MouseEventArgs e)
        {
            multi.MouseMove(e);
            pictureBoxIpl1.Refresh();
        }

        private void pictureBoxIpl1_MouseUp(object sender, MouseEventArgs e)
        {
            multi.MouseUp(pictureBoxIpl1.ImageIpl, mCanvas.mColorWay.pnl_color, e);
            mCanvas.drawing = false;
        }

        private void pictureBoxIpl1_Paint(object sender, PaintEventArgs e)
        {
            multi.Paint(e);
        }
    }
}
