﻿using System;
using System.Windows.Forms;

namespace TexMaster
{
    public partial class CreateCanvas : Form
    {
        public TPCanvasInfo gCanvasInfo;
        public TUnit gUnit;

        public CreateCanvas()
        {
            InitializeComponent();
        }

        private void CreateCanvas_Load(object sender, EventArgs e)
        {
            /* Have to Read Configure file */
            cmb_size.SelectedIndex = 0;
            gCanvasInfo.Orientation = TPCanvasOrientation.coPortrait;
            rdo_portrait.Checked = true;
            gCanvasInfo.DotsPerInch = 160;
            nud_dpi.Value = gCanvasInfo.DotsPerInch;
            gCanvasInfo.SetSize(TPCanvasSizeType.cstA4);
            gUnit = TUnit.uCm;
            rdo_cm.Checked = true;
            Review();
        }

        private void rdo_cm_CheckedChanged(object sender, EventArgs e)
        {
            gUnit = TUnit.uCm;
            Review();
        }

        private void rdo_inch_CheckedChanged(object sender, EventArgs e)
        {
            gUnit = TUnit.uInch;
            Review();
        }

        private void rdo_dot_CheckedChanged(object sender, EventArgs e)
        {
            gUnit = TUnit.uDot;
            Review();
        }

        private void btn_default_Click(object sender, EventArgs e)
        {
            cmb_size.SelectedIndex = 0;
            gCanvasInfo.Orientation = TPCanvasOrientation.coPortrait;
            rdo_portrait.Checked = true;
            gCanvasInfo.DotsPerInch = 160;
            nud_dpi.Value = gCanvasInfo.DotsPerInch;
            gCanvasInfo.SetSize(TPCanvasSizeType.cstA4);
            gUnit = TUnit.uCm;
            rdo_cm.Checked = true;
            Review();
        }

        private void cmb_size_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cmb_size.SelectedIndex == 8)
            {
                gCanvasInfo.SizeType = TPCanvasSizeType.cstFree;
                lbl_width.Enabled = true;
                txt_width.Enabled = true;
                lbl_height.Enabled = true;
                txt_height.Enabled = true;
                grp_paper.Enabled = false;
                txt_width.Focus();
            }
            else
            {
                switch (cmb_size.SelectedIndex)
                {
                    case 0: gCanvasInfo.SetSize(TPCanvasSizeType.cstA4); break;
                    case 1: gCanvasInfo.SetSize(TPCanvasSizeType.cstA3); break;
                    case 2: gCanvasInfo.SetSize(TPCanvasSizeType.cstA2); break;
                    case 3: gCanvasInfo.SetSize(TPCanvasSizeType.cstA1); break;
                    case 4: gCanvasInfo.SetSize(TPCanvasSizeType.cstA0); break;
                    case 5: gCanvasInfo.SetSize(TPCanvasSizeType.cstLetter); break;
                    case 6: gCanvasInfo.SetSize(TPCanvasSizeType.cstLegal); break;
                    case 7: gCanvasInfo.SetSize(TPCanvasSizeType.cstTabloid); break;
                }

                lbl_width.Enabled = false;
                txt_width.Enabled = false;
                lbl_height.Enabled = false;
                txt_height.Enabled = false;
                grp_paper.Enabled = true;
                txt_width.Focus();
            }

            Review();
        }

        private void Review()
        {
            int dpi;
            long hor, ver;
            int index;

            if (gCanvasInfo.Orientation.Equals(TPCanvasOrientation.coPortrait))
            {
                hor = gCanvasInfo.Width;
                ver = gCanvasInfo.Height;
            }
            else
            {
                hor = gCanvasInfo.Height;
                ver = gCanvasInfo.Width;
            }

            index = cmb_size.SelectedIndex;

            switch (gUnit)
            {
                case TUnit.uInch:
                    txt_width.Text = ((double)hor / gCanvasInfo.DotsPerInch).ToString();
                    txt_height.Text = ((double)ver / gCanvasInfo.DotsPerInch).ToString();
                    lbl_cm1.Text = "Inch";
                    lbl_cm2.Text = "Inch";
                    break;
                case TUnit.uCm:
                    txt_width.Text = (2.54 * hor / gCanvasInfo.DotsPerInch).ToString();
                    txt_height.Text = (2.54 * ver / gCanvasInfo.DotsPerInch).ToString();
                    lbl_cm1.Text = "Cm";
                    lbl_cm2.Text = "Cm";
                    break;
                default:
                    dpi = (int)nud_dpi.Value;
                    txt_width.Text = hor.ToString();
                    txt_height.Text = ver.ToString();
                    lbl_cm1.Text = "Dot";
                    lbl_cm2.Text = "Dot";
                    break;
            }

            cmb_size.SelectedIndex = index;
        }

        private void txt_width_TextChanged(object sender, EventArgs e)
        {
            double hor = 0.0;
            if (Convert.ToDouble(txt_width.Text) > 0)
            {
                switch (gUnit)
                {
                    case TUnit.uInch:
                        hor = Convert.ToDouble(txt_width.Text) * gCanvasInfo.DotsPerInch;
                        break;
                    case TUnit.uCm:
                        hor = Convert.ToDouble(txt_width.Text) * gCanvasInfo.DotsPerInch / 2.54;
                        break;
                    default:
                        hor = Convert.ToInt32(txt_width.Text);
                        break;
                }
            }
            if (gCanvasInfo.Orientation.Equals(TPCanvasOrientation.coPortrait))
                gCanvasInfo.Width = Convert.ToInt32(hor);
            else
                gCanvasInfo.Height = Convert.ToInt32(hor);

        }

        private void txt_height_TextChanged(object sender, EventArgs e)
        {
            double ver = 0.0;
            if (Convert.ToDouble(txt_height.Text) > 0)
            {
                switch (gUnit)
                {
                    case TUnit.uInch:
                        ver = Convert.ToDouble(txt_height.Text) * gCanvasInfo.DotsPerInch;
                        break;
                    case TUnit.uCm:
                        ver = Convert.ToDouble(txt_height.Text) * gCanvasInfo.DotsPerInch / 2.54;
                        break;
                    default:
                        ver = Convert.ToInt32(txt_height.Text);
                        break;
                }
            }
            if (gCanvasInfo.Orientation.Equals(TPCanvasOrientation.coPortrait))
            {
                gCanvasInfo.Height = Convert.ToInt32(ver);
            }
            else
            {
                gCanvasInfo.Width = Convert.ToInt32(ver);
            }
        }

        private void rdo_portrait_CheckedChanged(object sender, EventArgs e)
        {
            gCanvasInfo.Orientation = TPCanvasOrientation.coPortrait;
            Review();
        }

        private void rdo_landscape_CheckedChanged(object sender, EventArgs e)
        {
            gCanvasInfo.Orientation = TPCanvasOrientation.coLandscape;
            Review();
        }

        private void nud_dpi_ValueChanged(object sender, EventArgs e)
        {
            double w = 0.0;
            double h = 0.0;

            if ((int)nud_dpi.Value > 0)
            {
                gCanvasInfo.DotsPerInch = (int)nud_dpi.Value;

                switch (cmb_size.SelectedIndex)
                {
                    case 0:
                        w = 7.8 * gCanvasInfo.DotsPerInch;
                        h = 11 * gCanvasInfo.DotsPerInch;
                        break;
                    case 1:
                        w = 11 * gCanvasInfo.DotsPerInch;
                        h = 15.6 * gCanvasInfo.DotsPerInch;
                        break;
                    case 2:
                        w = 15.6 * gCanvasInfo.DotsPerInch;
                        h = 22 * gCanvasInfo.DotsPerInch;
                        break;
                    case 3:
                        w = 22 * gCanvasInfo.DotsPerInch;
                        h = 31.2 * gCanvasInfo.DotsPerInch;
                        break;
                    case 4:
                        w = 31.2 * gCanvasInfo.DotsPerInch;
                        h = 44 * gCanvasInfo.DotsPerInch;
                        break;
                    case 5:
                        w = 8.0 * gCanvasInfo.DotsPerInch;
                        h = 10.3 * gCanvasInfo.DotsPerInch;
                        break;
                    case 6:
                        w = 8.0 * gCanvasInfo.DotsPerInch;
                        h = 13.2 * gCanvasInfo.DotsPerInch;
                        break;
                    case 7:
                        w = 10.3 * gCanvasInfo.DotsPerInch;
                        h = 16.0 * gCanvasInfo.DotsPerInch;
                        break;
                }

                if (gCanvasInfo.Orientation.Equals(TPCanvasOrientation.coPortrait))
                {
                    gCanvasInfo.Width = (int)w;
                    gCanvasInfo.Height = (int)h;
                }
                else
                {
                    gCanvasInfo.Width = (int)h;
                    gCanvasInfo.Height = (int)w;
                }
            }
            Review();
        }

        private void btn_ok_Click(object sender, EventArgs e)
        {
            ((MainForm)this.MdiParent).CreateFile();
            this.Close();
        }

        private void btn_cancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
