﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Drawing2D;

using System.Windows.Forms;

namespace TexMaster.Source
{
    public enum LineCurve
    {
        LINE, CURVE
    }

    public partial class CurveTest : Form
    {
        private CurveObj curve = null;
        private List<CurveObj> curveList = new List<CurveObj>();
        private LineCurve lineCurve = LineCurve.LINE;
        private bool connect = false;
        private bool drawing = false;

        List<GraphicsPath> lines = new List<GraphicsPath>();
        int mouseX, mouseY;

        public CurveTest()
        {
            InitializeComponent();
            Bitmap bitmap = new Bitmap(pnl_curve.Width, pnl_curve.Height);
            Graphics graphics = Graphics.FromImage(bitmap);
            graphics.Clear(Color.White);
            pnl_curve.BackgroundImage = bitmap;
        }

        private void pnl_curve_MouseDown(object sender, MouseEventArgs e)
        {
            if (curve == null)
            {
                curve = new CurveObj();

                if (lineCurve == LineCurve.LINE) curve.mLineCurve = LineCurve.LINE;
                else
                {
                    curve.mLineCurve = LineCurve.CURVE;
                    curve.cList.Add(e.Location);
                }
                curve.start = e.Location;
                curve.end = e.Location;
            }
            else
            {
                if (curve.mLineCurve == LineCurve.LINE)
                {
                    curveList.Add(curve);

                    if (connect)
                    {
                        curve = new CurveObj();
                        curve.mLineCurve = LineCurve.LINE;
                        curve.start = curveList[curveList.Count - 1].end;
                        curve.end = e.Location;
                    }
                    else
                    {
                        curve = null;
                    }
                }
                else
                {
                    curve.cList.Add(e.Location);
                    if (curve.cList.Count == 2)
                    {
                        curve.cList.Add(e.Location);
                        curve.cList.Add(e.Location);
                        curve.cList[curve.cList.Count - 1] = curve.cList[curve.cList.Count - 3];
                    }
                    else if (curve.cList.Count == 5)
                    {
                        curve.cList.RemoveAt(curve.cList.Count - 1);
                        curveList.Add(curve);

                        if (connect)
                        {
                            curve = new CurveObj();
                            curve.start = Point.Round(curveList[curveList.Count - 1].cList[curveList[curveList.Count - 1].cList.Count - 1]);
                            curve.end = e.Location;
                            curve.mLineCurve = LineCurve.CURVE;
                            curve.cList.Add(curve.start);
                        }
                        else
                        {
                            curve = null;
                        }
                    }
                }
            }
            pnl_curve.Refresh();
        }

        private void pnl_curve_MouseMove(object sender, MouseEventArgs e)
        {
            mouseX = e.Location.X;
            mouseY = e.Location.Y;

            if (curve == null) return;

            if (curve.mLineCurve == LineCurve.CURVE && curve.cList.Count > 1)
            {
                try
                {
                    curve.cList[1] = SymmetryPoint(curve.cList[3], e.Location);
                    curve.cList[2] = SymmetryPoint(curve.cList[3], e.Location);

                    int bX = (int)(curve.cList[0].X + (2.0f / 3.0f) * (curve.cList[1].X - curve.cList[0].X));
                    int bY = (int)(curve.cList[0].Y + (2.0f / 3.0f) * (curve.cList[1].Y - curve.cList[0].Y));
                    int cX = (int)(curve.cList[3].X + (2.0f / 3.0f) * (curve.cList[1].X - curve.cList[3].X));
                    int cY = (int)(curve.cList[3].Y + (2.0f / 3.0f) * (curve.cList[1].Y - curve.cList[3].Y));

                    curve.cList[1] = new Point(bX, bY);
                    curve.cList[2] = new Point(cX, cY);
                }
                catch
                {
                    return;
                }
            }
            curve.end = e.Location;
            pnl_curve.Refresh();
        }

        private void pnl_curve_MouseUp(object sender, MouseEventArgs e)
        {
            if (curve == null) return;

            pnl_curve.Refresh();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (connect) connect = false;
            else connect = true;
        }


        private void pnl_curve_Paint(object sender, PaintEventArgs e)
        {
            e.Graphics.SmoothingMode = SmoothingMode.AntiAlias;
            for (int i = 0; i < curveList.Count; i++)
            {
                DrawShape(curveList[i], e.Graphics);
            }
            if (curve != null)
            {
                DrawShape(curve, e.Graphics);

                if (curve.cList.Count == 4)
                {
                    e.Graphics.DrawLine(Pens.Red, new Point(mouseX, mouseY), SymmetryPoint(new Point(mouseX, mouseY), curve.cList[3], true));
                }

            }
        }

        private void DrawShape(CurveObj obj, Graphics gr)
        {
            switch (obj.mLineCurve)
            {
                case LineCurve.LINE:
                    gr.DrawLine(obj.cPen, obj.start, obj.end);
                    break;
                case LineCurve.CURVE:
                    if (obj.cList.Count == 1)
                    {
                        gr.DrawLine(obj.cPen, obj.start, obj.end);
                    }
                    else if (obj.cList.Count == 4)
                    {
                        gr.DrawBeziers(obj.cPen, obj.cList.ToArray());
                    }
                    break;
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (drawing) drawing = false;
            else drawing = true;
        }

        private void button3_Click(object sender, EventArgs e)
        {
            switch (lineCurve)
            {
                case LineCurve.LINE:
                    lineCurve = LineCurve.CURVE;
                    break;
                case LineCurve.CURVE:
                    lineCurve = LineCurve.LINE;
                    break;
            }
        }

        private Point SymmetryPoint(Point p1, Point p2, bool reverse = false)
        {
            int x, y;
            if (!reverse)
            {
                x = 2 * p1.X - p2.X;
                y = 2 * p1.Y - p2.Y;
            }
            else
            {
                x = 2 * p2.X - p1.X;
                y = 2 * p2.Y - p1.Y;
            }

            Point result = new Point(x, y);
            return result;
        }
    }

    public class CurveObj
    {
        public Pen cPen = new Pen(Brushes.Black, 5);
        public List<Point> cList = new List<Point>();
        public Point start, end;
        public LineCurve mLineCurve;
    }
}
