﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices;
using System.Runtime.Serialization.Formatters.Binary;
using System.Windows.Forms;
using Excel = Microsoft.Office.Interop.Excel;

namespace TexMaster
{
    [Serializable()]
    public struct Pantone
    {
        public int index;                  // 고유 번호 (1~ )
        public int page;                   // 페이지 번호
        public int col;                    // Col 
        public int row;                    // Row
        public string code;                // Color 코드에서 숫자만 추출한 값
        public string name;                // 이름
        public int r, g, b;
    }

    public partial class DTPColorLibrary : Form
    {
        Dictionary<int, Pantone> pantones;
        GraphicsPath pinkingT, pinkingB, pinkingL, pinkingR;

        int tag;
        Palette mPalette;

        public DTPColorLibrary(Palette palette)
        {
            InitializeComponent();
            mPalette = palette;
        }

        private void DTPColorLibrary_Load(object sender, EventArgs e)
        {
            //LoadPCL("Cotton.pcl");
            cmb_library.SelectedIndex = 0;
            cmb_tag_change.SelectedIndex = 1;
            tag = 1;
            UpdateList(pantones);
        }

        private void LoadPCL(string filename)
        {
            if (pantones != null)
            {
                pantones.Clear();
            }

            FileStream fs = new FileStream(filename, FileMode.Open);
            BinaryFormatter formatter = new BinaryFormatter();

            try
            {
                pantones = (Dictionary<int, Pantone>)formatter.Deserialize(fs);
            }
            catch
            {
                Console.WriteLine("fail");
                throw;
            }
            finally
            {
                fs.Close();
            }

        }

        public void UpdateList(Dictionary<int, Pantone> pantones)
        {
            prePanel.BorderStyle = BorderStyle.None;
            int currentPage = Convert.ToInt32(txt_move_page.Text);
            int itemPage;
            foreach (KeyValuePair<int, Pantone> items in pantones)
            {
                hsc_horz.Maximum = Math.Max(hsc_horz.Maximum, items.Value.page);
                itemPage = items.Value.page;
                if (currentPage == itemPage)
                {
                    InsertColorChip(items);
                }
            }
        }

        private void DrawColorChip(Panel pnl, Label lbl, String strTag, KeyValuePair<int, Pantone> items)
        {
            Bitmap bm = new Bitmap(pnl.Width, pnl.Height);
            pnl.BackgroundImage = bm;
            Graphics gr = Graphics.FromImage(pnl.BackgroundImage);
            gr.Clear(Color.FromArgb(items.Value.r, items.Value.g, items.Value.b));

            lbl.Text = strTag;
            pnl.BackgroundImage = GetPinkingEffect((Bitmap)pnl.BackgroundImage, 5, pnl.BackColor);
        }

        private void InsertColorChip(KeyValuePair<int, Pantone> items)
        {
            string strTag = "";

            if (cmb_library.SelectedIndex == 2) //# nylon
            {
                pnl_col4.Visible = false;
                pnl_col5.Visible = false;
            }
            else
            {
                pnl_col4.Visible = true;
                pnl_col5.Visible = true;
            }

            switch (tag)
            {
                case 0:
                    strTag = items.Value.index.ToString();
                    break;
                case 1:
                    strTag = items.Value.code;
                    break;
                case 2:
                    strTag = items.Value.name;
                    break;
            }

            switch (items.Value.col)
            {
                case 1:
                    lbl_col1.Text = "< " + ((int)((items.Value.page - 1) * 5) + items.Value.col).ToString() + " >";
                    switch (items.Value.row)
                    {
                        case 1:
                            DrawColorChip(pnl_col1row1, lbl_col1row1, strTag, items);
                            break;
                        case 2:
                            DrawColorChip(pnl_col1row2, lbl_col1row2, strTag, items);
                            break;
                        case 3:
                            DrawColorChip(pnl_col1row3, lbl_col1row3, strTag, items);
                            break;
                        case 4:
                            DrawColorChip(pnl_col1row4, lbl_col1row4, strTag, items);
                            break;
                        case 5:
                            DrawColorChip(pnl_col1row5, lbl_col1row5, strTag, items);
                            break;
                        case 6:
                            DrawColorChip(pnl_col1row6, lbl_col1row6, strTag, items);
                            break;
                        case 7:
                            DrawColorChip(pnl_col1row7, lbl_col1row7, strTag, items);
                            break;
                    }
                    break;
                case 2:
                    lbl_col2.Text = "< " + ((int)((items.Value.page - 1) * 5) + items.Value.col).ToString() + " >";
                    switch (items.Value.row)
                    {
                        case 1:
                            DrawColorChip(pnl_col2row1, lbl_col2row1, strTag, items);
                            break;
                        case 2:
                            DrawColorChip(pnl_col2row2, lbl_col2row2, strTag, items);
                            break;
                        case 3:
                            DrawColorChip(pnl_col2row3, lbl_col2row3, strTag, items);
                            break;
                        case 4:
                            DrawColorChip(pnl_col2row4, lbl_col2row4, strTag, items);
                            break;
                        case 5:
                            DrawColorChip(pnl_col2row5, lbl_col2row5, strTag, items);
                            break;
                        case 6:
                            DrawColorChip(pnl_col2row6, lbl_col2row6, strTag, items);
                            break;
                        case 7:
                            DrawColorChip(pnl_col2row7, lbl_col2row7, strTag, items);
                            break;
                    }
                    break;
                case 3:
                    lbl_col3.Text = "< " + ((int)((items.Value.page - 1) * 5) + items.Value.col).ToString() + " >";
                    switch (items.Value.row)
                    {
                        case 1:
                            DrawColorChip(pnl_col3row1, lbl_col3row1, strTag, items);
                            break;
                        case 2:
                            DrawColorChip(pnl_col3row2, lbl_col3row2, strTag, items);
                            break;
                        case 3:
                            DrawColorChip(pnl_col3row3, lbl_col3row3, strTag, items);
                            break;
                        case 4:
                            DrawColorChip(pnl_col3row4, lbl_col3row4, strTag, items);
                            break;
                        case 5:
                            DrawColorChip(pnl_col3row5, lbl_col3row5, strTag, items);
                            break;
                        case 6:
                            DrawColorChip(pnl_col3row6, lbl_col3row6, strTag, items);
                            break;
                        case 7:
                            DrawColorChip(pnl_col3row7, lbl_col3row7, strTag, items);
                            break;
                    }
                    break;
                case 4:
                    lbl_col4.Text = "< " + ((int)((items.Value.page - 1) * 5) + items.Value.col).ToString() + " >";
                    switch (items.Value.row)
                    {
                        case 1:
                            DrawColorChip(pnl_col4row1, lbl_col4row1, strTag, items);
                            break;
                        case 2:
                            DrawColorChip(pnl_col4row2, lbl_col4row2, strTag, items);
                            break;
                        case 3:
                            DrawColorChip(pnl_col4row3, lbl_col4row3, strTag, items);
                            break;
                        case 4:
                            DrawColorChip(pnl_col4row4, lbl_col4row4, strTag, items);
                            break;
                        case 5:
                            DrawColorChip(pnl_col4row5, lbl_col4row5, strTag, items);
                            break;
                        case 6:
                            DrawColorChip(pnl_col4row6, lbl_col4row6, strTag, items);
                            break;
                        case 7:
                            DrawColorChip(pnl_col4row7, lbl_col4row7, strTag, items);
                            break;
                    }
                    break;
                case 5:
                    lbl_col5.Text = "< " + ((int)((items.Value.page - 1) * 5) + items.Value.col).ToString() + " >";
                    switch (items.Value.row)
                    {
                        case 1:
                            DrawColorChip(pnl_col5row1, lbl_col5row1, strTag, items);
                            break;
                        case 2:
                            DrawColorChip(pnl_col5row2, lbl_col5row2, strTag, items);
                            break;
                        case 3:
                            DrawColorChip(pnl_col5row3, lbl_col5row3, strTag, items);
                            break;
                        case 4:
                            DrawColorChip(pnl_col5row4, lbl_col5row4, strTag, items);
                            break;
                        case 5:
                            DrawColorChip(pnl_col5row5, lbl_col5row5, strTag, items);
                            break;
                        case 6:
                            DrawColorChip(pnl_col5row6, lbl_col5row6, strTag, items);
                            break;
                        case 7:
                            DrawColorChip(pnl_col5row7, lbl_col5row7, strTag, items);
                            break;
                    }
                    break;
            }
        }

        private void txt_move_page_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
            {
                UpdateList(pantones);
            }
        }

        private void hsc_horz_Scroll(object sender, ScrollEventArgs e)
        {
            txt_move_page.Text = hsc_horz.Value.ToString();
            UpdateList(pantones);
        }

        private void cmb_tag_change_SelectedIndexChanged(object sender, EventArgs e)
        {
            switch (cmb_tag_change.SelectedIndex)
            {
                case 0:
                    tag = 0;
                    break;
                case 1:
                    tag = 1;
                    break;
                case 2:
                    tag = 2;
                    break;
            }

            UpdateList(pantones);

        }

        private void cmb_library_SelectedIndexChanged(object sender, EventArgs e)
        {
            switch (cmb_library.SelectedIndex)
            {
                case 0:
                    LoadPCL(Application.StartupPath + "\\Color\\Cotton.pcl");
                    break;
                case 1:
                    LoadPCL(Application.StartupPath + "\\Color\\Paper.pcl");
                    break;
                case 2:
                    LoadPCL(Application.StartupPath + "\\Color\\Nylon.pcl");
                    break;
            }

            UpdateList(pantones);
        }

        private void btn_first_Click(object sender, EventArgs e)
        {
            txt_move_page.Text = Convert.ToString(1);
            UpdateList(pantones);
        }

        private void btn_center_Click(object sender, EventArgs e)
        {
            txt_move_page.Text = Convert.ToString(hsc_horz.Maximum / 2);
            UpdateList(pantones);
        }

        private void btn_end_Click(object sender, EventArgs e)
        {
            txt_move_page.Text = Convert.ToString(hsc_horz.Maximum);
            UpdateList(pantones);
        }

        private void btn_before_Click(object sender, EventArgs e)
        {
            txt_move_page.Text = Convert.ToString(Convert.ToInt32(txt_move_page.Text) - 1);
            UpdateList(pantones);
        }

        private void btn_next_Click(object sender, EventArgs e)
        {
            txt_move_page.Text = Convert.ToString(Convert.ToInt32(txt_move_page.Text) + 1);
            UpdateList(pantones);
        }

        private void btn_exit_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        public Bitmap GetPinkingEffect(Bitmap pantone, int size, Color bg)
        {
            Bitmap bmp = pantone;

            var CurvePointsL = new List<Point>();
            var CurvePointsR = new List<Point>();
            var CurvePointsT = new List<Point>();
            var CurvePointsB = new List<Point>();

            using (var g = Graphics.FromImage(bmp))
            {
                CurvePointsT.Add(new Point(0, 0));
                CurvePointsB.Add(new Point(0, bmp.Height));
                for (int i = 0; i < Math.Ceiling((Decimal)bmp.Width / (size * 2)); i++)
                {
                    CurvePointsT.Add(new Point(size + i * (size * 2), size));
                    CurvePointsT.Add(new Point((i + 1) * (size * 2), 0));

                    CurvePointsB.Add(new Point(size + i * (size * 2), bmp.Height - size));
                    CurvePointsB.Add(new Point((i + 1) * (size * 2), bmp.Height));
                }
                g.FillPolygon(new SolidBrush(bg), CurvePointsT.ToArray());
                g.FillPolygon(new SolidBrush(bg), CurvePointsB.ToArray());

                CurvePointsL.Add(new Point(0, 0));
                CurvePointsR.Add(new Point(bmp.Width, 0));
                for (int i = 0; i < Math.Ceiling((Decimal)bmp.Height / (size * 2)); i++)
                {
                    CurvePointsL.Add(new Point(size, size + i * (size * 2)));
                    CurvePointsL.Add(new Point(0, (i + 1) * (size * 2)));

                    CurvePointsR.Add(new Point(bmp.Width - size, size + i * (size * 2)));
                    CurvePointsR.Add(new Point(bmp.Width, (i + 1) * (size * 2)));
                }
                g.FillPolygon(new SolidBrush(bg), CurvePointsL.ToArray());
                g.FillPolygon(new SolidBrush(bg), CurvePointsR.ToArray());

                pinkingT = new GraphicsPath();
                pinkingB = new GraphicsPath();
                pinkingR = new GraphicsPath();
                pinkingL = new GraphicsPath();
                for(int i=0; i<CurvePointsT.Count - 1; i++)
                {
                    pinkingT.AddLine(CurvePointsT[i], CurvePointsT[i + 1]);
                }
                for (int i = 0; i < CurvePointsR.Count - 1; i++)
                {
                    pinkingR.AddLine(CurvePointsR[i], CurvePointsR[i + 1]);
                }
                for (int i = 0; i < CurvePointsB.Count - 1; i++)
                {
                    pinkingB.AddLine(CurvePointsB[i], CurvePointsB[i + 1]);
                }
                for (int i = 0; i < CurvePointsL.Count - 1; i++)
                {
                    pinkingL.AddLine(CurvePointsL[i], CurvePointsL[i + 1]);
                }
            }
            return bmp;
        }

        Panel prePanel = new Panel();
        public void PanelClick(object sender, EventArgs e)
        {
            //Todo Border 설정하는 거 방법을 바꿔야 할 듯 .. 이미지를 바꿔버리면 다시 지울 수가 없어서...
            prePanel.BorderStyle = BorderStyle.None;
            Panel pnl = (Panel)sender;
            prePanel = pnl;
            
            int index = Convert.ToInt32(pnl.Tag);

            List<Pantone> ptList = pantones.Values.ToList();
            int r = ptList[(Convert.ToInt32(txt_move_page.Text) - 1) * 35 + index].r;
            int g = ptList[(Convert.ToInt32(txt_move_page.Text) - 1) * 35 + index].g;
            int b = ptList[(Convert.ToInt32(txt_move_page.Text) - 1) * 35 + index].b;

            Pen border;
            if(r + g + b / 3 > 128)
            {
                border = new Pen(Brushes.Black, 3);
            }
            else
            {
                border = new Pen(Brushes.White, 3);
            }
            using(Graphics gr = Graphics.FromImage(pnl.BackgroundImage))
            {
                gr.DrawPath(border, pinkingB);
                gr.DrawPath(border, pinkingT);
                gr.DrawPath(border, pinkingR);
                gr.DrawPath(border, pinkingL);

                pnl.Refresh();
            }
           
        }

        public void PanelDoubleClick(object sender, EventArgs e)
        {
            Panel pnl = (Panel)sender;
            int index = Convert.ToInt32(pnl.Tag);

            List<Pantone> ptList = pantones.Values.ToList();
            int r = ptList[(Convert.ToInt32(txt_move_page.Text) - 1) * 35 + index].r;
            int g = ptList[(Convert.ToInt32(txt_move_page.Text) - 1) * 35 + index].g;
            int b = ptList[(Convert.ToInt32(txt_move_page.Text) - 1) * 35 + index].b;
            
            mPalette.cgd_256.CustomColors[mPalette.cgd_256.ColorIndex] = Color.FromArgb(r,g,b);

            ColorChip selectedColor = new ColorChip();
            selectedColor.r = r;
            selectedColor.g = g;
            selectedColor.b = b;
            selectedColor.index = mPalette.cgd_256.ColorIndex;
            switch (mPalette.cmb_library.SelectedIndex)
            {
                case 0:                             //PANTONE
                    selectedColor.library = Library.PANTONE;
                    selectedColor.code = ptList[(Convert.ToInt32(txt_move_page.Text) - 1) * 35 + index].code;
                    break;
                case 1:                             //Printer
                    selectedColor.library = Library.PRINTER;
                    break;
                case 2:                             //Standard
                    selectedColor.library = Library.STANDARD;
                    break;
                case 3:                             //Textile
                    selectedColor.library = Library.TEXTILE;
                    break;
                case 4:                             //User
                    selectedColor.library = Library.USER;
                    break;
            }

            mPalette.mColorList.Insert(selectedColor.index, selectedColor);
            mPalette.mColorList.RemoveAt(selectedColor.index + 1);
        }

        private void tsb_apply_Click(object sender, EventArgs e)
        {

        }
    }
}
