﻿using OpenCvSharp;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;
using cvPoint = OpenCvSharp.Point;
using cvSize = OpenCvSharp.Size;
using Point = System.Drawing.Point;

namespace TexMaster
{
    public partial class Gradient : Form
    {
        Canvas mCanvas;
        public List<Color> colList;
        public List<List<Color>> subColor;
        public int index;
        public cvPoint start, end;
        public Mat colorMask;

        MultiColor multi;

        public Gradient(Canvas canvas)
        {
            InitializeComponent();
            mCanvas = canvas;
            mCanvas.mGradient = this;

            colList = new List<Color>();
            subColor = new List<List<Color>>();

            multi = new MultiColor();
        }

        private void Gradient_Load(object sender, EventArgs e)
        {

        }


        public void gradient_MouseDown(MouseEventArgs e)
        {
            if (subColor.Count == 0) return;

            if (checkBox1.Checked)
            {
                multi.MouseDown(mCanvas.dst, mCanvas.mWorkarea.totalPath, pnl_color, e);
            }
            else
            {
                mCanvas.direction = new GraphicsPath();
            }

            mCanvas.drawing = true;
            start = new cvPoint(e.X, e.Y);
        }

        public void gradient_MouseMove(MouseEventArgs e)
        {
            if (subColor.Count == 0) return;

            if (checkBox1.Checked)
            {
                multi.MouseMove(e);
                mCanvas.PictureBox1.Refresh();
            }
            else
            {
                Point startPt = new Point(start.X, start.Y);
                Point endPt = new Point(end.X, end.Y);
                mCanvas.direction = new GraphicsPath();
                if ((System.Windows.Input.Keyboard.GetKeyStates(System.Windows.Input.Key.LeftShift) & System.Windows.Input.KeyStates.Down) > 0)
                {
                    //# 수평선
                    GraphicsPath line = new GraphicsPath();
                    double angle = 360 - mCanvas.GetAngle(start, end);
                    if ((angle >= 45 && angle < 135) || (angle >= 225 && angle < 315))
                    {
                        line.AddLine(startPt, new Point(startPt.X, endPt.Y));
                    }
                    else
                    {
                        line.AddLine(startPt, new Point(endPt.X, startPt.Y));
                    }
                    mCanvas.direction = line;
                }
                else
                {
                    mCanvas.direction = new GraphicsPath();
                    mCanvas.direction.AddLine(startPt, endPt);
                }

                mCanvas.PictureBox1.Refresh();
                end = new cvPoint(e.X, e.Y);
            }
        }

        public void gradient_MouseUp(MouseEventArgs e)
        {
            if (subColor.Count == 0) return;

            if (checkBox1.Checked)
            {
                multi.MouseUp(mCanvas.dst, pnl_color, e);
                mCanvas.drawing = false;
                mCanvas.PictureBox1.Refresh();
            }
            else
            {
                multi.lastList = multi.colList;
                float angle = (float)mCanvas.GetAngle(start, end);
                Console.WriteLine(angle);

                mCanvas.direction = null;
                mCanvas.drawing = false;
                mCanvas.PictureBox1.Refresh();

                Mat mask = new Mat();
                if (multi.colList.Count > 0)
                {
                    for (int i = 0; i < multi.colList.Count; i++)
                    {
                        Mat hsv = new Mat();
                        Color c = Color.FromArgb((int)multi.colList[i]);
                        Scalar selColor = new Scalar(c.B, c.G, c.R, c.A);
                        Mat ori = mCanvas.dst.Clone();
                        Cv2.CvtColor(ori, hsv, ColorConversionCodes.BGR2HSV);
                        Cv2.InRange(ori, selColor, selColor, hsv);
                        if (i == 0)
                        {
                            mask = hsv;
                        }
                        else
                        {
                            mask += hsv;
                        }
                    }
                }
                else
                {
                    mask = FloodFill(mCanvas.dst, start);
                }
                Mat fill = GradientFill(mask, angle);

                fill.CopyTo(mCanvas.dst, mask);
                mCanvas.PictureBox1.ImageIpl = mCanvas.dst;
            }
        }

        public void gradient_Paint(PaintEventArgs e)
        {
            if (checkBox1.Checked)
            {
                multi.Paint(e);
            }
        }


        public Mat FloodFill(Mat src, cvPoint seedPt)
        {
            Mat hsv = new Mat();

            //# 배경색 제거 - 현재 흰색 -1 임시 적용
            Color c = Color.FromArgb(-1);
            Scalar s = new Scalar(c.B, c.G, c.R, c.A);
            Cv2.InRange(src, s, s, hsv);

            //# 채우기 전 이미지
            Mat ori = hsv.Clone();
            //# 채운 후 이미지
            Cv2.FloodFill(hsv, seedPt, 0);
            Mat diff = new Mat();
            //# 차이비교 - 채워질 영역 mask 반환
            Cv2.BitwiseXor(hsv, ori, diff);
            return diff;
        }

        public Mat GradientFill(Mat mask, float angle)
        {
            //# 각도 계산을 위해 Mat 회전
            Mat mat1 = new Mat();
            Mat matrix = Cv2.GetRotationMatrix2D(new Point2f(mask.Width / 2, mask.Height / 2), angle, 1);
            Cv2.WarpAffine(mask, mat1, matrix, new cvSize(mask.Width, mask.Height));

            //Cv2.ImShow("mat1", mat1);

            //# FloodFill mask boundary 구함
            int top = int.MaxValue, left = int.MaxValue;
            int bottom = 0, right = 0;

            for (int i = 0; i < mat1.Width; i++)
            {
                for (int j = 0; j < mat1.Height; j++)
                {
                    if (mat1.At<int>(j, i) != 0)
                    {
                        if (top > j)
                        {
                            top = j;
                        }
                        if (bottom < j)
                        {
                            bottom = j;
                        }
                    }
                }
            }

            for (int i = 0; i < mat1.Height; i++)
            {
                for (int j = 0; j < mat1.Width; j++)
                {
                    if (mat1.At<int>(i, j) != 0)
                    {
                        if (left > j)
                        {
                            left = j;
                        }
                        if (right < j)
                        {
                            right = j;
                        }
                    }
                }
            }

            Console.WriteLine("{0}, {1}, {2}, {3}", left, top, right - left, bottom - top);

            //# boundary 크기
            Mat mat2 = new Mat();

            if ((right - left) * Math.Sqrt(2) > mCanvas.dst.Width || (bottom - top) * Math.Sqrt(2) > mCanvas.dst.Height)
            {
                Console.WriteLine("범위가 큽니다.");
                int tWidth = (int)((right - left) * Math.Sqrt(2));
                int tHeight = (int)((bottom - top) * Math.Sqrt(2));
                Mat totalMat = GetGradient(tWidth, tHeight);

                matrix = Cv2.GetRotationMatrix2D(new Point2f(tWidth / 2, tHeight / 2), (-angle), 1);
                Cv2.WarpAffine(totalMat, mat2, matrix, new cvSize(totalMat.Width, totalMat.Height));

                mat2 = mat2[new Rect(tWidth / 2 - mCanvas.dst.Width / 2, tHeight / 2 - mCanvas.dst.Height / 2, mask.Width, mask.Height)];
                //Cv2.ImShow("total", mat2);
            }
            else
            {
                //# boundary에 gradient 효과 넣기
                Mat tempMat = new Mat(new cvSize(mat1.Width, mat1.Height), MatType.CV_8UC4, 0);
                tempMat[new Rect(left, top, right - left, bottom - top)] = GetGradient(right - left, bottom - top);
                //# mat 다시 회전 / mask 만큼 자르기
                matrix = Cv2.GetRotationMatrix2D(new Point2f(mask.Width / 2, mask.Height / 2), (-angle), 1);
                Cv2.WarpAffine(tempMat, mat2, matrix, new cvSize(mask.Width, mask.Height));
            }


            Mat cropMat = new Mat();
            mat2.CopyTo(cropMat, mask);
            return cropMat;
        }

        public void gradient_MousePaint(MouseEventArgs e)
        {

        }

        public Mat GetGradient(int width, int height)
        {
            Mat gradient = new Mat(new cvSize(width, height), MatType.CV_8UC4, 0);
            Random r = new Random();

            if (colList.Count == 1)
            {
                Color c = colList[0];
                Scalar s = new Scalar(c.B, c.G, c.R, c.A);
                gradient.SetTo(s);
            }
            else
            {
                //# 전체 color 수 파악 및 단위 넓이 계산
                List<Color> totalList = new List<Color>();

                for (int i = 0; i < subColor.Count; i++)
                {
                    for (int j = 0; j < subColor[i].Count - 1; j++)
                    {
                        totalList.Add(subColor[i][j]);
                    }

                    if (i == subColor.Count - 1)
                    {
                        totalList.Add(subColor[i][subColor[i].Count - 1]);
                    }
                }

                for (int i = 0; i < totalList.Count - 1; i++)
                {
                    for (int w = gradient.Width / (totalList.Count - 1) * i; w < gradient.Width / (totalList.Count - 1) * (i + 1); w++)
                    {
                        for (int h = 0; h < gradient.Height; h++)
                        {
                            if (r.Next(gradient.Width / (totalList.Count - 1) * i, gradient.Width / (totalList.Count - 1) * (i + 1)) > w)
                            {
                                gradient.Set<int>(h, w, totalList[i].ToArgb());
                            }
                            else
                            {
                                gradient.Set<int>(h, w, totalList[i + 1].ToArgb());
                            }
                        }
                    }
                }
            }

            return gradient;
        }

        private void pic_colorList_Paint(object sender, PaintEventArgs e)
        {
            for (int i = 0; i < colList.Count; i++)
            {
                e.Graphics.FillRectangle(new SolidBrush(colList[i]), new RectangleF(i * (float)pic_colorList.Width / colList.Count, 0, (float)pic_colorList.Width / colList.Count, pic_colorList.Height));
            }
        }

        private void nud_level_ValueChanged(object sender, EventArgs e)
        {
            List<Color> addedList = new List<Color>();
            Color start = colList[trb_colList.Value - 1];
            Color end = colList[trb_colList.Value];

            //int minR = start.R < end.R ? start.R : end.R;
            //int minG = start.G < end.G ? start.G : end.G;
            //int minB = start.B < end.B ? start.B : end.B;

            int offsetR = (end.R - start.R) / ((int)nud_level.Value - 1);
            int offsetG = (end.G - start.G) / ((int)nud_level.Value - 1);
            int offsetB = (end.B - start.B) / ((int)nud_level.Value - 1);

            for (int i = 0; i < nud_level.Value; i++)
            {
                if (i == nud_level.Value - 1)
                {
                    addedList.Add(end);
                    break;
                }
                Color newColor = Color.FromArgb(start.R + offsetR * i, start.G + offsetG * i, start.B + offsetB * i);
                //Console.WriteLine(newColor);
                addedList.Add(newColor);
            }

            subColor[trb_colList.Value - 1] = addedList;

            Mat mat = GetGradient(pic_gradient.Width, pic_gradient.Height);
            pic_gradient.ImageIpl = mat;
        }

        private void trb_colList_ValueChanged(object sender, EventArgs e)
        {
            if (trb_colList.Value <= 0 || trb_colList.Value >= colList.Count)
            {
                nud_level.Enabled = false;
            }
            else
            {
                nud_level.Enabled = true;
                nud_level.Value = subColor[trb_colList.Value - 1].Count;
            }
        }

        public void AddColor(Color color)
        {
            if (colList.Count == 5)
            {
                colList.RemoveAt(index % 5);
            }
            colList.Insert(index % 5, color);

            if (subColor.Count != colList.Count - 1)
            {
                List<Color> list = new List<Color>();
                list.Add(colList[colList.Count - 2]);
                list.Add(colList[colList.Count - 1]);
                subColor.Add(list);
            }

            index++;
            pic_gradient.ImageIpl = GetGradient(pic_gradient.Width, pic_gradient.Height);
            pic_colorList.Refresh();
            trb_colList.Maximum = colList.Count;
        }

        private void btn_multi_new_Click(object sender, EventArgs e)
        {
            if (checkBox1.Checked)
            {
                multi.SelectClear(pnl_color);
            }
        }

        private void btn_multi_all_Click(object sender, EventArgs e)
        {
            if (checkBox1.Checked)
            {
                multi.SelectAll(pnl_color, mCanvas.dst, mCanvas.mWorkarea.totalPath);
            }
        }

        private void btn_multi_area_Click(object sender, EventArgs e)
        {
            if (checkBox1.Checked)
            {
                multi.SetSelectState(btn_multi_area);
            }
        }

        private void btn_multi_insert_Click(object sender, EventArgs e)
        {
            if (checkBox1.Checked)
            {
                multi.SetSelectState(btn_multi_insert);
            }
        }

        private void btn_multi_pre_Click(object sender, EventArgs e)
        {
            if (checkBox1.Checked)
            {
                multi.SelectRestore(pnl_color);
            }
        }
    }
}
