﻿using System;
using System.Drawing;
using System.Windows.Forms;
using TexMaster.Source;

namespace TexMaster
{
    public partial class Grid : Form
    {
        Canvas mCanvas;

        public const int ADD = 1;
        public const int SUB = 2;
        public const int MUL = 3;
        public const int DIV = 4;

        public static Color gridColor;
        public static Color selColor;
        public static int gIntervalX;
        public static int gIntervalY;
        public static int gGroup;
        public static bool bInputX;    //# true : x, false : y

        public Grid(Canvas canvas)
        {
            InitializeComponent();
            gridColor = Color.Black;        //# default color
            selColor = Color.Black;
            bInputX = true;
            gIntervalX = 5;
            gIntervalY = 5;
            mCanvas = canvas;
        }

        private void btn_gap_x_Click(object sender, EventArgs e)
        {
            bInputX = true;
            if (pnl_cal.Visible)
            {
                pnl_cal.Visible = false;
            }
            else
            {
                pnl_cal.Visible = true;
            }

            pnl_cal.Location = new Point(btn_gap_x.Location.X, txt_gap_x.Location.Y + txt_gap_x.Height);
        }

        private void btn_gap_y_Click(object sender, EventArgs e)
        {
            bInputX = false;
            if (pnl_cal.Visible)
            {
                pnl_cal.Visible = false;
            }
            else
            {
                pnl_cal.Visible = true;
            }

            pnl_cal.Location = new Point(btn_gap_y.Location.X, txt_gap_y.Location.Y + txt_gap_y.Height);
        }

        private void pic_grid_Paint(object sender, PaintEventArgs e)
        {
            for (int i = 0; i < pic_grid.Width; i++)
            {
                if (i % 5 == 0)     //# device per 5px
                {
                    e.Graphics.DrawLine(new Pen(gridColor), new Point(i, 0), new Point(i, pic_grid.Height));
                }

                if (nud_line_section.Value != 0 && i % (5 * (int)nud_line_section.Value) == 0)
                {
                    e.Graphics.DrawLine(new Pen(selColor), new Point(i, 0), new Point(i, pic_grid.Height));
                }
            }

            for (int i = 0; i < pic_grid.Height; i++)
            {
                if (i % 5 == 0)     //# device per 5px
                {
                    e.Graphics.DrawLine(new Pen(gridColor), new Point(0, i), new Point(pic_grid.Width, i));
                }

                if (nud_line_section.Value != 0 && i % (5 * (int)nud_line_section.Value) == 0)
                {
                    e.Graphics.DrawLine(new Pen(selColor), new Point(0, i), new Point(pic_grid.Width, i));
                }
            }
        }

        private void btn_grid_color_Click(object sender, EventArgs e)
        {
            cld_grid_color.ShowDialog();
            pnl_grid_color.BackColor = cld_grid_color.Color;
            gridColor = cld_grid_color.Color;
            pic_grid.Refresh();
        }

        private void btn_section_color_Click(object sender, EventArgs e)
        {
            cld_grid_color.ShowDialog();
            pnl_section_color.BackColor = cld_grid_color.Color;
            selColor = cld_grid_color.Color;
            pic_grid.Refresh();
        }

        private void nud_line_section_ValueChanged(object sender, EventArgs e)
        {
            pic_grid.Refresh();
        }

        private void btn_run_Click(object sender, EventArgs e)
        {
            gIntervalX = Convert.ToInt32(txt_gap_x.Text);
            gIntervalY = Convert.ToInt32(txt_gap_y.Text);

            int dpi = 160;
            if (mCanvas.unit == UnitType.INCH)
            {
                FullView.gridX = gIntervalX / (float)dpi;
                FullView.gridY = gIntervalX / (float)dpi;
            }
            else if (mCanvas.unit == UnitType.CM)
            {
                FullView.gridX = 2.54F * gIntervalX / (float)dpi;
                FullView.gridY = 2.54F * gIntervalX / (float)dpi;
            }
            else if (mCanvas.unit == UnitType.DOT)
            {
                FullView.gridX = gIntervalX;
                FullView.gridY = gIntervalY;
            }

            gGroup = (int)nud_line_section.Value;
            mCanvas.Refresh();
            this.Close();
        }

        private void btn_cancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btn_default_Click(object sender, EventArgs e)
        {
            rdo_grid_dot.Checked = true;
            gridColor = Color.Black;        //# default color
            selColor = Color.Black;
            bInputX = true;
            gIntervalX = 5;
            gIntervalY = 5;
            this.Refresh();
        }

        private void Grid_Load(object sender, EventArgs e)
        {
            txt_gap_x.Text = gIntervalX.ToString();
            txt_gap_y.Text = gIntervalY.ToString();
            pnl_grid_color.BackColor = gridColor;
            pnl_section_color.BackColor = selColor;
        }
    }
}
