﻿using System.Drawing;
using System.Windows.Forms;

namespace TexMaster
{
    public partial class InputSize : Form
    {
        private Vector mVector;

        public InputSize(Vector vector ,Mode mode)
        {
            InitializeComponent();
            mVector = vector;
            switch (mode)
            {
                case Mode.LINE:
                    pnl_line.Location = new System.Drawing.Point(1, 1);
                    pnl_line.Visible = true;
                    pnl_rect.Visible = false;
                    break;
                case Mode.RECT:
                case Mode.CIRCLE:
                case Mode.SQUARE:
                case Mode.ELLIPSE:
                    pnl_rect.Location = new System.Drawing.Point(1, 1);
                    pnl_line.Visible = false;
                    pnl_rect.Visible = true;
                    break;
                default:
                    return;
            }

        }

        private void btn_line_ok_Click(object sender, System.EventArgs e)
        {
            float length, angle;
            if(float.TryParse(txt_length.Text, out length) && float.TryParse(txt_angle.Text, out angle))
            {
                if(length == 0)
                {
                    MessageBox.Show("NO!!Zero");
                }
                mVector.CreateObject((float)(length * 37.7952755906), angle);
            }
            Close();
        }

        private void btn_line_cancel_Click(object sender, System.EventArgs e)
        {
            Close();
        }

        private void btn_rect_ok_Click(object sender, System.EventArgs e)
        {
            float width, height;
            if (float.TryParse(txt_width.Text, out width) && float.TryParse(txt_height.Text, out height))
            {
                if (width == 0 || height == 0)
                {
                    MessageBox.Show("NO!!Zero");
                }
                mVector.CreateObject((float)(width * 37.7952755906), (float)(height * 37.7952755906));
            }
            Close();
        }

        private void btn_rect_cancel_Click(object sender, System.EventArgs e)
        {
            Close();
        }

        private void txt_length_KeyDown(object sender, KeyEventArgs e)
        {
            if(e.KeyCode == Keys.Enter)
            {
                btn_line_ok.PerformClick();
            }
        }

        private void txt_width_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
            {
                btn_rect_ok.PerformClick();
            }
        }
    }
}
