﻿using System;
using System.Drawing;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;
using System.Windows.Forms;

namespace TexMaster
{
    public partial class MainForm : Form
    {
        private int childFormNumber = 0;
        PenManager specialPen;
        FullView fullView;
        Palette palette;
        MainMenu mainmenu;
        Layer layer;
        Vector vector;
        Canvas canvas;

        public MainForm()
        {
            InitializeComponent();
        }

        private void ReArrange()
        {
            specialPen.StartPosition = FormStartPosition.Manual;
            fullView.StartPosition = FormStartPosition.Manual;
            palette.StartPosition = FormStartPosition.Manual;
            mainmenu.StartPosition = FormStartPosition.Manual;
            layer.StartPosition = FormStartPosition.Manual;
            canvas.StartPosition = FormStartPosition.Manual;

            specialPen.Width = 213;
            specialPen.Height = 145;

            fullView.Width = specialPen.Width;
            palette.Width = specialPen.Width;
            mainmenu.Width = specialPen.Width;
            layer.Width = specialPen.Width;

            canvas.Location = new Point(0, 0);
            specialPen.Location = new Point(this.ClientSize.Width - specialPen.Width - 4, 0);
            fullView.Location = new Point(this.ClientSize.Width - fullView.Width - 4, specialPen.Height);
            palette.Location = new Point(this.ClientSize.Width - palette.Width - 4, specialPen.Height + fullView.Height);
            mainmenu.Location = new Point(this.ClientSize.Width - mainmenu.Width - 4, specialPen.Height + fullView.Height + palette.Height);
            layer.Location = new Point(this.ClientSize.Width - layer.Width - 4, specialPen.Height + fullView.Height + palette.Height + mainmenu.Height);

        }


        private void ExitToolsStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void CutToolStripMenuItem_Click(object sender, EventArgs e)
        {
        }

        private void CopyToolStripMenuItem_Click(object sender, EventArgs e)
        {
        }

        private void PasteToolStripMenuItem_Click(object sender, EventArgs e)
        {
        }

        private void StatusBarToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ssr_main.Visible = tsm_statusBar.Checked;
        }

        private void CascadeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            LayoutMdi(MdiLayout.Cascade);
        }

        private void TileVerticalToolStripMenuItem_Click(object sender, EventArgs e)
        {
            LayoutMdi(MdiLayout.TileVertical);
        }

        private void TileHorizontalToolStripMenuItem_Click(object sender, EventArgs e)
        {
            LayoutMdi(MdiLayout.TileHorizontal);
        }

        private void ArrangeIconsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            LayoutMdi(MdiLayout.ArrangeIcons);
        }

        private void CloseAllToolStripMenuItem_Click(object sender, EventArgs e)
        {
            foreach (Form childForm in MdiChildren)
            {
                childForm.Close();
            }
        }

        private void MDIParent1_Load(object sender, EventArgs e)
        {

            vector = new Vector();
            vector.MdiParent = this;
            vector.Text = "벡터";
            vector.Hide();

            canvas = new Canvas(vector);
            canvas.MdiParent = this;
            canvas.Text = "Noname" + childFormNumber++ + ".txm";
            canvas.Height = this.ClientSize.Height - mns_main.Height - ssr_main.Height - tab_canvas.Height - 20;
            canvas.Width = canvas.Height;

            layer = new Layer(canvas);
            layer.MdiParent = this;
            layer.Text = "레이어";

            mainmenu = new MainMenu(canvas, vector);
            mainmenu.MdiParent = this;
            mainmenu.Text = "주 메뉴";

            specialPen = new PenManager(canvas);
            specialPen.MdiParent = this;
            specialPen.Text = "특수펜";


            palette = new Palette(canvas);
            palette.MdiParent = this;
            palette.Text = "팔레트";

            fullView = new FullView(canvas);
            fullView.MdiParent = this;
            fullView.Text = "전체보기";


            ReArrange();
            specialPen.Show();
            fullView.Show();
            palette.Show();
            mainmenu.Show();
            canvas.Show();

            TabPage page = new TabPage();
            page.Text = canvas.Text;
            tab_canvas.Controls.Add(page);
            tab_canvas.SelectedIndex = childFormNumber - 1;
        }

        private void tsm_256_Click(object sender, EventArgs e)
        {

        }

        private void tsm_manager_Click(object sender, EventArgs e)
        {
            //FileManager fileManager = new FileManager();
            //fileManager.ShowDialog();

            OpenFileDialog fileDialog = new OpenFileDialog();
            fileDialog.Filter = "Image Files(*.BMP;*.JPG;*.GIF)|*.BMP;*.JPG;*.GIF|TexMaster File|*.txm|All files (*.*)|*.*";
            fileDialog.ShowDialog();

            if (fileDialog.FileName == null) return;
            FileStream fs = new FileStream(fileDialog.FileName, FileMode.Open);
            BinaryFormatter formatter = new BinaryFormatter();

            try
            {
                //FileInfo fileInfo = (FileInfo)formatter.Deserialize(fs);
                Image openImage = (Image)formatter.Deserialize(fs);
            }
            catch
            {
                Console.WriteLine("fail");
                throw;
            }
            finally
            {
                fs.Close();
            }
        }

        private void tsm_resize_Click(object sender, EventArgs e)
        {
            ResizeCanvas resizeCanvas = new ResizeCanvas();
            resizeCanvas.ShowDialog();
        }

        private void tsm_enlarge_Click(object sender, EventArgs e)
        {
            EnlargeCanvas enlargeCanvas = new EnlargeCanvas();
            enlargeCanvas.ShowDialog();
        }

        private void tsm_print_set_Click(object sender, EventArgs e)
        {
            prd_set.ShowDialog();
        }

        private void tsm_print_Click(object sender, EventArgs e)
        {
            PrintForm printForm = new PrintForm();
            printForm.ShowDialog();
        }

        private void tsm_font_set_Click(object sender, EventArgs e)
        {
            fnd_set.ShowDialog();
        }

        private void tsm_env_set_Click(object sender, EventArgs e)
        {
            EnvSetting env = new EnvSetting();
            env.ShowDialog();
        }

        private void tsm_exit_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void tsm_pen_Click(object sender, EventArgs e)
        {
            if (tsm_pen.Checked)
            {
                tsm_pen.Checked = false;
                specialPen.Visible = false;
            }
            else
            {
                tsm_pen.Checked = true;
                specialPen.Visible = true;
            }
        }

        private void tsm_fullView_Click(object sender, EventArgs e)
        {
            if (tsm_fullView.Checked)
            {
                tsm_fullView.Checked = false;
                fullView.Visible = false;
            }
            else
            {
                tsm_fullView.Checked = true;
                fullView.Visible = true;
            }
        }

        private void tsm_palette_Click(object sender, EventArgs e)
        {
            if (tsm_palette.Checked)
            {
                tsm_palette.Checked = false;
                palette.Visible = false;
            }
            else
            {
                tsm_palette.Checked = true;
                palette.Visible = true;
            }
        }

        private void tsm_mainMenu_Click(object sender, EventArgs e)
        {
            if (tsm_mainMenu.Checked)
            {
                tsm_mainMenu.Checked = false;
                mainmenu.Visible = false;
            }
            else
            {
                tsm_mainMenu.Checked = true;
                mainmenu.Visible = true;
            }

        }

        private void tsm_layer_Click(object sender, EventArgs e)
        {
            if (tsm_layer.Checked)
            {
                tsm_layer.Checked = false;
                //layer.Visible = false;
                layer.Hide();
            }
            else
            {
                tsm_layer.Checked = true;
                //layer.Visible = true;
                layer.Show();
            }
        }

        private void tsm_reArrange_Click(object sender, EventArgs e)
        {
            ReArrange();
        }

        private void tsm_statusBar_Click(object sender, EventArgs e)
        {
            if (tsm_statusBar.Checked)
            {
                tsm_statusBar.Checked = false;
                ssr_main.Visible = false;
            }
            else
            {
                tsm_statusBar.Checked = true;
                ssr_main.Visible = true;
            }
        }

        private void tsm_cascade_Click(object sender, EventArgs e)
        {
            this.LayoutMdi(MdiLayout.Cascade);
        }

        private void tsm_tileH_Click(object sender, EventArgs e)
        {
            this.LayoutMdi(MdiLayout.TileHorizontal);
        }

        private void tsm_tileV_Click(object sender, EventArgs e)
        {
            this.LayoutMdi(MdiLayout.TileVertical);
        }

        private void tsm_arrange_Click(object sender, EventArgs e)
        {
            this.LayoutMdi(MdiLayout.ArrangeIcons);
        }

        private void tsm_about_Click(object sender, EventArgs e)
        {
            About about = new About();
            about.ShowDialog();
        }

        private void tsm_hotkey_Click(object sender, EventArgs e)
        {
            HotKey hotKey = new HotKey();
            hotKey.ShowDialog();
        }

        private void tsm_save_Click(object sender, EventArgs e)
        {
            sfd_canvase.ShowDialog();
        }

        private void tsm_canvas_tab_Click(object sender, EventArgs e)
        {
            if (tsm_canvas_tab.Checked)
            {
                tsm_canvas_tab.Checked = false;
                tab_canvas.Visible = false;
            }
            else
            {
                tsm_canvas_tab.Checked = true;
                tab_canvas.Visible = true;

                tab_canvas.TabPages.Clear();

                for (int idx = 0; idx < MdiChildren.Length; idx++)
                {
                    string title = MdiChildren[idx].Text;
                    TabPage myTabPage = new TabPage(title);
                    tab_canvas.TabPages.Add(myTabPage);

                }
            }
        }

        private void tsm_intensity_Click(object sender, EventArgs e)
        {
            AForge aForge = new AForge();
            aForge.Show();
        }

        private void tsm_full_Click(object sender, EventArgs e)
        {
            CreateCanvas createCanvas = new CreateCanvas();
            createCanvas.MdiParent = this;
            createCanvas.StartPosition = FormStartPosition.CenterScreen;
            createCanvas.Show();
        }

        public void CreateFile()
        {
            Vector vector = new Vector();
            vector.MdiParent = this;

            Canvas canvas = new Canvas(vector);
            canvas.MdiParent = this;
            canvas.Text = "Noname" + childFormNumber++ + ".txm";
            canvas.Height = this.ClientSize.Height - mns_main.Height - ssr_main.Height - tab_canvas.Height - 20;
            canvas.Width = canvas.Height;

            PenManager specialPen = new PenManager(canvas);
            specialPen.MdiParent = this;

            Palette palette = new Palette(canvas);
            palette.MdiParent = this;

            MainMenu mainmenu = new MainMenu(canvas, vector);
            mainmenu.MdiParent = this;

            canvas.StartPosition = FormStartPosition.Manual;
            canvas.Location = new Point(0, 0);
            canvas.Show();

            TabPage page = new TabPage();
            page.Text = canvas.Text;
            tab_canvas.Controls.Add(page);

            tab_canvas.SelectedIndex = childFormNumber - 1;
        }

        private void tab_canvas_SelectedIndexChanged(object sender, EventArgs e)
        {
            for (int i = 0; i < MdiChildren.Length; i++)
            {
                if (tab_canvas.SelectedTab.Text == MdiChildren[i].Text)
                {
                    MdiChildren[i].Activate();
                }
            }
        }
    }
}
