﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;

namespace TexMaster
{
    public enum MainMode
    {
        WORKAREA, MOVE, COLOR, KMEAN, REPEAT, MIRROR, DRAW, FILL,
        GRADIENT, STIPPLE, PATTERN, ZOOM, STRIPE, SEPARATE, STITCH, TEXT, 
        COLORWAY, SMOOTH, SCRATCH, VECTOR, ASSEM, CLEAR, SHADOW, UNDO,
        FILE, PRINT, SCAN
    }

    public partial class MainMenu : Form
    {
        public static MainMode mode;
        Vector mVector;
        Canvas mCanvas;

        List<Form> formList = new List<Form>();
        List<ToolStripButton> tsbList = new List<ToolStripButton>();

        public MainMenu(Canvas canvas, Vector Vector)
        {
            InitializeComponent();
            mVector = Vector;
            mCanvas = canvas;
            mCanvas.menu = this;

            WorkArea work = new WorkArea(mCanvas);
            MoveCopy move = new MoveCopy(mCanvas);
            ColorChange color = new ColorChange(mCanvas);
            Kmean kmean = new Kmean(mCanvas);
            AutoRepeat repeat = new AutoRepeat(mCanvas);
            Reflection reverse = new Reflection(mCanvas);
            Draw draw = new Draw(mCanvas);
            Fill fill = new Fill(mCanvas);

            //SpreadFill spreadFill = new SpreadFill(canvas);
            Gradient gradient = new Gradient(mCanvas);
            Stipple stipple = new Stipple(mCanvas);
            PatternRepeat pattern = new PatternRepeat(mCanvas);
            Reproportion zoom = new Reproportion(mCanvas);
            Stripe stripe = new Stripe(mCanvas);
            Separate separate = new Separate(mCanvas);
            Stitch stitch = new Stitch(mCanvas);
            TextDraw text = new TextDraw(mCanvas);

            ColorWay colorWay = new ColorWay(mCanvas);
            Smooth smooth = new Smooth(mCanvas);
            Scratch scratch = new Scratch(mCanvas);
            Assemble assemble = new Assemble(mCanvas);
            Clear clear = new Clear(mCanvas);
            Shadow shadow = new Shadow(mCanvas);
            Undo undo = new Undo(mCanvas);

            FileManager file = new FileManager(mCanvas);
            PrintForm print = new PrintForm(mCanvas);

            formList.Add(work);
            formList.Add(move);
            formList.Add(color);
            formList.Add(kmean);
            formList.Add(repeat);
            formList.Add(reverse);
            formList.Add(draw);
            formList.Add(fill);

            formList.Add(gradient);
            formList.Add(stipple);
            formList.Add(pattern);
            formList.Add(zoom);
            formList.Add(stripe);
            formList.Add(separate);
            formList.Add(stitch);
            formList.Add(text);

            formList.Add(colorWay);
            formList.Add(smooth);
            formList.Add(scratch);
            formList.Add(mVector); //# add Vector Form
            formList.Add(assemble);
            formList.Add(clear);
            formList.Add(shadow);
            formList.Add(undo);

            formList.Add(file);
            formList.Add(print);

            tsbList.Add(tsb_work);
            tsbList.Add(tsb_move);
            tsbList.Add(tsb_color);
            tsbList.Add(tsb_kmean);
            tsbList.Add(tsb_repeat);
            tsbList.Add(tsb_reverse);
            tsbList.Add(tsb_draw);
            tsbList.Add(tsb_fill);

            tsbList.Add(tsb_gradient);
            tsbList.Add(tsb_stipple);
            tsbList.Add(tsb_pattern);
            tsbList.Add(tsb_zoom);
            tsbList.Add(tsb_stripe);
            tsbList.Add(tsb_separate);
            tsbList.Add(tsb_stitch);
            tsbList.Add(tsb_text);

            tsbList.Add(tsb_colorway);
            tsbList.Add(tsb_smooth);
            tsbList.Add(tsb_scratch);
            tsbList.Add(tsb_vector);
            tsbList.Add(tsb_assemble);
            tsbList.Add(tsb_clear);
            tsbList.Add(tsb_shadow);
            tsbList.Add(tsb_undo);

            tsbList.Add(tsb_file);
            tsbList.Add(tsb_print);
        }

        private void InitForm(Form form)
        {
            form.MdiParent = this.MdiParent;
            switch (form.Name)
            {
                case "Stitch":
                    form.Width = this.Width;
                    form.StartPosition = FormStartPosition.Manual;
                    form.Location = new Point(this.Left, this.Top + this.Height);
                    mCanvas.mDraw.shape = TShape.LINE;
                    mCanvas.mDrawObject = CanvasType.BITMAP;
                    break;
                case "Stripe":
                case "FileManager":
                case "PrintForm":
                    form.StartPosition = FormStartPosition.CenterScreen;
                    break;
                case "Kmean":
                    form.StartPosition = FormStartPosition.Manual;
                    form.Location = new Point(0, 0);
                    form.Width = this.Parent.Width - this.Width - 4;
                    form.Height = this.Parent.Height - 38;
                    break;
                default:
                    form.Width = this.Width;
                    form.StartPosition = FormStartPosition.Manual;
                    form.Location = new Point(this.Left, this.Top + this.Height);
                    break;
            }

            form.Show();
            form.BringToFront();
        }

        private void ButtonClick(object sender, EventArgs e)
        {
            mode = MainMode.DRAW;
            mCanvas.mDrawObject = CanvasType.BITMAP;
            int index = 7;
            //# check clicked button
            for (int i = 0; i < tsbList.Count; i++)
            {
                tsbList[i].Checked = false;
                if (sender.Equals(tsbList[i]))
                {
                    tsbList[i].Checked = true;
                    mode = (MainMode)i;
                    index = i;
                }
            }

            switch (mode)
            {
                case MainMode.DRAW:
                    mCanvas.mDrawObject = CanvasType.BITMAP;
                    break;
                case MainMode.WORKAREA:
                case MainMode.MOVE:
                    //mCanvas.mDrawObject = DrawObject.WORKAREA;
                    break;
                case MainMode.VECTOR:
                    mCanvas.mDrawObject = CanvasType.VECTOR;
                    mVector.bitCanvas = mCanvas;
                    mVector.pictureBox1 = mCanvas.PictureBox1;
                    break;
                case MainMode.ZOOM:
                    mCanvas.mReproportion.InitZoomData();
                    break;
                case MainMode.SHADOW:
                    mCanvas.mShadow.SetShadowData();
                    break;
            }

            Console.WriteLine(mode);
            mCanvas.tsl_mode.Text = mode.ToString().ToLower();
            InitForm(formList[index]);
        }
    }
}
