﻿using OpenCvSharp;
using Svg;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Linq;
using System.Windows.Forms;
using cvPoint = OpenCvSharp.Point;
using cvRect = OpenCvSharp.Rect;
using cvSize = OpenCvSharp.Size;
using Input = System.Windows.Input;

namespace TexMaster
{
    public partial class Assemble : Form
    {
        public PointF[] assemPoints;

        private Canvas mCanvas;
        private int index;
        private int mode;                           //# -1 : 이미지 붙이기, 0 : 이미지 변형 포인트 추가, 1 : 이미지 변형 포인트 이동

        private List<PointF> warpPoints;
        private List<PointF[]> horiLine, vertLine;  //# 가로, 세로 선 Point를 담을 리스트
        private List<PointF[]> polygon;             //# 가로, 세로 선으로 이루어진 4각형 포인트를 담을 리스트
        private List<int[]> selIndex;               //# 포인트 이동 시 4각형의 점 Index를 기억할 리스트
        private List<Mat> polyMat;                  //# polygon으로 자른 Mat
        private List<Mat> warpMat;
        private byte[] rectType;
        private RectangleF rect;
        private bool isMove = false;

        public Assemble(Canvas canvas)
        {
            InitializeComponent();
            mCanvas = canvas;
            mCanvas.mAssem = this;
            assemPoints = new PointF[4];
            warpPoints = new List<PointF>();
            horiLine = new List<PointF[]>();
            vertLine = new List<PointF[]>();
            polygon = new List<PointF[]>();
            polyMat = new List<Mat>();
            warpMat = new List<Mat>();
            rectType = new byte[4] { 0, 1, 1, 129 };
        }

        private void Assemble_Load(object sender, EventArgs e)
        {
            btn_point.Enabled = true;
            btn_cancel.Enabled = false;
            btn_assem.Enabled = false;

            index = -1;
        }

        public void assem_MouseDown(MouseEventArgs e)
        {
            //if (!mCanvas.drawing) return;
            mCanvas.drawing = true;
            switch (mode)
            {
                case -1:
                    index++;
                    assemPoints[index] = e.Location;

                    mCanvas.PictureBox1.Refresh();

                    if (index >= 0)
                        btn_cancel.Enabled = true;

                    if (index == 3) //# 이미 포인트 지정을 끝냈을 때
                    {
                        index = -1;
                        btn_assem.Enabled = true;
                        btn_cancel.Enabled = false;
                    }
                    break;
                case 0:
                    if (!rect.Contains(e.Location)) return;

                    if ((Input.Keyboard.GetKeyStates(Input.Key.LeftShift) & Input.KeyStates.Down) > 0)    //# 가로
                    {
                        horiLine = horiLine.OrderBy(a => a[0].Y).ToList();

                        PointF hori1, hori2;
                        hori1 = new PointF(rect.Left, e.Y);
                        hori2 = new PointF(rect.Right, e.Y);

                        if (horiLine.Contains(new PointF[2] { hori1, hori2 })) return;

                        horiLine.Add(new PointF[2] { hori1, hori2 });
                        for (int i = 0; i < vertLine.Count; i++)
                        {
                            PointF inter = new PointF();
                            if (mCanvas.mVector.GetIntersectPoint2D(vertLine[i][0], vertLine[i][1], hori1, hori2, ref inter))
                            {
                                warpPoints.Add(inter);
                            }
                        }
                    }
                    else //# 세로
                    {
                        vertLine = vertLine.OrderBy(a => a[0].X).ToList();

                        PointF vert1, vert2;
                        vert1 = new PointF(e.X, rect.Top);
                        vert2 = new PointF(e.X, rect.Bottom);

                        if (vertLine.Contains(new PointF[2] { vert1, vert2 })) return;

                        vertLine.Add(new PointF[2] { vert1, vert2 });
                        for (int i = 0; i < horiLine.Count; i++)
                        {
                            PointF inter = new PointF();
                            if (mCanvas.mVector.GetIntersectPoint2D(horiLine[i][0], horiLine[i][1], vert1, vert2, ref inter))
                            {
                                warpPoints.Add(inter);
                            }
                        }
                    }

                    mCanvas.PictureBox1.Refresh();
                    warpPoints = warpPoints.OrderBy(a => a.Y).ThenBy(b => b.X).ToList();
                    SetPolygon(warpPoints);
                    mCanvas.PictureBox1.Refresh();
                    break;
                case 1:
                    RectangleF ptRect;
                    int size = mCanvas.mVector.handleSize;

                    selIndex = new List<int[]>();
                    for (int i = 0; i < polygon.Count; i++)
                    {
                        for (int j = 0; j < polygon[i].Length; j++)
                        {
                            ptRect = new RectangleF(polygon[i][j].X - size, polygon[i][j].Y - size, size * 2, size * 2);
                            if (ptRect.Contains(e.Location))
                            {
                                isMove = true;
                                mCanvas.drawing = true;
                                selIndex.Add(new int[2] { i, j });
                            }
                        }
                    }
                    mCanvas.PictureBox1.Refresh();
                    break;
            }
        }
        public void assem_MouseMove(MouseEventArgs e)
        {
            if (!mCanvas.drawing) return;

            if (isMove)
            {
                for (int i = 0; i < selIndex.Count; i++)
                {
                    polygon[selIndex[i][0]][selIndex[i][1]] = e.Location;
                }
                mCanvas.PictureBox1.Refresh();
            }
        }
        public void assem_MouseUp(MouseEventArgs e)
        {
            isMove = false;
            mCanvas.drawing = false;
        }
        public void assem_Paint(PaintEventArgs e)
        {
            switch (mode)
            {
                case -1:
                    for (int i = 0; i <= index; i++)
                    {
                        Console.WriteLine(assemPoints[i]);
                        RectangleF r = new RectangleF(assemPoints[i].X - 5, assemPoints[i].Y - 5, 10, 10);
                        e.Graphics.FillRectangle(new SolidBrush(Color.DeepSkyBlue), r);
                        e.Graphics.DrawString(i.ToString(), new Font("굴림", 10, FontStyle.Bold), new SolidBrush(Color.DeepSkyBlue), new PointF(assemPoints[i].X + 5, assemPoints[i].Y));
                    }

                    if (index > 0)
                    {
                        e.Graphics.DrawLine(Pens.DeepSkyBlue, assemPoints[0], assemPoints[1]);
                    }
                    if (index > 1)
                    {
                        e.Graphics.DrawLine(Pens.DeepSkyBlue, assemPoints[0], assemPoints[2]);
                    }
                    if (index > 2)
                    {
                        e.Graphics.DrawLine(Pens.DeepSkyBlue, assemPoints[3], assemPoints[2]);
                        e.Graphics.DrawLine(Pens.DeepSkyBlue, assemPoints[3], assemPoints[1]);
                    }
                    break;
                case 0:
                    foreach (PointF[] pt in polygon)
                    {
                        int size = mCanvas.mVector.handleSize;
                        for (int i = 0; i < pt.Length; i++)
                        {
                            RectangleF r = new RectangleF(pt[i].X - size, pt[i].Y - size, size * 2, size * 2);
                            e.Graphics.FillRectangle(new SolidBrush(Color.DeepSkyBlue), r);
                        }
                    }
                    foreach (PointF[] vert in vertLine)
                    {
                        e.Graphics.DrawLine(Pens.Black, vert[0], vert[1]);
                    }
                    foreach (PointF[] hori in horiLine)
                    {
                        e.Graphics.DrawLine(Pens.Black, hori[0], hori[1]);
                    }
                    break;
                case 1:
                    foreach (PointF[] pt in polygon)
                    {
                        int size = mCanvas.mVector.handleSize;
                        for (int i = 0; i < pt.Length; i++)
                        {
                            RectangleF r = new RectangleF(pt[i].X - size, pt[i].Y - size, size * 2, size * 2);
                            e.Graphics.FillRectangle(new SolidBrush(Color.DeepSkyBlue), r);
                        }
                    }
                    foreach (PointF[] poly in polygon)
                    {
                        e.Graphics.DrawPolygon(Pens.Red, poly);
                    }
                    break;
            }
        }

        private void btn_cancel_Click(object sender, EventArgs e)
        {
            --index;

            Console.WriteLine(index);

            mCanvas.PictureBox1.Refresh();

            if (index == 0)
            {
                index = -1;
                btn_cancel.Enabled = false;
            }
        }

        Point2f mid_pt = new Point2f();
        cvPoint new_point;

        private void btn_assem_Click(object sender, EventArgs e)
        {
            //# 작업구역 크기 및 mat
            Mat src = CropMat(mCanvas.dst.Clone());
            Rectangle rect = Rectangle.Round(mCanvas.mWorkarea.totalPath.GetBounds());

            //# 비율계산
            double src_len = Math.Sqrt(Math.Pow(assemPoints[0].X - assemPoints[2].X, 2) + Math.Pow(assemPoints[0].Y - assemPoints[2].Y, 2));
            double dst_len = Math.Sqrt(Math.Pow(assemPoints[1].X - assemPoints[3].X, 2) + Math.Pow(assemPoints[1].Y - assemPoints[3].Y, 2));
            double ratio = dst_len / src_len;

            //# 회전 mat과 확대된 cropmat / 적용
            int length = rect.Width > rect.Height ? rect.Width : rect.Height;
            cvSize rot_size = new cvSize((int)(length * ratio * Math.Sqrt(2)), (int)(length * ratio * Math.Sqrt(2)));
            cvSize exp_size = new cvSize((int)(rect.Width * ratio), (int)(rect.Height * ratio));

            Mat rot_mat = new Mat(rot_size, MatType.CV_8UC4);
            Mat exp_mat = new Mat();
            Cv2.Resize(src, exp_mat, exp_size, 0, 0, InterpolationFlags.Area);
            //Cv2.ImShow("exp_mat", exp_mat);

            mid_pt = new Point2f(rot_size.Width / 2, rot_size.Height / 2);

            cvRect r = new cvRect((int)(mid_pt.X - exp_size.Width / 2), (int)(mid_pt.X - exp_size.Height / 2), exp_size.Width, exp_size.Height);
            rot_mat[r] = exp_mat;
            //Cv2.ImShow("rot_mat1", rot_mat);

            double fst_angle = Math.Atan2(assemPoints[2].Y - assemPoints[0].Y, assemPoints[2].X - assemPoints[0].X);
            double sec_angle = Math.Atan2(assemPoints[3].Y - assemPoints[1].Y, assemPoints[3].X - assemPoints[1].X);
            double rot_angle = -((sec_angle - fst_angle) * 180 / Math.PI);

            RotatedRect rot_rect = new RotatedRect(mid_pt, new Size2f(exp_size.Width, exp_size.Height), (float)rot_angle);

            Mat rotation = Cv2.GetRotationMatrix2D(mid_pt, rot_angle, 1);
            Cv2.WarpAffine(rot_mat, rot_mat, rotation, rot_size, InterpolationFlags.Area);

            Cv2.Rectangle(rot_mat, rot_rect.BoundingRect(), Scalar.Red, 1);
            rot_mat = rot_mat[rot_rect.BoundingRect()];
            //Cv2.ImShow("rot_mat2", rot_mat);

            Mat mask = new Mat();
            Cv2.CvtColor(rot_mat, mask, ColorConversionCodes.BGR2HSV);
            Cv2.InRange(rot_mat, new Scalar(0, 0, 0, 255), new Scalar(255, 255, 255, 255), mask);
            //Cv2.ImShow("mask", mask);

            new_point = new cvPoint(assemPoints[1].X - (assemPoints[0].X - rect.Left) * ratio, assemPoints[1].Y - (assemPoints[0].Y - rect.Top) * ratio);
            mCanvas.dst[new cvRect(rect.X, rect.Y, rect.Width, rect.Height)].SetTo(new Scalar(255, 255, 255, 255));
            rot_mat.CopyTo(mCanvas.dst[new cvRect(new_point, rot_mat.Size())], mask);

            mCanvas.PictureBox1.ImageIpl = mCanvas.dst;

            //# 초기화
            index = -1;
            assemPoints = new PointF[4];

            mCanvas.mWorkarea.totalPath = null;
            mCanvas.PictureBox1.Refresh();
            mCanvas.drawing = false;

            btn_point.Enabled = true;
            btn_assem.Enabled = false;
            btn_cancel.Enabled = false;

        }

        private void btn_point_Click(object sender, EventArgs e)
        {
            mode = -1;

            mCanvas.drawing = true;
            btn_point.Enabled = false;
        }

        public void SetPolygon(List<PointF> points)
        {
            polygon.Clear();
            polyMat.Clear();
            warpMat.Clear();
            for (int i = 0; i < horiLine.Count - 1; i++)
            {
                for (int j = 0; j < vertLine.Count - 1; j++)
                {
                    PointF pt1, pt2, pt3, pt4;
                    pt1 = points[i * vertLine.Count + j];
                    pt2 = points[i * vertLine.Count + (j + 1)];
                    pt3 = points[(i + 1) * vertLine.Count + (j + 1)];
                    pt4 = points[(i + 1) * vertLine.Count + j];

                    polygon.Add(new PointF[4] { pt1, pt2, pt3, pt4 });
                    Rectangle r = Rectangle.Round(new RectangleF(pt1.X, pt1.Y, pt2.X - pt1.X, pt3.Y - pt2.Y));
                    polyMat.Add(mCanvas.restore.SubMat(r.Y, r.Y + r.Height, r.X, r.X + r.Width).Clone());
                    warpMat.Add(polyMat[polyMat.Count - 1].Clone());
                }
            }
        }

        public Mat CropMat(Mat oriMat)
        {
            Mat maskMat = new Mat();
            Rectangle tempRect = Rectangle.Round(mCanvas.mWorkarea.totalPath.GetBounds());
            cvRect r = new cvRect(tempRect.Left, tempRect.Top, tempRect.Width, tempRect.Height);
            oriMat.CopyTo(maskMat, mCanvas.mWorkarea.holeMat);
            Mat cropMat = maskMat[r];
            return cropMat;
        }

        private void btn_workarea_Click(object sender, EventArgs e)
        {
            MainMenu.mode = MainMode.WORKAREA;
            mCanvas.mWorkarea.wShape = WShape.RECT;
            mCanvas.mWorkarea.rdo_set.Checked = true;
        }

        private void btn_add_Click(object sender, EventArgs e)
        {
            MainMenu.mode = MainMode.ASSEM;

            mode = 0;

            rect = mCanvas.mWorkarea.totalPath.GetBounds();
            float left, right, bottom, top;
            left = rect.Left; right = rect.Right; bottom = rect.Bottom; top = rect.Top;

            warpPoints.Clear();
            warpPoints.Add(new PointF(left, top));
            warpPoints.Add(new PointF(right, top));
            warpPoints.Add(new PointF(right, bottom));
            warpPoints.Add(new PointF(left, bottom));

            horiLine.Clear();
            horiLine.Add(new PointF[2] { new PointF(left, top), new PointF(right, top) });
            horiLine.Add(new PointF[2] { new PointF(left, bottom), new PointF(right, bottom) });

            vertLine.Clear();
            vertLine.Add(new PointF[2] { new PointF(left, top), new PointF(left, bottom) });
            vertLine.Add(new PointF[2] { new PointF(right, top), new PointF(right, bottom) });

            polygon.Clear();
            polygon.Add(new PointF[4] { new PointF(left, top), new PointF(right, top), new PointF(right, bottom), new PointF(left, bottom) });

            polyMat.Clear();
            Rectangle r = Rectangle.Round(new RectangleF(rect.X, rect.Y, rect.Width, rect.Height));
            polyMat.Add(mCanvas.restore.SubMat(r.Y, r.Y + r.Height, r.X, r.X + r.Width));

            warpMat.Clear();
            warpMat.Add(polyMat[polyMat.Count - 1].Clone());

            mCanvas.drawing = true;
            mCanvas.PictureBox1.Refresh();
            mCanvas.drawing = false;
        }

        private void btn_modify_Click(object sender, EventArgs e)
        {
            mode = 1;

            mCanvas.drawing = true;
            mCanvas.PictureBox1.Refresh();
            mCanvas.drawing = false;
        }

        private void btn_warp_Click(object sender, EventArgs e)
        {
            for (int i = 0; i < polygon.Count; i++)
            {
                GraphicsPath poly = new GraphicsPath(polygon[i].ToArray(), rectType);
                Rectangle warpRect = Rectangle.Round(poly.GetBounds());
                List<Point2f> srcPts = new List<Point2f>()
                {
                    new Point2f(0.0f, 0.0f),
                    new Point2f(0.0f, polyMat[i].Height),
                    new Point2f(polyMat[i].Width, polyMat[i].Height),
                    new Point2f(polyMat[i].Width, 0.0f)
                };
                List<Point2f> dstPts = new List<Point2f>()
                {
                    new Point2f(polygon[i][0].X - warpRect.X, polygon[i][0].Y - warpRect.Y),
                    new Point2f(polygon[i][3].X - warpRect.X, polygon[i][3].Y - warpRect.Y),
                    new Point2f(polygon[i][2].X - warpRect.X, polygon[i][2].Y - warpRect.Y),
                    new Point2f(polygon[i][1].X - warpRect.X, polygon[i][1].Y - warpRect.Y)
                };

                Mat pers = Cv2.GetPerspectiveTransform(srcPts, dstPts);
                Mat pMask = new Mat();
                Mat roi;
                Cv2.WarpPerspective(polyMat[i], warpMat[i], pers, new cvSize(warpRect.Width, warpRect.Height), InterpolationFlags.Nearest);

                Scalar scalar = new Scalar(0, 0, 0);
                Cv2.CvtColor(warpMat[i], pMask, ColorConversionCodes.BGR2HSV);
                Cv2.InRange(warpMat[i], scalar, scalar, pMask);
                Cv2.BitwiseNot(pMask, pMask);

                roi = new Mat(mCanvas.restore, new cvRect(warpRect.X, warpRect.Y, warpRect.Width, warpRect.Height));
                warpMat[i].CopyTo(roi, pMask);
            }
            mCanvas.dst = mCanvas.restore.Clone();
            mCanvas.matList.Add(mCanvas.dst.Clone());
            mCanvas.PictureBox1.ImageIpl = mCanvas.dst;
            mCanvas.restore = mCanvas.dst.Clone();
        }

        private void Assemble_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true; //리소스를 해제하지 않아 데이터를 유지할 수 있다
            this.Hide();
        }
    }
}
