﻿using OpenCvSharp;
using OpenCvSharp.Extensions;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;
using cvRect = OpenCvSharp.Rect;
namespace TexMaster
{
    public partial class AutoRepeat : Form
    {
        public Canvas mCanvas;
        public GraphicsPath repeatPath;         //Repeat 영역을 표시
        public Mat[] repeatMat;                 //작업구역을 4등분했을 때 LT, RT, LB, RB 순으로 저장된 배열
        public Mat[,] changedMat;               //그림을 그린 후 변한 Mat
        public int halfRows, halfCols;          //작업구역을 반으로 잘랐을 때 pixel 수
        public bool isRepeat = false;           //Repeat기능을 사용중인지
        public repeatType mRepeatType;          //리핏 방법

        public Mat repSrc, repDst;              //AutoRepeat Image
        public List<Mat> repMatList;            //AutoRepeat Mat List
        public Rectangle totalRect;             //MainCanvas 작업구역의 Bounds

        public enum repeatType
        {
            NONE, NORMAL, HORZ, VERT
        }

        private float[] repeatInter = { 0.125f, 0.25f, 0.5f, 0.75f, 0.875f };

        public AutoRepeat(Canvas canvas)
        {
            InitializeComponent();
            mCanvas = canvas;
            mCanvas.mAutoRepeat = this;
            mRepeatType = repeatType.NONE;
            repMatList = new List<Mat>();
            repeatMat = new Mat[4];
            changedMat = new Mat[4, 4];

            cmb_max.SelectedIndex = 2;
        }

        private void AutoRepeat_Load(object sender, EventArgs e)
        {
            lbl_max.Enabled = false;
            cmb_max.Enabled = false;
        }

        public void repeat_Paint(PaintEventArgs e)
        {
            if (isRepeat)
            {
                e.Graphics.DrawPath(mCanvas.mWorkarea.blankPen, repeatPath);
                e.Graphics.DrawPath(mCanvas.mWorkarea.dashPen, repeatPath);
                return;
            }
        }

        private void SetAutoRepeatImage()
        {
            totalRect = Rectangle.Round(mCanvas.mWorkarea.totalPath.GetBounds());
            repSrc = new Mat(totalRect.Height * 2, totalRect.Width * 2, MatType.CV_8UC4, 0);
            Color c = mCanvas.gBackColor;
            Scalar penColor = new Scalar(c.B, c.G, c.R, c.A);
            repSrc[new cvRect(0, 0, repSrc.Width, repSrc.Height)].SetTo(penColor);

            Mat subMat = mCanvas.dst.SubMat(totalRect.Y, totalRect.Y + totalRect.Height, totalRect.X, totalRect.X + totalRect.Width);

            repeatPath = new GraphicsPath();
            repeatPath.AddRectangle(totalRect);
            Matrix translate = new Matrix();
            translate.Translate(totalRect.Width / 2 - totalRect.X, totalRect.Height / 2 - totalRect.Y);
            repeatPath.Transform(translate);
            Rectangle path = Rectangle.Round(repeatPath.GetBounds());//새로 변경된 위치로 갱신
            repSrc[new cvRect(path.X, path.Y, path.Width, path.Height)] = subMat;
            SetRepeatMat(subMat);

            switch (mRepeatType)
            {
                case repeatType.NORMAL:
                    lbl_max_value.Text = "";
                    SetNormalRepeat();
                    break;
                case repeatType.HORZ:
                    lbl_max_value.Text = subMat.Cols.ToString();
                    SetHorzRepeat(subMat, path.X, path.Y, (int)(path.Width * repeatInter[cmb_max.SelectedIndex]));
                    break;
                case repeatType.VERT:
                    lbl_max_value.Text = subMat.Rows.ToString();
                    SetVertRepeat(subMat, path.X, path.Y, (int)(path.Height * repeatInter[cmb_max.SelectedIndex]));
                    break;
            }
            repMatList.Add(repSrc);

            mCanvas.dst = repSrc.Clone();
            mCanvas.matList.Add(mCanvas.dst);
            mCanvas.PictureBox1.ImageIpl = mCanvas.dst;
            mCanvas.PictureBox1.Width = mCanvas.dst.Width;
            mCanvas.PictureBox1.Height = mCanvas.dst.Height;
        }

        private void SetRepeatMat(Mat work)
        {
            halfRows = work.Rows / 2;
            halfCols = work.Cols / 2;

            repeatMat[0] = work.SubMat(0, halfRows + work.Rows % 2, 0, halfCols + work.Cols % 2);
            repeatMat[1] = work.SubMat(0, halfRows + work.Rows % 2, repeatMat[0].Width, work.Cols);
            repeatMat[2] = work.SubMat(repeatMat[0].Height, work.Rows, 0, halfCols + work.Cols % 2);
            repeatMat[3] = work.SubMat(repeatMat[0].Height, work.Rows, repeatMat[0].Width, work.Cols);
        }

        public void SetRepeatImage()
        {
            repDst = mCanvas.dst.Clone();
            for (int i = 0; i < changedMat.Length; i++)
            {
                switch (i)
                {
                    case 0:
                        changedMat[i, 0] = repDst[new cvRect(repeatMat[3].Width, repeatMat[3].Height, repeatMat[0].Width, repeatMat[0].Height)];
                        changedMat[i, 1] = repDst[new cvRect(repDst.Width - repeatMat[0].Width, repeatMat[2].Height, repeatMat[0].Width, repeatMat[0].Height)];
                        changedMat[i, 2] = repDst[new cvRect(repeatMat[1].Width, repDst.Height - repeatMat[0].Height, repeatMat[0].Width, repeatMat[0].Height)];
                        changedMat[i, 3] = repDst[new cvRect(repDst.Width - repeatMat[0].Width, repDst.Height - repeatMat[0].Height, repeatMat[0].Width, repeatMat[0].Height)];
                        break;
                    case 1:
                        changedMat[i, 0] = repDst[new cvRect(repeatMat[0].Width + repeatMat[1].Width, repeatMat[3].Height, repeatMat[1].Width, repeatMat[1].Height)];
                        changedMat[i, 1] = repDst[new cvRect(0, repeatMat[3].Height, repeatMat[1].Width, repeatMat[1].Height)];
                        changedMat[i, 2] = repDst[new cvRect(0, repDst.Height - repeatMat[1].Height, repeatMat[1].Width, repeatMat[1].Height)];
                        changedMat[i, 3] = repDst[new cvRect(repDst.Width - (repeatMat[0].Width + repeatMat[1].Width), repDst.Height - repeatMat[1].Height, repeatMat[1].Width, repeatMat[1].Height)];
                        break;
                    case 2:
                        changedMat[i, 0] = repDst[new cvRect(repeatMat[3].Width, repeatMat[0].Height + repeatMat[2].Height, repeatMat[2].Width, repeatMat[2].Height)];
                        changedMat[i, 1] = repDst[new cvRect(repeatMat[3].Width, 0, repeatMat[2].Width, repeatMat[2].Height)];
                        changedMat[i, 2] = repDst[new cvRect(repDst.Width - repeatMat[2].Width, 0, repeatMat[2].Width, repeatMat[2].Height)];
                        changedMat[i, 3] = repDst[new cvRect(repDst.Width - repeatMat[2].Width, repDst.Height - (repeatMat[0].Height + repeatMat[2].Height), repeatMat[2].Width, repeatMat[2].Height)];
                        break;
                    case 3:
                        changedMat[i, 0] = repDst[new cvRect(repeatMat[2].Width + repeatMat[3].Width, repeatMat[1].Height + repeatMat[3].Height, repeatMat[3].Width, repeatMat[3].Height)];
                        changedMat[i, 1] = repDst[new cvRect(0, 0, repeatMat[3].Width, repeatMat[3].Height)];
                        changedMat[i, 2] = repDst[new cvRect(repDst.Width - (repeatMat[2].Width + repeatMat[3].Width), 0, repeatMat[3].Width, repeatMat[3].Height)];
                        changedMat[i, 3] = repDst[new cvRect(0, repDst.Height - (repeatMat[1].Height + repeatMat[3].Height), repeatMat[3].Width, repeatMat[3].Height)];
                        break;
                }
            }
            CompareChangedImage();
            repDst = GetRefDstMat(true);
            repMatList.Add(repSrc);

            mCanvas.PictureBox1.ImageIpl = repDst;
            mCanvas.PictureBox1.Width = repDst.Width;
            mCanvas.PictureBox1.Height = repDst.Height;
            mCanvas.dst = repDst.Clone();
            mCanvas.matList.Add(mCanvas.dst);
            mCanvas.restore = mCanvas.dst.Clone();
        }

        private void CompareChangedImage()
        {
            for (int i = 0; i < changedMat.GetLength(0); i++)
            {
                for (int j = 0; j < changedMat.GetLength(1); j++)
                {
                    for (int row = 0; row < repeatMat[i].Rows; row++)
                    {
                        for (int col = 0; col < repeatMat[i].Cols; col++)
                        {
                            Color cc = Color.FromArgb(changedMat[i, j].At<int>(row, col));
                            Color rc = Color.FromArgb(repeatMat[i].At<int>(row, col));
                            if (cc != rc)
                            {
                                repeatMat[i].Set<int>(row, col, changedMat[i, j].At<int>(row, col));
                                for (int m = j + 1; m < 4; m++)
                                {
                                    changedMat[i, m].Set<int>(row, col, changedMat[i, j].At<int>(row, col));
                                }
                            }
                        }
                    }
                }
            }
        }

        private Mat GetRefDstMat(bool isFull)//true = 전체 이미지, false = 작업구역 내 이미지
        {
            Mat temp1 = new Mat();
            Mat temp2 = new Mat();
            if (isFull)
            {
                Cv2.HConcat(repeatMat[3], repeatMat[2], temp1);
                Cv2.HConcat(temp1, temp1, temp1);
                Cv2.HConcat(repeatMat[1], repeatMat[0], temp2);
                Cv2.HConcat(temp2, temp2, temp2);
                Cv2.VConcat(temp1, temp2, temp1);
                Cv2.VConcat(temp1, temp1, temp1);
            }
            else
            {
                Cv2.HConcat(repeatMat[0], repeatMat[1], temp1);
                Cv2.HConcat(repeatMat[2], repeatMat[3], temp2);
                Cv2.VConcat(temp1, temp2, temp1);
            }
            return temp1;
        }

        private void SetNormalRepeat()
        {
            for (int i = 0; i < repeatMat.Length; i++)
            {
                switch (i)
                {
                    case 0:
                        repSrc[new cvRect(repSrc.Width - repeatMat[0].Width, repeatMat[2].Height, repeatMat[0].Width, repeatMat[0].Height)] = repeatMat[0];
                        repSrc[new cvRect(repeatMat[1].Width, repSrc.Height - repeatMat[0].Height, repeatMat[0].Width, repeatMat[0].Height)] = repeatMat[0];
                        repSrc[new cvRect(repSrc.Width - repeatMat[0].Width, repSrc.Height - repeatMat[0].Height, repeatMat[0].Width, repeatMat[0].Height)] = repeatMat[0];
                        break;
                    case 1:
                        repSrc[new cvRect(0, repeatMat[3].Height, repeatMat[1].Width, repeatMat[1].Height)] = repeatMat[1];
                        repSrc[new cvRect(0, repSrc.Height - repeatMat[1].Height, repeatMat[1].Width, repeatMat[1].Height)] = repeatMat[1];
                        repSrc[new cvRect(repSrc.Width - (repeatMat[0].Width + repeatMat[1].Width), repSrc.Height - repeatMat[1].Height, repeatMat[1].Width, repeatMat[1].Height)] = repeatMat[1];
                        break;
                    case 2:
                        repSrc[new cvRect(repeatMat[3].Width, 0, repeatMat[2].Width, repeatMat[2].Height)] = repeatMat[2];
                        repSrc[new cvRect(repSrc.Width - repeatMat[2].Width, 0, repeatMat[2].Width, repeatMat[2].Height)] = repeatMat[2];
                        repSrc[new cvRect(repSrc.Width - repeatMat[2].Width, repSrc.Height - (repeatMat[0].Height + repeatMat[2].Height), repeatMat[2].Width, repeatMat[2].Height)] = repeatMat[2];
                        break;
                    case 3:
                        repSrc[new cvRect(0, 0, repeatMat[3].Width, repeatMat[3].Height)] = repeatMat[3];
                        repSrc[new cvRect(repSrc.Width - (repeatMat[2].Width + repeatMat[3].Width), 0, repeatMat[3].Width, repeatMat[3].Height)] = repeatMat[3];
                        repSrc[new cvRect(0, repSrc.Height - (repeatMat[1].Height + repeatMat[3].Height), repeatMat[3].Width, repeatMat[3].Height)] = repeatMat[3];
                        break;
                }
            }
        }

        private void SetHorzRepeat(Mat work, int repRectX, int repRectY, int inter)
        {
            Console.WriteLine("inter = " + inter.ToString());
            Console.WriteLine("Half = " + halfCols.ToString() + ", " + halfRows.ToString());
            for (int k = 0; k < repeatMat.Length; k++)
            {
                for (int i = 0; i < repeatMat[k].Height; i++)
                {
                    for (int j = 0; j < repeatMat[k].Width; j++)
                    {
                        if (repeatMat[k].At<int>(i, j) != 0)
                        {
                            switch (k)
                            {
                                //오른쪽방향으로 이동///////
                                case 0:
                                    repDst.Set<int>(repRectY + i, repRectX + work.Cols + j, repeatMat[k].At<int>(i, j));

                                    if (j + inter > work.Cols + repeatMat[0].Cols)
                                        repDst.Set<int>(repRectY + work.Rows + i, (j + inter) % work.Cols + repRectX - work.Cols, repeatMat[k].At<int>(i, j));
                                    else
                                        repDst.Set<int>(repRectY + work.Rows + i, repRectX + j + inter, repeatMat[k].At<int>(i, j));
                                    if (j + inter > repeatMat[0].Cols)
                                        repDst.Set<int>(repRectY + work.Rows + i, (j + inter) % work.Cols + repRectX - work.Cols, repeatMat[k].At<int>(i, j));
                                    else
                                        repDst.Set<int>(repRectY + work.Rows + i, repRectX + work.Cols + j + inter, repeatMat[k].At<int>(i, j));
                                    break;
                                //오른쪽방향으로 이동///////
                                case 1:
                                    repDst.Set<int>(repRectY + i, repRectX - repeatMat[k].Cols + j, repeatMat[k].At<int>(i, j));

                                    if (j - repeatMat[k].Cols + inter > work.Cols + repeatMat[0].Cols)
                                        repDst.Set<int>(repRectY + work.Rows + i, (j + inter) % work.Cols + repRectX - work.Cols, repeatMat[k].At<int>(i, j));
                                    else
                                        repDst.Set<int>(repRectY + work.Rows + i, repRectX - repeatMat[k].Cols + j + inter, repeatMat[k].At<int>(i, j));
                                    if (j + halfCols + inter > repeatMat[0].Cols)
                                        repDst.Set<int>(repRectY + work.Rows + i, (j + inter) % work.Cols + repRectX - work.Cols, repeatMat[k].At<int>(i, j));
                                    else
                                        repDst.Set<int>(repRectY + work.Rows + i, repRectX + halfCols + j + inter, repeatMat[k].At<int>(i, j));
                                    break;
                                //왼쪽방향으로 이동///////
                                case 2:
                                    repDst.Set<int>(repRectY - repeatMat[k].Rows + i, repRectX + j, repeatMat[k].At<int>(i, j));
                                    repDst.Set<int>(repRectY - repeatMat[k].Rows + i, repRectX + work.Cols + j, repeatMat[k].At<int>(i, j));
                                    //repDst.Set<int>(repRectY + halfRows + i, repRectX + work.Cols + j, repeatMat[k].At<int>(i, j));
                                    break;
                                //왼쪽방향으로 이동///////
                                case 3:
                                    repDst.Set<int>(repRectY - repeatMat[k].Rows + i, repRectX - repeatMat[k].Cols + j, repeatMat[k].At<int>(i, j));
                                    repDst.Set<int>(repRectY - repeatMat[k].Rows + i, repRectX + halfCols + j, repeatMat[k].At<int>(i, j));
                                    //repDst.Set<int>(repRectY + halfRows + i, repRectX - repeatMat[k].Cols + j, repeatMat[k].At<int>(i, j));
                                    break;
                            }
                        }
                    }
                }
            }
        }

        private void SetVertRepeat(Mat work, int repRectX, int repRectY, int inter)
        {
            for (int k = 0; k < repeatMat.Length; k++)
            {
                for (int i = 0; i < repeatMat[k].Height; i++)
                {
                    for (int j = 0; j < repeatMat[k].Width; j++)
                    {
                        if (repeatMat[k].At<int>(i, j) != 0)
                        {
                            switch (k)
                            {
                                //아랫쪽 방향으로 이동
                                case 0:
                                    repDst.Set<int>(repRectY + i, repRectX + work.Cols + j, repeatMat[k].At<int>(i, j));
                                    //repDst.Set<int>(repRectY + work.Rows + i, repRectX + j, repeatMat[k].At<int>(i, j));
                                    repDst.Set<int>(repRectY + work.Rows + i, repRectX + work.Cols + j, repeatMat[k].At<int>(i, j));
                                    break;
                                //위쪽 방향으로 이동
                                case 1:
                                    repDst.Set<int>(repRectY + i, repRectX - repeatMat[k].Cols + j, repeatMat[k].At<int>(i, j));
                                    repDst.Set<int>(repRectY + work.Rows + i, repRectX - repeatMat[k].Cols + j, repeatMat[k].At<int>(i, j));
                                    //repDst.Set<int>(repRectY + work.Rows + i, repRectX + halfCols + j, repeatMat[k].At<int>(i, j));
                                    break;
                                //아랫쪽 방향으로 이동
                                case 2:
                                    //repDst.Set<int>(repRectY - repeatMat[k].Rows + i, repRectX + j, repeatMat[k].At<int>(i, j));
                                    repDst.Set<int>(repRectY - repeatMat[k].Rows + i, repRectX + work.Cols + j, repeatMat[k].At<int>(i, j));
                                    repDst.Set<int>(repRectY + halfRows + i, repRectX + work.Cols + j, repeatMat[k].At<int>(i, j));
                                    break;
                                //위쪽 방향으로 이동
                                case 3:
                                    repDst.Set<int>(repRectY - repeatMat[k].Rows + i, repRectX - repeatMat[k].Cols + j, repeatMat[k].At<int>(i, j));
                                    //repDst.Set<int>(repRectY - repeatMat[k].Rows + i, repRectX + halfCols + j, repeatMat[k].At<int>(i, j));
                                    repDst.Set<int>(repRectY + halfRows + i, repRectX - repeatMat[k].Cols + j, repeatMat[k].At<int>(i, j));
                                    break;
                            }
                        }
                    }
                }
            }
        }

        private void SetMainImage()
        {
            //MainImage WorkArea 내부를 그릴 새로운 이미지로 초기화
            totalRect = Rectangle.Round(mCanvas.mWorkarea.totalPath.GetBounds());
            mCanvas.dst = mCanvas.restore.Clone();
            mCanvas.dst[new cvRect(totalRect.X, totalRect.Y, totalRect.Width, totalRect.Height)] = GetRefDstMat(false);
            mCanvas.PictureBox1.Size = new System.Drawing.Size(mCanvas.restore.Width, mCanvas.restore.Height);
            mCanvas.PictureBox1.ImageIpl = mCanvas.dst;
            mCanvas.restore = mCanvas.dst.Clone();
            mCanvas.matList.Add(mCanvas.dst);
        }

        public void Normal_Click(object sender, EventArgs e)
        {
            if (mRepeatType == repeatType.NORMAL) return;
            isRepeat = true;

            mCanvas.mAutoRepeat.mRepeatType = repeatType.NORMAL;
            lbl_max.Enabled = false;
            cmb_max.Enabled = false;

            SetAutoRepeatImage();

            mCanvas.drawing = true;
            mCanvas.Refresh();
            mCanvas.drawing = false;
        }

        public void Horz_Click(object sender, EventArgs e)
        {
            if (mRepeatType == repeatType.HORZ) return;

            mCanvas.mAutoRepeat.mRepeatType = repeatType.HORZ;
            lbl_max.Enabled = true;
            cmb_max.Enabled = true;

            SetAutoRepeatImage();

            mCanvas.drawing = true;
            mCanvas.Refresh();
            mCanvas.drawing = false;
        }

        public void Vert_Click(object sender, EventArgs e)
        {
            if (mRepeatType == repeatType.VERT) return;

            mCanvas.mAutoRepeat.mRepeatType = repeatType.VERT;
            lbl_max.Enabled = true;
            cmb_max.Enabled = false;

            SetAutoRepeatImage();

            mCanvas.drawing = true;
            mCanvas.Refresh();
            mCanvas.drawing = false;
        }

        private void btn_stop_Click(object sender, EventArgs e)
        {
            if (repMatList.Count == 0) return;
            this.Hide();
            //Todo RepeatBmp를 새로 적용시켜야함
            SetMainImage();

            isRepeat = false;
            mRepeatType = repeatType.NONE;
            MainMenu.mode = MainMode.DRAW;
            repMatList.Clear();
        }

        private void cmb_max_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
            {

            }
        }

        private void AutoRepeat_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
            this.Hide();
        }
    }
}
