﻿using OpenCvSharp;
using OpenCvSharp.Extensions;
using System;
using System.Drawing;
using System.Windows.Forms;

namespace TexMaster
{
    public partial class Clear : Form
    {
        Canvas mCanvas;

        public Clear(Canvas canvas)
        {
            InitializeComponent();
            mCanvas = canvas;
            mCanvas.mClear = this;
        }

        private void Clear_Load(object sender, EventArgs e)
        {
            if (mCanvas.mWorkarea.holeMat == null)
            {
                btn_internal.Enabled = false;
                btn_outside.Enabled = false;
            }
            else
            {
                btn_internal.Enabled = true;
                btn_outside.Enabled = true;
            }
        }

        private void btn_all_Click(object sender, EventArgs e)
        {
            mCanvas.dst.SetTo(0);
            mCanvas.PictureBox1.ImageIpl = mCanvas.dst;
        }

        private void btn_eraser_Click(object sender, EventArgs e)
        {
            mCanvas.mPen.penMode = PenManager.PenShape.ERASER;
        }

        private void btn_internal_Click(object sender, EventArgs e)
        {
            mCanvas.dst.SetTo(0, mCanvas.mWorkarea.holeMat);
            mCanvas.PictureBox1.ImageIpl = mCanvas.dst;
        }

        private void btn_outside_Click(object sender, EventArgs e)
        {
            Mat toggleMat = new Mat();
            Cv2.BitwiseNot(mCanvas.mWorkarea.holeMat, toggleMat);

            mCanvas.dst.SetTo(0, toggleMat);
            mCanvas.PictureBox1.ImageIpl = mCanvas.dst;
        }

        public void Eraser(MouseEventArgs e)
        {
            Color c = mCanvas.gBackColor;
            Scalar s = new Scalar(c.B, c.G, c.R, c.A);
            Cv2.Line(mCanvas.dst, mCanvas.start, mCanvas.end, s, mCanvas.penSize);
        }

        private void Clear_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
            this.Hide();
        }
    }
}
