﻿using OpenCvSharp;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;
using cvPoint = OpenCvSharp.Point;
using cvRect = OpenCvSharp.Rect;
using Point = System.Drawing.Point;

namespace TexMaster
{
    public partial class ColorChange : Form
    {
        public Canvas mCanvas;
        public Mat workMat;
        public Mat mask;
        public bool isRun; //# 색상 돌리기 상태
        public int color;
        public bool isTarget;

        Mat cropMat;
        cvRect rect;

        MultiColor multi;
        Color oriColor;

        public ColorChange(Canvas canvas)
        {
            InitializeComponent();
            mCanvas = canvas;
            mCanvas.mColorChange = this;
            isTarget = false;
            //gSourcePanel = new List<Panel>();
            //gTargetColor = Color.Transparent;
            multi = new MultiColor();

        }

        private void GetCropMat()
        {
            cropMat = new Mat();
            if (mCanvas.mWorkarea.totalPath != null)
            {
                Rectangle r = Rectangle.Round(mCanvas.mWorkarea.totalPath.GetBounds());
                rect = new cvRect((int)r.X, (int)r.Y, (int)r.Width, (int)r.Height);
                mCanvas.dst.CopyTo(cropMat, mCanvas.mWorkarea.holeMat);
                cropMat[rect].CopyTo(cropMat);
            }
            else
            {
                rect = new cvRect(0, 0, mCanvas.PictureBox1.Width, mCanvas.PictureBox1.Height);
                cropMat = mCanvas.dst.Clone();
            }
        }

        public void color_MouseDown(MouseEventArgs e)
        {
            mCanvas.dst = mCanvas.LastList(mCanvas.matList).Clone();
            Color pixel = Color.FromArgb(mCanvas.dst.At<int>(e.Y, e.X));
            if (e.Button == MouseButtons.Middle)
            {
                if (cmb_pen.SelectedIndex == 0 && rdo_single_source.Checked)
                {
                    pnl_source.BackColor = pixel;
                    rdo_single_target.Checked = true;
                }

                if (rdo_multi_source.Checked)
                {
                    multi.MouseDown(mCanvas.dst, mCanvas.mWorkarea.totalPath, pnl_color, e);
                    mCanvas.drawing = true;
                }
            }
            else if (rdo_single_target.Checked)
            {
                if (rdo_workarea.Checked)
                {
                    pnl_single_target.BackColor = pixel;
                    rdo_single_source.Checked = true;
                }
            }
            else if (rdo_pen.Checked && rdo_single_target.Checked)
            {
                mCanvas.start = new cvPoint(e.X, e.Y);
                mCanvas.drawing = true;
                workMat = mCanvas.dst.Clone();
                return;
            }
        }

        public void color_MouseMove(MouseEventArgs e)
        {
            if (mCanvas.drawing)
            {
                if (rdo_multi_source.Checked)
                {
                    multi.MouseMove(e);
                    mCanvas.PictureBox1.Refresh();
                }
                else
                {
                    Mat dst = mCanvas.LastList(mCanvas.matList);
                    Color target = pnl_single_target.BackColor;
                    Scalar sTarget = new Scalar(target.B, target.G, target.R, target.A);
                    Cv2.Line(dst, mCanvas.start, new cvPoint(e.X, e.Y), sTarget, mCanvas.penSize);
                    mCanvas.start = new cvPoint(e.X, e.Y);

                    Color source = pnl_source.BackColor;
                    Scalar sSource = new Scalar(source.B, source.G, source.R, source.A);
                    mask = GetMaskMat(sSource);
                    dst.CopyTo(mCanvas.dst, mask);

                    Rect work = new Rect(0, 0, dst.Width, dst.Height);
                    if (mCanvas.mWorkarea.totalPath != null)
                    {
                        Rectangle r = Rectangle.Round(mCanvas.mWorkarea.totalPath.GetBounds());
                        work = new Rect((int)r.X, (int)r.Y, (int)r.Width, (int)r.Height);
                    }

                    workMat[work] = mCanvas.dst[work];
                    mCanvas.PictureBox1.ImageIpl = workMat;

                    //# 현재 Pixel 색상으로 미리보기
                    if (rdo_single_target.Checked)
                    {
                        if (cmb_area.SelectedIndex != 0)   //# 맞바꿈일때는 미리보기 하지 않음
                        {
                            pnl_single_target.BackColor = Color.FromArgb(mCanvas.dst.At<int>(e.Y, e.X));
                        }
                    }
                }
            }
        }

        public void color_MouseUp(MouseEventArgs e)
        {
            if (mCanvas.drawing)
            {
                if (rdo_multi_source.Checked)
                {
                    multi.MouseUp(mCanvas.restore, pnl_color, e);
                }
                else
                {
                    Rect work = new Rect(0, 0, mCanvas.dst.Width, mCanvas.dst.Height);
                    if (mCanvas.mWorkarea.totalPath != null)
                    {
                        Rectangle r = Rectangle.Round(mCanvas.mWorkarea.totalPath.GetBounds());
                        work = new Rect((int)r.X, (int)r.Y, (int)r.Width, (int)r.Height);
                    }

                    workMat[work] = mCanvas.dst[work];
                    mCanvas.PictureBox1.ImageIpl = workMat;

                    mCanvas.matList.Add(workMat);
                }
                mCanvas.PictureBox1.Refresh();
                mCanvas.drawing = false;
            }
        }

        public void color_Paint(PaintEventArgs e)
        {
            multi.Paint(e);
        }

        private void ColorChange_Load(object sender, EventArgs e)
        {
            UpdateDisplay();
            cmb_method.SelectedIndex = 0;
            cmb_pen.SelectedIndex = 0;
            cmb_area.SelectedIndex = 1;
        }

        public void UpdateDisplay()
        {
            List<Panel> pnlList = new List<Panel>();
            pnlList.Add(pnl_select);

            if (rdo_workarea.Checked)
            {
                pnlList.Add(pnl_window);
                if (cmb_area.SelectedIndex == 2) //# 다색 - 단색
                    pnlList.Add(pnl_multi);
                else
                    pnlList.Add(pnl_single);

            }
            else if (rdo_pen.Checked)
            {
                pnlList.Add(pnl_pen);
                if (cmb_pen.SelectedIndex == 0)
                {
                    pnlList.Add(pnl_single);
                }
                else
                {
                    pnlList.Add(pnl_multi);
                }
            }
            else if (rdo_color.Checked)
            {
                if (!isRun)
                {
                    pnlList.Add(pnl_256);
                }
                else
                {
                    if (cmb_method.SelectedIndex == 0)
                    {
                        pnlList.Add(pnl_rgb);
                    }
                    else if (cmb_method.SelectedIndex == 1)
                    {
                        pnlList.Add(pnl_hls);
                    }
                    else if (cmb_method.SelectedIndex == 2)
                    {
                        pnlList.Add(pnl_cmy);
                    }
                    pnlList.Add(pnl_set);
                }
            }

            if (pnlList.Count > 0)
            {
                int top = 0;
                for (int i = 0; i < pnlList.Count; i++)
                {
                    pnlList[i].Visible = true;
                    pnlList[i].Location = new Point(0, top);
                    pnlList[i].BringToFront();
                    top += pnlList[i].Height;
                }

                this.Height = pnlList[pnlList.Count - 1].Top + pnlList[pnlList.Count - 1].Height + 38;  //# 38 - Topbar Height
            }

            this.Refresh();
        }

        private void RadioCheckChanged(object sender, EventArgs e)
        {
            UpdateDisplay();
        }

        private void rdo_single_source_CheckedChanged(object sender, EventArgs e)
        {
            if (rdo_single_source.Checked)
            {
                isTarget = false;

                Mat tempMat = mCanvas.dst.Clone();
                Color c = pnl_single_target.BackColor;
                Scalar s = new Scalar(c.B, c.G, c.R, c.A);
                tempMat.SetTo(s, mask);

                if (cmb_area.SelectedIndex == 0)    //# 맞바꿈
                {
                    mask = GetMaskMat(s);

                    c = pnl_source.BackColor;
                    s = new Scalar(c.B, c.G, c.R, c.A);
                    tempMat.SetTo(s, mask);
                }

                Rect work = new Rect(0, 0, tempMat.Width, tempMat.Height);
                if (mCanvas.mWorkarea.totalPath != null)
                {
                    Rectangle r = Rectangle.Round(mCanvas.mWorkarea.totalPath.GetBounds());
                    work = new Rect((int)r.X, (int)r.Y, (int)r.Width, (int)r.Height);
                }
                mCanvas.dst[work] = tempMat[work];
                mCanvas.PictureBox1.ImageIpl = mCanvas.dst;
                mCanvas.matList.Add(mCanvas.dst);

            }
            else
            {
                isTarget = true;
            }
        }

        private void rdo_single_target_CheckedChanged(object sender, EventArgs e)
        {
            if (rdo_single_target.Checked)
            {
                isTarget = true;
                Color c = pnl_source.BackColor;
                Scalar s = new Scalar(c.B, c.G, c.R, c.A);
                mask = GetMaskMat(s);
            }
            else
            {
                isTarget = false;
            }
        }

        private void cmb_pen_SelectedIndexChanged(object sender, EventArgs e)
        {
            UpdateDisplay();
        }

        public Mat GetMaskMat(Scalar s)
        {
            Mat hsv = new Mat();
            Mat ori = mCanvas.dst.Clone();
            Cv2.CvtColor(ori, hsv, ColorConversionCodes.BGR2HSV);
            Cv2.InRange(ori, s, s, hsv);
            return hsv;
        }

        private void cmb_area_SelectedIndexChanged(object sender, EventArgs e)
        {
            UpdateDisplay();
        }

        private void pnl_single_target_BackColorChanged(object sender, EventArgs e)
        {
            if (rdo_workarea.Checked)
            {
                if (mCanvas.mColorChange.cmb_area.SelectedIndex != 0)
                {
                    Mat tempMat = mCanvas.dst.Clone();
                    Color c = pnl_single_target.BackColor;
                    Scalar s = new Scalar(c.B, c.G, c.R, c.A);
                    tempMat.SetTo(s, mask);

                    Rect work = new Rect(0, 0, tempMat.Width, tempMat.Height);
                    if (mCanvas.mWorkarea.totalPath != null)
                    {
                        Rectangle r = Rectangle.Round(mCanvas.mWorkarea.totalPath.GetBounds());
                        work = new Rect((int)r.X, (int)r.Y, (int)r.Width, (int)r.Height);
                    }

                    mCanvas.dst[work] = tempMat[work];
                    mCanvas.PictureBox1.ImageIpl = mCanvas.dst;
                }
            }

            if (rdo_pen.Checked)
            {
                Console.WriteLine("rdo_pen.Checked");

            }
        }

        private void rdo_multi_target_CheckedChanged(object sender, EventArgs e)
        {
            if (!(pnl_color.Controls.Count > 0))
            {
                MessageBox.Show("한가지 이상의 색상을 선택해주세요");
                return;
            }

            if (rdo_multi_target.Checked)
            {
                cvPoint[][] contours;
                HierarchyIndex[] hierarchy;
                mask = new Mat();

                for (int i = 0; i < multi.colList.Count; i++)
                {
                    Mat hsv = new Mat();
                    Color c = Color.FromArgb((int)multi.colList[i]);
                    Scalar selColor = new Scalar(c.B, c.G, c.R, c.A);
                    Mat ori = mCanvas.dst.Clone();
                    Cv2.CvtColor(ori, hsv, ColorConversionCodes.BGR2HSV);
                    Cv2.InRange(ori, selColor, selColor, hsv);
                    Cv2.FindContours(hsv, out contours, out hierarchy, RetrievalModes.Tree, ContourApproximationModes.ApproxTC89KCOS);
                    if (i == 0)
                    {
                        mask = hsv;
                    }
                    else
                    {
                        mask += hsv;
                    }
                }
            }
        }

        private void pnl_multi_target_BackColorChanged(object sender, EventArgs e)
        {
            if (rdo_single_target.Checked && mCanvas.mColorChange.cmb_area.SelectedIndex != 0)
            {
                Mat tempMat = mCanvas.dst.Clone();
                Color c = pnl_multi_target.BackColor;
                Scalar s = new Scalar(c.B, c.G, c.R, c.A);
                tempMat.SetTo(s, mask);

                Rect work = new Rect(0, 0, tempMat.Width, tempMat.Height);
                if (mCanvas.mWorkarea.totalPath != null)
                {
                    Rectangle r = Rectangle.Round(mCanvas.mWorkarea.totalPath.GetBounds());
                    work = new Rect((int)r.X, (int)r.Y, (int)r.Width, (int)r.Height);
                }

                mCanvas.dst[work] = tempMat[work];
                mCanvas.PictureBox1.ImageIpl = mCanvas.dst;
            }
        }

        private void btn_change_Click(object sender, EventArgs e)
        {
            isRun = true;
            UpdateDisplay();

            mask = new Mat();

            for (int i = 0; i < multi.colList.Count; i++)
            {
                Mat hsv = new Mat();
                Color c = Color.FromArgb((int)multi.colList[i]);
                Scalar selColor = new Scalar(c.B, c.G, c.R, c.A);
                Mat ori = mCanvas.dst.Clone();
                Cv2.CvtColor(ori, hsv, ColorConversionCodes.BGR2HSV);
                Cv2.InRange(ori, selColor, selColor, hsv);
                if (i == 0)
                {
                    mask = hsv;
                }
                else
                {
                    mask += hsv;
                }

                color += multi.colList[i];
                oriColor = Color.FromArgb(color / multi.colList.Count);
            }

            if (mCanvas.mWorkarea.holeMat != null)
                Cv2.BitwiseAnd(mask, mCanvas.mWorkarea.holeMat, mask);


            if (cmb_method.SelectedIndex == 0) //# RGB
            {
                edit_rgb.Color = oriColor;
            }
            else if (cmb_method.SelectedIndex == 1)
            {
                edit_hsl.Color = oriColor;
            }
            else if (cmb_method.SelectedIndex == 2)
            {
            }
        }

        private void edit_rgb_ColorChanged(object sender, EventArgs e)
        {

            int diffR = edit_rgb.Color.R - oriColor.R;
            if (diffR >= 255)
            {
                diffR -= 255;
            }
            else if (diffR < 0)
            {
                diffR += 255;
            }
            int diffG = edit_rgb.Color.G - oriColor.G;
            if (diffG >= 255)
            {
                diffG -= 255;
            }
            else if (diffG < 0)
            {
                diffG += 255;
            }
            int diffB = edit_rgb.Color.B - oriColor.B;
            if (diffB >= 255)
            {
                diffB -= 255;
            }
            else if (diffB < 0)
            {
                diffB += 255;
            }

            Scalar s = new Scalar(diffB, diffG, diffR, 255);
            Mat src = mCanvas.restore.Clone();
            Mat filter = new Mat(src.Size(), MatType.CV_8UC4, s);
            Mat sumMat = new Mat(src.Size(), MatType.CV_8UC4, 0);

            Cv2.BitwiseOr(src, filter, sumMat);
            sumMat.CopyTo(mCanvas.dst, mask);
            mCanvas.PictureBox1.ImageIpl = mCanvas.dst;
        }

        private void ColorChange_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
            this.Hide();
        }

        private void btn_multi_new_Click(object sender, EventArgs e)
        {
            multi.SelectClear(pnl_color);
        }

        private void btn_multi_all_Click(object sender, EventArgs e)
        {
            multi.SelectAll(pnl_color, mCanvas.restore, mCanvas.mWorkarea.totalPath);
        }

        private void btn_multi_area_Click(object sender, EventArgs e)
        {
            multi.SetSelectState(btn_multi_area);
        }

        private void btn_multi_insert_Click(object sender, EventArgs e)
        {
            multi.SetInsertState(btn_multi_insert);
        }

        private void btn_multi_pre_Click(object sender, EventArgs e)
        {
            multi.SelectRestore(pnl_color);
        }

        private void btn_hls_new_Click(object sender, EventArgs e)
        {
            multi.SelectClear(pnl_slide_color);
        }

        private void btn_hls_all_Click(object sender, EventArgs e)
        {
            multi.SelectAll(pnl_slide_color, mCanvas.restore, mCanvas.mWorkarea.totalPath);
        }

        private void btn_hls_area_Click(object sender, EventArgs e)
        {
            multi.SetSelectState(btn_hls_area);
        }

        private void btn_hls_insert_Click(object sender, EventArgs e)
        {
            multi.SetInsertState(btn_hls_insert);
        }

        private void btn_hls_pre_Click(object sender, EventArgs e)
        {
            multi.SelectRestore(pnl_slide_color);
        }

        private void btn_pre_Click(object sender, EventArgs e)
        {
            isRun = false;
            UpdateDisplay();
        }
    }
}
