﻿using OpenCvSharp;
using OpenCvSharp.Extensions;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;
using cvPoint = OpenCvSharp.Point;
using cvRect = OpenCvSharp.Rect;
using Point = System.Drawing.Point;

namespace TexMaster
{
    public partial class ColorWay : Form
    {
        Canvas mCanvas;

        public List<int> colList;
        public List<int> rmList;
        public List<List<int>> cases = new List<List<int>>();
        public bool isRun;
        public bool isBack;
        //public List<Mat> matList;
        ColorWayForm colorWay;

        public int idx;

        MultiColor multi;

        public ColorWay(Canvas canvas)
        {
            InitializeComponent();
            mCanvas = canvas;

            mCanvas.mColorWay = this;
            idx = 0;
            colList = new List<int>();
            rmList = new List<int>();
        }

        private void ColorWay_Load(object sender, EventArgs e)
        {
            colorWay = new ColorWayForm(mCanvas);
            colorWay.TopMost = true;
            Mat cropMat;

            if (mCanvas.mWorkarea.totalPath != null)
            {
                Rectangle r = Rectangle.Round(mCanvas.mWorkarea.totalPath.GetBounds());
                cvRect rect = new cvRect((int)r.X, (int)r.Y, (int)r.Width, (int)r.Height);
                cropMat = new Mat();
                mCanvas.dst.CopyTo(cropMat, mCanvas.mWorkarea.holeMat);
                cropMat[rect].CopyTo(cropMat);
                colorWay.pictureBoxIpl1.Width = cropMat.Width;
                colorWay.pictureBoxIpl1.Height = cropMat.Height;
                colorWay.pictureBoxIpl1.ImageIpl = cropMat;
            }
            else
            {
                colorWay.pictureBoxIpl1.Width = mCanvas.PictureBox1.Width;
                colorWay.pictureBoxIpl1.Height = mCanvas.PictureBox1.Height;
                colorWay.pictureBoxIpl1.ImageIpl = mCanvas.PictureBox1.ImageIpl;
            }

            colorWay.Show();
            colorWay.DrawColorChip();

            UpdateDisplay();
        }

        private void UpdateDisplay()
        {
            List<Panel> pnlList = new List<Panel>();

            if (!isRun)
            {
                pnlList.Add(pnl_style);
                pnlList.Add(pnl_select);
                pnlList.Add(pnl_change);
            }
            else
            {
                pnlList.Add(pnl_style);
                pnlList.Add(pnl_progress);
                pnlList.Add(pnl_change);
            }

            if (pnlList.Count > 0)
            {
                int top = 0;
                for (int i = 0; i < pnlList.Count; i++)
                {
                    pnlList[i].Visible = true;
                    pnlList[i].Location = new Point(0, top);
                    pnlList[i].BringToFront();
                    top += pnlList[i].Height;
                }

                this.Height = pnlList[pnlList.Count - 1].Top + pnlList[pnlList.Count - 1].Height + 38;  //# 38 - Topbar Height
            }

            this.Refresh();
        }

        private void btn_run_Click(object sender, EventArgs e)
        {
            isRun = true;
            btn_exit.Enabled = true;
            btn_run.Enabled = false;
            btn_auto.Enabled = true;
            UpdateDisplay();

            int n = pnl_color.Controls.Count;
            int r = colList.Count;

            TCombi comb = new TCombi(r, n);

            cases.Clear();

            while (true)
            {
                int[] c = comb.next();
                if (c == null || cases.Count >= 362880) break;

                TPermu perm = new TPermu(c.Length);
                while (true)
                {
                    int[] p = perm.next();
                    if (p == null || cases.Count >= 362880) break;
                    List<int> combColor = new List<int>();
                    for (int j = 0; j < p.Length; j++)
                    {
                        combColor.Add(pnl_color.Controls[c[p[j]]].BackColor.ToArgb());
                    }
                    cases.Add(combColor);
                }
            }

            Console.WriteLine(cases.Count);
            
            cvPoint[][] contours;
            HierarchyIndex[] hierarchy;
            colorWay.matList = new List<Mat>();

            for (int i = 0; i < r; i++)
            {
                Mat hsv = new Mat();
                Color c = Color.FromArgb((int)colList[i]);
                Scalar selColor = new Scalar(c.B, c.G, c.R, c.A);
                Mat ori =colorWay.pictureBoxIpl1.ImageIpl.Clone();
                Cv2.CvtColor(ori, hsv, ColorConversionCodes.BGR2HSV);
                Cv2.InRange(ori, selColor, selColor, hsv);
                Cv2.FindContours(hsv, out contours, out hierarchy, RetrievalModes.Tree, ContourApproximationModes.ApproxTC89KCOS);
                colorWay.matList.Add(hsv);
            }

            lbl_progress.Text = String.Format("{0}/{1}", 0, cases.Count);
            trb_progress.Minimum = 1;
            trb_progress.Maximum = cases.Count;

        }

        private void Perm(List<int> a, int k)
        {
            List<int> colors = new List<int>();
            if (k == a.Count - 1)//순열을 출력
            {
                for (int i = 0; i < a.Count; i++)
                {
                    colors.Add(a[i]);
                }
                cases.Add(colors);
            }
            else
            {
                for (int i = k; i < a.Count; i++)
                {
                    //a[k]와 a[i]를 교환
                    int temp = a[k];
                    a[k] = a[i];
                    a[i] = temp;

                    Perm(a, k + 1); //a[k+1],…,a[n-1]에 대한 모든 순열
                    //원래 상태로 되돌리기 위해 a[k]와 a[i]를 다시 교환
                    temp = a[k];
                    a[k] = a[i];
                    a[i] = temp;
                }
            }

        }

        private void btn_next_Click(object sender, EventArgs e)
        {
            timer1.Interval = 2000;
            isBack = false;
            timer1.Start();
        }

        private void btn_forward_Click(object sender, EventArgs e)
        {
            timer1.Interval = 200;
            isBack = false;
            timer1.Start();
        }

        private void btn_fast_forward_Click(object sender, EventArgs e)
        {
            timer1.Interval = 20;
            isBack = false;
            timer1.Start();
        }

        private void btn_pause_Click(object sender, EventArgs e)
        {
            timer1.Stop();
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            Mat tempMat = colorWay.pictureBoxIpl1.ImageIpl.Clone();

            for (int i = 0; i < cases[idx].Count; i++)
            {
                Console.WriteLine(Color.FromArgb(cases[idx][i]));
                Color c = Color.FromArgb(cases[idx][i]);
                Scalar s = new Scalar(c.B, c.G, c.R, c.A);
                tempMat.SetTo(s, colorWay.matList[i]);
            }

            colorWay.pictureBoxIpl1.ImageIpl = tempMat;

            if (!isBack)
            {
                idx++;
                if (idx >= cases.Count)
                {
                    idx = 0;
                }
                lbl_progress.Text = String.Format("{0}/{1}", idx, cases.Count);
            }
            else
            {
                if (idx <= 0)
                {
                    idx = cases.Count;
                }
                lbl_progress.Text = String.Format("{0}/{1}", idx, cases.Count);
                idx--;
            }
        }

        private void btn_back_Click(object sender, EventArgs e)
        {
            timer1.Interval = 2000;
            isBack = true;
            timer1.Start();
        }

        private void btn_backward_Click(object sender, EventArgs e)
        {
            timer1.Interval = 200;
            isBack = true;
            timer1.Start();
        }

        private void btn_fast_backward_Click(object sender, EventArgs e)
        {
            timer1.Interval = 20;
            isBack = true;
            timer1.Start();
        }

        private void btn_auto_Click(object sender, EventArgs e)
        {
            Mat tempMat = colorWay.pictureBoxIpl1.ImageIpl.Clone();
            Random r = new Random();
            bool isSame;
            int length = (int)nud_style_num.Value;
            int[] randArray = new int[length];

            for (int i = 0; i < length; i++)
            {
                while (true)
                {
                    randArray[i] = r.Next(0, cases.Count - 1);
                    isSame = false;

                    for (int j = 0; j < i; j++)
                    {
                        if (randArray[j] == randArray[i])
                        {
                            isSame = true;
                            break;
                        }
                    }

                    if (!isSame) break;
                }
            }

            for (int j = 0; j < randArray.Length; j++)
            {
                for (int i = 0; i < cases[randArray[j]].Count; i++)
                {
                    Color c = Color.FromArgb(cases[randArray[j]][i]);
                    Scalar s = new Scalar(c.B, c.G, c.R, c.A);
                    tempMat.SetTo(s, colorWay.matList[i]);
                }

                colorWay.pictureBoxIpl1.ImageIpl = tempMat;

                PictureBox index = new PictureBox();
                index.Size = new System.Drawing.Size(25, 25);
                index.Image = imageList1.Images[j];
                index.SizeMode = PictureBoxSizeMode.Zoom;
                colorWay.pnl_small_img.Controls.Add(index);

                FlowLayoutPanel panel = new FlowLayoutPanel();
                panel.AutoSize = true;
                panel.BorderStyle = BorderStyle.FixedSingle;

                PictureBox picture = new PictureBox();
                picture.DoubleClick += pictureBoxDoubleClick;
                float ratio = (float)(colorWay.pnl_small_img.Width - 30) / (float)colorWay.pictureBoxIpl1.ImageIpl.Width;
                picture.Width = (int)((float)colorWay.pictureBoxIpl1.ImageIpl.Width * ratio);
                picture.Height = (int)((float)colorWay.pictureBoxIpl1.ImageIpl.Height * ratio);
                picture.BackgroundImage = BitmapConverter.ToBitmap(colorWay.pictureBoxIpl1.ImageIpl.Clone());
                picture.BackgroundImageLayout = ImageLayout.Zoom;
                panel.Controls.Add(picture);

                int col = 0;
                int row = cases[randArray[j]].Count / 10 + 1;
                PictureBox colorChip = new PictureBox();
                colorChip.SizeMode = PictureBoxSizeMode.AutoSize;
                colorChip.Image = new Bitmap(picture.Width, 20 * row);
                Graphics gr = Graphics.FromImage(colorChip.Image);
                gr.Clear(colorChip.BackColor);

                for (int i = 0; i < cases[randArray[j]].Count; i++)
                {
                    gr.FillRectangle(new SolidBrush(Color.FromArgb(cases[randArray[j]][i])), new RectangleF(20 * col, 20 * ((int)i / 10), 15, 15));
                    col++;
                    if (col >= 10) col = 0;
                }
                panel.Controls.Add(colorChip);

                colorWay.pnl_small_img.Controls.Add(panel);
            }
        }

        private void pictureBoxDoubleClick(object sender, EventArgs e)
        {
            colorWay.pictureBoxIpl1.ImageIpl = BitmapConverter.ToMat((Bitmap)((PictureBox)sender).BackgroundImage);
        }

        private void trb_progress_Scroll(object sender, EventArgs e)
        {
            Mat tempMat = colorWay.pictureBoxIpl1.ImageIpl.Clone();

            for (int i = 0; i < cases[trb_progress.Value - 1].Count; i++)
            {
                Console.WriteLine(Color.FromArgb(cases[trb_progress.Value - 1][i]));
                Color c = Color.FromArgb(cases[trb_progress.Value - 1][i]);
                Scalar s = new Scalar(c.B, c.G, c.R, c.A);
                tempMat.SetTo(s, colorWay.matList[i]);
            }

            colorWay.pictureBoxIpl1.ImageIpl = tempMat;

            lbl_progress.Text = String.Format("{0}/{1}", trb_progress.Value, cases.Count);
        }

        private void ColorWay_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
            this.Hide();
        }

        private void btn_new_Click(object sender, EventArgs e)
        {
            multi.SelectClear(pnl_color);
        }

        private void btn_all_Click(object sender, EventArgs e)
        {
            multi.SelectAll(pnl_color, mCanvas.dst, mCanvas.mWorkarea.totalPath);
        }

        private void btn_area_Click(object sender, EventArgs e)
        {
            multi.SetSelectState(btn_area);
        }

        private void btn_insert_Click(object sender, EventArgs e)
        {
            multi.SetInsertState(btn_insert);
        }

        private void btn_pre_Click(object sender, EventArgs e)
        {
            multi.SelectRestore(pnl_color);
        }
    }

    class TCombi
    {
        private int[] result;
        private Stack<int> stack;
        private int r, n;

        public TCombi(int r, int n)
        {   // nCr 계산
            this.r = r;
            this.n = n;
            result = new int[r];
            stack = new Stack<int>();
            stack.Push(0);
        }

        public int[] next()
        {   // null 리턴하면 더 이상 없음
            while (stack.Count > 0)
            {
                int index = stack.Count - 1;
                int value = stack.Pop();

                while (value < n)
                {
                    result[index++] = value++;
                    stack.Push(value);
                    if (index == r)
                    {
                        return result;
                    }
                }
            }
            return null;
        }
    }

    class TPermu
    {
        private int num;
        private int[] arr;

        public TPermu(int num)
        {
            this.num = num;
            arr = null;
        }

        public int[] next()
        {   // 다음 순열 못찾으면 null 리턴
            //---------------------------------------------
            //  첫번째 순열
            //---------------------------------------------
            if (arr == null)
            {
                arr = new int[num];
                for (int k = 0; k < num; k++) arr[k] = k;
                return arr;
            }

            //---------------------------------------------
            //  Find i
            //---------------------------------------------
            int i, j;
            bool found;
            found = false;
            for (i = num - 1 - 1; i >= 0; i--)
            {
                if (arr[i] < arr[i + 1])
                {
                    found = true;
                    break;
                }
            }

            if (found == false)
                return null;

            //---------------------------------------------
            //  Find j
            //---------------------------------------------
            found = false;
            for (j = num - 1; j >= 1; j--)
            {
                if (arr[j] > arr[i])
                {
                    found = true;
                    break;
                }
            }

            if (found == false)
                return null;

            //---------------------------------------------
            //  swap i, j
            //---------------------------------------------
            swap(ref arr[i], ref arr[j]);

            //---------------------------------------------
            //  sorting from i+1
            //---------------------------------------------
            int m, n, imin;
            for (m = i + 1; m < num - 1; m++)
            {
                imin = m;
                for (n = m + 1; n < num; n++)
                {
                    if (arr[n] < arr[imin]) imin = n;
                }
                swap(ref arr[m], ref arr[imin]);
            }

            return arr;
        }

        //========================================================
        //  swap
        //========================================================
        private static void swap(ref int a, ref int b)
        {
            int tmp = a;
            a = b;
            b = tmp;
        }
    }
}
