﻿using OpenCvSharp;
using OpenCvSharp.Extensions;
using System;
using System.Drawing;
using System.Windows.Forms;
using cvPoint = OpenCvSharp.Point;
using cvRect = OpenCvSharp.Rect;
using cvSize = OpenCvSharp.Size;

namespace TexMaster
{
    public partial class Fill : Form
    {
        private Canvas mCanvas;
        public bool bPattern;
        public Mat cropMat;

        MultiColor multi;

        public Fill(Canvas canvas)
        {
            InitializeComponent();
            mCanvas = canvas;
            mCanvas.mFill = this;

            multi = new MultiColor();
        }

        private void Fill_Load(object sender, EventArgs e)
        {

        }

        public void fill_MouseDown(MouseEventArgs e)
        {
            if (chk_select.Checked)
            {
                multi.MouseDown(mCanvas.dst, mCanvas.mWorkarea.totalPath, pnl_color, e);
                mCanvas.drawing = true;
            }
            else
            {
                if (bPattern)
                {
                    Mat mask = GetFillMask(mCanvas.dst, new cvPoint(e.X, e.Y));
                    Mat fill = PatternFill(mask, new cvPoint(e.X, e.Y));
                    fill.CopyTo(mCanvas.dst, mask);
                }
                else
                {
                    if (chk_air.Checked)
                    {
                        Mat mask = GetFillMask(mCanvas.dst, new cvPoint(e.X, e.Y));
                        Mat fill = SprayFill(mask, new cvPoint(e.X, e.Y));
                        fill.CopyTo(mCanvas.dst, mask);
                    }
                    else
                    {
                        mCanvas.dst = FloodFill(mCanvas.dst, new cvPoint(e.X, e.Y));
                    }
                }
                mCanvas.PictureBox1.ImageIpl = mCanvas.dst;
                mCanvas.restore = mCanvas.dst.Clone();
            }
        }

        public void fill_MouseMove(MouseEventArgs e)
        {
            if (chk_select.Checked)
            {
                multi.MouseMove(e);
                mCanvas.PictureBox1.Refresh();
            }
            else
            {
                if (bPattern)
                {
                    if (cropMat != null)
                    {
                        Mat dst = mCanvas.dst.Clone();
                        cvRect r = new cvRect(e.X - cropMat.Width / 2, e.Y - cropMat.Height / 2, cropMat.Width, cropMat.Height);
                        dst[r] = cropMat;
                        mCanvas.PictureBox1.ImageIpl = dst;
                    }
                }
                else
                {
                    pnl_s_pre.BackColor = Color.FromArgb(mCanvas.dst.At<int>(e.Y, e.X));
                }
            }
        }

        public void fill_MouseUp(MouseEventArgs e)
        {
            if (chk_select.Checked)
            {
                multi.MouseUp(mCanvas.dst, pnl_color, e);
                mCanvas.drawing = false;
                mCanvas.PictureBox1.Refresh();
            }
        }

        public void fill_Paint(PaintEventArgs e)
        {
            if (chk_select.Checked)
            {
                multi.Paint(e);
            }
        }


        //# fill
        public Mat GetFillMask(Mat src, cvPoint seedPt)
        {
            Mat hsv = new Mat();

            //# 배경색 제거
            Color c = Color.FromArgb(mCanvas.dst.At<int>(seedPt.Y, seedPt.X));
            Scalar s = new Scalar(c.B, c.G, c.R, 255);
            Cv2.InRange(src, s, s, hsv);

            //# 채우기 전 이미지
            Mat ori = hsv.Clone();
            //# 채운 후 이미지
            Cv2.FloodFill(hsv, seedPt, 0);
            Mat diff = new Mat();
            //# 차이비교 - 채워질 영역 mask 반환
            Cv2.BitwiseXor(hsv, ori, diff);
            return diff;
        }


        public Mat FloodFill(Mat src, cvPoint pt)
        {
            Mat fill = new Mat();
            Mat[] rgba = new Mat[4];

            Cv2.Split(src.Clone(), out rgba);

            Mat r = rgba[0];
            Mat g = rgba[1];
            Mat b = rgba[2];

            rgba = new Mat[3];
            rgba[0] = r;
            rgba[1] = g;
            rgba[2] = b;

            Cv2.Merge(rgba, fill);

            Color c = mCanvas.mPalette.color;
            Cv2.FloodFill(fill, pt, new Scalar(c.B, c.G, c.R));

            return fill;
        }

        public Mat PatternFill(Mat mask, cvPoint seedPt)
        {
            int row = mask.Height / cropMat.Height + 2;
            int col = mask.Width / cropMat.Width + 2;
            int xOffset = seedPt.X % cropMat.Width;
            int yOffset = seedPt.Y % cropMat.Height;

            Mat ret_mat = new Mat(new cvSize(cropMat.Width * col, cropMat.Height * row), MatType.CV_8UC4, 0);

            for (int i = 0; i < row; i++)
            {
                for (int j = 0; j < col; j++)
                {
                    ret_mat[new cvRect(cropMat.Width * j, cropMat.Height * i, cropMat.Width, cropMat.Height)] = cropMat;
                }
            }

            int x = cropMat.Width / 2 - xOffset > 0 ? cropMat.Width / 2 - xOffset : cropMat.Width - xOffset;
            int y = cropMat.Height / 2 - yOffset > 0 ? cropMat.Height / 2 - yOffset : cropMat.Height - yOffset;
            Mat resizeMat = ret_mat[new cvRect(x, y, mask.Width, mask.Height)];
            return resizeMat;
        }

        public Mat SprayFill(Mat mask, cvPoint seedPt)
        {
            Mat sprayMat = mCanvas.dst.Clone();
            Color c = Color.FromArgb(pnl_s_post.BackColor.R, pnl_s_post.BackColor.G, pnl_s_post.BackColor.B);
            Scalar s = new Scalar(c.G, c.B, c.R, c.A);
            Random rand = new Random();

            for (int i = 0; i < mask.Width; i++)
            {
                for (int j = 0; j < mask.Height; j++)
                {
                    if (mask.At<int>(j, i) != 0)
                    {
                        if (rand.Next(0, (int)(1 / (0.005 * (float)(nud_density.Value)))) == 0)
                        {
                            int cnt = 0;
                            for (int x = 0; x < (int)Math.Sqrt((int)nud_nozzle.Value - 1) + 1; x++)
                            {
                                for (int y = 0; y < (int)Math.Sqrt((int)nud_nozzle.Value - 1) + 1; y++)
                                {
                                    if (cnt >= (int)nud_nozzle.Value)
                                        break;
                                    int currentX = j + x < mask.Width ? j + x : mask.Width - 1;
                                    int currentY = i + y < mask.Height ? i + y : mask.Height - 1;
                                    sprayMat.Set<int>(currentX, currentY, c.ToArgb());
                                    cnt++;
                                }
                            }
                        }
                    }
                }
            }

            return sprayMat;
        }


        private void btn_s_pattern_Click(object sender, EventArgs e)
        {
            if (mCanvas.mWorkarea.totalPath.PointCount > 0)
            {
                bPattern = true;
                mCanvas.mDrawObject = CanvasType.BITMAP;

                Rectangle r = Rectangle.Round(mCanvas.mWorkarea.totalPath.GetBounds());
                cvRect rect = new cvRect((int)r.X, (int)r.Y, (int)r.Width, (int)r.Height);
                if (cropMat == null)
                {
                    cropMat = new Mat();
                }
                mCanvas.dst.CopyTo(cropMat, mCanvas.mWorkarea.holeMat);
                cropMat[rect].CopyTo(cropMat);

                mCanvas.drawing = true;

                //Cv2.ImShow("cropMat", cropMat);

                pnl_s_post.BackColor = Color.White;
                pnl_s_post.BackgroundImageLayout = ImageLayout.Zoom;
                pnl_s_post.BackgroundImage = BitmapConverter.ToBitmap(cropMat);
            }
        }

        private void btn_s_single_Click(object sender, EventArgs e)
        {
            bPattern = false;

            mCanvas.mDrawObject = CanvasType.BITMAP;
            MainMenu.mode = MainMode.FILL;
            mCanvas.tsl_mode.Text = MainMenu.mode.ToString();

            pnl_s_post.BackgroundImage = null;
            pnl_s_post.BackColor = mCanvas.mPalette.color;
        }

        private void Fill_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
            this.Hide();
        }

        private void btn_new_Click(object sender, EventArgs e)
        {
            multi.SelectClear(pnl_color);
        }

        private void btn_all_Click(object sender, EventArgs e)
        {
            multi.SelectAll(pnl_color, mCanvas.dst, mCanvas.mWorkarea.totalPath);
        }

        private void btn_area_Click(object sender, EventArgs e)
        {
            multi.SetSelectState(btn_area);
        }

        private void btn_insert_Click(object sender, EventArgs e)
        {
            multi.SetInsertState(btn_insert);
        }

        private void btn_pre_Click(object sender, EventArgs e)
        {
            multi.SelectRestore(pnl_color);
        }
    }
}
