﻿using System;
using System.Drawing;
using System.Windows.Forms;
using TexMaster.Source;

namespace TexMaster
{
    public partial class FullView : Form
    {
        Canvas mCanvas;
        public static float gridX;
        public static float gridY;
        public static RulerType type;

        public enum RulerType
        {
            DIAG, HORZ, VERT
        }

        public FullView(Canvas canvas)
        {
            InitializeComponent();
            mCanvas = canvas;
            type = RulerType.DIAG;
            gridX = 5.0F;
            gridY = 5.0F;
        }

        private void btn_grid_Click(object sender, EventArgs e)
        {
            Grid grid = new Grid(mCanvas);
            grid.ShowDialog();
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            if (mCanvas.PictureBox1.Image == null) return;
            float zoom = (float)pnl_stretch_img.Width / mCanvas.PictureBox1.Image.Width;
            Bitmap resizeImage = new Bitmap(mCanvas.PictureBox1.Image, Size.Round(new SizeF(mCanvas.PictureBox1.Image.Width * zoom, mCanvas.PictureBox1.Image.Height * zoom)));
            pic_stretch_img.Size = new Size(pnl_stretch_img.Width, pnl_stretch_img.Height);
            pic_stretch_img.Image = resizeImage;

            if (mCanvas.unit == UnitType.DOT)
            {
                txt_grid_x.Text = String.Format("{0}", gridX);
                txt_grid_y.Text = String.Format("{0}", gridY);
            }
            else
            {
                txt_grid_x.Text = String.Format("{0, 0:N2}", gridX);
                txt_grid_y.Text = String.Format("{0, 0:N2}", gridY);
            }
        }

        private void FullView_Load(object sender, EventArgs e)
        {
            timer1.Start();
        }

        private void FullView_FormClosing(object sender, FormClosingEventArgs e)
        {
            timer1.Stop();
        }

        private void btn_ruler_Click(object sender, EventArgs e)
        {
            //Draw.gShape = TShape.RULER;
            //cms_ruler.Show(MousePosition.X - cms_ruler.Width, MousePosition.Y);
        }

        private void btn_angle_Click(object sender, EventArgs e)
        {

        }

        private void tsm_diagonal_Click(object sender, EventArgs e)
        {
            type = RulerType.DIAG;
        }

        private void tsm_horiz_Click(object sender, EventArgs e)
        {
            type = RulerType.HORZ;
        }

        private void tsm_vert_Click(object sender, EventArgs e)
        {
            type = RulerType.VERT;
        }
    }
}
