﻿using OpenCvSharp;
using OpenCvSharp.Extensions;
using System;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;
using cvRect = OpenCvSharp.Rect;
using Point = System.Drawing.Point;

namespace TexMaster
{
    public partial class MoveCopy : Form
    {
        Canvas mCanvas;

        public MoveCopyType movetype = MoveCopyType.NONE;
        public Mat cropMat;
        public Mat reverseMat;
        public cvRect selArea;
        public cvRect changeArea;

        private Point pt;

        public enum MoveCopyType
        {
            NONE, MOVE, COPY
        }

        public MoveCopy(Canvas canvas)
        {
            InitializeComponent();
            mCanvas = canvas;
            mCanvas.mMove = this;
        }

        private void MoveCopy_Load(object sender, EventArgs e)
        {
            Init();
            this.Height = pnl_moveCopy.Height + 38;
            movetype = MoveCopyType.MOVE;
            CropMat();
            reverseMat = cropMat.Clone();

            ToolTip toolTip = new ToolTip();
            toolTip.ShowAlways = true;
            toolTip.SetToolTip(btn_normal, "표준");
            toolTip.SetToolTip(btn_LR, "좌우");
            toolTip.SetToolTip(btn_TB, "상하");
            toolTip.SetToolTip(btn_TBLR, "상하좌우");
            toolTip.SetToolTip(btn_rotation, "회전");
            toolTip.SetToolTip(btn_rotary, "회전거울");
            toolTip.SetToolTip(btn_bend, "부채꼴");
        }

        private void Init()
        {
            pnl_preview.Visible = false;
            pnl_rotate.Visible = false;
            pnl_bend.Visible = false;
        }

        public void CropMat()
        {
            Rectangle r = Rectangle.Round(mCanvas.mWorkarea.totalPath.GetBounds());
            selArea = new cvRect((int)r.X, (int)r.Y, (int)r.Width, (int)r.Height);
            if (cropMat == null)
            {
                cropMat = new Mat();
            }
            mCanvas.dst.CopyTo(cropMat, mCanvas.mWorkarea.holeMat);
            cropMat[selArea].CopyTo(cropMat);
        }

        public void move_MouseDown(MouseEventArgs e)
        {
            pt = e.Location;

            changeArea = new cvRect(pt.X - reverseMat.Width / 2, pt.Y - reverseMat.Height / 2, reverseMat.Width, reverseMat.Height);
            if (movetype == MoveCopyType.MOVE)
            {
                Matrix mat = new Matrix();
                mat.Translate(pt.X - (selArea.Left + selArea.Width / 2), pt.Y - (selArea.Top + selArea.Height / 2));
                mCanvas.mWorkarea.totalPath.Transform(mat);
                mCanvas.mWorkarea.GetHoleMat();

                mCanvas.dst[selArea].SetTo(new Scalar(255, 255, 255, 255));
                selArea = changeArea;
            }

            mCanvas.dst = mCanvas.LastList(mCanvas.matList);
            mCanvas.dst[changeArea] = reverseMat;

            mCanvas.matList.Add(mCanvas.dst);
            //cropMat = null;
            mCanvas.restore = mCanvas.dst.Clone();
            mCanvas.PictureBox1.ImageIpl = mCanvas.dst;

            mCanvas.drawing = false;
            mCanvas.PictureBox1.Refresh();
        }

        public void move_MouseMove(MouseEventArgs e)
        {
            if (reverseMat == null) return; //# 작업 구역 이미지가 없을 때
            pt = e.Location;
        }

        public void move_Paint(PaintEventArgs e)
        {
            if (reverseMat != null)
            {
                pt = new Point(pt.X - reverseMat.Width / 2, pt.Y - reverseMat.Height / 2);
                e.Graphics.DrawImage(BitmapConverter.ToBitmap(reverseMat), pt);
            }
        }

        private void btn_move_Click(object sender, EventArgs e)
        {
            CropMat();
            mCanvas.drawing = true;
            movetype = MoveCopyType.MOVE;
        }

        private void btn_copy_Click(object sender, EventArgs e)
        {
            CropMat();
            mCanvas.drawing = true;
            movetype = MoveCopyType.COPY;
        }


        private void btn_reverse_Click(object sender, EventArgs e)
        {
            int idx = Convert.ToInt32(((Button)sender).Tag);
            reverseMat = cropMat.Clone();

            //# 구현 중
            switch (idx)
            {
                case 0:
                    //# btn_normal
                    break;
                case 1:
                    //# btn_LR
                    reverseMat = cropMat.Flip(FlipMode.Y);
                    break;
                case 2:
                    //# btn_TB
                    reverseMat = cropMat.Flip(FlipMode.X);
                    break;
                case 3:
                    //# btn_TBLR
                    reverseMat = cropMat.Flip(FlipMode.XY);
                    break;
                case 4:
                    //# btn_rotation
                    break;
                case 5:
                    //# btn_rotary
                    break;
                case 6:
                    //# btn_bend
                    break;
                default:
                    break;
            }
        }

        private void MoveCopy_FormClosing(object sender, FormClosingEventArgs e)
        {
            movetype = MoveCopyType.NONE;
            e.Cancel = true;
            this.Hide();
        }
    }
}
