﻿using OpenCvSharp;
using OpenCvSharp.Extensions;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;
using Point = System.Drawing.Point;
using cvRect = OpenCvSharp.Rect;

namespace TexMaster
{
    public partial class PatternRepeat : Form
    {
        Canvas mCanvas;

        public enum PatternMethod { NONE, REGULAR, IRREGULAR, SPRAY };

        public PatternMethod method;
        public List<int> colList;
        public List<int> colCnt;

        public bool isSelPos;

        public PatternRepeat(Canvas canvas)
        {
            InitializeComponent();
            mCanvas = canvas;
            mCanvas.mPattern = this;
            method = PatternMethod.NONE;
            colList = new List<int>();
            colCnt = new List<int>();
        }

        private void PatternRepeat_Load(object sender, EventArgs e)
        {
            UpdateDisplay(method);
            cmb_method.SelectedIndex = 0;
            cmb_location.SelectedIndex = 0;

            Rectangle r = Rectangle.Round(mCanvas.mWorkarea.totalPath.GetBounds());
            cvRect rect = new cvRect((int)r.X, (int)r.Y, (int)r.Width, (int)r.Height);
            if (mCanvas.cropMat == null)
            {
                mCanvas.cropMat = new Mat();
            }
            mCanvas.dst.CopyTo(mCanvas.cropMat, mCanvas.mWorkarea.holeMat);
            mCanvas.cropMat[rect].CopyTo(mCanvas.cropMat);
        }

        private void UpdateDisplay(PatternMethod method)
        {
            List<Panel> pnlList = new List<Panel>();
            pnlList.Add(pnl_button);

            switch (method)
            {
                case PatternMethod.REGULAR:
                    pnlList.Add(pnl_regular);
                    break;
                case PatternMethod.IRREGULAR:
                    break;
                case PatternMethod.SPRAY:
                    pnlList.Add(pnl_image);
                    break;

            }

            if (pnlList.Count > 0)
            {
                int top = 0;
                for (int i = 0; i < pnlList.Count; i++)
                {
                    pnlList[i].Visible = true;
                    pnlList[i].Location = new Point(0, top);
                    pnlList[i].BringToFront();
                    top += pnlList[i].Height;
                }

                this.Height = pnlList[pnlList.Count - 1].Top + pnlList[pnlList.Count - 1].Height + 38;  //# 38 - Topbar Height
            }

            this.Refresh();
        }

        private void btn_regular_Click(object sender, EventArgs e)
        {
            method = PatternMethod.REGULAR;
            pic_one.Refresh();
            UpdateDisplay(method);
        }

        private void btn_irregular_Click(object sender, EventArgs e)
        {
            if (mCanvas.mWorkarea.totalPath != null)
            {
                Mat workMat = CropMat(mCanvas.PictureBox1.ImageIpl.Clone());
                int total = 0;

                colCnt.Clear();
                colList.Clear();

                //# 작업구역 테두리 제외 영역만 비교
                for (int i = 0; i < workMat.Width - 1; i++)
                {
                    for (int j = 0; j < workMat.Height - 1; j++)
                    {
                        if (workMat.At<int>(i, j) == 0) continue; //# 투명 부분은 처리하지 않는다 - 연산 속도 향상
                        total++; //# 0이 아닌 부분은 색상이 있는 값이므로 총 픽셀 수에 더해준다.
                        if (workMat.At<int>(i, j) != workMat.At<int>(i + 1, j + 1) && !colList.Contains(workMat.At<int>(i, j)))
                        {
                            colList.Add(workMat.At<int>(i, j));
                        }
                    }
                }

                int acc = 0; //# 누적 확률

                for (int i = 0; i < colList.Count; i++)
                {
                    Mat hsv = new Mat();
                    Color c = Color.FromArgb(colList[i]);
                    Scalar s = new Scalar(c.B, c.G, c.R, c.A);
                    Cv2.InRange(workMat, s, s, hsv);
                    acc += 100 * hsv.CountNonZero() / total;
                    colCnt.Add(acc);
                }
            }

        }

        public Mat CropMat(Mat oriMat)
        {
            Mat cropMat = new Mat();
            oriMat.CopyTo(cropMat, mCanvas.mWorkarea.holeMat);
            return cropMat;
        }

        private void btn_spray_Click(object sender, EventArgs e)
        {
            method = PatternMethod.SPRAY;
            pic_spray.Refresh();
            UpdateDisplay(method);
        }

        private void btn_position_Click(object sender, EventArgs e)
        {
            isSelPos = true;
            btn_position.Enabled = false;
        }

        private void PatternDraw(object sender, PaintEventArgs e)
        {
            pic_one.BackgroundImage = BitmapConverter.ToBitmap(mCanvas.cropMat);
            pic_spray.BackgroundImage = BitmapConverter.ToBitmap(mCanvas.cropMat);
        }

        private void btn_irregular_MouseDown(object sender, MouseEventArgs e)
        {
            method = PatternMethod.IRREGULAR;
            UpdateDisplay(method);
        }

        private void PatternRepeat_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
            this.Hide();
        }
    }
}
