﻿using System.Drawing;
using System.Drawing.Printing;
using System.Windows.Forms;
using TexMaster.Source;

namespace TexMaster
{
    public partial class PrintForm : Form
    {
        /*
        internal PrintPreviewDialog PrintPreviewDialog1;
        private System.Drawing.Printing.PrintDocument document = new System.Drawing.Printing.PrintDocument();
        private int curPageNumber;
        private int curPageNumber_bak;

        public PrintForm()
        {
            InitializeComponent();
            this.PrintPreviewDialog1 = new PrintPreviewDialog();
            curPageNumber = 1;

            //Set the size, location, and name.
            this.PrintPreviewDialog1.ClientSize =
                new System.Drawing.Size(400, 300);
            this.PrintPreviewDialog1.Location =
                new System.Drawing.Point(29, 29);
            this.PrintPreviewDialog1.Name = "PrintPreviewDialog1";

            // Associate the event-handling method with the
            // document's PrintPage event.
            this.document.PrintPage +=
                new System.Drawing.Printing.PrintPageEventHandler
                (document_PrintPage);

            this.document.BeginPrint += new System.Drawing.Printing.PrintEventHandler(document_BeginPrint);
            // Set the minimum size the dialog can be resized to.
            this.PrintPreviewDialog1.MinimumSize =
                new System.Drawing.Size(700, 700);

            // Set the UseAntiAlias property to true, which will allow the
            // operating system to smooth fonts.
            this.PrintPreviewDialog1.UseAntiAlias = true;

            curPageNumber = 2;
            curPageNumber_bak = 2;
        }

        void document_BeginPrint(object sender, System.Drawing.Printing.PrintEventArgs e)
        {
            curPageNumber = curPageNumber_bak;
            //throw new NotImplementedException();
        }

        private void document_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            System.Drawing.Font printFont = new System.Drawing.Font("휴먼모음T", 25, System.Drawing.FontStyle.Regular);

            e.Graphics.DrawString("- " + (curPageNumber) + " -", printFont, System.Drawing.Brushes.Black, 400, 400);
            if (curPageNumber == 0)
            {
                e.HasMorePages = false;

            }
            else
            {
                e.HasMorePages = true;
                curPageNumber--;
            }
        }
        */

        Canvas mCanvas;
        public PrintForm(Canvas canvas)
        {
            InitializeComponent();
            mCanvas = canvas;

            pri_setting = new PrintDialog();
            lbl_printer.Text = pri_setting.PrinterSettings.PrinterName;
            cmb_format.SelectedIndex = 0;
        }

        public PrintForm()
        {
            InitializeComponent();
            pri_setting = new PrintDialog();
            lbl_printer.Text = pri_setting.PrinterSettings.PrinterName;
            cmb_format.SelectedIndex = 0;

        }

        private void btn_preview_Click(object sender, System.EventArgs e)
        {
            pri_doc = new PrintDocument();
            pri_preview = new PrintPreviewDialog();

            pri_doc.PrintPage += new PrintPageEventHandler(pri_doc_PrintPage);
            pri_doc.PrinterSettings.PrinterName = lbl_printer.Text;

            pri_preview.Document = pri_doc;
            pri_preview.Show();

        }

        void pri_doc_PrintPage(object sender, PrintPageEventArgs e)
        {
            Font pf = new Font("궁서", 20, FontStyle.Regular);

            //# Canvas Image
            //Image img = BitCanvas.gCanvasImage;
            //e.Graphics.DrawImage(img, 0, 0, img.Width, img.Height);
        }

        private void btn_set_Click(object sender, System.EventArgs e)
        {
            pri_setting.ShowDialog();
            lbl_printer.Text = pri_setting.PrinterSettings.PrinterName;
        }

        private void btn_print_Click(object sender, System.EventArgs e)
        {
            
        }

        private void cmb_format_SelectedIndexChanged(object sender, System.EventArgs e)
        {
            switch (cmb_format.SelectedIndex) {
                case 0: //# image
                    pnl_colorchip.Enabled = false;
                    break;
                case 1: //# image / colorchip
                    pnl_colorchip.Enabled = true;
                    break;
                case 2: //# colorchip
                    pnl_colorchip.Enabled = true;
                    break;
                case 3: //# palette
                    pnl_colorchip.Enabled = false;
                    break;
            }
        }

        private void PrintForm_FormClosing(object sender, FormClosingEventArgs e)
        {

        }
    }
}
