﻿using OpenCvSharp;
using OpenCvSharp.UserInterface;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;
using cvRect = OpenCvSharp.Rect;
using Size = System.Drawing.Size;

namespace TexMaster
{
    public partial class Reflection : Form
    {
        private Canvas mCanvas;

        public bool isReflect = false;              //반전 그리기 모드 여부
        Rectangle totalRect;                        //MainCanvas 작업구역의 Bounds
        public ReflectionType type;                 //반전 그리기 모드
        public ReflectionArea area;                 //반전 영역(반절 or 전체)
        public Size refImageSize;                   //refImage의 Size
        public Mat refMat;                          //Reflection Image
        public List<Mat> refMatList;                //Reflection Mat List
        public Mat flipMat, totalMat;               //반전된 Mat, refImage + flipMat = totalMat

        public PictureBoxIpl flipPic;

        public enum ReflectionType
        {
            LEFT2RIGHT, RIGHT2LEFT, TOP2BOTTOM, BOTTOM2TOP
        }
        public enum ReflectionArea
        {
            HALF, FULL
        }

        public Reflection(Canvas canvas)
        {
            InitializeComponent();
            mCanvas = canvas;
            mCanvas.mReflection = this;

            refMatList = new List<Mat>();
            flipPic = new PictureBoxIpl();
            flipPic.Parent = mCanvas.panel1;

            isReflect = false;
            type = ReflectionType.LEFT2RIGHT;
            area = ReflectionArea.HALF;
            rdo_reflection.Checked = true;
            rdo_image.Checked = false;
        }

        public void reflection_Paint(PaintEventArgs e)
        {
            if (isReflect)
            {
                int w, h;
                switch (type)
                {
                    case ReflectionType.LEFT2RIGHT:
                        w = refMat.Width - 1; h = refMat.Height - 1;
                        e.Graphics.DrawLine(mCanvas.mWorkarea.blankPen, new PointF(w, 0), new PointF(w, h));
                        e.Graphics.DrawLine(mCanvas.mWorkarea.dashPen, new PointF(w, 0), new PointF(w, h));
                        break;
                    case ReflectionType.RIGHT2LEFT:
                        w = flipMat.Width - 1; h = flipMat.Height - 1;
                        e.Graphics.DrawLine(mCanvas.mWorkarea.blankPen, new PointF(w, 0), new PointF(w, h));
                        e.Graphics.DrawLine(mCanvas.mWorkarea.dashPen, new PointF(w, 0), new PointF(w, h));
                        break;
                    case ReflectionType.TOP2BOTTOM:
                        w = refMat.Width - 1; h = refMat.Height - 1;
                        e.Graphics.DrawLine(mCanvas.mWorkarea.blankPen, new PointF(0, h), new PointF(w, h));
                        e.Graphics.DrawLine(mCanvas.mWorkarea.dashPen, new PointF(0, h), new PointF(w, h));
                        break;
                    case ReflectionType.BOTTOM2TOP:
                        w = flipMat.Width - 1; h = flipMat.Height - 1;
                        e.Graphics.DrawLine(mCanvas.mWorkarea.blankPen, new PointF(0, h), new PointF(w, h));
                        e.Graphics.DrawLine(mCanvas.mWorkarea.dashPen, new PointF(0, h), new PointF(w, h));
                        break;
                }
                return;
            }
        }

        public void SetReflectionMode()
        {
            //작업구역이 없으면 전체영역을 작업구역으로 설정 해야함
            if (mCanvas.mWorkarea.totalPath == null) refImageSize = new Size(mCanvas.restore.Width, mCanvas.restore.Height);
            else refImageSize = new Size((int)mCanvas.mWorkarea.totalPath.GetBounds().Width, (int)mCanvas.mWorkarea.totalPath.GetBounds().Height);

            SetReflectionImage(refImageSize.Width, refImageSize.Height, area, type);
        }

        private void SetReflectionImage(int w, int h, ReflectionArea area, ReflectionType type)
        {
            totalRect = Rectangle.Round(mCanvas.mWorkarea.totalPath.GetBounds());
            Mat subMat = mCanvas.restore.SubMat(totalRect.Y, totalRect.Y + totalRect.Height, totalRect.X, totalRect.X + totalRect.Width);
            refMat = new Mat();
            if (area == ReflectionArea.HALF)
            {
                switch (type)
                {
                    case ReflectionType.LEFT2RIGHT:
                        refMat = subMat.SubMat(0, h, 0, (w / 2) + w % 2);
                        break;
                    case ReflectionType.RIGHT2LEFT:
                        refMat = subMat.SubMat(0, h, w / 2, w);
                        break;
                    case ReflectionType.TOP2BOTTOM:
                        refMat = subMat.SubMat(0, (h / 2) + h % 2, 0, w);
                        break;
                    case ReflectionType.BOTTOM2TOP:
                        refMat = subMat.SubMat(h / 2, h, 0, w);
                        break;
                }
            }
            else
            {
                switch (type)
                {
                    case ReflectionType.LEFT2RIGHT:
                        if (mCanvas.restore.Width / 2 > refImageSize.Width) refMat = subMat.SubMat(0, h, 0, w);
                        else refMat = subMat.SubMat(0, h, 0, (w / 2) + w % 2);
                        break;
                    case ReflectionType.RIGHT2LEFT:
                        if (mCanvas.restore.Width / 2 > refImageSize.Width) refMat = subMat.SubMat(0, h, 0, w);
                        else refMat = subMat.SubMat(0, h, w / 2, w);
                        break;
                    case ReflectionType.TOP2BOTTOM:
                        if (mCanvas.restore.Height / 2 > refImageSize.Height) refMat = subMat.SubMat(0, h, 0, w);
                        else refMat = subMat.SubMat(0, (h / 2) + h % 2, 0, w);
                        break;
                    case ReflectionType.BOTTOM2TOP:
                        if (mCanvas.restore.Height / 2 > refImageSize.Height) refMat = subMat.SubMat(0, h, 0, w);
                        else refMat = subMat.SubMat(h / 2, h, 0, w);
                        break;
                }
            }
            SetReflectionMat(refMat);
            mCanvas.PictureBox1.Refresh();
        }

        public void SetReflectionMat(Mat refMat)
        {

            totalMat = new Mat();
            flipMat = new Mat();
            //반전되는 Mat 설정 MatList 마지막을 가져와서
            switch (type)
            {
                case ReflectionType.LEFT2RIGHT:
                    if (totalRect.Width % 2 == 1) Cv2.Flip(refMat.SubMat(0, refMat.Height, 0, refMat.Width - 1), flipMat, FlipMode.Y);
                    else Cv2.Flip(refMat, flipMat, FlipMode.Y);
                    Cv2.HConcat(refMat, flipMat, totalMat);

                    flipPic.Location = new System.Drawing.Point(refMat.Width, 0);
                    mCanvas.PictureBox1.Location = new System.Drawing.Point(0, 0);
                    break;
                case ReflectionType.RIGHT2LEFT:
                    if (totalRect.Width % 2 == 1) Cv2.Flip(refMat.SubMat(0, refMat.Height, 1, refMat.Width), flipMat, FlipMode.Y);
                    else Cv2.Flip(refMat, flipMat, FlipMode.Y);
                    Cv2.HConcat(flipMat, refMat, totalMat);

                    flipPic.Location = new System.Drawing.Point(0, 0);
                    mCanvas.PictureBox1.Location = new System.Drawing.Point(flipMat.Width, 0);
                    break;
                case ReflectionType.TOP2BOTTOM:
                    if (totalRect.Height % 2 == 1) Cv2.Flip(refMat.SubMat(0, refMat.Height - 1, 0, refMat.Width), flipMat, FlipMode.X);
                    else Cv2.Flip(refMat, flipMat, FlipMode.X);
                    Cv2.VConcat(refMat, flipMat, totalMat);

                    flipPic.Location = new System.Drawing.Point(0, refMat.Height);
                    mCanvas.PictureBox1.Location = new System.Drawing.Point(0, 0);
                    break;
                case ReflectionType.BOTTOM2TOP:
                    if (totalRect.Height % 2 == 1) Cv2.Flip(refMat.SubMat(1, refMat.Height, 0, refMat.Width), flipMat, FlipMode.X);
                    else Cv2.Flip(refMat, flipMat, FlipMode.X);
                    Cv2.VConcat(flipMat, refMat, totalMat);

                    flipPic.Location = new System.Drawing.Point(0, 0);
                    mCanvas.PictureBox1.Location = new System.Drawing.Point(0, flipMat.Height);
                    break;
            }
            flipPic.Size = new Size(flipMat.Width, flipMat.Height);
            flipPic.ImageIpl = flipMat;

            mCanvas.dst = refMat.Clone();
            mCanvas.matList.Add(refMat.Clone());
            mCanvas.PictureBox1.Size = new Size(refMat.Width, refMat.Height);
            mCanvas.PictureBox1.ImageIpl = refMat;

            refMatList.Add(refMat.Clone());
        }

        private void btn_run_Click(object sender, EventArgs e)
        {
            isReflect = true;
            SetReflectionMode();
            mCanvas.Refresh();
        }
        private void btn_cancel_Click(object sender, EventArgs e)
        {
            this.Hide();
            mCanvas.PictureBox1.Size = new Size(mCanvas.restore.Width, mCanvas.restore.Height);
            mCanvas.PictureBox1.ImageIpl = mCanvas.restore.Clone();
            isReflect = false;
        }
        private void btn_apply_Click(object sender, EventArgs e)
        {
            if (!isReflect) return;

            this.Hide();
            if (area == ReflectionArea.HALF)
            {
                MainMenu.mode = MainMode.DRAW;
                mCanvas.restore[new cvRect(totalRect.X, totalRect.Y, totalRect.Width, totalRect.Height)] = totalMat;
                mCanvas.PictureBox1.Size = new Size(mCanvas.restore.Width, mCanvas.restore.Height);
                mCanvas.PictureBox1.ImageIpl = mCanvas.restore.Clone();
                mCanvas.dst = mCanvas.restore.Clone();
                mCanvas.matList.Add(mCanvas.restore.Clone());
            }
            else
            {
                //이미지 붙여넣기 코드
                MainMenu.mode = MainMode.MOVE;
                mCanvas.PictureBox1.Size = new Size(mCanvas.restore.Width, mCanvas.restore.Height);
                mCanvas.PictureBox1.ImageIpl = mCanvas.restore.Clone();
                mCanvas.matList.Add(mCanvas.restore.Clone());
                mCanvas.mMove.movetype = MoveCopy.MoveCopyType.COPY;
                mCanvas.mMove.cropMat = totalMat.Clone();
                mCanvas.drawing = true;
            }
            isReflect = false;
        }

        private void rdo_r_right_CheckedChanged(object sender, EventArgs e)
        {
            if (rdo_r_right.Checked)
            {
                type = ReflectionType.LEFT2RIGHT;
            }
        }
        private void rdo_r_left_CheckedChanged(object sender, EventArgs e)
        {
            if (rdo_r_left.Checked)
            {
                type = ReflectionType.RIGHT2LEFT;
            }
        }


        private void rdo_r_top_CheckedChanged(object sender, EventArgs e)
        {
            if (rdo_r_top.Checked)
            {
                type = ReflectionType.TOP2BOTTOM;
            }
        }
        private void rdo_r_bottom_CheckedChanged(object sender, EventArgs e)
        {
            if (rdo_r_bottom.Checked)
            {
                type = ReflectionType.BOTTOM2TOP;
            }
        }

        private void rdo_reflection_CheckedChanged(object sender, EventArgs e)
        {
            if (rdo_reflection.Checked)
            {
                area = ReflectionArea.HALF;
            }
        }

        private void rdo_image_CheckedChanged(object sender, EventArgs e)
        {
            if (rdo_image.Checked)
            {
                area = ReflectionArea.FULL;
            }
        }

        private void Reflection_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
            this.Hide();
        }


    }
}
