﻿using OpenCvSharp;
using System;
using System.Drawing;
using System.Windows.Forms;
using cvPoint = OpenCvSharp.Point;
using cvRect = OpenCvSharp.Rect;
using cvSize = OpenCvSharp.Size;

namespace TexMaster
{
    public partial class Scratch : Form
    {
        Canvas mCanvas;

        public Mat cropMat;


        public Scratch(Canvas canvas)
        {
            InitializeComponent();
            mCanvas = canvas;
        }

        private void btn_run_Click(object sender, EventArgs e)
        {
            Rectangle r;
            cvRect rect;
            if (mCanvas.mWorkarea.totalPath != null)
            {
                r = Rectangle.Round(mCanvas.mWorkarea.totalPath.GetBounds());
                rect = new cvRect((int)r.X, (int)r.Y, (int)r.Width, (int)r.Height);

                cropMat = new Mat();
                mCanvas.dst.CopyTo(cropMat, mCanvas.mWorkarea.holeMat);
                cropMat[rect].CopyTo(cropMat);
            }
            else
            {
                rect = new cvRect(0, 0, mCanvas.dst.Width, mCanvas.dst.Height);
                cropMat = mCanvas.dst.Clone();
            }

            Random rand = new Random();

            for (int i = 0; i < (int)nud_density.Value * mCanvas.dst.Width / (int)nud_width.Value; i++)
            {
                //Console.WriteLine("{0}", rand.Next(0, cropMat.Width));
                //Console.WriteLine("{0}", rand.Next(0, cropMat.Height));

                int xOffset = (int)(((double)nud_length.Value / 2) * Math.Cos((double)nud_angle.Value * Math.PI / 180));
                int yOffset = (int)(((double)nud_length.Value / 2) * Math.Sin((double)nud_angle.Value * Math.PI / 180));
                cvPoint center = new cvPoint(rand.Next(0, cropMat.Width), rand.Next(0, cropMat.Height));
                cvPoint start = new cvPoint(center.X - xOffset, center.Y - yOffset);
                cvPoint end = new cvPoint(center.X + xOffset, center.Y + yOffset);
                Color c = Color.FromArgb(cropMat.At<int>(center.Y, center.X));
                Scalar s = new Scalar(c.B, c.G, c.R, 255);

                //Console.WriteLine("{0}, {1}", xOffset, yOffset);

                //Cv2.Rectangle(cropMat, new cvRect(new cvPoint(center.X - 2, center.Y - 2), new cvSize(4, 4)), Scalar.DeepSkyBlue, -1, LineTypes.Link8);
                //Cv2.Rectangle(cropMat, new cvRect(new cvPoint(start.X - 2, start.Y - 2), new cvSize(4, 4)), Scalar.Red, -1, LineTypes.Link8);
                //Cv2.Rectangle(cropMat, new cvRect(new cvPoint(end.X - 2, end.Y - 2), new cvSize(4, 4)), Scalar.Blue, -1, LineTypes.Link8);

                for (int j = 0; j < (int)nud_width.Value; j++)
                {
                    Cv2.Line(cropMat, new cvPoint(start.X + j, start.Y), new cvPoint(end.X + j, end.Y), s);
                }
            }

            Mat tempMat = new Mat(new cvSize(mCanvas.dst.Width, mCanvas.dst.Height), MatType.CV_8UC4, 0);
            tempMat[rect] = cropMat;
            //Cv2.ImShow("tempMat", tempMat);
            tempMat.CopyTo(mCanvas.dst, mCanvas.mWorkarea.holeMat);
            mCanvas.PictureBox1.ImageIpl = mCanvas.dst;

            //Cv2.ImShow("cropMat", cropMat);


        }

        private void Scratch_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
            this.Hide();
        }
    }
}
