﻿using OpenCvSharp;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;
using cvPoint = OpenCvSharp.Point;
using cvRect = OpenCvSharp.Rect;
using Point = System.Drawing.Point;

namespace TexMaster
{
    public partial class Separate : Form
    {
        public Mat cropMat;
        public List<int> colList;
        public List<int> lastList;

        public cvRect rect;

        public bool isArea;
        public bool isDelete;
        public Point start, end;

        Canvas mCanvas;
        MultiColor multi;

        public Separate(Canvas canvas)
        {
            InitializeComponent();
            mCanvas = canvas;
            mCanvas.mSeparate = this;

            colList = new List<int>();
            lastList = new List<int>();
            multi = new MultiColor();
        }

        private void Separate_Load(object sender, EventArgs e)
        {
            btn_area.Image = imageList1.Images[2];      //# area
            btn_insert.Image = imageList1.Images[0];    //# insert

            isArea = true;
            isDelete = false;
            GetCropMat();
        }

        private void GetCropMat()
        {
            cropMat = new Mat();
            if (mCanvas.mWorkarea.totalPath != null)
            {
                Rectangle r = Rectangle.Round(mCanvas.mWorkarea.totalPath.GetBounds());
                rect = new cvRect((int)r.X, (int)r.Y, (int)r.Width, (int)r.Height);
                mCanvas.dst.CopyTo(cropMat, mCanvas.mWorkarea.holeMat);
                cropMat[rect].CopyTo(cropMat);
            }
            else
            {
                rect = new cvRect(0, 0, mCanvas.PictureBox1.Width, mCanvas.PictureBox1.Height);
                cropMat = mCanvas.dst.Clone();
            }
        }

        public void separate_MouseDown(MouseEventArgs e)
        {
            multi.MouseDown(mCanvas.dst, mCanvas.mWorkarea.totalPath, pnl_color, e);
            mCanvas.drawing = true;
        }

        public void separate_MouseMove(MouseEventArgs e)
        {
            multi.MouseMove(e);
            mCanvas.PictureBox1.Refresh();
        }

        public void separate_MouseUp(MouseEventArgs e)
        {
            multi.MouseUp(mCanvas.dst, pnl_color, e);
            mCanvas.drawing = false;
            mCanvas.PictureBox1.Refresh();
        }

        public void separate_Paint(PaintEventArgs e)
        {
            multi.Paint(e);
        }

        private void btn_run_Click(object sender, EventArgs e)
        {
            cvPoint[][] contours;
            HierarchyIndex[] hierarchy;
            Mat ori = cropMat.Clone();
            Mat mask = new Mat();
            lastList = colList;

            for (int i = 0; i < colList.Count; i++)
            {
                Mat hsv = new Mat();
                Color c = Color.FromArgb((int)colList[i]);
                Scalar selColor = new Scalar(c.B, c.G, c.R, c.A);
                Cv2.CvtColor(ori, hsv, ColorConversionCodes.BGR2HSV);
                Cv2.InRange(ori, selColor, selColor, hsv);
                Cv2.FindContours(hsv, out contours, out hierarchy, RetrievalModes.Tree, ContourApproximationModes.ApproxTC89KCOS);

                Mat dil = new Mat();
                Cv2.Dilate(hsv, dil, null, null, (int)nud_overlap.Value);
                //Cv2.BitwiseNot(dil, dil);
                ori.SetTo(selColor, dil);
                if (i == 0)
                {
                    mask = dil;
                }
                else
                {
                    mask += dil;
                }
            }

            Cv2.BitwiseNot(mask, mask);
            ori.SetTo(new Scalar(255, 255, 255, 255), mask);

            mCanvas.dst[rect] = ori;
            mCanvas.PictureBox1.ImageIpl = ori;

            btn_run.Enabled = false;
            btn_apply.Enabled = true;
        }

        private void btn_apply_Click(object sender, EventArgs e)
        {
            mCanvas.dst[rect] = cropMat;
            mCanvas.PictureBox1.ImageIpl = mCanvas.dst;

            btn_run.Enabled = true;
            btn_apply.Enabled = false;
        }


        private void Separate_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
            this.Hide();
        }

        private void btn_new_Click(object sender, EventArgs e)
        {
            multi.SelectClear(pnl_color);
        }

        private void btn_all_Click(object sender, EventArgs e)
        {
            multi.SelectAll(pnl_color, mCanvas.dst, mCanvas.mWorkarea.totalPath);
        }

        private void btn_area_Click(object sender, EventArgs e)
        {
            multi.SetSelectState(btn_area);
        }

        private void btn_insert_Click(object sender, EventArgs e)
        {
            multi.SetInsertState(btn_insert);
        }

        private void btn_pre_Click(object sender, EventArgs e)
        {
            multi.SelectRestore(pnl_color);
        }
    }
}
