﻿using OpenCvSharp;
using System;
using System.Drawing;
using System.Windows.Forms;
using cvPoint = OpenCvSharp.Point;

namespace TexMaster
{
    public partial class Shadow : Form
    {
        public Canvas mCanvas;
        public Mat shadow, cMask, sMask, restore, roi;
        public int angle, distance;
        public cvPoint leftTop, newPt;

        public Scalar cScalar, sScalar;

        public void SetShadowData()
        {
            //Init
            Rectangle workRect = Rectangle.Round(mCanvas.mWorkarea.totalPath.GetBounds());
            leftTop = new cvPoint(workRect.X, workRect.Y);
            newPt = GetCirclePosition(trb_angle.Value, trb_distance.Value, leftTop);
            pnl_color.BackColor = mCanvas.mPen.penColor;
            restore = mCanvas.restore.Clone();
            //임시 흰색 초기화
            cScalar = new Scalar(Color.FromArgb(-1).B, Color.FromArgb(-1).G, Color.FromArgb(-1).R, Color.FromArgb(-1).A);
            sScalar = new Scalar(pnl_color.BackColor.B, pnl_color.BackColor.G, pnl_color.BackColor.R, pnl_color.BackColor.A);

            //Shadow Init
            shadow = mCanvas.restore[new Rect(workRect.X, workRect.Y, workRect.Width, workRect.Height)];
            Cv2.CvtColor(shadow, sMask, ColorConversionCodes.BGR2HSV);
            Cv2.InRange(shadow, cScalar, cScalar, sMask);
            Mat tempMat = shadow.Clone();
            tempMat.SetTo(cScalar);
            Cv2.BitwiseNot(sMask, sMask);
            tempMat.SetTo(sScalar, sMask);
            shadow = tempMat;

            roi = new Mat(restore, new Rect(newPt.X, newPt.Y, shadow.Width, shadow.Height));

            Cv2.CvtColor(roi, cMask, ColorConversionCodes.BGR2HSV);
            Cv2.InRange(roi, cScalar, cScalar, cMask);
        }

        private void trb_angle_ValueChanged(object sender, System.EventArgs e)
        {
            lbl_angle.Text = trb_angle.Value.ToString();
            SetShadowImage();
        }
        private void trb_distance_ValueChanged(object sender, System.EventArgs e)
        {
            lbl_distance.Text = trb_distance.Value.ToString();
            SetShadowImage();
        }

        public void SetShadowImage()
        {
            newPt = GetCirclePosition(trb_angle.Value, trb_distance.Value, leftTop);
            roi = new Mat(restore, new Rect(newPt.X, newPt.Y, shadow.Width, shadow.Height));

            Cv2.CvtColor(roi, cMask, ColorConversionCodes.BGR2HSV);
            Cv2.InRange(roi, cScalar, cScalar, cMask);
            shadow.CopyTo(roi, cMask);
            mCanvas.PictureBox1.ImageIpl = restore;
            restore = mCanvas.restore.Clone();
        }
        private void btn_apply_Click(object sender, EventArgs e)
        {
            mCanvas.dst = mCanvas.PictureBox1.ImageIpl;
            mCanvas.matList.Add(mCanvas.dst);

            this.Hide();
            MainMenu.mode = MainMode.DRAW;
        }

        private void Shadow_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
            this.Hide();
            mCanvas.PictureBox1.ImageIpl = mCanvas.restore;
            MainMenu.mode = MainMode.DRAW;
        }

        private cvPoint GetCirclePosition(int angle, int distance, cvPoint origin)
        {
            double rad = Math.PI * angle / 180.0;
            return new cvPoint(origin.X + distance * Math.Cos(rad), origin.Y + distance * Math.Sin(rad));
        }

        public Shadow(Canvas canvas)
        {
            InitializeComponent();
            mCanvas = canvas;
            mCanvas.mShadow = this;

            cMask = new Mat();
            sMask = new Mat();
        }
    }
}
