﻿using OpenCvSharp;
using System;
using System.Drawing;
using System.Windows.Forms;

using cvRect = OpenCvSharp.Rect;
using cvPoint = OpenCvSharp.Point;
using cvSize = OpenCvSharp.Size;
using System.Collections.Generic;

namespace TexMaster
{
    public partial class Smooth : Form
    {
        Canvas mCanvas;

        List<int> colList;
        
        public Smooth(Canvas canvas)
        {
            InitializeComponent();
            mCanvas = canvas;
            mCanvas.mSmooth = this;

            colList = new List<int>();
        }

        private void Smooth_Load(object sender, EventArgs e)
        {
            cmb_type.SelectedIndex = 0;
        }

        public void smooth_MouseDown(MouseEventArgs e)
        {
            Mat src = new Mat();
            Mat dst = new Mat();

            switch (cmb_type.SelectedIndex)
            {
                case 0: //# 선택 색상
                    Console.WriteLine("select");
                    break;
                case 1: //# 작업 구역
                    Console.WriteLine("area");
                    Rectangle r;
                    cvRect rect;
                    if (mCanvas.mWorkarea.totalPath != null)
                    {
                        r = Rectangle.Round(mCanvas.mWorkarea.totalPath.GetBounds());
                        rect = new cvRect((int)r.X, (int)r.Y, (int)r.Width, (int)r.Height);

                        src = new Mat();
                        mCanvas.dst.CopyTo(src, mCanvas.mWorkarea.holeMat);
                        src[rect].CopyTo(src);
                    }
                    else
                    {
                        rect = new cvRect(0, 0, mCanvas.dst.Width, mCanvas.dst.Height);
                        src = mCanvas.dst.Clone();
                    }

                    //Cv2.ImShow("src", src);
                    //Cv2.Dilate(src, dst, null, null, 1, BorderTypes.Replicate);
                    //Cv2.ImShow("dst", dst);

                    mCanvas.dst[rect] = dst;
                    mCanvas.PictureBox1.ImageIpl = mCanvas.dst;


                    break;
                case 2: //# 전체
                    Console.WriteLine("whole");
                    break;
            }
        }

        private void Smooth_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
            this.Hide();
        }
    }
}
