﻿using OpenCvSharp;
using System;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;
using cvPoint = OpenCvSharp.Point;

namespace TexMaster
{
    public partial class Stitch : Form
    {
        Canvas mCanvas;
        public int hori;
        public int vert;
        public int invt;

        public Stitch(Canvas canvas)
        {
            InitializeComponent();
            mCanvas = canvas;
            mCanvas.mStitch = this;
        }

        private void Stitch_Load(object sender, System.EventArgs e)
        {
            cmb_line1.SelectedIndex = 0;
            cmb_line2.SelectedIndex = 0;
            cmb_line3.SelectedIndex = 0;

            hori = 8;
            vert = 4;
            invt = 10;

            nud_dot2.Value = hori;
            nud_gap2.Value = vert;
            nud_space2.Value = invt;
        }

        private void ComboBox_DrawItem(object sender, DrawItemEventArgs e)
        {
            Rectangle rect = new Rectangle(2, e.Bounds.Top + 2, e.Bounds.Width, e.Bounds.Height - 4);
            //e.Graphics.FillRectangle(new SolidBrush(Color.White), rect);
            int x = e.Bounds.X + 5;
            int y = e.Bounds.Y + e.Bounds.Height / 2;
            int length = e.Bounds.Width - 10;

            hori = 8;
            vert = 4;

            e.Graphics.SmoothingMode = SmoothingMode.AntiAlias;
            e.Graphics.FillRectangle(new SolidBrush(Color.White), rect);
            Pen pen = new Pen(Color.Black, 2);
            pen.SetLineCap(LineCap.Round, LineCap.Round, DashCap.Round);
            switch (e.Index)
            {
                case 0: //# cross
                    for (int i = 0; i < length / (hori + 2); i++)
                    {
                        e.Graphics.DrawLine(pen, x + (i * (hori + 2)), y - vert, x + (i * (hori + 2)) + hori, y + vert);
                        e.Graphics.DrawLine(pen, x + (i * (hori + 2)), y + vert, x + (i * (hori + 2)) + hori, y - vert);
                    }
                    break;
                case 1: //# stitch
                    e.Graphics.DrawLine(pen, x, y, x + length - length % hori, y);
                    for (int i = 0; i < length / hori; i++)
                    {
                        e.Graphics.DrawLine(pen, x + (i * hori) + vert, y - vert, x + (i * hori) + vert, y + vert);
                    }
                    break;
                case 2: //# zigzag
                    for (int i = 0; i < length / hori; i++)
                    {
                        if (i % 2 == 0)
                        {
                            e.Graphics.DrawLine(pen, x + (i * hori), y, x + (i * hori) + hori / 2, y - vert);
                            e.Graphics.DrawLine(pen, x + (i * hori) + hori / 2, y - vert, x + (i * hori) + hori, y);
                        }
                        else
                        {
                            e.Graphics.DrawLine(pen, x + (i * hori), y, x + (i * hori) + hori / 2, y + vert);
                            e.Graphics.DrawLine(pen, x + (i * hori) + hori / 2, y + vert, x + (i * hori) + hori, y);
                        }
                    }
                    break;
                case 3: //# dash
                    for (int i = 0; i < length / hori; i++)
                    {
                        if (i % 2 == 0)
                        {
                            e.Graphics.DrawLine(pen, x + (i * hori), y, x + (i * hori) + hori, y);
                        }
                    }
                    break;
                case 4: //# line
                    e.Graphics.DrawLine(pen, x, y, x + length - length % hori, y);
                    break;
                case 5: //# none
                    e.Graphics.DrawString("None", this.Font, Brushes.Black, rect);
                    break;
            }
            e.DrawFocusRectangle();
        }

        private void nup_dot2_ValueChanged(object sender, EventArgs e)
        {
            hori = (int)nud_dot2.Value;
        }

        private void nup_gap2_ValueChanged(object sender, EventArgs e)
        {
            vert = (int)nud_gap2.Value;
        }

        private void nup_space2_ValueChanged(object sender, EventArgs e)
        {
            invt = (int)nud_space2.Value;
        }

        public void DrawStitch(cvPoint start, cvPoint end, int idx, int hori, int vert)
        {
            int length = (int)Math.Sqrt(Math.Pow(start.X - end.X, 2) + Math.Pow(start.Y - end.Y, 2));
            int angle = 360 - (int)(mCanvas.GetAngle(start, end));

            if (idx == 2)
            {
                hori /= 2;
            }

            double xLine = mCanvas.penSize * hori * Math.Cos(angle * Math.PI / 180);
            double yLine = mCanvas.penSize * hori * Math.Sin(angle * Math.PI / 180);

            double xOffset = mCanvas.penSize * vert * Math.Cos(angle * Math.PI / 180);
            double yOffset = mCanvas.penSize * vert * Math.Sin(angle * Math.PI / 180);

            int dLen = (int)Math.Sqrt(Math.Pow(xLine + xOffset, 2) + Math.Pow(yLine + yOffset, 2));
            cvPoint current = start;
            cvPoint next;

            int cnt = length / (int)Math.Sqrt(xLine * xLine + yLine * yLine);

            switch (idx)
            {
                case 0: //# cross
                    for (int i = 0; i < length / dLen; i++)
                    {
                        next = new cvPoint(current.X + xLine, current.Y - yLine);

                        //# 수직점
                        double a = mCanvas.penSize * vert * Math.Sin(angle * Math.PI / 180);
                        double b = mCanvas.penSize * vert * Math.Cos(angle * Math.PI / 180);

                        Cv2.Line(mCanvas.dst, new cvPoint(current.X + a, current.Y + b), new cvPoint(next.X - a, next.Y - b), mCanvas.penColor, mCanvas.penSize);
                        Cv2.Line(mCanvas.dst, new cvPoint(next.X + a, next.Y + b), new cvPoint(current.X - a, current.Y - b), mCanvas.penColor, mCanvas.penSize);
                        current = new cvPoint(next.X + xOffset, next.Y - yOffset);
                    }
                    break;
                case 1: //# stitch
                    for (int i = 0; i < length / dLen; i++)
                    {
                        if (i == cnt - 1)
                        {
                            break;
                        }

                        next = new cvPoint(current.X + xLine, current.Y - yLine);

                        //# 수직점
                        int a = (int)(mCanvas.penSize * vert * Math.Sin(angle * Math.PI / 180));
                        int b = (int)(mCanvas.penSize * vert * Math.Cos(angle * Math.PI / 180));

                        Cv2.Line(mCanvas.dst, current, next, mCanvas.penColor, mCanvas.penSize);
                        Cv2.Line(mCanvas.dst, new cvPoint(next.X + a, next.Y + b), new cvPoint(next.X - a, next.Y - b), mCanvas.penColor, mCanvas.penSize);
                        current = next;
                    }
                    break;
                case 2: //# zigzag
                    for (int i = 0; i < length * 2 / dLen; i++)
                    {
                        next = new cvPoint(current.X + xLine, current.Y - yLine);

                        //# 수직점
                        int a = (int)(mCanvas.penSize * vert * Math.Sin(angle * Math.PI / 180));
                        int b = (int)(mCanvas.penSize * vert * Math.Cos(angle * Math.PI / 180));

                        if (i % 2 == 0)
                        {
                            Cv2.Line(mCanvas.dst, new cvPoint(current.X, current.Y), new cvPoint((current.X + next.X) / 2 + a, (current.Y + next.Y) / 2 + b), mCanvas.penColor, mCanvas.penSize);
                            Cv2.Line(mCanvas.dst, new cvPoint((current.X + next.X) / 2 + a, (current.Y + next.Y) / 2 + b), new cvPoint(next.X, next.Y), mCanvas.penColor, mCanvas.penSize);
                        }
                        else
                        {
                            Cv2.Line(mCanvas.dst, new cvPoint(current.X, current.Y), new cvPoint((current.X + next.X) / 2 - a, (current.Y + next.Y) / 2 - b), mCanvas.penColor, mCanvas.penSize);
                            Cv2.Line(mCanvas.dst, new cvPoint((current.X + next.X) / 2 - a, (current.Y + next.Y) / 2 - b), new cvPoint(next.X, next.Y), mCanvas.penColor, mCanvas.penSize);
                        }
                        current = next;
                    }
                    break;
                case 3: //# dashcvPoint current = start;
                    for (int i = 0; i < length / dLen; i++)
                    {
                        next = new cvPoint(current.X + xLine, current.Y - yLine);
                        Cv2.Line(mCanvas.dst, current, next, mCanvas.penColor, mCanvas.penSize);
                        current = new cvPoint(next.X + xOffset, next.Y - yOffset);
                    }
                    break;
                case 4: //# line
                    Cv2.Line(mCanvas.dst, start, end, mCanvas.penColor, mCanvas.penSize);
                    break;
            }
        }

        private void Stitch_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
            this.Hide();
        }
    }
}
