﻿using System;
using System.ComponentModel;
using System.Drawing.Drawing2D;
using System.Windows.Forms;
using TexMaster.Source;

namespace TexMaster
{
    public partial class VectorList : Form
    {
        private Canvas mCanvas;
        private bool isAscending = true;

        public VectorList(Canvas canvas)
        {
            mCanvas = canvas;
            InitializeComponent();
        }

        private void VectorList_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true; //리소스를 해제하지 않아 데이터를 유지할 수 있다
            this.Hide();
        }

        private void dgv_vector_ColumnHeaderMouseClick(object sender, DataGridViewCellMouseEventArgs e)
        {
            if (e.ColumnIndex == 0)
            {
                if (isAscending)
                {
                    dgv_vector.Sort(dgv_vector.Columns[0], ListSortDirection.Ascending);
                    isAscending = false;
                }
                else
                {
                    dgv_vector.Sort(dgv_vector.Columns[0], ListSortDirection.Descending);
                    isAscending = true;
                }
            }
            else if (e.ColumnIndex == 3)
            {
                if (isAscending)
                {
                    dgv_vector.SortCompare += OnVectorListSortCompare;
                    dgv_vector.Sort(dgv_vector.Columns[3], ListSortDirection.Ascending);
                    isAscending = false;
                }
                else
                {
                    dgv_vector.SortCompare += OnVectorListSortCompare;
                    dgv_vector.Sort(dgv_vector.Columns[3], ListSortDirection.Descending);
                    isAscending = true;
                }
            }
            else
            {
                return;
            }
        }

        private void dgv_vector_RowHeaderMouseClick(object sender, DataGridViewCellMouseEventArgs e)
        {
            mCanvas.mVector.selPathIndex.Clear();
            mCanvas.mVector.selTempPath.Clear();

            for (int i = 0; i < dgv_vector.SelectedRows.Count; i++)
            {
                if (!(bool)dgv_vector[4, dgv_vector.SelectedRows[i].Index].Value)
                {
                    int idx = int.Parse((string)dgv_vector[0, dgv_vector.SelectedRows[i].Index].Value);
                    mCanvas.mVector.selPathIndex.Add(idx);
                    mCanvas.mVector.selTempPath.Add((GraphicsPath)mCanvas.mVector.vecList[idx].path.Clone());
                }
            }

            mCanvas.mVector.mode = Mode.SELECT;
            mCanvas.mVector.VectorCanvasRefresh();
        }

        private void OnVectorListSortCompare(object sender, DataGridViewSortCompareEventArgs e)
        {
            string v1 = e.CellValue1 != null ? e.CellValue1.ToString() : string.Empty;
            string v2 = e.CellValue2 != null ? e.CellValue2.ToString() : string.Empty;

            e.SortResult = String.Compare(v1, v2);
            e.Handled = true;
        }

        private void dgv_vector_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex < 0) return;

            switch (e.ColumnIndex)
            {
                case 1://View
                    var cbxView = (DataGridViewCheckBoxCell)dgv_vector.Rows[e.RowIndex].Cells[1];
                    if ((bool)cbxView.Value)
                    {
                        cbxView.Value = false;
                    }
                    else
                    {
                        cbxView.Value = true;
                    }
                    dgv_vector.EndEdit();
                    mCanvas.mVector.VectorCanvasRefresh();
                    break;
                case 4://Lock
                    var cbxLcok = (DataGridViewCheckBoxCell)dgv_vector.Rows[e.RowIndex].Cells[4];
                    if ((bool)cbxLcok.Value)
                    {
                        cbxLcok.Value = false;
                    }
                    else
                    {
                        cbxLcok.Value = true;
                    }
                    dgv_vector.EndEdit();
                    mCanvas.mVector.VectorCanvasRefresh();
                    break;
            }
        }
    }
}
