﻿using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;
using System.Collections.Generic;
using Excel = Microsoft.Office.Interop.Excel;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;

namespace TexMaster
{
    public partial class MakePCL : Form
    {
        Excel.Application excelApp = null;
        Excel.Workbook workBook = null;
        Excel.Worksheet workSheet = null;

        Pantone newPantone;
        Dictionary<int, Pantone> pantones;

        public MakePCL()
        {
            InitializeComponent();
        }

        private void btn_make_Click(object sender, EventArgs e)
        {
            lbl_state.Text = "Reading........";
            btn_make.Enabled = false;
            pantones = new Dictionary<int, Pantone>();

            try
            {
                excelApp = new Excel.Application();
                workBook = excelApp.Workbooks.Open("D:\\PANTONE® FHI TPG Paper 2625_LAB.xlsx");
                workSheet = workBook.Worksheets.get_Item(1) as Excel.Worksheet;

                Excel.Range range = workSheet.UsedRange;
                int page = 0;
                int code = 0;
                for (int row = 13; row <= range.Rows.Count; row++)
                {
                    newPantone = new Pantone();

                    newPantone.index = Convert.ToInt32(range.Cells[row, 2].Value2);

                    if ((newPantone.index - 1) % 35 == 0)
                    {
                        page++;
                    }
                    newPantone.page = page;
                    newPantone.col = Convert.ToInt32(range.Cells[row, 3].Value2);
                    newPantone.row = Convert.ToInt32(range.Cells[row, 4].Value2);
                    newPantone.code = Convert.ToString(range.Cells[row, 5].Value2);

                    //# code
                    code = PantoneCodeConvert(newPantone.code);
                    //Console.Write(code);
                    //Console.WriteLine();

                    newPantone.name = Convert.ToString(range.Cells[row, 6].Value2);

                    newPantone.r = Convert.ToInt32(range.Cells[row, 39].Value2);
                    newPantone.g = Convert.ToInt32(range.Cells[row, 40].Value2);
                    newPantone.b = Convert.ToInt32(range.Cells[row, 41].Value2);

                    pantones.Add(code, newPantone);
                }
                lbl_state.Text = "Read Success.......!";
                lbl_state.Text = "Saving........";
                SavePCL();
                lbl_state.Text = "Save Success.......!";
                workBook.Close(true);
                excelApp.Quit();

                btn_make.Enabled = true;
            }
            finally
            {
                ReleaseObject(workSheet);
                ReleaseObject(workBook);
                ReleaseObject(excelApp);
            }
        }

        private void ReleaseObject(object obj)
        {
            try
            {
                if (obj != null)
                {
                    Marshal.ReleaseComObject(obj); // 액셀 객체 해제 
                    obj = null;
                }
            }
            catch (Exception ex)
            {
                obj = null;
                throw ex;
            }
            finally
            {
                GC.Collect(); // 가비지 수집
            }
        }

        public int PantoneCodeConvert(string code)
        {
            char[] separator = { ' ', '-' };
            string[] split = code.Split(separator);

            int int_code = Convert.ToInt32(split[1] + split[2]);

            return int_code;
        }

        public void SavePCL()
        {
            FileStream fs = new FileStream("D:\\Paper.pcl", FileMode.Create);
            BinaryFormatter formatter = new BinaryFormatter();
            try
            {
                formatter.Serialize(fs, pantones);
            }
            catch
            {
                Console.WriteLine("fail");
                throw;
            }
            finally
            {
                fs.Close();
            }
        }

        private void LoadPCL(string filename)
        {
            if (pantones != null)
            {
                pantones.Clear();
            }

            FileStream fs = new FileStream(filename, FileMode.Open);
            BinaryFormatter formatter = new BinaryFormatter();

            try
            {
                pantones = (Dictionary<int, Pantone>)formatter.Deserialize(fs);
            }
            catch
            {
                Console.WriteLine("fail");
                throw;
            }
            finally
            {
                fs.Close();
            }

        }

        private void btn_load_Click(object sender, EventArgs e)
        {
            lbl_state.Text = "Loading........";
            OpenFileDialog fileDialog = new OpenFileDialog();
            fileDialog.Filter = "Pantone Color Library File|*.pcl";

            if (fileDialog.ShowDialog() == DialogResult.Cancel) return;
            LoadPCL(fileDialog.FileName);
            lbl_state.Text = "Load Success.......!";
        }

        private void textBox1_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
            {
                int key = Convert.ToInt32(textBox1.Text);
                if (pantones.ContainsKey(key))
                {
                    panel1.BackColor = System.Drawing.Color.FromArgb(pantones[key].r, pantones[key].g, pantones[key].b);
                }
            }
        }

        private void btn_search_Click(object sender, EventArgs e)
        {
            Pantone findPantone = new Pantone();

            int R = Convert.ToInt32(numericUpDown1.Value);
            int G = Convert.ToInt32(numericUpDown2.Value);
            int B = Convert.ToInt32(numericUpDown3.Value);

            findPantone = FindPantonColorFromRGB(pantones, System.Drawing.Color.FromArgb(R, G, B));
            panel1.BackColor = System.Drawing.Color.FromArgb(findPantone.r, findPantone.g, findPantone.b);
            Console.Write(findPantone.name);
            Console.WriteLine();
        }

        public Pantone FindPantonColorFromRGB(Dictionary<int, Pantone> pantones, System.Drawing.Color s_color)
        {
            double min = 500;                               // MAX = 441.6729559
            double distance;
            int key = 0;
            foreach (KeyValuePair<int, Pantone> items in pantones)
            {
                distance = Math.Sqrt(Math.Pow(items.Value.r - s_color.R, 2) + Math.Pow(items.Value.g - s_color.G, 2) + Math.Pow(items.Value.b - s_color.B, 2));

                if (min > distance)
                {
                    min = distance;
                    key = items.Key;
                    if (min == 0)                       //같은 값을 찾았으면 더 돌 필요없이 Return
                    {
                        return pantones[key];
                    }
                }
            }

            return pantones[key];
        }

        private void MakePCL_Load(object sender, EventArgs e)
        {
            //LoadPCL();
        }
    }
}
