﻿using Cyotek.Windows.Forms;
using OpenCvSharp;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;
using System.Windows.Forms;
using Point = System.Drawing.Point;


namespace TexMaster
{
    public enum Library
    {
        PANTONE, PRINTER, STANDARD, TEXTILE, USER
    }
    [Serializable()]
    public struct ColorChip
    {
        public int index;
        public int r, g, b;
        public Library library;
        public string code;
        public double ratio;
        public bool protect;
    }

    public partial class Palette : Form
    {
        public Color color;
        public bool updating;
        public int ctrl;
        public Canvas mCanvas;
        public List<ColorChip> mColorList = new List<ColorChip>();

        public Palette(Canvas canvas)
        {
            InitializeComponent();
            mCanvas = canvas;
            mCanvas.mPalette = this;
            cgd_256.ColorIndex = 0;
            color = cgd_256.Color;
            colorEditor1.Color = Color.FromArgb(255, color);
            pnl_preColor.BackColor = color;
            cmb_library.SelectedIndex = 0;
            this.ConvertFromCmyk();
            InitPalette("d:\\standard.tpc");
        }

        private ColorChip AddColorList(ColorChip chip, Color color)
        {
            chip.r = color.R;
            chip.g = color.G;
            chip.b = color.B;

            chip.library = Library.STANDARD;
            chip.code = "";
            chip.ratio = 0.0f;
            chip.protect = false;

            return chip;
        }

        private void InsertColor()
        {
            cgd_256.CustomColors.Clear();
            mColorList.Clear();

            cgd_256.AddCustomColor(Color.Black);
            cgd_256.AddCustomColor(Color.White);

            LoadColorChip("D:\\basic.pcl");
            for (int i = 0; i < mColorList.Count; i++)
            {
                cgd_256.AddCustomColor(Color.FromArgb(mColorList[i].r, mColorList[i].g, mColorList[i].b));
            }

            cgd_256.CustomColors.RemoveAt(0);
            cgd_256.ColorIndex = 0;
        }

        private void LoadColorChip(string filename)
        {
            FileStream fs = new FileStream(filename, FileMode.Open);
            BinaryFormatter formatter = new BinaryFormatter();
            try
            {
                mColorList = (List<ColorChip>)formatter.Deserialize(fs);
            }
            catch
            {
                Console.WriteLine("fail");
                throw;
            }
            finally
            {
                fs.Close();
            }
        }
        private void SaveColorChip()
        {
            FileStream fs = new FileStream("D:\\basic.pcl", FileMode.Create);
            BinaryFormatter formatter = new BinaryFormatter();
            try
            {
                formatter.Serialize(fs, mColorList);
            }
            catch
            {
                Console.WriteLine("fail");
            }
            finally
            {
                fs.Close();
            }
        }

        private void InitPalette(String filename)
        {
            cgd_256.CustomColors = new ColorCollection();
            InsertColor();
        }

        private void Init()
        {
            pnl_color.Visible = false;
            pnl_search.Visible = false;
            pnl_protect.Visible = false;
            this.Height = pnl_palette.Height + 38;
            this.Width = pnl_palette.Width + 16;
        }

        private void Palette_Load(object sender, EventArgs e)
        {
            Init();

            Graphics gr;
            Brush br;
            Color black = Color.FromArgb(255, 0, 0, 0);
            Color cyan = Color.FromArgb(255, 0, 255, 255);
            Color magenta = Color.FromArgb(255, 255, 0, 255);
            Color yellow = Color.FromArgb(255, 255, 255, 0);
            Color white = Color.FromArgb(255, 255, 255, 255);

            pic_cyan.Image = new Bitmap(pic_cyan.Width, pic_cyan.Height);
            gr = Graphics.FromImage(pic_cyan.Image);
            br = new LinearGradientBrush(new Point(0, 0), new Point(pic_cyan.Width, pic_cyan.Height), white, cyan);
            gr.FillRectangle(br, new Rectangle(0, 0, pic_cyan.Width, pic_cyan.Height));

            pic_magenta.Image = new Bitmap(pic_magenta.Width, pic_magenta.Height);
            gr = Graphics.FromImage(pic_magenta.Image);
            br = new LinearGradientBrush(new Point(0, 0), new Point(pic_magenta.Width, pic_magenta.Height), white, magenta);
            gr.FillRectangle(br, new Rectangle(0, 0, pic_magenta.Width, pic_magenta.Height));

            pic_yellow.Image = new Bitmap(pic_yellow.Width, pic_yellow.Height);
            gr = Graphics.FromImage(pic_yellow.Image);
            br = new LinearGradientBrush(new Point(0, 0), new Point(pic_yellow.Width, pic_yellow.Height), white, yellow);
            gr.FillRectangle(br, new Rectangle(0, 0, pic_yellow.Width, pic_yellow.Height));

            pic_key.Image = new Bitmap(pic_key.Width, pic_key.Height);
            gr = Graphics.FromImage(pic_key.Image);
            br = new LinearGradientBrush(new Point(0, 0), new Point(pic_key.Width, pic_key.Height), white, black);
            gr.FillRectangle(br, new Rectangle(0, 0, pic_key.Width, pic_key.Height));

        }

        private void button1_Click(object sender, EventArgs e)
        {
            Init();
            pnl_color.Visible = true;
            pnl_color.Location = new Point(0, pnl_palette.Height);
            this.Height = pnl_palette.Height + pnl_color.Height + 38;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            Init();
            pnl_search.Visible = true;
            pnl_search.Location = new Point(0, pnl_palette.Height);
            this.Height = pnl_palette.Height + pnl_search.Height + 38;
        }

        private void button3_Click(object sender, EventArgs e)
        {
            Init();
            /* Set SaveFileDialog */
            SaveFileDialog saveFileDialog = new SaveFileDialog();
            saveFileDialog.Filter = "Palette File|*.tpc";
            saveFileDialog.Title = "Save Palette File";
            //saveFileDialog.ShowDialog();

            if (saveFileDialog.ShowDialog() == DialogResult.Cancel) return;
            FileStream fs = new FileStream(saveFileDialog.FileName, FileMode.Create);

            BinaryFormatter formatter = new BinaryFormatter();
            try
            {
                formatter.Serialize(fs, mColorList);

            }
            catch
            {
                Console.WriteLine("fail");
                throw;
            }
            finally
            {
                fs.Close();
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            Init();
            ColorChart colorChart = new ColorChart(mCanvas);
            colorChart.Show();
        }

        private void button5_Click(object sender, EventArgs e)
        {
            Init();
            pnl_protect.Visible = true;
            pnl_protect.Location = new Point(0, pnl_palette.Height);
            this.Height = pnl_palette.Height + pnl_protect.Height + 38;
        }

        private void button6_Click(object sender, EventArgs e)
        {
            //Init();
            cgd_256.CustomColors.Clear();
            mColorList.Clear();

            // Create a new bitmap.
            if (mCanvas.PictureBox1.Image == null) return;
            Bitmap bmp = new Bitmap(mCanvas.PictureBox1.Image);

            Rectangle rect = new Rectangle(0, 0, bmp.Width, bmp.Height);
            System.Drawing.Imaging.BitmapData bmpData =
                bmp.LockBits(rect, System.Drawing.Imaging.ImageLockMode.ReadWrite,
                bmp.PixelFormat);

            // Get the address of the first line.
            IntPtr ptr = bmpData.Scan0;

            // Declare an array to hold the bytes of the bitmap.
            int bytes = Math.Abs(bmpData.Stride) * bmp.Height;
            byte[] rgbValues = new byte[bytes];

            System.Runtime.InteropServices.Marshal.Copy(ptr, rgbValues, 0, bytes);

            int numBytes = 0;
            Color back = mCanvas.gBackColor;

            for (int y = 0; y < bmp.Height; y++)
            {
                for (int x = 0; x < bmp.Width; x++)
                {
                    numBytes = (y * (bmp.Width * 4)) + (x * 4);

                    byte blue = rgbValues[numBytes++];
                    byte green = rgbValues[numBytes++];
                    byte red = rgbValues[numBytes++];
                    byte alpha = rgbValues[numBytes];

                    ColorChip color = new ColorChip();
                    color.r = red;
                    color.g = green;
                    color.b = blue;
                    //color.index = ;
                    //color.library = ;
                    //Todo 추가 속성 넣어줘야 함 그래야 Contain 비교 가능

                    if (!mColorList.Contains(color) && Color.FromArgb(alpha, red, green, blue) != back)
                    {
                        mColorList.Add(color);
                    }
                }
            }

            for (int i = 0; i < mColorList.Count; i++)
            {
                cgd_256.AddCustomColor(Color.FromArgb(mColorList[i].r, mColorList[i].g, mColorList[i].b));
            }

            // Unlock the bits.
            bmp.UnlockBits(bmpData);
            lbl_color_num.Text = String.Format("{0}", mColorList.Count);
        }

        private void colorGrid1_ColorChanged(object sender, EventArgs e)
        {
            color = cgd_256.Color;

            if (MainMenu.mode == MainMode.FILL)
            {
                mCanvas.mFill.pnl_s_post.BackColor = color;
            }
            else if (MainMenu.mode == MainMode.COLOR)
            {
                if (mCanvas.mColorChange.rdo_single_target.Checked)
                {
                    mCanvas.mColorChange.pnl_single_target.BackColor = color;
                    if (mCanvas.mColorChange.rdo_workarea.Checked)
                        mCanvas.mColorChange.rdo_single_source.Checked = true;
                }
                else if (mCanvas.mColorChange.rdo_multi_target.Checked)
                {
                    mCanvas.mColorChange.pnl_multi_target.BackColor = color;
                    if (mCanvas.mColorChange.rdo_workarea.Checked)
                        mCanvas.mColorChange.rdo_multi_source.Checked = true;
                }

                mCanvas.penColor = new Scalar(color.B, color.G, color.R, color.A);
            }

            colorEditor1.Color = color;
            pnl_curColor.BackColor = color;
            pnl_preColor.BackColor = color;
            mCanvas.mPen.Refresh();
        }

        private void vsc_color_Scroll(object sender, ScrollEventArgs e)
        {
            cgd_256.Location = new Point(34, -(vsc_color.Value + 2));
        }

        private void colorEditor1_ColorChanged(object sender, EventArgs e)
        {
            //# To Do - 새로 구현
        }

        private void cTrackBar_ValueChanged(object sender, EventArgs e)
        {
            cNumericUpDown.Value = cTrackBar.Value;
            ctrl = 0;
        }

        private void mTrackBar_ValueChanged(object sender, EventArgs e)
        {
            mNumericUpDown.Value = mTrackBar.Value;
            ctrl = 1;
        }

        private void yTrackBar_ValueChanged(object sender, EventArgs e)
        {
            yNumericUpDown.Value = yTrackBar.Value;
            ctrl = 2;
        }

        private void kTrackBar_ValueChanged(object sender, EventArgs e)
        {
            kNumericUpDown.Value = kTrackBar.Value;
            ctrl = 3;
        }

        private void cNumericUpDown_ValueChanged(object sender, EventArgs e)
        {
            cTrackBar.Value = (int)cNumericUpDown.Value;
            this.ConvertFromCmyk();
        }

        private void mNumericUpDown_ValueChanged(object sender, EventArgs e)
        {
            mTrackBar.Value = (int)mNumericUpDown.Value;
            this.ConvertFromCmyk();
        }

        private void yNumericUpDown_ValueChanged(object sender, EventArgs e)
        {
            yTrackBar.Value = (int)yNumericUpDown.Value;
            this.ConvertFromCmyk();
        }

        private void kNumericUpDown_ValueChanged(object sender, EventArgs e)
        {
            kTrackBar.Value = (int)kNumericUpDown.Value;
            this.ConvertFromCmyk();
        }

        private void ConvertFromRgb()
        {
            int r;
            int g;
            int b;
            CmykColor converted;

            r = (int)colorEditor1.Color.R;
            g = (int)colorEditor1.Color.G;
            b = (int)colorEditor1.Color.B;

            pnl_curColor.BackColor = Color.FromArgb(r, g, b);

            converted = ColorConvert.ConvertRgbToCmyk(r, g, b);

            if (!updating)
            {
                updating = true;

                cNumericUpDown.Value = Convert.ToInt32(converted.C * 100);
                mNumericUpDown.Value = Convert.ToInt32(converted.M * 100);
                yNumericUpDown.Value = Convert.ToInt32(converted.Y * 100);
                kNumericUpDown.Value = Convert.ToInt32(converted.K * 100);

                updating = false;
            }
        }

        private void ConvertFromCmyk()
        {
            float c;
            float m;
            float y;
            float k;
            Color converted;

            c = (float)(cNumericUpDown.Value / 100);
            m = (float)(mNumericUpDown.Value / 100);
            y = (float)(yNumericUpDown.Value / 100);
            k = (float)(kNumericUpDown.Value / 100);

            converted = ColorConvert.ConvertCmykToRgb(c, m, y, k);

            pnl_curColor.BackColor = converted;

            if (!updating)
            {
                updating = true;
                colorEditor1.Color = Color.FromArgb(255, converted.R, converted.G, converted.B);
                updating = false;
            }

            Graphics gr;
            Brush br;

            Color black = Color.FromArgb(255, 0, 0, 0);
            Color cyan = Color.FromArgb(255, 0, converted.G, converted.B);
            Color magenta = Color.FromArgb(255, converted.R, 0, converted.B);
            Color yellow = Color.FromArgb(255, converted.R, converted.G, 0);
            Color cmy = Color.FromArgb(255, converted.R, converted.G, converted.B);

            if (ctrl != 0)
            {
                pic_cyan.Image = new Bitmap(pic_cyan.Width, pic_cyan.Height);
                gr = Graphics.FromImage(pic_cyan.Image);
                br = new LinearGradientBrush(new Point(0, 0), new Point(pic_cyan.Width, pic_cyan.Height), cmy, cyan);
                gr.FillRectangle(br, new Rectangle(0, 0, pic_cyan.Width, pic_cyan.Height));
            }

            if (ctrl != 1)
            {
                pic_magenta.Image = new Bitmap(pic_magenta.Width, pic_magenta.Height);
                gr = Graphics.FromImage(pic_magenta.Image);
                br = new LinearGradientBrush(new Point(0, 0), new Point(pic_magenta.Width, pic_magenta.Height), cmy, magenta);
                gr.FillRectangle(br, new Rectangle(0, 0, pic_magenta.Width, pic_magenta.Height));
            }

            if (ctrl != 2)
            {
                pic_yellow.Image = new Bitmap(pic_yellow.Width, pic_yellow.Height);
                gr = Graphics.FromImage(pic_yellow.Image);
                br = new LinearGradientBrush(new Point(0, 0), new Point(pic_yellow.Width, pic_yellow.Height), cmy, yellow);
                gr.FillRectangle(br, new Rectangle(0, 0, pic_yellow.Width, pic_yellow.Height));
            }

            if (ctrl != 3)
            {
                pic_key.Image = new Bitmap(pic_key.Width, pic_key.Height);
                gr = Graphics.FromImage(pic_key.Image);
                br = new LinearGradientBrush(new Point(0, 0), new Point(pic_key.Width, pic_key.Height), cmy, black);
                gr.FillRectangle(br, new Rectangle(0, 0, pic_key.Width, pic_key.Height));
            }

        }

        private void pnl_preColor_Click(object sender, EventArgs e)
        {
            pnl_curColor.BackColor = pnl_preColor.BackColor;
            colorEditor1.Color = pnl_preColor.BackColor;
        }

        private void btn_add_Click(object sender, EventArgs e)
        {
            //# 새로 구현
            /*
            int idx = cgd_256.ColorIndex;

            for (int i = 0; i < mCanvas.gSegmentList.Count; i++)
            {
                if (mCanvas.gSegmentList[i].sPen.Color == cgd_256.Color)
                {
                    mCanvas.gSegmentList[i].sPen.Color = pnl_curColor.BackColor;
                }

                if (((SolidBrush)mCanvas.gSegmentList[i].sBrush).Color == cgd_256.Color)
                {
                    ((SolidBrush)mCanvas.gSegmentList[i].sBrush).Color = pnl_curColor.BackColor;
                }
            }

            cgd_256.CustomColors.Insert(idx, pnl_curColor.BackColor);
            cgd_256.CustomColors.RemoveAt(idx + 1);
            cgd_256.ColorIndex = idx;

            ColorChip color = new ColorChip();
            color.r = pnl_curColor.BackColor.R;
            color.g = pnl_curColor.BackColor.G;
            color.b = pnl_curColor.BackColor.B;

            mColorList.Insert(idx, color);
            mColorList.RemoveAt(idx + 1);
            //gPalette.customColors.Insert(idx, pnl_curColor.BackColor);
            //gPalette.customColors.RemoveAt(idx + 1);
            mCanvas.Refresh();
            */
        }

        private void button7_Click(object sender, EventArgs e)
        {
            cgd_256.CustomColors = new ColorCollection();
            //gPalette = new CustomColor();
            mColorList = new List<ColorChip>();
            InsertColor();
        }

        private void pnl_back_Click(object sender, EventArgs e)
        {
        }

        int last_idx = 0;
        private void cgd_256_Click(object sender, EventArgs e)
        {
            pnl_palColor.BackColor = cgd_256.Color;
            Color c = cgd_256.Color;
            if ((c.R + c.G + c.B) / 3 < 128)
            {
                lbl_cur_idx.ForeColor = Color.White;
                lbl_color_num.ForeColor = Color.White;
            }
            else
            {
                lbl_cur_idx.ForeColor = Color.Black;
                lbl_color_num.ForeColor = Color.Black;
            }
            lbl_cur_idx.Text = String.Format("{0}", cgd_256.ColorIndex);
            if (last_idx < cgd_256.ColorIndex)
            {
                last_idx = cgd_256.ColorIndex;
                lbl_color_num.Text = String.Format("{0}", last_idx);
            }

            if (mCanvas.mDraw != null)
            {
                if (mCanvas.mDraw.shape == TShape.PATH)
                {
                    if (mCanvas.mPen.rdo_multi.Checked)
                    {
                        if (mCanvas.mPen.multiSpray.Count < 17)
                        {
                            if (!mCanvas.mPen.multiSpray.Contains(cgd_256.Color))
                                mCanvas.mPen.multiSpray.Add(cgd_256.Color);
                        }
                    }

                    mCanvas.mPen.pic_color.Refresh();
                }
            }
        }

        private void cgd_256_MouseMove(object sender, MouseEventArgs e)
        {
            if (cgd_256.HotIndex < 0) return;
            pnl_cursor.BackColor = cgd_256.GetColor(cgd_256.HotIndex);
            Color c = pnl_cursor.BackColor;

            if (MainMenu.mode == MainMode.COLOR)
            {
                if (mCanvas.mColorChange.rdo_single_target.Checked && mCanvas.mColorChange.cmb_area.SelectedIndex != 0)
                {
                    mCanvas.mColorChange.pnl_single_target.BackColor = cgd_256.GetColor(cgd_256.HotIndex);
                }
                else if (mCanvas.mColorChange.rdo_multi_target.Checked && mCanvas.mColorChange.cmb_area.SelectedIndex == 2)
                {
                    mCanvas.mColorChange.pnl_multi_target.BackColor = cgd_256.GetColor(cgd_256.HotIndex);
                }
            }

            if ((c.R + c.G + c.B) / 3 < 128)
            {
                lbl_cursor_idx.ForeColor = Color.White;
            }
            else
            {
                lbl_cursor_idx.ForeColor = Color.Black;
            }
            lbl_cursor_idx.Text = String.Format("{0}", cgd_256.HotIndex);
        }

        private void cgd_256_ColorIndexChanged(object sender, EventArgs e)
        {
            switch (MainMenu.mode)
            {
                case MainMode.GRADIENT:
                    mCanvas.mGradient.AddColor(color);
                    break;
                case MainMode.COLORWAY:
                    MultiColor multi = new MultiColor();
                    Panel panel = new Panel();
                    panel.Click += multi.PanelClick;
                    panel.Width = 17;
                    panel.Height = 17;
                    panel.BackColor = color;
                    panel.BorderStyle = BorderStyle.FixedSingle;
                    mCanvas.mColorWay.pnl_color.Controls.Add(panel);
                    break;
                case MainMode.STIPPLE:
                    mCanvas.mStipple.pnl_colorchip.BackColor = color;
                    break;
                case MainMode.SHADOW:
                    mCanvas.mShadow.pnl_color.BackColor = cgd_256.Color;
                    mCanvas.mShadow.sScalar = new Scalar(cgd_256.Color.B, cgd_256.Color.G, cgd_256.Color.R, cgd_256.Color.A);
                    mCanvas.mShadow.shadow.SetTo(mCanvas.mShadow.sScalar, mCanvas.mShadow.sMask);
                    mCanvas.mShadow.SetShadowImage();
                    break;
            }
        }

        private void btn_colorGuide_Click(object sender, EventArgs e)
        {
            ColorLibrary library = new ColorLibrary(mCanvas);
            library.Show();
        }

        private void btn_read_Click(object sender, EventArgs e)
        {
            //gPalette.customColors.Clear();
            mColorList.Clear();
            //CustomColor colorInfo = new CustomColor();
            OpenFileDialog fileDialog = new OpenFileDialog();
            fileDialog.Filter = "Palette File|*.tpc";
            //fileDialog.ShowDialog();

            if (fileDialog.ShowDialog() == DialogResult.Cancel) return;
            FileStream fs = new FileStream(fileDialog.FileName, FileMode.Open);
            BinaryFormatter formatter = new BinaryFormatter();

            try
            {
                //gPalette.customColors = (List<Color>)formatter.Deserialize(fs);
                mColorList = (List<ColorChip>)formatter.Deserialize(fs);
            }
            catch
            {
                Console.WriteLine("fail");
                throw;
            }
            finally
            {
                fs.Close();
            }

            cgd_256.CustomColors.Clear();
            for (int i = 0; i < mColorList.Count; i++)
            {
                cgd_256.CustomColors.Add(Color.FromArgb(mColorList[i].r, mColorList[i].g, mColorList[i].b));
            }

            cgd_256.CustomColors.RemoveAt(0);
            cgd_256.ColorIndex = 0;

        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            //pnl_curColor.BackColor = mCanvas.pixelColor;
        }

        private void btn_displayLib_Click(object sender, EventArgs e)
        {
            DTPColorLibrary library = new DTPColorLibrary(this);
            library.Show();
        }
    }

}
