﻿using System;
using System.Drawing;
using System.Windows.Forms;

namespace TexMaster
{
    public partial class Ruler : Form
    {
        int dpi;

        public Ruler()
        {
            InitializeComponent();
            dpi = DeviceDpi;
            numericUpDown1.Value = dpi;
        }

        private void radioButton1_CheckedChanged(object sender, EventArgs e)
        {
            panel1.Refresh();
        }

        private void radioButton2_CheckedChanged(object sender, EventArgs e)
        {
            panel1.Refresh();
        }

        private void radioButton3_CheckedChanged(object sender, EventArgs e)
        {
            panel1.Refresh();
        }

        private void panel1_Paint(object sender, PaintEventArgs e)
        {
            float unit = 0;

            label2.Text = dpi.ToString();

            label3.Text = String.Format("1px = 2.54cm * {0}", dpi);
            label4.Text = String.Format("1cm = {0} / 2.54cm", dpi);
            label5.Text = String.Format("1inch = 2.54cm");

            if (radioButton1.Checked)
            {
                unit = 100.0F;
            }
            else if (radioButton2.Checked)
            {
                unit = dpi / 2.54F;
            }
            else if (radioButton3.Checked)
            {
                unit = dpi;
            }

            for (int i = 1; i < panel1.Width-1; i++)
            {
                e.Graphics.DrawLine(new Pen(Color.Black), new PointF(i * unit / 10, 22), new PointF(i * unit / 10, panel1.Height));
                e.Graphics.DrawLine(new Pen(Color.Black), new PointF(i * unit / 2, 15), new PointF(i * unit / 2, panel1.Height));
                e.Graphics.DrawLine(new Pen(Color.Black), new PointF(i * unit, 0), new PointF(i * unit, panel1.Height));
                e.Graphics.DrawString(String.Format("{0, 0:N2}", i), new Font("굴림", 8), new SolidBrush(Color.Black), new PointF(i * unit, 1));
            }
        }

        private void numericUpDown1_ValueChanged(object sender, EventArgs e)
        {
            dpi = (int)numericUpDown1.Value;
            panel1.Refresh();

        }
    }
}
