/*
 * Decompiled with CFR 0.152.
 */
package com.secondfury.nativetoolkit;

import android.app.AlarmManager;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.RingtoneManager;
import android.net.Uri;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import com.secondfury.nativetoolkit.LocalNotificationResult;
import java.util.Calendar;

public class LocalNotification
extends BroadcastReceiver {
    Context context;

    public void onReceive(Context context, Intent paramIntent) {
        this.context = context;
        int id = paramIntent.getIntExtra("id", 0);
        String title = paramIntent.getStringExtra("title");
        String message = paramIntent.getStringExtra("message");
        String smallIcon = paramIntent.getStringExtra("smallIcon");
        String largeIcon = paramIntent.getStringExtra("largeIcon");
        String sound = paramIntent.getStringExtra("sound");
        boolean vibrate = paramIntent.getBooleanExtra("vibrate", false);
        Log.w((String)"Native Toolkit", (String)("Create local notification: " + title));
        String packageName = context.getPackageName();
        int smallIconId = context.getResources().getIdentifier(smallIcon, "drawable", packageName);
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(this.context).setSmallIcon(smallIconId).setContentTitle((CharSequence)title).setContentText((CharSequence)message).setAutoCancel(true);
        if (largeIcon != "") {
            int largeIconId = context.getResources().getIdentifier(largeIcon, "drawable", packageName);
            Bitmap bmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)largeIconId);
            mBuilder.setLargeIcon(bmap);
        }
        if (sound == "default_sound") {
            Uri soundUri = RingtoneManager.getDefaultUri((int)2);
            mBuilder.setSound(soundUri);
        } else if (sound != "") {
            Uri soundUri = Uri.parse((String)("android.resource://" + packageName + "/raw/" + sound));
            mBuilder.setSound(soundUri);
        }
        if (vibrate) {
            long[] lArray = new long[2];
            lArray[1] = 1000L;
            mBuilder.setVibrate(lArray);
        }
        if (message.length() > 40) {
            mBuilder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)message));
        }
        Intent resultIntent = new Intent(context, LocalNotificationResult.class);
        resultIntent.putExtra("fromNotification", true);
        PendingIntent resultPendingIntent = PendingIntent.getActivity((Context)context, (int)id, (Intent)resultIntent, (int)0x8000000);
        mBuilder.setContentIntent(resultPendingIntent);
        NotificationManager mNotifyMgr = (NotificationManager)context.getSystemService("notification");
        mNotifyMgr.notify(id, mBuilder.build());
    }

    public void scheduleLocalNotification(Context context, int id, String title, String message, int delay, String sound, boolean vibrate, String smallIcon, String largeIcon) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.add(12, delay);
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        Intent intent = new Intent(context, LocalNotification.class);
        intent.putExtra("id", id);
        intent.putExtra("title", title);
        intent.putExtra("message", message);
        intent.putExtra("smallIcon", smallIcon);
        intent.putExtra("largeIcon", largeIcon);
        intent.putExtra("sound", sound);
        intent.putExtra("vibrate", vibrate);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)id, (Intent)intent, (int)0x8000000);
        alarmManager.set(1, calendar.getTimeInMillis(), pendingIntent);
        SharedPreferences prefs = context.getSharedPreferences("notifications", 0);
        String pendingNotifications = prefs.getString("pending", "");
        SharedPreferences.Editor edit = prefs.edit();
        pendingNotifications = pendingNotifications == "" ? Integer.toString(id) : String.valueOf(pendingNotifications) + "," + Integer.toString(id);
        edit.putString("pending", pendingNotifications);
        edit.commit();
    }

    public void clearLocalNotification(Context context, int id) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.cancel(id);
        Intent alarmIntent = new Intent(context, LocalNotification.class);
        if (PendingIntent.getBroadcast((Context)context, (int)id, (Intent)alarmIntent, (int)0x8000000) != null) {
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)id, (Intent)alarmIntent, (int)0x8000000);
            AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
            alarmManager.cancel(pendingIntent);
        }
    }

    public void clearAllLocalNotifications(Context context) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.cancelAll();
        SharedPreferences prefs = context.getSharedPreferences("notifications", 0);
        String pendingNotifications = prefs.getString("pending", "");
        if (pendingNotifications == "") {
            return;
        }
        String[] notifications = pendingNotifications.split(",");
        Intent alarmIntent = new Intent(context, LocalNotification.class);
        int i = 0;
        while (i < notifications.length) {
            int id = Integer.parseInt(notifications[i]);
            if (PendingIntent.getBroadcast((Context)context, (int)id, (Intent)alarmIntent, (int)0x8000000) != null) {
                Log.w((String)"Native Toolkit", (String)("Clear local notification id #" + id));
                PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)id, (Intent)alarmIntent, (int)0x8000000);
                AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
                alarmManager.cancel(pendingIntent);
            }
            ++i;
        }
        SharedPreferences.Editor edit = prefs.edit();
        edit.putString("pending", "");
        edit.commit();
    }
}

