/*
 * Decompiled with CFR 0.152.
 */
package com.secondfury.nativetoolkit;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.secondfury.nativetoolkit.Dialog;
import com.secondfury.nativetoolkit.Email;
import com.secondfury.nativetoolkit.Image;
import com.secondfury.nativetoolkit.LocalNotification;
import com.secondfury.nativetoolkit.MainActivity;
import com.unity3d.player.UnityPlayer;
import com.unity3d.player.UnityPlayerNativeActivity;
import java.util.Locale;

public class Main
extends UnityPlayerNativeActivity {
    public static int addImageToGallery(String path) {
        Log.w((String)"Native Toolkit", (String)"Add image to gallery");
        Image image = new Image();
        return image.Save(path);
    }

    public static void pickImageFromGallery() {
        Log.w((String)"Native Toolkit", (String)"Select image from gallery");
        Intent intent = new Intent((Context)Main.getUnityActivity(), MainActivity.class);
        intent.putExtra("action", 0);
        Main.getUnityActivity().startActivity(intent);
    }

    public static void takeCameraShot() {
        Log.w((String)"Native Toolkit", (String)"Open camera");
        Intent intent = new Intent((Context)Main.getUnityActivity(), MainActivity.class);
        intent.putExtra("action", 1);
        Main.getUnityActivity().startActivity(intent);
    }

    public static void pickContact() {
        Log.w((String)"Native Toolkit", (String)"Pick contact");
        Intent intent = new Intent((Context)Main.getUnityActivity(), MainActivity.class);
        intent.putExtra("action", 2);
        Main.getUnityActivity().startActivity(intent);
    }

    public static void sendEmail(String to, String cc, String bcc, String subject, String message, String filePath) {
        Log.w((String)"Native Toolkit", (String)"Send Email with attachment");
        new Email(Main.getUnityActivity(), to, cc, bcc, subject, message, filePath);
    }

    public static void showConfirm(final String title, final String message, final String pos, final String neg) {
        Log.w((String)"Native Toolkit", (String)"Show dialog");
        Main.getUnityActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Dialog dialog = new Dialog(Main.getUnityActivity());
                dialog.CreateConfirm(title, message, pos, neg);
            }
        });
    }

    public static void showAlert(final String title, final String message, final String pos) {
        Log.w((String)"Native Toolkit", (String)"Show alert");
        Main.getUnityActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Dialog dialog = new Dialog(Main.getUnityActivity());
                dialog.CreateAlert(title, message, pos);
            }
        });
    }

    public static void rateThisApp(final String title, final String message, final String pos, final String neutral, final String neg) {
        Log.w((String)"Native Toolkit", (String)"Rate this App");
        Main.getUnityActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Dialog dialog = new Dialog(Main.getUnityActivity());
                dialog.CreateRate(title, message, pos, neutral, neg);
            }
        });
    }

    public static String getLocale() {
        Log.w((String)"Native Toolkit", (String)"Get Locale");
        try {
            TelephonyManager tm = (TelephonyManager)Main.getUnityActivity().getSystemService("phone");
            String simCountry = tm.getSimCountryIso();
            if (simCountry != null && simCountry.length() == 2) {
                return simCountry;
            }
        }
        catch (Exception tm) {
            // empty catch block
        }
        Locale locale = Locale.getDefault();
        return locale.getCountry();
    }

    public static void scheduleLocalNotification(String title, String message, int id, int delay, String sound, boolean vibrate, String smallIcon, String largeIcon) {
        Log.w((String)"Native Toolkit", (String)("Schedule local notification: " + title));
        LocalNotification ln = new LocalNotification();
        ln.scheduleLocalNotification((Context)Main.getUnityActivity(), id, title, message, delay, sound, vibrate, smallIcon, largeIcon);
    }

    public static void clearLocalNotification(int id) {
        Log.w((String)"Native Toolkit", (String)("Clear local notification id #" + Integer.toString(id)));
        LocalNotification ln = new LocalNotification();
        ln.clearLocalNotification((Context)Main.getUnityActivity(), id);
    }

    public static void clearAllLocalNotifications() {
        Log.w((String)"Native Toolkit", (String)"Clear all local notifications");
        LocalNotification ln = new LocalNotification();
        ln.clearAllLocalNotifications((Context)Main.getUnityActivity());
    }

    public static boolean wasLaunchedFromNotification() {
        boolean fromNotification = Main.getUnityActivity().getIntent().getBooleanExtra("fromNotification", false);
        Log.w((String)"Native Toolkit", (String)("Launched from notification : " + fromNotification));
        return fromNotification;
    }

    public static Activity getUnityActivity() {
        return UnityPlayer.currentActivity;
    }
}

