/*
 * Decompiled with CFR 0.152.
 */
package com.secondfury.nativetoolkit;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.ContactsContract;
import android.util.Log;
import com.secondfury.nativetoolkit.FileUtils;
import com.secondfury.nativetoolkit.Image;
import com.unity3d.player.UnityPlayer;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.json.JSONObject;

public class MainActivity
extends Activity {
    private static int PICK_IMAGE = 0;
    private static int CAPTURE_PHOTO = 1;
    private static int PICK_CONTACT = 2;
    private Uri imageUri;
    public static final int MEDIA_TYPE_IMAGE = 1;
    public static final int MEDIA_TYPE_VIDEO = 2;

    protected void onCreate(Bundle b) {
        super.onCreate(b);
        Bundle bundle = this.getIntent().getExtras();
        int action = bundle.getInt("action");
        switch (action) {
            case 0: {
                Intent getContentIntent = FileUtils.createGetContentIntent("image/*");
                Intent photoPickerIntent = Intent.createChooser((Intent)getContentIntent, (CharSequence)"Select an image");
                this.startActivityForResult(photoPickerIntent, PICK_IMAGE);
                break;
            }
            case 1: {
                this.imageUri = MainActivity.getOutputMediaFileUri(1);
                Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
                cameraIntent.putExtra("output", (Parcelable)this.imageUri);
                this.startActivityForResult(cameraIntent, CAPTURE_PHOTO);
                break;
            }
            case 2: {
                Intent pickContactIntent = new Intent("android.intent.action.PICK", ContactsContract.Contacts.CONTENT_URI);
                pickContactIntent.setType("vnd.android.cursor.dir/phone_v2");
                this.startActivityForResult(pickContactIntent, PICK_CONTACT);
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode != -1) {
            if (requestCode == PICK_IMAGE) {
                UnityPlayer.UnitySendMessage((String)"NativeToolkit", (String)"OnPickImage", (String)"Cancelled");
            } else if (requestCode == CAPTURE_PHOTO) {
                UnityPlayer.UnitySendMessage((String)"NativeToolkit", (String)"OnCameraFinished", (String)"Cancelled");
            } else if (requestCode == PICK_CONTACT) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("cancelled", "true");
                String jsonString = new JSONObject(map).toString();
                UnityPlayer.UnitySendMessage((String)"NativeToolkit", (String)"OnPickContactFinished", (String)jsonString);
            }
            this.finish();
            return;
        }
        if (requestCode == PICK_IMAGE) {
            if (data != null) {
                this.imageUri = data.getData();
                String imagePath = FileUtils.getPath((Context)this, this.imageUri);
                Log.w((String)"Native Toolkit", (String)("Image picked at location : " + imagePath));
                UnityPlayer.UnitySendMessage((String)"NativeToolkit", (String)"OnPickImage", (String)imagePath);
            }
        } else if (requestCode == CAPTURE_PHOTO) {
            String imagePath = this.imageUri.getPath();
            Image image = new Image();
            image.Save(imagePath);
            Log.w((String)"Native Toolkit", (String)("Camera shot saved to location : " + imagePath));
            UnityPlayer.UnitySendMessage((String)"NativeToolkit", (String)"OnCameraFinished", (String)imagePath);
        } else if (requestCode == PICK_CONTACT && data != null) {
            Uri dataUri = data.getData();
            HashMap<String, String> map = new HashMap<String, String>();
            String[] projection = new String[]{"contact_id", "display_name", "data1"};
            Cursor cursor = this.getContentResolver().query(dataUri, projection, null, null, null);
            if (cursor.moveToFirst()) {
                String name = cursor.getString(cursor.getColumnIndex("display_name"));
                map.put("name", name);
                String number = cursor.getString(cursor.getColumnIndex("data1"));
                map.put("number", number);
            }
            String id = cursor.getString(cursor.getColumnIndex("contact_id"));
            cursor.close();
            Cursor emailCursor = this.getContentResolver().query(ContactsContract.CommonDataKinds.Email.CONTENT_URI, null, "contact_id=" + Integer.parseInt(id), null, null);
            if (emailCursor.moveToFirst()) {
                String email = emailCursor.getString(emailCursor.getColumnIndex("data1"));
                map.put("email", email);
            }
            emailCursor.close();
            String jsonString = new JSONObject(map).toString();
            UnityPlayer.UnitySendMessage((String)"NativeToolkit", (String)"OnPickContactFinished", (String)jsonString);
        }
        this.finish();
    }

    private static Uri getOutputMediaFileUri(int type) {
        return Uri.fromFile((File)MainActivity.getOutputMediaFile(type));
    }

    private static File getOutputMediaFile(int type) {
        File mediaFile;
        File mediaStorageDir = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), "Camera");
        if (!mediaStorageDir.exists() && !mediaStorageDir.mkdirs()) {
            Log.d((String)"Native Toolkit", (String)"Failed to create directory");
            return null;
        }
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault()).format(new Date());
        if (type == 1) {
            mediaFile = new File(String.valueOf(mediaStorageDir.getPath()) + File.separator + "IMG_" + timeStamp + ".jpg");
        } else if (type == 2) {
            mediaFile = new File(String.valueOf(mediaStorageDir.getPath()) + File.separator + "VID_" + timeStamp + ".mp4");
        } else {
            return null;
        }
        return mediaFile;
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.imageUri != null) {
            outState.putString("imageUri", this.imageUri.toString());
        }
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        if (savedInstanceState.containsKey("imageUri")) {
            this.imageUri = Uri.parse((String)savedInstanceState.getString("imageUri"));
        }
    }
}

