#include <xdc/std.h>

#include <xdc/runtime/Error.h>
#include <xdc/runtime/System.h>

#include <ti/sysbios/BIOS.h>

#include <ti/sysbios/knl/Task.h>



#include <cslr_bootcfg.h>

#include "platform.h"
#include "platform_internal.h"

#include <evmc66x_gpio.h>

#include "gpio.h"



#define KICK0 *(unsigned int*)(0x02620038)
#define KICK1 *(unsigned int*)(0x0262003C)
#define KICK0_UNLOCK (0x83E70B13)
#define KICK1_UNLOCK (0x95A4F1E0)

CSL_GpioHandle		myhGpio=NULL;


void gpio_Dir(uint32_t uiNumber, GpioDirection direction);
void gpio_Output(uint32_t uiNumber, uint8_t Data);


void gpio_Init(void)
{
	int32_t		pinNum;


	// Open the CSL GPIO Module 0
	if(myhGpio == NULL) myhGpio	= CSL_GPIO_open (0);


	for (pinNum = GPIO_0; pinNum <= GPIO_15; pinNum++)
	{
        CSL_GPIO_clearFallingEdgeDetect(myhGpio, pinNum);
        CSL_GPIO_clearRisingEdgeDetect(myhGpio, pinNum);
    }

	gpio_Dir(GPIO_0, GPIO_OUT);//GPIO_IN or GPIO_OUT
	gpio_Output(GPIO_0, HIGH);
	gpio_Dir(GPIO_1, GPIO_OUT);//GPIO_IN or GPIO_OUT
	gpio_Output(GPIO_1, HIGH);
	gpio_Dir(GPIO_2, GPIO_OUT);//GPIO_IN or GPIO_OUT
	gpio_Output(GPIO_2, HIGH);
	gpio_Dir(GPIO_3, GPIO_OUT);//GPIO_IN or GPIO_OUT
	gpio_Output(GPIO_3, HIGH);
	gpio_Dir(GPIO_4, GPIO_OUT);//GPIO_IN or GPIO_OUT
	gpio_Output(GPIO_4, HIGH);
	gpio_Dir(GPIO_5, GPIO_OUT);//GPIO_IN or GPIO_OUT
	gpio_Output(GPIO_5, HIGH);
	gpio_Dir(GPIO_6, GPIO_OUT);//GPIO_IN or GPIO_OUT
	gpio_Output(GPIO_6, HIGH);
	gpio_Dir(GPIO_7, GPIO_OUT);//GPIO_IN or GPIO_OUT
	gpio_Output(GPIO_7, HIGH);
	gpio_Dir(GPIO_8, GPIO_OUT);//GPIO_IN or GPIO_OUT
	gpio_Output(GPIO_8, HIGH);
	gpio_Dir(GPIO_9, GPIO_OUT);//GPIO_IN or GPIO_OUT
	gpio_Output(GPIO_9, HIGH);

	gpio_Dir(GPIO_10, GPIO_OUT);//GPIO_IN or GPIO_OUT
	gpio_Output(GPIO_10, HIGH);
	gpio_Dir(GPIO_11, GPIO_OUT);//GPIO_IN or GPIO_OUT
	gpio_Output(GPIO_11, HIGH);
	gpio_Dir(GPIO_12, GPIO_OUT);//GPIO_IN or GPIO_OUT
	gpio_Output(GPIO_12, HIGH);
	gpio_Dir(GPIO_13, GPIO_OUT);//GPIO_IN or GPIO_OUT
	gpio_Output(GPIO_13, HIGH);
	gpio_Dir(GPIO_14, GPIO_OUT);//GPIO_IN or GPIO_OUT
	gpio_Output(GPIO_14, HIGH);
	gpio_Dir(GPIO_15, GPIO_OUT);//GPIO_IN or GPIO_OUT
	gpio_Output(GPIO_15, HIGH);
}

void gpio_Dir(uint32_t uiNumber, GpioDirection direction)
{
	if (direction == GPIO_OUT)		CSL_GPIO_setPinDirOutput(myhGpio, uiNumber); // Set to OUTPUT
	else							CSL_GPIO_setPinDirInput (myhGpio, uiNumber); // Set to INPUT
}

void gpio_Output(uint32_t uiNumber, uint8_t Data)
{
	if ( Data == 0 )	CSL_GPIO_clearOutputData(myhGpio, uiNumber);
	else				CSL_GPIO_setOutputData(myhGpio, uiNumber);
}

void gpio_SetRisingEdgeInt(uint32_t uiNumber)
{
	CSL_GPIO_setRisingEdgeDetect(myhGpio, uiNumber); //GPIOREGS->SET_RIS_TRIG |= (1 << uiNumber);
}

void gpio_SetFallingEdgeInt(uint32_t uiNumber)
{
	CSL_GPIO_setFallingEdgeDetect(myhGpio, uiNumber); //GPIOREGS->SET_FAL_TRIG |= (1 << uiNumber);
}

void gpio_EnGlbInt(uint32_t bank)
{
	if 		(bank == 0)		CSL_GPIO_bankInterruptDisable(myhGpio, 0); //GPIOREGS->BINTEN |= 0x01;
	else if (bank == 1)		CSL_GPIO_bankInterruptEnable(myhGpio, 0); //GPIOREGS->BINTEN |= 0x01;

}


void gpio_test()
{
	int i;


#if IPB01_R01
	for(i = 14; i <= 15; i ++)
	{
		gpio_Output(i, 0);
		Task_sleep(200);
		gpio_Output(i, 1);
		Task_sleep(200);
	}
#endif

#if TPB01_R01
	for(i = 14; i <= 15; i ++)
	{
		gpio_Output(i, 0);
		Task_sleep(200);
		gpio_Output(i, 1);
		Task_sleep(200);
	}
#endif


}






