#ifndef __SRIO_DEVICE_H__
#define __SRIO_DEVICE_H__

#include <ti/drv/srio/srio_drv.h>
#include <ti/drv/srio/srio_types.h>

/* Application Include Files */
#include "srio_config.h"

#define GARBAGE_LEN_QUEUE		    905
#define GARBAGE_TOUT_QUEUE		    906
#define GARBAGE_RETRY_QUEUE		    907
#define GARBAGE_TRANS_ERR_QUEUE	    908
#define GARBAGE_PROG_QUEUE		    909
#define GARBAGE_SSIZE_QUEUE		    910

#define DEVICE_VENDOR_ID            0x30
#define DEVICE_REVISION             0x0

/* SRIO Assembly Information
 * - Assembly Identifier
 * - Assembly Vendor Identifier.
 * - Assembly Device Revision.
 * - Assembly Extension Features */
#define DEVICE_ASSEMBLY_ID          0x0
#define DEVICE_ASSEMBLY_VENDOR_ID   0x30
#define DEVICE_ASSEMBLY_REVISION    0x0
#define DEVICE_ASSEMBLY_INFO        0x0100

/* This is the Number of host descriptors which are available & configured
 * in the memory region for this test. */
#define NUM_HOST_DESC                                  128

/* This is the size of each descriptor. */
#define SIZE_HOST_DESC                                 64

/* This is the number of RX descriptors to use */
#define NUM_RX_DESC                                    32
#define NUM_RX_DESC_ON_TX_SIDE                         1

/* This is the number of TX descriptors to use */
#define NUM_TX_DESC                                    32
#define NUM_TX_DESC_ON_RX_SIDE                         1

/* Round trip or one way designators for
 * latency statistics */
#define ROUND_TRIP_TIME                                TRUE
#define ONE_WAY_TIME                                   FALSE

/* Maximum attempts to try in order to find
 * a good pacing value before terminating */
#define MAX_TX_FAIL_ATTEMPTS                           100

/* Minimum number of packets to send in order
 * to correctly calculate the number of packets
 * to use for a given amount of seconds. */
#define MIN_NUM_PACKETS_TO_SEND                        2	//200000

/* Our software header byte count for Type-11.
 * This will be part of the payload. */
#define SOFTWARE_HEADER_BYTES                          12

/* Bytes of overhead for specific packet types */
#define TYPE_11_MESSAGE_OVERHEAD_BYTES_PER_256B        24
#define DIO_NWRITE_OVERHEAD_BYTES_PER_256B             16
#define DIO_NWRITER_OVERHEAD_BYTES_PER_256B            28
#define DIO_NREAD_OVERHEAD_BYTES_PER_256B              28

#define MAX_MSG_LEN 128

typedef int bool;

typedef struct {
	srioLaneRateGbps_e	srio_laneSpeedGbps;
	srioLanesMode_e		srio_lanesMode;
	srioTestsToRun_e	srio_testsToRun;
	uint32_t			srio_testTimeInSeconds;
	int32_t				srio_initCorenum;
	bool				srio_isBoardToBoard;
	bool				srio_isExternalSrioSwitch;
	bool				srio_isLoopbackMode;
	bool				srio_isDeviceID16Bit;
	bool				srio_isLatencyTest;
	bool				srio_isRunProgress;
	int32_t				srio_payloadSize;
	int32_t				srio_payloadEndSize;
	int32_t				srio_dioPayloadSize;
	int32_t				srio_dioPayloadEndSize;
} struct_srio_control;


int32_t SrioDevice_init (void);
void myDIOIsr(UArg argument);
int32_t setEnableSrioPllRxTx (CSL_SrioHandle hSrio, srioRefClockMhz_e refClockMhz, srioLaneRateGbps_e linkRateGbps, int isLoopbackMode);
Srio_SockHandle createMgmtSocket(void);
int32_t displaySrioLanesStatus (CSL_SrioHandle hSrio);
int32_t getPllValue (srioRefClockMhz_e refClockMhz, srioLaneRateGbps_e linkRateGbps);
uint32_t l2_global_address (uint32_t addr);
uint32_t l2_global_address_for_core (uint32_t addr, uint32_t coreNum);
uint32_t getIterationCountUsingSeconds (uint64_t tsLoopStart, uint64_t tsLoopEnd, uint32_t timeInSeconds);
void clearSrioStatsOutputBuffer (void);
int32_t setSrioLanes (CSL_SrioHandle hSrio, srioLanesMode_e laneMode);
int32_t waitAllSrioPortsOperational (CSL_SrioHandle hSrio, srioLanesMode_e laneMode);
#endif /* __SRIO_TPUT_H__ */
