#include <xdc/runtime/System.h>
#include <xdc/runtime/Memory.h>

/* CSL Chip Functional Layer */
#include <ti/csl/csl_chip.h>

/* SRIO Driver Include File. */
#include <ti/drv/srio/srio_drv.h>

/* Application Include File */
#include "srio_config.h"
#include "srio_device.h"
#include "srio_slave.h"
#include "srio_osal.h"
#include "com.h"
#include "common.h"
#include "data_indicator.h"
/* Time stamp includes */
#include <ti/csl/csl_tsc.h>

#include "gpio.h"

Srio_SockHandle         controlSocket;

extern struct_srio_control testControl;
extern Srio_SockHandle     mgmtSocket;
extern Srio_DrvHandle      hAppManagedSrioDrv;

extern uint32_t srio_iterationCount;
extern uint64_t srio_numDioPackets;
extern uint64_t srio_latencyNumPackets;
extern uint32_t srio_iterationCount;
extern uint64_t srio_numDioPackets;


int gGpioLedFlag = 0;

void Srio_Slave_init()
{
	srio_open();

}
void srio_open()
{

	Srio_SockBindAddrInfo   bindInfo;

	 controlSocket = Srio_sockOpen (hAppManagedSrioDrv, Srio_SocketType_DIO, FALSE);
	 if (controlSocket == NULL)
	 {
		 System_printf ("Error: DIO Control Socket open failed\n");
		 return ;
	 }

	 /* DIO Binding Information: */
	 bindInfo.dio.doorbellValid  = 0;
	 bindInfo.dio.intrRequest    = 0;
	 bindInfo.dio.supInt         = 0;
	 bindInfo.dio.xambs          = 0;
	 bindInfo.dio.priority       = 0;
	 bindInfo.dio.outPortID      = SRIO_PORT_NUM0 + gSrioPort;
	 bindInfo.dio.idSize         = 0;
	 bindInfo.dio.srcIDMap       = 0;
	 bindInfo.dio.hopCount       = 0;
	 bindInfo.dio.doorbellReg    = 0;
	 bindInfo.dio.doorbellBit    = 0;

	/* Bind the DIO socket. */
	if (Srio_sockBind (controlSocket, &bindInfo) < 0)
	{
		System_printf ("Error: Binding the DIO Control Socket failed.\n");
		return ;
	}
}

void srio_cloes()
{
	 Srio_sockClose (controlSocket);
}
