#include "environment.h"
#include "hardware.h"
#include "processing.h"
unsigned short BoardID;
volatile unsigned int Board1MSTimer;

TCPBSystemSetupData CPBSystemSetupData;
#pragma DATA_ALIGN(CPBCompatibility, 8);
TCPBCompatibility CPBCompatibility;

void EnvironmentInit()
{
	BoardID = CPBInfo.BoardID;
	CPBSystemSetupData.bCameraConnection = 0;
	CPBSystemSetupData.SDRSizeType = 0;
	CPBSystemSetupData.SuctionDiskNumber = 0;
	CPBSystemSetupData.spbBoardID = 0;  
	
	CPBCompatibility.AlgMajorVersion = PROGRAM_MAJOR_VERSION;
	CPBCompatibility.AlgMinorVersion = PROGRAM_MINOR_VERSION;
	CPBCompatibility.AlgTargetSystem = PROGRAM_TARGET_SYSTEM;
	CPBCompatibility.AlgReleaseDate = PROGRAM_RELEASE_DATE;
}


void Sleep(int miliSeconds)
{
	unsigned int st;
	st = Board1MSTimer;
	while(1)
	{
		if (Board1MSTimer - st > miliSeconds)
		{
			break;
		}
	} 	
}

